/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CNumberAccessor extends NumberAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  35 */   boolean underlyingLongRaw = false;
/*     */ 
/* 305 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CNumberAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  41 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  43 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CNumberAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  52 */     super(paramOracleStatement, paramInt1 == -1 ? paramInt8 : paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  55 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  58 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  60 */       this.definedColumnType = 0;
/*  61 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  65 */       this.definedColumnType = paramInt7;
/*  66 */       this.definedColumnSize = paramInt8;
/*     */     }
/*     */ 
/*  69 */     if (paramInt1 == -1)
/*  70 */       this.underlyingLongRaw = true;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  74 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  83 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  86 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  93 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 100 */       this.mare.unmarshalUB2();
/* 101 */       this.mare.unmarshalUB2();
/*     */     }
/* 103 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 107 */       this.mare.unmarshalSB2();
/*     */ 
/* 109 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 110 */         this.mare.unmarshalSB2();
/*     */     }
/* 112 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 113 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 119 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 120 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 135 */     boolean bool = false;
/* 136 */     if (!isUseless())
/*     */     {
/* 142 */       if (isUnexpected())
/*     */       {
/* 145 */         long l = this.rowData.getPosition();
/* 146 */         unmarshalColumnMetadata();
/* 147 */         unmarshalBytes();
/* 148 */         this.rowData.setPosition(l);
/* 149 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 151 */       else if (isNullByDescribe())
/*     */       {
/* 154 */         setNull(this.lastRowProcessed, true);
/* 155 */         unmarshalColumnMetadata();
/* 156 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 160 */         unmarshalColumnMetadata();
/* 161 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 163 */     this.previousRowProcessed = this.lastRowProcessed;
/* 164 */     this.lastRowProcessed += 1;
/* 165 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 177 */     setOffset(this.lastRowProcessed);
/*     */     int i;
/* 178 */     if (this.statement.maxFieldSize > 0)
/* 179 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize);
/*     */     else
/* 181 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 182 */     processIndicator(i);
/* 183 */     setLength(this.lastRowProcessed, i);
/* 184 */     setNull(this.lastRowProcessed, i == 0);
/* 185 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 194 */     if (this.isNullByDescribe) {
/* 195 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 197 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 202 */       if (this.previousRowProcessed == -1)
/* 203 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 204 */       long l = getOffset(this.previousRowProcessed);
/* 205 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 206 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 207 */       if (!isNull(this.previousRowProcessed)) {
/* 208 */         setOffset(this.lastRowProcessed);
/* 209 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 210 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 215 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 216 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 217 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 218 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 220 */     this.previousRowProcessed = this.lastRowProcessed;
/* 221 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 230 */     if (this.definedColumnType == 0) {
/* 231 */       return super.getObject(paramInt);
/*     */     }
/*     */ 
/* 234 */     if (isNull(paramInt)) return null;
/*     */ 
/* 236 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -15:
/*     */     case -9:
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 243 */       return getString(paramInt);
/*     */     case 2:
/*     */     case 3:
/* 248 */       return getBigDecimal(paramInt);
/*     */     case 4:
/* 251 */       return Integer.valueOf(getInt(paramInt));
/*     */     case -6:
/* 254 */       return Byte.valueOf(getByte(paramInt));
/*     */     case 5:
/* 257 */       return Short.valueOf(getShort(paramInt));
/*     */     case -7:
/*     */     case 16:
/* 262 */       return Boolean.valueOf(getBoolean(paramInt));
/*     */     case -5:
/* 265 */       return Long.valueOf(getLong(paramInt));
/*     */     case 7:
/* 268 */       return Float.valueOf(getFloat(paramInt));
/*     */     case 6:
/*     */     case 8:
/* 273 */       return Double.valueOf(getDouble(paramInt));
/*     */     case 91:
/* 276 */       return getDate(paramInt);
/*     */     case 92:
/* 279 */       return getTime(paramInt);
/*     */     case 93:
/* 282 */       return getTimestamp(paramInt);
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 289 */       return getBytes(paramInt);
/*     */     }
/*     */ 
/* 293 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 294 */     localSQLException.fillInStackTrace();
/* 295 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CNumberAccessor
 * JD-Core Version:    0.6.2
 */