/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CNamedTypeAccessor extends NamedTypeAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 2147483647;
/*  23 */   final int[] meta = new int[1];
/*     */   T4CMAREngine mare;
/* 225 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  36 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  45 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  48 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  55 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  62 */       this.mare.unmarshalUB2();
/*  63 */       this.mare.unmarshalUB2();
/*     */     }
/*  65 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  69 */       this.mare.unmarshalSB2();
/*     */ 
/*  71 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  72 */         this.mare.unmarshalSB2();
/*     */     }
/*  74 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  75 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/*  81 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  82 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/*  98 */     boolean bool = false;
/*  99 */     if (!isUseless())
/*     */     {
/* 105 */       if (isUnexpected())
/*     */       {
/* 108 */         long l = this.rowData.getPosition();
/* 109 */         unmarshalColumnMetadata();
/* 110 */         unmarshalBytes();
/* 111 */         this.rowData.setPosition(l);
/* 112 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 114 */       else if (isNullByDescribe())
/*     */       {
/* 117 */         setNull(this.lastRowProcessed, true);
/* 118 */         unmarshalColumnMetadata();
/* 119 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 123 */         unmarshalColumnMetadata();
/* 124 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 126 */     this.previousRowProcessed = this.lastRowProcessed;
/* 127 */     this.lastRowProcessed += 1;
/* 128 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 137 */     if (this.isNullByDescribe) {
/* 138 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 140 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 145 */       if (this.previousRowProcessed == -1)
/* 146 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 147 */       long l = getOffset(this.previousRowProcessed);
/* 148 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 149 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 150 */       if (!isNull(this.previousRowProcessed)) {
/* 151 */         setOffset(this.lastRowProcessed);
/* 152 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 153 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 158 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 159 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 160 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 161 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 163 */     this.previousRowProcessed = this.lastRowProcessed;
/* 164 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   T4CNamedTypeAccessor(OracleStatement paramOracleStatement, String paramString, short paramShort, int paramInt, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 174 */     super(paramOracleStatement, paramString, paramShort, paramInt, paramBoolean);
/*     */ 
/* 176 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CNamedTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 186 */     super(paramOracleStatement, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/* 189 */     this.mare = paramT4CMAREngine;
/* 190 */     this.definedColumnType = paramInt7;
/* 191 */     this.definedColumnSize = paramInt8;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 204 */     byte[] arrayOfByte1 = this.mare.unmarshalDALC();
/* 205 */     byte[] arrayOfByte2 = this.mare.unmarshalDALC();
/* 206 */     byte[] arrayOfByte3 = this.mare.unmarshalDALC();
/* 207 */     int i = this.mare.unmarshalUB2();
/* 208 */     long l = this.mare.unmarshalUB4();
/* 209 */     int j = this.mare.unmarshalUB2();
/*     */ 
/* 211 */     setOffset(this.lastRowProcessed);
/* 212 */     if (l > 0L) {
/* 213 */       int k = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 214 */       setLength(this.lastRowProcessed, k);
/* 215 */       setNull(this.lastRowProcessed, false);
/*     */     } else {
/* 217 */       setNull(this.lastRowProcessed, true);
/* 218 */     }processIndicator((int)l);
/* 219 */     return false;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CNamedTypeAccessor
 * JD-Core Version:    0.6.2
 */