/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ 
/*     */ abstract class T4CMarshaller
/*     */ {
/*  27 */   private static final T4CMarshaller BASIC = new BasicMarshaller(null);
/*  28 */   private static final T4CMarshaller STREAM = new StreamMarshaller(null);
/*     */ 
/*  30 */   static final T4CMarshaller CHAR = BASIC;
/*  31 */   static final T4CMarshaller LONG_RAW = STREAM;
/*  32 */   static final T4CMarshaller RAW = BASIC;
/*  33 */   static final T4CMarshaller VARCHAR = BASIC;
/*  34 */   static final T4CMarshaller LONG = STREAM;
/*     */ 
/* 347 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   abstract boolean unmarshalOneRow(Accessor paramAccessor)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   abstract int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   private static final class StreamMarshaller extends T4CMarshaller
/*     */   {
/*     */     private StreamMarshaller()
/*     */     {
/* 151 */       super();
/*     */     }
/*     */ 
/*     */     boolean unmarshalOneRow(Accessor paramAccessor) throws SQLException, IOException
/*     */     {
/* 156 */       T4CAccessor localT4CAccessor = (T4CAccessor)paramAccessor;
/* 157 */       T4CMAREngine localT4CMAREngine = localT4CAccessor.getMAREngine();
/*     */ 
/* 163 */       if (paramAccessor.isUseless()) {
/* 164 */         paramAccessor.lastRowProcessed += 1;
/* 165 */         return false;
/*     */       }
/*     */ 
/* 168 */       boolean bool = false;
/*     */ 
/* 174 */       paramAccessor.escapeSequenceArr[0] = localT4CMAREngine.unmarshalUB1();
/*     */       int i;
/* 177 */       if (localT4CMAREngine.escapeSequenceNull(paramAccessor.escapeSequenceArr[0]))
/*     */       {
/* 179 */         paramAccessor.setNull(paramAccessor.lastRowProcessed, true);
/* 180 */         localT4CMAREngine.processIndicator(false, 0);
/* 181 */         i = (int)localT4CMAREngine.unmarshalUB4();
/*     */ 
/* 183 */         paramAccessor.escapeSequenceArr[0] = 0;
/* 184 */         paramAccessor.previousRowProcessed = paramAccessor.lastRowProcessed;
/* 185 */         paramAccessor.lastRowProcessed += 1;
/*     */       }
/*     */       else
/*     */       {
/* 189 */         paramAccessor.setNull(paramAccessor.lastRowProcessed, false);
/* 190 */         paramAccessor.readHeaderArr[0] = true;
/* 191 */         paramAccessor.readAsNonStreamArr[0] = false;
/*     */ 
/* 194 */         if ((paramAccessor.statement.isFetchStreams) || (paramAccessor.definedColumnType == -2) || (paramAccessor.definedColumnType == 12) || (paramAccessor.definedColumnType == 1))
/*     */         {
/* 201 */           i = 0;
/* 202 */           int j = 0;
/* 203 */           byte[] arrayOfByte = paramAccessor.statement.connection.getByteBuffer(32768);
/* 204 */           paramAccessor.setOffset(paramAccessor.lastRowProcessed);
/* 205 */           while (i != -1) {
/* 206 */             i = readStreamFromWire(arrayOfByte, 0, 32768, paramAccessor.escapeSequenceArr, paramAccessor.readHeaderArr, paramAccessor.readAsNonStreamArr, localT4CMAREngine, ((T4CConnection)paramAccessor.statement.connection).oer);
/*     */ 
/* 214 */             if (i != -1) {
/* 215 */               if (paramAccessor.statement.connection.checksumMode.needToCalculateFetchChecksum()) {
/* 216 */                 long l = CRC64.updateChecksum(paramAccessor.statement.checkSum, arrayOfByte, 0, i);
/*     */ 
/* 220 */                 paramAccessor.statement.checkSum = l;
/*     */               }
/* 222 */               paramAccessor.rowData.put(arrayOfByte, 0, i);
/* 223 */               j += i;
/*     */             }
/*     */           }
/* 226 */           paramAccessor.setLength(paramAccessor.lastRowProcessed, j);
/* 227 */           paramAccessor.previousRowProcessed = paramAccessor.lastRowProcessed;
/* 228 */           paramAccessor.lastRowProcessed += 1;
/* 229 */           paramAccessor.isStream = false;
/* 230 */           paramAccessor.statement.connection.cacheBuffer(arrayOfByte);
/*     */         }
/*     */         else {
/* 233 */           bool = true;
/*     */         }
/*     */       }
/*     */ 
/* 237 */       return bool;
/*     */     }
/*     */ 
/*     */     int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */       throws SQLException, IOException
/*     */     {
/* 250 */       int i = -1;
/*     */       try
/*     */       {
/* 253 */         if (paramArrayOfBoolean2[0] == 0)
/*     */         {
/*     */           SQLException localSQLException;
/* 255 */           if ((paramInt2 > 32768) || (paramInt2 < 0))
/*     */           {
/* 257 */             localSQLException = DatabaseError.createSqlException(null, 433);
/* 258 */             localSQLException.fillInStackTrace();
/* 259 */             throw localSQLException;
/*     */           }
/*     */ 
/* 263 */           if (paramArrayOfBoolean1[0] != 0)
/*     */           {
/* 265 */             if (paramArrayOfInt[0] == 254) {
/* 266 */               if (paramT4CMAREngine.useCLRBigChunks)
/*     */               {
/* 268 */                 i = paramT4CMAREngine.unmarshalSB4();
/*     */               }
/*     */               else
/*     */               {
/* 272 */                 i = paramT4CMAREngine.unmarshalUB1();
/*     */               }
/*     */             }
/*     */             else {
/* 276 */               if (paramArrayOfInt[0] == 0)
/*     */               {
/* 278 */                 paramT4CTTIoer.connection.internalClose();
/*     */ 
/* 280 */                 localSQLException = DatabaseError.createSqlException(null, 401);
/* 281 */                 localSQLException.fillInStackTrace();
/* 282 */                 throw localSQLException;
/*     */               }
/*     */ 
/* 287 */               paramArrayOfBoolean2[0] = true;
/* 288 */               i = paramArrayOfInt[0];
/*     */             }
/*     */ 
/* 291 */             paramArrayOfBoolean1[0] = false;
/* 292 */             paramArrayOfInt[0] = 0;
/*     */           }
/* 295 */           else if (paramT4CMAREngine.useCLRBigChunks)
/*     */           {
/* 297 */             i = paramT4CMAREngine.unmarshalSB4();
/*     */           }
/*     */           else
/*     */           {
/* 301 */             i = paramT4CMAREngine.unmarshalUB1();
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 307 */           paramArrayOfBoolean2[0] = false;
/*     */         }
/*     */ 
/* 311 */         if (i > 0)
/*     */         {
/* 313 */           paramT4CMAREngine.unmarshalNBytes(paramArrayOfByte, paramInt1, i);
/*     */         }
/*     */         else {
/* 316 */           i = -1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (BreakNetException localBreakNetException)
/*     */       {
/* 325 */         i = paramT4CMAREngine.unmarshalSB1();
/* 326 */         if (i == 4) {
/* 327 */           paramT4CTTIoer.init();
/* 328 */           paramT4CTTIoer.processError();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 333 */       if (i == -1) {
/* 334 */         paramArrayOfBoolean1[0] = true;
/*     */ 
/* 336 */         paramT4CMAREngine.unmarshalUB2();
/* 337 */         paramT4CMAREngine.unmarshalUB2();
/*     */       }
/*     */ 
/* 340 */       return i;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class BasicMarshaller extends T4CMarshaller
/*     */   {
/*     */     private BasicMarshaller()
/*     */     {
/*  63 */       super();
/*     */     }
/*     */ 
/*     */     boolean unmarshalOneRow(Accessor paramAccessor)
/*     */       throws SQLException, IOException
/*     */     {
/*  73 */       T4CAccessor localT4CAccessor = (T4CAccessor)paramAccessor;
/*     */ 
/*  75 */       boolean bool = false;
/*  76 */       if (!paramAccessor.isUseless())
/*     */       {
/*  82 */         if (paramAccessor.isUnexpected())
/*     */         {
/*  85 */           long l = paramAccessor.rowData.getPosition();
/*  86 */           localT4CAccessor.unmarshalColumnMetadata();
/*  87 */           unmarshalBytes(paramAccessor);
/*  88 */           paramAccessor.rowData.setPosition(l);
/*  89 */           paramAccessor.setNull(paramAccessor.lastRowProcessed, true);
/*     */         }
/*  91 */         else if (paramAccessor.isNullByDescribe())
/*     */         {
/*  94 */           paramAccessor.setNull(paramAccessor.lastRowProcessed, true);
/*  95 */           localT4CAccessor.unmarshalColumnMetadata();
/*  96 */           if (paramAccessor.statement.connection.versionNumber < 9200) localT4CAccessor.processIndicator(0);
/*     */         }
/*     */         else
/*     */         {
/* 100 */           localT4CAccessor.unmarshalColumnMetadata();
/* 101 */           bool = unmarshalBytes(paramAccessor);
/*     */         }
/*     */       }
/* 103 */       paramAccessor.previousRowProcessed = paramAccessor.lastRowProcessed;
/* 104 */       paramAccessor.lastRowProcessed += 1;
/* 105 */       return bool;
/*     */     }
/*     */ 
/*     */     private boolean unmarshalBytes(Accessor paramAccessor)
/*     */       throws SQLException, IOException
/*     */     {
/* 116 */       T4CAccessor localT4CAccessor = (T4CAccessor)paramAccessor;
/* 117 */       T4CMAREngine localT4CMAREngine = localT4CAccessor.getMAREngine();
/*     */ 
/* 120 */       paramAccessor.setOffset(paramAccessor.lastRowProcessed);
/*     */       int i;
/* 121 */       if (paramAccessor.statement.maxFieldSize > 0)
/* 122 */         i = ((DynamicByteArray)paramAccessor.rowData).unmarshalCLR(localT4CMAREngine, paramAccessor.statement.maxFieldSize);
/*     */       else
/* 124 */         i = ((DynamicByteArray)paramAccessor.rowData).unmarshalCLR(localT4CMAREngine);
/* 125 */       localT4CAccessor.processIndicator(i);
/* 126 */       paramAccessor.setLength(paramAccessor.lastRowProcessed, i);
/* 127 */       paramAccessor.setNull(paramAccessor.lastRowProcessed, i == 0);
/* 128 */       return false;
/*     */     }
/*     */ 
/*     */     int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */       throws SQLException, IOException
/*     */     {
/* 141 */       return -1;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CMarshaller
 * JD-Core Version:    0.6.2
 */