/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ import oracle.net.ns.Communication;
/*     */ import oracle.net.ns.NetException;
/*     */ import oracle.net.ns.NetInputStream;
/*     */ import oracle.net.ns.NetOutputStream;
/*     */ 
/*     */ class T4CMAREngineStream extends T4CMAREngine
/*     */ {
/*     */   NetInputStream inStream;
/*     */   NetOutputStream outStream;
/* 859 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CMAREngineStream(Communication paramCommunication)
/*     */     throws SQLException, IOException
/*     */   {
/*  59 */     if (paramCommunication == null)
/*     */     {
/*  63 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 433);
/*  64 */       localSQLException.fillInStackTrace();
/*  65 */       throw localSQLException;
/*     */     }
/*     */ 
/*  70 */     this.net = paramCommunication;
/*     */     try
/*     */     {
/*  73 */       this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)paramCommunication.getOutputStream());
/*  74 */       this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)paramCommunication.getInputStream(), (T4CSocketOutputStreamWrapper)this.outStream);
/*     */     }
/*     */     catch (NetException localNetException)
/*     */     {
/*  79 */       throw new IOException(localNetException.getMessage());
/*     */     }
/*     */ 
/*  82 */     this.types = new T4CTypeRep(this, false);
/*     */ 
/*  84 */     this.types.setRep((byte)1, (byte)2);
/*     */   }
/*     */ 
/*     */   void initBuffers()
/*     */   {
/*     */   }
/*     */ 
/*     */   final void marshalSB1(byte paramByte)
/*     */     throws IOException
/*     */   {
/* 122 */     marshalSB2((short)paramByte);
/*     */   }
/*     */ 
/*     */   final void marshalUB1(short paramShort)
/*     */     throws IOException
/*     */   {
/* 134 */     this.outStream.write((byte)(paramShort & 0xFF));
/*     */   }
/*     */ 
/*     */   final void marshalSB2(short paramShort)
/*     */     throws IOException
/*     */   {
/* 150 */     int i = value2Buffer(paramShort, this.tmpBuffer2, (byte)1);
/*     */ 
/* 152 */     if (i != 0)
/*     */     {
/* 154 */       this.outStream.write(this.tmpBuffer2, 0, i);
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalUB2(int paramInt)
/*     */     throws IOException
/*     */   {
/* 167 */     marshalSB2((short)(paramInt & 0xFFFF));
/*     */   }
/*     */ 
/*     */   final void marshalSB4(int paramInt)
/*     */     throws IOException
/*     */   {
/* 184 */     int i = value2Buffer(paramInt, this.tmpBuffer4, (byte)2);
/*     */ 
/* 187 */     if (i != 0)
/*     */     {
/* 189 */       this.outStream.write(this.tmpBuffer4, 0, i);
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalUB4(long paramLong)
/*     */     throws IOException
/*     */   {
/* 202 */     marshalSB4((int)(paramLong & 0xFFFFFFFF));
/*     */   }
/*     */ 
/*     */   final void marshalSB8(long paramLong)
/*     */     throws IOException
/*     */   {
/* 218 */     int i = value2Buffer(paramLong, this.tmpBuffer8, (byte)3);
/*     */ 
/* 221 */     if (i != 0)
/*     */     {
/* 223 */       this.outStream.write(this.tmpBuffer8, 0, i);
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalB1Array(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 237 */     if (paramArrayOfByte.length > 0)
/*     */     {
/* 239 */       this.outStream.write(paramArrayOfByte);
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalB1Array(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 255 */     if (paramArrayOfByte.length > 0)
/*     */     {
/* 257 */       this.outStream.write(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */   }
/*     */ 
/*     */   final byte value2Buffer(int paramInt, byte[] paramArrayOfByte, byte paramByte)
/*     */     throws IOException
/*     */   {
/* 277 */     int i = (this.types.rep[paramByte] & 0x1) > 0 ? 1 : 0;
/* 278 */     int j = 1;
/* 279 */     byte b = 0;
/*     */ 
/* 283 */     for (int k = paramArrayOfByte.length - 1; k >= 0; k--)
/*     */     {
/* 285 */       paramArrayOfByte[b] = ((byte)(paramInt >>> 8 * k & 0xFF));
/*     */ 
/* 289 */       if (i != 0)
/*     */       {
/* 291 */         if ((j == 0) || (paramArrayOfByte[b] != 0))
/*     */         {
/* 293 */           j = 0;
/* 294 */           b = (byte)(b + 1);
/*     */         }
/*     */       }
/*     */       else {
/* 298 */         b = (byte)(b + 1);
/*     */       }
/*     */     }
/*     */ 
/* 302 */     if (i != 0)
/*     */     {
/* 304 */       this.outStream.write(b);
/*     */     }
/*     */ 
/* 310 */     if ((this.types.rep[paramByte] & 0x2) > 0) {
/* 311 */       reverseArray(paramArrayOfByte, b);
/*     */     }
/* 313 */     return b;
/*     */   }
/*     */ 
/*     */   final byte value2Buffer(long paramLong, byte[] paramArrayOfByte, byte paramByte)
/*     */     throws IOException
/*     */   {
/* 321 */     int i = (this.types.rep[paramByte] & 0x1) > 0 ? 1 : 0;
/* 322 */     int j = 1;
/* 323 */     byte b = 0;
/*     */ 
/* 327 */     for (int k = paramArrayOfByte.length - 1; k >= 0; k--)
/*     */     {
/* 329 */       paramArrayOfByte[b] = ((byte)(int)(paramLong >>> 8 * k & 0xFF));
/*     */ 
/* 333 */       if (i != 0)
/*     */       {
/* 335 */         if ((j == 0) || (paramArrayOfByte[b] != 0))
/*     */         {
/* 337 */           j = 0;
/* 338 */           b = (byte)(b + 1);
/*     */         }
/*     */       }
/*     */       else {
/* 342 */         b = (byte)(b + 1);
/*     */       }
/*     */     }
/*     */ 
/* 346 */     if (i != 0)
/*     */     {
/* 348 */       this.outStream.write(b);
/*     */     }
/*     */ 
/* 354 */     if ((this.types.rep[paramByte] & 0x2) > 0) {
/* 355 */       reverseArray(paramArrayOfByte, b);
/*     */     }
/* 357 */     return b;
/*     */   }
/*     */ 
/*     */   final void reverseArray(byte[] paramArrayOfByte, byte paramByte)
/*     */   {
/* 372 */     int j = paramByte / 2;
/*     */ 
/* 374 */     for (int k = 0; k < j; k++)
/*     */     {
/* 376 */       int i = paramArrayOfByte[k];
/* 377 */       paramArrayOfByte[k] = paramArrayOfByte[(paramByte - 1 - k)];
/* 378 */       paramArrayOfByte[(paramByte - 1 - k)] = i;
/*     */     }
/*     */   }
/*     */ 
/*     */   final byte unmarshalSB1()
/*     */     throws SQLException, IOException
/*     */   {
/* 406 */     byte b = (byte)unmarshalSB2();
/* 407 */     return b;
/*     */   }
/*     */ 
/*     */   final short unmarshalUB1()
/*     */     throws SQLException, IOException
/*     */   {
/* 421 */     short s = 0;
/*     */     try
/*     */     {
/* 426 */       s = (short)this.inStream.read();
/*     */     }
/*     */     catch (BreakNetException localBreakNetException)
/*     */     {
/* 435 */       this.net.sendReset();
/* 436 */       throw localBreakNetException;
/*     */     }
/*     */ 
/* 441 */     if (s < 0)
/*     */     {
/* 445 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 446 */       localSQLException.fillInStackTrace();
/* 447 */       throw localSQLException;
/*     */     }
/*     */ 
/* 456 */     return s;
/*     */   }
/*     */ 
/*     */   final short unmarshalSB2()
/*     */     throws SQLException, IOException
/*     */   {
/* 470 */     short s = (short)unmarshalUB2();
/* 471 */     return s;
/*     */   }
/*     */ 
/*     */   final int unmarshalUB2()
/*     */     throws SQLException, IOException
/*     */   {
/* 488 */     int i = (int)buffer2Value((byte)1);
/*     */ 
/* 496 */     return i & 0xFFFF;
/*     */   }
/*     */ 
/*     */   final int unmarshalSB4()
/*     */     throws SQLException, IOException
/*     */   {
/* 510 */     int i = (int)unmarshalUB4();
/* 511 */     return i;
/*     */   }
/*     */ 
/*     */   final long unmarshalUB4()
/*     */     throws SQLException, IOException
/*     */   {
/* 528 */     long l = buffer2Value((byte)2);
/*     */ 
/* 530 */     return l;
/*     */   }
/*     */ 
/*     */   byte[] unmarshalNBytes(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 545 */     byte[] arrayOfByte = new byte[paramInt];
/*     */ 
/* 547 */     if (paramInt > 0)
/*     */     {
/*     */       try
/*     */       {
/* 552 */         if (this.inStream.read(arrayOfByte) < 0)
/*     */         {
/* 556 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 557 */           localSQLException.fillInStackTrace();
/* 558 */           throw localSQLException;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (BreakNetException localBreakNetException)
/*     */       {
/* 570 */         this.net.sendReset();
/* 571 */         throw localBreakNetException;
/*     */       }
/*     */     }
/*     */ 
/* 575 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int unmarshalNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException, IOException
/*     */   {
/* 591 */     if (paramInt1 + paramInt2 > paramArrayOfByte.length)
/*     */     {
/* 593 */       paramInt2 = paramArrayOfByte.length - paramInt1;
/*     */     }
/*     */ 
/* 596 */     int i = 0;
/*     */ 
/* 598 */     while (i < paramInt2) {
/* 599 */       i += getNBytes(paramArrayOfByte, paramInt1 + i, paramInt2 - i);
/*     */     }
/* 601 */     return i;
/*     */   }
/*     */ 
/*     */   int getNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException, IOException
/*     */   {
/* 618 */     if (paramInt1 + paramInt2 > paramArrayOfByte.length)
/*     */     {
/* 620 */       paramInt2 = paramArrayOfByte.length - paramInt1;
/*     */     }
/*     */ 
/* 623 */     int i = 0;
/*     */     try
/*     */     {
/* 629 */       if ((i = this.inStream.read(paramArrayOfByte, paramInt1, paramInt2)) < 0)
/*     */       {
/* 633 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 634 */         localSQLException.fillInStackTrace();
/* 635 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BreakNetException localBreakNetException)
/*     */     {
/* 648 */       this.net.sendReset();
/* 649 */       throw localBreakNetException;
/*     */     }
/*     */ 
/* 653 */     return i;
/*     */   }
/*     */ 
/*     */   byte[] getNBytes(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 667 */     byte[] arrayOfByte = new byte[paramInt];
/*     */     try
/*     */     {
/* 673 */       if (this.inStream.read(arrayOfByte) < 0)
/*     */       {
/* 678 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 679 */         localSQLException.fillInStackTrace();
/* 680 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BreakNetException localBreakNetException)
/*     */     {
/* 693 */       this.net.sendReset();
/* 694 */       throw localBreakNetException;
/*     */     }
/*     */ 
/* 698 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   byte[] unmarshalTEXT(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 716 */     int i = 0;
/*     */ 
/* 720 */     byte[] arrayOfByte1 = new byte[paramInt];
/*     */ 
/* 723 */     while (i < paramInt)
/*     */     {
/*     */       try
/*     */       {
/* 729 */         if (this.inStream.read(arrayOfByte1, i, 1) < 0)
/*     */         {
/* 734 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 735 */           localSQLException.fillInStackTrace();
/* 736 */           throw localSQLException;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (BreakNetException localBreakNetException)
/*     */       {
/* 749 */         this.net.sendReset();
/* 750 */         throw localBreakNetException;
/*     */       }
/*     */ 
/* 754 */       if (arrayOfByte1[(i++)] == 0)
/* 755 */         break;
/*     */     }
/*     */     byte[] arrayOfByte2;
/* 759 */     if (arrayOfByte1.length == --i)
/*     */     {
/* 761 */       arrayOfByte2 = arrayOfByte1;
/*     */     }
/*     */     else
/*     */     {
/* 765 */       arrayOfByte2 = new byte[i];
/*     */ 
/* 767 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, i);
/*     */     }
/*     */ 
/* 770 */     return arrayOfByte2;
/*     */   }
/*     */ 
/*     */   final long buffer2Value(byte paramByte)
/*     */     throws SQLException, IOException
/*     */   {
/*     */     try
/*     */     {
/* 791 */       long l = 0L;
/* 792 */       int i = 1;
/* 793 */       if ((this.types.rep[paramByte] & 0x1) > 0) {
/* 794 */         i = this.inStream.readB1();
/*     */       }
/*     */       else {
/* 797 */         switch (paramByte) {
/*     */         case 1:
/* 799 */           i = 2;
/* 800 */           break;
/*     */         case 2:
/* 802 */           i = 4;
/* 803 */           break;
/*     */         case 3:
/* 805 */           i = 8;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 810 */       if ((this.types.rep[paramByte] & 0x2) > 0) {
/* 811 */         l = this.inStream.readLongLSB(i);
/*     */       }
/* 813 */       return this.inStream.readLongMSB(i);
/*     */     }
/*     */     catch (BreakNetException localBreakNetException)
/*     */     {
/* 819 */       this.net.sendReset();
/* 820 */       throw localBreakNetException;
/*     */     }
/*     */     catch (SocketTimeoutException localSocketTimeoutException)
/*     */     {
/* 826 */       throw localSocketTimeoutException;
/*     */     }
/*     */   }
/*     */ 
/*     */   void setByteOrder(byte paramByte)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void flush()
/*     */     throws IOException
/*     */   {
/* 842 */     ((T4CSocketOutputStreamWrapper)this.outStream).flush(true);
/*     */   }
/*     */ 
/*     */   void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException
/*     */   {
/* 853 */     this.outStream.flush();
/* 854 */     this.outStream.writeZeroCopyIO(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CMAREngineStream
 * JD-Core Version:    0.6.2
 */