/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.ByteOrder;
/*     */ import java.sql.SQLException;
/*     */ import oracle.net.ns.BreakNetException;
/*     */ import oracle.net.ns.Communication;
/*     */ import oracle.net.ns.NIONSDataChannel;
/*     */ import oracle.net.ns.NetException;
/*     */ import oracle.net.ns.SessionAtts;
/*     */ 
/*     */ class T4CMAREngineNIO extends T4CMAREngine
/*     */ {
/*     */   NIONSDataChannel nsDataChannel;
/*     */   ByteBuffer dataBuffer;
/*  46 */   private boolean bytesReadyToGo = false;
/*     */ 
/*  50 */   private boolean bufferReadyToWriteInto = false;
/*     */ 
/* 456 */   int bytesWrittenSoFar = 0; int bytesToWriteInNextCall = 0;
/*     */ 
/* 857 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CMAREngineNIO(Communication paramCommunication)
/*     */     throws SQLException, IOException
/*     */   {
/*  59 */     if (paramCommunication == null)
/*     */     {
/*  63 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 433);
/*  64 */       localSQLException.fillInStackTrace();
/*  65 */       throw localSQLException;
/*     */     }
/*     */ 
/*  70 */     this.net = paramCommunication;
/*     */ 
/*  72 */     this.nsDataChannel = paramCommunication.getSessionAttributes().dataChannel;
/*  73 */     this.dataBuffer = paramCommunication.getSessionAttributes().payloadDataBuffer;
/*  74 */     this.types = new T4CTypeRep(this, true);
/*     */ 
/*  78 */     this.types.setRep((byte)1, (byte)2);
/*  79 */     this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
/*     */   }
/*     */ 
/*     */   final void prepareForReading()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/*  92 */       if (this.bytesReadyToGo)
/*     */       {
/*  94 */         this.nsDataChannel.writeDataToSocketChannel();
/*  95 */         this.bytesReadyToGo = false;
/*  96 */         this.nsDataChannel.readDataFromSocketChannel();
/*     */       }
/*     */ 
/*  99 */       while (!this.dataBuffer.hasRemaining()) {
/* 100 */         this.nsDataChannel.readDataFromSocketChannel();
/*     */       }
/*     */ 
/* 103 */       this.bufferReadyToWriteInto = false;
/*     */     }
/*     */     catch (BreakNetException localBreakNetException)
/*     */     {
/* 108 */       this.net.sendReset();
/* 109 */       throw localBreakNetException;
/*     */     }
/*     */   }
/*     */ 
/*     */   final void prepareForWriting()
/*     */     throws IOException
/*     */   {
/* 119 */     if (!this.bufferReadyToWriteInto)
/*     */     {
/* 121 */       this.dataBuffer.clear();
/* 122 */       this.dataBuffer.limit(this.dataBuffer.capacity());
/* 123 */       this.bufferReadyToWriteInto = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void valueToUNV(long paramLong, byte[] paramArrayOfByte)
/*     */   {
/* 130 */     paramArrayOfByte[0] = 0;
/* 131 */     if (paramLong == 0L)
/* 132 */       return;
/* 133 */     int i = 0;
/* 134 */     int j = 1;
/* 135 */     int k = paramLong < 0L ? 1 : 0;
/* 136 */     long l = k != 0 ? -paramLong : paramLong;
/* 137 */     for (int m = 0; m < 8; m++)
/*     */     {
/* 140 */       int n = (byte)(int)(l >>> 8 * (7 - m) & 0xFF);
/* 141 */       if ((j == 0) || (n != 0))
/*     */       {
/* 143 */         j = 0;
/* 144 */         paramArrayOfByte[(++i)] = n;
/*     */       }
/*     */     }
/* 147 */     paramArrayOfByte[0] = ((byte)i);
/* 148 */     if (k != 0)
/*     */     {
/*     */       int tmp110_109 = 0;
/*     */       byte[] tmp110_108 = paramArrayOfByte; tmp110_108[tmp110_109] = ((byte)(tmp110_108[tmp110_109] | 0xFFFFFF80));
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalSB1(byte paramByte)
/*     */     throws IOException
/*     */   {
/* 172 */     prepareForWriting();
/*     */ 
/* 174 */     if (this.dataBuffer.remaining() < 1)
/* 175 */       this.nsDataChannel.writeDataToSocketChannel();
/* 176 */     this.dataBuffer.put(paramByte);
/* 177 */     this.bytesReadyToGo = true;
/*     */   }
/*     */ 
/*     */   final void marshalUB1(short paramShort)
/*     */     throws IOException
/*     */   {
/* 190 */     marshalSB1((byte)paramShort);
/*     */   }
/*     */ 
/*     */   final void marshalSB2(short paramShort)
/*     */     throws IOException
/*     */   {
/* 203 */     prepareForWriting();
/*     */ 
/* 205 */     if (this.dataBuffer.remaining() < 3)
/* 206 */       this.nsDataChannel.writeDataToSocketChannel();
/* 207 */     if (this.types.rep[1] != 1)
/*     */     {
/* 209 */       this.dataBuffer.putShort(paramShort);
/*     */     }
/* 212 */     else if (paramShort == 0) {
/* 213 */       this.dataBuffer.put((byte)0);
/*     */     }
/*     */     else {
/* 216 */       int i = paramShort < 0 ? 1 : 0;
/* 217 */       short s = (short)(i != 0 ? -paramShort : paramShort);
/* 218 */       if (s <= 255)
/*     */       {
/* 220 */         if (i != 0)
/* 221 */           this.dataBuffer.put((byte)-127);
/*     */         else
/* 223 */           this.dataBuffer.put((byte)1);
/* 224 */         this.dataBuffer.put((byte)s);
/*     */       }
/*     */       else
/*     */       {
/* 229 */         if (i != 0)
/* 230 */           this.dataBuffer.put((byte)-126);
/*     */         else
/* 232 */           this.dataBuffer.put((byte)2);
/* 233 */         this.dataBuffer.putShort(s);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   final void marshalUB2(int paramInt)
/*     */     throws IOException
/*     */   {
/* 249 */     prepareForWriting();
/*     */ 
/* 251 */     if (this.dataBuffer.remaining() < 3)
/* 252 */       this.nsDataChannel.writeDataToSocketChannel();
/* 253 */     if (this.types.rep[1] != 1)
/*     */     {
/* 255 */       this.dataBuffer.putShort((short)paramInt);
/*     */     }
/* 258 */     else if (paramInt == 0) {
/* 259 */       this.dataBuffer.put((byte)0);
/*     */     }
/* 262 */     else if (paramInt <= 255)
/*     */     {
/* 265 */       this.dataBuffer.put((byte)1);
/* 266 */       this.dataBuffer.put((byte)paramInt);
/*     */     }
/*     */     else
/*     */     {
/* 271 */       this.dataBuffer.put((byte)2);
/* 272 */       this.dataBuffer.putShort((short)paramInt);
/*     */     }
/*     */ 
/* 276 */     this.bytesReadyToGo = true;
/*     */   }
/*     */ 
/*     */   final void marshalSB4(int paramInt)
/*     */     throws IOException
/*     */   {
/* 290 */     prepareForWriting();
/*     */ 
/* 292 */     if (this.dataBuffer.remaining() < 5)
/* 293 */       this.nsDataChannel.writeDataToSocketChannel();
/* 294 */     if (this.types.rep[2] != 1)
/*     */     {
/* 296 */       this.dataBuffer.putInt(paramInt);
/*     */     }
/* 300 */     else if (paramInt == 0) {
/* 301 */       this.dataBuffer.put((byte)0);
/*     */     }
/*     */     else {
/* 304 */       int i = paramInt < 0 ? 1 : 0;
/* 305 */       int j = i != 0 ? -paramInt : paramInt;
/* 306 */       if (j <= 255)
/*     */       {
/* 309 */         if (i == 0)
/* 310 */           this.dataBuffer.put((byte)1);
/*     */         else
/* 312 */           this.dataBuffer.put((byte)-127);
/* 313 */         this.dataBuffer.put((byte)j);
/*     */       }
/* 315 */       else if (j <= 65535)
/*     */       {
/* 318 */         if (i == 0)
/* 319 */           this.dataBuffer.put((byte)2);
/*     */         else
/* 321 */           this.dataBuffer.put((byte)-126);
/* 322 */         this.dataBuffer.putShort((short)j);
/*     */       }
/* 324 */       else if (j < 26)
/*     */       {
/* 327 */         valueToUNV(paramInt, this.tmpBuffer10);
/* 328 */         this.dataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
/*     */       }
/*     */       else
/*     */       {
/* 333 */         if (i == 0)
/* 334 */           this.dataBuffer.put((byte)4);
/*     */         else
/* 336 */           this.dataBuffer.put((byte)-124);
/* 337 */         this.dataBuffer.putInt(j);
/*     */       }
/*     */     }
/*     */ 
/* 341 */     this.bytesReadyToGo = true;
/*     */   }
/*     */ 
/*     */   final void marshalUB4(long paramLong)
/*     */     throws IOException
/*     */   {
/* 354 */     prepareForWriting();
/*     */ 
/* 356 */     if (this.dataBuffer.remaining() < 5)
/* 357 */       this.nsDataChannel.writeDataToSocketChannel();
/* 358 */     if (this.types.rep[2] != 1)
/*     */     {
/* 360 */       this.dataBuffer.putInt((int)paramLong);
/*     */     }
/* 364 */     else if (paramLong == 0L) {
/* 365 */       this.dataBuffer.put((byte)0);
/* 366 */     } else if (paramLong <= 255L)
/*     */     {
/* 368 */       this.dataBuffer.put((byte)1);
/* 369 */       this.dataBuffer.put((byte)(int)paramLong);
/*     */     }
/* 371 */     else if (paramLong <= 65535L)
/*     */     {
/* 373 */       this.dataBuffer.put((byte)2);
/* 374 */       this.dataBuffer.putShort((short)(int)paramLong);
/*     */     }
/* 376 */     else if (paramLong <= 16777215L)
/*     */     {
/* 379 */       valueToUNV(paramLong, this.tmpBuffer10);
/* 380 */       this.dataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
/*     */     }
/*     */     else
/*     */     {
/* 385 */       this.dataBuffer.put((byte)4);
/* 386 */       this.dataBuffer.putInt((int)paramLong);
/*     */     }
/*     */ 
/* 389 */     this.bytesReadyToGo = true;
/*     */   }
/*     */ 
/*     */   final void marshalSB8(long paramLong)
/*     */     throws IOException
/*     */   {
/* 402 */     prepareForWriting();
/*     */ 
/* 404 */     if (this.dataBuffer.remaining() < 9)
/* 405 */       this.nsDataChannel.writeDataToSocketChannel();
/* 406 */     if (this.types.rep[3] != 1)
/* 407 */       throw new IOException("TODO: SB8 in UNV representation only");
/* 408 */     valueToUNV(paramLong, this.tmpBuffer10);
/* 409 */     this.dataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
/*     */   }
/*     */ 
/*     */   final void marshalUB8(long paramLong)
/*     */     throws IOException
/*     */   {
/* 421 */     prepareForWriting();
/*     */ 
/* 423 */     if (this.dataBuffer.remaining() < 9)
/* 424 */       this.nsDataChannel.writeDataToSocketChannel();
/* 425 */     if (paramLong == 0L)
/* 426 */       this.dataBuffer.put((byte)0);
/* 427 */     if (this.types.rep[3] != 1) {
/* 428 */       throw new IOException("TODO: UB8 in UNV representation only");
/*     */     }
/* 430 */     this.tmpBuffer10[0] = 0;
/* 431 */     int i = 0;
/* 432 */     for (int j = 0; j < 8; j++)
/*     */     {
/* 435 */       int k = (byte)(int)(paramLong >>> 8 * (7 - j) & 0xFF);
/* 436 */       if (k != 0)
/*     */       {
/* 439 */         this.tmpBuffer10[(++i)] = k;
/*     */       }
/*     */     }
/* 441 */     this.tmpBuffer10[0] = ((byte)i);
/* 442 */     this.dataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
/*     */   }
/*     */ 
/*     */   final void marshalB1Array(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 453 */     marshalB1Array(paramArrayOfByte, 0, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   final void marshalB1Array(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 468 */     prepareForWriting();
/* 469 */     this.bytesWrittenSoFar = 0;
/* 470 */     this.bytesToWriteInNextCall = 0;
/*     */ 
/* 472 */     while (this.bytesWrittenSoFar < paramInt2)
/*     */     {
/* 474 */       if (this.dataBuffer.remaining() == 0)
/* 475 */         this.nsDataChannel.writeDataToSocketChannel();
/* 476 */       this.bytesToWriteInNextCall = Math.min(this.dataBuffer.remaining(), paramInt2 - this.bytesWrittenSoFar);
/* 477 */       this.dataBuffer.put(paramArrayOfByte, paramInt1 + this.bytesWrittenSoFar, this.bytesToWriteInNextCall);
/* 478 */       this.bytesWrittenSoFar += this.bytesToWriteInNextCall;
/*     */     }
/* 480 */     this.bytesReadyToGo = true;
/*     */   }
/*     */ 
/*     */   final byte unmarshalSB1()
/*     */     throws SQLException, IOException
/*     */   {
/* 505 */     byte b = (byte)unmarshalSB2();
/* 506 */     return b;
/*     */   }
/*     */ 
/*     */   final short unmarshalUB1()
/*     */     throws SQLException, IOException
/*     */   {
/* 522 */     prepareForReading();
/* 523 */     short s = (short)(this.dataBuffer.get() & 0xFF);
/* 524 */     return s;
/*     */   }
/*     */ 
/*     */   final short unmarshalSB2()
/*     */     throws SQLException, IOException
/*     */   {
/* 540 */     prepareForReading();
/* 541 */     if ((this.types.rep[1] != 1) && (this.dataBuffer.remaining() >= 2))
/*     */     {
/* 544 */       return this.dataBuffer.getShort();
/*     */     }
/*     */ 
/* 547 */     short s = (short)unmarshalUB2();
/* 548 */     return s;
/*     */   }
/*     */ 
/*     */   final int unmarshalUB2()
/*     */     throws SQLException, IOException
/*     */   {
/* 569 */     int i = (int)buffer2Value((byte)1);
/*     */ 
/* 577 */     return i & 0xFFFF;
/*     */   }
/*     */ 
/*     */   final int unmarshalSB4()
/*     */     throws SQLException, IOException
/*     */   {
/* 592 */     prepareForReading();
/* 593 */     if ((this.types.rep[1] != 1) && (this.dataBuffer.remaining() >= 4))
/*     */     {
/* 596 */       return this.dataBuffer.getInt();
/*     */     }
/*     */ 
/* 599 */     return (int)buffer2Value((byte)2);
/*     */   }
/*     */ 
/*     */   final long unmarshalUB4()
/*     */     throws SQLException, IOException
/*     */   {
/* 615 */     return unmarshalSB4() & 0xFFFFFFFF;
/*     */   }
/*     */ 
/*     */   byte[] unmarshalNBytes(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 632 */     byte[] arrayOfByte = new byte[paramInt];
/* 633 */     getNBytes(arrayOfByte, 0, paramInt);
/* 634 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int unmarshalNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException, IOException
/*     */   {
/* 651 */     return getNBytes(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   int getNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException, IOException
/*     */   {
/* 670 */     if (paramInt1 + paramInt2 > paramArrayOfByte.length)
/*     */     {
/* 672 */       paramInt2 = paramArrayOfByte.length - paramInt1;
/*     */     }
/*     */ 
/* 675 */     int i = 0;
/* 676 */     prepareForReading();
/* 677 */     int j = 0;
/* 678 */     while (j < paramInt2)
/*     */     {
/* 680 */       if (!this.dataBuffer.hasRemaining())
/* 681 */         prepareForReading();
/* 682 */       int k = this.dataBuffer.position();
/* 683 */       this.dataBuffer.get(paramArrayOfByte, paramInt1 + j, Math.min(paramInt2 - j, this.dataBuffer.remaining()));
/* 684 */       j += this.dataBuffer.position() - k;
/*     */     }
/* 686 */     return j;
/*     */   }
/*     */ 
/*     */   byte[] getNBytes(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 702 */     return unmarshalNBytes(paramInt);
/*     */   }
/*     */ 
/*     */   byte[] unmarshalTEXT(int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 720 */     int i = 0;
/*     */ 
/* 724 */     byte[] arrayOfByte1 = new byte[paramInt];
/*     */ 
/* 727 */     while (i < paramInt)
/*     */     {
/* 729 */       prepareForReading();
/* 730 */       arrayOfByte1[i] = this.dataBuffer.get();
/*     */ 
/* 732 */       if (arrayOfByte1[(i++)] == 0)
/* 733 */         break;
/*     */     }
/*     */     byte[] arrayOfByte2;
/* 737 */     if (arrayOfByte1.length == --i)
/*     */     {
/* 739 */       arrayOfByte2 = arrayOfByte1;
/*     */     }
/*     */     else
/*     */     {
/* 743 */       arrayOfByte2 = new byte[i];
/*     */ 
/* 745 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, i);
/*     */     }
/*     */ 
/* 748 */     return arrayOfByte2;
/*     */   }
/*     */ 
/*     */   final long buffer2Value(byte paramByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 767 */     long l = 0L;
/* 768 */     int i = this.types.rep[paramByte];
/* 769 */     int j = 0;
/* 770 */     int k = 0;
/* 771 */     if (i == 1)
/*     */     {
/* 774 */       prepareForReading();
/* 775 */       j = this.dataBuffer.get();
/* 776 */       if (j == 0)
/* 777 */         return 0L;
/* 778 */       if ((j & 0x80) > 0)
/*     */       {
/* 780 */         j &= 127;
/* 781 */         k = 1;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 786 */       switch (paramByte)
/*     */       {
/*     */       case 1:
/* 789 */         j = 2;
/* 790 */         break;
/*     */       case 2:
/* 792 */         j = 4;
/* 793 */         break;
/*     */       case 3:
/* 795 */         j = 8;
/*     */       }
/*     */     }
/*     */ 
/* 799 */     if ((this.dataBuffer.remaining() >= j) && ((j == 1) || (j == 2) || (j == 4) || (j == 8)))
/*     */     {
/* 804 */       prepareForReading();
/* 805 */       if (j == 1)
/* 806 */         l = this.dataBuffer.get() & 0xFF;
/* 807 */       else if (j == 2)
/* 808 */         l = this.dataBuffer.getShort() & 0xFFFF;
/* 809 */       else if (j == 4)
/* 810 */         l = this.dataBuffer.getInt() & 0xFFFFFFFF;
/*     */       else {
/* 812 */         l = this.dataBuffer.getLong();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 817 */       unmarshalNBytes(this.tmpBuffer8, 0, j);
/* 818 */       for (int m = 0; m < j; m++)
/*     */       {
/* 820 */         if ((i == 1) || (i != 2))
/* 821 */           l |= (this.tmpBuffer8[m] & 0xFF) << 8 * (j - m - 1);
/*     */         else
/* 823 */           l |= (this.tmpBuffer8[m] & 0xFF) << 8 * m;
/*     */       }
/*     */     }
/* 826 */     if (k != 0)
/* 827 */       l *= -1L;
/* 828 */     return l;
/*     */   }
/*     */ 
/*     */   void setByteOrder(byte paramByte)
/*     */   {
/* 834 */     if (paramByte == 2)
/* 835 */       this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
/*     */     else
/* 837 */       this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
/*     */   }
/*     */ 
/*     */   protected void flush()
/*     */     throws IOException
/*     */   {
/* 843 */     this.nsDataChannel.writeDataToSocketChannel();
/* 844 */     this.bytesReadyToGo = false;
/*     */   }
/*     */ 
/*     */   void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException
/*     */   {
/* 852 */     this.net.writeZeroCopyIO(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CMAREngineNIO
 * JD-Core Version:    0.6.2
 */