/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.concurrent.atomic.AtomicReference;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.net.ns.Communication;
/*      */ import oracle.net.ns.NetException;
/*      */ 
/*      */ abstract class T4CMAREngine
/*      */ {
/*      */   static final int TTCC_MXL = 252;
/*      */   static final int TTCC_ESC = 253;
/*      */   static final int TTCC_LNG = 254;
/*      */   static final int TTCC_ERR = 255;
/*      */   static final int TTCC_MXIN = 32767;
/*      */   static final int TTCC_MXIN_OLD = 64;
/*   88 */   private int effectiveTTCC_MXIN = 64;
/*      */   static final byte TTCLXMULTI = 1;
/*      */   static final byte TTCLXMCONV = 2;
/*      */   T4CTypeRep types;
/*      */   Communication net;
/*      */   DBConversion conv;
/*      */   short proSvrVer;
/*  103 */   static final byte[] NO_BYTES = new byte[0];
/*      */ 
/*  108 */   boolean useCLRBigChunks = false;
/*      */ 
/*  125 */   static final byte[] IGNORED = new byte[32767];
/*  126 */   final byte[] tmpBuffer1 = new byte[1];
/*  127 */   final byte[] tmpBuffer2 = new byte[2];
/*  128 */   final byte[] tmpBuffer3 = new byte[3];
/*  129 */   final byte[] tmpBuffer4 = new byte[4];
/*  130 */   final byte[] tmpBuffer5 = new byte[5];
/*  131 */   final byte[] tmpBuffer6 = new byte[6];
/*  132 */   final byte[] tmpBuffer7 = new byte[7];
/*  133 */   final byte[] tmpBuffer8 = new byte[8];
/*  134 */   final byte[] tmpBuffer10 = new byte[10];
/*  135 */   final int[] retLen = new int[1];
/*      */ 
/*  138 */   AtomicReference<OracleConnection> connForException = new AtomicReference();
/*      */ 
/*  737 */   static final byte[] NULL_PTR = { 0, 0, 0, 0 };
/*  738 */   static final byte[] NOTNULL_PTR = { 127, 127, 127, 127 };
/*      */ 
/* 1435 */   ArrayList refVector = null;
/*      */ 
/* 1919 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   static String toHex(long paramLong, int paramInt)
/*      */   {
/*      */     String str;
/*  150 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/*  154 */       str = "00" + Long.toString(paramLong & 0xFF, 16);
/*      */ 
/*  156 */       break;
/*      */     case 2:
/*  159 */       str = "0000" + Long.toString(paramLong & 0xFFFF, 16);
/*      */ 
/*  161 */       break;
/*      */     case 3:
/*  164 */       str = "000000" + Long.toString(paramLong & 0xFFFFFF, 16);
/*      */ 
/*  166 */       break;
/*      */     case 4:
/*  169 */       str = "00000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/*      */ 
/*  171 */       break;
/*      */     case 5:
/*  174 */       str = "0000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/*      */ 
/*  176 */       break;
/*      */     case 6:
/*  179 */       str = "000000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/*      */ 
/*  181 */       break;
/*      */     case 7:
/*  184 */       str = "00000000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/*      */ 
/*  187 */       break;
/*      */     case 8:
/*  190 */       return toHex(paramLong >> 32, 4) + toHex(paramLong, 4).substring(2);
/*      */     default:
/*  193 */       return "more than 8 bytes";
/*      */     }
/*      */ 
/*  196 */     return "0x" + str.substring(str.length() - 2 * paramInt);
/*      */   }
/*      */ 
/*      */   static String toHex(byte paramByte)
/*      */   {
/*  201 */     String str = "00" + Integer.toHexString(paramByte & 0xFF);
/*  202 */     return "0x" + str.substring(str.length() - 2);
/*      */   }
/*      */ 
/*      */   static String toHex(short paramShort)
/*      */   {
/*  207 */     return toHex(paramShort, 2);
/*      */   }
/*      */ 
/*      */   static String toHex(int paramInt)
/*      */   {
/*  212 */     return toHex(paramInt, 4);
/*      */   }
/*      */ 
/*      */   static String toHex(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/*  217 */     if (paramArrayOfByte == null) {
/*  218 */       return "null";
/*      */     }
/*  220 */     if (paramInt > paramArrayOfByte.length) {
/*  221 */       return "byte array not long enough";
/*      */     }
/*  223 */     String str = "[";
/*  224 */     int i = Math.min(64, paramInt);
/*      */ 
/*  226 */     for (int j = 0; j < i; j++)
/*      */     {
/*  228 */       str = str + toHex(paramArrayOfByte[j]) + " ";
/*      */     }
/*      */ 
/*  231 */     if (i < paramInt) {
/*  232 */       str = str + "...";
/*      */     }
/*  234 */     return str + "]";
/*      */   }
/*      */ 
/*      */   static String toHex(byte[] paramArrayOfByte)
/*      */   {
/*  239 */     if (paramArrayOfByte == null) {
/*  240 */       return "null";
/*      */     }
/*  242 */     return toHex(paramArrayOfByte, paramArrayOfByte.length);
/*      */   }
/*      */ 
/*      */   abstract void marshalSB1(byte paramByte)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalUB1(short paramShort)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalSB2(short paramShort)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalUB2(int paramInt)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalSB4(int paramInt)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalUB4(long paramLong)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalSB8(long paramLong)
/*      */     throws IOException;
/*      */ 
/*      */   final void marshalSWORD(int paramInt)
/*      */     throws IOException
/*      */   {
/*  316 */     marshalSB4(paramInt);
/*      */   }
/*      */ 
/*      */   final void marshalUWORD(long paramLong)
/*      */     throws IOException
/*      */   {
/*  328 */     marshalSB4((int)(paramLong & 0xFFFFFFFF));
/*      */   }
/*      */ 
/*      */   abstract void marshalB1Array(byte[] paramArrayOfByte)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void marshalB1Array(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws IOException;
/*      */ 
/*      */   final void marshalUB4Array(long[] paramArrayOfLong)
/*      */     throws IOException
/*      */   {
/*  356 */     for (int i = 0; i < paramArrayOfLong.length; i++)
/*  357 */       marshalSB4((int)(paramArrayOfLong[i] & 0xFFFFFFFF));
/*      */   }
/*      */ 
/*      */   final void marshalO2U(boolean paramBoolean)
/*      */     throws IOException
/*      */   {
/*  400 */     if (paramBoolean)
/*  401 */       addPtr((byte)1);
/*      */     else
/*  403 */       addPtr((byte)0);
/*      */   }
/*      */ 
/*      */   final void marshalNULLPTR()
/*      */     throws IOException
/*      */   {
/*  419 */     addPtr((byte)0);
/*      */   }
/*      */ 
/*      */   final void marshalPTR()
/*      */     throws IOException
/*      */   {
/*  437 */     addPtr((byte)1);
/*      */   }
/*      */ 
/*      */   final void marshalCHR(byte[] paramArrayOfByte)
/*      */     throws IOException
/*      */   {
/*  452 */     marshalCHR(paramArrayOfByte, 0, paramArrayOfByte.length);
/*      */   }
/*      */ 
/*      */   final void marshalCHR(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws IOException
/*      */   {
/*  460 */     if (paramInt2 > 0)
/*      */     {
/*  462 */       if (this.types.isConvNeeded()) {
/*  463 */         marshalCLR(paramArrayOfByte, paramInt1, paramInt2);
/*      */       }
/*      */       else
/*  466 */         marshalB1Array(paramArrayOfByte, paramInt1, paramInt2);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void marshalCLR(byte[] paramArrayOfByte, int paramInt)
/*      */     throws IOException
/*      */   {
/*  481 */     marshalCLR(paramArrayOfByte, 0, paramInt);
/*      */   }
/*      */ 
/*      */   final void marshalCLR(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws IOException
/*      */   {
/*  491 */     if (paramInt2 > 252)
/*      */     {
/*  493 */       int k = 0;
/*      */ 
/*  497 */       marshalUB1((short)-2);
/*      */       do
/*      */       {
/*  500 */         int i = paramInt2 - k;
/*  501 */         int j = i > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : i;
/*      */ 
/*  504 */         if (this.useCLRBigChunks)
/*      */         {
/*  506 */           marshalSB4(j);
/*      */         }
/*      */         else
/*      */         {
/*  510 */           marshalUB1((short)(byte)(j & 0xFF));
/*      */         }
/*      */ 
/*  513 */         marshalB1Array(paramArrayOfByte, paramInt1 + k, j);
/*      */ 
/*  515 */         k += j;
/*      */       }
/*  517 */       while (k < paramInt2);
/*  518 */       marshalUB1((short)0);
/*      */     }
/*      */     else
/*      */     {
/*  522 */       marshalUB1((short)(byte)(paramInt2 & 0xFF));
/*      */ 
/*  528 */       if (paramArrayOfByte.length != 0)
/*  529 */         marshalB1Array(paramArrayOfByte, paramInt1, paramInt2);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void marshalCLR(InputStream paramInputStream, int paramInt)
/*      */     throws IOException
/*      */   {
/*  546 */     int i = this.effectiveTTCC_MXIN;
/*  547 */     byte[] arrayOfByte = new byte[i];
/*  548 */     int j = 0;
/*  549 */     int k = 0;
/*      */ 
/*  552 */     marshalUB1((short)254);
/*      */     try
/*      */     {
/*  555 */       while (k == 0)
/*      */       {
/*  557 */         j = paramInputStream.read(arrayOfByte, 0, i);
/*  558 */         if (j == -1)
/*      */         {
/*  560 */           k = 1;
/*      */         }
/*      */ 
/*  563 */         if (j > 0)
/*      */         {
/*  565 */           if (this.useCLRBigChunks)
/*      */           {
/*  567 */             marshalSB4(j);
/*      */           }
/*      */           else
/*      */           {
/*  571 */             marshalUB1((short)(byte)(j & 0xFF));
/*      */           }
/*      */ 
/*  575 */           marshalB1Array(arrayOfByte, 0, j);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  582 */       marshalUB1((short)0);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void marshalKEYVAL(byte[][] paramArrayOfByte1, int[] paramArrayOfInt1, byte[][] paramArrayOfByte2, int[] paramArrayOfInt2, byte[] paramArrayOfByte, int paramInt)
/*      */     throws IOException
/*      */   {
/*  597 */     for (int i = 0; i < paramInt; i++)
/*      */     {
/*  599 */       if ((paramArrayOfByte1[i] != null) && (paramArrayOfInt1[i] > 0))
/*      */       {
/*  601 */         marshalUB4(paramArrayOfInt1[i]);
/*  602 */         marshalCLR(paramArrayOfByte1[i], 0, paramArrayOfInt1[i]);
/*      */       }
/*      */       else {
/*  605 */         marshalUB4(0L);
/*      */       }
/*  607 */       if ((paramArrayOfByte2[i] != null) && (paramArrayOfInt2[i] > 0))
/*      */       {
/*  609 */         marshalUB4(paramArrayOfInt2[i]);
/*  610 */         marshalCLR(paramArrayOfByte2[i], 0, paramArrayOfInt2[i]);
/*      */       }
/*      */       else {
/*  613 */         marshalUB4(0L);
/*      */       }
/*      */ 
/*  616 */       if (paramArrayOfByte[i] != 0)
/*  617 */         marshalUB4(1L);
/*      */       else
/*  619 */         marshalUB4(0L);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void marshalKEYVAL(byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2, byte[] paramArrayOfByte, int paramInt)
/*      */     throws IOException
/*      */   {
/*  630 */     int[] arrayOfInt1 = new int[paramInt];
/*  631 */     int[] arrayOfInt2 = new int[paramInt];
/*  632 */     for (int i = 0; i < paramInt; i++)
/*      */     {
/*  634 */       if (paramArrayOfByte1[i] != null)
/*  635 */         arrayOfInt1[i] = paramArrayOfByte1[i].length;
/*  636 */       if (paramArrayOfByte2[i] != null)
/*  637 */         arrayOfInt2[i] = paramArrayOfByte2[i].length;
/*      */     }
/*  639 */     marshalKEYVAL(paramArrayOfByte1, arrayOfInt1, paramArrayOfByte2, arrayOfInt2, paramArrayOfByte, paramInt);
/*      */   }
/*      */ 
/*      */   final void marshalDALC(byte[] paramArrayOfByte)
/*      */     throws IOException
/*      */   {
/*  657 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length < 1))
/*      */     {
/*  659 */       marshalUB4(0L);
/*      */     }
/*      */     else
/*      */     {
/*  663 */       marshalUB4(paramArrayOfByte.length);
/*  664 */       marshalCLR(paramArrayOfByte, paramArrayOfByte.length);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void marshalKPDKV(byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2, int[] paramArrayOfInt)
/*      */     throws IOException
/*      */   {
/*  675 */     for (int i = 0; i < paramArrayOfByte1.length; i++)
/*      */     {
/*  677 */       if (paramArrayOfByte1[i] != null)
/*      */       {
/*  679 */         marshalUB4(paramArrayOfByte1[i].length);
/*  680 */         marshalCLR(paramArrayOfByte1[i], 0, paramArrayOfByte1[i].length);
/*      */       }
/*      */       else {
/*  683 */         marshalUB4(0L);
/*  684 */       }if (paramArrayOfByte2[i] != null)
/*      */       {
/*  686 */         marshalUB4(paramArrayOfByte2[i].length);
/*  687 */         marshalCLR(paramArrayOfByte2[i], 0, paramArrayOfByte2[i].length);
/*      */       }
/*      */       else {
/*  690 */         marshalUB4(0L);
/*  691 */       }marshalUB2(paramArrayOfInt[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   final void unmarshalKPDKV(byte[][] paramArrayOfByte1, int[] paramArrayOfInt1, byte[][] paramArrayOfByte2, int[] paramArrayOfInt2)
/*      */     throws IOException, SQLException
/*      */   {
/*  703 */     int i = 0;
/*  704 */     int[] arrayOfInt = new int[1];
/*      */ 
/*  706 */     for (int j = 0; j < paramArrayOfByte1.length; j++)
/*      */     {
/*  708 */       i = (int)unmarshalUB4();
/*  709 */       if (i > 0)
/*      */       {
/*  711 */         paramArrayOfByte1[j] = new byte[i];
/*  712 */         unmarshalCLR(paramArrayOfByte1[j], 0, arrayOfInt, i);
/*  713 */         paramArrayOfInt1[j] = arrayOfInt[0];
/*      */       }
/*  715 */       i = (int)unmarshalUB4();
/*  716 */       if (i > 0)
/*      */       {
/*  718 */         paramArrayOfByte2[j] = new byte[i];
/*  719 */         unmarshalCLR(paramArrayOfByte2[j], 0, arrayOfInt, i);
/*      */       }
/*  721 */       paramArrayOfInt2[j] = unmarshalUB2();
/*      */     }
/*      */   }
/*      */ 
/*      */   final void addPtr(byte paramByte)
/*      */     throws IOException
/*      */   {
/*  744 */     if (this.types.rep[4] == 1) {
/*  745 */       marshalUB1((short)paramByte);
/*      */     }
/*  749 */     else if (paramByte == 0)
/*      */     {
/*  751 */       marshalB1Array(NULL_PTR);
/*      */     }
/*      */     else
/*      */     {
/*  755 */       marshalB1Array(NOTNULL_PTR);
/*      */     }
/*      */   }
/*      */ 
/*      */   abstract byte unmarshalSB1()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract short unmarshalUB1()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract short unmarshalSB2()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract int unmarshalUB2()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   final int unmarshalUCS2(byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException, IOException
/*      */   {
/*  842 */     int i = unmarshalUB2();
/*      */ 
/*  844 */     this.tmpBuffer2[0] = ((byte)((i & 0xFF00) >> 8));
/*  845 */     this.tmpBuffer2[1] = ((byte)(i & 0xFF));
/*      */ 
/*  848 */     if (paramLong + 1L < paramArrayOfByte.length)
/*      */     {
/*  852 */       paramArrayOfByte[((int)paramLong)] = this.tmpBuffer2[0];
/*  853 */       paramArrayOfByte[((int)paramLong + 1)] = this.tmpBuffer2[1];
/*      */     }
/*      */ 
/*  879 */     return this.tmpBuffer2[0] == 0 ? 2 : this.tmpBuffer2[1] == 0 ? 1 : 3;
/*      */   }
/*      */ 
/*      */   abstract int unmarshalSB4()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract long unmarshalUB4()
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   final int unmarshalSB4(byte[] paramArrayOfByte)
/*      */     throws SQLException, IOException
/*      */   {
/*  926 */     long l = buffer2Value((byte)2, new ByteArrayInputStream(paramArrayOfByte));
/*      */ 
/*  928 */     return (int)l;
/*      */   }
/*      */ 
/*      */   final long unmarshalSB8()
/*      */     throws SQLException, IOException
/*      */   {
/*  949 */     long l = buffer2Value((byte)3);
/*  950 */     return l;
/*      */   }
/*      */ 
/*      */   final int unmarshalRefCursor(byte[] paramArrayOfByte)
/*      */     throws SQLException, IOException
/*      */   {
/*  960 */     int i = unmarshalSB4(paramArrayOfByte);
/*  961 */     return i;
/*      */   }
/*      */ 
/*      */   int unmarshalSWORD()
/*      */     throws SQLException, IOException
/*      */   {
/*  981 */     int i = (int)unmarshalUB4();
/*  982 */     return i;
/*      */   }
/*      */ 
/*      */   long unmarshalUWORD()
/*      */     throws SQLException, IOException
/*      */   {
/* 1001 */     long l = unmarshalUB4();
/* 1002 */     return l;
/*      */   }
/*      */ 
/*      */   abstract byte[] unmarshalNBytes(int paramInt)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract int unmarshalNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract int getNBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract byte[] getNBytes(int paramInt)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   abstract byte[] unmarshalTEXT(int paramInt)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   byte[] unmarshalCHR(int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1085 */     Object localObject = null;
/*      */ 
/* 1087 */     if (this.types.isConvNeeded())
/*      */     {
/* 1089 */       localObject = unmarshalCLR(paramInt, this.retLen);
/*      */ 
/* 1091 */       if (localObject.length != this.retLen[0])
/*      */       {
/* 1093 */         byte[] arrayOfByte = new byte[this.retLen[0]];
/*      */ 
/* 1095 */         System.arraycopy(localObject, 0, arrayOfByte, 0, this.retLen[0]);
/*      */ 
/* 1097 */         localObject = arrayOfByte;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1102 */       localObject = getNBytes(paramInt);
/*      */     }
/*      */ 
/* 1105 */     return localObject;
/*      */   }
/*      */ 
/*      */   void unmarshalCLR(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1114 */     unmarshalCLR(paramArrayOfByte, paramInt, paramArrayOfInt, 2147483647);
/*      */   }
/*      */ 
/*      */   void unmarshalCLR(byte[] paramArrayOfByte, int paramInt1, int[] paramArrayOfInt, int paramInt2)
/*      */     throws SQLException, IOException
/*      */   {
/* 1122 */     unmarshalCLR(paramArrayOfByte, paramInt1, paramArrayOfInt, paramInt2, 0);
/*      */   }
/*      */ 
/*      */   void unmarshalCLR(Object paramObject, long paramLong, int[] paramArrayOfInt, int paramInt1, int paramInt2)
/*      */     throws SQLException, IOException
/*      */   {
/* 1145 */     int i = 0;
/* 1146 */     int j = 0;
/* 1147 */     long l = paramLong;
/* 1148 */     int k = 0;
/* 1149 */     int m = 0;
/* 1150 */     int n = 0;
/* 1151 */     int i1 = 0;
/*      */ 
/* 1157 */     int i2 = -1;
/*      */ 
/* 1159 */     i = unmarshalUB1();
/*      */ 
/* 1162 */     if (i < 0)
/*      */     {
/* 1166 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 1167 */       localSQLException.fillInStackTrace();
/* 1168 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1172 */     if (i == 0)
/*      */     {
/* 1174 */       paramArrayOfInt[0] = 0;
/* 1175 */       return;
/*      */     }
/*      */ 
/* 1178 */     if (escapeSequenceNull(i))
/*      */     {
/* 1180 */       paramArrayOfInt[0] = 0;
/*      */       return;
/*      */     }
/*      */     int i3;
/* 1184 */     if (i != 254)
/*      */     {
/* 1186 */       if (paramInt2 - i1 >= i)
/*      */       {
/* 1189 */         unmarshalBuffer(IGNORED, 0, i);
/* 1190 */         i1 += i;
/*      */ 
/* 1192 */         i = 0;
/*      */       }
/* 1194 */       else if (paramInt2 - i1 > 0)
/*      */       {
/* 1198 */         unmarshalBuffer(IGNORED, 0, paramInt2 - i1);
/*      */ 
/* 1200 */         i -= paramInt2 - i1;
/* 1201 */         i1 += paramInt2 - i1;
/*      */       }
/*      */ 
/* 1204 */       if (i > 0)
/*      */       {
/* 1207 */         n = Math.min(paramInt1 - m, i);
/* 1208 */         l = unmarshalBuffer(paramObject, l, n);
/* 1209 */         m += n;
/*      */ 
/* 1212 */         i3 = i - n;
/*      */ 
/* 1214 */         if (i3 > 0)
/* 1215 */           unmarshalBuffer(IGNORED, 0, i3);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1220 */       i2 = -1;
/*      */       while (true)
/*      */       {
/* 1227 */         if (i2 != -1)
/*      */         {
/* 1229 */           if (this.useCLRBigChunks)
/*      */           {
/* 1231 */             i = unmarshalSB4();
/*      */           }
/*      */           else
/*      */           {
/* 1235 */             i = unmarshalUB1();
/*      */           }
/*      */ 
/* 1239 */           if (i <= 0) {
/*      */             break;
/*      */           }
/*      */         }
/* 1243 */         if (i == 254)
/*      */         {
/* 1245 */           switch (i2)
/*      */           {
/*      */           case -1:
/* 1249 */             i2 = 1;
/*      */ 
/* 1251 */             break;
/*      */           case 1:
/* 1254 */             i2 = 0;
/*      */ 
/* 1256 */             break;
/*      */           case 0:
/* 1259 */             if (k != 0)
/*      */             {
/* 1261 */               i2 = 0;
/*      */             }
/*      */             else
/*      */             {
/* 1267 */               i2 = 0;
/*      */             }
/* 1269 */             break;
/*      */           }
/*      */         }
/*      */         else {
/* 1273 */           if (l == -1L)
/*      */           {
/* 1275 */             unmarshalBuffer(IGNORED, 0, i);
/*      */           }
/*      */           else
/*      */           {
/* 1280 */             j = i;
/* 1281 */             if (paramInt2 - i1 >= j)
/*      */             {
/* 1284 */               unmarshalBuffer(IGNORED, 0, j);
/* 1285 */               i1 += j;
/*      */ 
/* 1287 */               j = 0;
/*      */             }
/* 1289 */             else if (paramInt2 - i1 > 0)
/*      */             {
/* 1293 */               unmarshalBuffer(IGNORED, 0, paramInt2 - i1);
/*      */ 
/* 1295 */               j -= paramInt2 - i1;
/* 1296 */               i1 += paramInt2 - i1;
/*      */             }
/*      */ 
/* 1299 */             if (j > 0)
/*      */             {
/* 1302 */               n = Math.min(paramInt1 - m, j);
/* 1303 */               l = unmarshalBuffer(paramObject, l, n);
/* 1304 */               m += n;
/*      */ 
/* 1307 */               i3 = j - n;
/*      */ 
/* 1309 */               if (i3 > 0) {
/* 1310 */                 unmarshalBuffer(IGNORED, 0, i3);
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/* 1315 */           i2 = 0;
/*      */ 
/* 1317 */           if (i > 252) {
/* 1318 */             k = 1;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1323 */     if (paramArrayOfInt != null)
/*      */     {
/* 1325 */       if (l != -1L) {
/* 1326 */         paramArrayOfInt[0] = m;
/*      */       }
/*      */       else
/*      */       {
/* 1330 */         paramArrayOfInt[0] = (((byte[])(byte[])paramObject).length - (int)paramLong);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   final byte[] unmarshalCLR(int paramInt, int[] paramArrayOfInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1344 */     byte[] arrayOfByte = new byte[paramInt * this.conv.c2sNlsRatio];
/*      */ 
/* 1346 */     unmarshalCLR(arrayOfByte, 0, paramArrayOfInt, paramInt);
/* 1347 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   final int[] unmarshalKEYVAL(byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1357 */     byte[] arrayOfByte = new byte[1000];
/* 1358 */     int[] arrayOfInt1 = new int[1];
/* 1359 */     int[] arrayOfInt2 = new int[paramInt];
/*      */ 
/* 1362 */     for (int j = 0; j < paramInt; j++)
/*      */     {
/* 1364 */       int i = unmarshalSB4();
/*      */ 
/* 1366 */       if (i > 0)
/*      */       {
/* 1368 */         unmarshalCLR(arrayOfByte, 0, arrayOfInt1);
/*      */ 
/* 1370 */         paramArrayOfByte1[j] = new byte[arrayOfInt1[0]];
/*      */ 
/* 1372 */         System.arraycopy(arrayOfByte, 0, paramArrayOfByte1[j], 0, arrayOfInt1[0]);
/*      */       }
/*      */ 
/* 1375 */       i = unmarshalSB4();
/*      */ 
/* 1377 */       if (i > 0)
/*      */       {
/* 1379 */         unmarshalCLR(arrayOfByte, 0, arrayOfInt1);
/*      */ 
/* 1381 */         paramArrayOfByte2[j] = new byte[arrayOfInt1[0]];
/*      */ 
/* 1383 */         System.arraycopy(arrayOfByte, 0, paramArrayOfByte2[j], 0, arrayOfInt1[0]);
/*      */       }
/*      */ 
/* 1386 */       arrayOfInt2[j] = unmarshalSB4();
/*      */     }
/*      */ 
/* 1389 */     arrayOfByte = null;
/*      */ 
/* 1392 */     return arrayOfInt2;
/*      */   }
/*      */ 
/*      */   final long unmarshalBuffer(Object paramObject, long paramLong, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1400 */     if ((paramObject instanceof DynamicByteArray)) {
/* 1401 */       return ((DynamicByteArray)paramObject).unmarshalBuffer(this, paramLong, paramInt);
/*      */     }
/* 1403 */     return unmarshalBuffer((byte[])paramObject, (int)paramLong, paramInt);
/*      */   }
/*      */ 
/*      */   final int unmarshalBuffer(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException, IOException
/*      */   {
/* 1411 */     if (paramInt2 <= 0) {
/* 1412 */       return paramInt1;
/*      */     }
/* 1414 */     if (paramArrayOfByte.length < paramInt1 + paramInt2)
/*      */     {
/* 1416 */       unmarshalNBytes(paramArrayOfByte, paramInt1, paramArrayOfByte.length - paramInt1);
/*      */ 
/* 1419 */       unmarshalNBytes(IGNORED, 0, paramInt1 + paramInt2 - paramArrayOfByte.length);
/*      */ 
/* 1421 */       paramInt1 = -1;
/*      */     }
/*      */     else
/*      */     {
/* 1427 */       unmarshalNBytes(paramArrayOfByte, paramInt1, paramInt2);
/*      */ 
/* 1429 */       paramInt1 += paramInt2;
/*      */     }
/* 1431 */     return paramInt1;
/*      */   }
/*      */ 
/*      */   final byte[] unmarshalCLRforREFS()
/*      */     throws SQLException, IOException
/*      */   {
/* 1441 */     int i = 0;
/* 1442 */     int j = 0;
/* 1443 */     byte[] arrayOfByte1 = null;
/*      */ 
/* 1446 */     int k = unmarshalUB1();
/*      */ 
/* 1450 */     if (k < 0)
/*      */     {
/* 1454 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 1455 */       localSQLException.fillInStackTrace();
/* 1456 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1460 */     if (k == 0)
/*      */     {
/* 1462 */       return null;
/*      */     }
/*      */ 
/* 1466 */     boolean bool = escapeSequenceNull(k);
/* 1467 */     if (!bool)
/*      */     {
/* 1469 */       if (this.refVector == null)
/* 1470 */         this.refVector = new ArrayList(10);
/*      */       else {
/* 1472 */         this.refVector.clear();
/*      */       }
/*      */     }
/* 1475 */     if (!bool)
/*      */     {
/* 1477 */       if (k == 254)
/*      */       {
/* 1481 */         while ((i = this.useCLRBigChunks ? unmarshalSB4() : unmarshalUB1()) > 0)
/*      */         {
/* 1487 */           if ((i != 254) || 
/* 1489 */             (!this.types.isServerConversion()))
/*      */           {
/* 1493 */             j = (short)(j + i);
/* 1494 */             arrayOfByte2 = new byte[i];
/*      */ 
/* 1496 */             unmarshalBuffer(arrayOfByte2, 0, i);
/* 1497 */             this.refVector.add(arrayOfByte2);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1502 */       j = k;
/*      */ 
/* 1504 */       byte[] arrayOfByte2 = new byte[k];
/*      */ 
/* 1506 */       unmarshalBuffer(arrayOfByte2, 0, k);
/* 1507 */       this.refVector.add(arrayOfByte2);
/*      */ 
/* 1511 */       arrayOfByte1 = new byte[j];
/*      */ 
/* 1513 */       int m = 0;
/*      */ 
/* 1515 */       while (this.refVector.size() > 0)
/*      */       {
/* 1517 */         int n = ((byte[])this.refVector.get(0)).length;
/*      */ 
/* 1519 */         System.arraycopy(this.refVector.get(0), 0, arrayOfByte1, m, n);
/*      */ 
/* 1522 */         m += n;
/*      */ 
/* 1526 */         this.refVector.remove(0);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1532 */       arrayOfByte1 = null;
/*      */     }
/* 1534 */     return arrayOfByte1;
/*      */   }
/*      */ 
/*      */   final boolean escapeSequenceNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1547 */     boolean bool = false;
/*      */ 
/* 1549 */     switch (paramInt)
/*      */     {
/*      */     case 0:
/* 1555 */       bool = true;
/*      */ 
/* 1557 */       break;
/*      */     case 253:
/* 1562 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 1563 */       localSQLException.fillInStackTrace();
/* 1564 */       throw localSQLException;
/*      */     case 255:
/* 1574 */       bool = true;
/* 1575 */       break;
/*      */     case 254:
/* 1584 */       break;
/*      */     }
/*      */ 
/* 1592 */     return bool;
/*      */   }
/*      */ 
/*      */   final int processIndicator(boolean paramBoolean, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1605 */     int i = unmarshalSB2();
/* 1606 */     int j = 0;
/*      */ 
/* 1608 */     if (!paramBoolean)
/*      */     {
/* 1610 */       if (i == 0)
/* 1611 */         j = paramInt;
/* 1612 */       else if ((i == -2) || (i > 0)) {
/* 1613 */         j = i;
/*      */       }
/*      */       else
/*      */       {
/* 1617 */         j = 65536 + i;
/*      */       }
/*      */     }
/* 1619 */     return j;
/*      */   }
/*      */ 
/*      */   final long unmarshalDALC(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1638 */     long l = unmarshalUB4();
/*      */ 
/* 1640 */     if (l > 0L)
/* 1641 */       unmarshalCLR(paramArrayOfByte, paramInt, paramArrayOfInt);
/* 1642 */     return l;
/*      */   }
/*      */ 
/*      */   final byte[] unmarshalDALC()
/*      */     throws SQLException, IOException
/*      */   {
/* 1650 */     long l = unmarshalUB4();
/* 1651 */     byte[] arrayOfByte = new byte[(int)(0xFFFFFFFF & l)];
/*      */ 
/* 1653 */     if (arrayOfByte.length > 0)
/*      */     {
/* 1655 */       arrayOfByte = unmarshalCLR(arrayOfByte.length, this.retLen);
/*      */ 
/* 1657 */       if (arrayOfByte == null)
/*      */       {
/* 1661 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 1662 */         localSQLException.fillInStackTrace();
/* 1663 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1668 */       arrayOfByte = new byte[0];
/* 1669 */     }return arrayOfByte;
/*      */   }
/*      */ 
/*      */   final byte[] unmarshalDALC(int[] paramArrayOfInt)
/*      */     throws SQLException, IOException
/*      */   {
/* 1677 */     long l = unmarshalUB4();
/* 1678 */     byte[] arrayOfByte = new byte[(int)(0xFFFFFFFF & l)];
/*      */ 
/* 1681 */     if (arrayOfByte.length > 0)
/*      */     {
/* 1683 */       arrayOfByte = unmarshalCLR(arrayOfByte.length, paramArrayOfInt);
/*      */ 
/* 1685 */       if (arrayOfByte == null)
/*      */       {
/* 1690 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 1691 */         localSQLException.fillInStackTrace();
/* 1692 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1697 */       arrayOfByte = new byte[0];
/* 1698 */     }return arrayOfByte;
/*      */   }
/*      */ 
/*      */   abstract long buffer2Value(byte paramByte)
/*      */     throws SQLException, IOException;
/*      */ 
/*      */   final long buffer2Value(byte paramByte, ByteArrayInputStream paramByteArrayInputStream)
/*      */     throws SQLException, IOException
/*      */   {
/* 1736 */     int j = 0;
/*      */ 
/* 1738 */     long l = 0L;
/* 1739 */     int k = 0;
/*      */     SQLException localSQLException;
/* 1742 */     if ((this.types.rep[paramByte] & 0x1) > 0)
/*      */     {
/* 1744 */       j = paramByteArrayInputStream.read();
/*      */ 
/* 1747 */       if ((j & 0x80) > 0)
/*      */       {
/* 1749 */         j &= 127;
/* 1750 */         k = 1;
/*      */       }
/*      */ 
/* 1753 */       if (j < 0)
/*      */       {
/* 1758 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 1759 */         localSQLException.fillInStackTrace();
/* 1760 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1767 */       if (j == 0)
/*      */       {
/* 1770 */         return 0L;
/*      */       }
/*      */ 
/* 1774 */       if (((paramByte == 1) && (j > 2)) || ((paramByte == 2) && (j > 4)))
/*      */       {
/* 1780 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 412);
/* 1781 */         localSQLException.fillInStackTrace();
/* 1782 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/* 1789 */     else if (paramByte == 1) {
/* 1790 */       j = 2;
/* 1791 */     } else if (paramByte == 2) {
/* 1792 */       j = 4;
/*      */     }
/*      */ 
/* 1800 */     byte[] arrayOfByte = new byte[j];
/*      */ 
/* 1802 */     if (paramByteArrayInputStream.read(arrayOfByte) < 0)
/*      */     {
/* 1807 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 410);
/* 1808 */       localSQLException.fillInStackTrace();
/* 1809 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1813 */     for (int m = 0; m < arrayOfByte.length; m++)
/*      */     {
/*      */       int i;
/* 1816 */       if ((this.types.rep[paramByte] & 0x2) > 0)
/* 1817 */         i = (short)(arrayOfByte[(arrayOfByte.length - 1 - m)] & 0xFF);
/*      */       else {
/* 1819 */         i = (short)(arrayOfByte[m] & 0xFF);
/*      */       }
/* 1821 */       l |= i << 8 * (arrayOfByte.length - 1 - m);
/*      */     }
/*      */ 
/* 1825 */     l &= -1L;
/*      */ 
/* 1827 */     if (k != 0) {
/* 1828 */       l = -l;
/*      */     }
/* 1830 */     return l;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1845 */     return (OracleConnection)this.connForException.get();
/*      */   }
/*      */ 
/*      */   protected void setConnectionDuringExceptionHandling(OracleConnection paramOracleConnection)
/*      */   {
/* 1856 */     this.connForException.set(paramOracleConnection);
/*      */   }
/*      */ 
/*      */   protected abstract void flush()
/*      */     throws IOException;
/*      */ 
/*      */   abstract void setByteOrder(byte paramByte)
/*      */     throws IOException;
/*      */ 
/*      */   abstract void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws IOException, NetException;
/*      */ 
/*      */   boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*      */     throws IOException, NetException
/*      */   {
/* 1894 */     boolean bool = this.net.readZeroCopyIO(paramArrayOfByte, paramInt, paramArrayOfInt);
/* 1895 */     return bool;
/*      */   }
/*      */ 
/*      */   void setUseCLRBigChunks(boolean paramBoolean)
/*      */   {
/* 1902 */     this.useCLRBigChunks = paramBoolean;
/*      */ 
/* 1904 */     if (paramBoolean == true)
/*      */     {
/* 1906 */       this.effectiveTTCC_MXIN = 32767;
/*      */     }
/*      */     else
/*      */     {
/* 1912 */       if (!$assertionsDisabled) throw new AssertionError();
/* 1913 */       this.effectiveTTCC_MXIN = 64;
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CMAREngine
 * JD-Core Version:    0.6.2
 */