/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CLongRawAccessor extends LongRawAccessor
/*     */   implements T4CAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  31 */   byte[][] data = (byte[][])null;
/*  32 */   int[] nbBytesRead = null;
/*  33 */   int[] bytesReadSoFar = null;
/*     */ 
/* 270 */   private T4CMarshaller marshaller = null;
/*     */ 
/* 319 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CLongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  39 */     super(paramOracleStatement, paramInt1, paramInt2, paramShort, paramInt3);
/*     */ 
/*  42 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  44 */     if (paramOracleStatement.isFetchStreams)
/*     */     {
/*  46 */       this.data = new byte[paramOracleStatement.rowPrefetch][];
/*     */ 
/*  48 */       for (int i = 0; i < paramOracleStatement.rowPrefetch; i++) {
/*  49 */         this.data[i] = new byte[4080];
/*     */       }
/*  51 */       this.nbBytesRead = new int[paramOracleStatement.rowPrefetch];
/*  52 */       this.bytesReadSoFar = new int[paramOracleStatement.rowPrefetch];
/*     */     }
/*     */   }
/*     */ 
/*     */   T4CLongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort, int paramInt8, int paramInt9, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  63 */     super(paramOracleStatement, paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort);
/*     */ 
/*  66 */     this.mare = paramT4CMAREngine;
/*  67 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  69 */       this.definedColumnType = 0;
/*  70 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  74 */       this.definedColumnType = paramInt8;
/*  75 */       this.definedColumnSize = paramInt9;
/*     */     }
/*     */ 
/*  78 */     if (paramOracleStatement.isFetchStreams)
/*     */     {
/*  80 */       this.data = new byte[paramOracleStatement.rowPrefetch][];
/*     */ 
/*  82 */       for (int i = 0; i < paramOracleStatement.rowPrefetch; i++) {
/*  83 */         this.data[i] = new byte[4080];
/*     */       }
/*  85 */       this.nbBytesRead = new int[paramOracleStatement.rowPrefetch];
/*  86 */       this.bytesReadSoFar = new int[paramOracleStatement.rowPrefetch];
/*     */     }
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  93 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/* 102 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/* 105 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 112 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 119 */       this.mare.unmarshalUB2();
/* 120 */       this.mare.unmarshalUB2();
/*     */     }
/* 122 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 126 */       this.mare.unmarshalSB2();
/*     */ 
/* 128 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 129 */         this.mare.unmarshalSB2();
/*     */     }
/* 131 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 132 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 138 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 139 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 149 */     return getMarshaller().unmarshalOneRow(this);
/*     */   }
/*     */ 
/*     */   int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */     throws SQLException, IOException
/*     */   {
/* 160 */     return getMarshaller().readStreamFromWire(paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt, paramArrayOfBoolean1, paramArrayOfBoolean2, paramT4CMAREngine, paramT4CTTIoer);
/*     */   }
/*     */ 
/*     */   void fetchNextColumns()
/*     */     throws SQLException
/*     */   {
/* 176 */     this.statement.continueReadRow(this.columnPosition);
/*     */   }
/*     */ 
/*     */   int readStream(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 195 */     int i = this.lastRowProcessed;
/*     */ 
/* 197 */     if (this.statement.isFetchStreams) {
/* 198 */       j = getLength(i);
/* 199 */       int k = this.bytesReadSoFar[i];
/*     */ 
/* 201 */       if (k == j) return -1;
/*     */ 
/* 203 */       int m = 0;
/* 204 */       if (paramInt <= j - k) m = paramInt; else
/* 205 */         m = j - k;
/* 206 */       this.rowData.setPosition(getOffset(i) + k);
/* 207 */       this.rowData.getBytes(paramArrayOfByte, 0, m);
/* 208 */       this.bytesReadSoFar[i] += m;
/* 209 */       return m;
/*     */     }
/*     */ 
/* 214 */     int j = readStreamFromWire(paramArrayOfByte, 0, paramInt, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
/*     */ 
/* 217 */     if ((this.statement.connection.checksumMode.needToCalculateFetchChecksum()) && (j != -1))
/*     */     {
/* 219 */       long l = CRC64.updateChecksum(this.statement.checkSum, paramArrayOfByte, 0, j);
/*     */ 
/* 223 */       this.statement.checkSum = l;
/*     */     }
/*     */ 
/* 226 */     return j;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 237 */     if (this.isNullByDescribe) {
/* 238 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 240 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 245 */       if (this.previousRowProcessed == -1)
/* 246 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 247 */       long l = getOffset(this.previousRowProcessed);
/* 248 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 249 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 250 */       if (!isNull(this.previousRowProcessed)) {
/* 251 */         setOffset(this.lastRowProcessed);
/* 252 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 253 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 258 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 259 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 260 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 261 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 263 */     this.previousRowProcessed = this.lastRowProcessed;
/* 264 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   private final T4CMarshaller getMarshaller()
/*     */   {
/* 272 */     if (this.marshaller == null) {
/* 273 */       this.marshaller = (this.describeType == 23 ? T4CMarshaller.RAW : T4CMarshaller.LONG_RAW);
/*     */     }
/*     */ 
/* 277 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   boolean isNullByDescribe()
/*     */   {
/* 283 */     return false;
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 290 */     String str = super.getString(paramInt);
/*     */ 
/* 294 */     if ((str != null) && (this.definedColumnSize > 0) && (str.length() > this.definedColumnSize * 2))
/*     */     {
/* 296 */       str = str.substring(0, this.definedColumnSize * 2);
/*     */     }
/* 298 */     return str;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 306 */     if (isNull(paramInt))
/*     */     {
/* 308 */       paramLong = CRC64.updateChecksum(paramLong, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
/*     */     }
/*     */ 
/* 314 */     return paramLong;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CLongRawAccessor
 * JD-Core Version:    0.6.2
 */