/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CLongAccessor extends LongAccessor
/*     */   implements T4CAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*     */   static final int PLSQL_MAXLENGTH = 32760;
/*  32 */   byte[][] data = (byte[][])null;
/*  33 */   int[] nbBytesRead = null;
/*  34 */   int[] bytesReadSoFar = null;
/*     */ 
/* 271 */   private T4CMarshaller marshaller = null;
/*     */ 
/* 303 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CLongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(paramOracleStatement, paramInt1, paramInt2, paramShort, paramInt3);
/*     */ 
/*  43 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  45 */     if (paramOracleStatement.isFetchStreams)
/*     */     {
/*  47 */       this.data = new byte[paramOracleStatement.rowPrefetch][];
/*     */ 
/*  49 */       for (int i = 0; i < paramOracleStatement.rowPrefetch; i++) {
/*  50 */         this.data[i] = new byte[4080];
/*     */       }
/*  52 */       this.nbBytesRead = new int[paramOracleStatement.rowPrefetch];
/*  53 */       this.bytesReadSoFar = new int[paramOracleStatement.rowPrefetch];
/*     */     }
/*     */   }
/*     */ 
/*     */   T4CLongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort, int paramInt8, int paramInt9, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  64 */     super(paramOracleStatement, paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort);
/*     */ 
/*  67 */     this.mare = paramT4CMAREngine;
/*  68 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  70 */       this.definedColumnType = 0;
/*  71 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  75 */       this.definedColumnType = paramInt8;
/*  76 */       this.definedColumnSize = paramInt9;
/*     */     }
/*     */ 
/*  79 */     if (paramOracleStatement.isFetchStreams)
/*     */     {
/*  81 */       this.data = new byte[paramOracleStatement.rowPrefetch][];
/*     */ 
/*  83 */       for (int i = 0; i < paramOracleStatement.rowPrefetch; i++) {
/*  84 */         this.data[i] = new byte[4080];
/*     */       }
/*  86 */       this.nbBytesRead = new int[paramOracleStatement.rowPrefetch];
/*  87 */       this.bytesReadSoFar = new int[paramOracleStatement.rowPrefetch];
/*     */     }
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  94 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/* 103 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/* 106 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 113 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 120 */       this.mare.unmarshalUB2();
/* 121 */       this.mare.unmarshalUB2();
/*     */     }
/* 123 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 127 */       this.mare.unmarshalSB2();
/*     */ 
/* 129 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 130 */         this.mare.unmarshalSB2();
/*     */     }
/* 132 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 133 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 139 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 140 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 151 */     if (this.isNullByDescribe) {
/* 152 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 154 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 159 */       if (this.previousRowProcessed == -1)
/* 160 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 161 */       long l = getOffset(this.previousRowProcessed);
/* 162 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 163 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 164 */       if (!isNull(this.previousRowProcessed)) {
/* 165 */         setOffset(this.lastRowProcessed);
/* 166 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 167 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 172 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 173 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 174 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 175 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 177 */     this.previousRowProcessed = this.lastRowProcessed;
/* 178 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 187 */     return getMarshaller().unmarshalOneRow(this);
/*     */   }
/*     */ 
/*     */   int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */     throws SQLException, IOException
/*     */   {
/* 198 */     return getMarshaller().readStreamFromWire(paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt, paramArrayOfBoolean1, paramArrayOfBoolean2, paramT4CMAREngine, paramT4CTTIoer);
/*     */   }
/*     */ 
/*     */   void fetchNextColumns()
/*     */     throws SQLException
/*     */   {
/* 214 */     this.statement.continueReadRow(this.columnPosition);
/*     */   }
/*     */ 
/*     */   int readStream(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 233 */     int i = this.lastRowProcessed;
/*     */ 
/* 235 */     if (this.statement.isFetchStreams) {
/* 236 */       j = getLength(i);
/* 237 */       int k = this.bytesReadSoFar[i];
/*     */ 
/* 239 */       if (k == j) return -1;
/*     */ 
/* 241 */       int m = 0;
/* 242 */       if (paramInt <= j - k) m = paramInt; else
/* 243 */         m = j - k;
/* 244 */       this.rowData.setPosition(getOffset(i) + k);
/* 245 */       this.rowData.getBytes(paramArrayOfByte, 0, m);
/* 246 */       this.bytesReadSoFar[i] += m;
/* 247 */       return m;
/*     */     }
/*     */ 
/* 252 */     int j = readStreamFromWire(paramArrayOfByte, 0, paramInt, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
/*     */ 
/* 255 */     if ((this.statement.connection.checksumMode.needToCalculateFetchChecksum()) && (j != -1))
/*     */     {
/* 257 */       long l = CRC64.updateChecksum(this.statement.checkSum, paramArrayOfByte, 0, j);
/*     */ 
/* 261 */       this.statement.checkSum = l;
/*     */     }
/*     */ 
/* 264 */     return j;
/*     */   }
/*     */ 
/*     */   private final T4CMarshaller getMarshaller()
/*     */   {
/* 273 */     if (this.marshaller == null) this.marshaller = ((this.describeType == 8) || (this.describeType == 112) ? T4CMarshaller.LONG : T4CMarshaller.VARCHAR);
/*     */ 
/* 277 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   boolean isNullByDescribe()
/*     */   {
/* 283 */     return false;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 290 */     if (isNull(paramInt))
/*     */     {
/* 292 */       paramLong = CRC64.updateChecksum(paramLong, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
/*     */     }
/*     */ 
/* 298 */     return paramLong;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CLongAccessor
 * JD-Core Version:    0.6.2
 */