/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T4CKvaldfList
/*     */ {
/*     */   static final int INTIAL_CAPACITY = 30;
/*     */   private int capacity;
/*     */   private int offset;
/*     */   private byte[][] keys;
/*     */   private byte[][] values;
/*     */   private byte[] flags;
/*     */   DBConversion conv;
/* 138 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CKvaldfList(DBConversion paramDBConversion)
/*     */   {
/*  54 */     this.conv = paramDBConversion;
/*  55 */     initializeList();
/*     */   }
/*     */ 
/*     */   void initializeList()
/*     */   {
/*  62 */     this.capacity = 30;
/*  63 */     this.offset = 0;
/*  64 */     this.keys = new byte[this.capacity][];
/*  65 */     this.values = new byte[this.capacity][];
/*  66 */     this.flags = new byte[this.capacity];
/*     */   }
/*     */ 
/*     */   void add(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte paramByte)
/*     */   {
/*  73 */     if (this.offset == this.capacity)
/*     */     {
/*  75 */       byte[][] arrayOfByte1 = new byte[this.capacity * 2][];
/*  76 */       byte[][] arrayOfByte2 = new byte[this.capacity * 2][];
/*  77 */       byte[] arrayOfByte = new byte[this.capacity * 2];
/*  78 */       System.arraycopy(this.keys, 0, arrayOfByte1, 0, this.capacity);
/*  79 */       System.arraycopy(this.values, 0, arrayOfByte2, 0, this.capacity);
/*  80 */       System.arraycopy(this.flags, 0, arrayOfByte, 0, this.capacity);
/*  81 */       this.keys = arrayOfByte1;
/*  82 */       this.values = arrayOfByte2;
/*  83 */       this.flags = arrayOfByte;
/*  84 */       this.capacity *= 2;
/*     */     }
/*  86 */     this.keys[this.offset] = paramArrayOfByte1;
/*  87 */     this.values[this.offset] = paramArrayOfByte2;
/*  88 */     this.flags[(this.offset++)] = paramByte;
/*     */   }
/*     */ 
/*     */   void add(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */   {
/*  95 */     add(paramArrayOfByte1, paramArrayOfByte2, (byte)0);
/*     */   }
/*     */ 
/*     */   void add(String paramString, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 102 */     add(this.conv.StringToCharBytes(paramString), paramArrayOfByte, (byte)0);
/*     */   }
/*     */ 
/*     */   void add(String paramString, byte[] paramArrayOfByte, byte paramByte)
/*     */     throws SQLException
/*     */   {
/* 108 */     add(this.conv.StringToCharBytes(paramString), paramArrayOfByte, paramByte);
/*     */   }
/*     */ 
/*     */   int size()
/*     */   {
/* 115 */     return this.offset;
/*     */   }
/*     */ 
/*     */   byte[][] getKeys()
/*     */   {
/* 121 */     return this.keys;
/*     */   }
/*     */ 
/*     */   byte[][] getValues()
/*     */   {
/* 127 */     return this.values;
/*     */   }
/*     */ 
/*     */   byte[] getFlags()
/*     */   {
/* 133 */     return this.flags;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CKvaldfList
 * JD-Core Version:    0.6.2
 */