/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CIntervalymAccessor extends IntervalymAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/* 268 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  32 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  41 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  44 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  51 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  58 */       this.mare.unmarshalUB2();
/*  59 */       this.mare.unmarshalUB2();
/*     */     }
/*  61 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  65 */       this.mare.unmarshalSB2();
/*     */ 
/*  67 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/*  68 */         this.mare.unmarshalSB2();
/*     */     }
/*  70 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/*  71 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/*  77 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/*  78 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/*  93 */     boolean bool = false;
/*  94 */     if (!isUseless())
/*     */     {
/* 100 */       if (isUnexpected())
/*     */       {
/* 103 */         long l = this.rowData.getPosition();
/* 104 */         unmarshalColumnMetadata();
/* 105 */         unmarshalBytes();
/* 106 */         this.rowData.setPosition(l);
/* 107 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 109 */       else if (isNullByDescribe())
/*     */       {
/* 112 */         setNull(this.lastRowProcessed, true);
/* 113 */         unmarshalColumnMetadata();
/* 114 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 118 */         unmarshalColumnMetadata();
/* 119 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 121 */     this.previousRowProcessed = this.lastRowProcessed;
/* 122 */     this.lastRowProcessed += 1;
/* 123 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 135 */     setOffset(this.lastRowProcessed);
/*     */     int i;
/* 136 */     if (this.statement.maxFieldSize > 0)
/* 137 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize);
/*     */     else
/* 139 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 140 */     processIndicator(i);
/* 141 */     setLength(this.lastRowProcessed, i);
/* 142 */     setNull(this.lastRowProcessed, i == 0);
/* 143 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 152 */     if (this.isNullByDescribe) {
/* 153 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 155 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 160 */       if (this.previousRowProcessed == -1)
/* 161 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 162 */       long l = getOffset(this.previousRowProcessed);
/* 163 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 164 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 165 */       if (!isNull(this.previousRowProcessed)) {
/* 166 */         setOffset(this.lastRowProcessed);
/* 167 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 168 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 173 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 174 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 175 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 176 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 178 */     this.previousRowProcessed = this.lastRowProcessed;
/* 179 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   T4CIntervalymAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 194 */     super(paramOracleStatement, 5, paramShort, paramInt2, paramBoolean);
/*     */ 
/* 196 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CIntervalymAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/* 214 */     super(paramOracleStatement, 5, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/* 225 */     this.mare = paramT4CMAREngine;
/* 226 */     this.definedColumnType = paramInt7;
/* 227 */     this.definedColumnSize = paramInt8;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 235 */     if (this.definedColumnType == 0)
/* 236 */       return super.getObject(paramInt);
/* 237 */     if (isNull(paramInt)) return null;
/*     */ 
/* 239 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -15:
/*     */     case -9:
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 246 */       return getString(paramInt);
/*     */     case -103:
/* 249 */       return getINTERVALYM(paramInt);
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 254 */       return getBytes(paramInt);
/*     */     }
/*     */ 
/* 258 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 259 */     localSQLException.fillInStackTrace();
/* 260 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CIntervalymAccessor
 * JD-Core Version:    0.6.2
 */