/*    */ package oracle.jdbc.driver;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.sql.SQLException;
/*    */ 
/*    */ class T4CInputStream extends OracleInputStream
/*    */ {
/* 96 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*    */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*    */   public static final boolean TRACE = false;
/*    */ 
/*    */   T4CInputStream(OracleStatement paramOracleStatement, int paramInt, Accessor paramAccessor)
/*    */   {
/* 25 */     super(paramOracleStatement, paramInt, paramAccessor);
/*    */   }
/*    */ 
/*    */   public boolean isNull()
/*    */     throws IOException
/*    */   {
/* 33 */     if (!this.statement.isFetchStreams) {
/* 34 */       return super.isNull();
/*    */     }
/* 36 */     boolean bool = false;
/*    */     try
/*    */     {
/* 40 */       int i = this.statement.currentResultSet.getRow();
/*    */ 
/* 42 */       if (i < 0) {
/* 43 */         i = 0;
/*    */       }
/* 45 */       if (i >= this.statement.validRows) {
/* 46 */         return true;
/*    */       }
/* 48 */       bool = this.statement.isNull(i, this.columnIndex);
/*    */     }
/*    */     catch (SQLException localSQLException)
/*    */     {
/* 53 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 54 */       localIOException.fillInStackTrace();
/* 55 */       throw localIOException;
/*    */     }
/*    */ 
/* 59 */     return bool;
/*    */   }
/*    */ 
/*    */   public int getBytes(int paramInt)
/*    */     throws IOException
/*    */   {
/* 66 */     synchronized (this.statement.connection) {
/* 67 */       int i = -1;
/*    */       try
/*    */       {
/* 71 */         if ((this.statement.connection.lifecycle == 1) || (this.statement.connection.lifecycle == 2))
/*    */         {
/* 73 */           i = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
/*    */         }
/*    */       }
/*    */       catch (SQLException localSQLException1) {
/* 77 */         throw new IOException(localSQLException1.getMessage());
/*    */       }
/*    */       catch (IOException localIOException)
/*    */       {
/*    */         try
/*    */         {
/* 84 */           ((T4CConnection)this.statement.connection).handleIOException(localIOException);
/*    */         }
/*    */         catch (SQLException localSQLException2) {
/*    */         }
/* 88 */         throw localIOException;
/*    */       }
/*    */ 
/* 91 */       return i;
/*    */     }
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CInputStream
 * JD-Core Version:    0.6.2
 */