/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.io.Writer;
/*      */ import java.lang.reflect.Field;
/*      */ import java.net.SocketException;
/*      */ import java.security.NoSuchAlgorithmException;
/*      */ import java.security.spec.InvalidKeySpecException;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.EnumSet;
/*      */ import java.util.HashMap;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.concurrent.Executor;
/*      */ import java.util.zip.CRC32;
/*      */ import oracle.jdbc.LogicalTransactionId;
/*      */ import oracle.jdbc.LogicalTransactionIdEventListener;
/*      */ import oracle.jdbc.NotificationRegistration.RegistrationState;
/*      */ import oracle.jdbc.OracleConnection.CommitOption;
/*      */ import oracle.jdbc.OracleConnection.DatabaseShutdownMode;
/*      */ import oracle.jdbc.OracleConnection.DatabaseStartupMode;
/*      */ import oracle.jdbc.aq.AQDequeueOptions;
/*      */ import oracle.jdbc.aq.AQEnqueueOptions;
/*      */ import oracle.jdbc.internal.JMSDequeueOptions;
/*      */ import oracle.jdbc.internal.JMSEnqueueOptions;
/*      */ import oracle.jdbc.internal.JMSMessageProperties;
/*      */ import oracle.jdbc.internal.JMSNotificationRegistration;
/*      */ import oracle.jdbc.internal.KeywordValue;
/*      */ import oracle.jdbc.internal.KeywordValueLong;
/*      */ import oracle.jdbc.internal.OracleBfile;
/*      */ import oracle.jdbc.internal.OracleBlob;
/*      */ import oracle.jdbc.internal.OracleClob;
/*      */ import oracle.jdbc.internal.OracleConnection.EndReplayCallback;
/*      */ import oracle.jdbc.internal.OracleConnection.InstanceProperty;
/*      */ import oracle.jdbc.internal.OracleConnection.ReplayOperation;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.internal.OracleConnection.XSOperationCode;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionModeFlag;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionOperationCode;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionSetOperationCode;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.internal.PDBChangeEventListener;
/*      */ import oracle.jdbc.internal.ReplayContext;
/*      */ import oracle.jdbc.internal.XSEventListener;
/*      */ import oracle.jdbc.internal.XSKeyval;
/*      */ import oracle.jdbc.internal.XSNamespace;
/*      */ import oracle.jdbc.internal.XSPrincipal;
/*      */ import oracle.jdbc.internal.XSSecureId;
/*      */ import oracle.jdbc.internal.XSSessionParameters;
/*      */ import oracle.jdbc.pool.OraclePooledConnection;
/*      */ import oracle.net.ns.Communication;
/*      */ import oracle.net.ns.NSProtocolNIO;
/*      */ import oracle.net.ns.NSProtocolStream;
/*      */ import oracle.net.ns.NetException;
/*      */ import oracle.net.ns.SessionAtts;
/*      */ import oracle.net.nt.ConnOption;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.BfileDBAccess;
/*      */ import oracle.sql.BlobDBAccess;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ClobDBAccess;
/*      */ import oracle.sql.LobPlsqlUtil;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ class T4CConnection extends PhysicalConnection
/*      */   implements BfileDBAccess, BlobDBAccess, ClobDBAccess
/*      */ {
/*      */   static final short MIN_TTCVER_SUPPORTED = 4;
/*      */   static final short V8_TTCVER_SUPPORTED = 5;
/*      */   static final short MAX_TTCVER_SUPPORTED = 6;
/*      */   static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
/*      */   static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
/*      */   static final int REFCURSOR_SIZE = 5;
/*  119 */   long LOGON_MODE = 0L;
/*      */   boolean isLoggedOn;
/*      */   private boolean useZeroCopyIO;
/*      */   boolean useLobPrefetch;
/*      */   private String password;
/*      */   Communication net;
/*      */   int eocs;
/*  153 */   private NTFEventListener[] ltxidListeners = new NTFEventListener[0];
/*      */ 
/*  155 */   private NTFEventListener[] xsListeners = new NTFEventListener[0];
/*      */ 
/*  159 */   NTFEventListener pdbChangeListener = null;
/*      */   boolean readAsNonStream;
/*      */   T4CTTIoer oer;
/*      */   T4CMAREngine mare;
/*      */   T4C8TTIpro pro;
/*      */   T4CTTIrxd rxd;
/*      */   T4CTTIsto sto;
/*      */   T4CTTIspfp spfp;
/*      */   T4CTTIoauthenticate auth;
/*      */   T4C8Odscrarr describe;
/*      */   T4C8Oall all8;
/*      */   T4C8Oclose close8;
/*      */   T4C7Ocommoncall commoncall;
/*      */   T4Caqe aqe;
/*      */   T4Caqdq aqdq;
/*      */   T4CTTIoaqenq oaqenq;
/*      */   T4CTTIoaqdeq oaqdeq;
/*      */   T4CTTIkpdnrdeq kpdnrdeq;
/*      */   T4C8TTIBfile bfileMsg;
/*      */   T4C8TTIBlob blobMsg;
/*      */   T4C8TTIClob clobMsg;
/*      */   T4CTTIoses oses;
/*      */   T4CTTIoping oping;
/*      */   T4CTTIokpn okpn;
/*  193 */   byte[] EMPTY_BYTE = new byte[0];
/*      */   T4CTTIOtxen otxen;
/*      */   T4CTTIOtxse otxse;
/*      */   T4CTTIk2rpc k2rpc;
/*      */   T4CTTIoscid oscid;
/*      */   T4CTTIokeyval okeyval;
/*      */   T4CTTIoxsscs oxsscs;
/*      */   T4CTTIoxssro oxssro;
/*      */   T4CTTIoxsspo oxsspo;
/*      */   T4CTTIxsnsop xsnsop;
/*      */   T4CTTIosesstate osesstate;
/*      */   T4CTTIoappcontreplay oappcontreplay;
/*      */   T4CTTIoxsns xsnsop2;
/*      */   T4CTTIoxscre oxscre;
/*      */   T4CTTIoxsdes oxsdes;
/*      */   T4CTTIoxsdet oxsdet;
/*      */   T4CTTIoxsatt oxsatt;
/*      */   T4CTTIoxsset oxsset;
/*      */   T4CTTIosessrls osessrls;
/*      */   T4CTTIosessget osessget;
/*      */   T4CTTIocsessret ocsessret;
/*      */   int[] cursorToClose;
/*      */   int cursorToCloseOffset;
/*      */   int[] queryToClose;
/*      */   int queryToCloseOffset;
/*      */   int[] lusFunctionId2;
/*      */   byte[][] lusSessionId2;
/*      */   KeywordValueLong[][] lusInKeyVal2;
/*      */   int[] lusInFlags2;
/*      */   int lusOffset2;
/*      */   long ossestateOperations;
/*      */   static final int DIRECTIVE_REPLAY_ENABLED = 4;
/*      */   EnumSet<ReplayMode> replayModes;
/*      */   OracleConnection.EndReplayCallback endReplayCallback;
/*      */   ReplayContext[] oappcontreplayContextsArr;
/*      */   int oappcontreplayOffset;
/*      */   int sessionId;
/*      */   int serialNumber;
/*      */   byte negotiatedTTCversion;
/*      */   byte[] serverRuntimeCapabilities;
/*      */   byte[] serverCompileTimeCapabilities;
/*      */   Hashtable namespaces;
/*      */   byte[] internalName;
/*      */   byte[] externalName;
/*      */   static final int FREE = -1;
/*      */   static final int SEND = 1;
/*      */   static final int RECEIVE = 2;
/*  305 */   int pipeState = -1;
/*  306 */   boolean sentCancel = false;
/*      */   String currentSchema;
/*      */   int maxNonStreamBindByteSize;
/*  319 */   boolean cancelInProgressFlag = false;
/*      */ 
/*  326 */   boolean statementCancel = true;
/*      */   String databaseUniqueIdentifier;
/*  336 */   static final Map<String, String[]> cachedVersionTable = new Hashtable();
/*      */ 
/*  339 */   byte currentTTCSeqNumber = 0;
/*      */   short[] ttiList;
/*  345 */   short executingRPCFunctionCode = 0;
/*      */   String executingRPCSQL;
/* 3215 */   private final CRC32 checksumEngine = new CRC32();
/*      */ 
/* 3232 */   private final Hashtable<Long, Integer> tempLobRefCount = new Hashtable();
/*      */   static final int MAX_SIZE_VSESSION_OSUSER = 30;
/*      */   static final int MAX_SIZE_VSESSION_PROCESS = 24;
/*      */   static final int MAX_SIZE_VSESSION_MACHINE = 64;
/*      */   static final int MAX_SIZE_VSESSION_TERMINAL = 30;
/*      */   static final int MAX_SIZE_VSESSION_PROGRAM = 48;
/* 6777 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public short getExecutingRPCFunctionCode()
/*      */   {
/*  354 */     return this.executingRPCFunctionCode;
/*      */   }
/*      */ 
/*      */   void setExecutingRPCFunctionCode(short paramShort)
/*      */   {
/*  359 */     this.executingRPCFunctionCode = paramShort;
/*      */   }
/*      */ 
/*      */   void setExecutingRPCSQL(String paramString)
/*      */   {
/*  366 */     this.executingRPCSQL = paramString;
/*      */   }
/*      */ 
/*      */   public String getExecutingRPCSQL() {
/*  370 */     return this.executingRPCSQL;
/*      */   }
/*      */ 
/*      */   T4CConnection(String paramString, Properties paramProperties, OracleDriverExtension paramOracleDriverExtension)
/*      */     throws SQLException
/*      */   {
/*  385 */     super(paramString, paramProperties, paramOracleDriverExtension);
/*      */   }
/*      */ 
/*      */   void additionalInitialization()
/*      */     throws SQLException
/*      */   {
/*  391 */     this.cursorToClose = new int[4];
/*  392 */     this.cursorToCloseOffset = 0;
/*      */ 
/*  395 */     this.queryToClose = new int[10];
/*  396 */     this.queryToCloseOffset = 0;
/*      */ 
/*  398 */     this.lusFunctionId2 = new int[10];
/*  399 */     this.lusSessionId2 = new byte[10][];
/*  400 */     this.lusInKeyVal2 = new KeywordValueLong[10][];
/*  401 */     this.lusInFlags2 = new int[10];
/*  402 */     this.lusOffset2 = 0;
/*      */ 
/*  404 */     this.replayModes = EnumSet.noneOf(ReplayMode.class);
/*      */ 
/*  408 */     this.ossestateOperations = -1L;
/*  409 */     this.endReplayCallback = null;
/*      */ 
/*  411 */     this.oappcontreplayOffset = 0;
/*  412 */     this.oappcontreplayContextsArr = null;
/*      */ 
/*  414 */     this.minVcsBindSize = 0;
/*      */ 
/*  416 */     this.namespaces = new Hashtable(5);
/*      */ 
/*  418 */     this.currentSchema = null;
/*      */ 
/*  420 */     this.ttiList = new short[''];
/*      */   }
/*      */ 
/*      */   final void initializePassword(String paramString)
/*      */     throws SQLException
/*      */   {
/*  426 */     this.password = paramString;
/*      */   }
/*      */ 
/*      */   void logon()
/*      */     throws SQLException
/*      */   {
/*  457 */     Object localObject1 = null;
/*      */     try
/*      */     {
/*  462 */       if (this.isLoggedOn)
/*      */       {
/*  465 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 428);
/*  466 */         localSQLException1.fillInStackTrace();
/*  467 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  474 */       if (this.database == null)
/*      */       {
/*  476 */         this.database = "localhost:1521:orcl";
/*      */       }
/*      */ 
/*  486 */       connect(this.database);
/*      */ 
/*  488 */       this.all8 = new T4C8Oall(this);
/*  489 */       this.okpn = new T4CTTIokpn(this);
/*  490 */       this.close8 = new T4C8Oclose(this);
/*  491 */       this.sto = new T4CTTIsto(this);
/*  492 */       this.spfp = new T4CTTIspfp(this);
/*  493 */       this.commoncall = new T4C7Ocommoncall(this);
/*  494 */       this.describe = new T4C8Odscrarr(this);
/*  495 */       this.bfileMsg = new T4C8TTIBfile(this);
/*  496 */       this.blobMsg = new T4C8TTIBlob(this);
/*  497 */       this.clobMsg = new T4C8TTIClob(this);
/*  498 */       this.otxen = new T4CTTIOtxen(this);
/*  499 */       this.otxse = new T4CTTIOtxse(this);
/*  500 */       this.oping = new T4CTTIoping(this);
/*  501 */       this.k2rpc = new T4CTTIk2rpc(this);
/*  502 */       this.oses = new T4CTTIoses(this);
/*  503 */       this.okeyval = new T4CTTIokeyval(this);
/*  504 */       this.oxssro = new T4CTTIoxssro(this);
/*  505 */       this.oxsspo = new T4CTTIoxsspo(this);
/*  506 */       this.oxsscs = new T4CTTIoxsscs(this);
/*  507 */       this.oxscre = new T4CTTIoxscre(this);
/*  508 */       this.oxsdes = new T4CTTIoxsdes(this);
/*  509 */       this.oxsatt = new T4CTTIoxsatt(this);
/*  510 */       this.xsnsop = new T4CTTIxsnsop(this);
/*  511 */       this.xsnsop2 = new T4CTTIoxsns(this);
/*  512 */       this.oxsdet = new T4CTTIoxsdet(this);
/*  513 */       this.oxsset = new T4CTTIoxsset(this);
/*      */ 
/*  515 */       this.aqe = new T4Caqe(this);
/*  516 */       this.aqdq = new T4Caqdq(this);
/*  517 */       this.oscid = new T4CTTIoscid(this);
/*  518 */       this.osessrls = new T4CTTIosessrls(this);
/*  519 */       this.ocsessret = new T4CTTIocsessret(this);
/*  520 */       this.osessget = new T4CTTIosessget(this);
/*      */ 
/*  522 */       this.oaqenq = new T4CTTIoaqenq(this);
/*  523 */       this.oaqdeq = new T4CTTIoaqdeq(this);
/*      */ 
/*  525 */       this.kpdnrdeq = new T4CTTIkpdnrdeq(this);
/*      */ 
/*  527 */       this.osesstate = new T4CTTIosesstate(this);
/*  528 */       this.oappcontreplay = new T4CTTIoappcontreplay(this);
/*      */ 
/*  531 */       this.LOGON_MODE = 0L;
/*  532 */       if (this.internalLogon != null)
/*      */       {
/*  536 */         if (this.internalLogon.equalsIgnoreCase("sysoper"))
/*      */         {
/*  538 */           this.LOGON_MODE = 64L;
/*      */         }
/*  540 */         else if (this.internalLogon.equalsIgnoreCase("sysdba"))
/*      */         {
/*  542 */           this.LOGON_MODE = 32L;
/*      */         }
/*  544 */         else if (this.internalLogon.equalsIgnoreCase("sysasm"))
/*      */         {
/*  546 */           this.LOGON_MODE = 4194304L;
/*      */         }
/*  548 */         else if (this.internalLogon.equalsIgnoreCase("sysbackup"))
/*      */         {
/*  550 */           this.LOGON_MODE = 16777216L;
/*      */         }
/*  552 */         else if (this.internalLogon.equalsIgnoreCase("sysdg"))
/*      */         {
/*  554 */           this.LOGON_MODE = 33554432L;
/*      */         }
/*  556 */         else if (this.internalLogon.equalsIgnoreCase("syskm"))
/*      */         {
/*  558 */           this.LOGON_MODE = 67108864L;
/*      */         }
/*      */       }
/*      */ 
/*  562 */       if (this.prelimAuth) {
/*  563 */         this.LOGON_MODE |= 128L;
/*      */       }
/*  565 */       this.auth = new T4CTTIoauthenticate(this, this.resourceManagerId, this.serverCompileTimeCapabilities);
/*      */ 
/*  567 */       if ((this.userName != null) && (this.userName.length() != 0))
/*      */       {
/*      */         try
/*      */         {
/*  580 */           this.auth.doOSESSKEY(this.userName, this.LOGON_MODE);
/*      */         }
/*      */         catch (SQLException localSQLException2)
/*      */         {
/*  584 */           if (localSQLException2.getErrorCode() == 1017)
/*      */           {
/*  586 */             localObject1 = localSQLException2;
/*  587 */             this.userName = null;
/*      */           }
/*      */           else
/*      */           {
/*  591 */             throw localSQLException2;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  596 */       this.auth.doOAUTH(this.userName, this.password, this.LOGON_MODE);
/*      */ 
/*  598 */       this.sessionId = getSessionId();
/*  599 */       this.serialNumber = getSerialNumber();
/*  600 */       this.internalName = this.auth.internalName;
/*  601 */       this.externalName = this.auth.externalName;
/*  602 */       this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
/*  603 */       this.dbName = this.sessionProperties.getProperty("AUTH_DBNAME");
/*      */ 
/*  605 */       this.databaseUniqueIdentifier = this.sessionProperties.getProperty("AUTH_DB_ID");
/*  606 */       String str = (String)this.sessionProperties.get("AUTH_SC_INSTANCE_START_TIME");
/*  607 */       localObject2 = null;
/*  608 */       if ((this.drcpEnabled) && (this.databaseUniqueIdentifier != null))
/*      */       {
/*  610 */         localObject2 = (String[])cachedVersionTable.get(new StringBuilder().append(this.databaseUniqueIdentifier).append(str).toString());
/*      */       }
/*      */ 
/*  613 */       if ((!this.prelimAuth) && (!this.jmsNotificationConnection) && (localObject2 == null))
/*      */       {
/*  615 */         T4C7Oversion localT4C7Oversion = new T4C7Oversion(this);
/*  616 */         localT4C7Oversion.doOVERSION();
/*      */ 
/*  618 */         byte[] arrayOfByte = localT4C7Oversion.getVersion();
/*      */         try
/*      */         {
/*  621 */           this.databaseProductVersion = new String(arrayOfByte, "UTF8");
/*      */         }
/*      */         catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*      */         {
/*  627 */           SQLException localSQLException4 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localUnsupportedEncodingException);
/*  628 */           localSQLException4.fillInStackTrace();
/*  629 */           throw localSQLException4;
/*      */         }
/*      */ 
/*  633 */         this.versionNumber = localT4C7Oversion.getVersionNumber();
/*      */ 
/*  635 */         if ((this.drcpEnabled) && (this.databaseUniqueIdentifier != null)) {
/*  636 */           localObject2 = new String[] { this.databaseProductVersion, String.valueOf(this.versionNumber) };
/*      */ 
/*  638 */           cachedVersionTable.put(new StringBuilder().append(this.databaseUniqueIdentifier).append(str).toString(), localObject2);
/*  639 */           detachServerConnection((String)null);
/*      */         }
/*      */ 
/*      */       }
/*  647 */       else if (localObject2 == null) {
/*  648 */         this.versionNumber = 0;
/*      */       }
/*      */       else {
/*  651 */         this.databaseProductVersion = localObject2[0];
/*  652 */         this.versionNumber = Short.parseShort(localObject2[1]);
/*      */       }
/*      */ 
/*  662 */       this.isLoggedOn = true;
/*      */ 
/*  666 */       if (getVersionNumber() < 11000) {
/*  667 */         this.enableTempLobRefCnt = false;
/*      */       }
/*      */     }
/*      */     catch (NetException localNetException)
/*      */     {
/*  672 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localNetException);
/*  673 */       ((SQLException)localObject2).fillInStackTrace();
/*  674 */       throw ((Throwable)localObject2);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  679 */       handleIOException(localIOException);
/*      */ 
/*  681 */       Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  682 */       ((SQLException)localObject2).fillInStackTrace();
/*  683 */       throw ((Throwable)localObject2);
/*      */     }
/*      */     catch (SQLException localSQLException3)
/*      */     {
/*  690 */       if (localObject1 != null)
/*      */       {
/*  692 */         localSQLException3.initCause(localObject1);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  700 */         this.net.disconnect();
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*      */       }
/*      */ 
/*  707 */       this.isLoggedOn = false;
/*      */ 
/*  709 */       throw localSQLException3;
/*      */     }
/*      */   }
/*      */ 
/*      */   void handleIOException(IOException paramIOException)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  719 */       this.pipeState = -1;
/*  720 */       this.net.disconnect();
/*  721 */       this.net = null;
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */ 
/*  728 */     this.isLoggedOn = false;
/*  729 */     this.lifecycle = 4;
/*      */   }
/*      */ 
/*      */   synchronized void logoff()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  753 */       assertLoggedOn("T4CConnection.logoff");
/*  754 */       if (this.lifecycle == 8) {
/*      */         return;
/*      */       }
/*  757 */       this.commoncall.doOLOGOFF();
/*  758 */       this.net.disconnect();
/*  759 */       this.net = null;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  764 */       handleIOException(localIOException);
/*      */ 
/*  766 */       if (this.lifecycle != 8)
/*      */       {
/*  769 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  770 */         localSQLException.fillInStackTrace();
/*  771 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  780 */         if (this.net != null) {
/*  781 */           this.net.disconnect();
/*      */         }
/*      */       }
/*      */       catch (Exception localException4)
/*      */       {
/*      */       }
/*      */ 
/*  788 */       this.isLoggedOn = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   T4CMAREngine getMarshalEngine()
/*      */   {
/*  797 */     return this.mare;
/*      */   }
/*      */ 
/*      */   synchronized void doCommit(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  818 */     assertLoggedOn("T4CConnection.do_commit");
/*      */     try
/*      */     {
/*  821 */       if (paramInt == 0)
/*      */       {
/*  823 */         this.commoncall.doOCOMMIT();
/*      */       }
/*      */       else
/*      */       {
/*  841 */         int i = 0;
/*  842 */         if ((paramInt & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
/*  843 */           i = i | 0x2 | 0x1;
/*      */         }
/*  845 */         else if ((paramInt & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
/*  846 */           i |= 2;
/*      */         }
/*  848 */         if ((paramInt & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
/*  849 */           i = i | 0x8 | 0x4;
/*      */         }
/*  851 */         else if ((paramInt & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
/*  852 */           i |= 8;
/*      */         }
/*      */ 
/*  854 */         this.otxen.doOTXEN(1, null, null, 0, 0, 0, 0, 4, i);
/*      */ 
/*  863 */         int j = this.otxen.getOutStateFromServer();
/*      */ 
/*  865 */         if ((j == 2) || (j == 4));
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  875 */       handleIOException(localIOException);
/*      */ 
/*  877 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  878 */       localSQLException.fillInStackTrace();
/*  879 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void doRollback()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  905 */       assertLoggedOn("T4CConnection.do_rollback");
/*  906 */       this.commoncall.doOROLLBACK();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  911 */       handleIOException(localIOException);
/*      */ 
/*  913 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  914 */       localSQLException.fillInStackTrace();
/*  915 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void doSetAutoCommit(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  940 */     if ((this.autoCommitSpecCompliant) && (paramBoolean) && (getTransactionState().contains(OracleConnection.TransactionState.TRANSACTION_STARTED)))
/*      */     {
/*  943 */       commit();
/*      */     }
/*  945 */     this.autocommit = paramBoolean;
/*      */   }
/*      */ 
/*      */   synchronized void open(OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*  982 */     assertLoggedOn("T4CConnection.open");
/*  983 */     paramOracleStatement.setCursorId(0);
/*      */   }
/*      */ 
/*      */   synchronized String doGetDatabaseProductVersion()
/*      */     throws SQLException
/*      */   {
/*  997 */     assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
/*      */ 
/*  999 */     T4C7Oversion localT4C7Oversion = new T4C7Oversion(this);
/*      */     try
/*      */     {
/* 1002 */       localT4C7Oversion.doOVERSION();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1007 */       handleIOException(localIOException);
/*      */ 
/* 1009 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1010 */       ((SQLException)localObject).fillInStackTrace();
/* 1011 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1015 */     String str = null;
/*      */ 
/* 1017 */     Object localObject = localT4C7Oversion.getVersion();
/*      */     try
/*      */     {
/* 1020 */       str = new String((byte[])localObject, "UTF8");
/*      */     }
/*      */     catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*      */     {
/* 1027 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localUnsupportedEncodingException);
/* 1028 */       localSQLException.fillInStackTrace();
/* 1029 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1033 */     return str;
/*      */   }
/*      */ 
/*      */   synchronized short doGetVersionNumber()
/*      */     throws SQLException
/*      */   {
/* 1046 */     assertLoggedOn("T4CConnection.do_getVersionNumber");
/*      */ 
/* 1048 */     T4C7Oversion localT4C7Oversion = new T4C7Oversion(this);
/*      */     try
/*      */     {
/* 1051 */       localT4C7Oversion.doOVERSION();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1056 */       handleIOException(localIOException);
/*      */ 
/* 1058 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1059 */       localSQLException.fillInStackTrace();
/* 1060 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1064 */     return localT4C7Oversion.getVersionNumber();
/*      */   }
/*      */ 
/*      */   OracleStatement RefCursorBytesToStatement(byte[] paramArrayOfByte, OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/* 1072 */     T4CStatement localT4CStatement = new T4CStatement(this, -1, -1);
/*      */     try
/*      */     {
/* 1076 */       int i = this.mare.unmarshalRefCursor(paramArrayOfByte);
/*      */ 
/* 1078 */       localT4CStatement.setCursorId(i);
/*      */ 
/* 1080 */       localT4CStatement.isOpen = true;
/*      */ 
/* 1084 */       localT4CStatement.sqlObject = paramOracleStatement.sqlObject;
/*      */ 
/* 1086 */       localT4CStatement.serverCursor = true;
/* 1087 */       paramOracleStatement.addChild(localT4CStatement);
/* 1088 */       localT4CStatement.prepareForNewResults(true, false, true);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1095 */       handleIOException(localIOException);
/*      */ 
/* 1097 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1098 */       localSQLException.fillInStackTrace();
/* 1099 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1104 */     localT4CStatement.needToParse = false;
/*      */ 
/* 1106 */     return localT4CStatement;
/*      */   }
/*      */ 
/*      */   OracleStatement createImplicitResultSetStatement(OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/* 1114 */     T4CStatement localT4CStatement = new T4CStatement(this, -1, -1);
/*      */ 
/* 1116 */     localT4CStatement.sqlObject = paramOracleStatement.sqlObject;
/* 1117 */     localT4CStatement.sqlKind = OracleStatement.SqlKind.SELECT;
/* 1118 */     localT4CStatement.numberOfDefinePositions = paramOracleStatement.numberOfDefinePositions;
/* 1119 */     localT4CStatement.isOpen = paramOracleStatement.isOpen;
/* 1120 */     localT4CStatement.prepareForNewResults(true, false, true);
/*      */ 
/* 1123 */     paramOracleStatement.addImplicitResultSetStmt(localT4CStatement);
/* 1124 */     return localT4CStatement;
/*      */   }
/*      */ 
/*      */   void cancelOperationOnServer(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1134 */     synchronized (this.cancelInProgressLockForThin)
/*      */     {
/* 1136 */       if (!this.cancelInProgressFlag)
/*      */       {
/*      */         try
/*      */         {
/* 1140 */           switch (this.pipeState)
/*      */           {
/*      */           case -1:
/* 1144 */             return;
/*      */           case 1:
/* 1146 */             this.net.sendBreak();
/* 1147 */             break;
/*      */           case 2:
/* 1149 */             this.net.sendInterrupt();
/*      */           case 0:
/*      */           }
/* 1152 */           this.sentCancel = true;
/*      */         }
/*      */         catch (NetException localNetException)
/*      */         {
/* 1158 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localNetException);
/* 1159 */           localSQLException.fillInStackTrace();
/* 1160 */           throw localSQLException;
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 1167 */           handleIOException(localIOException);
/*      */ 
/* 1169 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1170 */           localSQLException.fillInStackTrace();
/* 1171 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1175 */         this.cancelInProgressFlag = true;
/* 1176 */         this.statementCancel = paramBoolean;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void connect(String paramString)
/*      */     throws IOException, SQLException
/*      */   {
/* 1219 */     if (paramString == null)
/*      */     {
/* 1223 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 433);
/* 1224 */       ((SQLException)localObject).fillInStackTrace();
/* 1225 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1230 */     Object localObject = new Properties();
/* 1231 */     if (this.thinNetProfile != null)
/* 1232 */       ((Properties)localObject).setProperty("oracle.net.profile", this.thinNetProfile);
/* 1233 */     if (this.thinNetAuthenticationServices != null) {
/* 1234 */       ((Properties)localObject).setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
/*      */     }
/* 1236 */     if (this.thinNetAuthenticationKrb5Mutual != null) {
/* 1237 */       ((Properties)localObject).setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
/*      */     }
/* 1239 */     if (this.thinNetAuthenticationKrb5CcName != null) {
/* 1240 */       ((Properties)localObject).setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
/*      */     }
/* 1242 */     if (this.thinNetEncryptionLevel != null) {
/* 1243 */       ((Properties)localObject).setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
/*      */     }
/* 1245 */     if (this.thinNetEncryptionTypes != null) {
/* 1246 */       ((Properties)localObject).setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
/*      */     }
/* 1248 */     if (this.thinNetChecksumLevel != null) {
/* 1249 */       ((Properties)localObject).setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
/*      */     }
/* 1251 */     if (this.thinNetChecksumTypes != null) {
/* 1252 */       ((Properties)localObject).setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
/*      */     }
/* 1254 */     if (this.thinNetCryptoSeed != null)
/* 1255 */       ((Properties)localObject).setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
/* 1256 */     if (this.thinTcpNoDelay)
/* 1257 */       ((Properties)localObject).setProperty("TCP.NODELAY", "YES");
/* 1258 */     if (this.thinReadTimeout != null) {
/* 1259 */       ((Properties)localObject).setProperty("oracle.net.READ_TIMEOUT", this.thinReadTimeout);
/*      */     }
/* 1261 */     if (this.thinNetConnectTimeout != null) {
/* 1262 */       ((Properties)localObject).setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
/*      */     }
/* 1264 */     if (this.thinSslServerDnMatch != null) {
/* 1265 */       ((Properties)localObject).setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
/*      */     }
/* 1267 */     if (this.walletLocation != null) {
/* 1268 */       ((Properties)localObject).setProperty("oracle.net.wallet_location", this.walletLocation);
/*      */     }
/* 1270 */     if (this.walletPassword != null) {
/* 1271 */       ((Properties)localObject).setProperty("oracle.net.wallet_password", this.walletPassword);
/*      */     }
/* 1273 */     if (this.thinSslVersion != null) {
/* 1274 */       ((Properties)localObject).setProperty("oracle.net.ssl_version", this.thinSslVersion);
/*      */     }
/* 1276 */     if (this.thinSslCipherSuites != null) {
/* 1277 */       ((Properties)localObject).setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
/*      */     }
/* 1279 */     if (this.thinJavaxNetSslKeystore != null) {
/* 1280 */       ((Properties)localObject).setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
/*      */     }
/* 1282 */     if (this.thinJavaxNetSslKeystoretype != null) {
/* 1283 */       ((Properties)localObject).setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
/*      */     }
/* 1285 */     if (this.thinJavaxNetSslKeystorepassword != null) {
/* 1286 */       ((Properties)localObject).setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
/*      */     }
/* 1288 */     if (this.thinJavaxNetSslTruststore != null) {
/* 1289 */       ((Properties)localObject).setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
/*      */     }
/* 1291 */     if (this.thinJavaxNetSslTruststoretype != null) {
/* 1292 */       ((Properties)localObject).setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
/*      */     }
/* 1294 */     if (this.thinJavaxNetSslTruststorepassword != null) {
/* 1295 */       ((Properties)localObject).setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
/*      */     }
/* 1297 */     if (this.thinSslKeymanagerfactoryAlgorithm != null) {
/* 1298 */       ((Properties)localObject).setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
/*      */     }
/* 1300 */     if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
/* 1301 */       ((Properties)localObject).setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
/*      */     }
/* 1303 */     if (this.thinNetOldsyntax != null)
/* 1304 */       ((Properties)localObject).setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
/* 1305 */     if (this.thinNamingContextInitial != null)
/* 1306 */       ((Properties)localObject).setProperty("java.naming.factory.initial", this.thinNamingContextInitial);
/* 1307 */     if (this.thinNamingProviderUrl != null)
/* 1308 */       ((Properties)localObject).setProperty("java.naming.provider.url", this.thinNamingProviderUrl);
/* 1309 */     if (this.thinNamingSecurityAuthentication != null) {
/* 1310 */       ((Properties)localObject).setProperty("java.naming.security.authentication", this.thinNamingSecurityAuthentication);
/*      */     }
/* 1312 */     if (this.thinNamingSecurityPrincipal != null) {
/* 1313 */       ((Properties)localObject).setProperty("java.naming.security.principal", this.thinNamingSecurityPrincipal);
/*      */     }
/* 1315 */     if (this.thinNamingSecurityCredentials != null) {
/* 1316 */       ((Properties)localObject).setProperty("java.naming.security.credentials", this.thinNamingSecurityCredentials);
/*      */     }
/* 1318 */     if (this.thinJndiLdapConnectTimeout != null) {
/* 1319 */       ((Properties)localObject).setProperty("com.sun.jndi.ldap.connect.timeout", this.thinJndiLdapConnectTimeout);
/*      */     }
/* 1321 */     if (this.thinJndiLdapReadTimeout != null) {
/* 1322 */       ((Properties)localObject).setProperty("com.sun.jndi.ldap.read.timeout", this.thinJndiLdapReadTimeout);
/*      */     }
/* 1324 */     if (this.thinNetDisableOutOfBandBreak) {
/* 1325 */       ((Properties)localObject).setProperty("DISABLE_OOB", new StringBuilder().append("").append(this.thinNetDisableOutOfBandBreak).toString());
/*      */     }
/* 1327 */     ((Properties)localObject).setProperty("USE_ZERO_COPY_IO", new StringBuilder().append("").append(this.thinNetUseZeroCopyIO).toString());
/*      */ 
/* 1329 */     ((Properties)localObject).setProperty("FORCE_DNS_LOAD_BALANCING", new StringBuilder().append("").append(this.thinForceDnsLoadBalancing).toString());
/*      */ 
/* 1332 */     ((Properties)localObject).setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
/* 1333 */     ((Properties)localObject).setProperty("oracle.jdbc.v$session.program", this.thinVsessionProgram);
/* 1334 */     ((Properties)localObject).setProperty("T4CConnection.hashCode", Integer.toHexString(hashCode()).toUpperCase());
/*      */ 
/* 1340 */     ((Properties)localObject).setProperty("oracle.net.keepAlive", Boolean.toString(this.keepAlive));
/* 1341 */     ((Properties)localObject).setProperty("oracle.jdbc.useNio", Boolean.toString(this.javaNetNio));
/*      */ 
/* 1343 */     if (this.targetInstanceName != null) {
/* 1344 */       ((Properties)localObject).setProperty("oracle.jdbc.targetInstanceName", this.targetInstanceName);
/*      */     }
/*      */ 
/* 1350 */     if (this.javaNetNio)
/*      */     {
/* 1352 */       this.net = new NSProtocolNIO(this.nsDirectBuffer);
/*      */     }
/*      */     else
/*      */     {
/* 1356 */       this.net = new NSProtocolStream();
/*      */     }
/*      */ 
/* 1360 */     this.net.connect(paramString, (Properties)localObject);
/*      */ 
/* 1370 */     if (this.javaNetNio)
/*      */     {
/* 1372 */       this.mare = new T4CMAREngineNIO(this.net);
/*      */     }
/*      */     else
/*      */     {
/* 1376 */       this.mare = new T4CMAREngineStream(this.net);
/*      */     }
/* 1378 */     this.oer = new T4CTTIoer(this);
/* 1379 */     this.mare.setConnectionDuringExceptionHandling(this);
/*      */ 
/* 1385 */     this.pro = new T4C8TTIpro(this);
/*      */ 
/* 1387 */     this.pro.marshal();
/*      */ 
/* 1389 */     this.serverCompileTimeCapabilities = this.pro.receive();
/* 1390 */     this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
/*      */ 
/* 1395 */     short s1 = this.pro.getOracleVersion();
/* 1396 */     short s2 = this.pro.getCharacterSet();
/* 1397 */     short s3 = DBConversion.findDriverCharSet(s2, s1);
/*      */ 
/* 1400 */     this.conversion = new DBConversion(s2, s3, this.pro.getncharCHARSET(), this.isStrictAsciiConversion);
/*      */ 
/* 1403 */     this.mare.types.setServerConversion(s3 != s2);
/*      */ 
/* 1408 */     if (DBConversion.isCharSetMultibyte(s3))
/*      */     {
/* 1414 */       if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet()))
/* 1415 */         this.mare.types.setFlags((byte)1);
/*      */       else
/* 1417 */         this.mare.types.setFlags((byte)2);
/*      */     }
/*      */     else {
/* 1420 */       this.mare.types.setFlags(this.pro.getFlags());
/*      */     }
/* 1422 */     this.mare.conv = this.conversion;
/*      */ 
/* 1426 */     if ((this.serverCompileTimeCapabilities.length > 37) && (bit(this.serverCompileTimeCapabilities[37], 32)))
/*      */     {
/* 1429 */       this.mare.setUseCLRBigChunks(true);
/*      */     }
/*      */ 
/* 1434 */     T4C8TTIdty localT4C8TTIdty = new T4C8TTIdty(this, this.serverCompileTimeCapabilities, this.serverRuntimeCapabilities, (this.logonCap != null) && (this.logonCap.trim().equals("o3")), this.thinNetUseZeroCopyIO);
/*      */ 
/* 1439 */     localT4C8TTIdty.doRPC();
/*      */ 
/* 1443 */     this.negotiatedTTCversion = this.serverCompileTimeCapabilities[7];
/* 1444 */     if (localT4C8TTIdty.jdbcThinCompileTimeCapabilities[7] < this.serverCompileTimeCapabilities[7]) {
/* 1445 */       this.negotiatedTTCversion = localT4C8TTIdty.jdbcThinCompileTimeCapabilities[7];
/*      */     }
/*      */ 
/* 1449 */     if ((this.serverRuntimeCapabilities != null) && (this.serverRuntimeCapabilities.length > 6) && ((this.serverRuntimeCapabilities[6] & T4C8TTIdty.KPCCAP_RTB_TTC_ZCPY) != 0) && (this.thinNetUseZeroCopyIO) && ((this.net.getSessionAttributes().getNegotiatedOptions() & 0x40) != 0) && (getDataIntegrityAlgorithmName().equals("")) && (getEncryptionAlgorithmName().equals("")))
/*      */     {
/* 1460 */       this.useZeroCopyIO = true;
/*      */     }
/* 1462 */     else this.useZeroCopyIO = false;
/*      */ 
/* 1466 */     if ((this.serverCompileTimeCapabilities.length > 23) && (bit(this.serverCompileTimeCapabilities[23], 64)) && (bit(localT4C8TTIdty.jdbcThinCompileTimeCapabilities[23], 64)))
/*      */     {
/* 1469 */       this.useLobPrefetch = true;
/*      */     }
/* 1471 */     else this.useLobPrefetch = false;
/*      */ 
/* 1473 */     if ((this.serverRuntimeCapabilities != null) && (this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC) && (bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_32K)))
/*      */     {
/* 1477 */       this.maxNonStreamBindByteSize = 32767;
/* 1478 */       this.varTypeMaxLenCompat = 2;
/*      */     } else {
/* 1480 */       this.maxNonStreamBindByteSize = 4000;
/* 1481 */       this.varTypeMaxLenCompat = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean isZeroCopyIOEnabled()
/*      */   {
/* 1498 */     return this.useZeroCopyIO;
/*      */   }
/*      */ 
/*      */   final T4CTTIoer getT4CTTIoer()
/*      */   {
/* 1517 */     return this.oer;
/*      */   }
/*      */ 
/*      */   final byte getTTCVersion()
/*      */   {
/* 1527 */     return this.negotiatedTTCversion;
/*      */   }
/*      */ 
/*      */   void doStartup(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1536 */       int i = 0;
/* 1537 */       if (paramInt == OracleConnection.DatabaseStartupMode.FORCE.getMode())
/* 1538 */         i = 16;
/* 1539 */       else if (paramInt == OracleConnection.DatabaseStartupMode.RESTRICT.getMode())
/* 1540 */         i = 1;
/* 1541 */       this.spfp.doOSPFPPUT();
/* 1542 */       this.sto.doOV6STRT(i);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1546 */       handleIOException(localIOException);
/*      */ 
/* 1548 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1549 */       localSQLException.fillInStackTrace();
/* 1550 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void doShutdown(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1562 */       int i = 4;
/*      */ 
/* 1564 */       if (paramInt == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode())
/* 1565 */         i = 128;
/* 1566 */       else if (paramInt == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode())
/* 1567 */         i = 256;
/* 1568 */       else if (paramInt == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode())
/* 1569 */         i = 2;
/* 1570 */       else if (paramInt == OracleConnection.DatabaseShutdownMode.FINAL.getMode())
/* 1571 */         i = 8;
/* 1572 */       else if (paramInt == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
/* 1573 */         i = 64;
/*      */       }
/* 1575 */       this.sto.doOV6STOP(i);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1579 */       handleIOException(localIOException);
/*      */ 
/* 1581 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1582 */       localSQLException.fillInStackTrace();
/* 1583 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void checkEndReplayCallback()
/*      */     throws SQLException
/*      */   {
/* 1623 */     if ((this.endReplayCallback != null) && (this.oappcontreplayContextsArr == null)) {
/* 1624 */       OracleConnection.EndReplayCallback localEndReplayCallback = this.endReplayCallback;
/* 1625 */       this.endReplayCallback = null;
/*      */ 
/* 1628 */       T4C8Oall localT4C8Oall1 = new T4C8Oall(this);
/* 1629 */       T4C8Oall localT4C8Oall2 = this.all8;
/* 1630 */       this.all8 = localT4C8Oall1;
/*      */       try {
/* 1632 */         localEndReplayCallback.executeCallback();
/*      */       }
/*      */       finally {
/* 1635 */         this.all8 = localT4C8Oall2;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void sendPiggyBackedMessages()
/*      */     throws SQLException, IOException
/*      */   {
/* 1649 */     checkEndReplayCallback();
/*      */ 
/* 1652 */     if (this.queryToCloseOffset > 0)
/*      */     {
/* 1654 */       this.close8.doOCANA(this.queryToClose, this.queryToCloseOffset);
/* 1655 */       this.queryToCloseOffset = 0;
/*      */     }
/*      */ 
/* 1659 */     if (this.cursorToCloseOffset > 0)
/*      */     {
/* 1661 */       this.close8.doOCCA(this.cursorToClose, this.cursorToCloseOffset);
/* 1662 */       this.cursorToCloseOffset = 0;
/*      */     }
/*      */ 
/* 1666 */     if ((this.endToEndAnyChanged) && (getTTCVersion() >= 3))
/*      */     {
/* 1674 */       this.oscid.doOSCID(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
/*      */ 
/* 1677 */       for (int i = 0; i < 5; i++) {
/* 1678 */         if (this.endToEndHasChanged[i] != 0)
/* 1679 */           this.endToEndHasChanged[i] = false;
/*      */       }
/*      */     }
/* 1682 */     this.endToEndAnyChanged = false;
/*      */ 
/* 1684 */     if (!this.namespaces.isEmpty())
/*      */     {
/* 1686 */       if (getTTCVersion() >= 4)
/*      */       {
/* 1688 */         Object[] arrayOfObject = this.namespaces.values().toArray();
/* 1689 */         for (int k = 0; k < arrayOfObject.length; k++)
/*      */         {
/* 1691 */           this.okeyval.doOKEYVAL((Namespace)arrayOfObject[k]);
/*      */         }
/*      */       }
/* 1694 */       this.namespaces.clear();
/*      */     }
/*      */ 
/* 1698 */     if (this.lusOffset2 > 0)
/*      */     {
/* 1700 */       for (int j = 0; j < this.lusOffset2; j++) {
/* 1701 */         this.oxsspo.doOXSSPO(this.lusFunctionId2[j], this.lusSessionId2[j], this.lusInKeyVal2[j], this.lusInFlags2[j]);
/*      */       }
/*      */ 
/* 1705 */       this.lusOffset2 = 0;
/*      */     }
/*      */ 
/* 1711 */     assert ((!this.replayModes.contains(ReplayMode.RUNTIME_REPLAY_ENABLED)) || (!this.replayModes.contains(ReplayMode.REPLAYING))) : "RUNTIME_REPLAY_ENABLED and REPLAYING modes cannot bet set at the same time";
/*      */ 
/* 1716 */     if (this.replayModes.contains(ReplayMode.NONREQUEST)) {
/* 1717 */       if (this.replayModes.contains(ReplayMode.RUNTIME_REPLAY_ENABLED))
/*      */       {
/* 1720 */         if (this.ossestateOperations == -1L) {
/* 1721 */           this.ossestateOperations = 0L;
/*      */         }
/*      */ 
/* 1727 */         this.ossestateOperations |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode() | OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode();
/*      */       }
/* 1730 */       else if (this.replayModes.contains(ReplayMode.REPLAYING))
/*      */       {
/* 1732 */         this.ossestateOperations = OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode();
/*      */       }
/*      */ 
/* 1735 */       if (this.replayModes.contains(ReplayMode.RUNTIME_OR_REPLAYING_STATIC)) {
/* 1736 */         this.ossestateOperations |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode();
/*      */       }
/*      */     }
/*      */ 
/* 1740 */     if (this.ossestateOperations >= 0L)
/*      */     {
/* 1742 */       this.osesstate.doOSESSSTATE(this.ossestateOperations);
/*      */     }
/*      */ 
/* 1745 */     this.ossestateOperations = -1L;
/*      */ 
/* 1751 */     if ((!this.replayModes.contains(ReplayMode.NONREQUEST)) && (this.oappcontreplayContextsArr != null))
/*      */     {
/* 1760 */       while ((this.oappcontreplayOffset < this.oappcontreplayContextsArr.length - 1) && (this.oappcontreplayContextsArr[this.oappcontreplayOffset] == null))
/*      */       {
/* 1762 */         this.oappcontreplayOffset += 1;
/*      */       }
/* 1764 */       if ((this.oappcontreplayContextsArr[this.oappcontreplayOffset] != null) && (this.oappcontreplayContextsArr[this.oappcontreplayOffset].getContext() != null))
/*      */       {
/* 1766 */         this.oappcontreplay.doOAPPCONTREPLAY(this.oappcontreplayContextsArr[this.oappcontreplayOffset]);
/*      */       }
/* 1768 */       if (this.oappcontreplayOffset == this.oappcontreplayContextsArr.length - 1)
/*      */       {
/* 1770 */         this.oappcontreplayContextsArr = null;
/*      */       }
/* 1772 */       else this.oappcontreplayOffset += 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void closeCursor(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1780 */     if (this.cursorToCloseOffset == this.cursorToClose.length)
/*      */     {
/* 1783 */       int[] arrayOfInt = new int[this.cursorToClose.length * 2];
/* 1784 */       System.arraycopy(this.cursorToClose, 0, arrayOfInt, 0, this.cursorToClose.length);
/* 1785 */       this.cursorToClose = arrayOfInt;
/*      */     }
/* 1787 */     this.cursorToClose[(this.cursorToCloseOffset++)] = paramInt;
/*      */   }
/*      */ 
/*      */   void doProxySession(int paramInt, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1798 */       this.auth.doOAUTH(paramInt, paramProperties, this.sessionId, this.serialNumber);
/*      */ 
/* 1800 */       int i = getSessionId();
/* 1801 */       int j = getSerialNumber();
/*      */ 
/* 1804 */       this.oses.doO80SES(i, j, 1);
/*      */ 
/* 1806 */       this.savedUser = this.userName;
/*      */ 
/* 1808 */       if (paramInt == 1)
/* 1809 */         this.userName = paramProperties.getProperty("PROXY_USER_NAME");
/*      */       else {
/* 1811 */         this.userName = null;
/*      */       }
/* 1813 */       this.isProxy = true;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1819 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1820 */       localSQLException.fillInStackTrace();
/* 1821 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void closeProxySession()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1833 */       this.commoncall.doOLOGOFF();
/*      */ 
/* 1835 */       this.oses.doO80SES(this.sessionId, this.serialNumber, 1);
/*      */ 
/* 1837 */       this.userName = this.savedUser;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1843 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1844 */       localSQLException.fillInStackTrace();
/* 1845 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void updateSessionProperties(KeywordValue[] paramArrayOfKeywordValue)
/*      */     throws SQLException
/*      */   {
/* 1855 */     for (int i = 0; i < paramArrayOfKeywordValue.length; i++) {
/* 1856 */       int j = paramArrayOfKeywordValue[i].getKeyword();
/* 1857 */       byte[] arrayOfByte = paramArrayOfKeywordValue[i].getBinaryValue();
/* 1858 */       if (j < T4C8Oall.NLS_KEYS.length) {
/* 1859 */         String str1 = T4C8Oall.NLS_KEYS[j];
/* 1860 */         if (str1 != null) {
/* 1861 */           if (arrayOfByte != null) {
/* 1862 */             this.sessionProperties.setProperty(str1, this.mare.conv.CharBytesToString(arrayOfByte, arrayOfByte.length));
/*      */           }
/* 1866 */           else if (paramArrayOfKeywordValue[i].getTextValue() != null) {
/* 1867 */             this.sessionProperties.setProperty(str1, paramArrayOfKeywordValue[i].getTextValue().trim());
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/* 1872 */       else if (j == 163) {
/* 1873 */         if (arrayOfByte != null)
/*      */         {
/* 1875 */           int k = arrayOfByte[4];
/* 1876 */           int m = arrayOfByte[5];
/*      */ 
/* 1878 */           if ((arrayOfByte[4] & 0xFF) > 120) {
/* 1879 */             k = (arrayOfByte[4] & 0xFF) - 181;
/* 1880 */             m = (arrayOfByte[5] & 0xFF) - 60;
/*      */           }
/*      */           else {
/* 1883 */             k = (arrayOfByte[4] & 0xFF) - 60;
/* 1884 */             m = (arrayOfByte[5] & 0xFF) - 60;
/*      */           }
/*      */ 
/* 1887 */           String str3 = new StringBuilder().append(k > 0 ? "+" : "").append(k).append(m <= 9 ? ":0" : ":").append(m).toString();
/*      */ 
/* 1892 */           this.sessionProperties.setProperty("SESSION_TIME_ZONE", str3);
/*      */         }
/*      */ 
/*      */       }
/* 1896 */       else if (j != 165)
/*      */       {
/* 1908 */         if (j != 166)
/*      */         {
/* 1919 */           if (j != 167)
/*      */           {
/* 1922 */             if (j == 168) {
/* 1923 */               String str2 = paramArrayOfKeywordValue[i].getTextValue();
/* 1924 */               if (str2 != null) {
/* 1925 */                 this.currentSchema = str2.trim();
/*      */               }
/*      */             }
/* 1928 */             else if (j != 169)
/*      */             {
/* 1939 */               if (j != 170)
/*      */               {
/* 1941 */                 if (j != 171)
/*      */                 {
/* 1945 */                   if (j != 175)
/*      */                   {
/* 1947 */                     if (j != 176)
/*      */                     {
/* 1949 */                       if (j == 177) {
/* 1950 */                         this.isPDBChanged = true;
/* 1951 */                         long l = 0L;
/*      */ 
/* 1953 */                         for (int n = 3; n >= 0; n--) {
/* 1954 */                           l |= (arrayOfByte[(3 - n)] & 0xFF) << 8 * n;
/*      */                         }
/*      */ 
/* 1957 */                         this.sessionProperties.setProperty("AUTH_DB_ID", String.valueOf(l));
/* 1958 */                         onPDBChange();
/*      */                       }
/* 1960 */                       else if (j != 178)
/*      */                       {
/* 1962 */                         if ((j == 179) && 
/* 1963 */                           (paramArrayOfKeywordValue[i].getTextValue() != null)) {
/* 1964 */                           this.dbName = paramArrayOfKeywordValue[i].getTextValue();
/* 1965 */                           this.sessionProperties.setProperty("AUTH_DBNAME", this.dbName);
/*      */                         }
/*      */                       }
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void onPDBChange() throws SQLException
/*      */   {
/* 1981 */     super.onPDBChange();
/*      */ 
/* 1983 */     this.databaseUniqueIdentifier = this.sessionProperties.getProperty("AUTH_DB_ID");
/*      */   }
/*      */ 
/*      */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener, Executor paramExecutor)
/*      */     throws SQLException
/*      */   {
/* 2005 */     if (this.lifecycle != 1)
/*      */     {
/* 2007 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 2008 */       ((SQLException)localObject).fillInStackTrace();
/* 2009 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 2013 */     Object localObject = new NTFEventListener(paramPDBChangeEventListener);
/* 2014 */     ((NTFEventListener)localObject).setExecutor(paramExecutor);
/* 2015 */     if (this.pdbChangeListener == null) {
/* 2016 */       this.pdbChangeListener = ((NTFEventListener)localObject);
/*      */     }
/*      */     else
/*      */     {
/* 2020 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 248);
/* 2021 */       localSQLException.fillInStackTrace();
/* 2022 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener)
/*      */     throws SQLException
/*      */   {
/* 2042 */     setPDBChangeEventListener(paramPDBChangeEventListener, null);
/*      */   }
/*      */ 
/*      */   void notify(final NTFPDBChangeEvent paramNTFPDBChangeEvent)
/*      */   {
/* 2053 */     if (this.pdbChangeListener != null) {
/* 2054 */       Executor localExecutor = this.pdbChangeListener.getExecutor();
/* 2055 */       if (localExecutor != null) {
/* 2056 */         final PDBChangeEventListener localPDBChangeEventListener = this.pdbChangeListener.getPDBChangeEventListener();
/*      */ 
/* 2058 */         localExecutor.execute(new Runnable() {
/*      */           public void run() {
/* 2060 */             localPDBChangeEventListener.pdbChanged(paramNTFPDBChangeEvent);
/*      */           }
/*      */         });
/*      */       }
/*      */       else {
/* 2065 */         this.pdbChangeListener.getPDBChangeEventListener().pdbChanged(paramNTFPDBChangeEvent);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getCurrentSchema()
/*      */     throws SQLException
/*      */   {
/* 2083 */     if (this.lifecycle != 1)
/*      */     {
/* 2085 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 2086 */       localSQLException.fillInStackTrace();
/* 2087 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2092 */     if ((this.currentSchema == null) || (getVersionNumber() < 11100)) {
/* 2093 */       this.currentSchema = super.getCurrentSchema();
/*      */     }
/* 2095 */     return this.currentSchema;
/*      */   }
/*      */ 
/*      */   public Properties getServerSessionInfo()
/*      */     throws SQLException
/*      */   {
/* 2103 */     if ((getVersionNumber() >= 10000) && (getVersionNumber() < 10200))
/* 2104 */       queryFCFProperties(this.sessionProperties);
/* 2105 */     return this.sessionProperties;
/*      */   }
/*      */ 
/*      */   public String getSessionTimeZoneOffset()
/*      */     throws SQLException
/*      */   {
/* 2117 */     String str = getServerSessionInfo().getProperty("SESSION_TIME_ZONE");
/* 2118 */     if (str == null)
/*      */     {
/* 2120 */       str = super.getSessionTimeZoneOffset();
/*      */     }
/*      */     else
/*      */     {
/* 2124 */       str = tzToOffset(str);
/*      */     }
/* 2126 */     return str;
/*      */   }
/*      */ 
/*      */   int getSessionId()
/*      */   {
/* 2133 */     int i = -1;
/* 2134 */     String str = this.sessionProperties.getProperty("AUTH_SESSION_ID");
/*      */     try
/*      */     {
/* 2138 */       i = Integer.parseInt(str);
/*      */     } catch (NumberFormatException localNumberFormatException) {
/*      */     }
/* 2141 */     return i;
/*      */   }
/*      */ 
/*      */   int getSerialNumber()
/*      */   {
/* 2148 */     int i = -1;
/* 2149 */     String str = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
/*      */     try
/*      */     {
/* 2153 */       i = Integer.parseInt(str);
/*      */     } catch (NumberFormatException localNumberFormatException) {
/*      */     }
/* 2156 */     return i;
/*      */   }
/*      */ 
/*      */   public byte getInstanceProperty(OracleConnection.InstanceProperty paramInstanceProperty)
/*      */     throws SQLException
/*      */   {
/* 2170 */     byte b = 0;
/*      */     SQLException localSQLException;
/* 2171 */     if (paramInstanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED)
/*      */     {
/* 2174 */       if ((this.serverRuntimeCapabilities == null) || (this.serverRuntimeCapabilities.length < 6))
/*      */       {
/* 2176 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 256);
/* 2177 */         localSQLException.fillInStackTrace();
/* 2178 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2181 */       b = this.serverRuntimeCapabilities[5];
/*      */     }
/* 2183 */     else if (paramInstanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE)
/*      */     {
/* 2186 */       if ((this.serverRuntimeCapabilities == null) || (this.serverRuntimeCapabilities.length < 4))
/*      */       {
/* 2188 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 256);
/* 2189 */         localSQLException.fillInStackTrace();
/* 2190 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2193 */       b = this.serverRuntimeCapabilities[3];
/*      */     }
/*      */ 
/* 2196 */     return b;
/*      */   }
/*      */ 
/*      */   public synchronized BlobDBAccess createBlobDBAccess()
/*      */     throws SQLException
/*      */   {
/* 2216 */     return this;
/*      */   }
/*      */ 
/*      */   public synchronized ClobDBAccess createClobDBAccess()
/*      */     throws SQLException
/*      */   {
/* 2224 */     return this;
/*      */   }
/*      */ 
/*      */   public synchronized BfileDBAccess createBfileDBAccess()
/*      */     throws SQLException
/*      */   {
/* 2232 */     return this;
/*      */   }
/*      */ 
/*      */   public synchronized long length(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2253 */     assertLoggedOn("length");
/* 2254 */     assertNotNull(paramBFILE.shareBytes(), "length");
/*      */ 
/* 2256 */     needLine();
/*      */ 
/* 2258 */     long l = 0L;
/*      */     try
/*      */     {
/* 2262 */       l = this.bfileMsg.getLength(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2267 */       handleIOException(localIOException);
/*      */ 
/* 2269 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2270 */       localSQLException.fillInStackTrace();
/* 2271 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2276 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized long position(BFILE paramBFILE, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2293 */     assertNotNull(paramBFILE.shareBytes(), "position");
/*      */ 
/* 2295 */     if (paramLong < 1L)
/*      */     {
/* 2298 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2299 */       localSQLException.fillInStackTrace();
/* 2300 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2305 */     long l = LobPlsqlUtil.hasPattern(paramBFILE, paramArrayOfByte, paramLong);
/*      */ 
/* 2307 */     l = l == 0L ? -1L : l;
/*      */ 
/* 2309 */     return l;
/*      */   }
/*      */ 
/*      */   public long position(BFILE paramBFILE1, BFILE paramBFILE2, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2326 */     assertNotNull(paramBFILE1.shareBytes(), "position");
/*      */ 
/* 2328 */     if (paramLong < 1L)
/*      */     {
/* 2331 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2332 */       localSQLException.fillInStackTrace();
/* 2333 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2338 */     long l = LobPlsqlUtil.isSubLob(paramBFILE1, paramBFILE2, paramLong);
/*      */ 
/* 2340 */     l = l == 0L ? -1L : l;
/*      */ 
/* 2342 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getBytes(BFILE paramBFILE, long paramLong, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2358 */     assertLoggedOn("getBytes");
/* 2359 */     assertNotNull(paramBFILE.shareBytes(), "getBytes");
/*      */     SQLException localSQLException1;
/* 2362 */     if (paramLong < 1L)
/*      */     {
/* 2365 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getBytes()");
/* 2366 */       localSQLException1.fillInStackTrace();
/* 2367 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2373 */     if ((paramInt <= 0) || (paramArrayOfByte == null)) {
/* 2374 */       return 0;
/*      */     }
/* 2376 */     if (this.pipeState != -1)
/*      */     {
/* 2379 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 453, "getBytes()");
/* 2380 */       localSQLException1.fillInStackTrace();
/* 2381 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2384 */     needLine();
/*      */ 
/* 2386 */     long l = 0L;
/*      */ 
/* 2388 */     if (paramInt != 0)
/*      */     {
/*      */       try
/*      */       {
/* 2392 */         l = this.bfileMsg.read(paramBFILE.shareBytes(), paramLong, paramInt, paramArrayOfByte, 0);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 2397 */         handleIOException(localIOException);
/*      */ 
/* 2399 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2400 */         localSQLException2.fillInStackTrace();
/* 2401 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2407 */     return (int)l;
/*      */   }
/*      */ 
/*      */   public String getName(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2421 */     assertLoggedOn("getName");
/* 2422 */     assertNotNull(paramBFILE.shareBytes(), "getName");
/*      */ 
/* 2424 */     String str = LobPlsqlUtil.fileGetName(paramBFILE);
/*      */ 
/* 2426 */     return str;
/*      */   }
/*      */ 
/*      */   public String getDirAlias(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2440 */     assertLoggedOn("getDirAlias");
/* 2441 */     assertNotNull(paramBFILE.shareBytes(), "getDirAlias");
/*      */ 
/* 2443 */     String str = LobPlsqlUtil.fileGetDirAlias(paramBFILE);
/*      */ 
/* 2445 */     return str;
/*      */   }
/*      */ 
/*      */   public synchronized void openFile(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2458 */     assertLoggedOn("openFile");
/* 2459 */     assertNotNull(paramBFILE.shareBytes(), "openFile");
/*      */ 
/* 2461 */     needLine();
/*      */     try
/*      */     {
/* 2465 */       this.bfileMsg.open(paramBFILE.shareBytes(), 11);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2470 */       handleIOException(localIOException);
/*      */ 
/* 2472 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2473 */       localSQLException.fillInStackTrace();
/* 2474 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isFileOpen(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2493 */     assertLoggedOn("openFile");
/* 2494 */     assertNotNull(paramBFILE.shareBytes(), "openFile");
/*      */ 
/* 2496 */     needLine();
/*      */ 
/* 2498 */     boolean bool = false;
/*      */     try
/*      */     {
/* 2502 */       bool = this.bfileMsg.isOpen(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2507 */       handleIOException(localIOException);
/*      */ 
/* 2509 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2510 */       localSQLException.fillInStackTrace();
/* 2511 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2516 */     return bool;
/*      */   }
/*      */ 
/*      */   public synchronized boolean fileExists(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2532 */     assertLoggedOn("fileExists");
/* 2533 */     assertNotNull(paramBFILE.shareBytes(), "fileExists");
/*      */ 
/* 2535 */     needLine();
/*      */ 
/* 2537 */     boolean bool = false;
/*      */     try
/*      */     {
/* 2541 */       bool = this.bfileMsg.doesExist(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2546 */       handleIOException(localIOException);
/*      */ 
/* 2548 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2549 */       localSQLException.fillInStackTrace();
/* 2550 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2555 */     return bool;
/*      */   }
/*      */ 
/*      */   public synchronized void closeFile(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2568 */     assertLoggedOn("closeFile");
/* 2569 */     assertNotNull(paramBFILE.shareBytes(), "closeFile");
/*      */ 
/* 2571 */     needLine();
/*      */     try
/*      */     {
/* 2575 */       this.bfileMsg.close(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2580 */       handleIOException(localIOException);
/*      */ 
/* 2582 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2583 */       localSQLException.fillInStackTrace();
/* 2584 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void open(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2602 */     assertLoggedOn("open");
/* 2603 */     assertNotNull(paramBFILE.shareBytes(), "open");
/*      */ 
/* 2605 */     needLine();
/*      */     try
/*      */     {
/* 2609 */       this.bfileMsg.open(paramBFILE.shareBytes(), paramInt);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2614 */       handleIOException(localIOException);
/*      */ 
/* 2616 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2617 */       localSQLException.fillInStackTrace();
/* 2618 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void close(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2632 */     assertLoggedOn("close");
/* 2633 */     assertNotNull(paramBFILE.shareBytes(), "close");
/*      */ 
/* 2635 */     needLine();
/*      */     try
/*      */     {
/* 2639 */       this.bfileMsg.close(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2644 */       handleIOException(localIOException);
/*      */ 
/* 2646 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2647 */       localSQLException.fillInStackTrace();
/* 2648 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2663 */     assertLoggedOn("isOpen");
/* 2664 */     assertNotNull(paramBFILE.shareBytes(), "isOpen");
/*      */ 
/* 2666 */     needLine();
/*      */ 
/* 2668 */     boolean bool = false;
/*      */     try
/*      */     {
/* 2672 */       bool = this.bfileMsg.isOpen(paramBFILE.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2677 */       handleIOException(localIOException);
/*      */ 
/* 2679 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2680 */       localSQLException.fillInStackTrace();
/* 2681 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2685 */     return bool;
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BFILE paramBFILE, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2704 */     return newInputStream(paramBFILE, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBfile paramOracleBfile, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2723 */     if (paramLong == 0L)
/*      */     {
/* 2725 */       return new OracleBlobInputStream(paramOracleBfile, paramInt);
/*      */     }
/*      */ 
/* 2729 */     return new OracleBlobInputStream(paramOracleBfile, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2748 */     return newConversionInputStream(paramBFILE, paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(OracleBfile paramOracleBfile, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2766 */     assertNotNull(paramOracleBfile.shareBytes(), "newConversionInputStream");
/*      */ 
/* 2768 */     OracleConversionInputStream localOracleConversionInputStream = new OracleConversionInputStream(this.conversion, paramOracleBfile.getBinaryStream(), paramInt);
/*      */ 
/* 2770 */     return localOracleConversionInputStream;
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2788 */     return newConversionReader(paramBFILE, paramInt);
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(OracleBfile paramOracleBfile, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2806 */     assertNotNull(paramOracleBfile.shareBytes(), "newConversionReader");
/*      */ 
/* 2808 */     OracleConversionReader localOracleConversionReader = new OracleConversionReader(this.conversion, paramOracleBfile.getBinaryStream(), paramInt);
/*      */ 
/* 2811 */     return localOracleConversionReader;
/*      */   }
/*      */ 
/*      */   public synchronized long length(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2833 */     assertLoggedOn("length");
/* 2834 */     assertNotNull(paramBLOB.shareBytes(), "length");
/*      */ 
/* 2836 */     needLine();
/*      */ 
/* 2838 */     long l = 0L;
/*      */     try
/*      */     {
/* 2842 */       l = this.blobMsg.getLength(paramBLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2847 */       handleIOException(localIOException);
/*      */ 
/* 2849 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2850 */       localSQLException.fillInStackTrace();
/* 2851 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2856 */     return l;
/*      */   }
/*      */ 
/*      */   public long position(BLOB paramBLOB, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2873 */     assertLoggedOn("position");
/* 2874 */     assertNotNull(paramBLOB.shareBytes(), "position");
/*      */ 
/* 2877 */     if (paramLong < 1L)
/*      */     {
/* 2880 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2881 */       localSQLException.fillInStackTrace();
/* 2882 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2887 */     long l = LobPlsqlUtil.hasPattern(paramBLOB, paramArrayOfByte, paramLong);
/*      */ 
/* 2889 */     l = l == 0L ? -1L : l;
/*      */ 
/* 2891 */     return l;
/*      */   }
/*      */ 
/*      */   public long position(BLOB paramBLOB1, BLOB paramBLOB2, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2907 */     assertLoggedOn("position");
/* 2908 */     assertNotNull(paramBLOB1.shareBytes(), "position");
/* 2909 */     assertNotNull(paramBLOB2.shareBytes(), "position");
/*      */ 
/* 2912 */     if (paramLong < 1L)
/*      */     {
/* 2915 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2916 */       localSQLException.fillInStackTrace();
/* 2917 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2922 */     long l = LobPlsqlUtil.isSubLob(paramBLOB1, paramBLOB2, paramLong);
/*      */ 
/* 2924 */     l = l == 0L ? -1L : l;
/*      */ 
/* 2926 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getBytes(BLOB paramBLOB, long paramLong, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2943 */     assertLoggedOn("getBytes");
/* 2944 */     assertNotNull(paramBLOB.shareBytes(), "getBytes");
/*      */     SQLException localSQLException1;
/* 2947 */     if (paramLong < 1L)
/*      */     {
/* 2950 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getBytes()");
/* 2951 */       localSQLException1.fillInStackTrace();
/* 2952 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2959 */     if (this.pipeState != -1)
/*      */     {
/* 2962 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 453, "getBytes()");
/* 2963 */       localSQLException1.fillInStackTrace();
/* 2964 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2968 */     if ((paramInt <= 0) || (paramArrayOfByte == null)) {
/* 2969 */       return 0;
/*      */     }
/*      */ 
/* 2972 */     long l1 = 0L;
/*      */ 
/* 2974 */     long l2 = -1L;
/*      */ 
/* 2976 */     if (paramBLOB.isActivePrefetch())
/*      */     {
/* 2978 */       byte[] arrayOfByte = paramBLOB.getPrefetchedData();
/* 2979 */       int i = paramBLOB.getPrefetchedDataSize();
/* 2980 */       l2 = paramBLOB.length();
/* 2981 */       int j = 0;
/*      */ 
/* 2983 */       if (arrayOfByte != null) {
/* 2984 */         j = Math.min(i, arrayOfByte.length);
/*      */       }
/* 2986 */       if ((j > 0) && (paramLong <= j))
/*      */       {
/* 2990 */         int k = Math.min(j - (int)paramLong + 1, paramInt);
/*      */ 
/* 2993 */         System.arraycopy(arrayOfByte, (int)paramLong - 1, paramArrayOfByte, 0, k);
/* 2994 */         l1 += k;
/*      */       }
/*      */     }
/*      */ 
/* 2998 */     if ((l1 < paramInt) && ((l2 == -1L) || (paramLong - 1L + l1 < l2)))
/*      */     {
/* 3000 */       needLine();
/*      */       try
/*      */       {
/* 3004 */         l1 += this.blobMsg.read(paramBLOB.shareBytes(), paramLong + l1, paramInt - l1, paramArrayOfByte, (int)l1);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 3013 */         handleIOException(localIOException);
/*      */ 
/* 3015 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3016 */         localSQLException2.fillInStackTrace();
/* 3017 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3024 */     return (int)l1;
/*      */   }
/*      */ 
/*      */   public synchronized int putBytes(BLOB paramBLOB, long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3044 */     assertLoggedOn("putBytes");
/* 3045 */     assertNotNull(paramBLOB.shareBytes(), "putBytes");
/*      */ 
/* 3048 */     if (paramLong < 1L)
/*      */     {
/* 3051 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "putBytes()");
/* 3052 */       localSQLException1.fillInStackTrace();
/* 3053 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3058 */     if ((paramArrayOfByte == null) || (paramInt2 <= 0)) {
/* 3059 */       return 0;
/*      */     }
/* 3061 */     needLine();
/*      */ 
/* 3063 */     long l = 0L;
/*      */ 
/* 3065 */     if (paramInt2 != 0)
/*      */     {
/*      */       try
/*      */       {
/* 3070 */         paramBLOB.setActivePrefetch(false);
/* 3071 */         paramBLOB.clearCachedData();
/* 3072 */         l = this.blobMsg.write(paramBLOB.shareBytes(), paramLong, paramArrayOfByte, paramInt1, paramInt2);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 3078 */         handleIOException(localIOException);
/*      */ 
/* 3080 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3081 */         localSQLException2.fillInStackTrace();
/* 3082 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3088 */     return (int)l;
/*      */   }
/*      */ 
/*      */   public synchronized int getChunkSize(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 3100 */     assertLoggedOn("getChunkSize");
/* 3101 */     assertNotNull(paramBLOB.shareBytes(), "getChunkSize");
/*      */ 
/* 3103 */     needLine();
/*      */ 
/* 3105 */     long l = 0L;
/*      */     try
/*      */     {
/* 3109 */       l = this.blobMsg.getChunkSize(paramBLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3114 */       handleIOException(localIOException);
/*      */ 
/* 3116 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3117 */       localSQLException.fillInStackTrace();
/* 3118 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3123 */     return (int)l;
/*      */   }
/*      */ 
/*      */   public synchronized void trim(BLOB paramBLOB, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3137 */     assertLoggedOn("trim");
/* 3138 */     assertNotNull(paramBLOB.shareBytes(), "trim");
/*      */ 
/* 3141 */     if (paramLong < 0L)
/*      */     {
/* 3144 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "trim()");
/* 3145 */       localSQLException1.fillInStackTrace();
/* 3146 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3151 */     needLine();
/*      */     try
/*      */     {
/* 3156 */       paramBLOB.setActivePrefetch(false);
/* 3157 */       paramBLOB.clearCachedData();
/* 3158 */       this.blobMsg.trim(paramBLOB.shareBytes(), paramLong);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3163 */       handleIOException(localIOException);
/*      */ 
/* 3165 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3166 */       localSQLException2.fillInStackTrace();
/* 3167 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized BLOB createTemporaryBlob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3189 */     assertLoggedOn("createTemporaryBlob");
/*      */ 
/* 3191 */     needLine();
/*      */ 
/* 3193 */     BLOB localBLOB = null;
/*      */     try
/*      */     {
/* 3197 */       localBLOB = (BLOB)this.blobMsg.createTemporaryLob(this, paramBoolean, paramInt);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3202 */       handleIOException(localIOException);
/*      */ 
/* 3204 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3205 */       localSQLException.fillInStackTrace();
/* 3206 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3211 */     return localBLOB;
/*      */   }
/*      */ 
/*      */   private final synchronized Long getLocatorHash(byte[] paramArrayOfByte)
/*      */   {
/* 3237 */     this.checksumEngine.reset();
/*      */ 
/* 3239 */     this.checksumEngine.update(paramArrayOfByte, 10, 10);
/* 3240 */     long l = this.checksumEngine.getValue();
/* 3241 */     Long localLong = Long.valueOf(l);
/*      */ 
/* 3243 */     return localLong;
/*      */   }
/*      */ 
/*      */   public final synchronized int decrementTempLobReferenceCount(byte[] paramArrayOfByte)
/*      */   {
/* 3253 */     int i = 0;
/* 3254 */     if ((this.enableTempLobRefCnt) && (paramArrayOfByte != null) && (paramArrayOfByte.length == 40) && (((paramArrayOfByte[7] & 0x1) > 0) || ((paramArrayOfByte[4] & 0x40) > 0)))
/*      */     {
/* 3260 */       Long localLong = getLocatorHash(paramArrayOfByte);
/* 3261 */       Integer localInteger = (Integer)this.tempLobRefCount.get(localLong);
/* 3262 */       if (localInteger != null)
/*      */       {
/* 3264 */         i = localInteger.intValue() - 1;
/* 3265 */         if (i == 0)
/* 3266 */           this.tempLobRefCount.remove(localLong);
/*      */         else {
/* 3268 */           this.tempLobRefCount.put(localLong, Integer.valueOf(i));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3279 */     return i;
/*      */   }
/*      */ 
/*      */   public final synchronized void incrementTempLobReferenceCount(byte[] paramArrayOfByte)
/*      */   {
/* 3285 */     if ((this.enableTempLobRefCnt) && (paramArrayOfByte != null) && (paramArrayOfByte.length == 40) && (((paramArrayOfByte[7] & 0x1) > 0) || ((paramArrayOfByte[4] & 0x40) > 0)))
/*      */     {
/* 3291 */       Long localLong = getLocatorHash(paramArrayOfByte);
/* 3292 */       Integer localInteger = (Integer)this.tempLobRefCount.get(localLong);
/*      */ 
/* 3294 */       if (localInteger != null)
/*      */       {
/* 3296 */         int i = localInteger.intValue();
/*      */ 
/* 3298 */         this.tempLobRefCount.put(localLong, Integer.valueOf(i + 1));
/*      */       }
/*      */       else
/*      */       {
/* 3303 */         this.tempLobRefCount.put(localLong, Integer.valueOf(1));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void freeTemporary(BLOB paramBLOB, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3320 */     assertLoggedOn("freeTemporary");
/* 3321 */     assertNotNull(paramBLOB.shareBytes(), "freeTemporary");
/*      */ 
/* 3323 */     needLine();
/*      */     try
/*      */     {
/* 3327 */       this.blobMsg.freeTemporaryLob(paramBLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3332 */       handleIOException(localIOException);
/*      */ 
/* 3334 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3335 */       localSQLException.fillInStackTrace();
/* 3336 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isTemporary(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 3355 */     assertNotNull(paramBLOB.shareBytes(), "isTemporary");
/*      */ 
/* 3359 */     boolean bool = false;
/* 3360 */     byte[] arrayOfByte = paramBLOB.shareBytes();
/*      */ 
/* 3362 */     if (((arrayOfByte[7] & 0x1) > 0) || ((arrayOfByte[4] & 0x40) > 0)) {
/* 3363 */       bool = true;
/*      */     }
/* 3365 */     return bool;
/*      */   }
/*      */ 
/*      */   public synchronized void open(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3378 */     assertLoggedOn("open");
/* 3379 */     assertNotNull(paramBLOB.shareBytes(), "open");
/*      */ 
/* 3381 */     needLine();
/*      */     try
/*      */     {
/* 3385 */       this.blobMsg.open(paramBLOB.shareBytes(), paramInt);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3390 */       handleIOException(localIOException);
/*      */ 
/* 3392 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3393 */       localSQLException.fillInStackTrace();
/* 3394 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void close(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 3409 */     assertLoggedOn("close");
/* 3410 */     assertNotNull(paramBLOB.shareBytes(), "close");
/*      */ 
/* 3412 */     needLine();
/*      */     try
/*      */     {
/* 3416 */       this.blobMsg.close(paramBLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3421 */       handleIOException(localIOException);
/*      */ 
/* 3423 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3424 */       localSQLException.fillInStackTrace();
/* 3425 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 3441 */     assertLoggedOn("isOpen");
/* 3442 */     assertNotNull(paramBLOB.shareBytes(), "isOpen");
/*      */ 
/* 3444 */     needLine();
/*      */ 
/* 3446 */     boolean bool = false;
/*      */     try
/*      */     {
/* 3450 */       bool = this.blobMsg.isOpen(paramBLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3455 */       handleIOException(localIOException);
/*      */ 
/* 3457 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3458 */       localSQLException.fillInStackTrace();
/* 3459 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3464 */     return bool;
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BLOB paramBLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3483 */     return newInputStream(paramBLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3502 */     if (paramLong == 0L)
/*      */     {
/* 3504 */       return new OracleBlobInputStream(paramOracleBlob, paramInt);
/*      */     }
/*      */ 
/* 3508 */     return new OracleBlobInputStream(paramOracleBlob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BLOB paramBLOB, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 3528 */     return newInputStream(paramBLOB, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 3547 */     return new OracleBlobInputStream(paramOracleBlob, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(BLOB paramBLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3566 */     return newOutputStream(paramBLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3585 */     if (paramLong == 0L)
/*      */     {
/* 3587 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 3590 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3591 */         localSQLException.fillInStackTrace();
/* 3592 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3597 */       return new OracleBlobOutputStream(paramOracleBlob, paramInt);
/*      */     }
/*      */ 
/* 3602 */     return new OracleBlobOutputStream(paramOracleBlob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3621 */     return newConversionInputStream(paramBLOB, paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(OracleBlob paramOracleBlob, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3639 */     assertNotNull(paramOracleBlob.shareBytes(), "newConversionInputStream");
/*      */ 
/* 3641 */     OracleConversionInputStream localOracleConversionInputStream = new OracleConversionInputStream(this.conversion, paramOracleBlob.getBinaryStream(), paramInt);
/*      */ 
/* 3644 */     return localOracleConversionInputStream;
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3662 */     return newConversionReader(paramBLOB, paramInt);
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(OracleBlob paramOracleBlob, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3680 */     assertNotNull(paramOracleBlob.shareBytes(), "newConversionReader");
/*      */ 
/* 3682 */     OracleConversionReader localOracleConversionReader = new OracleConversionReader(this.conversion, paramOracleBlob.getBinaryStream(), paramInt);
/*      */ 
/* 3685 */     return localOracleConversionReader;
/*      */   }
/*      */ 
/*      */   public synchronized long length(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3710 */     assertLoggedOn("length");
/* 3711 */     assertNotNull(paramCLOB.shareBytes(), "length");
/*      */ 
/* 3713 */     needLine();
/*      */ 
/* 3715 */     long l = 0L;
/*      */     try
/*      */     {
/* 3719 */       l = this.clobMsg.getLength(paramCLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3724 */       handleIOException(localIOException);
/*      */ 
/* 3726 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3727 */       localSQLException.fillInStackTrace();
/* 3728 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3733 */     return l;
/*      */   }
/*      */ 
/*      */   public long position(CLOB paramCLOB, String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3750 */     if (paramString == null)
/*      */     {
/* 3752 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3753 */       ((SQLException)localObject).fillInStackTrace();
/* 3754 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 3757 */     assertLoggedOn("position");
/* 3758 */     assertNotNull(paramCLOB.shareBytes(), "position");
/*      */ 
/* 3761 */     if (paramLong < 1L)
/*      */     {
/* 3764 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3765 */       ((SQLException)localObject).fillInStackTrace();
/* 3766 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 3771 */     Object localObject = new char[paramString.length()];
/*      */ 
/* 3773 */     paramString.getChars(0, localObject.length, (char[])localObject, 0);
/*      */ 
/* 3775 */     long l = LobPlsqlUtil.hasPattern(paramCLOB, (char[])localObject, paramLong);
/*      */ 
/* 3777 */     l = l == 0L ? -1L : l;
/*      */ 
/* 3779 */     return l;
/*      */   }
/*      */ 
/*      */   public long position(CLOB paramCLOB1, CLOB paramCLOB2, long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 3795 */     if (paramCLOB2 == null)
/*      */     {
/* 3797 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3798 */       localSQLException.fillInStackTrace();
/* 3799 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3802 */     assertLoggedOn("position");
/* 3803 */     assertNotNull(paramCLOB1.shareBytes(), "position");
/* 3804 */     assertNotNull(paramCLOB2.shareBytes(), "position");
/*      */ 
/* 3806 */     if (paramLong < 1L)
/*      */     {
/* 3809 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3810 */       localSQLException.fillInStackTrace();
/* 3811 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3815 */     long l = LobPlsqlUtil.isSubLob(paramCLOB1, paramCLOB2, paramLong);
/*      */ 
/* 3817 */     l = l == 0L ? -1L : l;
/*      */ 
/* 3819 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getChars(CLOB paramCLOB, long paramLong, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 3836 */     assertLoggedOn("getChars");
/* 3837 */     assertNotNull(paramCLOB.shareBytes(), "getChars");
/*      */     SQLException localSQLException1;
/* 3839 */     if (paramLong < 1L)
/*      */     {
/* 3842 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getChars()");
/* 3843 */       localSQLException1.fillInStackTrace();
/* 3844 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3850 */     if (this.pipeState != -1)
/*      */     {
/* 3853 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 453, "getChars()");
/* 3854 */       localSQLException1.fillInStackTrace();
/* 3855 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3860 */     if ((paramInt <= 0) || (paramArrayOfChar == null)) {
/* 3861 */       return 0;
/*      */     }
/*      */ 
/* 3864 */     long l1 = 0L;
/*      */ 
/* 3867 */     long l2 = -1L;
/*      */ 
/* 3870 */     if (paramCLOB.isActivePrefetch())
/*      */     {
/* 3872 */       l2 = paramCLOB.length();
/* 3873 */       char[] arrayOfChar = paramCLOB.getPrefetchedData();
/* 3874 */       int i = paramCLOB.getPrefetchedDataSize();
/*      */ 
/* 3876 */       int j = 0;
/* 3877 */       if (arrayOfChar != null) {
/* 3878 */         j = Math.min(i, arrayOfChar.length);
/*      */       }
/* 3880 */       if ((j > 0) && (paramLong <= j))
/*      */       {
/* 3884 */         int k = Math.min(j - (int)paramLong + 1, paramInt);
/*      */ 
/* 3888 */         System.arraycopy(arrayOfChar, (int)paramLong - 1, paramArrayOfChar, 0, k);
/* 3889 */         l1 += k;
/*      */       }
/*      */     }
/*      */ 
/* 3893 */     if ((l1 < paramInt) && ((l2 == -1L) || (paramLong - 1L + l1 < l2)))
/*      */     {
/* 3896 */       needLine();
/*      */       try
/*      */       {
/* 3899 */         boolean bool = paramCLOB.isNCLOB();
/*      */ 
/* 3901 */         l1 += this.clobMsg.read(paramCLOB.shareBytes(), paramLong + l1, paramInt - l1, bool, paramArrayOfChar, (int)l1);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 3911 */         handleIOException(localIOException);
/*      */ 
/* 3913 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3914 */         localSQLException2.fillInStackTrace();
/* 3915 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3922 */     return (int)l1;
/*      */   }
/*      */ 
/*      */   public synchronized int putChars(CLOB paramCLOB, long paramLong, char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3942 */     assertLoggedOn("putChars");
/* 3943 */     assertNotNull(paramCLOB.shareBytes(), "putChars");
/*      */ 
/* 3945 */     if (paramLong < 1L)
/*      */     {
/* 3948 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "putChars()");
/* 3949 */       localSQLException1.fillInStackTrace();
/* 3950 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3954 */     if ((paramArrayOfChar == null) || (paramInt2 <= 0)) {
/* 3955 */       return 0;
/*      */     }
/* 3957 */     needLine();
/*      */ 
/* 3959 */     long l = 0L;
/*      */ 
/* 3961 */     if (paramInt2 != 0)
/*      */     {
/*      */       try
/*      */       {
/* 3965 */         boolean bool = paramCLOB.isNCLOB();
/*      */ 
/* 3967 */         paramCLOB.setActivePrefetch(false);
/* 3968 */         paramCLOB.clearCachedData();
/* 3969 */         l = this.clobMsg.write(paramCLOB.shareBytes(), paramLong, bool, paramArrayOfChar, paramInt1, paramInt2);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 3975 */         handleIOException(localIOException);
/*      */ 
/* 3977 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3978 */         localSQLException2.fillInStackTrace();
/* 3979 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3985 */     return (int)l;
/*      */   }
/*      */ 
/*      */   public synchronized int getChunkSize(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3997 */     assertLoggedOn("getChunkSize");
/* 3998 */     assertNotNull(paramCLOB.shareBytes(), "getChunkSize");
/*      */ 
/* 4000 */     needLine();
/*      */ 
/* 4002 */     long l = 0L;
/*      */     try
/*      */     {
/* 4006 */       l = this.clobMsg.getChunkSize(paramCLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4011 */       handleIOException(localIOException);
/*      */ 
/* 4013 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4014 */       localSQLException.fillInStackTrace();
/* 4015 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4020 */     return (int)l;
/*      */   }
/*      */ 
/*      */   public synchronized void trim(CLOB paramCLOB, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4034 */     assertLoggedOn("trim");
/* 4035 */     assertNotNull(paramCLOB.shareBytes(), "trim");
/*      */ 
/* 4038 */     if (paramLong < 0L)
/*      */     {
/* 4041 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "trim()");
/* 4042 */       localSQLException1.fillInStackTrace();
/* 4043 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 4048 */     needLine();
/*      */     try
/*      */     {
/* 4053 */       paramCLOB.setActivePrefetch(false);
/* 4054 */       paramCLOB.clearCachedData();
/* 4055 */       this.clobMsg.trim(paramCLOB.shareBytes(), paramLong);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4060 */       handleIOException(localIOException);
/*      */ 
/* 4062 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4063 */       localSQLException2.fillInStackTrace();
/* 4064 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized CLOB createTemporaryClob(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 4087 */     assertLoggedOn("createTemporaryClob");
/*      */ 
/* 4090 */     if ((paramShort != 2) && (paramShort != 1))
/*      */     {
/* 4094 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 184);
/* 4095 */       ((SQLException)localObject).fillInStackTrace();
/* 4096 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 4100 */     needLine();
/*      */ 
/* 4102 */     Object localObject = null;
/*      */     try
/*      */     {
/* 4106 */       localObject = (CLOB)this.clobMsg.createTemporaryLob(this, paramBoolean, paramInt, paramShort);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4112 */       handleIOException(localIOException);
/*      */ 
/* 4114 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4115 */       localSQLException.fillInStackTrace();
/* 4116 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4121 */     return localObject;
/*      */   }
/*      */ 
/*      */   public synchronized void freeTemporary(CLOB paramCLOB, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4136 */     assertLoggedOn("freeTemporary");
/* 4137 */     assertNotNull(paramCLOB.shareBytes(), "freeTemporary");
/*      */ 
/* 4139 */     needLine();
/*      */     try
/*      */     {
/* 4143 */       this.clobMsg.freeTemporaryLob(paramCLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4148 */       handleIOException(localIOException);
/*      */ 
/* 4150 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4151 */       localSQLException.fillInStackTrace();
/* 4152 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isTemporary(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 4173 */     boolean bool = false;
/* 4174 */     byte[] arrayOfByte = paramCLOB.shareBytes();
/*      */ 
/* 4176 */     if (((arrayOfByte[7] & 0x1) > 0) || ((arrayOfByte[4] & 0x40) > 0)) {
/* 4177 */       bool = true;
/*      */     }
/* 4179 */     return bool;
/*      */   }
/*      */ 
/*      */   public synchronized void open(CLOB paramCLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4192 */     assertLoggedOn("open");
/* 4193 */     assertNotNull(paramCLOB.shareBytes(), "open");
/*      */ 
/* 4195 */     needLine();
/*      */     try
/*      */     {
/* 4199 */       this.clobMsg.open(paramCLOB.shareBytes(), paramInt);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4204 */       handleIOException(localIOException);
/*      */ 
/* 4206 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4207 */       localSQLException.fillInStackTrace();
/* 4208 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void close(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 4223 */     assertLoggedOn("close");
/* 4224 */     assertNotNull(paramCLOB.shareBytes(), "close");
/*      */ 
/* 4226 */     needLine();
/*      */     try
/*      */     {
/* 4230 */       this.clobMsg.close(paramCLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4235 */       handleIOException(localIOException);
/*      */ 
/* 4237 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4238 */       localSQLException.fillInStackTrace();
/* 4239 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 4255 */     assertLoggedOn("isOpen");
/* 4256 */     assertNotNull(paramCLOB.shareBytes(), "isOpen");
/*      */ 
/* 4258 */     boolean bool = false;
/*      */ 
/* 4260 */     needLine();
/*      */     try
/*      */     {
/* 4264 */       bool = this.clobMsg.isOpen(paramCLOB.shareBytes());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4269 */       handleIOException(localIOException);
/*      */ 
/* 4271 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4272 */       localSQLException.fillInStackTrace();
/* 4273 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4278 */     return bool;
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(CLOB paramCLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4297 */     return newInputStream(paramCLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleClob paramOracleClob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4316 */     if (paramLong == 0L)
/*      */     {
/* 4318 */       return new OracleClobInputStream(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 4322 */     return new OracleClobInputStream(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(CLOB paramCLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4343 */     return newOutputStream(paramCLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(OracleClob paramOracleClob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4363 */     if (paramLong == 0L)
/*      */     {
/* 4365 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 4368 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4369 */         localSQLException.fillInStackTrace();
/* 4370 */         throw localSQLException;
/*      */       }
/*      */ 
/* 4375 */       return new OracleClobOutputStream(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 4380 */     return new OracleClobOutputStream(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(CLOB paramCLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4400 */     return newReader(paramCLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(OracleClob paramOracleClob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4419 */     if (paramLong == 0L)
/*      */     {
/* 4421 */       return new OracleClobReader(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 4425 */     return new OracleClobReader(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(CLOB paramCLOB, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 4446 */     return newReader(paramCLOB, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public Reader newReader(OracleClob paramOracleClob, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 4466 */     return new OracleClobReader(paramOracleClob, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public Writer newWriter(CLOB paramCLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4485 */     return newWriter(paramCLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public Writer newWriter(OracleClob paramOracleClob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4504 */     if (paramLong == 0L)
/*      */     {
/* 4506 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 4509 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4510 */         localSQLException.fillInStackTrace();
/* 4511 */         throw localSQLException;
/*      */       }
/*      */ 
/* 4516 */       return new OracleClobWriter(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 4521 */     return new OracleClobWriter(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   void assertLoggedOn(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4547 */     if (!this.isLoggedOn)
/*      */     {
/* 4550 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 430);
/* 4551 */       localSQLException.fillInStackTrace();
/* 4552 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean isLoggedOn()
/*      */   {
/* 4566 */     return this.isLoggedOn;
/*      */   }
/*      */ 
/*      */   void assertNotNull(byte[] paramArrayOfByte, String paramString)
/*      */     throws NullPointerException
/*      */   {
/* 4582 */     if (paramArrayOfByte == null)
/*      */     {
/* 4584 */       throw new NullPointerException("bytes are null");
/*      */     }
/*      */   }
/*      */ 
/*      */   void internalClose()
/*      */     throws SQLException
/*      */   {
/* 4593 */     super.internalClose();
/*      */ 
/* 4601 */     if (this.all8 != null) {
/* 4602 */       this.all8.definesAccessors = null;
/*      */     }
/*      */ 
/* 4605 */     this.isLoggedOn = false;
/*      */     try
/*      */     {
/* 4608 */       if (this.net != null)
/* 4609 */         this.net.disconnect();
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   void doAbort()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 4623 */       this.net.abort();
/*      */     }
/*      */     catch (NetException localNetException)
/*      */     {
/* 4629 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localNetException);
/* 4630 */       localSQLException.fillInStackTrace();
/* 4631 */       throw localSQLException;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4638 */       handleIOException(localIOException);
/*      */ 
/* 4640 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4641 */       localSQLException.fillInStackTrace();
/* 4642 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doDescribeTable(AutoKeyInfo paramAutoKeyInfo) throws SQLException
/*      */   {
/* 4653 */     T4CStatement localT4CStatement = new T4CStatement(this, -1, -1);
/* 4654 */     localT4CStatement.open();
/*      */ 
/* 4656 */     String str1 = paramAutoKeyInfo.getTableName();
/* 4657 */     String str2 = new StringBuilder().append("SELECT * FROM ").append(str1).toString();
/*      */ 
/* 4659 */     localT4CStatement.sqlObject.initialize(str2);
/*      */ 
/* 4661 */     Accessor[] arrayOfAccessor = null;
/*      */     Object localObject;
/*      */     try {
/* 4665 */       this.describe.doODNY(localT4CStatement, 0, arrayOfAccessor, localT4CStatement.sqlObject.getSqlBytes(false, false));
/* 4666 */       arrayOfAccessor = this.describe.getAccessors();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4670 */       handleIOException(localIOException);
/*      */ 
/* 4672 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4673 */       ((SQLException)localObject).fillInStackTrace();
/* 4674 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 4678 */     int i = this.describe.numuds;
/*      */ 
/* 4689 */     paramAutoKeyInfo.allocateSpaceForDescribedData(i);
/*      */ 
/* 4691 */     for (int i1 = 0; i1 < i; i1++)
/*      */     {
/* 4693 */       Accessor localAccessor = arrayOfAccessor[i1];
/* 4694 */       localObject = localAccessor.columnName;
/* 4695 */       int j = localAccessor.describeType;
/* 4696 */       int k = localAccessor.describeMaxLength;
/* 4697 */       boolean bool = localAccessor.nullable;
/* 4698 */       short s = localAccessor.formOfUse;
/* 4699 */       int m = localAccessor.precision;
/* 4700 */       int n = localAccessor.scale;
/* 4701 */       String str3 = localAccessor.describeTypeName;
/*      */ 
/* 4703 */       paramAutoKeyInfo.fillDescribedData(i1, (String)localObject, j, k, bool, s, m, n, str3);
/*      */     }
/*      */ 
/* 4707 */     localT4CStatement.close();
/*      */   }
/*      */ 
/*      */   void doSetApplicationContext(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4718 */     Namespace localNamespace = (Namespace)this.namespaces.get(paramString1);
/* 4719 */     if (localNamespace == null)
/*      */     {
/* 4721 */       localNamespace = new Namespace(paramString1);
/* 4722 */       this.namespaces.put(paramString1, localNamespace);
/*      */     }
/* 4724 */     localNamespace.setAttribute(paramString2, paramString3);
/*      */   }
/*      */ 
/*      */   void doClearAllApplicationContext(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4733 */     Namespace localNamespace = new Namespace(paramString);
/* 4734 */     localNamespace.clear();
/* 4735 */     this.namespaces.put(paramString, localNamespace);
/*      */   }
/*      */ 
/*      */   public void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 4743 */     super.getPropertyForPooledConnection(paramOraclePooledConnection, this.password);
/*      */   }
/*      */ 
/*      */   final void getPasswordInternal(T4CXAResource paramT4CXAResource)
/*      */     throws SQLException
/*      */   {
/* 4751 */     paramT4CXAResource.setPasswordInternal(this.password);
/*      */   }
/*      */ 
/*      */   synchronized void doEnqueue(String paramString, AQEnqueueOptions paramAQEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[][] paramArrayOfByte, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 4769 */       needLine();
/* 4770 */       this.aqe.doOAQEQ(paramString, paramAQEnqueueOptions, paramAQMessagePropertiesI, paramArrayOfByte2, paramArrayOfByte1, paramBoolean);
/*      */ 
/* 4777 */       if (paramAQEnqueueOptions.getRetrieveMessageId())
/* 4778 */         paramArrayOfByte[0] = this.aqe.getMessageId();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4782 */       handleIOException(localIOException);
/*      */ 
/* 4784 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4785 */       localSQLException.fillInStackTrace();
/* 4786 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized boolean doDequeue(String paramString, AQDequeueOptions paramAQDequeueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, byte[] paramArrayOfByte, byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4803 */     boolean bool = false;
/*      */     try
/*      */     {
/* 4806 */       needLine();
/* 4807 */       this.aqdq.doOAQDQ(paramString, paramAQDequeueOptions, paramArrayOfByte, paramBoolean, paramAQMessagePropertiesI);
/*      */ 
/* 4813 */       paramArrayOfByte1[0] = this.aqdq.getPayload();
/* 4814 */       paramArrayOfByte2[0] = this.aqdq.getDequeuedMessageId();
/* 4815 */       bool = this.aqdq.hasAMessageBeenDequeued();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4819 */       handleIOException(localIOException);
/*      */ 
/* 4821 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4822 */       localSQLException.fillInStackTrace();
/* 4823 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4826 */     return bool;
/*      */   }
/*      */ 
/*      */   synchronized void doJMSEnqueue(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessageProperties paramJMSMessageProperties, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[][] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 4842 */       needLine();
/* 4843 */       this.oaqenq.doJMSEnq(paramString, paramJMSEnqueueOptions, paramAQMessagePropertiesI, paramJMSMessageProperties, paramArrayOfByte1, paramArrayOfByte2);
/*      */ 
/* 4851 */       if (paramJMSEnqueueOptions.isRetrieveMessageId())
/* 4852 */         paramArrayOfByte[0] = this.oaqenq.getMsgId();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4856 */       handleIOException(localIOException);
/*      */ 
/* 4858 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4859 */       localSQLException.fillInStackTrace();
/* 4860 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized boolean doJmsDequeue(String paramString, JMSDequeueOptions paramJMSDequeueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessagePropertiesI paramJMSMessagePropertiesI, byte[] paramArrayOfByte, byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 4875 */     boolean bool = false;
/*      */     try
/*      */     {
/* 4878 */       needLine();
/* 4879 */       this.oaqdeq.doJMSDeq(paramString, paramJMSDequeueOptions, paramArrayOfByte, paramAQMessagePropertiesI, paramJMSMessagePropertiesI);
/* 4880 */       paramArrayOfByte1[0] = this.oaqdeq.getPayload();
/* 4881 */       paramArrayOfByte2[0] = this.oaqdeq.getDequeuedMessageId();
/* 4882 */       bool = this.oaqdeq.isHasAMessageBeenDequeued();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4886 */       handleIOException(localIOException);
/* 4887 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4888 */       localSQLException.fillInStackTrace();
/* 4889 */       throw localSQLException;
/*      */     }
/* 4891 */     return bool;
/*      */   }
/*      */ 
/*      */   synchronized int doPingDatabase() throws SQLException
/*      */   {
/* 4896 */     if (this.versionNumber >= 10102)
/*      */     {
/*      */       try
/*      */       {
/* 4900 */         needLine();
/* 4901 */         this.oping.doOPING();
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 4905 */         return -1;
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/* 4909 */         return -1;
/*      */       }
/* 4911 */       return 0;
/*      */     }
/*      */ 
/* 4915 */     return super.doPingDatabase();
/*      */   }
/*      */ 
/*      */   synchronized Map<String, JMSNotificationRegistration> doRegisterJMSNotification(String[] paramArrayOfString, Map<String, Properties> paramMap)
/*      */     throws SQLException
/*      */   {
/* 4936 */     assert (this.databaseUniqueIdentifier != null) : "databaseUniqueIdentifier is null";
/* 4937 */     String str = null;
/* 4938 */     int i = paramArrayOfString.length;
/* 4939 */     int[] arrayOfInt1 = new int[i];
/* 4940 */     int[] arrayOfInt2 = new int[i];
/* 4941 */     int[] arrayOfInt3 = new int[i];
/* 4942 */     int[] arrayOfInt4 = new int[i];
/* 4943 */     int[] arrayOfInt5 = new int[i];
/*      */ 
/* 4945 */     byte[][] arrayOfByte = new byte[i][];
/* 4946 */     NTFJMSPerDatabaseManager localNTFJMSPerDatabaseManager = PhysicalConnection.ntfManager.getJMSPerDatabaseManager(this.databaseUniqueIdentifier);
/*      */ 
/* 4948 */     HashMap localHashMap = new HashMap();
/*      */ 
/* 4951 */     for (int j = 0; j < i; j++) {
/* 4952 */       arrayOfInt2[j] = 1;
/* 4953 */       arrayOfInt3[j] = 0;
/* 4954 */       arrayOfInt1[j] = PhysicalConnection.ntfManager.getNextJdbcRegId();
/* 4955 */       arrayOfByte[j] = new byte[4];
/* 4956 */       arrayOfByte[j][0] = ((byte)((arrayOfInt1[j] & 0xFF000000) >> 24));
/* 4957 */       arrayOfByte[j][1] = ((byte)((arrayOfInt1[j] & 0xFF0000) >> 16));
/* 4958 */       arrayOfByte[j][2] = ((byte)((arrayOfInt1[j] & 0xFF00) >> 8));
/* 4959 */       arrayOfByte[j][3] = ((byte)(arrayOfInt1[j] & 0xFF));
/* 4960 */       Properties localProperties = (Properties)paramMap.get(paramArrayOfString[j]);
/* 4961 */       if (localProperties != null) {
/* 4962 */         if (localProperties.getProperty("NTF_QOS_RELIABLE", "false").equalsIgnoreCase("true")) {
/* 4963 */           arrayOfInt4[j] |= 1;
/*      */         }
/* 4965 */         if (localProperties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").equalsIgnoreCase("true")) {
/* 4966 */           arrayOfInt4[j] |= 16;
/*      */         }
/* 4968 */         if (localProperties.getProperty("NTF_AQ_PAYLOAD", "false").equalsIgnoreCase("true")) {
/* 4969 */           arrayOfInt4[j] |= 2;
/*      */         }
/* 4971 */         if (localProperties.getProperty("NTF_ASYNC_DEQ", "false").equalsIgnoreCase("true")) {
/* 4972 */           arrayOfInt4[j] |= 512;
/*      */         }
/* 4974 */         if (localProperties.getProperty("NTF_QOS_SECURE", "false").equalsIgnoreCase("true")) {
/* 4975 */           arrayOfInt4[j] |= 8;
/*      */         }
/* 4977 */         if (localProperties.getProperty("NTF_QOS_TX_ACK", "false").equalsIgnoreCase("true")) {
/* 4978 */           arrayOfInt4[j] |= 2048;
/*      */         }
/* 4980 */         if (localProperties.getProperty("NTF_QOS_AUTO_ACK", "false").equalsIgnoreCase("true")) {
/* 4981 */           arrayOfInt4[j] |= 1024;
/*      */         }
/* 4983 */         arrayOfInt5[j] = readNTFtimeout(localProperties);
/*      */       }
/*      */     }
/* 4986 */     synchronized (localNTFJMSPerDatabaseManager) {
/* 4987 */       if (localNTFJMSPerDatabaseManager.isInitialized)
/* 4988 */         str = localNTFJMSPerDatabaseManager.getJMSClientId();
/*      */       Object localObject2;
/*      */       try {
/* 4991 */         this.okpn.doOKPN(1, 4, this.userName, str, i, arrayOfInt2, paramArrayOfString, arrayOfByte, arrayOfInt3, arrayOfInt4, arrayOfInt5, null, null, null, null, null, null, null, null, null);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 5013 */         handleIOException(localIOException);
/*      */ 
/* 5015 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5016 */         ((SQLException)localObject2).fillInStackTrace();
/* 5017 */         throw ((Throwable)localObject2);
/*      */       }
/*      */       Object localObject3;
/* 5023 */       if (!localNTFJMSPerDatabaseManager.isInitialized)
/*      */       {
/* 5026 */         str = this.okpn.getJMSClientId();
/* 5027 */         if (str == null)
/*      */         {
/* 5029 */           localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 287, "clientID returned by server is null");
/* 5030 */           ((SQLException)localObject1).fillInStackTrace();
/* 5031 */           throw ((Throwable)localObject1);
/*      */         }
/*      */ 
/* 5034 */         localObject1 = this.okpn.getDatabaseInstances();
/* 5035 */         if ((localObject1 == null) || (localObject1.length == 0)) {
/* 5036 */           localObject1 = new String[1];
/* 5037 */           localObject1[0] = this.instanceName;
/*      */         }
/* 5039 */         localObject2 = this.okpn.getListenerAddresses();
/* 5040 */         if (localObject2 == null)
/*      */         {
/* 5042 */           localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 287, "listenerAddress returned by server is null");
/* 5043 */           ((SQLException)localObject3).fillInStackTrace();
/* 5044 */           throw ((Throwable)localObject3);
/*      */         }
/*      */ 
/* 5047 */         localNTFJMSPerDatabaseManager.init(str, (String[])localObject1, (ArrayList)localObject2);
/*      */       }
/*      */ 
/* 5053 */       Object localObject1 = this.net.getSessionAttributes().getcOption().service_name;
/*      */ 
/* 5055 */       if (localObject1 == null)
/*      */       {
/* 5057 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 287, "No service name found,please use a service name format URL to create a connection");
/* 5058 */         ((SQLException)localObject2).fillInStackTrace();
/* 5059 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/* 5068 */       localNTFJMSPerDatabaseManager.startJMSListenerConnection((String)localObject1, this.userName, this.password);
/*      */ 
/* 5072 */       long[] arrayOfLong = this.okpn.getRegistrationIdArray();
/*      */ 
/* 5074 */       assert (arrayOfLong.length == arrayOfInt1.length) : new StringBuilder().append("jmsRegIdArr.length = ").append(arrayOfLong.length).append(", jdbcRegIdArr.length = ").append(arrayOfInt1.length).toString();
/*      */ 
/* 5079 */       for (int k = 0; k < i; k++) {
/* 5080 */         localObject3 = (Properties)paramMap.get(paramArrayOfString[k]);
/* 5081 */         if (localObject3 == null) {
/* 5082 */           localObject3 = new Properties();
/*      */         }
/*      */ 
/* 5085 */         NTFJMSRegistration localNTFJMSRegistration = new NTFJMSRegistration(arrayOfInt1[k], true, this.instanceName, this.userName, (Properties)localObject3, paramArrayOfString[k], this.versionNumber, str);
/*      */ 
/* 5096 */         localNTFJMSRegistration.setJMSRegistrationId(arrayOfLong[k]);
/*      */ 
/* 5098 */         localNTFJMSRegistration.setQOSFlag(arrayOfInt4[k]);
/* 5099 */         localHashMap.put(paramArrayOfString[k], localNTFJMSRegistration);
/*      */ 
/* 5101 */         PhysicalConnection.ntfManager.addRegistration(localNTFJMSRegistration);
/*      */ 
/* 5104 */         localNTFJMSPerDatabaseManager.mapJMSRegIdToJDBCRegId(Long.valueOf(arrayOfLong[k]), arrayOfInt1[k]);
/*      */ 
/* 5106 */         localNTFJMSPerDatabaseManager.incrementNumberOfRegistrations();
/*      */       }
/* 5108 */       return localHashMap;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void doUnregisterJMSNotification(NTFJMSRegistration paramNTFJMSRegistration)
/*      */     throws SQLException
/*      */   {
/* 5120 */     assert (this.databaseUniqueIdentifier != null) : "databaseUniqueIdentifier is null";
/*      */ 
/* 5122 */     PhysicalConnection.ntfManager.removeRegistration(paramNTFJMSRegistration);
/* 5123 */     PhysicalConnection.ntfManager.freeJdbcRegId(paramNTFJMSRegistration.getJdbcRegId());
/* 5124 */     Long localLong = Long.valueOf(paramNTFJMSRegistration.getJMSRegistrationId());
/* 5125 */     paramNTFJMSRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
/*      */ 
/* 5127 */     NTFJMSPerDatabaseManager localNTFJMSPerDatabaseManager = PhysicalConnection.ntfManager.getJMSPerDatabaseManager(this.databaseUniqueIdentifier);
/*      */ 
/* 5129 */     assert (localNTFJMSPerDatabaseManager != null) : "jmsPerDatabaseManager is null";
/* 5130 */     assert (localNTFJMSPerDatabaseManager.isInitialized) : "jmsPerDatabaseManager is not initialized";
/* 5131 */     localNTFJMSPerDatabaseManager.decrementNumberOfRegistrations();
/*      */ 
/* 5134 */     localNTFJMSPerDatabaseManager.closeJMSListenerConnection();
/* 5135 */     localNTFJMSPerDatabaseManager.removeRegistrationId(localLong);
/* 5136 */     String str = localNTFJMSPerDatabaseManager.getJMSClientId();
/*      */ 
/* 5138 */     int[] arrayOfInt1 = { 1 };
/* 5139 */     String[] arrayOfString = new String[1];
/* 5140 */     arrayOfString[0] = paramNTFJMSRegistration.getQueueName();
/* 5141 */     int[] arrayOfInt2 = { 0 };
/* 5142 */     int i = paramNTFJMSRegistration.getQOSFlag();
/* 5143 */     int[] arrayOfInt3 = { i };
/* 5144 */     int[] arrayOfInt4 = { 0 };
/* 5145 */     long[] arrayOfLong = { localLong.longValue() };
/*      */     try {
/* 5147 */       this.okpn.doOKPN(2, 4, this.userName, str, 1, arrayOfInt1, arrayOfString, (byte[][])null, arrayOfInt2, arrayOfInt3, arrayOfInt4, null, null, null, null, null, null, null, null, arrayOfLong);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 5169 */       handleIOException(localIOException);
/*      */ 
/* 5171 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5172 */       localSQLException.fillInStackTrace();
/* 5173 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void doAckJMSNtfn(NTFJMSRegistration paramNTFJMSRegistration, byte[] paramArrayOfByte, short paramShort)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 5185 */       assert (this.databaseUniqueIdentifier != null) : "databaseUniqueIdentifier is null";
/* 5186 */       NTFJMSPerDatabaseManager localNTFJMSPerDatabaseManager = PhysicalConnection.ntfManager.getJMSPerDatabaseManager(this.databaseUniqueIdentifier);
/*      */ 
/* 5188 */       assert (localNTFJMSPerDatabaseManager != null) : "jmsPerDatabaseManager is null";
/* 5189 */       localObject = localNTFJMSPerDatabaseManager.getJMSClientId();
/* 5190 */       this.kpdnrdeq.doOAQEMNDEQ((String)localObject, paramShort, paramArrayOfByte, paramNTFJMSRegistration.getJMSRegistrationId(), paramNTFJMSRegistration.getQueueName());
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 5197 */       handleIOException(localIOException);
/*      */ 
/* 5199 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5200 */       ((SQLException)localObject).fillInStackTrace();
/* 5201 */       throw ((Throwable)localObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized NTFAQRegistration[] doRegisterAQNotification(String[] paramArrayOfString, String paramString, int paramInt, Properties[] paramArrayOfProperties)
/*      */     throws SQLException
/*      */   {
/* 5216 */     int i = paramArrayOfString.length;
/* 5217 */     int[] arrayOfInt1 = new int[i];
/* 5218 */     byte[][] arrayOfByte = new byte[i][];
/* 5219 */     int[] arrayOfInt2 = new int[i];
/* 5220 */     int[] arrayOfInt3 = new int[i];
/* 5221 */     int[] arrayOfInt4 = new int[i];
/* 5222 */     int[] arrayOfInt5 = new int[i];
/* 5223 */     int[] arrayOfInt6 = new int[i];
/* 5224 */     int[] arrayOfInt7 = new int[i];
/* 5225 */     long[] arrayOfLong = new long[i];
/* 5226 */     byte[] arrayOfByte1 = new byte[i];
/* 5227 */     int[] arrayOfInt8 = new int[i];
/* 5228 */     byte[] arrayOfByte2 = new byte[i];
/* 5229 */     TIMESTAMPTZ[] arrayOfTIMESTAMPTZ = new TIMESTAMPTZ[i];
/* 5230 */     int[] arrayOfInt9 = new int[i];
/*      */ 
/* 5232 */     boolean bool1 = false;
/* 5233 */     if (paramInt == 0)
/*      */     {
/* 5236 */       bool1 = true;
/* 5237 */       paramInt = 47632;
/*      */     }
/*      */ 
/* 5240 */     for (int j = 0; j < i; j++)
/*      */     {
/* 5242 */       arrayOfInt1[j] = PhysicalConnection.ntfManager.getNextJdbcRegId();
/* 5243 */       arrayOfByte[j] = new byte[4];
/* 5244 */       arrayOfByte[j][0] = ((byte)((arrayOfInt1[j] & 0xFF000000) >> 24));
/* 5245 */       arrayOfByte[j][1] = ((byte)((arrayOfInt1[j] & 0xFF0000) >> 16));
/* 5246 */       arrayOfByte[j][2] = ((byte)((arrayOfInt1[j] & 0xFF00) >> 8));
/* 5247 */       arrayOfByte[j][3] = ((byte)(arrayOfInt1[j] & 0xFF));
/* 5248 */       arrayOfInt2[j] = 1;
/* 5249 */       arrayOfInt3[j] = 23;
/*      */ 
/* 5252 */       if ((paramArrayOfProperties.length > j) && (paramArrayOfProperties[j] != null))
/*      */       {
/* 5254 */         if (paramArrayOfProperties[j].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0)
/*      */         {
/* 5256 */           arrayOfInt4[j] |= 1;
/* 5257 */         }if (paramArrayOfProperties[j].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0)
/*      */         {
/* 5259 */           arrayOfInt4[j] |= 16;
/* 5260 */         }if (paramArrayOfProperties[j].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0)
/*      */         {
/* 5262 */           arrayOfInt4[j] |= 2;
/* 5263 */         }arrayOfInt5[j] = readNTFtimeout(paramArrayOfProperties[j]);
/*      */       }
/*      */     }
/*      */ 
/* 5267 */     setNtfGroupingOptions(arrayOfByte1, arrayOfInt8, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt9, paramArrayOfProperties);
/*      */ 
/* 5274 */     int[] arrayOfInt10 = new int[1];
/* 5275 */     arrayOfInt10[0] = paramInt;
/*      */ 
/* 5279 */     boolean bool2 = PhysicalConnection.ntfManager.listenOnPortT4C(arrayOfInt10, bool1);
/* 5280 */     paramInt = arrayOfInt10[0];
/*      */ 
/* 5282 */     String str = new StringBuilder().append("(ADDRESS=(PROTOCOL=tcp)(HOST=").append(paramString).append(")(PORT=").append(paramInt).append("))?PR=0").toString();
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/* 5289 */         int k = bool2 ? 1 : 0;
/* 5290 */         this.okpn.doOKPN(1, k, this.userName, str, i, arrayOfInt2, paramArrayOfString, arrayOfByte, arrayOfInt3, arrayOfInt4, arrayOfInt5, arrayOfInt6, arrayOfInt7, arrayOfLong, arrayOfByte1, arrayOfInt8, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt9, arrayOfLong);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 5315 */         handleIOException(localIOException);
/*      */ 
/* 5317 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5318 */         localSQLException2.fillInStackTrace();
/* 5319 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 5325 */       if (bool2) {
/* 5326 */         PhysicalConnection.ntfManager.cleanListenersT4C(paramInt);
/*      */       }
/* 5328 */       throw localSQLException1;
/*      */     }
/* 5330 */     NTFAQRegistration[] arrayOfNTFAQRegistration = new NTFAQRegistration[i];
/*      */ 
/* 5332 */     for (int m = 0; m < i; m++) {
/* 5333 */       arrayOfNTFAQRegistration[m] = new NTFAQRegistration(arrayOfInt1[m], true, this.instanceName, this.userName, paramString, paramInt, paramArrayOfProperties[m], paramArrayOfString[m], this.versionNumber);
/*      */     }
/*      */ 
/* 5343 */     for (m = 0; m < arrayOfNTFAQRegistration.length; m++)
/* 5344 */       PhysicalConnection.ntfManager.addRegistration(arrayOfNTFAQRegistration[m]);
/* 5345 */     return arrayOfNTFAQRegistration;
/*      */   }
/*      */ 
/*      */   private void setNtfGroupingOptions(byte[] paramArrayOfByte1, int[] paramArrayOfInt1, byte[] paramArrayOfByte2, TIMESTAMPTZ[] paramArrayOfTIMESTAMPTZ, int[] paramArrayOfInt2, Properties[] paramArrayOfProperties)
/*      */     throws SQLException
/*      */   {
/* 5364 */     for (int i = 0; i < paramArrayOfProperties.length; i++)
/*      */     {
/* 5366 */       String str1 = paramArrayOfProperties[i].getProperty("NTF_GROUPING_CLASS", "NTF_GROUPING_CLASS_NONE");
/* 5367 */       String str2 = paramArrayOfProperties[i].getProperty("NTF_GROUPING_VALUE");
/* 5368 */       String str3 = paramArrayOfProperties[i].getProperty("NTF_GROUPING_TYPE");
/* 5369 */       TIMESTAMPTZ localTIMESTAMPTZ = null;
/* 5370 */       if (paramArrayOfProperties[i].get("NTF_GROUPING_START_TIME") != null)
/* 5371 */         localTIMESTAMPTZ = (TIMESTAMPTZ)paramArrayOfProperties[i].get("NTF_GROUPING_START_TIME");
/* 5372 */       String str4 = paramArrayOfProperties[i].getProperty("NTF_GROUPING_REPEAT_TIME", "NTF_GROUPING_REPEAT_FOREVER");
/*      */       SQLException localSQLException;
/* 5375 */       if ((str1.compareTo("NTF_GROUPING_CLASS_TIME") != 0) && (str1.compareTo("NTF_GROUPING_CLASS_NONE") != 0))
/*      */       {
/* 5379 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5380 */         localSQLException.fillInStackTrace();
/* 5381 */         throw localSQLException;
/*      */       }
/*      */ 
/* 5386 */       if ((str1.compareTo("NTF_GROUPING_CLASS_NONE") != 0) && (getTTCVersion() < 5))
/*      */       {
/* 5391 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 5392 */         localSQLException.fillInStackTrace();
/* 5393 */         throw localSQLException;
/*      */       }
/*      */ 
/* 5399 */       if (str1.compareTo("NTF_GROUPING_CLASS_TIME") == 0)
/*      */       {
/* 5401 */         paramArrayOfByte1[i] = 1;
/*      */ 
/* 5403 */         paramArrayOfInt1[i] = 600;
/* 5404 */         if (str2 != null) {
/* 5405 */           paramArrayOfInt1[i] = Integer.parseInt(str2);
/*      */         }
/* 5407 */         paramArrayOfByte2[i] = 1;
/* 5408 */         if (str3 != null)
/*      */         {
/* 5410 */           if (str3.compareTo("NTF_GROUPING_TYPE_SUMMARY") == 0) {
/* 5411 */             paramArrayOfByte2[i] = 1;
/* 5412 */           } else if (str3.compareTo("NTF_GROUPING_TYPE_LAST") == 0) {
/* 5413 */             paramArrayOfByte2[i] = 2;
/*      */           }
/*      */           else
/*      */           {
/* 5419 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5420 */             localSQLException.fillInStackTrace();
/* 5421 */             throw localSQLException;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 5426 */         paramArrayOfTIMESTAMPTZ[i] = localTIMESTAMPTZ;
/* 5427 */         if (str4.compareTo("NTF_GROUPING_REPEAT_FOREVER") == 0)
/* 5428 */           paramArrayOfInt2[i] = 0;
/*      */         else
/* 5430 */           paramArrayOfInt2[i] = Integer.parseInt(str4);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void doUnregisterAQNotification(NTFAQRegistration paramNTFAQRegistration)
/*      */     throws SQLException
/*      */   {
/* 5442 */     String str1 = paramNTFAQRegistration.getClientHost();
/* 5443 */     int i = paramNTFAQRegistration.getClientTCPPort();
/* 5444 */     if (str1 == null) {
/* 5445 */       return;
/*      */     }
/*      */ 
/* 5455 */     PhysicalConnection.ntfManager.removeRegistration(paramNTFAQRegistration);
/* 5456 */     PhysicalConnection.ntfManager.freeJdbcRegId(paramNTFAQRegistration.getJdbcRegId());
/* 5457 */     PhysicalConnection.ntfManager.cleanListenersT4C(paramNTFAQRegistration.getClientTCPPort());
/* 5458 */     paramNTFAQRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
/*      */ 
/* 5460 */     String str2 = new StringBuilder().append("(ADDRESS=(PROTOCOL=tcp)(HOST=").append(str1).append(")(PORT=").append(i).append("))?PR=0").toString();
/*      */ 
/* 5463 */     int[] arrayOfInt1 = { 1 };
/* 5464 */     String[] arrayOfString = new String[1];
/* 5465 */     arrayOfString[0] = paramNTFAQRegistration.getQueueName();
/* 5466 */     int[] arrayOfInt2 = { 0 };
/* 5467 */     int[] arrayOfInt3 = { 0 };
/* 5468 */     int[] arrayOfInt4 = { 0 };
/* 5469 */     int[] arrayOfInt5 = { 0 };
/* 5470 */     int[] arrayOfInt6 = { 0 };
/* 5471 */     long[] arrayOfLong = { 0L };
/* 5472 */     byte[] arrayOfByte1 = { 0 };
/* 5473 */     int[] arrayOfInt7 = { 0 };
/* 5474 */     byte[] arrayOfByte2 = { 0 };
/* 5475 */     TIMESTAMPTZ[] arrayOfTIMESTAMPTZ = { null };
/* 5476 */     int[] arrayOfInt8 = { 0 };
/* 5477 */     byte[][] arrayOfByte = new byte[1][];
/* 5478 */     int j = paramNTFAQRegistration.getJdbcRegId();
/* 5479 */     arrayOfByte[0] = new byte[4];
/* 5480 */     arrayOfByte[0][0] = ((byte)((j & 0xFF000000) >> 24));
/* 5481 */     arrayOfByte[0][1] = ((byte)((j & 0xFF0000) >> 16));
/* 5482 */     arrayOfByte[0][2] = ((byte)((j & 0xFF00) >> 8));
/* 5483 */     arrayOfByte[0][3] = ((byte)(j & 0xFF));
/*      */     try
/*      */     {
/* 5486 */       this.okpn.doOKPN(2, 0, this.userName, str2, 1, arrayOfInt1, arrayOfString, arrayOfByte, arrayOfInt2, arrayOfInt3, arrayOfInt4, arrayOfInt5, arrayOfInt6, arrayOfLong, arrayOfByte1, arrayOfInt7, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt8, arrayOfLong);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 5511 */       handleIOException(localIOException);
/*      */ 
/* 5513 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5514 */       localSQLException.fillInStackTrace();
/* 5515 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String paramString, int paramInt1, Properties paramProperties, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 5531 */     int i = 0;
/* 5532 */     int j = 0;
/* 5533 */     int k = 0;
/* 5534 */     int m = 0;
/* 5535 */     int n = 0;
/* 5536 */     Object localObject = null;
/* 5537 */     int i1 = 0;
/* 5538 */     boolean bool1 = false;
/* 5539 */     if (paramInt1 == 0)
/*      */     {
/* 5542 */       bool1 = true;
/* 5543 */       paramInt1 = 47632;
/*      */     }
/*      */ 
/* 5548 */     if (paramProperties.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5550 */       j |= 1;
/* 5551 */     }if (paramProperties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5553 */       j |= 16;
/*      */     }
/*      */ 
/* 5557 */     if (paramProperties.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5559 */       i |= 16;
/*      */     }
/*      */ 
/* 5562 */     if (paramProperties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5564 */       i |= 32;
/*      */     }
/*      */ 
/* 5567 */     if (paramProperties.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5569 */       i |= 64;
/*      */     }
/* 5571 */     int i2 = 0;
/* 5572 */     int i3 = 0;
/* 5573 */     int i4 = 0;
/* 5574 */     if (paramProperties.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5576 */       i2 = 1;
/* 5577 */     }if (paramProperties.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5579 */       i3 = 1;
/* 5580 */     }if (paramProperties.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0)
/*      */     {
/* 5582 */       i4 = 1;
/*      */     }
/* 5584 */     if ((i2 != 0) || (i3 != 0) || (i4 != 0))
/*      */     {
/* 5586 */       i |= 15;
/*      */ 
/* 5590 */       if (i2 != 0)
/* 5591 */         i -= 2;
/* 5592 */       if (i3 != 0)
/* 5593 */         i -= 4;
/* 5594 */       if (i4 != 0) {
/* 5595 */         i -= 8;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5601 */     byte[] arrayOfByte1 = new byte[1];
/* 5602 */     int[] arrayOfInt1 = new int[1];
/* 5603 */     byte[] arrayOfByte2 = new byte[1];
/* 5604 */     TIMESTAMPTZ[] arrayOfTIMESTAMPTZ = new TIMESTAMPTZ[1];
/* 5605 */     int[] arrayOfInt2 = new int[1];
/* 5606 */     Properties[] arrayOfProperties = { paramProperties };
/* 5607 */     setNtfGroupingOptions(arrayOfByte1, arrayOfInt1, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt2, arrayOfProperties);
/*      */ 
/* 5623 */     int[] arrayOfInt3 = new int[1];
/* 5624 */     arrayOfInt3[0] = paramInt1;
/*      */ 
/* 5629 */     boolean bool2 = PhysicalConnection.ntfManager.listenOnPortT4C(arrayOfInt3, bool1);
/* 5630 */     paramInt1 = arrayOfInt3[0];
/*      */ 
/* 5632 */     String str = new StringBuilder().append("(ADDRESS=(PROTOCOL=tcp)(HOST=").append(paramString).append(")(PORT=").append(paramInt1).append("))?PR=0").toString();
/*      */ 
/* 5636 */     int[] arrayOfInt4 = { 2 };
/* 5637 */     String[] arrayOfString = new String[1];
/* 5638 */     int[] arrayOfInt5 = { 23 };
/*      */ 
/* 5641 */     int[] arrayOfInt6 = { j };
/* 5642 */     int[] arrayOfInt7 = { paramInt2 };
/* 5643 */     int[] arrayOfInt8 = { i };
/* 5644 */     int[] arrayOfInt9 = { paramInt3 };
/* 5645 */     long[] arrayOfLong = { 0L };
/* 5646 */     int i5 = PhysicalConnection.ntfManager.getNextJdbcRegId();
/* 5647 */     byte[][] arrayOfByte = new byte[1][];
/* 5648 */     arrayOfByte[0] = new byte[4];
/* 5649 */     arrayOfByte[0][0] = ((byte)((i5 & 0xFF000000) >> 24));
/* 5650 */     arrayOfByte[0][1] = ((byte)((i5 & 0xFF0000) >> 16));
/* 5651 */     arrayOfByte[0][2] = ((byte)((i5 & 0xFF00) >> 8));
/* 5652 */     arrayOfByte[0][3] = ((byte)(i5 & 0xFF));
/* 5653 */     long l = 0L;
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/* 5658 */         int i6 = bool2 ? 1 : 0;
/* 5659 */         this.okpn.doOKPN(1, i6, this.userName, str, 1, arrayOfInt4, arrayOfString, arrayOfByte, arrayOfInt5, arrayOfInt6, arrayOfInt7, arrayOfInt8, arrayOfInt9, arrayOfLong, arrayOfByte1, arrayOfInt1, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt2, arrayOfLong);
/*      */ 
/* 5681 */         l = this.okpn.getRegistrationId();
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 5685 */         handleIOException(localIOException);
/*      */ 
/* 5687 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5688 */         localSQLException2.fillInStackTrace();
/* 5689 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 5695 */       if (bool2) {
/* 5696 */         PhysicalConnection.ntfManager.cleanListenersT4C(paramInt1);
/*      */       }
/* 5698 */       throw localSQLException1;
/*      */     }
/* 5700 */     NTFDCNRegistration localNTFDCNRegistration = new NTFDCNRegistration(i5, true, this.dbName, l, this.userName, paramString, paramInt1, paramProperties, this.versionNumber);
/*      */ 
/* 5711 */     return localNTFDCNRegistration;
/*      */   }
/*      */ 
/*      */   synchronized void doUnregisterDatabaseChangeNotification(long paramLong, String paramString)
/*      */     throws SQLException
/*      */   {
/* 5724 */     int[] arrayOfInt1 = { 2 };
/* 5725 */     String[] arrayOfString = new String[1];
/* 5726 */     int[] arrayOfInt2 = { 0 };
/* 5727 */     int[] arrayOfInt3 = { 0 };
/* 5728 */     int[] arrayOfInt4 = { 0 };
/* 5729 */     int[] arrayOfInt5 = { 0 };
/* 5730 */     int[] arrayOfInt6 = { 0 };
/* 5731 */     byte[] arrayOfByte1 = { 0 };
/* 5732 */     int[] arrayOfInt7 = { 0 };
/* 5733 */     byte[] arrayOfByte2 = { 0 };
/* 5734 */     TIMESTAMPTZ[] arrayOfTIMESTAMPTZ = { null };
/* 5735 */     int[] arrayOfInt8 = { 0 };
/* 5736 */     long[] arrayOfLong = { paramLong };
/* 5737 */     byte[][] arrayOfByte = new byte[1][];
/*      */     try
/*      */     {
/* 5740 */       this.okpn.doOKPN(2, 0, null, paramString, 1, arrayOfInt1, arrayOfString, arrayOfByte, arrayOfInt2, arrayOfInt3, arrayOfInt4, arrayOfInt5, arrayOfInt6, arrayOfLong, arrayOfByte1, arrayOfInt7, arrayOfByte2, arrayOfTIMESTAMPTZ, arrayOfInt8, arrayOfLong);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 5765 */       handleIOException(localIOException);
/*      */ 
/* 5767 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5768 */       localSQLException.fillInStackTrace();
/* 5769 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration paramNTFDCNRegistration)
/*      */     throws SQLException
/*      */   {
/* 5782 */     PhysicalConnection.ntfManager.removeRegistration(paramNTFDCNRegistration);
/* 5783 */     PhysicalConnection.ntfManager.freeJdbcRegId(paramNTFDCNRegistration.getJdbcRegId());
/* 5784 */     PhysicalConnection.ntfManager.cleanListenersT4C(paramNTFDCNRegistration.getClientTCPPort());
/* 5785 */     paramNTFDCNRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
/*      */ 
/* 5787 */     doUnregisterDatabaseChangeNotification(paramNTFDCNRegistration.getRegId(), new StringBuilder().append("(ADDRESS=(PROTOCOL=tcp)(HOST=").append(paramNTFDCNRegistration.getClientHost()).append(")(PORT=").append(paramNTFDCNRegistration.getClientTCPPort()).append("))?PR=0").toString());
/*      */   }
/*      */ 
/*      */   public String getDataIntegrityAlgorithmName()
/*      */     throws SQLException
/*      */   {
/* 5797 */     return this.net.getDataIntegrityName();
/*      */   }
/*      */ 
/*      */   public String getEncryptionAlgorithmName()
/*      */     throws SQLException
/*      */   {
/* 5804 */     return this.net.getEncryptionName();
/*      */   }
/*      */ 
/*      */   public String getAuthenticationAdaptorName()
/*      */     throws SQLException
/*      */   {
/* 5811 */     return this.net.getAuthenticationAdaptorName();
/*      */   }
/*      */ 
/*      */   void validateConnectionProperties()
/*      */     throws SQLException
/*      */   {
/* 5826 */     super.validateConnectionProperties();
/*      */ 
/* 5828 */     String str = ".*[\\00\\(\\)].*";
/*      */     SQLException localSQLException;
/* 5829 */     if ((this.thinVsessionOsuser != null) && ((this.thinVsessionOsuser.matches(str)) || (this.thinVsessionOsuser.length() > 30)))
/*      */     {
/* 5833 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.osuser' and value is '").append(this.thinVsessionOsuser).append("'").toString());
/* 5834 */       localSQLException.fillInStackTrace();
/* 5835 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5838 */     if ((this.thinVsessionTerminal != null) && ((this.thinVsessionTerminal.matches(str)) || (this.thinVsessionTerminal.length() > 30)))
/*      */     {
/* 5842 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.terminal' and value is '").append(this.thinVsessionTerminal).append("'").toString());
/* 5843 */       localSQLException.fillInStackTrace();
/* 5844 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5847 */     if ((this.thinVsessionMachine != null) && ((this.thinVsessionMachine.matches(str)) || (this.thinVsessionMachine.length() > 64)))
/*      */     {
/* 5851 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.machine' and value is '").append(this.thinVsessionMachine).append("'").toString());
/* 5852 */       localSQLException.fillInStackTrace();
/* 5853 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5856 */     if ((this.thinVsessionProgram != null) && ((this.thinVsessionProgram.matches(str)) || (this.thinVsessionProgram.length() > 48)))
/*      */     {
/* 5860 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.program' and value is '").append(this.thinVsessionProgram).append("'").toString());
/* 5861 */       localSQLException.fillInStackTrace();
/* 5862 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5865 */     if ((this.thinVsessionProcess != null) && ((this.thinVsessionProcess.matches(str)) || (this.thinVsessionProcess.length() > 24)))
/*      */     {
/* 5869 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.process' and value is '").append(this.thinVsessionProcess).append("'").toString());
/* 5870 */       localSQLException.fillInStackTrace();
/* 5871 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5874 */     if ((this.thinVsessionIname != null) && (this.thinVsessionIname.matches(str)))
/*      */     {
/* 5876 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.iname' and value is '").append(this.thinVsessionIname).append("'").toString());
/* 5877 */       localSQLException.fillInStackTrace();
/* 5878 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5881 */     if ((this.thinVsessionEname != null) && (this.thinVsessionEname.matches(str)))
/*      */     {
/* 5883 */       localSQLException = DatabaseError.createSqlException(null, 190, new StringBuilder().append("Property is 'v$session.ename' and value is '").append(this.thinVsessionEname).append("'").toString());
/* 5884 */       localSQLException.fillInStackTrace();
/* 5885 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized byte[] createLightweightSession(String paramString, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 5899 */     if ((paramArrayOfKeywordValueLong1.length != 1) || (paramArrayOfInt.length != 1))
/*      */     {
/* 5901 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5902 */       ((SQLException)localObject).fillInStackTrace();
/* 5903 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 5906 */     Object localObject = null;
/*      */     try
/*      */     {
/* 5909 */       this.oxsscs.doOXSSCS(paramString, paramArrayOfKeywordValueLong, paramInt);
/* 5910 */       localObject = this.oxsscs.getSessionId();
/* 5911 */       paramArrayOfKeywordValueLong1[0] = this.oxsscs.getOutKV();
/* 5912 */       paramArrayOfInt[0] = this.oxsscs.getOutFlags();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 5916 */       handleIOException(localIOException);
/*      */ 
/* 5918 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5919 */       localSQLException.fillInStackTrace();
/* 5920 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5923 */     return localObject;
/*      */   }
/*      */ 
/*      */   private synchronized void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSNamespace[][] paramArrayOfXSNamespace1, XSSecureId paramXSSecureId, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 5941 */     XSNamespace[] arrayOfXSNamespace = null;
/*      */     try {
/* 5943 */       this.xsnsop2.doOXSNS(paramXSOperationCode, paramArrayOfByte, paramArrayOfXSNamespace, paramXSSecureId, paramBoolean);
/* 5944 */       if (paramBoolean)
/* 5945 */         arrayOfXSNamespace = this.xsnsop2.getNamespaces();
/*      */     } catch (IOException localIOException) {
/* 5947 */       handleIOException(localIOException);
/*      */ 
/* 5949 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5950 */       localSQLException.fillInStackTrace();
/* 5951 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5954 */     if ((paramArrayOfXSNamespace1 != null) && (paramArrayOfXSNamespace1.length > 0))
/* 5955 */       paramArrayOfXSNamespace1[0] = arrayOfXSNamespace;
/*      */   }
/*      */ 
/*      */   public void doXSSessionDetachOp(int paramInt, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 5968 */       this.oxsdet.doOXSDET(paramInt, paramArrayOfByte, paramXSSecureId, paramBoolean);
/*      */     }
/*      */     catch (IOException localIOException) {
/* 5971 */       handleIOException(localIOException);
/*      */ 
/* 5973 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 5974 */       localSQLException.fillInStackTrace();
/* 5975 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSNamespace[][] paramArrayOfXSNamespace1, XSSecureId paramXSSecureId)
/*      */     throws SQLException
/*      */   {
/* 5992 */     doXSNamespaceOp(paramXSOperationCode, paramArrayOfByte, paramArrayOfXSNamespace, paramArrayOfXSNamespace1, paramXSSecureId, true);
/*      */   }
/*      */ 
/*      */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSSecureId paramXSSecureId)
/*      */     throws SQLException
/*      */   {
/* 6005 */     doXSNamespaceOp(paramXSOperationCode, paramArrayOfByte, paramArrayOfXSNamespace, (XSNamespace[][])null, paramXSSecureId, false);
/*      */   }
/*      */ 
/*      */   public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode paramXSSessionOperationCode, XSSecureId paramXSSecureId, byte[] paramArrayOfByte, XSPrincipal paramXSPrincipal, String paramString, XSNamespace[] paramArrayOfXSNamespace, OracleConnection.XSSessionModeFlag paramXSSessionModeFlag, XSKeyval paramXSKeyval)
/*      */     throws SQLException
/*      */   {
/* 6020 */     byte[] arrayOfByte = null;
/*      */     try
/*      */     {
/* 6023 */       this.oxscre.doOXSCRE(paramXSSessionOperationCode, paramXSSecureId, paramArrayOfByte, paramXSPrincipal, paramString, paramArrayOfXSNamespace, paramXSSessionModeFlag, paramXSKeyval);
/*      */ 
/* 6032 */       arrayOfByte = this.oxscre.getSessionId();
/*      */     } catch (IOException localIOException) {
/* 6034 */       handleIOException(localIOException);
/*      */ 
/* 6036 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 6037 */       localSQLException.fillInStackTrace();
/* 6038 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6041 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public void doXSSessionDestroyOp(byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 6053 */       this.oxsdes.doOXSDES(paramArrayOfByte1, paramXSSecureId, paramArrayOfByte2);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 6058 */       handleIOException(localIOException);
/*      */ 
/* 6060 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 6061 */       localSQLException.fillInStackTrace();
/* 6062 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doXSSessionAttachOp(int paramInt1, byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2, XSPrincipal paramXSPrincipal, String[] paramArrayOfString1, String[] paramArrayOfString2, String[] paramArrayOfString3, XSNamespace[] paramArrayOfXSNamespace1, XSNamespace[] paramArrayOfXSNamespace2, XSNamespace[] paramArrayOfXSNamespace3, TIMESTAMPTZ paramTIMESTAMPTZ1, TIMESTAMPTZ paramTIMESTAMPTZ2, int paramInt2, long paramLong, XSKeyval paramXSKeyval, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 6096 */       this.oxsatt.doOXSATT(paramInt1, paramArrayOfByte1, paramXSSecureId, paramArrayOfByte2, paramXSPrincipal, paramArrayOfString1, paramArrayOfString2, paramArrayOfString3, paramArrayOfXSNamespace1, paramArrayOfXSNamespace2, paramArrayOfXSNamespace3, paramTIMESTAMPTZ1, paramTIMESTAMPTZ2, paramInt2, paramLong, paramXSKeyval, paramArrayOfInt);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 6115 */       handleIOException(localIOException);
/*      */ 
/* 6117 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 6118 */       localSQLException.fillInStackTrace();
/* 6119 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode paramXSSessionSetOperationCode, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, XSSessionParameters paramXSSessionParameters)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 6135 */       this.oxsset.doOXSSET(paramXSSessionSetOperationCode, paramArrayOfByte, paramXSSecureId, (XSSessionParametersI)paramXSSessionParameters);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 6141 */       handleIOException(localIOException);
/*      */ 
/* 6143 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 6144 */       localSQLException.fillInStackTrace();
/* 6145 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener, Executor paramExecutor)
/*      */     throws SQLException
/*      */   {
/* 6163 */     if (this.lifecycle != 1)
/*      */     {
/* 6165 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 6166 */       ((SQLException)localObject1).fillInStackTrace();
/* 6167 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 6170 */     Object localObject1 = new NTFEventListener(paramLogicalTransactionIdEventListener);
/* 6171 */     ((NTFEventListener)localObject1).setExecutor(paramExecutor);
/* 6172 */     synchronized (this.ltxidListeners)
/*      */     {
/* 6174 */       int i = this.ltxidListeners.length;
/* 6175 */       for (int j = 0; j < i; j++) {
/* 6176 */         if (this.ltxidListeners[j].getLogicalTransactionIdEventListener() == paramLogicalTransactionIdEventListener)
/*      */         {
/* 6180 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 248);
/* 6181 */           localSQLException.fillInStackTrace();
/* 6182 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/* 6186 */       NTFEventListener[] arrayOfNTFEventListener = new NTFEventListener[i + 1];
/* 6187 */       System.arraycopy(this.ltxidListeners, 0, arrayOfNTFEventListener, 0, i);
/*      */ 
/* 6189 */       arrayOfNTFEventListener[i] = localObject1;
/*      */ 
/* 6191 */       this.ltxidListeners = arrayOfNTFEventListener;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*      */     throws SQLException
/*      */   {
/* 6206 */     addLogicalTransactionIdEventListener(paramLogicalTransactionIdEventListener, null);
/*      */   }
/*      */ 
/*      */   public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*      */     throws SQLException
/*      */   {
/* 6219 */     synchronized (this.ltxidListeners)
/*      */     {
/* 6222 */       int i = 0;
/* 6223 */       int j = this.ltxidListeners.length;
/*      */ 
/* 6225 */       for (i = 0; (i < j) && 
/* 6226 */         (this.ltxidListeners[i].getLogicalTransactionIdEventListener() != paramLogicalTransactionIdEventListener); i++);
/* 6228 */       if (i == j)
/*      */       {
/* 6232 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 249);
/* 6233 */         ((SQLException)localObject1).fillInStackTrace();
/* 6234 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 6238 */       Object localObject1 = new NTFEventListener[j - 1];
/* 6239 */       int k = 0;
/* 6240 */       for (i = 0; i < j; i++) {
/* 6241 */         if (this.ltxidListeners[i].getLogicalTransactionIdEventListener() != paramLogicalTransactionIdEventListener) {
/* 6242 */           localObject1[(k++)] = this.ltxidListeners[i];
/*      */         }
/*      */       }
/* 6245 */       this.ltxidListeners = ((NTFEventListener[])localObject1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public LogicalTransactionId getLogicalTransactionId()
/*      */     throws SQLException
/*      */   {
/* 6257 */     return this.thinACCurrentLTXID;
/*      */   }
/*      */ 
/*      */   boolean notify(final NTFLTXIDEvent paramNTFLTXIDEvent)
/*      */   {
/* 6264 */     boolean bool = false;
/* 6265 */     if (this.ltxidListeners != null)
/*      */     {
/* 6267 */       NTFEventListener[] arrayOfNTFEventListener = this.ltxidListeners;
/*      */ 
/* 6271 */       int i = arrayOfNTFEventListener.length;
/* 6272 */       if (i > 0)
/* 6273 */         bool = true;
/* 6274 */       for (int j = 0; j < i; j++)
/*      */       {
/* 6276 */         Executor localExecutor = arrayOfNTFEventListener[j].getExecutor();
/* 6277 */         if (localExecutor != null)
/*      */         {
/* 6279 */           final LogicalTransactionIdEventListener localLogicalTransactionIdEventListener = arrayOfNTFEventListener[j].getLogicalTransactionIdEventListener();
/*      */ 
/* 6281 */           localExecutor.execute(new Runnable() {
/*      */             public void run() {
/* 6283 */               localLogicalTransactionIdEventListener.onLogicalTransactionIdEvent(paramNTFLTXIDEvent);
/*      */             }
/*      */           });
/*      */         }
/*      */         else
/*      */         {
/* 6289 */           arrayOfNTFEventListener[j].getLogicalTransactionIdEventListener().onLogicalTransactionIdEvent(paramNTFLTXIDEvent);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 6294 */     return bool;
/*      */   }
/*      */ 
/*      */   public void addXSEventListener(XSEventListener paramXSEventListener, Executor paramExecutor)
/*      */     throws SQLException
/*      */   {
/* 6310 */     if (this.lifecycle != 1)
/*      */     {
/* 6312 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 6313 */       ((SQLException)localObject1).fillInStackTrace();
/* 6314 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 6317 */     Object localObject1 = new NTFEventListener(paramXSEventListener);
/* 6318 */     ((NTFEventListener)localObject1).setExecutor(paramExecutor);
/* 6319 */     synchronized (this.xsListeners)
/*      */     {
/* 6321 */       int i = this.xsListeners.length;
/* 6322 */       for (int j = 0; j < i; j++) {
/* 6323 */         if (this.xsListeners[j].getXSEventListener() == paramXSEventListener)
/*      */         {
/* 6327 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 248);
/* 6328 */           localSQLException.fillInStackTrace();
/* 6329 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/* 6333 */       NTFEventListener[] arrayOfNTFEventListener = new NTFEventListener[i + 1];
/* 6334 */       System.arraycopy(this.xsListeners, 0, arrayOfNTFEventListener, 0, i);
/*      */ 
/* 6336 */       arrayOfNTFEventListener[i] = localObject1;
/*      */ 
/* 6338 */       this.xsListeners = arrayOfNTFEventListener;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException
/*      */   {
/* 6353 */     addXSEventListener(paramXSEventListener, null);
/*      */   }
/*      */ 
/*      */   public void removeXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException
/*      */   {
/* 6366 */     synchronized (this.xsListeners)
/*      */     {
/* 6369 */       int i = 0;
/* 6370 */       int j = this.xsListeners.length;
/*      */ 
/* 6372 */       for (i = 0; (i < j) && 
/* 6373 */         (this.xsListeners[i].getXSEventListener() != paramXSEventListener); i++);
/* 6375 */       if (i == j)
/*      */       {
/* 6379 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 249);
/* 6380 */         ((SQLException)localObject1).fillInStackTrace();
/* 6381 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 6385 */       Object localObject1 = new NTFEventListener[j - 1];
/* 6386 */       int k = 0;
/* 6387 */       for (i = 0; i < j; i++) {
/* 6388 */         if (this.xsListeners[i].getXSEventListener() != paramXSEventListener) {
/* 6389 */           localObject1[(k++)] = this.xsListeners[i];
/*      */         }
/*      */       }
/* 6392 */       this.xsListeners = ((NTFEventListener[])localObject1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeAllXSEventListener()
/*      */     throws SQLException
/*      */   {
/* 6405 */     synchronized (this.xsListeners)
/*      */     {
/* 6407 */       NTFEventListener[] arrayOfNTFEventListener = new NTFEventListener[0];
/*      */ 
/* 6409 */       this.xsListeners = arrayOfNTFEventListener;
/*      */     }
/*      */   }
/*      */ 
/*      */   void notify(final NTFXSEvent paramNTFXSEvent)
/*      */   {
/* 6421 */     NTFEventListener[] arrayOfNTFEventListener = this.xsListeners;
/*      */ 
/* 6425 */     int i = arrayOfNTFEventListener.length;
/* 6426 */     for (int j = 0; j < i; j++)
/*      */     {
/* 6428 */       Executor localExecutor = arrayOfNTFEventListener[j].getExecutor();
/* 6429 */       if (localExecutor != null)
/*      */       {
/* 6431 */         final XSEventListener localXSEventListener = arrayOfNTFEventListener[j].getXSEventListener();
/*      */ 
/* 6433 */         localExecutor.execute(new Runnable() {
/*      */           public void run() {
/* 6435 */             localXSEventListener.onXSEvent(paramNTFXSEvent);
/*      */           }
/*      */         });
/*      */       }
/*      */       else
/*      */       {
/* 6441 */         arrayOfNTFEventListener[j].getXSEventListener().onXSEvent(paramNTFXSEvent);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   final boolean hasServerCompileTimeCapability(int paramInt1, int paramInt2)
/*      */   {
/* 6464 */     boolean bool = false;
/* 6465 */     if ((this.serverCompileTimeCapabilities != null) && (this.serverCompileTimeCapabilities.length > paramInt1) && ((this.serverCompileTimeCapabilities[paramInt1] & paramInt2) != 0))
/*      */     {
/* 6470 */       bool = true;
/*      */     }
/* 6472 */     return bool;
/*      */   }
/*      */ 
/*      */   long doGetCurrentSCN()
/*      */     throws SQLException
/*      */   {
/* 6480 */     return this.outScn;
/*      */   }
/*      */ 
/*      */   EnumSet<OracleConnection.TransactionState> doGetTransactionState()
/*      */     throws SQLException
/*      */   {
/* 6487 */     EnumSet localEnumSet = EnumSet.noneOf(OracleConnection.TransactionState.class);
/* 6488 */     if ((this.eocs & 0x1) != 0)
/*      */     {
/* 6490 */       localEnumSet.add(OracleConnection.TransactionState.TRANSACTION_READONLY);
/*      */     }
/* 6492 */     if ((this.eocs & 0x2) != 0)
/*      */     {
/* 6494 */       localEnumSet.add(OracleConnection.TransactionState.TRANSACTION_STARTED);
/*      */     }
/* 6496 */     if ((this.eocs & 0x4) != 0)
/*      */     {
/* 6498 */       localEnumSet.add(OracleConnection.TransactionState.TRANSACTION_ENDED);
/*      */     }
/* 6500 */     if ((this.eocs & 0x400) != 0)
/*      */     {
/* 6502 */       localEnumSet.add(OracleConnection.TransactionState.TRANSACTION_INTENTION);
/*      */     }
/* 6504 */     return localEnumSet;
/*      */   }
/*      */ 
/*      */   public boolean isConnectionSocketKeepAlive()
/*      */     throws SocketException
/*      */   {
/* 6511 */     return this.net.isConnectionSocketKeepAlive();
/*      */   }
/*      */ 
/*      */   public int getEOC()
/*      */     throws SQLException
/*      */   {
/* 6517 */     return this.eocs;
/*      */   }
/*      */ 
/*      */   public synchronized void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> paramEnumSet)
/*      */     throws SQLException
/*      */   {
/* 6523 */     if ((this.ossestateOperations == OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode()) && (paramEnumSet.size() == 0))
/*      */     {
/* 6525 */       return;
/*      */     }
/*      */ 
/* 6529 */     this.ossestateOperations = 0L;
/*      */ 
/* 6531 */     Iterator localIterator = paramEnumSet.iterator();
/* 6532 */     while (localIterator.hasNext()) {
/* 6533 */       this.ossestateOperations |= ((OracleConnection.ReplayOperation)localIterator.next()).getCode();
/*      */     }
/*      */ 
/* 6539 */     if ((this.ossestateOperations & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode()) != 0L)
/* 6540 */       this.replayModes.add(ReplayMode.RUNTIME_REPLAY_ENABLED);
/*      */     else {
/* 6542 */       this.replayModes.remove(ReplayMode.RUNTIME_REPLAY_ENABLED);
/*      */     }
/* 6544 */     if ((this.ossestateOperations & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode()) != 0L)
/* 6545 */       this.replayModes.add(ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
/*      */     else
/* 6547 */       this.replayModes.remove(ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
/*      */   }
/*      */ 
/*      */   public synchronized void setReplayingMode(boolean paramBoolean) throws SQLException
/*      */   {
/* 6552 */     if (paramBoolean)
/*      */     {
/* 6554 */       this.replayModes.remove(ReplayMode.RUNTIME_REPLAY_ENABLED);
/* 6555 */       this.replayModes.add(ReplayMode.REPLAYING);
/*      */     }
/*      */     else {
/* 6558 */       this.replayModes.remove(ReplayMode.REPLAYING);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void beginNonRequestCalls()
/*      */     throws SQLException
/*      */   {
/* 6567 */     this.replayModes.add(ReplayMode.NONREQUEST);
/*      */   }
/*      */ 
/*      */   public synchronized void endNonRequestCalls() throws SQLException {
/* 6571 */     this.replayModes.remove(ReplayMode.NONREQUEST);
/*      */   }
/*      */ 
/*      */   public synchronized void setReplayContext(ReplayContext[] paramArrayOfReplayContext)
/*      */     throws SQLException
/*      */   {
/* 6578 */     if (paramArrayOfReplayContext != null)
/*      */     {
/* 6580 */       this.oappcontreplayContextsArr = paramArrayOfReplayContext;
/* 6581 */       this.oappcontreplayOffset = 0;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized ReplayContext[] getReplayContext()
/*      */     throws SQLException
/*      */   {
/* 6593 */     if (this.thinACReplayContextReceivedCurrent == 0) {
/* 6594 */       return null;
/*      */     }
/*      */ 
/* 6598 */     ReplayContext[] arrayOfReplayContext = new ReplayContext[this.thinACReplayContextReceivedCurrent];
/* 6599 */     System.arraycopy(this.thinACReplayContextReceived, 0, arrayOfReplayContext, 0, this.thinACReplayContextReceivedCurrent);
/*      */ 
/* 6602 */     this.thinACReplayContextReceivedCurrent = 0;
/* 6603 */     return arrayOfReplayContext;
/*      */   }
/*      */ 
/*      */   public ReplayContext getLastReplayContext() throws SQLException
/*      */   {
/* 6608 */     return this.thinACLastReplayContextReceived;
/*      */   }
/*      */ 
/*      */   public void registerEndReplayCallback(OracleConnection.EndReplayCallback paramEndReplayCallback) throws SQLException {
/* 6612 */     this.endReplayCallback = paramEndReplayCallback;
/*      */   }
/*      */ 
/*      */   public byte[] getDerivedKeyInternal(byte[] paramArrayOfByte, int paramInt)
/*      */     throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException
/*      */   {
/* 6622 */     return this.auth.getDerivedKeyJdbc(paramArrayOfByte, paramInt);
/*      */   }
/*      */ 
/*      */   void releaseConnectionToPool()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 6630 */       if (this.drcpState != PhysicalConnection.DrcpState.STATEFUL)
/* 6631 */         return;
/* 6632 */       this.drcpState = PhysicalConnection.DrcpState.STATELESS;
/* 6633 */       if (this.currentlyInTransaction)
/*      */       {
/* 6635 */         this.osessrls.setTTCCode((byte)3);
/* 6636 */         this.osessrls.doRPC();
/*      */       }
/*      */       else
/*      */       {
/* 6640 */         this.osessrls.setTTCCode((byte)26);
/* 6641 */         this.osessrls.doOneWayRPC();
/*      */       }
/*      */     } catch (IOException localIOException) { handleIOException(localIOException);
/*      */     } catch (SQLException localSQLException) {
/* 6645 */       if (this.currentlyInTransaction)
/*      */       {
/* 6647 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean reusePooledConnection()
/*      */     throws SQLException
/*      */   {
/* 6660 */     if (this.drcpState != PhysicalConnection.DrcpState.STATEFUL) {
/* 6661 */       this.drcpState = PhysicalConnection.DrcpState.STATEFUL;
/*      */       try
/*      */       {
/* 6664 */         if (this.drcpTagName != null)
/*      */         {
/* 6666 */           this.osessget.doRPC();
/* 6667 */           resetAfterReusePooledConnection();
/*      */         }
/*      */       } catch (IOException localIOException) { handleIOException(localIOException); }
/*      */ 
/*      */     }
/* 6672 */     return !bit(this.ocsessret.sessretflags, 1L);
/*      */   }
/*      */ 
/*      */   public boolean needToPurgeStatementCache()
/*      */     throws SQLException
/*      */   {
/* 6692 */     if (this.lifecycle != 1)
/*      */     {
/* 6694 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 6695 */       localSQLException.fillInStackTrace();
/* 6696 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6699 */     if (!this.drcpEnabled) return false;
/* 6700 */     return (bit(this.ocsessret.sessretflags, 4L)) || (bit(this.ocsessret.sessretflags, 8L));
/*      */   }
/*      */ 
/*      */   static final String dumpObject(Object paramObject, String paramString)
/*      */   {
/* 6713 */     return dumpObject(paramObject, paramString, new StringBuilder());
/*      */   }
/*      */ 
/*      */   static final String dumpObject(Object paramObject, String paramString, StringBuilder paramStringBuilder)
/*      */   {
/* 6718 */     Class localClass = paramObject.getClass();
/* 6719 */     Field[] arrayOfField1 = localClass.getDeclaredFields();
/*      */ 
/* 6721 */     paramStringBuilder.append(new StringBuilder().append(paramString).append(localClass.getName()).append(" { \n").toString());
/* 6722 */     for (Field localField : arrayOfField1)
/*      */     {
/* 6724 */       if ((localField.getModifiers() & 0x8) == 0)
/*      */       {
/* 6728 */         localField.setAccessible(true);
/*      */         try
/*      */         {
/* 6731 */           paramStringBuilder.append(new StringBuilder().append(paramString).append("  ").append(localField.getName()).append(" = ").toString());
/*      */ 
/* 6733 */           Object localObject = localField.get(paramObject);
/* 6734 */           if (localObject == null) {
/* 6735 */             paramStringBuilder.append("null");
/*      */           }
/*      */           else
/*      */           {
/* 6739 */             paramStringBuilder.append(localObject);
/*      */           }
/* 6741 */           paramStringBuilder.append("\n"); } catch (IllegalAccessException localIllegalAccessException) {  }
/*      */       }
/*      */     }
/* 6744 */     paramStringBuilder.append(new StringBuilder().append(paramString).append("}\n").toString());
/*      */ 
/* 6746 */     return paramStringBuilder.toString();
/*      */   }
/*      */ 
/*      */   byte getNextSeqNumber()
/*      */   {
/* 6751 */     if (this.currentTTCSeqNumber == 127)
/*      */     {
/* 6753 */       this.currentTTCSeqNumber = 1;
/* 6754 */       return this.currentTTCSeqNumber;
/*      */     }
/*      */ 
/* 6757 */     return this.currentTTCSeqNumber = (byte)(this.currentTTCSeqNumber + 1);
/*      */   }
/*      */ 
/*      */   public int getNegotiatedSDU() throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 6764 */       return this.net.getNegotiatedSDU();
/*      */     }
/*      */     catch (NetException localNetException)
/*      */     {
/* 6768 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localNetException);
/* 6769 */       localSQLException.fillInStackTrace();
/* 6770 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   static enum ReplayMode
/*      */   {
/*  246 */     RUNTIME_REPLAY_ENABLED, 
/*      */ 
/*  251 */     RUNTIME_OR_REPLAYING_STATIC, 
/*      */ 
/*  260 */     NONREQUEST, 
/*      */ 
/*  268 */     REPLAYING;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CConnection
 * JD-Core Version:    0.6.2
 */