/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.LinkedList;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ import oracle.sql.CLOB;
/*     */ 
/*     */ class T4CClobAccessor extends ClobAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  26 */   short[] prefetchedClobCharset = null;
/*     */ 
/*  29 */   boolean[] prefetchedClobDBVary = null;
/*     */ 
/* 127 */   final int[] meta = new int[1];
/*     */ 
/* 239 */   ArrayList<LinkedList<CLOB>> registeredCLOBs = new ArrayList(10);
/*     */ 
/* 309 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CClobAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  49 */     super(paramOracleStatement, 4000, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  51 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CClobAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  61 */     super(paramOracleStatement, 4000, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  65 */     this.mare = paramT4CMAREngine;
/*  66 */     this.definedColumnType = paramInt7;
/*  67 */     this.definedColumnSize = paramInt8;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  72 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  81 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  84 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  91 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  98 */       this.mare.unmarshalUB2();
/*  99 */       this.mare.unmarshalUB2();
/*     */     }
/* 101 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 105 */       this.mare.unmarshalSB2();
/*     */ 
/* 107 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 108 */         this.mare.unmarshalSB2();
/*     */     }
/* 110 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 111 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 117 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 118 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 136 */     boolean bool = false;
/* 137 */     if (!isUseless())
/*     */     {
/* 143 */       if (isUnexpected())
/*     */       {
/* 146 */         long l = this.rowData.getPosition();
/* 147 */         unmarshalColumnMetadata();
/* 148 */         unmarshalBytes();
/* 149 */         this.rowData.setPosition(l);
/* 150 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 152 */       else if (isNullByDescribe())
/*     */       {
/* 155 */         setNull(this.lastRowProcessed, true);
/* 156 */         unmarshalColumnMetadata();
/* 157 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 161 */         unmarshalColumnMetadata();
/* 162 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 164 */     this.previousRowProcessed = this.lastRowProcessed;
/* 165 */     this.lastRowProcessed += 1;
/* 166 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 173 */     throw new NoSuchMethodError("oracle.jdbc.driver.T4C_lobAccessor.copyRow");
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws IOException, SQLException
/*     */   {
/* 189 */     int i = (int)this.mare.unmarshalUB4();
/*     */ 
/* 191 */     if (i == 0) {
/* 192 */       setNull(this.lastRowProcessed, true);
/* 193 */       processIndicator(0);
/*     */     }
/*     */     else {
/* 196 */       if (isPrefetched()) unmarshalPrefetchData();
/* 197 */       setOffset(this.lastRowProcessed);
/* 198 */       int j = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 199 */       setNull(this.lastRowProcessed, j == 0);
/* 200 */       setLength(this.lastRowProcessed, j);
/* 201 */       processIndicator(j);
/*     */     }
/* 203 */     return false;
/*     */   }
/*     */ 
/*     */   void unmarshalPrefetchData()
/*     */     throws SQLException, IOException
/*     */   {
/* 212 */     setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
/*     */ 
/* 214 */     setPrefetchedChunkSize(this.lastRowProcessed, (int)this.mare.unmarshalUB4());
/*     */ 
/* 218 */     if (this.lobPrefetchSizeForThisColumn > 0)
/*     */     {
/* 221 */       int i = (byte)this.mare.unmarshalUB1() == 1 ? 1 : 0;
/*     */ 
/* 225 */       if (i != 0) setPrefetchedDataCharset(this.lastRowProcessed, this.mare.unmarshalUB2()); else {
/* 226 */         setPrefetchedDataCharset(this.lastRowProcessed, 0);
/*     */       }
/*     */ 
/* 229 */       setPrefetchedDataFormOfUse(this.lastRowProcessed, this.mare.unmarshalUB1());
/*     */ 
/* 232 */       setPrefetchedDataOffset(this.lastRowProcessed);
/* 233 */       setPrefetchedDataLength(this.lastRowProcessed, ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void saveCLOBReference(int paramInt, CLOB paramCLOB)
/*     */   {
/* 248 */     LinkedList localLinkedList = null;
/* 249 */     if (this.registeredCLOBs.size() > paramInt)
/*     */     {
/* 251 */       localLinkedList = (LinkedList)this.registeredCLOBs.get(paramInt);
/*     */     }
/*     */     else
/*     */     {
/* 255 */       localLinkedList = new LinkedList();
/* 256 */       while (this.registeredCLOBs.size() < paramInt)
/* 257 */         this.registeredCLOBs.add(new LinkedList());
/* 258 */       this.registeredCLOBs.add(paramInt, localLinkedList);
/*     */     }
/*     */ 
/* 261 */     if (localLinkedList == null) localLinkedList = new LinkedList();
/* 262 */     localLinkedList.add(paramCLOB);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 271 */     if (this.definedColumnType == 0) {
/* 272 */       return super.getObject(paramInt);
/*     */     }
/* 274 */     if (isNull(paramInt)) return null;
/*     */ 
/* 276 */     switch (this.definedColumnType)
/*     */     {
/*     */     case 2011:
/* 279 */       return getNCLOB(paramInt);
/*     */     case 2005:
/* 282 */       return getCLOB(paramInt);
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 287 */       return getString(paramInt);
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 292 */       return getBytes(paramInt);
/*     */     }
/*     */ 
/* 296 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 297 */     localSQLException.fillInStackTrace();
/* 298 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CClobAccessor
 * JD-Core Version:    0.6.2
 */