/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Properties;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPLTZ;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ class T4CCharAccessor extends CharAccessor
/*     */   implements T4CAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  53 */   boolean underlyingLong = false;
/*     */ 
/* 703 */   private T4CMarshaller marshaller = null;
/*     */ 
/* 783 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CCharAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  59 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  61 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  63 */     calculateSizeTmpByteArray();
/*     */   }
/*     */ 
/*     */   T4CCharAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, int paramInt9, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  73 */     super(paramOracleStatement, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  77 */     this.mare = paramT4CMAREngine;
/*  78 */     this.definedColumnType = paramInt8;
/*  79 */     this.definedColumnSize = paramInt9;
/*     */ 
/*  81 */     calculateSizeTmpByteArray();
/*     */ 
/*  87 */     this.oacmxl = paramInt7;
/*     */ 
/*  89 */     if (this.oacmxl == -1)
/*     */     {
/*  91 */       this.underlyingLong = true;
/*  92 */       this.oacmxl = 4000;
/*     */     }
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  98 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/* 107 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/* 110 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/* 117 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 124 */       this.mare.unmarshalUB2();
/* 125 */       this.mare.unmarshalUB2();
/*     */     }
/* 127 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 131 */       this.mare.unmarshalSB2();
/*     */ 
/* 133 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 134 */         this.mare.unmarshalSB2();
/*     */     }
/* 136 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 137 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 143 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 144 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 155 */     if (this.isNullByDescribe) {
/* 156 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 158 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 163 */       if (this.previousRowProcessed == -1)
/* 164 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 165 */       long l = getOffset(this.previousRowProcessed);
/* 166 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 167 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 168 */       if (!isNull(this.previousRowProcessed)) {
/* 169 */         setOffset(this.lastRowProcessed);
/* 170 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 171 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 176 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 177 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 178 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 179 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 181 */     this.previousRowProcessed = this.lastRowProcessed;
/* 182 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 191 */     return getMarshaller().unmarshalOneRow(this);
/*     */   }
/*     */ 
/*     */   int readStreamFromWire(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2, T4CMAREngine paramT4CMAREngine, T4CTTIoer paramT4CTTIoer)
/*     */     throws SQLException, IOException
/*     */   {
/* 202 */     return getMarshaller().readStreamFromWire(paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt, paramArrayOfBoolean1, paramArrayOfBoolean2, paramT4CMAREngine, paramT4CTTIoer);
/*     */   }
/*     */ 
/*     */   NUMBER getNUMBER(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 211 */     NUMBER localNUMBER = null;
/*     */ 
/* 213 */     if (this.definedColumnType == 0) {
/* 214 */       localNUMBER = super.getNUMBER(paramInt);
/*     */     } else {
/* 216 */       String str = getString(paramInt);
/* 217 */       if (str != null) return T4CVarcharAccessor.StringToNUMBER(str.trim());
/*     */     }
/* 219 */     return localNUMBER;
/*     */   }
/*     */ 
/*     */   DATE getDATE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 226 */     DATE localDATE = null;
/*     */ 
/* 228 */     if (this.definedColumnType == 0) {
/* 229 */       localDATE = super.getDATE(paramInt);
/*     */     }
/*     */     else {
/* 232 */       Date localDate = getDate(paramInt);
/* 233 */       if (localDate != null)
/*     */       {
/* 242 */         localDATE = new DATE(localDate);
/*     */       }
/*     */     }
/*     */ 
/* 246 */     return localDATE;
/*     */   }
/*     */ 
/*     */   TIMESTAMP getTIMESTAMP(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 254 */     TIMESTAMP localTIMESTAMP = null;
/*     */ 
/* 256 */     if (this.definedColumnType == 0) {
/* 257 */       localTIMESTAMP = super.getTIMESTAMP(paramInt);
/*     */     }
/*     */     else {
/* 260 */       String str = getString(paramInt);
/* 261 */       if (str != null)
/*     */       {
/* 271 */         int[] arrayOfInt = new int[1];
/* 272 */         Calendar localCalendar = T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), arrayOfInt);
/*     */ 
/* 275 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/* 276 */         localTimestamp.setNanos(arrayOfInt[0]);
/* 277 */         localTIMESTAMP = new TIMESTAMP(localTimestamp);
/*     */       }
/*     */     }
/*     */ 
/* 281 */     return localTIMESTAMP;
/*     */   }
/*     */ 
/*     */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 288 */     TIMESTAMPTZ localTIMESTAMPTZ = null;
/*     */ 
/* 290 */     if (this.definedColumnType == 0) {
/* 291 */       localTIMESTAMPTZ = super.getTIMESTAMPTZ(paramInt);
/*     */     }
/*     */     else {
/* 294 */       String str = getString(paramInt);
/* 295 */       if (str != null)
/*     */       {
/* 306 */         int[] arrayOfInt = new int[1];
/* 307 */         Calendar localCalendar = T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*     */ 
/* 310 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/* 311 */         localTimestamp.setNanos(arrayOfInt[0]);
/* 312 */         localTIMESTAMPTZ = new TIMESTAMPTZ(this.statement.connection, localTimestamp, localCalendar);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 318 */     return localTIMESTAMPTZ;
/*     */   }
/*     */ 
/*     */   TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 325 */     TIMESTAMPLTZ localTIMESTAMPLTZ = null;
/*     */ 
/* 327 */     if (this.definedColumnType == 0) {
/* 328 */       localTIMESTAMPLTZ = super.getTIMESTAMPLTZ(paramInt);
/*     */     }
/*     */     else {
/* 331 */       String str = getString(paramInt);
/* 332 */       if (str != null)
/*     */       {
/* 343 */         int[] arrayOfInt = new int[1];
/* 344 */         Calendar localCalendar = T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*     */ 
/* 347 */         Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/* 348 */         localTimestamp.setNanos(arrayOfInt[0]);
/* 349 */         localTIMESTAMPLTZ = new TIMESTAMPLTZ(this.statement.connection, localTimestamp, localCalendar);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 355 */     return localTIMESTAMPLTZ;
/*     */   }
/*     */ 
/*     */   RAW getRAW(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 362 */     RAW localRAW = null;
/*     */ 
/* 364 */     if (this.definedColumnType == 0) {
/* 365 */       localRAW = super.getRAW(paramInt);
/*     */     }
/* 368 */     else if (this.rowNull[paramInt] == 0)
/*     */     {
/* 370 */       if ((this.definedColumnType == -2) || (this.definedColumnType == -3) || (this.definedColumnType == -4))
/*     */       {
/* 373 */         localRAW = new RAW(getBytesFromHexChars(paramInt));
/*     */       }
/* 375 */       else localRAW = new RAW(super.getBytes(paramInt));
/*     */ 
/*     */     }
/*     */ 
/* 379 */     return localRAW;
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 386 */     if (this.definedColumnType == 0) {
/* 387 */       return super.getOracleObject(paramInt);
/*     */     }
/*     */ 
/* 390 */     Datum localDatum = null;
/*     */     SQLException localSQLException;
/* 392 */     if (this.rowNull == null)
/*     */     {
/* 394 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/* 395 */       localSQLException.fillInStackTrace();
/* 396 */       throw localSQLException;
/*     */     }
/*     */ 
/* 399 */     if (this.rowNull[paramInt] == 0)
/*     */     {
/* 401 */       switch (this.definedColumnType)
/*     */       {
/*     */       case -16:
/*     */       case -15:
/*     */       case -9:
/*     */       case -1:
/*     */       case 1:
/*     */       case 12:
/* 410 */         return super.getOracleObject(paramInt);
/*     */       case -7:
/*     */       case -6:
/*     */       case -5:
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       case 16:
/* 433 */         return getNUMBER(paramInt);
/*     */       case 91:
/* 436 */         return getDATE(paramInt);
/*     */       case 92:
/* 439 */         return getDATE(paramInt);
/*     */       case 93:
/* 442 */         return getTIMESTAMP(paramInt);
/*     */       case -101:
/* 445 */         return getTIMESTAMPTZ(paramInt);
/*     */       case -102:
/* 448 */         return getTIMESTAMPLTZ(paramInt);
/*     */       case -4:
/*     */       case -3:
/*     */       case -2:
/* 455 */         return getRAW(paramInt);
/*     */       case -8:
/* 458 */         return getROWID(paramInt);
/*     */       }
/*     */ 
/* 462 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 463 */       localSQLException.fillInStackTrace();
/* 464 */       throw localSQLException;
/*     */     }
/*     */ 
/* 470 */     return localDatum;
/*     */   }
/*     */ 
/*     */   byte getByte(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 480 */     byte b = 0;
/*     */ 
/* 482 */     if (this.definedColumnType == 0) {
/* 483 */       b = super.getByte(paramInt);
/*     */     }
/*     */     else {
/* 486 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 487 */       if (localNUMBER != null) {
/* 488 */         b = localNUMBER.byteValue();
/*     */       }
/*     */     }
/* 491 */     return b;
/*     */   }
/*     */ 
/*     */   int getInt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 499 */     int i = 0;
/*     */ 
/* 501 */     if (this.definedColumnType == 0) {
/* 502 */       i = super.getInt(paramInt);
/*     */     }
/*     */     else {
/* 505 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 506 */       if (localNUMBER != null) {
/* 507 */         i = localNUMBER.intValue();
/*     */       }
/*     */     }
/* 510 */     return i;
/*     */   }
/*     */ 
/*     */   short getShort(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 518 */     short s = 0;
/*     */ 
/* 520 */     if (this.definedColumnType == 0) {
/* 521 */       s = super.getShort(paramInt);
/*     */     }
/*     */     else {
/* 524 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 525 */       if (localNUMBER != null) {
/* 526 */         s = localNUMBER.shortValue();
/*     */       }
/*     */     }
/* 529 */     return s;
/*     */   }
/*     */ 
/*     */   long getLong(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 537 */     long l = 0L;
/*     */ 
/* 539 */     if (this.definedColumnType == 0) {
/* 540 */       l = super.getLong(paramInt);
/*     */     }
/*     */     else {
/* 543 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 544 */       if (localNUMBER != null) {
/* 545 */         l = localNUMBER.longValue();
/*     */       }
/*     */     }
/* 548 */     return l;
/*     */   }
/*     */ 
/*     */   float getFloat(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 556 */     float f = 0.0F;
/*     */ 
/* 558 */     if (this.definedColumnType == 0) {
/* 559 */       f = super.getFloat(paramInt);
/*     */     }
/*     */     else {
/* 562 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 563 */       if (localNUMBER != null) {
/* 564 */         f = localNUMBER.floatValue();
/*     */       }
/*     */     }
/* 567 */     return f;
/*     */   }
/*     */ 
/*     */   double getDouble(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 575 */     double d = 0.0D;
/*     */ 
/* 577 */     if (this.definedColumnType == 0) {
/* 578 */       d = super.getDouble(paramInt);
/*     */     }
/*     */     else {
/* 581 */       NUMBER localNUMBER = getNUMBER(paramInt);
/* 582 */       if (localNUMBER != null) {
/* 583 */         d = localNUMBER.doubleValue();
/*     */       }
/*     */     }
/* 586 */     return d;
/*     */   }
/*     */ 
/*     */   Date getDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 596 */     Date localDate = null;
/*     */ 
/* 598 */     if (this.definedColumnType == 0) {
/* 599 */       localDate = super.getDate(paramInt);
/*     */     }
/*     */     else {
/* 602 */       String str = getString(paramInt);
/* 603 */       if (str != null)
/*     */       {
/* 612 */         int[] arrayOfInt = new int[1];
/*     */         try {
/* 614 */           localDate = new Date(T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), arrayOfInt).getTimeInMillis());
/*     */         }
/*     */         catch (NumberFormatException localNumberFormatException)
/*     */         {
/* 620 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/* 621 */           localSQLException.fillInStackTrace();
/* 622 */           throw localSQLException;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 628 */     return localDate;
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 636 */     Timestamp localTimestamp = null;
/*     */ 
/* 638 */     if (this.definedColumnType == 0) {
/* 639 */       localTimestamp = super.getTimestamp(paramInt);
/*     */     }
/*     */     else {
/* 642 */       String str = getString(paramInt);
/* 643 */       if (str != null)
/*     */       {
/* 645 */         int[] arrayOfInt = new int[1];
/*     */         try {
/* 647 */           Calendar localCalendar = T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), arrayOfInt);
/*     */ 
/* 650 */           localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/* 651 */           localTimestamp.setNanos(arrayOfInt[0]);
/*     */         }
/*     */         catch (NumberFormatException localNumberFormatException)
/*     */         {
/* 655 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/* 656 */           localSQLException.fillInStackTrace();
/* 657 */           throw localSQLException;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 663 */     return localTimestamp;
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 671 */     Time localTime = null;
/*     */ 
/* 673 */     if (this.definedColumnType == 0) {
/* 674 */       localTime = super.getTime(paramInt);
/*     */     }
/*     */     else {
/* 677 */       String str = getString(paramInt);
/* 678 */       if (str != null)
/*     */       {
/* 680 */         int[] arrayOfInt = new int[1];
/*     */         try {
/* 682 */           Calendar localCalendar = T4CVarcharAccessor.DATEStringToCalendar(str, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), arrayOfInt);
/*     */ 
/* 685 */           localTime = new Time(localCalendar.getTimeInMillis());
/*     */         }
/*     */         catch (NumberFormatException localNumberFormatException)
/*     */         {
/* 689 */           SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localNumberFormatException);
/* 690 */           localSQLException.fillInStackTrace();
/* 691 */           throw localSQLException;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 697 */     return localTime;
/*     */   }
/*     */ 
/*     */   private final T4CMarshaller getMarshaller()
/*     */   {
/* 705 */     if (this.marshaller == null) this.marshaller = (this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.CHAR);
/* 706 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt) throws SQLException
/*     */   {
/* 711 */     if (this.definedColumnType == 0)
/* 712 */       return super.getObject(paramInt);
/* 713 */     if (isUnexpected()) {
/* 714 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/* 715 */       localSQLException.fillInStackTrace();
/* 716 */       throw localSQLException;
/*     */     }
/* 718 */     if (isNull(paramInt)) return null;
/*     */ 
/* 720 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -16:
/*     */     case -15:
/*     */     case -9:
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 728 */       return getString(paramInt);
/*     */     case 2:
/*     */     case 3:
/* 732 */       return getBigDecimal(paramInt);
/*     */     case 4:
/* 735 */       return Integer.valueOf(getInt(paramInt));
/*     */     case -6:
/* 738 */       return Byte.valueOf(getByte(paramInt));
/*     */     case 5:
/* 741 */       return Short.valueOf(getShort(paramInt));
/*     */     case -7:
/*     */     case 16:
/* 745 */       return Boolean.valueOf(getBoolean(paramInt));
/*     */     case -5:
/* 748 */       return Long.valueOf(getLong(paramInt));
/*     */     case 7:
/* 751 */       return Float.valueOf(getFloat(paramInt));
/*     */     case 6:
/*     */     case 8:
/* 755 */       return Double.valueOf(getDouble(paramInt));
/*     */     case 91:
/* 758 */       return getDate(paramInt);
/*     */     case 92:
/* 761 */       return getTime(paramInt);
/*     */     case 93:
/* 764 */       return getTimestamp(paramInt);
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 769 */       return getBytesFromHexChars(paramInt);
/*     */     }
/*     */ 
/* 773 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 774 */     localSQLException.fillInStackTrace();
/* 775 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CCharAccessor
 * JD-Core Version:    0.6.2
 */