/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ class T4CCallableStatement extends OracleCallableStatement
/*      */ {
/*   41 */   static final byte[] EMPTY_BYTE = new byte[0];
/*      */   T4CConnection t4Connection;
/* 1188 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4CCallableStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*   25 */     super(paramPhysicalConnection, paramString, paramPhysicalConnection.defaultExecuteBatch, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*      */ 
/*   27 */     this.t4Connection = ((T4CConnection)paramPhysicalConnection);
/*   28 */     this.nbPostPonedColumns = new int[1];
/*   29 */     this.nbPostPonedColumns[0] = 0;
/*   30 */     this.indexOfPostPonedColumn = new int[1][3];
/*      */ 
/*   32 */     this.theRowidBinder = theStaticT4CRowidBinder;
/*   33 */     this.theRowidNullBinder = theStaticT4CRowidNullBinder;
/*   34 */     this.theURowidBinder = theStaticT4CURowidBinder;
/*   35 */     this.theURowidNullBinder = theStaticT4CURowidNullBinder;
/*      */   }
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5)
/*      */     throws SQLException, IOException
/*      */   {
/*   53 */     doOall8(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, 0);
/*      */   }
/*      */ 
/*      */   void doOall8(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*   67 */     if ((paramBoolean1) || (paramBoolean4) || (!paramBoolean2)) {
/*   68 */       this.oacdefSent = null;
/*      */     }
/*   70 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.doOall8");
/*      */ 
/*   72 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED)
/*      */     {
/*   76 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 439, "sqlKind = " + this.sqlKind);
/*   77 */       localSQLException1.fillInStackTrace();
/*   78 */       throw localSQLException1;
/*      */     }
/*      */ 
/*   82 */     int i = this.rowPrefetch;
/*   83 */     if (paramBoolean3) {
/*   84 */       if ((this.maxRows > 0) && (this.maxRows <= this.indexOfFirstRow + this.storedRowCount + this.rowPrefetch))
/*      */       {
/*   86 */         i = this.maxRows - (this.indexOfFirstRow + this.storedRowCount);
/*   87 */         this.isComplete = true;
/*      */       }
/*   89 */       this.rowPrefetchInLastFetch = i;
/*   90 */       if ((i == 0) && (this.isComplete))
/*   91 */         return;
/*      */     }
/*   93 */     int j = this.numberOfDefinePositions;
/*      */ 
/*   95 */     if (this.sqlKind.isDML())
/*   96 */       j = 0;
/*      */     int k;
/*   99 */     if (this.accessors != null)
/*  100 */       for (k = 0; k < this.accessors.length; k++)
/*  101 */         if (this.accessors[k] != null)
/*  102 */           this.accessors[k].lastRowProcessed = paramInt;
/*  103 */     if (this.outBindAccessors != null)
/*  104 */       for (k = 0; k < this.outBindAccessors.length; k++)
/*  105 */         if (this.outBindAccessors[k] != null)
/*  106 */           this.outBindAccessors[k].lastRowProcessed = 0;
/*      */     int i2;
/*  113 */     if (this.bindIndicators != null)
/*      */     {
/*  115 */       k = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */ 
/*  118 */       int m = 0;
/*      */ 
/*  120 */       if (this.ibtBindChars != null) {
/*  121 */         m = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
/*      */       }
/*  123 */       for (int n = 0; n < this.numberOfBindPositions; n++)
/*      */       {
/*  125 */         int i1 = this.bindIndicatorSubRange + 5 + 10 * n;
/*      */ 
/*  129 */         i2 = this.bindIndicators[(i1 + 2)] & 0xFFFF;
/*      */ 
/*  133 */         if (i2 != 0)
/*      */         {
/*  136 */           int i3 = this.bindIndicators[(i1 + 9)] & 0xFFFF;
/*      */ 
/*  140 */           if (i3 == 2)
/*      */           {
/*  142 */             m = Math.max(i2 * this.connection.conversion.maxNCharSize, m);
/*      */           }
/*      */           else
/*      */           {
/*  147 */             m = Math.max(i2 * this.connection.conversion.cMaxCharSize, m);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  153 */       if (this.tmpBindsByteArray == null)
/*      */       {
/*  155 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*  157 */       else if (this.tmpBindsByteArray.length < m)
/*      */       {
/*  159 */         this.tmpBindsByteArray = null;
/*  160 */         this.tmpBindsByteArray = new byte[m];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  172 */       this.tmpBindsByteArray = null;
/*      */     }
/*      */ 
/*  177 */     int[] arrayOfInt1 = this.definedColumnType;
/*  178 */     int[] arrayOfInt2 = this.definedColumnSize;
/*  179 */     int[] arrayOfInt3 = this.definedColumnFormOfUse;
/*      */ 
/*  185 */     if ((paramBoolean5) && (paramBoolean4) && (this.isRowidPrepended))
/*      */     {
/*  190 */       arrayOfInt1 = new int[this.definedColumnType.length + 1];
/*  191 */       System.arraycopy(this.definedColumnType, 0, arrayOfInt1, 1, this.definedColumnType.length);
/*  192 */       arrayOfInt1[0] = -8;
/*  193 */       arrayOfInt2 = new int[this.definedColumnSize.length + 1];
/*  194 */       System.arraycopy(this.definedColumnSize, 0, arrayOfInt2, 1, this.definedColumnSize.length);
/*  195 */       arrayOfInt3 = new int[this.definedColumnFormOfUse.length + 1];
/*  196 */       System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt3, 1, this.definedColumnFormOfUse.length);
/*      */     }
/*      */ 
/*  202 */     allocateTmpByteArray();
/*      */ 
/*  204 */     T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */     try
/*      */     {
/*  210 */       localT4C8Oall.doOALL(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean4, paramBoolean5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), i, this.outBindAccessors, this.numberOfBindPositions, this.accessors, j, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, arrayOfInt1, arrayOfInt2, arrayOfInt3, this.registration);
/*      */ 
/*  222 */       i2 = localT4C8Oall.getCursorId();
/*  223 */       if ((i2 != 0) && (this.implicitResultSetStatements == null)) {
/*  224 */         this.cursorId = i2;
/*      */       }
/*  226 */       this.oacdefSent = localT4C8Oall.oacdefBindsSent;
/*  227 */       if (this.connection.isPDBChanged) {
/*  228 */         NTFPDBChangeEvent localNTFPDBChangeEvent = new NTFPDBChangeEvent(this.connection);
/*      */ 
/*  230 */         ((T4CConnection)this.connection).notify(localNTFPDBChangeEvent);
/*  231 */         this.connection.isPDBChanged = false;
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  236 */       int i4 = localT4C8Oall.getCursorId();
/*  237 */       if (i4 != 0) {
/*  238 */         this.cursorId = i4;
/*      */       }
/*  240 */       if (localSQLException2.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/*  243 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/*  248 */         throw localSQLException2;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateTmpByteArray()
/*      */   {
/*  258 */     if (this.tmpByteArray == null)
/*      */     {
/*  261 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*  263 */     else if (this.sizeTmpByteArray > this.tmpByteArray.length)
/*      */     {
/*  267 */       this.tmpByteArray = new byte[this.sizeTmpByteArray];
/*      */     }
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/*  279 */     super.releaseBuffers();
/*  280 */     this.tmpByteArray = null;
/*  281 */     this.tmpBindsByteArray = null;
/*      */ 
/*  283 */     if (this.t4Connection != null)
/*      */     {
/*  285 */       this.t4Connection.all8.bindChars = null;
/*  286 */       this.t4Connection.all8.bindBytes = null;
/*  287 */       this.t4Connection.all8.tmpBindsByteArray = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateRowidAccessor()
/*      */     throws SQLException
/*      */   {
/*  295 */     this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
/*      */   }
/*      */ 
/*      */   void reparseOnRedefineIfNeeded()
/*      */     throws SQLException
/*      */   {
/*  308 */     this.needToParse = true;
/*      */   }
/*      */ 
/*      */   protected void defineColumnTypeInternal(int paramInt1, int paramInt2, int paramInt3, short paramShort, boolean paramBoolean, String paramString)
/*      */     throws SQLException
/*      */   {
/*  319 */     if (this.connection.disableDefinecolumntype)
/*      */     {
/*  322 */       return;
/*      */     }
/*  324 */     if ((paramInt2 == -15) || (paramInt2 == -9) || (paramInt2 == -16))
/*      */     {
/*  326 */       paramShort = 2;
/*      */     }
/*      */     SQLException localSQLException;
/*  331 */     if (paramInt1 < 1)
/*      */     {
/*  333 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  334 */       localSQLException.fillInStackTrace();
/*  335 */       throw localSQLException;
/*      */     }
/*      */ 
/*  338 */     if ((this.currentResultSet != null) && (!this.currentResultSet.closed))
/*      */     {
/*  340 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 28);
/*  341 */       localSQLException.fillInStackTrace();
/*  342 */       throw localSQLException;
/*      */     }
/*      */ 
/*  349 */     int i = paramInt1 - 1;
/*      */     int[] arrayOfInt;
/*  351 */     if ((this.definedColumnType == null) || (this.definedColumnType.length <= i))
/*      */     {
/*  353 */       if (this.definedColumnType == null)
/*      */       {
/*  355 */         this.definedColumnType = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  367 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  369 */         System.arraycopy(this.definedColumnType, 0, arrayOfInt, 0, this.definedColumnType.length);
/*      */ 
/*  372 */         this.definedColumnType = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  378 */     this.definedColumnType[i] = paramInt2;
/*      */ 
/*  380 */     if ((this.definedColumnSize == null) || (this.definedColumnSize.length <= i))
/*      */     {
/*  382 */       if (this.definedColumnSize == null) {
/*  383 */         this.definedColumnSize = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  387 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  389 */         System.arraycopy(this.definedColumnSize, 0, arrayOfInt, 0, this.definedColumnSize.length);
/*      */ 
/*  392 */         this.definedColumnSize = arrayOfInt;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  397 */     this.definedColumnSize[i] = ((paramInt2 == 2005) || (paramInt2 == 2004) ? paramInt3 : -1);
/*      */ 
/*  399 */     if ((this.definedColumnFormOfUse == null) || (this.definedColumnFormOfUse.length <= i))
/*      */     {
/*  401 */       if (this.definedColumnFormOfUse == null) {
/*  402 */         this.definedColumnFormOfUse = new int[(i + 1) * 4];
/*      */       }
/*      */       else
/*      */       {
/*  406 */         arrayOfInt = new int[(i + 1) * 4];
/*      */ 
/*  408 */         System.arraycopy(this.definedColumnFormOfUse, 0, arrayOfInt, 0, this.definedColumnFormOfUse.length);
/*      */ 
/*  411 */         this.definedColumnFormOfUse = arrayOfInt;
/*      */       }
/*      */     }
/*      */ 
/*  415 */     this.definedColumnFormOfUse[i] = paramShort;
/*      */ 
/*  417 */     if ((this.accessors != null) && (i < this.accessors.length) && (this.accessors[i] != null))
/*      */     {
/*  419 */       this.accessors[i].definedColumnSize = paramInt3;
/*      */ 
/*  424 */       if (((this.accessors[i].internalType == 96) || (this.accessors[i].internalType == 1)) && ((paramInt2 == 1) || (paramInt2 == 12)))
/*      */       {
/*  428 */         if (paramInt3 <= this.accessors[i].oacmxl)
/*      */         {
/*  434 */           this.needToPrepareDefineBuffer = true;
/*  435 */           this.columnsDefinedByUser = true;
/*      */ 
/*  437 */           this.accessors[i].initForDataAccess(paramInt2, paramInt3, null);
/*  438 */           this.accessors[i].calculateSizeTmpByteArray();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  443 */     this.executeDoneForDefines = false;
/*      */   }
/*      */ 
/*      */   public void clearDefines() throws SQLException
/*      */   {
/*  448 */     synchronized (this.connection)
/*      */     {
/*  450 */       super.clearDefines();
/*  451 */       this.definedColumnType = null;
/*  452 */       this.definedColumnSize = null;
/*  453 */       this.definedColumnFormOfUse = null;
/*  454 */       if ((this.t4Connection != null) && (this.t4Connection.all8 != null))
/*  455 */         this.t4Connection.all8.definesAccessors = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void doSetSnapshotSCN(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  464 */     this.inScn = paramLong;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  484 */     Object localObject = null;
/*      */     SQLException localSQLException;
/*  486 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/*  490 */       localObject = new T4CCharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  493 */       break;
/*      */     case 8:
/*  496 */       if (!paramBoolean)
/*      */       {
/*  498 */         localObject = new T4CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  501 */       break;
/*      */     case 1:
/*  506 */       localObject = new T4CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  509 */       break;
/*      */     case 2:
/*  512 */       localObject = new T4CNumberAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  515 */       break;
/*      */     case 6:
/*  518 */       localObject = new T4CVarnumAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  521 */       break;
/*      */     case 24:
/*  524 */       if (!paramBoolean)
/*      */       {
/*  526 */         localObject = new T4CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  529 */       break;
/*      */     case 23:
/*  534 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/*  536 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/*  537 */         localSQLException.fillInStackTrace();
/*  538 */         throw localSQLException;
/*      */       }
/*      */ 
/*  541 */       if (paramBoolean) {
/*  542 */         localObject = new T4COutRawAccessor(this, paramInt4, paramShort, paramInt2, this.t4Connection.mare);
/*      */       }
/*      */       else {
/*  545 */         localObject = new T4CRawAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  548 */       break;
/*      */     case 100:
/*  551 */       localObject = new T4CBinaryFloatAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  554 */       break;
/*      */     case 101:
/*  557 */       localObject = new T4CBinaryDoubleAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  560 */       break;
/*      */     case 104:
/*  563 */       if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */       {
/*  569 */         localObject = new T4CVarcharAccessor(this, 18, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  573 */         ((Accessor)localObject).definedColumnType = -8;
/*      */       }
/*      */       else {
/*  576 */         localObject = new T4CRowidAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */       }
/*      */ 
/*  580 */       break;
/*      */     case 102:
/*  583 */       localObject = new T4CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  586 */       break;
/*      */     case 12:
/*  589 */       localObject = new T4CDateAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  592 */       break;
/*      */     case 113:
/*  595 */       localObject = new T4CBlobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  598 */       break;
/*      */     case 112:
/*  601 */       localObject = new T4CClobAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  604 */       break;
/*      */     case 114:
/*  607 */       localObject = new T4CBfileAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  610 */       break;
/*      */     case 109:
/*  613 */       localObject = new T4CNamedTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  616 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  618 */       break;
/*      */     case 111:
/*  621 */       localObject = new T4CRefTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  624 */       ((Accessor)localObject).initMetadata();
/*      */ 
/*  626 */       break;
/*      */     case 180:
/*  631 */       localObject = new T4CTimestampAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  634 */       break;
/*      */     case 181:
/*  637 */       localObject = new T4CTimestamptzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  640 */       break;
/*      */     case 231:
/*  643 */       localObject = new T4CTimestampltzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  646 */       break;
/*      */     case 182:
/*  649 */       localObject = new T4CIntervalymAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  652 */       break;
/*      */     case 183:
/*  655 */       localObject = new T4CIntervaldsAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean, this.t4Connection.mare);
/*      */ 
/*  658 */       break;
/*      */     case 995:
/*  671 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/*  672 */       localSQLException.fillInStackTrace();
/*  673 */       throw localSQLException;
/*      */     }
/*      */ 
/*  677 */     return localObject;
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  703 */     if (!this.isOpen)
/*      */     {
/*  706 */       this.connection.open(this);
/*  707 */       this.isOpen = true;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  713 */       this.t4Connection.needLine();
/*  714 */       this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
/*  715 */       this.accessors = this.t4Connection.describe.getAccessors();
/*      */ 
/*  717 */       this.numberOfDefinePositions = this.t4Connection.describe.numuds;
/*      */ 
/*  719 */       for (int i = 0; i < this.numberOfDefinePositions; i++)
/*  720 */         this.accessors[i].initMetadata();
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  724 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  727 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  728 */       localSQLException.fillInStackTrace();
/*  729 */       throw localSQLException;
/*      */     }
/*      */ 
/*  733 */     this.describedWithNames = true;
/*  734 */     this.described = true;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  769 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.execute_for_describe");
/*      */     try {
/*  771 */       doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null);
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*      */       long l1;
/*  780 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  784 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  786 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  787 */       localSQLException2.fillInStackTrace();
/*  788 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*  793 */       this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
/*  794 */       this.validRows = this.t4Connection.all8.getNumRows();
/*  795 */       if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
/*  796 */         if (this.validRows > 0) {
/*  797 */           calculateCheckSum();
/*  798 */         } else if (this.rowsProcessed > 0) {
/*  799 */           long l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
/*      */ 
/*  801 */           this.checkSum = l2;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  806 */     this.needToParse = false;
/*      */ 
/*  816 */     if (this.definedColumnType == null) {
/*  817 */       this.implicitDefineForLobPrefetchDone = false;
/*      */     }
/*  819 */     this.aFetchWasDoneDuringDescribe = false;
/*  820 */     if (this.t4Connection.all8.aFetchWasDone)
/*      */     {
/*  822 */       this.aFetchWasDoneDuringDescribe = true;
/*  823 */       this.rowPrefetchInLastFetch = this.rowPrefetch;
/*      */     }
/*      */ 
/*  827 */     for (int i = 0; i < this.numberOfDefinePositions; i++) {
/*  828 */       this.accessors[i].initMetadata();
/*      */     }
/*  830 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/*  872 */         boolean bool = false;
/*  873 */         if (this.columnsDefinedByUser) {
/*  874 */           this.needToPrepareDefineBuffer = false;
/*      */         }
/*  894 */         else if ((this.t4Connection.useLobPrefetch) && (this.accessors != null) && (this.defaultLobPrefetchSize != -1) && (!this.implicitDefineForLobPrefetchDone) && (!this.aFetchWasDoneDuringDescribe) && (this.definedColumnType == null))
/*      */         {
/*  902 */           int i = 0;
/*  903 */           int[] arrayOfInt1 = new int[this.accessors.length];
/*  904 */           int[] arrayOfInt2 = new int[this.accessors.length];
/*  905 */           int[] arrayOfInt3 = new int[this.accessors.length];
/*      */ 
/*  907 */           for (int j = 0; j < this.accessors.length; j++) {
/*  908 */             if (this.accessors[j] != null)
/*      */             {
/*  912 */               arrayOfInt1[j] = getJDBCType(this.accessors[j].internalType);
/*  913 */               arrayOfInt3[j] = this.accessors[j].formOfUse;
/*  914 */               if ((this.accessors[j].internalType == 113) || (this.accessors[j].internalType == 112) || (this.accessors[j].internalType == 114))
/*      */               {
/*  920 */                 i = 1;
/*      */ 
/*  922 */                 this.accessors[j].setPrefetchLength(this.defaultLobPrefetchSize);
/*  923 */                 arrayOfInt2[j] = this.defaultLobPrefetchSize;
/*      */               }
/*      */             }
/*      */           }
/*  927 */           if (i != 0)
/*      */           {
/*  929 */             this.definedColumnType = arrayOfInt1;
/*  930 */             this.definedColumnSize = arrayOfInt2;
/*  931 */             this.definedColumnFormOfUse = arrayOfInt3;
/*  932 */             bool = true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  938 */         doOall8(this.needToParse, !paramBoolean, true, false, bool);
/*      */ 
/*  940 */         this.needToParse = false;
/*  941 */         if (bool)
/*  942 */           this.implicitDefineForLobPrefetchDone = true;
/*      */       }
/*      */       finally
/*      */       {
/*  946 */         if (this.implicitResultSetStatements == null)
/*  947 */           this.validRows = this.t4Connection.all8.getNumRows();
/*      */         else
/*  949 */           this.validRows = 0;
/*  950 */         calculateCheckSum();
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/*  955 */       throw localSQLException1;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*  959 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/*  961 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  962 */       localSQLException2.fillInStackTrace();
/*  963 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  989 */     if (this.rowData != null)
/*  990 */       if (paramBoolean)
/*      */       {
/*  992 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*  994 */       else this.rowData.reset();
/*      */     SQLException localSQLException;
/*  998 */     if (this.streamList != null)
/*      */     {
/* 1000 */       while (this.nextStream != null) {
/*      */         try {
/* 1002 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException1) {
/* 1005 */           ((T4CConnection)this.connection).handleIOException(localIOException1);
/*      */ 
/* 1007 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 1008 */           localSQLException.fillInStackTrace();
/* 1009 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1012 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */     try
/*      */     {
/* 1017 */       doOall8(false, false, true, false, false, paramInt);
/* 1018 */       this.validRows = this.t4Connection.all8.getNumRows();
/* 1019 */       if (this.validRows != -2) this.validRows -= paramInt;
/* 1020 */       calculateCheckSum();
/*      */     }
/*      */     catch (IOException localIOException2) {
/* 1023 */       ((T4CConnection)this.connection).handleIOException(localIOException2);
/*      */ 
/* 1025 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 1026 */       localSQLException.fillInStackTrace();
/* 1027 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void continueReadRow(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1046 */       if (!this.isFetchStreams)
/*      */       {
/* 1048 */         T4C8Oall localT4C8Oall = this.t4Connection.all8;
/*      */ 
/* 1050 */         localT4C8Oall.continueReadRow(paramInt, this);
/*      */       }
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1055 */       ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1057 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1058 */       localSQLException2.fillInStackTrace();
/* 1059 */       throw localSQLException2;
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 1064 */       if (localSQLException1.getErrorCode() == DatabaseError.getVendorCode(110))
/*      */       {
/* 1067 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
/*      */       }
/*      */       else
/*      */       {
/* 1072 */         throw localSQLException1;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1096 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.do_close");
/* 1097 */     if (this.cursorId != 0)
/*      */     {
/* 1099 */       this.t4Connection.closeCursor(this.cursorId);
/*      */     }
/*      */ 
/* 1102 */     this.tmpByteArray = null;
/* 1103 */     this.tmpBindsByteArray = null;
/* 1104 */     this.definedColumnType = null;
/* 1105 */     this.definedColumnSize = null;
/* 1106 */     this.definedColumnFormOfUse = null;
/* 1107 */     this.oacdefSent = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 1126 */     this.connection.registerHeartbeat();
/* 1127 */     this.connection.needLine();
/* 1128 */     this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.closeQuery");
/*      */ 
/* 1130 */     if (this.streamList != null)
/*      */     {
/* 1132 */       while (this.nextStream != null) {
/*      */         try {
/* 1134 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException) {
/* 1137 */           ((T4CConnection)this.connection).handleIOException(localIOException);
/*      */ 
/* 1139 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1140 */           localSQLException.fillInStackTrace();
/* 1141 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1144 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   Binder getRowidNullBinder(int paramInt)
/*      */   {
/* 1155 */     if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */     {
/* 1158 */       this.currentRowCharLens[paramInt] = 1;
/* 1159 */       return this.theVarcharNullBinder;
/*      */     }
/*      */ 
/* 1162 */     return this.theRowidNullBinder;
/*      */   }
/*      */ 
/*      */   Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1172 */     return new T4CPlsqlIndexTableAccessor(this, paramPlsqlIbtBindInfo, paramShort, this.t4Connection.mare);
/*      */   }
/*      */ 
/*      */   void endOfResultSet(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1182 */     super.endOfResultSet(paramBoolean);
/* 1183 */     this.rowData.free();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CCallableStatement
 * JD-Core Version:    0.6.2
 */