/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ import oracle.sql.BLOB;
/*     */ 
/*     */ class T4CBlobAccessor extends BlobAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/* 119 */   final int[] meta = new int[1];
/*     */ 
/* 267 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CBlobAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  41 */     super(paramOracleStatement, 4000, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  43 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CBlobAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  53 */     super(paramOracleStatement, 4000, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  57 */     this.mare = paramT4CMAREngine;
/*  58 */     this.definedColumnType = paramInt7;
/*  59 */     this.definedColumnSize = paramInt8;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  64 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  73 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  76 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  83 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  90 */       this.mare.unmarshalUB2();
/*  91 */       this.mare.unmarshalUB2();
/*     */     }
/*  93 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  97 */       this.mare.unmarshalSB2();
/*     */ 
/*  99 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 100 */         this.mare.unmarshalSB2();
/*     */     }
/* 102 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 103 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 109 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 110 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 128 */     boolean bool = false;
/* 129 */     if (!isUseless())
/*     */     {
/* 135 */       if (isUnexpected())
/*     */       {
/* 138 */         long l = this.rowData.getPosition();
/* 139 */         unmarshalColumnMetadata();
/* 140 */         unmarshalBytes();
/* 141 */         this.rowData.setPosition(l);
/* 142 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 144 */       else if (isNullByDescribe())
/*     */       {
/* 147 */         setNull(this.lastRowProcessed, true);
/* 148 */         unmarshalColumnMetadata();
/* 149 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 153 */         unmarshalColumnMetadata();
/* 154 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 156 */     this.previousRowProcessed = this.lastRowProcessed;
/* 157 */     this.lastRowProcessed += 1;
/* 158 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 165 */     throw new NoSuchMethodError("oracle.jdbc.driver.T4C_lobAccessor.copyRow");
/*     */   }
/*     */ 
/*     */   byte[] getBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 177 */     if (isNull(paramInt)) return null;
/* 178 */     if (isPrefetched())
/*     */     {
/* 180 */       if (getPrefetchedLength(paramInt) > 2147483647L)
/*     */       {
/* 185 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 186 */         ((SQLException)localObject).fillInStackTrace();
/* 187 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 190 */       if (getPrefetchedDataLength(paramInt) == getPrefetchedLength(paramInt))
/*     */       {
/* 192 */         return getPrefetchedData(paramInt);
/*     */       }
/*     */ 
/* 195 */       assert (getPrefetchedDataLength(paramInt) <= getPrefetchedLength(paramInt)) : (" prefetchDataLength=" + getPrefetchedDataLength(paramInt) + " > length=" + getPrefetchedLength(paramInt));
/*     */ 
/* 198 */       Object localObject = getBLOB(paramInt);
/* 199 */       if (localObject == null) return null;
/* 200 */       return ((BLOB)localObject).getBytes(1L, (int)getPrefetchedLength(paramInt));
/*     */     }
/*     */ 
/* 205 */     return super.getBytes(paramInt);
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws IOException, SQLException
/*     */   {
/* 213 */     int i = (int)this.mare.unmarshalUB4();
/*     */ 
/* 215 */     if (i == 0) {
/* 216 */       setNull(this.lastRowProcessed, true);
/* 217 */       processIndicator(0);
/*     */     }
/*     */     else {
/* 220 */       if (isPrefetched()) unmarshalPrefetchData();
/* 221 */       setOffset(this.lastRowProcessed);
/* 222 */       int j = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 223 */       setNull(this.lastRowProcessed, j == 0);
/* 224 */       setLength(this.lastRowProcessed, j);
/* 225 */       processIndicator(j);
/*     */     }
/* 227 */     return false;
/*     */   }
/*     */ 
/*     */   void unmarshalPrefetchData()
/*     */     throws SQLException, IOException
/*     */   {
/* 236 */     setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
/*     */ 
/* 238 */     setPrefetchedChunkSize(this.lastRowProcessed, (int)this.mare.unmarshalUB4());
/*     */ 
/* 241 */     setPrefetchedDataOffset(this.lastRowProcessed);
/* 242 */     if (getPrefetchLength() > 0)
/* 243 */       setPrefetchedDataLength(this.lastRowProcessed, ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare));
/* 244 */     else setPrefetchedDataLength(this.lastRowProcessed, 0);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 252 */     if (this.definedColumnType == 0)
/* 253 */       return super.getObject(paramInt);
/* 254 */     if (isNull(paramInt)) return null;
/* 255 */     if (this.definedColumnType == 2004) {
/* 256 */       return getBLOB(paramInt);
/*     */     }
/* 258 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 259 */     localSQLException.fillInStackTrace();
/* 260 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CBlobAccessor
 * JD-Core Version:    0.6.2
 */