/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CBinaryDoubleAccessor extends BinaryDoubleAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/*  34 */   boolean underlyingLongRaw = false;
/*     */ 
/* 288 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CBinaryDoubleAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(paramOracleStatement, paramInt1, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  42 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CBinaryDoubleAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  51 */     super(paramOracleStatement, paramInt1 == -1 ? paramInt8 : paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  54 */     this.mare = paramT4CMAREngine;
/*     */ 
/*  57 */     if ((paramOracleStatement != null) && (paramOracleStatement.implicitDefineForLobPrefetchDone))
/*     */     {
/*  59 */       this.definedColumnType = 0;
/*  60 */       this.definedColumnSize = 0;
/*     */     }
/*     */     else
/*     */     {
/*  64 */       this.definedColumnType = paramInt7;
/*  65 */       this.definedColumnSize = paramInt8;
/*     */     }
/*     */ 
/*  68 */     if (paramInt1 == -1)
/*  69 */       this.underlyingLongRaw = true;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine()
/*     */   {
/*  74 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  83 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  86 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  93 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/* 100 */       this.mare.unmarshalUB2();
/* 101 */       this.mare.unmarshalUB2();
/*     */     }
/* 103 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/* 107 */       this.mare.unmarshalSB2();
/*     */ 
/* 109 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 110 */         this.mare.unmarshalSB2();
/*     */     }
/* 112 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 113 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 119 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 120 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 134 */     boolean bool = false;
/* 135 */     if (!isUseless())
/*     */     {
/* 141 */       if (isUnexpected())
/*     */       {
/* 144 */         long l = this.rowData.getPosition();
/* 145 */         unmarshalColumnMetadata();
/* 146 */         unmarshalBytes();
/* 147 */         this.rowData.setPosition(l);
/* 148 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 150 */       else if (isNullByDescribe())
/*     */       {
/* 153 */         setNull(this.lastRowProcessed, true);
/* 154 */         unmarshalColumnMetadata();
/* 155 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 159 */         unmarshalColumnMetadata();
/* 160 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 162 */     this.previousRowProcessed = this.lastRowProcessed;
/* 163 */     this.lastRowProcessed += 1;
/* 164 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws SQLException, IOException
/*     */   {
/* 176 */     setOffset(this.lastRowProcessed);
/*     */     int i;
/* 177 */     if (this.statement.maxFieldSize > 0)
/* 178 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize);
/*     */     else
/* 180 */       i = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 181 */     processIndicator(i);
/* 182 */     setLength(this.lastRowProcessed, i);
/* 183 */     setNull(this.lastRowProcessed, i == 0);
/* 184 */     return false;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 193 */     if (this.isNullByDescribe) {
/* 194 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 196 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 201 */       if (this.previousRowProcessed == -1)
/* 202 */         this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 203 */       long l = getOffset(this.previousRowProcessed);
/* 204 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 205 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 206 */       if (!isNull(this.previousRowProcessed)) {
/* 207 */         setOffset(this.lastRowProcessed);
/* 208 */         ((DynamicByteArray)this.rowData).copyLeft(l, getLength(this.previousRowProcessed));
/* 209 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 214 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 215 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 216 */       setOffset(this.lastRowProcessed, getOffset(this.previousRowProcessed));
/* 217 */       setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */     }
/* 219 */     this.previousRowProcessed = this.lastRowProcessed;
/* 220 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 229 */     if (this.definedColumnType == 0) return super.getObject(paramInt);
/* 230 */     if (isNull(paramInt)) return null;
/*     */ 
/* 233 */     switch (this.definedColumnType)
/*     */     {
/*     */     case -15:
/*     */     case -9:
/*     */     case -1:
/*     */     case 1:
/*     */     case 12:
/* 240 */       return getString(paramInt);
/*     */     case 2:
/*     */     case 3:
/* 244 */       return getBigDecimal(paramInt);
/*     */     case 6:
/*     */     case 8:
/* 248 */       return Double.valueOf(getDouble(paramInt));
/*     */     case 101:
/* 251 */       return getBINARY_DOUBLE(paramInt);
/*     */     case 7:
/* 254 */       return Float.valueOf(getFloat(paramInt));
/*     */     case -5:
/* 257 */       return Long.valueOf(getLong(paramInt));
/*     */     case -6:
/* 260 */       return Byte.valueOf(getByte(paramInt));
/*     */     case 5:
/* 263 */       return Short.valueOf(getShort(paramInt));
/*     */     case 4:
/* 266 */       return Integer.valueOf(getInt(paramInt));
/*     */     case -4:
/*     */     case -3:
/*     */     case -2:
/* 273 */       return getBytes(paramInt);
/*     */     }
/*     */ 
/* 277 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 278 */     localSQLException.fillInStackTrace();
/* 279 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CBinaryDoubleAccessor
 * JD-Core Version:    0.6.2
 */