/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class T4CBfileAccessor extends BfileAccessor
/*     */ {
/*     */   T4CMAREngine mare;
/* 267 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4CBfileAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  42 */     super(paramOracleStatement, 530, paramShort, paramInt2, paramBoolean);
/*     */ 
/*  44 */     this.mare = paramT4CMAREngine;
/*     */   }
/*     */ 
/*     */   T4CBfileAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, int paramInt7, int paramInt8, T4CMAREngine paramT4CMAREngine)
/*     */     throws SQLException
/*     */   {
/*  54 */     super(paramOracleStatement, 530, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort);
/*     */ 
/*  58 */     this.mare = paramT4CMAREngine;
/*  59 */     this.definedColumnType = paramInt7;
/*  60 */     this.definedColumnSize = paramInt8;
/*     */   }
/*     */ 
/*     */   public T4CMAREngine getMAREngine() {
/*  64 */     return this.mare;
/*     */   }
/*     */ 
/*     */   public void unmarshalColumnMetadata()
/*     */     throws SQLException, IOException
/*     */   {
/*  73 */     if ((this.statement.statementType != 2) && (!this.statement.sqlKind.isPlsqlOrCall()) && (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED))
/*     */     {
/*  76 */       setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processIndicator(int paramInt)
/*     */     throws IOException, SQLException
/*     */   {
/*  83 */     if (((this.internalType == 1) && (this.describeType == 112)) || ((this.internalType == 23) && (this.describeType == 113)))
/*     */     {
/*  90 */       this.mare.unmarshalUB2();
/*  91 */       this.mare.unmarshalUB2();
/*     */     }
/*  93 */     else if (this.statement.connection.versionNumber < 9200)
/*     */     {
/*  97 */       this.mare.unmarshalSB2();
/*     */ 
/*  99 */       if (!this.statement.sqlKind.isPlsqlOrCall())
/* 100 */         this.mare.unmarshalSB2();
/*     */     }
/* 102 */     else if ((this.statement.sqlKind.isPlsqlOrCall()) || (this.isDMLReturnedParam)) {
/* 103 */       this.mare.processIndicator(paramInt <= 0, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getPreviousRowProcessed()
/*     */   {
/* 109 */     if (this.previousRowProcessed == -1) this.previousRowProcessed = (this.statement.rowPrefetchInLastFetch - 1);
/* 110 */     return this.previousRowProcessed;
/*     */   }
/*     */ 
/*     */   boolean unmarshalOneRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 124 */     boolean bool = false;
/* 125 */     if (!isUseless())
/*     */     {
/* 131 */       if (isUnexpected())
/*     */       {
/* 134 */         long l = this.rowData.getPosition();
/* 135 */         unmarshalColumnMetadata();
/* 136 */         unmarshalBytes();
/* 137 */         this.rowData.setPosition(l);
/* 138 */         setNull(this.lastRowProcessed, true);
/*     */       }
/* 140 */       else if (isNullByDescribe())
/*     */       {
/* 143 */         setNull(this.lastRowProcessed, true);
/* 144 */         unmarshalColumnMetadata();
/* 145 */         if (this.statement.connection.versionNumber < 9200) processIndicator(0);
/*     */       }
/*     */       else
/*     */       {
/* 149 */         unmarshalColumnMetadata();
/* 150 */         bool = unmarshalBytes();
/*     */       }
/*     */     }
/* 152 */     this.previousRowProcessed = this.lastRowProcessed;
/* 153 */     this.lastRowProcessed += 1;
/* 154 */     return bool;
/*     */   }
/*     */ 
/*     */   void copyRow()
/*     */     throws SQLException, IOException
/*     */   {
/* 164 */     if (this.isNullByDescribe) {
/* 165 */       setNull(this.lastRowProcessed, true);
/*     */     }
/* 167 */     else if (this.lastRowProcessed == 0)
/*     */     {
/* 172 */       long l1 = getOffset(this.previousRowProcessed);
/* 173 */       long l2 = getPrefetchedDataOffset(this.previousRowProcessed);
/* 174 */       setNull(this.lastRowProcessed, isNull(this.previousRowProcessed));
/* 175 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
/* 176 */       if (!isNull(this.previousRowProcessed)) {
/* 177 */         if (isPrefetched()) {
/* 178 */           setPrefetchedLength(this.lastRowProcessed, getPrefetchedLength(this.previousRowProcessed));
/* 179 */           setPrefetchedChunkSize(this.lastRowProcessed, getPrefetchedChunkSize(this.previousRowProcessed));
/* 180 */           setPrefetchedDataLength(this.lastRowProcessed, getPrefetchedDataLength(this.previousRowProcessed));
/* 181 */           setPrefetchedDataOffset(this.lastRowProcessed);
/* 182 */           ((DynamicByteArray)this.rowData).copyLeft(l2, getPrefetchedDataLength(this.previousRowProcessed));
/*     */         }
/*     */ 
/* 185 */         setOffset(this.lastRowProcessed);
/* 186 */         ((DynamicByteArray)this.rowData).copyLeft(l1, getLength(this.previousRowProcessed));
/* 187 */         setLength(this.lastRowProcessed, getLength(this.previousRowProcessed));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 192 */       int i = this.lastRowProcessed - 1;
/* 193 */       if (isPrefetched()) {
/* 194 */         setPrefetchedLength(this.lastRowProcessed, getPrefetchedLength(i));
/* 195 */         setPrefetchedChunkSize(this.lastRowProcessed, getPrefetchedChunkSize(i));
/* 196 */         setPrefetchedDataLength(this.lastRowProcessed, getPrefetchedDataLength(i));
/* 197 */         setPrefetchedDataOffset(this.lastRowProcessed, getPrefetchedDataOffset(i));
/*     */       }
/* 199 */       setNull(this.lastRowProcessed, isNull(i));
/* 200 */       this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[i];
/* 201 */       setOffset(this.lastRowProcessed, getOffset(i));
/* 202 */       setLength(this.lastRowProcessed, getLength(i));
/*     */     }
/* 204 */     this.previousRowProcessed = this.lastRowProcessed;
/* 205 */     this.lastRowProcessed += 1;
/*     */   }
/*     */ 
/*     */   boolean unmarshalBytes()
/*     */     throws IOException, SQLException
/*     */   {
/* 215 */     int i = (int)this.mare.unmarshalUB4();
/*     */ 
/* 217 */     if (i == 0) {
/* 218 */       setNull(this.lastRowProcessed, true);
/* 219 */       processIndicator(0);
/*     */     }
/*     */     else {
/* 222 */       if (isPrefetched()) unmarshalPrefetchData();
/* 223 */       setOffset(this.lastRowProcessed);
/* 224 */       int j = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
/* 225 */       setNull(this.lastRowProcessed, j == 0);
/* 226 */       setLength(this.lastRowProcessed, j);
/* 227 */       processIndicator(j);
/*     */     }
/* 229 */     return false;
/*     */   }
/*     */ 
/*     */   void unmarshalPrefetchData()
/*     */     throws SQLException, IOException
/*     */   {
/* 238 */     setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
/*     */ 
/* 241 */     setPrefetchedDataOffset(this.lastRowProcessed);
/* 242 */     setPrefetchedDataLength(this.lastRowProcessed, 0);
/* 243 */     if (getPrefetchLength() > 0)
/* 244 */       this.mare.unmarshalUB1();
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 252 */     if (this.definedColumnType == 0)
/* 253 */       return super.getObject(paramInt);
/* 254 */     if (isNull(paramInt)) return null;
/* 255 */     if (this.definedColumnType == -13) {
/* 256 */       return getBFILE(paramInt);
/*     */     }
/* 258 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 259 */     localSQLException.fillInStackTrace();
/* 260 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4CBfileAccessor
 * JD-Core Version:    0.6.2
 */