/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.StringWriter;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T4C8TTIpro extends T4CTTIMsg
/*     */ {
/*     */   short svrCharSet;
/*     */   short svrCharSetElem;
/*     */   byte svrFlags;
/*     */   byte[] proSvrStr;
/*     */   short proSvrVer;
/*  65 */   short oVersion = -1;
/*     */ 
/*  67 */   boolean svrInfoAvailable = false;
/*     */ 
/*  70 */   byte[] proCliVerTTC8 = { 6, 5, 4, 3, 2, 1, 0 };
/*     */ 
/*  76 */   byte[] proCliStrTTC8 = { 74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0 };
/*     */ 
/*  83 */   short NCHAR_CHARSET = 0;
/*     */ 
/*  85 */   byte[] runtimeCapabilities = null;
/*     */ 
/* 332 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4C8TTIpro(T4CConnection paramT4CConnection)
/*     */     throws SQLException, IOException
/*     */   {
/*  96 */     super(paramT4CConnection, (byte)1);
/*     */   }
/*     */ 
/*     */   byte[] receive()
/*     */     throws SQLException, IOException
/*     */   {
/*     */     SQLException localSQLException;
/* 127 */     if (this.meg.unmarshalUB1() != 1)
/*     */     {
/* 129 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 401);
/* 130 */       localSQLException.fillInStackTrace();
/* 131 */       throw localSQLException;
/*     */     }
/*     */ 
/* 134 */     this.proSvrVer = this.meg.unmarshalUB1();
/* 135 */     this.meg.proSvrVer = this.proSvrVer;
/*     */ 
/* 140 */     switch (this.proSvrVer)
/*     */     {
/*     */     case 4:
/* 144 */       this.oVersion = 7230;
/*     */ 
/* 146 */       break;
/*     */     case 5:
/* 150 */       this.oVersion = 8030;
/*     */ 
/* 152 */       break;
/*     */     case 6:
/* 155 */       this.oVersion = 8100;
/*     */ 
/* 157 */       break;
/*     */     default:
/* 161 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 444);
/* 162 */       localSQLException.fillInStackTrace();
/* 163 */       throw localSQLException;
/*     */     }
/*     */ 
/* 167 */     this.meg.unmarshalUB1();
/*     */ 
/* 169 */     this.proSvrStr = this.meg.unmarshalTEXT(50);
/* 170 */     this.oVersion = getOracleVersion();
/*     */ 
/* 173 */     this.svrCharSet = ((short)this.meg.unmarshalUB2());
/* 174 */     this.svrFlags = ((byte)this.meg.unmarshalUB1());
/*     */ 
/* 177 */     if ((this.svrCharSetElem = (short)this.meg.unmarshalUB2()) > 0)
/*     */     {
/* 183 */       this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
/*     */     }
/*     */ 
/* 186 */     this.svrInfoAvailable = true;
/*     */ 
/* 189 */     if (this.proSvrVer < 5) {
/* 190 */       return null;
/*     */     }
/*     */ 
/* 196 */     byte b = this.meg.types.getRep((byte)1);
/* 197 */     this.meg.types.setRep((byte)1, (byte)0);
/* 198 */     int i = this.meg.unmarshalUB2();
/*     */ 
/* 200 */     this.meg.types.setRep((byte)1, b);
/*     */ 
/* 202 */     byte[] arrayOfByte1 = this.meg.unmarshalNBytes(i);
/*     */ 
/* 205 */     int j = 6 + (arrayOfByte1[5] & 0xFF) + (arrayOfByte1[6] & 0xFF);
/*     */ 
/* 207 */     this.NCHAR_CHARSET = ((short)((arrayOfByte1[(j + 3)] & 0xFF) << 8));
/* 208 */     this.NCHAR_CHARSET = ((short)(this.NCHAR_CHARSET | (short)(arrayOfByte1[(j + 4)] & 0xFF)));
/*     */ 
/* 210 */     if (this.proSvrVer < 6) {
/* 211 */       return null;
/*     */     }
/*     */ 
/* 215 */     int k = this.meg.unmarshalUB1();
/* 216 */     byte[] arrayOfByte2 = new byte[k];
/* 217 */     for (int m = 0; m < k; m++) {
/* 218 */       arrayOfByte2[m] = ((byte)this.meg.unmarshalUB1());
/*     */     }
/*     */ 
/* 221 */     k = this.meg.unmarshalUB1();
/* 222 */     if (k > 0)
/*     */     {
/* 224 */       this.runtimeCapabilities = new byte[k];
/* 225 */       for (m = 0; m < k; m++) {
/* 226 */         this.runtimeCapabilities[m] = ((byte)this.meg.unmarshalUB1());
/*     */       }
/*     */     }
/* 229 */     return arrayOfByte2;
/*     */   }
/*     */ 
/*     */   short getOracleVersion()
/*     */   {
/* 241 */     return this.oVersion;
/*     */   }
/*     */ 
/*     */   byte[] getServerRuntimeCapabilities()
/*     */   {
/* 248 */     return this.runtimeCapabilities;
/*     */   }
/*     */ 
/*     */   short getCharacterSet()
/*     */   {
/* 260 */     return this.svrCharSet;
/*     */   }
/*     */ 
/*     */   short getncharCHARSET()
/*     */   {
/* 267 */     return this.NCHAR_CHARSET;
/*     */   }
/*     */ 
/*     */   byte getFlags()
/*     */   {
/* 279 */     return this.svrFlags;
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws SQLException, IOException
/*     */   {
/* 286 */     marshalTTCcode();
/*     */ 
/* 288 */     this.meg.marshalB1Array(this.proCliVerTTC8);
/* 289 */     this.meg.marshalB1Array(this.proCliStrTTC8);
/*     */   }
/*     */ 
/*     */   void printServerInfo()
/*     */   {
/* 303 */     if (this.svrInfoAvailable)
/*     */     {
/* 305 */       int i = 0;
/*     */ 
/* 310 */       StringWriter localStringWriter = new StringWriter();
/*     */ 
/* 312 */       localStringWriter.write("Protocol string  =");
/*     */ 
/* 314 */       while (i < this.proSvrStr.length)
/* 315 */         localStringWriter.write((char)this.proSvrStr[(i++)]);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4C8TTIpro
 * JD-Core Version:    0.6.2
 */