/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ abstract class T4C8TTILob extends T4CTTIfun
/*     */ {
/*     */   static final int KPLOB_READ = 2;
/*     */   static final int KPLOB_WRITE = 64;
/*     */   static final int KPLOB_WRITE_APPEND = 8192;
/*     */   static final int KPLOB_PAGE_SIZE = 16384;
/*     */   static final int KPLOB_FILE_OPEN = 256;
/*     */   static final int KPLOB_FILE_ISOPEN = 1024;
/*     */   static final int KPLOB_FILE_EXISTS = 2048;
/*     */   static final int KPLOB_FILE_CLOSE = 512;
/*     */   static final int KPLOB_OPEN = 32768;
/*     */   static final int KPLOB_CLOSE = 65536;
/*     */   static final int KPLOB_ISOPEN = 69632;
/*     */   static final int KPLOB_TMP_CREATE = 272;
/*     */   static final int KPLOB_TMP_FREE = 273;
/*     */   static final int KPLOB_GET_LEN = 1;
/*     */   static final int KPLOB_TRIM = 32;
/*     */   static final int KOKL_ORDONLY = 1;
/*     */   static final int KOKL_ORDWR = 2;
/*     */   static final int KOLF_ORDONLY = 11;
/*     */   static final int DTYCLOB = 112;
/*     */   static final int DTYBLOB = 113;
/*  77 */   byte[] sourceLobLocator = null;
/*  78 */   byte[] destinationLobLocator = null;
/*  79 */   long sourceOffset = 0L;
/*  80 */   long destinationOffset = 0L;
/*  81 */   int destinationLength = 0;
/*  82 */   short characterSet = 0;
/*  83 */   long lobamt = 0L;
/*  84 */   boolean lobnull = false;
/*  85 */   long lobops = 0L;
/*  86 */   int[] lobscn = null;
/*  87 */   int lobscnl = 0;
/*     */ 
/*  92 */   boolean nullO2U = false;
/*     */ 
/*  97 */   boolean sendLobamt = false;
/*     */ 
/* 100 */   byte[] inBuffer = null;
/*     */   long inBufferOffset;
/*     */   long inBufferNumBytes;
/* 104 */   byte[] outBuffer = null;
/* 105 */   int offsetInOutBuffer = 0;
/* 106 */   int rowsProcessed = 0;
/* 107 */   long lobBytesRead = 0L;
/* 108 */   boolean littleEndianClob = false;
/* 109 */   T4C8TTILobd lobd = null;
/*     */ 
/* 863 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4C8TTILob(T4CConnection paramT4CConnection)
/*     */   {
/* 115 */     super(paramT4CConnection, (byte)3);
/*     */ 
/* 117 */     setFunCode((short)96);
/*     */ 
/* 119 */     this.lobd = new T4C8TTILobd(paramT4CConnection);
/*     */   }
/*     */ 
/*     */   long read(byte[] paramArrayOfByte1, long paramLong1, long paramLong2, byte[] paramArrayOfByte2, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 134 */     initializeLobdef();
/*     */ 
/* 137 */     this.lobops = 2L;
/* 138 */     this.sourceLobLocator = paramArrayOfByte1;
/* 139 */     this.sourceOffset = paramLong1;
/* 140 */     this.lobamt = paramLong2;
/* 141 */     this.sendLobamt = true;
/* 142 */     this.outBuffer = paramArrayOfByte2;
/* 143 */     this.offsetInOutBuffer = paramInt;
/* 144 */     doRPC();
/*     */ 
/* 146 */     return this.lobBytesRead;
/*     */   }
/*     */ 
/*     */   long write(byte[] paramArrayOfByte1, long paramLong1, byte[] paramArrayOfByte2, long paramLong2, long paramLong3)
/*     */     throws SQLException, IOException
/*     */   {
/* 161 */     long l = 0L;
/*     */ 
/* 164 */     initializeLobdef();
/*     */ 
/* 167 */     this.lobops = 64L;
/* 168 */     this.sourceLobLocator = paramArrayOfByte1;
/* 169 */     this.sourceOffset = paramLong1;
/* 170 */     this.lobamt = paramLong3;
/* 171 */     this.sendLobamt = true;
/* 172 */     this.inBuffer = paramArrayOfByte2;
/* 173 */     this.inBufferOffset = paramLong2;
/* 174 */     this.inBufferNumBytes = paramLong3;
/*     */ 
/* 176 */     doRPC();
/*     */ 
/* 179 */     l = this.lobamt;
/*     */ 
/* 181 */     return l;
/*     */   }
/*     */ 
/*     */   long getLength(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 194 */     long l = 0L;
/*     */ 
/* 197 */     initializeLobdef();
/*     */ 
/* 200 */     this.lobops = 1L;
/* 201 */     this.sourceLobLocator = paramArrayOfByte;
/*     */ 
/* 204 */     this.sendLobamt = true;
/*     */ 
/* 206 */     doRPC();
/* 207 */     l = this.lobamt;
/*     */ 
/* 209 */     return l;
/*     */   }
/*     */ 
/*     */   long getChunkSize(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 222 */     long l = 0L;
/*     */ 
/* 225 */     initializeLobdef();
/*     */ 
/* 228 */     this.lobops = 16384L;
/* 229 */     this.sourceLobLocator = paramArrayOfByte;
/*     */ 
/* 232 */     this.sendLobamt = true;
/*     */ 
/* 234 */     doRPC();
/*     */ 
/* 236 */     l = this.lobamt;
/*     */ 
/* 238 */     return l;
/*     */   }
/*     */ 
/*     */   long trim(byte[] paramArrayOfByte, long paramLong)
/*     */     throws SQLException, IOException
/*     */   {
/* 251 */     long l = 0L;
/*     */ 
/* 254 */     initializeLobdef();
/*     */ 
/* 257 */     this.lobops = 32L;
/* 258 */     this.sourceLobLocator = paramArrayOfByte;
/* 259 */     this.lobamt = paramLong;
/* 260 */     this.sendLobamt = true;
/*     */ 
/* 262 */     doRPC();
/*     */ 
/* 264 */     l = this.lobamt;
/*     */ 
/* 267 */     return l;
/*     */   }
/*     */ 
/*     */   abstract Datum createTemporaryLob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   void freeTemporaryLob(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 289 */     initializeLobdef();
/*     */ 
/* 292 */     this.lobops = 273L;
/* 293 */     this.sourceLobLocator = paramArrayOfByte;
/*     */ 
/* 295 */     doRPC();
/*     */   }
/*     */ 
/*     */   abstract boolean open(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   boolean _open(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException, IOException
/*     */   {
/* 319 */     boolean bool = false;
/*     */ 
/* 324 */     if (((paramArrayOfByte[7] & 0x1) == 1) || ((paramArrayOfByte[4] & 0x40) == 64))
/*     */     {
/* 329 */       if ((paramArrayOfByte[7] & 0x8) == 8)
/*     */       {
/* 332 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 445);
/* 333 */         localSQLException.fillInStackTrace();
/* 334 */         throw localSQLException;
/*     */       }
/*     */       byte[] tmp60_57 = paramArrayOfByte; tmp60_57[7] = ((byte)(tmp60_57[7] | 0x8));
/*     */ 
/* 345 */       if (paramInt1 == 2)
/*     */       {
/*     */         byte[] tmp75_72 = paramArrayOfByte; tmp75_72[7] = ((byte)(tmp75_72[7] | 0x10));
/*     */       }
/* 348 */       bool = true;
/*     */     }
/*     */     else
/*     */     {
/* 357 */       initializeLobdef();
/*     */ 
/* 360 */       this.sourceLobLocator = paramArrayOfByte;
/* 361 */       this.lobops = paramInt2;
/* 362 */       this.lobamt = paramInt1;
/* 363 */       this.sendLobamt = true;
/*     */ 
/* 365 */       doRPC();
/*     */ 
/* 369 */       if (this.lobamt != 0L) {
/* 370 */         bool = true;
/*     */       }
/*     */     }
/* 373 */     return bool;
/*     */   }
/*     */ 
/*     */   abstract boolean close(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   boolean _close(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 392 */     boolean bool = true;
/*     */ 
/* 398 */     if (((paramArrayOfByte[7] & 0x1) == 1) || ((paramArrayOfByte[4] & 0x40) == 64))
/*     */     {
/* 403 */       if ((paramArrayOfByte[7] & 0x8) != 8)
/*     */       {
/* 406 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 446);
/* 407 */         localSQLException.fillInStackTrace();
/* 408 */         throw localSQLException;
/*     */       }
/*     */       byte[] tmp59_56 = paramArrayOfByte; tmp59_56[7] = ((byte)(tmp59_56[7] & 0xFFFFFFE7));
/*     */     }
/*     */     else
/*     */     {
/* 424 */       initializeLobdef();
/*     */ 
/* 427 */       this.sourceLobLocator = paramArrayOfByte;
/* 428 */       this.lobops = paramInt;
/*     */ 
/* 430 */       doRPC();
/*     */     }
/*     */ 
/* 434 */     return bool;
/*     */   }
/*     */ 
/*     */   abstract boolean isOpen(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException;
/*     */ 
/*     */   boolean _isOpen(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 454 */     boolean bool = false;
/*     */ 
/* 460 */     if (((paramArrayOfByte[7] & 0x1) == 1) || ((paramArrayOfByte[4] & 0x40) == 64))
/*     */     {
/* 465 */       if ((paramArrayOfByte[7] & 0x8) == 8) {
/* 466 */         bool = true;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 474 */       initializeLobdef();
/*     */ 
/* 477 */       this.sourceLobLocator = paramArrayOfByte;
/* 478 */       this.lobops = paramInt;
/* 479 */       this.nullO2U = true;
/*     */ 
/* 481 */       doRPC();
/*     */ 
/* 485 */       bool = this.lobnull;
/*     */     }
/*     */ 
/* 488 */     return bool;
/*     */   }
/*     */ 
/*     */   void initializeLobdef()
/*     */   {
/* 501 */     this.sourceLobLocator = null;
/* 502 */     this.destinationLobLocator = null;
/* 503 */     this.sourceOffset = 0L;
/* 504 */     this.destinationOffset = 0L;
/* 505 */     this.destinationLength = 0;
/* 506 */     this.characterSet = 0;
/* 507 */     this.lobamt = 0L;
/* 508 */     this.lobnull = false;
/* 509 */     this.lobops = 0L;
/* 510 */     this.lobscn = null;
/* 511 */     this.lobscnl = 0;
/* 512 */     this.inBuffer = null;
/* 513 */     this.outBuffer = null;
/* 514 */     this.nullO2U = false;
/* 515 */     this.sendLobamt = false;
/* 516 */     this.littleEndianClob = false;
/* 517 */     this.lobBytesRead = 0L;
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 552 */     int i = 0;
/*     */ 
/* 557 */     if (this.sourceLobLocator != null)
/*     */     {
/* 559 */       i = this.sourceLobLocator.length;
/*     */ 
/* 561 */       this.meg.marshalPTR();
/*     */     }
/*     */     else {
/* 564 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 567 */     this.meg.marshalSB4(i);
/*     */ 
/* 570 */     if (this.destinationLobLocator != null)
/*     */     {
/* 572 */       this.destinationLength = this.destinationLobLocator.length;
/*     */ 
/* 574 */       this.meg.marshalPTR();
/*     */     }
/*     */     else {
/* 577 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 580 */     this.meg.marshalSB4(this.destinationLength);
/*     */ 
/* 583 */     if (this.connection.getTTCVersion() >= 3)
/* 584 */       this.meg.marshalUB4(0L);
/*     */     else {
/* 586 */       this.meg.marshalUB4(this.sourceOffset);
/*     */     }
/*     */ 
/* 589 */     if (this.connection.getTTCVersion() >= 3)
/* 590 */       this.meg.marshalUB4(0L);
/*     */     else {
/* 592 */       this.meg.marshalUB4(this.destinationOffset);
/*     */     }
/*     */ 
/* 595 */     if (this.characterSet != 0)
/* 596 */       this.meg.marshalPTR();
/*     */     else {
/* 598 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 602 */     if ((this.sendLobamt == true) && (this.connection.getTTCVersion() < 3))
/* 603 */       this.meg.marshalPTR();
/*     */     else {
/* 605 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 613 */     if (this.nullO2U == true)
/* 614 */       this.meg.marshalPTR();
/*     */     else {
/* 616 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 619 */     this.meg.marshalUB4(this.lobops);
/*     */ 
/* 622 */     if (this.lobscnl != 0)
/* 623 */       this.meg.marshalPTR();
/*     */     else {
/* 625 */       this.meg.marshalNULLPTR();
/*     */     }
/*     */ 
/* 628 */     this.meg.marshalSB4(this.lobscnl);
/*     */ 
/* 630 */     if (this.connection.getTTCVersion() >= 3)
/*     */     {
/* 632 */       this.meg.marshalSB8(this.sourceOffset);
/* 633 */       this.meg.marshalSB8(this.destinationOffset);
/*     */ 
/* 635 */       if (this.sendLobamt == true)
/* 636 */         this.meg.marshalPTR();
/*     */       else
/* 638 */         this.meg.marshalNULLPTR();
/* 639 */       if (this.connection.getTTCVersion() >= 4)
/*     */       {
/* 655 */         this.meg.marshalNULLPTR();
/* 656 */         this.meg.marshalSWORD(0);
/* 657 */         this.meg.marshalNULLPTR();
/* 658 */         this.meg.marshalSWORD(0);
/* 659 */         this.meg.marshalNULLPTR();
/* 660 */         this.meg.marshalSWORD(0);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 672 */     if (this.sourceLobLocator != null)
/*     */     {
/* 674 */       this.meg.marshalB1Array(this.sourceLobLocator);
/*     */     }
/*     */ 
/* 678 */     if (this.destinationLobLocator != null)
/*     */     {
/* 680 */       this.meg.marshalB1Array(this.destinationLobLocator);
/*     */     }
/*     */ 
/* 684 */     if (this.characterSet != 0)
/*     */     {
/* 686 */       this.meg.marshalUB2(this.characterSet);
/*     */     }
/*     */ 
/* 690 */     if ((this.sendLobamt == true) && (this.connection.getTTCVersion() < 3))
/*     */     {
/* 694 */       this.meg.marshalUB4(this.lobamt);
/*     */     }
/*     */ 
/* 699 */     if (this.lobscnl != 0)
/*     */     {
/* 701 */       for (int j = 0; j < this.lobscnl; j++)
/*     */       {
/* 703 */         this.meg.marshalUB4(this.lobscn[j]);
/*     */       }
/*     */     }
/*     */ 
/* 707 */     if ((this.sendLobamt == true) && (this.connection.getTTCVersion() >= 3))
/*     */     {
/* 709 */       this.meg.marshalSB8(this.lobamt);
/*     */     }
/* 711 */     if (this.lobops == 64L)
/* 712 */       marshalData();
/*     */   }
/*     */ 
/*     */   void marshalData()
/*     */     throws IOException
/*     */   {
/* 721 */     boolean bool = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
/*     */ 
/* 723 */     int i = 0;
/* 724 */     if ((this.sourceLobLocator[6] & 0x80) == 128) {
/* 725 */       i = 1;
/*     */     }
/*     */ 
/* 729 */     if ((this.connection.versionNumber < 10101) && (i != 0))
/* 730 */       this.lobd.marshalClobUB2_For9iDB(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes);
/*     */     else
/* 732 */       this.lobd.marshalLobData(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes, bool);
/*     */   }
/*     */ 
/*     */   void readLOBD()
/*     */     throws IOException, SQLException
/*     */   {
/* 757 */     boolean bool = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
/*     */ 
/* 759 */     int i = 0;
/* 760 */     if ((this.sourceLobLocator[6] & 0x80) == 128) {
/* 761 */       i = 1;
/*     */     }
/*     */ 
/* 765 */     if ((this.connection.versionNumber < 10101) && (i != 0))
/* 766 */       this.lobBytesRead = this.lobd.unmarshalClobUB2_For9iDB(this.outBuffer, this.offsetInOutBuffer);
/*     */     else
/* 768 */       this.lobBytesRead = this.lobd.unmarshalLobData(this.outBuffer, this.offsetInOutBuffer, bool);
/*     */   }
/*     */ 
/*     */   void processError()
/*     */     throws SQLException
/*     */   {
/* 781 */     this.rowsProcessed = this.oer.getCurRowNumber();
/*     */ 
/* 786 */     if (this.oer.getRetCode() != 1403)
/*     */     {
/* 790 */       this.oer.processError();
/*     */     }
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws SQLException, IOException
/*     */   {
/*     */     int i;
/* 813 */     if (this.sourceLobLocator != null)
/*     */     {
/* 815 */       i = this.sourceLobLocator.length;
/*     */ 
/* 817 */       this.meg.getNBytes(this.sourceLobLocator, 0, i);
/*     */     }
/*     */ 
/* 821 */     if (this.destinationLobLocator != null)
/*     */     {
/* 823 */       i = this.meg.unmarshalSB2();
/*     */ 
/* 825 */       this.destinationLobLocator = this.meg.unmarshalNBytes(i);
/*     */     }
/*     */ 
/* 829 */     if (this.characterSet != 0)
/*     */     {
/* 831 */       this.characterSet = this.meg.unmarshalSB2();
/*     */     }
/*     */ 
/* 835 */     if (this.sendLobamt == true)
/*     */     {
/* 837 */       if (this.connection.getTTCVersion() >= 3)
/* 838 */         this.lobamt = this.meg.unmarshalSB8();
/*     */       else {
/* 840 */         this.lobamt = this.meg.unmarshalUB4();
/*     */       }
/*     */     }
/*     */ 
/* 844 */     if (this.nullO2U == true)
/*     */     {
/* 851 */       i = (short)this.meg.unmarshalSB1();
/*     */ 
/* 854 */       if (i != 0)
/* 855 */         this.lobnull = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4C8TTILob
 * JD-Core Version:    0.6.2
 */