/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleConnection;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NCLOB;
/*     */ 
/*     */ final class T4C8TTIClob extends T4C8TTILob
/*     */ {
/*     */   int[] nBytes;
/* 638 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4C8TTIClob(T4CConnection paramT4CConnection)
/*     */   {
/* 146 */     super(paramT4CConnection);
/*     */ 
/* 148 */     this.nBytes = new int[1];
/*     */   }
/*     */ 
/*     */   long read(byte[] paramArrayOfByte, long paramLong1, long paramLong2, boolean paramBoolean, char[] paramArrayOfChar, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 183 */     long l1 = 0L;
/* 184 */     long l2 = paramLong2;
/* 185 */     int i = 0;
/*     */ 
/* 197 */     byte[] arrayOfByte = null;
/*     */     try
/*     */     {
/* 202 */       initializeLobdef();
/*     */ 
/* 210 */       if ((paramArrayOfByte[6] & 0x80) == 128) {
/* 211 */         i = 1;
/*     */       }
/*     */ 
/* 218 */       int j = 0;
/* 219 */       if (i == 1)
/* 220 */         j = (int)paramLong2 * 2;
/*     */       else {
/* 222 */         j = (int)paramLong2 * 3;
/*     */       }
/*     */ 
/* 225 */       arrayOfByte = this.connection.getByteBuffer(j);
/*     */ 
/* 233 */       if ((paramArrayOfByte[7] & 0x40) > 0) {
/* 234 */         this.littleEndianClob = true;
/*     */       }
/*     */ 
/* 238 */       this.lobops = 2L;
/* 239 */       this.sourceLobLocator = paramArrayOfByte;
/* 240 */       this.sourceOffset = paramLong1;
/* 241 */       this.lobamt = paramLong2;
/* 242 */       this.sendLobamt = true;
/* 243 */       this.outBuffer = arrayOfByte;
/*     */ 
/* 245 */       doRPC();
/*     */ 
/* 247 */       l2 = this.lobamt;
/*     */ 
/* 253 */       long l3 = 0L;
/*     */ 
/* 258 */       if (i == 1)
/*     */       {
/* 260 */         if (this.connection.versionNumber < 10101)
/*     */         {
/* 264 */           DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, paramArrayOfChar);
/*     */         }
/* 267 */         else if (this.littleEndianClob)
/*     */         {
/* 269 */           CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, paramArrayOfChar, paramInt, (int)this.lobBytesRead, true);
/*     */         }
/*     */         else
/*     */         {
/* 274 */           CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, paramArrayOfChar, paramInt, (int)this.lobBytesRead, true);
/*     */         }
/*     */ 
/*     */       }
/* 282 */       else if (!paramBoolean)
/*     */       {
/* 287 */         this.nBytes[0] = ((int)this.lobBytesRead);
/*     */ 
/* 289 */         this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, paramArrayOfChar, paramInt, this.nBytes, paramArrayOfChar.length);
/*     */       }
/*     */       else
/*     */       {
/* 300 */         this.nBytes[0] = ((int)this.lobBytesRead);
/*     */ 
/* 302 */         this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, paramArrayOfChar, paramInt, this.nBytes, paramArrayOfChar.length);
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 309 */       this.outBuffer = null;
/* 310 */       this.connection.cacheBuffer(arrayOfByte);
/*     */     }
/*     */ 
/* 313 */     return l2;
/*     */   }
/*     */ 
/*     */   long write(byte[] paramArrayOfByte, long paramLong1, boolean paramBoolean, char[] paramArrayOfChar, long paramLong2, long paramLong3)
/*     */     throws SQLException, IOException
/*     */   {
/* 355 */     int i = 0;
/* 356 */     if ((paramArrayOfByte[6] & 0x80) == 128) {
/* 357 */       i = 1;
/*     */     }
/* 359 */     if ((paramArrayOfByte[7] & 0x40) == 64) {
/* 360 */       this.littleEndianClob = true;
/*     */     }
/*     */ 
/* 364 */     long l1 = 0L;
/* 365 */     byte[] arrayOfByte = null;
/*     */ 
/* 371 */     if (i == 1)
/*     */     {
/* 376 */       arrayOfByte = new byte[(int)paramLong3 * 2];
/*     */ 
/* 378 */       if (this.connection.versionNumber < 10101)
/*     */       {
/* 380 */         DBConversion.javaCharsToUcs2Bytes(paramArrayOfChar, (int)paramLong2, arrayOfByte, 0, (int)paramLong3);
/*     */       }
/* 382 */       else if (this.littleEndianClob)
/*     */       {
/* 384 */         CharacterSet.convertJavaCharsToAL16UTF16LEBytes(paramArrayOfChar, (int)paramLong2, arrayOfByte, 0, (int)paramLong3);
/*     */       }
/*     */       else
/*     */       {
/* 388 */         CharacterSet.convertJavaCharsToAL16UTF16Bytes(paramArrayOfChar, (int)paramLong2, arrayOfByte, 0, (int)paramLong3);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 396 */       arrayOfByte = new byte[(int)paramLong3 * 3];
/*     */ 
/* 398 */       if (!paramBoolean)
/*     */       {
/* 403 */         l1 = this.meg.conv.javaCharsToCHARBytes(paramArrayOfChar, (int)paramLong2, arrayOfByte, 0, (int)paramLong3);
/*     */       }
/*     */       else
/*     */       {
/* 411 */         l1 = this.meg.conv.javaCharsToNCHARBytes(paramArrayOfChar, (int)paramLong2, arrayOfByte, 0, (int)paramLong3);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 418 */     initializeLobdef();
/*     */ 
/* 421 */     this.lobops = 64L;
/* 422 */     this.sourceLobLocator = paramArrayOfByte;
/* 423 */     this.sourceOffset = paramLong1;
/* 424 */     this.lobamt = paramLong3;
/* 425 */     this.sendLobamt = true;
/* 426 */     this.inBuffer = arrayOfByte;
/* 427 */     this.inBufferOffset = 0L;
/*     */ 
/* 431 */     if (i == 1)
/*     */     {
/* 436 */       if (this.connection.versionNumber < 10101)
/* 437 */         this.inBufferNumBytes = paramLong3;
/*     */       else {
/* 439 */         this.inBufferNumBytes = (paramLong3 * 2L);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 446 */       this.inBufferNumBytes = l1;
/*     */     }
/* 448 */     doRPC();
/*     */ 
/* 450 */     long l2 = this.lobamt;
/*     */ 
/* 452 */     return l2;
/*     */   }
/*     */ 
/*     */   Datum createTemporaryLob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 472 */     return createTemporaryLob(paramConnection, paramBoolean, paramInt, (short)1);
/*     */   }
/*     */ 
/*     */   Datum createTemporaryLob(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*     */     throws SQLException, IOException
/*     */   {
/* 487 */     if (paramInt == 12)
/*     */     {
/* 489 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 158);
/* 490 */       ((SQLException)localObject).fillInStackTrace();
/* 491 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 496 */     Object localObject = null;
/*     */ 
/* 499 */     initializeLobdef();
/*     */ 
/* 502 */     this.lobops = 272L;
/* 503 */     this.sourceLobLocator = new byte[40];
/* 504 */     this.sourceLobLocator[1] = 84;
/*     */ 
/* 507 */     if (paramShort == 1)
/* 508 */       this.sourceOffset = 1L;
/*     */     else {
/* 510 */       this.sourceOffset = 2L;
/*     */     }
/*     */ 
/* 514 */     this.destinationOffset = 112L;
/*     */ 
/* 523 */     this.destinationLength = paramInt;
/*     */ 
/* 525 */     this.lobamt = paramInt;
/* 526 */     this.sendLobamt = true;
/*     */ 
/* 529 */     this.nullO2U = true;
/*     */ 
/* 534 */     this.characterSet = (paramShort == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId());
/*     */ 
/* 536 */     if (this.connection.versionNumber >= 9000)
/*     */     {
/* 538 */       this.lobscn = new int[1];
/* 539 */       this.lobscn[0] = (paramBoolean ? 1 : 0);
/* 540 */       this.lobscnl = 1;
/*     */     }
/*     */ 
/* 543 */     doRPC();
/*     */ 
/* 547 */     if (this.sourceLobLocator != null)
/*     */     {
/* 549 */       if (paramShort == 1) {
/* 550 */         localObject = new CLOB((OracleConnection)paramConnection, this.sourceLobLocator);
/*     */       }
/*     */       else
/*     */       {
/* 554 */         localObject = new NCLOB((OracleConnection)paramConnection, this.sourceLobLocator);
/*     */       }
/*     */     }
/*     */ 
/* 558 */     return localObject;
/*     */   }
/*     */ 
/*     */   boolean open(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException, IOException
/*     */   {
/* 577 */     boolean bool = false;
/*     */ 
/* 581 */     int i = 2;
/*     */ 
/* 583 */     if (paramInt == 0) {
/* 584 */       i = 1;
/*     */     }
/* 586 */     bool = _open(paramArrayOfByte, i, 32768);
/*     */ 
/* 588 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean close(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 606 */     boolean bool = false;
/*     */ 
/* 608 */     bool = _close(paramArrayOfByte, 65536);
/*     */ 
/* 610 */     return bool;
/*     */   }
/*     */ 
/*     */   boolean isOpen(byte[] paramArrayOfByte)
/*     */     throws SQLException, IOException
/*     */   {
/* 629 */     boolean bool = false;
/*     */ 
/* 631 */     bool = _isOpen(paramArrayOfByte, 69632);
/*     */ 
/* 633 */     return bool;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4C8TTIClob
 * JD-Core Version:    0.6.2
 */