/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayDeque;
/*      */ import java.util.Properties;
/*      */ import java.util.Vector;
/*      */ import oracle.jdbc.internal.KeywordValue;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ final class T4C8Oall extends T4CTTIfun
/*      */ {
/*  122 */   Vector<IOException> nonFatalIOExceptions = null;
/*      */ 
/*  124 */   static final byte[] EMPTY_BYTES = new byte[0];
/*      */   static final int UOPF_PRS = 1;
/*      */   static final int UOPF_BND = 8;
/*      */   static final int UOPF_EXE = 32;
/*      */   static final int UOPF_FEX = 512;
/*      */   static final int UOPF_FCH = 64;
/*      */   static final int UOPF_CAN = 128;
/*      */   static final int UOPF_COM = 256;
/*      */   static final int UOPF_DSY = 8192;
/*      */   static final int UOPF_SIO = 1024;
/*      */   static final int UOPF_NPL = 32768;
/*      */   static final int UOPF_DFN = 16;
/*      */   static final int UOPF_NCF = 262144;
/*      */   static final int EXE_COMMIT_ON_SUCCESS = 1;
/*      */   static final int EXE_LEAVE_CUR_MAPPED = 2;
/*      */   static final int EXE_BATCH_DML_ERRORS = 4;
/*      */   static final int EXE_SCROL_READ_ONLY = 8;
/*      */   static final int AL8EX_GET_PIDMLRC = 16384;
/*      */   static final int AL8KW_MAXLANG = 63;
/*      */   static final int AL8KW_TIMEZONE = 163;
/*      */   static final int AL8KW_ERR_OVLAP = 164;
/*      */   static final int AL8KW_SESSION_ID = 165;
/*      */   static final int AL8KW_SERIAL_NUM = 166;
/*      */   static final int AL8KW_TAG_FOUND = 167;
/*      */   static final int AL8KW_SCHEMA_NAME = 168;
/*      */   static final int AL8KW_SCHEMA_ID = 169;
/*      */   static final int AL8KW_ENABLED_ROLES = 170;
/*      */   static final int AL8KW_AUX_SESSSTATE = 171;
/*      */   static final int AL8KW_OPENCURSORS = 175;
/*      */   static final int AL8KW_PDBUID = 176;
/*      */   static final int AL8KW_DBID = 177;
/*      */   static final int AL8KW_GUDBID = 178;
/*      */   static final int AL8KW_DBNAME = 179;
/*  198 */   static final String[] NLS_KEYS = { "AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", null, null, null, null, "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCTERRITORY", "SESSION_NLS_LXCCHARSET", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", null, null, null, "AUTH_NLS_LXLAN", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "AUTH_NLS_LXCSORT", null, "AUTH_NLS_LXCUNIONCUR", null, null, null, null, "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_NLS_LXCNLSLENSEM", "SESSION_NLS_LXCNCHAREXCP", "SESSION_NLS_LXCNCHARIMP" };
/*      */   static final int LDIREGIDFLAG = 120;
/*      */   static final int LDIREGIDSET = 181;
/*      */   static final int LDIMAXTIMEFIELD = 60;
/*      */   static final int AL8EX_IMPL_RESULTS_CLIENT = 32768;
/*      */   int rowsProcessed;
/*      */   int numberOfDefinePositions;
/*      */   long options;
/*      */   int cursor;
/*  287 */   byte[] sqlStmt = new byte[0];
/*  288 */   final long[] al8i4 = new long[13];
/*      */ 
/*  291 */   boolean plsql = false;
/*      */   Accessor[] definesAccessors;
/*      */   int definesLength;
/*      */   Accessor[] outBindAccessors;
/*      */   int numberOfBindPositions;
/*      */   InputStream[][] parameterStream;
/*      */   byte[][][] parameterDatum;
/*      */   OracleTypeADT[][] parameterOtype;
/*      */   short[] bindIndicators;
/*      */   byte[] bindBytes;
/*      */   char[] bindChars;
/*      */   int bindIndicatorSubRange;
/*      */   byte[] tmpBindsByteArray;
/*      */   DBConversion conversion;
/*      */   byte[] ibtBindBytes;
/*      */   char[] ibtBindChars;
/*      */   short[] ibtBindIndicators;
/*  330 */   boolean sendBindsDefinition = false;
/*      */   OracleStatement oracleStatement;
/*      */   short dbCharSet;
/*      */   short NCharSet;
/*      */   T4CTTIrxd rxd;
/*      */   T4C8TTIrxh rxh;
/*      */   T4CTTIdcb dcb;
/*      */   T4CTTIimplres implres;
/*      */   OracleStatement.SqlKind typeOfStatement;
/*  346 */   int defCols = 0;
/*      */   int rowsToFetch;
/*  352 */   boolean aFetchWasDone = false;
/*      */   T4CTTIoac[] oacdefBindsSent;
/*      */   T4CTTIoac[] oacdefDefines;
/*      */   int[] definedColumnSize;
/*      */   int[] definedColumnType;
/*      */   int[] definedColumnFormOfUse;
/*  363 */   NTFDCNRegistration registration = null;
/*      */   static final int AL8TXCUR = 1;
/*      */   static final int AL8TXDON = 2;
/*      */   static final int AL8TXRON = 4;
/* 2014 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T4C8Oall(T4CConnection paramT4CConnection)
/*      */   {
/*  372 */     super(paramT4CConnection, (byte)3);
/*      */ 
/*  374 */     setFunCode((short)94);
/*  375 */     this.rxh = new T4C8TTIrxh(paramT4CConnection);
/*  376 */     this.rxd = new T4CTTIrxd(paramT4CConnection);
/*  377 */     this.dcb = new T4CTTIdcb(paramT4CConnection);
/*  378 */     this.implres = new T4CTTIimplres(paramT4CConnection);
/*      */   }
/*      */ 
/*      */   void doOALL(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, boolean paramBoolean5, OracleStatement.SqlKind paramSqlKind, int paramInt1, byte[] paramArrayOfByte1, int paramInt2, Accessor[] paramArrayOfAccessor1, int paramInt3, Accessor[] paramArrayOfAccessor2, int paramInt4, byte[] paramArrayOfByte2, char[] paramArrayOfChar1, short[] paramArrayOfShort1, int paramInt5, DBConversion paramDBConversion, byte[] paramArrayOfByte3, InputStream[][] paramArrayOfInputStream, byte[][][] paramArrayOfByte, OracleTypeADT[][] paramArrayOfOracleTypeADT, OracleStatement paramOracleStatement, byte[] paramArrayOfByte4, char[] paramArrayOfChar2, short[] paramArrayOfShort2, T4CTTIoac[] paramArrayOfT4CTTIoac, int[] paramArrayOfInt1, int[] paramArrayOfInt2, int[] paramArrayOfInt3, NTFDCNRegistration paramNTFDCNRegistration)
/*      */     throws SQLException, IOException
/*      */   {
/*  403 */     this.typeOfStatement = paramSqlKind;
/*  404 */     this.cursor = paramInt1;
/*  405 */     this.sqlStmt = (paramBoolean1 ? paramArrayOfByte1 : EMPTY_BYTES);
/*  406 */     this.rowsToFetch = paramInt2;
/*  407 */     this.outBindAccessors = paramArrayOfAccessor1;
/*  408 */     this.numberOfBindPositions = paramInt3;
/*  409 */     this.definesAccessors = paramArrayOfAccessor2;
/*  410 */     this.definesLength = paramInt4;
/*  411 */     this.bindBytes = paramArrayOfByte2;
/*  412 */     this.bindChars = paramArrayOfChar1;
/*  413 */     this.bindIndicators = paramArrayOfShort1;
/*  414 */     this.bindIndicatorSubRange = paramInt5;
/*  415 */     this.conversion = paramDBConversion;
/*  416 */     this.tmpBindsByteArray = paramArrayOfByte3;
/*  417 */     this.parameterStream = paramArrayOfInputStream;
/*  418 */     this.parameterDatum = paramArrayOfByte;
/*  419 */     this.parameterOtype = paramArrayOfOracleTypeADT;
/*  420 */     this.oracleStatement = paramOracleStatement;
/*  421 */     this.ibtBindBytes = paramArrayOfByte4;
/*  422 */     this.ibtBindChars = paramArrayOfChar2;
/*  423 */     this.ibtBindIndicators = paramArrayOfShort2;
/*  424 */     this.oacdefBindsSent = paramArrayOfT4CTTIoac;
/*  425 */     this.definedColumnType = paramArrayOfInt1;
/*  426 */     this.definedColumnSize = paramArrayOfInt2;
/*  427 */     this.definedColumnFormOfUse = paramArrayOfInt3;
/*  428 */     this.registration = paramNTFDCNRegistration;
/*      */ 
/*  431 */     this.dbCharSet = paramDBConversion.getServerCharSetId();
/*  432 */     this.NCharSet = paramDBConversion.getNCharSetId();
/*      */ 
/*  435 */     int i = 0;
/*  436 */     if (this.bindIndicators != null)
/*  437 */       i = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */     SQLException localSQLException1;
/*  441 */     if (paramArrayOfByte1 == null)
/*      */     {
/*  444 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 431);
/*  445 */       localSQLException1.fillInStackTrace();
/*  446 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  449 */     if ((!this.typeOfStatement.isDML()) && (i > 1))
/*      */     {
/*  453 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 433);
/*  454 */       localSQLException1.fillInStackTrace();
/*  455 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  460 */     this.rowsProcessed = 0;
/*  461 */     this.options = 0L;
/*  462 */     this.plsql = this.typeOfStatement.isPlsqlOrCall();
/*  463 */     this.sendBindsDefinition = false;
/*      */ 
/*  466 */     if (this.receiveState != 0)
/*      */     {
/*  471 */       this.receiveState = 0;
/*      */     }
/*      */ 
/*  474 */     this.rxh.init();
/*  475 */     this.rxd.init();
/*  476 */     this.oer.init();
/*      */ 
/*  479 */     if (paramBoolean5) {
/*  480 */       initDefinesDefinition();
/*      */     }
/*  482 */     if ((this.numberOfBindPositions > 0) && (this.bindIndicators != null))
/*      */     {
/*  484 */       if (this.oacdefBindsSent == null)
/*  485 */         this.oacdefBindsSent = new T4CTTIoac[this.numberOfBindPositions];
/*  486 */       this.sendBindsDefinition = initBindsDefinition(this.oacdefBindsSent);
/*      */     }
/*      */ 
/*  496 */     this.options = setOptions(paramBoolean1, paramBoolean2, paramBoolean3, paramBoolean5);
/*      */ 
/*  498 */     if ((this.options & 1L) > 0L)
/*  499 */       this.al8i4[0] = 1L;
/*      */     else {
/*  501 */       this.al8i4[0] = 0L;
/*      */     }
/*      */ 
/*  504 */     if ((this.plsql) || (this.typeOfStatement.isOTHER()))
/*  505 */       this.al8i4[1] = 1L;
/*  506 */     else if (paramBoolean4)
/*      */     {
/*  508 */       if ((paramBoolean3) && (this.oracleStatement.isFetchStreams))
/*  509 */         this.al8i4[1] = this.rowsToFetch;
/*      */       else
/*  511 */         this.al8i4[1] = 0L;
/*      */     }
/*  513 */     else if (this.typeOfStatement.isDML())
/*      */     {
/*  519 */       this.al8i4[1] = (i == 0 ? this.oracleStatement.batch : i);
/*      */     }
/*  521 */     else if ((paramBoolean3) && (!paramBoolean4))
/*      */     {
/*  523 */       this.al8i4[1] = this.rowsToFetch;
/*      */     }
/*  525 */     else this.al8i4[1] = 0L;
/*      */ 
/*  528 */     if (this.typeOfStatement.isSELECT())
/*  529 */       this.al8i4[7] = 1L;
/*      */     else {
/*  531 */       this.al8i4[7] = 0L;
/*      */     }
/*  533 */     long l = this.oracleStatement.inScn;
/*  534 */     int j = (int)l;
/*  535 */     int k = (int)(l >> 32);
/*  536 */     this.al8i4[5] = j;
/*  537 */     this.al8i4[6] = k;
/*      */ 
/*  540 */     if (this.typeOfStatement.isDML())
/*  541 */       this.al8i4[9] |= 16384L;
/*      */     else {
/*  543 */       this.al8i4[9] &= -16385L;
/*      */     }
/*  545 */     this.rowsProcessed = 0;
/*  546 */     this.aFetchWasDone = false;
/*      */ 
/*  549 */     this.rxd.setNumberOfColumns(this.definesLength);
/*      */ 
/*  551 */     if (((this.options & 0x40) != 0L) && ((this.options & 0x20) == 0L) && ((this.options & 1L) == 0L) && ((this.options & 0x8) == 0L) && ((this.options & 0x10) == 0L) && (!this.oracleStatement.needToSendOalToFetch))
/*      */     {
/*  554 */       setFunCode((short)5);
/*      */     }
/*  556 */     else setFunCode((short)94);
/*  557 */     if ((this.options & 0x20) != 0L)
/*  558 */       this.al8i4[9] |= 32768L;
/*      */     else {
/*  560 */       this.al8i4[9] &= -32769L;
/*      */     }
/*  562 */     if (getFunCode() == 94) {
/*  563 */       ((T4CConnection)this.oracleStatement.connection).setExecutingRPCSQL(this.oracleStatement.sqlObject.actualSql);
/*      */     }
/*  565 */     this.nonFatalIOExceptions = null;
/*  566 */     doRPC();
/*      */ 
/*  570 */     if ((this.options & 0x20) != 0L) {
/*  571 */       this.oracleStatement.inScn = 0L;
/*      */     }
/*      */ 
/*  574 */     this.ibtBindIndicators = null;
/*  575 */     this.ibtBindChars = null;
/*  576 */     this.ibtBindBytes = null;
/*  577 */     this.tmpBindsByteArray = null;
/*  578 */     this.outBindAccessors = null;
/*  579 */     this.bindBytes = null;
/*  580 */     this.bindChars = null;
/*  581 */     this.bindIndicators = null;
/*  582 */     this.oracleStatement = null;
/*  583 */     this.parameterStream = ((InputStream[][])null);
/*      */ 
/*  585 */     if (this.nonFatalIOExceptions != null)
/*      */     {
/*  587 */       IOException localIOException = (IOException)this.nonFatalIOExceptions.get(0);
/*      */       try
/*      */       {
/*  590 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 266);
/*  591 */         localSQLException2.fillInStackTrace();
/*  592 */         throw localSQLException2;
/*      */       }
/*      */       catch (SQLException localSQLException3)
/*      */       {
/*  600 */         localSQLException3.initCause(localIOException);
/*  601 */         throw localSQLException3;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void readBVC()
/*      */     throws IOException, SQLException
/*      */   {
/*  615 */     int i = this.meg.unmarshalUB2();
/*      */ 
/*  618 */     this.rxd.unmarshalBVC(i);
/*      */   }
/*      */ 
/*      */   void readIOV()
/*      */     throws IOException, SQLException
/*      */   {
/*  626 */     T4CTTIiov localT4CTTIiov = new T4CTTIiov(this.connection, this.rxh, this.rxd);
/*      */ 
/*  628 */     localT4CTTIiov.init();
/*  629 */     localT4CTTIiov.unmarshalV10();
/*      */ 
/*  632 */     if ((!this.oracleStatement.isDmlReturning) && (!localT4CTTIiov.isIOVectorEmpty()))
/*      */     {
/*  635 */       byte[] arrayOfByte = localT4CTTIiov.getIOVector();
/*      */ 
/*  640 */       this.outBindAccessors = localT4CTTIiov.processRXD(this.outBindAccessors, this.numberOfBindPositions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, arrayOfByte, this.parameterStream, this.parameterDatum, this.parameterOtype, this.oracleStatement, null, null, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   void readRXH()
/*      */     throws IOException, SQLException
/*      */   {
/*  656 */     this.rxh.init();
/*  657 */     this.rxh.unmarshalV10(this.rxd);
/*      */     SQLException localSQLException1;
/*  659 */     if (this.rxh.uacBufLength > 0)
/*      */     {
/*  662 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 405);
/*  663 */       localSQLException1.fillInStackTrace();
/*  664 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  668 */     if ((this.rxh.rxhflg & 0x8) == 8)
/*      */     {
/*  672 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 449);
/*  673 */       localSQLException1.fillInStackTrace();
/*  674 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  678 */     if ((this.rxh.rxhflg & 0x10) == 16)
/*      */     {
/*  684 */       for (int i = 0; i < this.definesAccessors.length; i++)
/*      */       {
/*  686 */         if ((this.definesAccessors[i].udskpos >= 0) && (this.definesAccessors[i].udskpos != i))
/*      */         {
/*  689 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 450);
/*  690 */           localSQLException2.fillInStackTrace();
/*  691 */           throw localSQLException2;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void processSLG()
/*      */     throws IOException, SQLException
/*      */   {
/*  764 */     readRXH();
/*      */ 
/*  767 */     int[] arrayOfInt = new int[this.numberOfBindPositions];
/*  768 */     for (int i = 0; i < this.numberOfBindPositions; i++) {
/*  769 */       arrayOfInt[i] = this.oacdefBindsSent[i].oacmxl;
/*      */     }
/*      */ 
/*  772 */     this.nonFatalIOExceptions = marshalBinds(arrayOfInt, true);
/*      */   }
/*      */ 
/*      */   boolean readRXD()
/*      */     throws IOException, SQLException
/*      */   {
/*  785 */     this.aFetchWasDone = true;
/*      */ 
/*  788 */     if ((this.oracleStatement.isDmlReturning) && (this.numberOfBindPositions > 0))
/*      */     {
/*  790 */       int i = 0;
/*  791 */       for (int j = 0; j < this.oracleStatement.numberOfBindPositions; j++)
/*      */       {
/*  793 */         Accessor localAccessor = this.oracleStatement.accessors[j];
/*  794 */         if (localAccessor != null)
/*      */         {
/*  796 */           int k = (int)this.meg.unmarshalUB4();
/*      */ 
/*  801 */           this.oracleStatement.increaseCapacity(k);
/*  802 */           this.oracleStatement.rowsDmlReturned = k;
/*      */ 
/*  804 */           for (int m = 0; m < k; m++)
/*      */           {
/*  809 */             localAccessor.unmarshalOneRow();
/*      */           }
/*      */         }
/*      */       }
/*  812 */       this.oracleStatement.returnParamsFetched = true;
/*      */     }
/*  815 */     else if ((this.iovProcessed) || ((this.outBindAccessors != null) && (this.definesAccessors == null)))
/*      */     {
/*  819 */       if (this.rxd.unmarshal(this.outBindAccessors, this.numberOfBindPositions))
/*      */       {
/*  821 */         return true;
/*      */       }
/*      */ 
/*      */     }
/*  825 */     else if (this.rxd.unmarshal(this.definesAccessors, this.definesLength))
/*      */     {
/*  831 */       return true;
/*      */     }
/*      */ 
/*  834 */     return false;
/*      */   }
/*      */ 
/*      */   void readRPA()
/*      */     throws IOException, SQLException
/*      */   {
/*  860 */     int i = this.meg.unmarshalUB2();
/*  861 */     int[] arrayOfInt = new int[i];
/*      */ 
/*  863 */     for (int j = 0; j < i; j++) {
/*  864 */       arrayOfInt[j] = ((int)this.meg.unmarshalUB4());
/*      */     }
/*  866 */     j = arrayOfInt[0];
/*  867 */     int k = arrayOfInt[1];
/*  868 */     long l1 = j & 0xFFFFFFFF | (k & 0xFFFFFFFF) << 32;
/*      */ 
/*  871 */     if (l1 != 0L) {
/*  872 */       this.oracleStatement.connection.outScn = l1;
/*      */     }
/*      */ 
/*  876 */     this.cursor = arrayOfInt[2];
/*      */ 
/*  879 */     int m = this.meg.unmarshalUB2();
/*      */ 
/*  881 */     byte[] arrayOfByte = null;
/*  882 */     if (m > 0) {
/*  883 */       arrayOfByte = this.meg.unmarshalNBytes(m);
/*      */     }
/*      */ 
/*  886 */     int n = this.meg.unmarshalUB2();
/*      */ 
/*  888 */     KeywordValue[] arrayOfKeywordValue = new KeywordValue[n];
/*  889 */     for (String str1 = 0; str1 < n; str1++) {
/*  890 */       arrayOfKeywordValue[str1] = KeywordValueI.unmarshal(this.meg);
/*      */     }
/*  892 */     this.connection.updateSessionProperties(arrayOfKeywordValue);
/*      */ 
/*  895 */     this.oracleStatement.dcnQueryId = -1L;
/*  896 */     this.oracleStatement.dcnTableName = null;
/*      */     Object localObject;
/*      */     int i1;
/*  897 */     if (this.connection.getTTCVersion() >= 4)
/*      */     {
/*  899 */       str1 = (int)this.meg.unmarshalUB4();
/*  900 */       localObject = this.meg.unmarshalNBytes(str1);
/*  901 */       if ((str1 > 0) && (this.registration != null))
/*      */       {
/*  903 */         i1 = 0;
/*  904 */         Properties localProperties = this.registration.getRegistrationOptions();
/*  905 */         if (localProperties != null)
/*      */         {
/*  907 */           str2 = localProperties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION");
/*  908 */           if ((str2 != null) && (str2.compareToIgnoreCase("true") == 0))
/*  909 */             i1 = 1;
/*      */         }
/*  911 */         String str2 = str1;
/*      */         int i2;
/*  912 */         if (i1 != 0) {
/*  913 */           i2 = str1 - 8;
/*      */         }
/*  915 */         String str3 = new String((byte[])localObject, 0, i2);
/*  916 */         char[] arrayOfChar = { '\000' };
/*  917 */         String[] arrayOfString = str3.split(new String(arrayOfChar));
/*  918 */         this.registration.addTablesName(arrayOfString, arrayOfString.length);
/*      */ 
/*  920 */         this.oracleStatement.dcnTableName = arrayOfString;
/*      */ 
/*  922 */         if (i1 != 0)
/*      */         {
/*  925 */           int i3 = localObject[(str1 - 1)] & 0xFF | (localObject[(str1 - 2)] & 0xFF) << 8 | (localObject[(str1 - 3)] & 0xFF) << 16 | (localObject[(str1 - 4)] & 0xFF) << 24;
/*      */ 
/*  930 */           int i4 = localObject[(str1 - 5)] & 0xFF | (localObject[(str1 - 6)] & 0xFF) << 8 | (localObject[(str1 - 7)] & 0xFF) << 16 | (localObject[(str1 - 8)] & 0xFF) << 24;
/*      */ 
/*  935 */           long l2 = i4 & 0xFFFFFFFF | (i3 & 0xFFFFFFFF) << 32;
/*  936 */           this.oracleStatement.dcnQueryId = l2;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  942 */     if ((this.connection.getTTCVersion() >= 7) && (this.typeOfStatement.isDML()))
/*      */     {
/*  944 */       str1 = (int)this.meg.unmarshalUB4();
/*  945 */       localObject = new int[str1];
/*  946 */       for (i1 = 0; i1 < str1; i1++)
/*      */       {
/*  948 */         localObject[i1] = ((int)this.meg.unmarshalSB8());
/*      */       }
/*  950 */       this.oracleStatement.batchRowsUpdatedArray = ((int[])localObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   void readDCB()
/*      */     throws IOException, SQLException
/*      */   {
/*  962 */     this.dcb.init(this.oracleStatement, 0);
/*      */ 
/*  964 */     this.definesAccessors = this.dcb.receive(this.definesAccessors);
/*  965 */     this.numberOfDefinePositions = this.dcb.numuds;
/*  966 */     this.definesLength = this.numberOfDefinePositions;
/*      */ 
/*  968 */     this.rxd.setNumberOfColumns(this.numberOfDefinePositions);
/*      */   }
/*      */ 
/*      */   void readIMPLRES()
/*      */     throws IOException, SQLException
/*      */   {
/*  976 */     this.implres.init(this.oracleStatement);
/*      */ 
/*  978 */     int i = (int)this.meg.unmarshalUB4();
/*  979 */     this.oracleStatement.implicitResultSetStatements = new ArrayDeque(i);
/*  980 */     while (i != 0)
/*      */     {
/*  983 */       this.implres.readImplicitResultSet();
/*  984 */       i--;
/*      */     }
/*  986 */     this.oracleStatement.implicitResultSetIterator = this.oracleStatement.implicitResultSetStatements.iterator();
/*      */   }
/*      */ 
/*      */   void processError()
/*      */     throws SQLException
/*      */   {
/*  997 */     this.cursor = this.oer.currCursorID;
/*      */ 
/* 1001 */     this.rowsProcessed = this.oer.getCurRowNumber();
/*      */ 
/* 1004 */     this.oracleStatement.isComplete |= this.oer.retCode == 1403;
/* 1005 */     if ((this.typeOfStatement.isSELECT()) && (this.oer.retCode == 1403))
/*      */     {
/* 1007 */       this.aFetchWasDone = true;
/*      */     }
/*      */ 
/* 1010 */     if ((!this.typeOfStatement.isSELECT()) || ((this.typeOfStatement.isSELECT()) && (this.oer.retCode != 1403)))
/*      */     {
/* 1012 */       if ((this.oracleStatement.connection.checksumMode.needToCalculateFetchChecksum()) && (this.oer.retCode != 0))
/*      */       {
/* 1014 */         long l = this.oer.updateChecksum(this.oracleStatement.checkSum);
/* 1015 */         this.oracleStatement.checkSum = l;
/*      */       }
/* 1017 */       this.oer.processError(this.oracleStatement);
/*      */     }
/*      */   }
/*      */ 
/*      */   int getCursorId()
/*      */   {
/* 1030 */     return this.cursor;
/*      */   }
/*      */ 
/*      */   void continueReadRow(int paramInt, OracleStatement paramOracleStatement)
/*      */     throws SQLException, IOException
/*      */   {
/*      */     try
/*      */     {
/* 1047 */       this.oracleStatement = paramOracleStatement;
/*      */ 
/* 1051 */       this.receiveState = 2;
/*      */ 
/* 1053 */       if (this.rxd.unmarshal(this.definesAccessors, paramInt, this.definesLength))
/*      */       {
/* 1059 */         this.receiveState = 3;
/*      */       }
/*      */       else
/*      */       {
/* 1065 */         resumeReceive();
/*      */       }
/*      */     }
/*      */     finally {
/* 1069 */       this.oracleStatement = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   int getNumRows()
/*      */   {
/* 1082 */     int i = 0;
/*      */ 
/* 1084 */     if (this.typeOfStatement == null) {
/* 1085 */       return i;
/*      */     }
/* 1087 */     if (this.receiveState == 3) {
/* 1088 */       i = -2;
/*      */     }
/*      */     else {
/* 1091 */       switch (1.$SwitchMap$oracle$jdbc$internal$OracleStatement$SqlKind[this.typeOfStatement.ordinal()]) {
/*      */       case 1:
/*      */       case 2:
/*      */       case 3:
/*      */       case 4:
/*      */       case 5:
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/* 1100 */         i = this.rowsProcessed;
/* 1101 */         break;
/*      */       case 9:
/*      */       case 10:
/* 1110 */         assert ((this.definesAccessors == null) || (this.definesAccessors[0] != null)) : "definesAccessors is not null but definesAccessors[0] is null";
/* 1111 */         i = (this.definesAccessors != null) && (this.definesLength > 0) && (this.definesAccessors[0] != null) ? this.definesAccessors[0].lastRowProcessed : 0;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1117 */     return i;
/*      */   }
/*      */ 
/*      */   void marshal()
/*      */     throws IOException
/*      */   {
/* 1129 */     if (getFunCode() == 5)
/*      */     {
/* 1131 */       this.meg.marshalSWORD(this.cursor);
/* 1132 */       this.meg.marshalSWORD((int)this.al8i4[1]);
/*      */     }
/*      */     else
/*      */     {
/* 1136 */       if (this.oracleStatement.needToSendOalToFetch) {
/* 1137 */         this.oracleStatement.needToSendOalToFetch = false;
/*      */       }
/* 1139 */       marshalPisdef();
/*      */ 
/* 1145 */       this.meg.marshalCHR(this.sqlStmt);
/*      */ 
/* 1148 */       this.meg.marshalUB4Array(this.al8i4);
/*      */ 
/* 1151 */       int[] arrayOfInt = new int[this.numberOfBindPositions];
/*      */ 
/* 1153 */       for (int i = 0; i < this.numberOfBindPositions; i++)
/*      */       {
/* 1155 */         arrayOfInt[i] = this.oacdefBindsSent[i].oacmxl;
/*      */       }
/*      */ 
/* 1159 */       if (((this.options & 0x8) != 0L) && (this.numberOfBindPositions > 0) && (this.bindIndicators != null) && (this.sendBindsDefinition))
/*      */       {
/* 1161 */         marshalBindsTypes(this.oacdefBindsSent);
/*      */       }
/*      */ 
/* 1165 */       if ((this.connection.getTTCVersion() >= 2) && ((this.options & 0x10) != 0L))
/*      */       {
/* 1167 */         for (i = 0; i < this.defCols; i++) {
/* 1168 */           this.oacdefDefines[i].marshal();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1174 */       if (((this.options & 0x20) != 0L) && (this.numberOfBindPositions > 0) && (this.bindIndicators != null))
/*      */       {
/* 1176 */         this.nonFatalIOExceptions = marshalBinds(arrayOfInt, false);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void marshalPisdef()
/*      */     throws IOException
/*      */   {
/* 1196 */     this.meg.marshalUB4(this.options);
/*      */ 
/* 1199 */     this.meg.marshalSWORD(this.cursor);
/*      */ 
/* 1203 */     if (this.sqlStmt.length == 0)
/* 1204 */       this.meg.marshalNULLPTR();
/*      */     else {
/* 1206 */       this.meg.marshalPTR();
/*      */     }
/*      */ 
/* 1209 */     this.meg.marshalSWORD(this.sqlStmt.length);
/*      */ 
/* 1213 */     if (this.al8i4.length == 0)
/* 1214 */       this.meg.marshalNULLPTR();
/*      */     else {
/* 1216 */       this.meg.marshalPTR();
/*      */     }
/*      */ 
/* 1219 */     this.meg.marshalSWORD(this.al8i4.length);
/*      */ 
/* 1223 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1226 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1229 */     if (((this.options & 0x40) == 0L) && ((this.options & 0x20) != 0L) && ((this.options & 1L) != 0L) && (this.typeOfStatement.isSELECT()))
/*      */     {
/* 1235 */       this.meg.marshalUB4(9223372036854775807L);
/* 1236 */       this.meg.marshalUB4(this.rowsToFetch);
/*      */     }
/*      */     else
/*      */     {
/* 1241 */       this.meg.marshalUB4(0L);
/*      */ 
/* 1243 */       this.meg.marshalUB4(0L);
/*      */     }
/*      */ 
/* 1248 */     if (!this.typeOfStatement.isPlsqlOrCall())
/* 1249 */       this.meg.marshalUB4(2147483647L);
/*      */     else {
/* 1251 */       this.meg.marshalUB4(32760L);
/*      */     }
/*      */ 
/* 1254 */     if (((this.options & 0x8) != 0L) && (this.numberOfBindPositions > 0) && (this.sendBindsDefinition))
/*      */     {
/* 1259 */       this.meg.marshalPTR();
/*      */ 
/* 1262 */       this.meg.marshalSWORD(this.numberOfBindPositions);
/*      */     }
/*      */     else
/*      */     {
/* 1268 */       this.meg.marshalNULLPTR();
/*      */ 
/* 1271 */       this.meg.marshalSWORD(0);
/*      */     }
/*      */ 
/* 1275 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1278 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1281 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1284 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1287 */     this.meg.marshalNULLPTR();
/*      */ 
/* 1292 */     if (this.connection.getTTCVersion() >= 2)
/*      */     {
/* 1294 */       if ((this.defCols > 0) && ((this.options & 0x10) != 0L))
/*      */       {
/* 1298 */         this.meg.marshalPTR();
/*      */ 
/* 1301 */         this.meg.marshalSWORD(this.defCols);
/*      */       }
/*      */       else
/*      */       {
/* 1307 */         this.meg.marshalNULLPTR();
/*      */ 
/* 1310 */         this.meg.marshalSWORD(0);
/*      */       }
/*      */     }
/*      */ 
/* 1314 */     if (this.connection.getTTCVersion() >= 4)
/*      */     {
/* 1323 */       int i = 0;
/* 1324 */       int j = 0;
/* 1325 */       if (this.registration != null)
/*      */       {
/* 1327 */         long l = this.registration.getRegId();
/* 1328 */         i = (int)(l & 0xFFFFFFFF);
/* 1329 */         j = (int)((l & 0x0) >> 32);
/*      */       }
/*      */ 
/* 1333 */       this.meg.marshalUB4(i);
/*      */ 
/* 1335 */       this.meg.marshalNULLPTR();
/* 1336 */       this.meg.marshalPTR();
/*      */ 
/* 1357 */       if (this.connection.getTTCVersion() >= 5)
/*      */       {
/* 1359 */         this.meg.marshalNULLPTR();
/* 1360 */         this.meg.marshalUB4(0L);
/* 1361 */         this.meg.marshalNULLPTR();
/* 1362 */         this.meg.marshalUB4(0L);
/*      */ 
/* 1364 */         this.meg.marshalUB4(j);
/*      */ 
/* 1366 */         if (this.connection.getTTCVersion() >= 7)
/*      */         {
/* 1374 */           if (this.typeOfStatement.isDML())
/*      */           {
/* 1376 */             this.meg.marshalPTR();
/* 1377 */             this.meg.marshalUB4(this.oracleStatement.currentRank);
/* 1378 */             this.meg.marshalPTR();
/*      */           }
/*      */           else
/*      */           {
/* 1382 */             this.meg.marshalNULLPTR();
/* 1383 */             this.meg.marshalUB4(0L);
/* 1384 */             this.meg.marshalNULLPTR();
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean initBindsDefinition(T4CTTIoac[] paramArrayOfT4CTTIoac)
/*      */     throws SQLException, IOException
/*      */   {
/* 1402 */     boolean bool = false;
/*      */ 
/* 1404 */     if (paramArrayOfT4CTTIoac.length != this.numberOfBindPositions)
/*      */     {
/* 1406 */       bool = true;
/* 1407 */       paramArrayOfT4CTTIoac = new T4CTTIoac[this.numberOfBindPositions];
/*      */     }
/*      */ 
/* 1411 */     short[] arrayOfShort = this.bindIndicators;
/*      */ 
/* 1414 */     int j = 0;
/*      */ 
/* 1417 */     int m = 0;
/*      */ 
/* 1420 */     for (int n = 0; n < this.numberOfBindPositions; n++)
/*      */     {
/* 1422 */       T4CTTIoac localT4CTTIoac = new T4CTTIoac(this.connection);
/*      */ 
/* 1427 */       int i = this.bindIndicatorSubRange + 5 + 10 * n;
/*      */ 
/* 1431 */       short s = arrayOfShort[(i + 9)];
/*      */ 
/* 1434 */       int k = arrayOfShort[(i + 0)] & 0xFFFF;
/*      */       Object localObject;
/*      */       int i2;
/* 1439 */       switch (k)
/*      */       {
/*      */       case 8:
/*      */       case 24:
/* 1444 */         if (this.plsql)
/* 1445 */           j = 32760;
/*      */         else {
/* 1447 */           j = 2147483647;
/*      */         }
/* 1449 */         localT4CTTIoac.init((short)k, j);
/* 1450 */         localT4CTTIoac.setFormOfUse(s);
/* 1451 */         localT4CTTIoac.setCharset(s == 2 ? this.NCharSet : this.dbCharSet);
/*      */ 
/* 1453 */         break;
/*      */       case 998:
/* 1458 */         if ((this.outBindAccessors != null) && (this.outBindAccessors[n] != null))
/*      */         {
/* 1460 */           PlsqlIbtBindInfo localPlsqlIbtBindInfo = this.outBindAccessors[n].plsqlIndexTableBindInfo();
/*      */ 
/* 1462 */           localT4CTTIoac.init((short)localPlsqlIbtBindInfo.element_internal_type, localPlsqlIbtBindInfo.elemMaxLen);
/*      */ 
/* 1464 */           localT4CTTIoac.setMal(localPlsqlIbtBindInfo.maxLen);
/* 1465 */           localT4CTTIoac.addFlg((short)64);
/* 1466 */           m++;
/*      */         }
/* 1468 */         else if (this.ibtBindIndicators[(6 + m * 8)] != 0)
/*      */         {
/* 1470 */           int i1 = this.ibtBindIndicators[(6 + m * 8)];
/* 1471 */           int i3 = (this.ibtBindIndicators[(6 + m * 8 + 2)] & 0xFFFF) << 16 | this.ibtBindIndicators[(6 + m * 8 + 3)] & 0xFFFF;
/*      */ 
/* 1475 */           j = this.ibtBindIndicators[(6 + m * 8 + 1)] * this.conversion.sMaxCharSize;
/*      */ 
/* 1477 */           localT4CTTIoac.init((short)i1, j);
/* 1478 */           localT4CTTIoac.setMal(i3);
/* 1479 */           localT4CTTIoac.addFlg((short)64);
/* 1480 */           m++;
/*      */         }
/*      */         else
/*      */         {
/* 1484 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), "INTERNAL ERROR: Binding PLSQL index-by table but no type defined", -1);
/* 1485 */           ((SQLException)localObject).fillInStackTrace();
/* 1486 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/*      */         break;
/*      */       case 109:
/*      */       case 111:
/* 1494 */         if ((this.outBindAccessors != null) && (this.outBindAccessors[n] != null))
/*      */         {
/* 1496 */           if (this.outBindAccessors[n].internalOtype != null)
/*      */           {
/* 1498 */             localT4CTTIoac.init((short)k, k == 109 ? 11 : 4000);
/*      */ 
/* 1500 */             localT4CTTIoac.setADT((OracleTypeADT)((TypeAccessor)this.outBindAccessors[n]).internalOtype);
/*      */           }
/*      */ 
/*      */         }
/* 1504 */         else if ((this.parameterOtype != null) && (this.parameterOtype[this.oracleStatement.firstRowInBatch] != null))
/*      */         {
/* 1507 */           localT4CTTIoac.init((short)k, k == 109 ? 11 : 4000);
/* 1508 */           localT4CTTIoac.setADT(this.parameterOtype[this.oracleStatement.firstRowInBatch][n]);
/*      */         }
/*      */         else
/*      */         {
/* 1514 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), "INTERNAL ERROR: Binding NAMED_TYPE but no type defined", -1);
/* 1515 */           ((SQLException)localObject).fillInStackTrace();
/* 1516 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/*      */         break;
/*      */       case 994:
/* 1524 */         localObject = this.oracleStatement.returnParamMeta;
/* 1525 */         k = localObject[(3 + n * 4 + 0)];
/*      */ 
/* 1530 */         j = localObject[(3 + n * 4 + 2)];
/*      */ 
/* 1535 */         s = (short)localObject[(3 + n * 4 + 3)];
/*      */ 
/* 1540 */         if ((k == 109) || (k == 111))
/*      */         {
/* 1542 */           TypeAccessor localTypeAccessor = (TypeAccessor)this.oracleStatement.accessors[n];
/*      */ 
/* 1545 */           localT4CTTIoac.init((short)k, k == 109 ? 11 : 4000);
/*      */ 
/* 1547 */           localT4CTTIoac.setADT((OracleTypeADT)localTypeAccessor.internalOtype);
/*      */         }
/*      */         else
/*      */         {
/* 1551 */           localT4CTTIoac.init((short)k, j);
/* 1552 */           localT4CTTIoac.setFormOfUse(s);
/* 1553 */           localT4CTTIoac.setCharset(s == 2 ? this.NCharSet : this.dbCharSet);
/*      */         }
/*      */ 
/* 1557 */         break;
/*      */       case 180:
/* 1560 */         j = arrayOfShort[(i + 1)] & 0xFFFF;
/*      */ 
/* 1564 */         localT4CTTIoac.init((short)k, j);
/* 1565 */         localT4CTTIoac.addFlg2(134217728);
/*      */ 
/* 1573 */         localT4CTTIoac.setTimestampFractionalSecondsPrecision((short)9);
/*      */ 
/* 1575 */         i2 = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */ 
/* 1580 */         if (i2 == 1)
/*      */         {
/* 1582 */           int i4 = ((arrayOfShort[(i + 7)] & 0xFFFF) << 16) + (arrayOfShort[(i + 8)] & 0xFFFF);
/*      */ 
/* 1585 */           int i5 = arrayOfShort[i4];
/*      */ 
/* 1587 */           if (i5 == 7)
/*      */           {
/* 1589 */             localT4CTTIoac.setTimestampFractionalSecondsPrecision((short)0);
/*      */           }
/*      */         }
/*      */ 
/* 1593 */         break;
/*      */       case 182:
/*      */       case 183:
/* 1597 */         j = arrayOfShort[(i + 1)] & 0xFFFF;
/*      */ 
/* 1601 */         localT4CTTIoac.init((short)k, j);
/* 1602 */         localT4CTTIoac.setFormOfUse(s);
/* 1603 */         localT4CTTIoac.setCharset(s == 2 ? this.NCharSet : this.dbCharSet);
/*      */ 
/* 1605 */         localT4CTTIoac.setPrecision((short)9);
/*      */ 
/* 1607 */         break;
/*      */       default:
/* 1614 */         j = arrayOfShort[(i + 1)] & 0xFFFF;
/*      */ 
/* 1621 */         if (j == 0)
/*      */         {
/* 1623 */           j = arrayOfShort[(i + 2)] & 0xFFFF;
/*      */ 
/* 1627 */           if (k == 996) {
/* 1628 */             j *= 2;
/*      */           }
/* 1630 */           else if (j > 1) {
/* 1631 */             j--;
/*      */           }
/*      */ 
/* 1634 */           if (s == 2) {
/* 1635 */             j *= this.conversion.maxNCharSize;
/*      */           }
/*      */ 
/* 1639 */           if ((this.typeOfStatement == OracleStatement.SqlKind.PLSQL_BLOCK) || ((this.connection.versionNumber >= 10200) && (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK)))
/*      */           {
/* 1643 */             if (j == 0)
/* 1644 */               j = this.connection.maxVcsBytesPlsql;
/*      */             else
/* 1646 */               j *= this.conversion.sMaxCharSize;
/*      */           }
/* 1648 */           else if (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK)
/*      */           {
/* 1653 */             if (j < 4001) {
/* 1654 */               j = 4001;
/*      */             }
/*      */ 
/*      */           }
/* 1659 */           else if (s != 2)
/*      */           {
/* 1670 */             i2 = this.connection.maxVarcharLength;
/* 1671 */             if ((((T4CConnection)this.oracleStatement.connection).retainV9BindBehavior) && (j <= i2))
/*      */             {
/* 1674 */               j = Math.min(j * this.conversion.sMaxCharSize, i2);
/*      */             }
/*      */             else
/*      */             {
/* 1678 */               j *= this.conversion.sMaxCharSize;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1684 */           if (j == 0) {
/* 1685 */             j = 32;
/*      */           }
/*      */         }
/* 1688 */         localT4CTTIoac.init((short)k, j);
/* 1689 */         localT4CTTIoac.setFormOfUse(s);
/* 1690 */         localT4CTTIoac.setCharset(s == 2 ? this.NCharSet : this.dbCharSet);
/*      */       }
/*      */ 
/* 1695 */       if ((paramArrayOfT4CTTIoac[n] == null) || (!localT4CTTIoac.isOldSufficient(paramArrayOfT4CTTIoac[n])))
/*      */       {
/* 1702 */         paramArrayOfT4CTTIoac[n] = localT4CTTIoac;
/* 1703 */         bool = true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1709 */     if (bool) {
/* 1710 */       this.oracleStatement.nbPostPonedColumns[0] = 0;
/*      */     }
/* 1712 */     return bool;
/*      */   }
/*      */ 
/*      */   void initDefinesDefinition()
/*      */     throws SQLException, IOException
/*      */   {
/* 1726 */     this.defCols = 0;
/*      */ 
/* 1728 */     for (int i = 0; i < this.definedColumnType.length; i++)
/*      */     {
/* 1730 */       if (this.definedColumnType[i] == 0)
/*      */         break;
/* 1732 */       this.defCols += 1;
/*      */     }
/* 1734 */     this.oacdefDefines = new T4CTTIoac[this.defCols];
/* 1735 */     i = 0;
/* 1736 */     int j = 0;
/* 1737 */     int k = 0;
/* 1738 */     short s1 = 0;
/* 1739 */     for (int m = 0; m < this.oacdefDefines.length; m++)
/*      */     {
/* 1741 */       this.oacdefDefines[m] = new T4CTTIoac(this.connection);
/* 1742 */       s1 = (short)this.oracleStatement.getInternalType(this.definedColumnType[m]);
/* 1743 */       j = 2147483647;
/* 1744 */       i = 0;
/* 1745 */       k = 0;
/* 1746 */       short s2 = 1;
/* 1747 */       if ((this.definedColumnFormOfUse != null) && (this.definedColumnFormOfUse.length > m) && (this.definedColumnFormOfUse[m] == 2))
/*      */       {
/* 1751 */         s2 = 2;
/*      */       }
/* 1753 */       if (s1 == 8) {
/* 1754 */         s1 = 1;
/* 1755 */       } else if (s1 == 24) {
/* 1756 */         s1 = 23;
/* 1757 */       } else if ((s1 == 1) || (s1 == 96))
/*      */       {
/* 1760 */         s1 = 1;
/*      */ 
/* 1766 */         j = this.connection.maxVarcharLength * this.conversion.sMaxCharSize;
/* 1767 */         if ((this.definedColumnSize != null) && (this.definedColumnSize.length > m) && (this.definedColumnSize[m] > 0))
/*      */         {
/* 1771 */           j = this.definedColumnSize[m] * this.conversion.sMaxCharSize;
/*      */         }
/* 1773 */       } else if ((this.connection.useLobPrefetch) && ((s1 == 113) || (s1 == 112) || (s1 == 114)))
/*      */       {
/* 1778 */         j = 0;
/* 1779 */         i = 33554432;
/* 1780 */         if ((this.definedColumnSize != null) && (this.definedColumnSize.length > m) && (this.definedColumnSize[m] > 0))
/*      */         {
/* 1784 */           k = this.definedColumnSize[m];
/*      */         }
/* 1786 */       } else if (s1 == 23) {
/* 1787 */         j = this.connection.maxRawLength;
/*      */       }
/* 1789 */       this.oacdefDefines[m].init(s1, j);
/* 1790 */       this.oacdefDefines[m].addFlg2(i);
/* 1791 */       this.oacdefDefines[m].setMxlc(k);
/* 1792 */       this.oacdefDefines[m].setFormOfUse(s2);
/* 1793 */       this.oacdefDefines[m].setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
/*      */     }
/*      */   }
/*      */ 
/*      */   void marshalBindsTypes(T4CTTIoac[] paramArrayOfT4CTTIoac)
/*      */     throws IOException
/*      */   {
/* 1803 */     if (paramArrayOfT4CTTIoac == null) {
/* 1804 */       return;
/*      */     }
/* 1806 */     for (int i = 0; i < paramArrayOfT4CTTIoac.length; i++)
/*      */     {
/* 1808 */       paramArrayOfT4CTTIoac[i].marshal();
/*      */     }
/*      */   }
/*      */ 
/*      */   Vector<IOException> marshalBinds(int[] paramArrayOfInt, boolean paramBoolean)
/*      */     throws IOException
/*      */   {
/* 1825 */     Vector localVector1 = null;
/* 1826 */     int i = ((this.bindIndicators[(this.bindIndicatorSubRange + 3)] & 0xFFFF) << 16) + (this.bindIndicators[(this.bindIndicatorSubRange + 4)] & 0xFFFF);
/*      */     int j;
/*      */     boolean bool;
/* 1834 */     if (paramBoolean)
/*      */     {
/* 1836 */       j = this.rxh.iterNum;
/* 1837 */       bool = true;
/*      */     }
/*      */     else
/*      */     {
/* 1841 */       j = 0;
/* 1842 */       bool = false;
/*      */     }
/*      */ 
/* 1846 */     for (; j < i; j++)
/*      */     {
/* 1848 */       int k = this.oracleStatement.firstRowInBatch + j;
/* 1849 */       InputStream[] arrayOfInputStream = null;
/* 1850 */       if (this.parameterStream != null)
/* 1851 */         arrayOfInputStream = this.parameterStream[k];
/* 1852 */       byte[][] arrayOfByte = (byte[][])null;
/* 1853 */       if (this.parameterDatum != null)
/* 1854 */         arrayOfByte = this.parameterDatum[k];
/* 1855 */       OracleTypeADT[] arrayOfOracleTypeADT = null;
/* 1856 */       if (this.parameterOtype != null) {
/* 1857 */         arrayOfOracleTypeADT = this.parameterOtype[k];
/*      */       }
/*      */ 
/* 1860 */       Vector localVector2 = this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, arrayOfInputStream, arrayOfByte, arrayOfOracleTypeADT, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, j, paramArrayOfInt, this.plsql, this.oracleStatement.returnParamMeta, this.oracleStatement.nbPostPonedColumns, this.oracleStatement.indexOfPostPonedColumn, bool);
/*      */ 
/* 1870 */       bool = false;
/*      */ 
/* 1872 */       if (localVector2 != null)
/*      */       {
/* 1874 */         if (localVector1 == null)
/* 1875 */           localVector1 = new Vector();
/* 1876 */         localVector1.addAll(localVector2);
/*      */       }
/*      */     }
/* 1879 */     return localVector1;
/*      */   }
/*      */ 
/*      */   long setOptions(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4)
/*      */     throws SQLException
/*      */   {
/* 1888 */     long l = 0L;
/*      */ 
/* 1891 */     if ((paramBoolean1) && (!paramBoolean2) && (!paramBoolean3)) {
/* 1892 */       l |= 1L;
/* 1893 */     } else if ((paramBoolean1) && (paramBoolean2) && (!paramBoolean3)) {
/* 1894 */       l = 32801L; } else {
/* 1895 */       if ((paramBoolean2) && (paramBoolean3))
/*      */       {
/* 1897 */         if (paramBoolean1) {
/* 1898 */           l |= 1L;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1903 */       switch (1.$SwitchMap$oracle$jdbc$internal$OracleStatement$SqlKind[this.typeOfStatement.ordinal()])
/*      */       {
/*      */       case 9:
/*      */       case 10:
/* 1908 */         l |= 32864L;
/*      */ 
/* 1910 */         break;
/*      */       case 7:
/*      */       case 8:
/* 1915 */         if (this.numberOfBindPositions > 0)
/*      */         {
/* 1918 */           l |= 0x420 | (this.oracleStatement.connection.autocommit ? 256 : 0);
/*      */ 
/* 1921 */           if (this.sendBindsDefinition)
/* 1922 */             l |= 8L;
/*      */         }
/*      */         else {
/* 1925 */           l |= 0x20 | (this.oracleStatement.connection.autocommit ? 256 : 0);
/*      */         }
/*      */ 
/* 1929 */         break;
/*      */       case 1:
/*      */       case 2:
/*      */       case 3:
/*      */       case 4:
/*      */       case 5:
/*      */       case 6:
/* 1940 */         if (this.oracleStatement.isDmlReturning) {
/* 1941 */           l |= 0x420 | (this.oracleStatement.connection.autocommit ? 256 : 0);
/*      */         }
/*      */         else {
/* 1944 */           l |= 0x8020 | (this.oracleStatement.connection.autocommit ? 256 : 0);
/*      */         }
/*      */ 
/* 1947 */         break;
/*      */       default:
/* 1952 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 432);
/* 1953 */         localSQLException.fillInStackTrace();
/* 1954 */         throw localSQLException;
/*      */ 
/* 1958 */         if ((!paramBoolean1) && (!paramBoolean2) && (paramBoolean3)) {
/* 1959 */           l = 32832L;
/*      */         }
/*      */         else
/*      */         {
/* 1963 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 432);
/* 1964 */           localSQLException.fillInStackTrace();
/* 1965 */           throw localSQLException;
/*      */         }
/*      */         break;
/*      */       }
/*      */     }
/* 1970 */     if (!this.typeOfStatement.isPlsqlOrCall())
/*      */     {
/* 1974 */       if ((paramBoolean1) || (paramBoolean2) || (!paramBoolean3))
/*      */       {
/* 1981 */         if ((this.numberOfBindPositions > 0) && (this.sendBindsDefinition)) {
/* 1982 */           l |= 8L;
/*      */         }
/*      */       }
/* 1985 */       if ((this.connection.versionNumber >= 9000) && (paramBoolean4))
/*      */       {
/* 1987 */         l |= 16L;
/*      */       }
/*      */     }
/*      */ 
/* 1991 */     l &= -1L;
/*      */ 
/* 1994 */     return l;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2009 */     return this.connection;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4C8Oall
 * JD-Core Version:    0.6.2
 */