/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ final class T4C7Oversion extends T4CTTIfun
/*     */ {
/*  37 */   byte[] rdbmsVersion = { 78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116 };
/*     */ 
/*  44 */   private final boolean rdbmsVersionO2U = true;
/*     */ 
/*  46 */   private final int bufLen = 256;
/*  47 */   private final boolean retVerLenO2U = true;
/*  48 */   int retVerLen = 0;
/*  49 */   private final boolean retVerNumO2U = true;
/*  50 */   long retVerNum = 0L;
/*     */ 
/* 177 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T4C7Oversion(T4CConnection paramT4CConnection)
/*     */   {
/*  59 */     super(paramT4CConnection, (byte)3);
/*     */ 
/*  61 */     setFunCode((short)59);
/*     */   }
/*     */ 
/*     */   void doOVERSION()
/*     */     throws SQLException, IOException
/*     */   {
/*  68 */     doRPC();
/*     */   }
/*     */ 
/*     */   void readRPA()
/*     */     throws IOException, SQLException
/*     */   {
/*  77 */     this.retVerLen = this.meg.unmarshalUB2();
/*  78 */     this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
/*  79 */     this.retVerNum = this.meg.unmarshalUB4();
/*     */   }
/*     */ 
/*     */   void processRPA()
/*     */     throws SQLException
/*     */   {
/*  87 */     if (this.rdbmsVersion == null)
/*     */     {
/*  89 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 438);
/*  90 */       localSQLException.fillInStackTrace();
/*  91 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   byte[] getVersion()
/*     */   {
/* 106 */     return this.rdbmsVersion;
/*     */   }
/*     */ 
/*     */   short getVersionNumber()
/*     */   {
/* 119 */     int i = 0;
/*     */ 
/* 121 */     i = (int)(i + (this.retVerNum >>> 24 & 0xFF) * 1000L);
/* 122 */     i = (int)(i + (this.retVerNum >>> 20 & 0xF) * 100L);
/* 123 */     i = (int)(i + (this.retVerNum >>> 12 & 0xF) * 10L);
/* 124 */     i = (int)(i + (this.retVerNum >>> 8 & 0xF));
/*     */ 
/* 126 */     return (short)i;
/*     */   }
/*     */ 
/*     */   long getVersionNumberasIs()
/*     */   {
/* 139 */     return this.retVerNum;
/*     */   }
/*     */ 
/*     */   void marshal()
/*     */     throws IOException
/*     */   {
/* 153 */     this.meg.marshalO2U(true);
/* 154 */     this.meg.marshalSWORD(256);
/* 155 */     this.meg.marshalO2U(true);
/* 156 */     this.meg.marshalO2U(true);
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 172 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T4C7Oversion
 * JD-Core Version:    0.6.2
 */