/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.nio.ByteBuffer;
/*      */ import java.nio.ByteOrder;
/*      */ import java.nio.CharBuffer;
/*      */ import java.nio.ShortBuffer;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayDeque;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T2CStatement extends OracleStatement
/*      */ {
/*   40 */   T2CConnection t2cConnection = null;
/*   41 */   int userResultSetType = -1;
/*   42 */   int userResultSetConcur = -1;
/*      */ 
/*   48 */   static int T2C_EXTEND_BUFFER = -3;
/*      */ 
/*   64 */   long[] t2cOutput = new long[10];
/*      */   static final int T2C_OUTPUT_USE_NIO = 5;
/*      */   static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
/*      */   static final int T2C_OUTPUT_USE_OCI_DEFAULT_DEFINE_OFFSET = 7;
/*      */   static final boolean T2CDEBUG = false;
/*      */   int extractedCharOffset;
/*      */   int extractedByteOffset;
/*  339 */   int savedRowPrefetch = 0;
/*      */   static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
/*      */   static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
/*      */   static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
/*      */   static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
/*      */   static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
/*      */   byte[] lobPrefetchTempBytes;
/* 1745 */   boolean needToRetainRows = false;
/*      */   byte[] returnParamBytes;
/*      */   char[] returnParamChars;
/*      */   short[] returnParamIndicators;
/*      */   int returnParamRowBytes;
/*      */   int returnParamRowChars;
/* 2284 */   static int PREAMBLE_PER_POSITION = 5;
/*      */ 
/* 2324 */   SQLException updateDataException = null;
/* 2325 */   int lastProcessedCell = 0;
/*      */   static final int PROCESS_DEFINE_DYNAMIC_COLUMNS = 16;
/*      */   static final int PROCESS_DEFINE_DEFAULT_COLUMNS = 32;
/*      */   static final int PROCESS_ADT_OUT_BINDS = 64;
/* 2329 */   int lastProcessedAccessorIndex = 0;
/* 2330 */   int accessorsProcessed = 0;
/* 2331 */   int previousMode = 0;
/*      */ 
/* 2717 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T2CStatement(T2CConnection paramT2CConnection, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  104 */     this(paramT2CConnection, paramInt1, paramInt2, -1, -1);
/*      */ 
/*  111 */     this.t2cConnection = paramT2CConnection;
/*  112 */     if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/*  114 */       this.savedRowPrefetch = this.rowPrefetch;
/*  115 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   T2CStatement(T2CConnection paramT2CConnection, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*      */     throws SQLException
/*      */   {
/*  126 */     super(paramT2CConnection, paramInt1, paramInt2, paramInt3, paramInt4);
/*      */ 
/*  132 */     this.userResultSetType = paramInt3;
/*  133 */     this.userResultSetConcur = paramInt4;
/*      */ 
/*  135 */     this.t2cConnection = paramT2CConnection;
/*  136 */     if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/*  138 */       this.savedRowPrefetch = this.rowPrefetch;
/*  139 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   static native int t2cParseExecuteDescribe(OracleStatement paramOracleStatement, long paramLong, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, byte[] paramArrayOfByte1, int paramInt4, byte paramByte, int paramInt5, int paramInt6, short[] paramArrayOfShort1, int paramInt7, byte[] paramArrayOfByte2, char[] paramArrayOfChar1, int paramInt8, int paramInt9, short[] paramArrayOfShort2, int paramInt10, int paramInt11, byte[] paramArrayOfByte3, char[] paramArrayOfChar2, int paramInt12, int paramInt13, int[] paramArrayOfInt, short[] paramArrayOfShort3, byte[] paramArrayOfByte4, int paramInt14, int paramInt15, int paramInt16, int paramInt17, boolean paramBoolean5, boolean paramBoolean6, Accessor[] paramArrayOfAccessor, byte[][][] paramArrayOfByte, long[] paramArrayOfLong, boolean paramBoolean7)
/*      */     throws IOException;
/*      */ 
/*      */   static native int t2cDefineExecuteFetch(OracleStatement paramOracleStatement, long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, boolean paramBoolean1, boolean paramBoolean2, byte[] paramArrayOfByte1, int paramInt5, byte paramByte, int paramInt6, int paramInt7, short[] paramArrayOfShort1, int paramInt8, byte[] paramArrayOfByte2, char[] paramArrayOfChar, int paramInt9, int paramInt10, short[] paramArrayOfShort2, byte[] paramArrayOfByte3, int paramInt11, int paramInt12, boolean paramBoolean3, boolean paramBoolean4, Accessor[] paramArrayOfAccessor, byte[][][] paramArrayOfByte, long[] paramArrayOfLong, ByteBuffer[] paramArrayOfByteBuffer, Object[] paramArrayOfObject)
/*      */     throws IOException;
/*      */ 
/*      */   static native int t2cDescribe(long paramLong, short[] paramArrayOfShort, byte[] paramArrayOfByte1, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte2, int paramInt5, boolean paramBoolean);
/*      */ 
/*      */   static native int t2cDefineFetch(OracleStatement paramOracleStatement, long paramLong, int paramInt1, short[] paramArrayOfShort, byte[] paramArrayOfByte, int paramInt2, int paramInt3, Accessor[] paramArrayOfAccessor, long[] paramArrayOfLong, ByteBuffer[] paramArrayOfByteBuffer, Object[] paramArrayOfObject);
/*      */ 
/*      */   static native int t2cGetImplicitResultSetCount(OracleStatement paramOracleStatement, long paramLong);
/*      */ 
/*      */   static native int t2cFetch(OracleStatement paramOracleStatement, long paramLong, boolean paramBoolean, int paramInt, Accessor[] paramArrayOfAccessor, long[] paramArrayOfLong, ByteBuffer[] paramArrayOfByteBuffer, Object[] paramArrayOfObject);
/*      */ 
/*      */   static native int t2cCloseStatement(long paramLong);
/*      */ 
/*      */   static native int t2cEndToEndUpdate(long paramLong, byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3, byte[] paramArrayOfByte4, int paramInt4, byte[] paramArrayOfByte5, int paramInt5, int paramInt6);
/*      */ 
/*      */   static native int t2cGetRowsDmlReturned(long paramLong);
/*      */ 
/*      */   static native int t2cFetchDmlReturnParams(long paramLong, OracleStatement paramOracleStatement, Accessor[] paramArrayOfAccessor, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort);
/*      */ 
/*      */   int getPrefetchInternal(boolean paramBoolean)
/*      */   {
/*  347 */     if (!this.t2cConnection.useOCIDefaultDefines) {
/*  348 */       return super.getPrefetchInternal(paramBoolean);
/*      */     }
/*  350 */     int i = paramBoolean ? this.defaultRowPrefetch : this.savedRowPrefetch;
/*      */ 
/*  352 */     return i;
/*      */   }
/*      */ 
/*      */   void setPrefetchInternal(int paramInt, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  363 */     int i = this.rowPrefetch;
/*  364 */     super.setPrefetchInternal(paramInt, paramBoolean1, paramBoolean2);
/*      */ 
/*  367 */     if ((this.t2cConnection.useOCIDefaultDefines) && (i != this.rowPrefetch))
/*      */     {
/*  369 */       this.savedRowPrefetch = this.rowPrefetch;
/*  370 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareForNewResults(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
/*      */     throws SQLException
/*      */   {
/*  385 */     super.prepareForNewResults(paramBoolean1, paramBoolean2, paramBoolean3);
/*      */ 
/*  390 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.rowPrefetchChanged))
/*      */     {
/*  392 */       this.savedRowPrefetch = this.rowPrefetch;
/*  393 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareAccessors()
/*      */     throws SQLException
/*      */   {
/*  404 */     super.prepareAccessors();
/*  405 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.hasStream))
/*  406 */       this.savedRowPrefetch = 1;
/*      */   }
/*      */ 
/*      */   String bytes2String(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  419 */     byte[] arrayOfByte = new byte[paramInt2];
/*      */ 
/*  421 */     System.arraycopy(paramArrayOfByte, paramInt1, arrayOfByte, 0, paramInt2);
/*      */ 
/*  423 */     return this.connection.conversion.CharBytesToString(arrayOfByte, paramInt2);
/*      */   }
/*      */ 
/*      */   void processDescribeData()
/*      */     throws SQLException
/*      */   {
/*  439 */     this.described = true;
/*  440 */     this.describedWithNames = true;
/*      */ 
/*  451 */     if (this.numberOfDefinePositions < 1) return;
/*  452 */     if ((this.accessors == null) || (this.numberOfDefinePositions > this.accessors.length)) {
/*  453 */       this.accessors = new Accessor[this.numberOfDefinePositions];
/*      */     }
/*      */ 
/*  469 */     int i = this.t2cConnection.queryMetaData1Offset;
/*  470 */     int j = this.t2cConnection.queryMetaData2Offset;
/*  471 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/*  472 */     byte[] arrayOfByte = this.t2cConnection.queryMetaData2;
/*      */ 
/*  474 */     for (int k = 0; k < this.numberOfDefinePositions; 
/*  475 */       i += 14)
/*      */     {
/*  477 */       int m = arrayOfShort[(i + 0)];
/*  478 */       int n = arrayOfShort[(i + 1)];
/*  479 */       int i1 = arrayOfShort[(i + 11)];
/*  480 */       boolean bool1 = arrayOfShort[(i + 2)] != 0;
/*  481 */       int i2 = arrayOfShort[(i + 3)];
/*  482 */       int i3 = arrayOfShort[(i + 4)];
/*  483 */       int i4 = 0;
/*  484 */       int i5 = 0;
/*  485 */       int i6 = 0;
/*  486 */       short s = arrayOfShort[(i + 5)];
/*  487 */       int i7 = arrayOfShort[(i + 6)];
/*  488 */       String str1 = bytes2String(arrayOfByte, j, i7);
/*  489 */       int i8 = arrayOfShort[(i + 12)];
/*  490 */       boolean bool2 = arrayOfShort[(i + 13)] != 0;
/*      */ 
/*  492 */       String str2 = null;
/*  493 */       OracleTypeADT localOracleTypeADT = null;
/*      */ 
/*  495 */       j += i7;
/*      */ 
/*  497 */       if (i8 > 0)
/*      */       {
/*  499 */         str2 = bytes2String(arrayOfByte, j, i8);
/*  500 */         j += i8;
/*  501 */         localOracleTypeADT = new OracleTypeADT(str2, this.connection);
/*  502 */         localOracleTypeADT.tdoCState = ((arrayOfShort[(i + 7)] & 0xFFFF) << 48 | (arrayOfShort[(i + 8)] & 0xFFFF) << 32 | (arrayOfShort[(i + 9)] & 0xFFFF) << 16 | arrayOfShort[(i + 10)] & 0xFFFF);
/*      */       }
/*      */ 
/*  509 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/*  516 */       if ((localAccessor == null) || (localAccessor.defineType == 0) || ((localAccessor.describeType != 0) && (localAccessor.describeType != m)))
/*      */       {
/*  520 */         localAccessor = allocateAccessorForDefines(k, m, n, bool1, i4, i2, i3, i5, i6, s, i1, localOracleTypeADT, str2);
/*      */ 
/*  523 */         if (this.accessors[k] != null)
/*      */         {
/*  525 */           localAccessor.rowLength = this.accessors[k].rowLength;
/*  526 */           localAccessor.rowOffset = this.accessors[k].rowOffset;
/*  527 */           localAccessor.rowNull = this.accessors[k].rowNull;
/*  528 */           localAccessor.rowMetadata = this.accessors[k].rowMetadata;
/*      */         }
/*      */       }
/*      */       else {
/*  532 */         localAccessor.initForDescribe(m, n, bool1, i4, i2, i3, i5, i6, s, str2);
/*      */       }
/*      */ 
/*  538 */       localAccessor.describeOtype = localOracleTypeADT;
/*  539 */       localAccessor.columnName = str1;
/*  540 */       localAccessor.columnInvisible = bool2;
/*      */ 
/*  542 */       this.accessors[k] = localAccessor;
/*      */ 
/*  475 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessorForDefines(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort, int paramInt9, OracleTypeADT paramOracleTypeADT, String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*  556 */     switch (paramInt2)
/*      */     {
/*      */     case 1:
/*  560 */       localObject = new VarcharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  564 */       if (paramInt9 > 0)
/*  565 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 96:
/*  570 */       localObject = new CharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  574 */       if (paramInt9 > 0)
/*  575 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 2:
/*  580 */       localObject = new NumberAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  584 */       break;
/*      */     case 23:
/*  587 */       localObject = new RawAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  591 */       break;
/*      */     case 100:
/*  594 */       localObject = new BinaryFloatAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  598 */       break;
/*      */     case 101:
/*  601 */       localObject = new BinaryDoubleAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  605 */       break;
/*      */     case 8:
/*  608 */       localObject = new T2CLongAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  615 */       this.rowPrefetch = 1;
/*  616 */       this.savedRowPrefetch = 1;
/*      */ 
/*  618 */       break;
/*      */     case 24:
/*  621 */       localObject = new T2CLongRawAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  628 */       this.rowPrefetch = 1;
/*  629 */       this.savedRowPrefetch = 1;
/*      */ 
/*  631 */       break;
/*      */     case 104:
/*  634 */       localObject = new RowidAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, (short)1);
/*      */ 
/*  638 */       break;
/*      */     case 102:
/*      */     case 116:
/*  643 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  645 */         localObject = new T2CResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */       else
/*      */       {
/*  650 */         localObject = new ResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */ 
/*  655 */       break;
/*      */     case 12:
/*  658 */       localObject = new DateAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  662 */       break;
/*      */     case 180:
/*  665 */       localObject = new TimestampAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  669 */       break;
/*      */     case 181:
/*  672 */       localObject = new TimestamptzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  676 */       break;
/*      */     case 231:
/*  679 */       localObject = new TimestampltzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  683 */       break;
/*      */     case 182:
/*  686 */       localObject = new IntervalymAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  690 */       break;
/*      */     case 183:
/*  693 */       localObject = new IntervaldsAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  697 */       break;
/*      */     case 112:
/*  700 */       localObject = new ClobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  704 */       break;
/*      */     case 113:
/*  707 */       localObject = new BlobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  711 */       break;
/*      */     case 114:
/*  714 */       localObject = new BfileAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  718 */       break;
/*      */     case 109:
/*  721 */       localObject = new NamedTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  726 */       break;
/*      */     case 111:
/*  729 */       localObject = new RefTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  734 */       break;
/*      */     default:
/*  738 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + paramInt2);
/*      */ 
/*  740 */       localSQLException.fillInStackTrace();
/*  741 */       throw localSQLException;
/*      */     }
/*      */ 
/*  744 */     return localObject;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  784 */     this.t2cOutput[0] = 0L;
/*  785 */     this.t2cOutput[2] = 0L;
/*  786 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/*      */ 
/*  790 */     this.lobPrefetchMetaData = null;
/*      */ 
/*  792 */     boolean bool1 = !this.described;
/*  793 */     boolean bool2 = false;
/*      */ 
/*  795 */     int j = this.t2cConnection.useOCIDefaultDefines ? this.savedRowPrefetch : this.rowPrefetch;
/*  796 */     assert (j > 0) : ("rowsToFetch < 1 (rowsToFetch=" + j + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/*  797 */     this.validRows = 0;
/*      */     int i;
/*      */     do
/*      */     {
/*  800 */       i = 0;
/*      */ 
/*  803 */       if (this.connection.endToEndAnyChanged)
/*      */       {
/*  805 */         pushEndToEndValues();
/*      */ 
/*  807 */         this.connection.endToEndAnyChanged = false;
/*      */       }
/*      */ 
/*  811 */       byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/*      */ 
/*  813 */       int k = 0;
/*      */       try
/*      */       {
/*  816 */         resetStateBeforeFetch();
/*  817 */         k = t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, 0, 0, false, this.needToParse, bool1, bool2, arrayOfByte, arrayOfByte.length, convertSqlKindEnumToByte(this.sqlKind), j, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, true, true, this.accessors, (byte[][][])null, this.t2cOutput, this.t2cConnection.plsqlCompilerWarnings);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/*  861 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 266);
/*  862 */         localSQLException.fillInStackTrace();
/*  863 */         throw localSQLException;
/*      */       }
/*      */ 
/*  871 */       this.validRows = ((int)this.t2cOutput[1]);
/*      */ 
/*  874 */       if ((k == -1) || (k == -4))
/*      */       {
/*  876 */         this.t2cConnection.checkError(k);
/*      */       }
/*  878 */       else if (k == T2C_EXTEND_BUFFER)
/*      */       {
/*  880 */         k = this.t2cConnection.queryMetaData1Size * 2;
/*      */       }
/*      */ 
/*  885 */       if (this.t2cOutput[3] != 0L)
/*      */       {
/*  887 */         foundPlsqlCompilerWarning();
/*      */       }
/*  889 */       else if (this.t2cOutput[2] != 0L)
/*      */       {
/*  891 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/*  896 */       this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/*  899 */       this.needToParse = false;
/*  900 */       bool2 = true;
/*      */ 
/*  902 */       if (this.sqlKind.isSELECT())
/*      */       {
/*  904 */         this.numberOfDefinePositions = k;
/*      */ 
/*  906 */         if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */         {
/*  908 */           i = 1;
/*  909 */           bool2 = true;
/*      */ 
/*  912 */           this.t2cConnection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  919 */         this.numberOfDefinePositions = 0;
/*  920 */         this.validRows = k;
/*      */       }
/*  922 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  924 */         checkForImplicitResultSets();
/*      */       }
/*      */     }
/*  927 */     while (i != 0);
/*      */ 
/*  930 */     this.isComplete = false;
/*      */ 
/*  932 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   void checkForImplicitResultSets()
/*      */     throws SQLException
/*      */   {
/*  940 */     int i = 0;
/*      */ 
/*  943 */     i = t2cGetImplicitResultSetCount(this, this.c_state);
/*  944 */     if (i > 0)
/*      */     {
/*  946 */       int j = i;
/*  947 */       this.implicitResultSetStatements = new ArrayDeque(j);
/*  948 */       while (j != 0)
/*      */       {
/*  952 */         OracleStatement localOracleStatement = this.connection.createImplicitResultSetStatement(this);
/*  953 */         ((T2CStatement)localOracleStatement).doDescribe(true);
/*  954 */         ((T2CStatement)localOracleStatement).prepareAccessors();
/*  955 */         j--;
/*      */       }
/*  957 */       this.implicitResultSetIterator = this.implicitResultSetStatements.iterator();
/*      */     }
/*  959 */     else if (i != 0) {
/*  960 */       this.t2cConnection.checkError(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   void pushEndToEndValues()
/*      */     throws SQLException
/*      */   {
/*  967 */     T2CConnection localT2CConnection = this.t2cConnection;
/*  968 */     byte[] arrayOfByte1 = null;
/*  969 */     byte[] arrayOfByte2 = null;
/*  970 */     byte[] arrayOfByte3 = null;
/*  971 */     byte[] arrayOfByte4 = null;
/*  972 */     byte[] arrayOfByte5 = null;
/*      */ 
/*  974 */     if (localT2CConnection.endToEndValues != null)
/*      */     {
/*      */       String str;
/*  976 */       if (localT2CConnection.endToEndHasChanged[0] != 0)
/*      */       {
/*  978 */         str = localT2CConnection.endToEndValues[0];
/*      */ 
/*  980 */         if (str != null) {
/*  981 */           arrayOfByte1 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  985 */           arrayOfByte1 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  988 */         localT2CConnection.endToEndHasChanged[0] = false;
/*      */       }
/*      */ 
/*  991 */       if (localT2CConnection.endToEndHasChanged[1] != 0)
/*      */       {
/*  993 */         str = localT2CConnection.endToEndValues[1];
/*      */ 
/*  995 */         if (str != null) {
/*  996 */           arrayOfByte2 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/* 1000 */           arrayOfByte2 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/* 1003 */         localT2CConnection.endToEndHasChanged[1] = false;
/*      */       }
/*      */ 
/* 1006 */       if (localT2CConnection.endToEndHasChanged[2] != 0)
/*      */       {
/* 1008 */         str = localT2CConnection.endToEndValues[2];
/*      */ 
/* 1010 */         if (str != null) {
/* 1011 */           arrayOfByte3 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/* 1015 */           arrayOfByte3 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/* 1018 */         localT2CConnection.endToEndHasChanged[2] = false;
/*      */       }
/*      */ 
/* 1021 */       if (localT2CConnection.endToEndHasChanged[3] != 0)
/*      */       {
/* 1023 */         str = localT2CConnection.endToEndValues[3];
/*      */ 
/* 1025 */         if (str != null) {
/* 1026 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/* 1030 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/* 1033 */         localT2CConnection.endToEndHasChanged[3] = false;
/*      */       }
/*      */ 
/* 1036 */       if (localT2CConnection.endToEndHasChanged[4] != 0)
/*      */       {
/* 1038 */         str = localT2CConnection.endToEndValues[4];
/*      */ 
/* 1040 */         if (str != null) {
/* 1041 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/* 1045 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/* 1048 */         localT2CConnection.endToEndHasChanged[4] = false;
/*      */       }
/*      */ 
/* 1054 */       t2cEndToEndUpdate(this.c_state, arrayOfByte1, arrayOfByte1 == null ? -1 : arrayOfByte1.length, arrayOfByte2, arrayOfByte2 == null ? -1 : arrayOfByte2.length, arrayOfByte3, arrayOfByte3 == null ? -1 : arrayOfByte3.length, arrayOfByte4, arrayOfByte4 == null ? -1 : arrayOfByte4.length, arrayOfByte5, arrayOfByte5 == null ? -1 : arrayOfByte5.length, localT2CConnection.endToEndECIDSequenceNumber);
/*      */     }
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1110 */     if (this.connection.endToEndAnyChanged)
/*      */     {
/* 1112 */       pushEndToEndValues();
/*      */ 
/* 1114 */       this.connection.endToEndAnyChanged = false;
/*      */     }
/*      */ 
/* 1118 */     if (!paramBoolean)
/*      */     {
/* 1126 */       if (this.numberOfDefinePositions > 0)
/*      */       {
/* 1128 */         doDefineExecuteFetch();
/*      */       }
/*      */       else
/*      */       {
/* 1132 */         executeForDescribe();
/*      */       }
/*      */     }
/* 1135 */     else if (this.numberOfDefinePositions > 0) {
/* 1136 */       doDefineFetch();
/*      */     }
/*      */ 
/* 1139 */     if (this.returnParamMeta != null) {
/* 1140 */       fetchDmlReturnParams();
/*      */     }
/*      */ 
/* 1145 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void setupForDefine()
/*      */     throws SQLException
/*      */   {
/* 1155 */     if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */     {
/* 1157 */       int i = this.numberOfDefinePositions / 100 + 1;
/*      */ 
/* 1159 */       this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * i, this.t2cConnection.queryMetaData2Size * i * 8);
/*      */     }
/*      */ 
/* 1164 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/* 1165 */     int j = this.t2cConnection.queryMetaData1Offset;
/*      */ 
/* 1168 */     for (int k = 0; k < this.numberOfDefinePositions; 
/* 1169 */       j += 14)
/*      */     {
/* 1171 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/* 1173 */       if (localAccessor == null)
/*      */       {
/* 1175 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/* 1176 */         localSQLException.fillInStackTrace();
/* 1177 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1180 */       arrayOfShort[(j + 0)] = ((short)localAccessor.defineType);
/*      */ 
/* 1183 */       if ((!this.described) && (localAccessor.charLength > 0) && (localAccessor.formOfUse == 1))
/*      */       {
/* 1190 */         int m = localAccessor.charLength;
/* 1191 */         int n = m + 1;
/* 1192 */         arrayOfShort[(j + 11)] = 0;
/* 1193 */         arrayOfShort[(j + 1)] = ((short)n);
/*      */       }
/*      */       else {
/* 1196 */         arrayOfShort[(j + 11)] = ((short)localAccessor.charLength);
/*      */ 
/* 1198 */         arrayOfShort[(j + 1)] = ((short)localAccessor.byteLength);
/*      */       }
/*      */ 
/* 1201 */       arrayOfShort[(j + 5)] = localAccessor.formOfUse;
/*      */ 
/* 1204 */       if (localAccessor.internalOtype != null)
/*      */       {
/* 1206 */         long l = ((OracleTypeADT)localAccessor.internalOtype).getTdoCState();
/*      */ 
/* 1209 */         arrayOfShort[(j + 7)] = ((short)(int)((l & 0x0) >> 48));
/*      */ 
/* 1211 */         arrayOfShort[(j + 8)] = ((short)(int)((l & 0x0) >> 32));
/*      */ 
/* 1213 */         arrayOfShort[(j + 9)] = ((short)(int)((l & 0xFFFF0000) >> 16));
/*      */ 
/* 1215 */         arrayOfShort[(j + 10)] = ((short)(int)(l & 0xFFFF));
/*      */       }
/*      */ 
/* 1219 */       switch (localAccessor.internalType)
/*      */       {
/*      */       case 112:
/*      */       case 113:
/* 1225 */         if (localAccessor.lobPrefetchSizeForThisColumn == -1) {
/* 1226 */           localAccessor.lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
/*      */         }
/*      */ 
/* 1229 */         arrayOfShort[(j + 7)] = ((short)localAccessor.lobPrefetchSizeForThisColumn);
/*      */       }
/* 1169 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void configureBindData()
/*      */     throws SQLException
/*      */   {
/* 1243 */     if (this.outBindAccessors == null) {
/* 1244 */       return;
/*      */     }
/*      */ 
/* 1247 */     this.bindData = null;
/*      */   }
/*      */ 
/*      */   void initializePlsqlIndexByTableAccessor(Accessor paramAccessor, int paramInt)
/*      */   {
/* 1254 */     ((T2CPlsqlIndexTableAccessor)paramAccessor).ibtMetaIndex = (paramInt - 8);
/*      */   }
/*      */ 
/*      */   Object[] getLobPrefetchMetaData()
/*      */   {
/* 1269 */     Object[] arrayOfObject = null;
/* 1270 */     Object localObject = null;
/* 1271 */     int[] arrayOfInt = null;
/* 1272 */     int i = 0;
/* 1273 */     int j = 0;
/*      */     int k;
/* 1275 */     if (this.accessors != null) {
/* 1276 */       for (k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1278 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1285 */           j = k;
/* 1286 */           break;
/*      */         case 112:
/*      */         case 113:
/* 1292 */           if (arrayOfInt == null)
/*      */           {
/* 1294 */             arrayOfInt = new int[this.accessors.length];
/*      */           }
/*      */ 
/* 1297 */           if (this.accessors[k].lobPrefetchSizeForThisColumn != -1)
/*      */           {
/* 1299 */             i++;
/*      */ 
/* 1301 */             arrayOfInt[k] = this.accessors[k].lobPrefetchSizeForThisColumn;
/*      */           }
/*      */           else
/*      */           {
/* 1305 */             arrayOfInt[k] = -1;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1313 */     if (i > 0)
/*      */     {
/* 1315 */       if (arrayOfObject == null)
/*      */       {
/* 1317 */         arrayOfObject = new Object[] { null, new long[this.rowPrefetch * i], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * i] };
/*      */       }
/*      */ 
/* 1339 */       for (k = 0; k < j; k++)
/*      */       {
/* 1341 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1345 */           this.accessors[k].lobPrefetchSizeForThisColumn = -1;
/* 1346 */           arrayOfInt[k] = -1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1351 */       arrayOfObject[0] = arrayOfInt;
/*      */     }
/*      */ 
/* 1355 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   void processLobPrefetchMetaData(Object[] paramArrayOfObject)
/*      */   {
/* 1363 */     int i = 0;
/* 1364 */     int j = this.validRows == -2 ? 1 : this.validRows;
/*      */ 
/* 1366 */     byte[] arrayOfByte1 = (byte[])paramArrayOfObject[2];
/* 1367 */     int[] arrayOfInt1 = (int[])paramArrayOfObject[3];
/* 1368 */     long[] arrayOfLong = (long[])paramArrayOfObject[1];
/* 1369 */     Object[] arrayOfObject = (Object[])paramArrayOfObject[4];
/* 1370 */     int[] arrayOfInt2 = (int[])paramArrayOfObject[0];
/*      */ 
/* 1372 */     if (this.accessors != null)
/* 1373 */       for (int k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1375 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1380 */           if (this.accessors[k].lobPrefetchSizeForThisColumn >= 0)
/*      */           {
/* 1382 */             LobCommonAccessor localLobCommonAccessor = (LobCommonAccessor)this.accessors[k];
/*      */ 
/* 1384 */             if ((localLobCommonAccessor.prefetchedDataLength == null) || (localLobCommonAccessor.prefetchedDataLength.length < this.rowPrefetch))
/*      */             {
/* 1388 */               if (localLobCommonAccessor.internalType == 112) {
/* 1389 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse = new int[this.rowPrefetch];
/*      */               }
/* 1391 */               localLobCommonAccessor.prefetchedChunkSize = new int[this.rowPrefetch];
/* 1392 */               localLobCommonAccessor.prefetchedDataLength = new int[this.rowPrefetch];
/* 1393 */               localLobCommonAccessor.prefetchedLength = new long[this.rowPrefetch];
/* 1394 */               localLobCommonAccessor.prefetchedDataOffset = new long[this.rowPrefetch];
/*      */             }
/*      */ 
/* 1397 */             int m = j * i;
/* 1398 */             int n = this.needToRetainRows ? this.storedRowCount : 0;
/* 1399 */             for (int i1 = 0; i1 < j; i1++)
/*      */             {
/* 1401 */               localLobCommonAccessor.prefetchedChunkSize[(n + i1)] = arrayOfInt1[k];
/* 1402 */               localLobCommonAccessor.prefetchedLength[(n + i1)] = arrayOfLong[(m + i1)];
/*      */ 
/* 1404 */               if (localLobCommonAccessor.internalType == 112)
/*      */               {
/* 1406 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse[(n + i1)] = arrayOfByte1[k];
/*      */               }
/*      */ 
/* 1409 */               localLobCommonAccessor.prefetchedDataLength[i1] = 0;
/* 1410 */               if ((arrayOfInt2[k] > 0) && (arrayOfLong[(m + i1)] > 0L))
/*      */               {
/* 1413 */                 byte[] arrayOfByte2 = (byte[])arrayOfObject[(m + i1)];
/* 1414 */                 int i2 = arrayOfByte2 == null ? 0 : arrayOfByte2.length;
/* 1415 */                 if (i2 > 0)
/*      */                 {
/* 1417 */                   localLobCommonAccessor.setPrefetchedDataOffset(n + i1);
/* 1418 */                   localLobCommonAccessor.rowData.put(arrayOfByte2, 0, i2);
/*      */                 }
/* 1420 */                 localLobCommonAccessor.prefetchedDataLength[(n + i1)] = i2;
/*      */               }
/*      */             }
/* 1423 */             i++;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */   }
/*      */ 
/*      */   int getRowsToFetch()
/*      */   {
/* 1435 */     int i = -1;
/* 1436 */     if (this.hasStream)
/*      */     {
/* 1438 */       i = 1;
/* 1439 */       if (this.t2cConnection.useOCIDefaultDefines) {
/* 1440 */         this.savedRowPrefetch = 1;
/*      */       }
/*      */       else {
/* 1443 */         this.rowPrefetch = 1;
/*      */       }
/*      */     }
/* 1446 */     else if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/* 1450 */       if ((this.maxRows > 0) && (this.maxRows == this.storedRowCount))
/*      */       {
/* 1453 */         i = 0;
/*      */       }
/*      */       else {
/* 1456 */         i = this.rowPrefetch;
/*      */       }
/*      */ 
/*      */     }
/* 1460 */     else if ((this.maxRows > 0) && (this.maxRows < this.rowPrefetch + this.storedRowCount)) {
/* 1461 */       if ((this.storedRowCount < 1) && (this.maxRows < this.rowPrefetch)) {
/* 1462 */         i = this.maxRows;
/*      */       }
/*      */       else {
/* 1465 */         i = Math.min(this.rowPrefetch, this.maxRows - (this.rowPrefetch + this.storedRowCount));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1470 */       i = this.rowPrefetch;
/*      */     }
/*      */ 
/* 1473 */     return i;
/*      */   }
/*      */ 
/*      */   void doDefineFetch()
/*      */     throws SQLException
/*      */   {
/* 1480 */     int i = getRowsToFetch();
/*      */ 
/* 1483 */     this.validRows = 0;
/*      */ 
/* 1485 */     if (!this.needToPrepareDefineBuffer) {
/* 1486 */       throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
/*      */     }
/*      */ 
/* 1489 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1490 */     if (i > 0) {
/* 1491 */       setupForDefine();
/*      */ 
/* 1493 */       this.t2cOutput[2] = 0L;
/* 1494 */       this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1495 */       this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1496 */       if (this.connection.useNio) {
/* 1497 */         resetNioAttributesBeforeFetch();
/* 1498 */         allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */       }
/*      */ 
/* 1504 */       if (this.lobPrefetchMetaData == null) {
/* 1505 */         this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */       }
/* 1507 */       resetStateBeforeFetch();
/* 1508 */       this.validRows = t2cDefineFetch(this, this.c_state, i, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1521 */       if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1522 */         this.t2cConnection.checkError(this.validRows);
/*      */       }
/*      */ 
/* 1526 */       if (this.t2cOutput[2] != 0L) {
/* 1527 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 1531 */       if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */       {
/* 1533 */         extractNioDefineBuffers(0);
/*      */       }
/* 1535 */       if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1536 */         copyStreamDataIntoDBA(0);
/*      */       }
/* 1538 */       if (this.lobPrefetchMetaData != null) {
/* 1539 */         processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */       }
/*      */     }
/* 1542 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */   }
/*      */ 
/*      */   void copyStreamDataIntoDBA(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1548 */     assert ((this.isFetchStreams) && (this.validRows == -2)) : ("isFetchStreams: " + this.isFetchStreams + "isScrollable(): " + this.realRsetType.isScrollable() + ", isUpdatable(): " + this.realRsetType.isUpdatable() + ", validRows=" + this.validRows);
/* 1549 */     checkValidRowsStatus();
/*      */ 
/* 1554 */     if (this.accessors != null)
/* 1555 */       for (Accessor localAccessor : this.accessors)
/* 1556 */         if (localAccessor != null)
/* 1557 */           switch (localAccessor.internalType) {
/*      */           case 8:
/* 1559 */             ((T2CLongAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/* 1560 */             break;
/*      */           case 24:
/* 1563 */             ((T2CLongRawAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/*      */           }
/*      */   }
/*      */ 
/*      */   void allocateNioBuffersIfRequired(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1574 */     if (this.nioBuffers == null) {
/* 1575 */       this.nioBuffers = new ByteBuffer[4];
/*      */     }
/* 1577 */     if (paramInt2 > 0)
/*      */     {
/* 1579 */       if ((this.nioBuffers[0] == null) || (this.nioBuffers[0].capacity() < paramInt2))
/*      */       {
/* 1582 */         this.nioBuffers[0] = ByteBuffer.allocateDirect(paramInt2);
/* 1583 */       } else if (this.nioBuffers[0] != null)
/*      */       {
/* 1585 */         this.nioBuffers[0].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1592 */     paramInt1 *= 2;
/* 1593 */     if (paramInt1 > 0)
/*      */     {
/* 1595 */       if ((this.nioBuffers[1] == null) || (this.nioBuffers[1].capacity() < paramInt1))
/*      */       {
/* 1598 */         this.nioBuffers[1] = ByteBuffer.allocateDirect(paramInt1);
/* 1599 */       } else if (this.nioBuffers[1] != null)
/*      */       {
/* 1601 */         this.nioBuffers[1].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1608 */     paramInt3 *= 2;
/* 1609 */     if (paramInt3 > 0)
/*      */     {
/* 1611 */       if ((this.nioBuffers[2] == null) || (this.nioBuffers[2].capacity() < paramInt3))
/*      */       {
/* 1614 */         this.nioBuffers[2] = ByteBuffer.allocateDirect(paramInt3);
/* 1615 */       } else if (this.nioBuffers[2] != null)
/*      */       {
/* 1617 */         this.nioBuffers[2].rewind();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doDefineExecuteFetch()
/*      */     throws SQLException
/*      */   {
/* 1626 */     short[] arrayOfShort = null;
/*      */ 
/* 1628 */     if ((this.needToPrepareDefineBuffer) || (this.needToParse))
/*      */     {
/* 1630 */       setupForDefine();
/*      */ 
/* 1632 */       arrayOfShort = this.t2cConnection.queryMetaData1;
/*      */     }
/*      */ 
/* 1635 */     this.t2cOutput[0] = 0L;
/* 1636 */     this.t2cOutput[2] = 0L;
/*      */ 
/* 1638 */     byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/* 1639 */     this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1640 */     this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1641 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/* 1642 */     if (this.connection.useNio) {
/* 1643 */       resetNioAttributesBeforeFetch();
/* 1644 */       allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */     }
/*      */ 
/* 1650 */     if (this.lobPrefetchMetaData == null) {
/* 1651 */       this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */     }
/* 1653 */     int i = getRowsToFetch();
/* 1654 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1655 */     this.validRows = 0;
/*      */     try {
/* 1657 */       resetStateBeforeFetch();
/* 1658 */       this.validRows = t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, 0, 0, false, this.needToParse, arrayOfByte, arrayOfByte.length, convertSqlKindEnumToByte(this.sqlKind), i, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, arrayOfShort, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, true, true, this.accessors, (byte[][][])null, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1694 */       this.validRows = 0;
/*      */ 
/* 1696 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1697 */       localSQLException.fillInStackTrace();
/* 1698 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1702 */     if (this.validRows == -1) {
/* 1703 */       this.t2cConnection.checkError(this.validRows);
/*      */     }
/* 1705 */     if (this.t2cOutput[2] != 0L) {
/* 1706 */       this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */     }
/*      */ 
/* 1711 */     this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/* 1713 */     if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */     {
/* 1715 */       extractNioDefineBuffers(0);
/*      */     }
/* 1717 */     if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1718 */       copyStreamDataIntoDBA(0);
/*      */     }
/*      */ 
/* 1721 */     if (this.lobPrefetchMetaData != null)
/*      */     {
/* 1723 */       processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */     }
/*      */ 
/* 1726 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */ 
/* 1728 */     this.needToParse = false;
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1749 */     this.needToRetainRows = paramBoolean;
/* 1750 */     int i = getRowsToFetch();
/* 1751 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1752 */     this.validRows = 0;
/* 1753 */     if ((i > 0) && 
/* 1754 */       (this.numberOfDefinePositions > 0)) {
/* 1755 */       if (this.needToPrepareDefineBuffer) {
/* 1756 */         doDefineFetch();
/* 1757 */         this.needToPrepareDefineBuffer = false;
/*      */       }
/*      */       else {
/* 1760 */         this.t2cOutput[2] = 0L;
/* 1761 */         this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1762 */         this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1763 */         if (this.connection.useNio) {
/* 1764 */           resetNioAttributesBeforeFetch();
/* 1765 */           allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */         }
/*      */ 
/* 1772 */         if (this.lobPrefetchMetaData == null) {
/* 1773 */           this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */         }
/* 1775 */         resetStateBeforeFetch();
/* 1776 */         this.validRows = t2cFetch(this, this.c_state, this.needToPrepareDefineBuffer, i, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1786 */         if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1787 */           this.t2cConnection.checkError(this.validRows);
/*      */         }
/* 1789 */         if (this.t2cOutput[2] != 0L)
/*      */         {
/* 1791 */           this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */         }
/*      */ 
/* 1794 */         if (this.lobPrefetchMetaData != null)
/*      */         {
/* 1796 */           processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */         }
/* 1798 */         if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */         {
/* 1800 */           extractNioDefineBuffers(0);
/*      */         }
/* 1802 */         if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1803 */           copyStreamDataIntoDBA(paramInt);
/*      */         }
/*      */       }
/*      */     }
/* 1807 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/* 1808 */     this.needToRetainRows = false;
/*      */   }
/*      */ 
/*      */   void resetNioAttributesBeforeFetch()
/*      */   {
/* 1815 */     this.extractedCharOffset = 0;
/* 1816 */     this.extractedByteOffset = 0;
/*      */   }
/*      */ 
/*      */   void extractNioDefineBuffers(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1825 */     if ((this.accessors == null) || (this.defineIndicators == null) || (paramInt == this.numberOfDefinePositions))
/*      */     {
/* 1828 */       return;
/*      */     }
/* 1830 */     int i = 0;
/* 1831 */     int j = 0;
/* 1832 */     int k = 0;
/* 1833 */     int m = 0;
/* 1834 */     int n = 0;
/*      */ 
/* 1837 */     if (!this.hasStream)
/*      */     {
/* 1839 */       i = this.defineBytes != null ? this.defineBytes.length : 0;
/* 1840 */       j = this.defineChars != null ? this.defineChars.length : 0;
/* 1841 */       k = this.defineIndicators.length;
/*      */     }
/*      */     else
/*      */     {
/* 1845 */       if (this.numberOfDefinePositions > paramInt)
/*      */       {
/* 1847 */         n = this.accessors[paramInt].indicatorIndex;
/* 1848 */         m = this.accessors[paramInt].lengthIndex;
/*      */       }
/*      */ 
/* 1853 */       for (int i1 = paramInt; i1 < this.numberOfDefinePositions; i1++)
/*      */       {
/* 1855 */         switch (this.accessors[i1].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1859 */           break;
/*      */         default:
/* 1861 */           i += this.accessors[i1].byteLength;
/* 1862 */           j += this.accessors[i1].charLength;
/* 1863 */           k++;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1868 */     ByteBuffer localByteBuffer = this.nioBuffers[0];
/* 1869 */     if ((localByteBuffer != null) && (this.defineBytes != null))
/*      */     {
/* 1871 */       if (i > 0)
/*      */       {
/* 1873 */         localByteBuffer.position(this.extractedByteOffset);
/* 1874 */         localByteBuffer.get(this.defineBytes, this.extractedByteOffset, i);
/* 1875 */         this.extractedByteOffset += i;
/*      */       }
/*      */     }
/*      */     Object localObject;
/* 1890 */     if ((this.nioBuffers[1] != null) && (this.defineChars != null))
/*      */     {
/* 1892 */       localByteBuffer = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
/* 1893 */       localObject = localByteBuffer.asCharBuffer();
/*      */ 
/* 1895 */       if (j > 0)
/*      */       {
/* 1897 */         ((CharBuffer)localObject).position(this.extractedCharOffset);
/* 1898 */         ((CharBuffer)localObject).get(this.defineChars, this.extractedCharOffset, j);
/* 1899 */         this.extractedCharOffset += j;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1904 */     if (this.nioBuffers[2] != null) {
/* 1905 */       localByteBuffer = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
/* 1906 */       localObject = localByteBuffer.asShortBuffer();
/* 1907 */       if (this.hasStream)
/*      */       {
/* 1909 */         if (k > 0)
/*      */         {
/* 1911 */           ((ShortBuffer)localObject).position(n);
/* 1912 */           ((ShortBuffer)localObject).get(this.defineIndicators, n, k);
/* 1913 */           ((ShortBuffer)localObject).position(m);
/* 1914 */           ((ShortBuffer)localObject).get(this.defineIndicators, m, k);
/*      */         }
/*      */       }
/*      */       else
/* 1918 */         ((ShortBuffer)localObject).get(this.defineIndicators);
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1966 */     if (this.defineBytes != null)
/*      */     {
/* 1968 */       this.defineBytes = null;
/*      */     }
/*      */ 
/* 1971 */     if (this.defineChars != null)
/*      */     {
/* 1973 */       this.defineChars = null;
/*      */     }
/*      */ 
/* 1976 */     if (this.defineIndicators != null)
/*      */     {
/* 1978 */       this.defineIndicators = null;
/*      */     }
/*      */ 
/* 1982 */     int i = t2cCloseStatement(this.c_state);
/*      */ 
/* 1984 */     this.nioBuffers = null;
/*      */ 
/* 1986 */     if (i != 0) {
/* 1987 */       this.t2cConnection.checkError(i);
/*      */     }
/* 1989 */     this.t2cOutput = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 2001 */     this.connection.registerHeartbeat();
/* 2002 */     this.connection.needLine();
/*      */ 
/* 2005 */     if (this.streamList != null)
/* 2006 */       while (this.nextStream != null) {
/*      */         try {
/* 2008 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 2012 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2013 */           localSQLException.fillInStackTrace();
/* 2014 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2017 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */   }
/*      */ 
/*      */   void closeUsedStreams(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 2029 */     while ((this.nextStream != null) && (this.nextStream.columnIndex < 1 + this.offsetOfFirstUserColumn + paramInt))
/*      */     {
/*      */       try
/*      */       {
/* 2035 */         this.nextStream.close();
/*      */       }
/*      */       catch (IOException localIOException1)
/*      */       {
/* 2040 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 2041 */         localSQLException.fillInStackTrace();
/* 2042 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2046 */       this.nextStream = this.nextStream.nextStream;
/*      */     }
/*      */ 
/* 2049 */     if (this.nextStream != null)
/*      */       try
/*      */       {
/* 2052 */         this.nextStream.needBytes();
/*      */       }
/*      */       catch (IOException localIOException2)
/*      */       {
/* 2056 */         interalCloseOnIOException(localIOException2);
/*      */ 
/* 2058 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 2059 */         localSQLException.fillInStackTrace();
/* 2060 */         throw localSQLException;
/*      */       }
/*      */   }
/*      */ 
/*      */   void interalCloseOnIOException(IOException paramIOException)
/*      */     throws SQLException
/*      */   {
/* 2069 */     this.closed = true;
/*      */ 
/* 2071 */     if (this.currentResultSet != null) {
/* 2072 */       this.currentResultSet.closed = true;
/*      */     }
/* 2074 */     doClose();
/*      */   }
/*      */ 
/*      */   void fetchDmlReturnParams()
/*      */     throws SQLException
/*      */   {
/* 2081 */     this.rowsDmlReturned = t2cGetRowsDmlReturned(this.c_state);
/*      */ 
/* 2083 */     if (this.rowsDmlReturned != 0)
/*      */     {
/* 2085 */       allocateDmlReturnStorage();
/*      */ 
/* 2087 */       resetStateBeforeFetch();
/* 2088 */       int i = t2cFetchDmlReturnParams(this.c_state, this, this.accessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
/*      */ 
/* 2097 */       if ((i == -1) || (i == -4)) {
/* 2098 */         this.t2cConnection.checkError(i);
/*      */       }
/*      */ 
/* 2101 */       if (this.t2cOutput[2] != 0L)
/*      */       {
/* 2103 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 2107 */       if ((this.connection.useNio) && ((i > 0) || (i == -2)))
/*      */       {
/* 2109 */         extractNioDefineBuffers(0);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2115 */     AggregateByteArray localAggregateByteArray = (AggregateByteArray)this.bindData;
/* 2116 */     if (this.returnParamBytes != null)
/* 2117 */       localAggregateByteArray.setBytes(this.returnParamBytes);
/* 2118 */     ((T2CCharByteArray)localAggregateByteArray.extension).setChars(this.returnParamChars);
/* 2119 */     ((T2CCharByteArray)localAggregateByteArray.extension).setDBConversion(this.connection.conversion);
/*      */ 
/* 2121 */     int j = this.returnParamBytes == null ? 0 : this.returnParamBytes.length;
/* 2122 */     int k = 0;
/* 2123 */     int m = this.numReturnParams * this.rowsDmlReturned;
/* 2124 */     int n = 0;
/* 2125 */     int i1 = j;
/* 2126 */     int i2 = 0;
/* 2127 */     for (int i3 = 0; i3 < this.numberOfBindPositions; i3++)
/*      */     {
/* 2129 */       Accessor localAccessor = this.accessors[i3];
/* 2130 */       if (localAccessor != null)
/*      */       {
/* 2132 */         localAccessor.setCapacity(this.rowsDmlReturned);
/* 2133 */         for (int i4 = 0; i4 < this.rowsDmlReturned; i4++)
/*      */         {
/* 2136 */           if ((localAccessor.internalType == 109) || (localAccessor.internalType == 111))
/*      */           {
/* 2139 */             i2++;
/*      */           }
/*      */           else
/*      */           {
/* 2143 */             int i5 = this.returnParamIndicators[(m++)];
/* 2144 */             int i6 = this.returnParamIndicators[(k++)] == -1 ? 1 : 0;
/* 2145 */             int i7 = 0;
/* 2146 */             if (localAccessor.internalType == 104)
/* 2147 */               i7 = 2;
/* 2148 */             else if ((localAccessor.defineType == 6) || (localAccessor.defineType == 9) || (localAccessor.defineType == 1))
/*      */             {
/* 2150 */               i7 = 1;
/*      */             }
/*      */ 
/* 2159 */             if (localAccessor.charLength > 0)
/*      */             {
/* 2169 */               localAccessor.setOffset(i4, i1 + i7);
/* 2170 */               i1 += localAccessor.charLength;
/*      */             }
/*      */             else
/*      */             {
/* 2181 */               localAccessor.setOffset(i4, n + i7);
/* 2182 */               n += localAccessor.byteLength;
/*      */             }
/*      */ 
/* 2185 */             if ((i6 != 0) || (i5 == 0))
/*      */             {
/* 2187 */               localAccessor.setLengthAndNull(i4, 0);
/*      */             }
/*      */             else {
/* 2190 */               if (localAccessor.internalType == 1) i5 /= 2;
/*      */ 
/* 2192 */               localAccessor.setLengthAndNull(i4, i5);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2201 */     this.returnParamsFetched = true;
/*      */   }
/*      */ 
/*      */   void processDmlReturningBind()
/*      */     throws SQLException
/*      */   {
/* 2216 */     super.processDmlReturningBind();
/* 2217 */     this.returnParamRowBytes = 0;
/* 2218 */     this.returnParamRowChars = 0;
/*      */ 
/* 2220 */     for (int i = 0; i < this.numberOfBindPositions; i++)
/*      */     {
/* 2222 */       Accessor localAccessor = this.accessors[i];
/*      */ 
/* 2224 */       if (localAccessor != null)
/*      */       {
/* 2226 */         if (localAccessor.charLength > 0)
/*      */         {
/* 2228 */           this.returnParamRowChars += localAccessor.charLength;
/*      */         }
/*      */         else
/*      */         {
/* 2232 */           this.returnParamRowBytes += localAccessor.byteLength;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2238 */     this.returnParamMeta[1] = this.returnParamRowBytes;
/* 2239 */     this.returnParamMeta[2] = this.returnParamRowChars;
/*      */   }
/*      */ 
/*      */   void allocateDmlReturnStorage()
/*      */   {
/* 2248 */     if (this.rowsDmlReturned == 0) return;
/*      */ 
/* 2250 */     int i = this.returnParamRowBytes * this.rowsDmlReturned;
/* 2251 */     int j = this.returnParamRowChars * this.rowsDmlReturned;
/* 2252 */     int k = 2 * this.numReturnParams * this.rowsDmlReturned;
/*      */ 
/* 2254 */     this.returnParamBytes = new byte[i];
/* 2255 */     this.returnParamChars = new char[j];
/* 2256 */     this.returnParamIndicators = new short[k];
/*      */ 
/* 2259 */     for (int m = 0; m < this.numberOfBindPositions; m++)
/*      */     {
/* 2261 */       Accessor localAccessor = this.accessors[m];
/* 2262 */       if (localAccessor != null)
/* 2263 */         localAccessor.setCapacity(this.rowsDmlReturned);
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanupReturnParameterBuffers()
/*      */   {
/* 2270 */     this.returnParamBytes = null;
/* 2271 */     this.returnParamChars = null;
/* 2272 */     this.returnParamIndicators = null;
/*      */   }
/*      */ 
/*      */   void initializeIndicatorSubRange()
/*      */   {
/* 2290 */     this.bindIndicatorSubRange = (this.numberOfBindPositions * PREAMBLE_PER_POSITION);
/*      */   }
/*      */ 
/*      */   int calculateIndicatorSubRangeSize()
/*      */   {
/* 2297 */     return this.numberOfBindPositions * PREAMBLE_PER_POSITION;
/*      */   }
/*      */ 
/*      */   short getInoutIndicator(int paramInt)
/*      */   {
/* 2304 */     return this.bindIndicators[(paramInt * PREAMBLE_PER_POSITION)];
/*      */   }
/*      */ 
/*      */   void resetStateBeforeFetch()
/*      */   {
/* 2310 */     this.lastProcessedCell = 0;
/* 2311 */     this.lastProcessedAccessorIndex = 0;
/* 2312 */     this.accessorsProcessed = 0;
/* 2313 */     this.previousMode = 0;
/* 2314 */     if (this.rowData != null)
/* 2315 */       if (this.needToRetainRows) {
/* 2316 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*      */       else
/* 2319 */         this.rowData.reset();
/*      */   }
/*      */ 
/*      */   public int updateData(int paramInt1, int paramInt2, int paramInt3, int[] paramArrayOfInt, byte[] paramArrayOfByte)
/*      */   {
/*      */     try
/*      */     {
/* 2350 */       if (this.previousMode != paramInt1) {
/* 2351 */         this.accessorsProcessed = 0;
/*      */       }
/* 2353 */       this.previousMode = paramInt1;
/*      */ 
/* 2355 */       int i = 0;
/* 2356 */       int j = 0;
/* 2357 */       int k = 0;
/* 2358 */       int m = 0;
/* 2359 */       int n = 0;
/*      */       int i1;
/*      */       Object localObject1;
/* 2361 */       switch (paramInt1)
/*      */       {
/*      */       case 16:
/*      */       case 32:
/* 2366 */         for (i1 = 0; 
/* 2367 */           i1 < paramInt2; 
/* 2368 */           i1++)
/*      */         {
/* 2370 */           j = paramArrayOfInt[(i1 * 4 + 0)];
/* 2371 */           k = paramArrayOfInt[(i1 * 4 + 1)];
/* 2372 */           m = paramArrayOfInt[(i1 * 4 + 2)];
/* 2373 */           n = paramArrayOfInt[(i1 * 4 + 3)] == -1 ? 1 : 0;
/* 2374 */           localObject1 = this.accessors[k];
/*      */ 
/* 2380 */           ((Accessor)localObject1).setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j);
/*      */ 
/* 2384 */           if (m > 0)
/*      */           {
/* 2387 */             switch (((Accessor)localObject1).defineType)
/*      */             {
/*      */             case 1:
/*      */             case 23:
/*      */             case 96:
/*      */             case 104:
/* 2395 */               i += 2;
/* 2396 */               m -= 2;
/* 2397 */               break;
/*      */             case 6:
/* 2400 */               i++;
/* 2401 */               m--;
/*      */             }
/*      */ 
/* 2408 */             this.rowData.put(paramArrayOfByte, i, m);
/*      */ 
/* 2410 */             i += m;
/*      */           }
/* 2412 */           ((Accessor)localObject1).setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/* 2413 */           this.accessorsProcessed += 1;
/*      */ 
/* 2368 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/* 2415 */         break;
/*      */       case 64:
/* 2421 */         i1 = 0;
/* 2422 */         localObject1 = null;
/* 2423 */         if (this.outBindAccessors != null) {
/* 2424 */           i1 = (this.bindBytes == null ? 0 : this.bindBytes.length) + (this.bindChars == null ? 0 : this.bindChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2428 */           localObject1 = this.outBindAccessors;
/*      */         }
/*      */         else {
/* 2431 */           i1 = (this.returnParamBytes == null ? 0 : this.returnParamBytes.length) + (this.returnParamChars == null ? 0 : this.returnParamChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2435 */           localObject1 = this.accessors;
/*      */         }
/* 2437 */         assert (localObject1 != null) : "No OUT binds or Return Parameters";
/* 2438 */         ByteArray localByteArray = this.bindData;
/*      */         do
/*      */         {
/* 2442 */           if (!(localByteArray instanceof AggregateByteArray))
/*      */             break;
/* 2444 */           localByteArray = ((AggregateByteArray)localByteArray).extension;
/*      */         }
/* 2446 */         while (localByteArray != null);
/*      */ 
/* 2448 */         i1 = (int)(i1 + localByteArray.getPosition());
/* 2449 */         int i2 = this.accessorsProcessed;
/* 2450 */         for (int i3 = 0; 
/* 2451 */           i3 < paramInt2; 
/* 2452 */           i3++)
/*      */         {
/* 2454 */           j = paramArrayOfInt[(i3 * 4 + 0)];
/* 2455 */           k = paramArrayOfInt[(i3 * 4 + 1)];
/* 2456 */           m = paramArrayOfInt[(i3 * 4 + 2)];
/* 2457 */           n = paramArrayOfInt[(i3 * 4 + 3)] == -1 ? 1 : 0;
/* 2458 */           Object localObject2 = localObject1[k];
/*      */ 
/* 2463 */           localObject2.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j, i1);
/* 2464 */           localByteArray.put(paramArrayOfByte, i, m);
/* 2465 */           localObject2.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/*      */ 
/* 2467 */           i += m;
/* 2468 */           i1 += m;
/*      */ 
/* 2452 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2474 */       this.updateDataException = localSQLException;
/* 2475 */       return -3;
/*      */     }
/* 2477 */     return 0;
/*      */   }
/*      */ 
/*      */   final boolean bit(long paramLong1, long paramLong2)
/*      */   {
/* 2482 */     return (paramLong1 & paramLong2) == paramLong1;
/*      */   }
/*      */ 
/*      */   public static String toHex(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/* 2487 */     if (paramArrayOfByte == null)
/* 2488 */       return "null";
/* 2489 */     if (paramInt > paramArrayOfByte.length)
/* 2490 */       return "byte array not long enough";
/* 2491 */     String str = "0:";
/* 2492 */     int i = paramInt;
/* 2493 */     for (int j = 0; j < i; j++)
/*      */     {
/* 2495 */       if ((j != 0) && (j % 10 == 0)) str = str + "\n" + j + ": ";
/* 2496 */       str = str + OracleLog.toHex(paramArrayOfByte[j]) + " ";
/*      */     }
/* 2498 */     return str;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2512 */     Object localObject = null;
/*      */     SQLException localSQLException;
/* 2514 */     switch (paramInt1)
/*      */     {
/*      */     case 102:
/*      */     case 116:
/* 2519 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2521 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2522 */         localSQLException.fillInStackTrace();
/* 2523 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2526 */       localObject = new T2CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2529 */       return localObject;
/*      */     case 8:
/* 2533 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2535 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2536 */         localSQLException.fillInStackTrace();
/* 2537 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2540 */       if (paramBoolean) {
/* 2541 */         return new VarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */       }
/*      */ 
/* 2544 */       return new T2CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     case 1:
/* 2550 */       if (paramBoolean)
/*      */       {
/* 2552 */         if (paramString != null)
/*      */         {
/* 2555 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2556 */           localSQLException.fillInStackTrace();
/* 2557 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2562 */         localObject = new T2CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2564 */         return localObject;
/*      */       }
/*      */ 
/*      */       break;
/*      */     case 24:
/* 2570 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2572 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2573 */         localSQLException.fillInStackTrace();
/* 2574 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2577 */       if (paramBoolean) {
/* 2578 */         return new OutRawAccessor(this, paramInt4, paramShort, paramInt2);
/*      */       }
/*      */ 
/* 2581 */       return new T2CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     }
/*      */ 
/* 2588 */     return super.allocateAccessor(paramInt1, paramInt2, paramInt3, paramInt4, paramShort, paramString, paramBoolean);
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 2607 */     if (this.closed)
/*      */     {
/* 2609 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 2610 */       localSQLException.fillInStackTrace();
/* 2611 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2614 */     if (this.described == true)
/*      */     {
/* 2616 */       return;
/*      */     }
/*      */ 
/* 2619 */     if (!this.isOpen)
/*      */     {
/* 2624 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 144);
/* 2625 */       localSQLException.fillInStackTrace();
/* 2626 */       throw localSQLException;
/*      */     }
/*      */ 
/*      */     int i;
/*      */     do
/*      */     {
/* 2635 */       i = 0;
/*      */ 
/* 2644 */       boolean bool = (this.sqlKind.isSELECT()) && (this.needToParse) && ((!this.described) || (!this.serverCursor));
/* 2645 */       byte[] arrayOfByte = bool ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
/* 2646 */       this.numberOfDefinePositions = t2cDescribe(this.c_state, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, arrayOfByte, arrayOfByte.length, bool);
/*      */ 
/* 2657 */       if (!this.described) {
/* 2658 */         this.described = true;
/*      */       }
/*      */ 
/* 2665 */       if (this.numberOfDefinePositions == -1)
/*      */       {
/* 2667 */         this.t2cConnection.checkError(this.numberOfDefinePositions);
/*      */       }
/*      */ 
/* 2671 */       if (this.numberOfDefinePositions == T2C_EXTEND_BUFFER)
/*      */       {
/* 2673 */         i = 1;
/*      */ 
/* 2677 */         this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * 2, this.t2cConnection.queryMetaData2Size * 2);
/*      */       }
/*      */     }
/*      */ 
/* 2681 */     while (i != 0);
/*      */ 
/* 2683 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   protected void configureRowData()
/*      */   {
/* 2689 */     super.configureRowData();
/*      */ 
/* 2699 */     DynamicByteArray localDynamicByteArray = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
/*      */ 
/* 2701 */     T2CCharByteArray localT2CCharByteArray1 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localDynamicByteArray);
/*      */ 
/* 2703 */     AggregateByteArray localAggregateByteArray = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray1);
/*      */ 
/* 2706 */     T2CCharByteArray localT2CCharByteArray2 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localAggregateByteArray);
/*      */ 
/* 2710 */     this.bindData = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray2);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CStatement
 * JD-Core Version:    0.6.2
 */