/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.nio.ByteBuffer;
/*      */ import java.nio.ByteOrder;
/*      */ import java.nio.CharBuffer;
/*      */ import java.nio.ShortBuffer;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayDeque;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T2CPreparedStatement extends OraclePreparedStatement
/*      */ {
/*   45 */   T2CConnection t2cConnection = null;
/*   46 */   int userResultSetType = -1;
/*   47 */   int userResultSetConcur = -1;
/*      */ 
/*   53 */   static int T2C_EXTEND_BUFFER = -3;
/*      */ 
/*   69 */   long[] t2cOutput = new long[10];
/*      */   static final int T2C_OUTPUT_USE_NIO = 5;
/*      */   static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
/*      */   static final int T2C_OUTPUT_USE_OCI_DEFAULT_DEFINE_OFFSET = 7;
/*      */   static final boolean T2CDEBUG = false;
/*      */   int extractedCharOffset;
/*      */   int extractedByteOffset;
/*  134 */   int savedRowPrefetch = 0;
/*      */   static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
/*      */   static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
/*      */   static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
/*      */   static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
/*      */   static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
/*      */   byte[] lobPrefetchTempBytes;
/* 1658 */   boolean needToRetainRows = false;
/*      */   byte[] returnParamBytes;
/*      */   char[] returnParamChars;
/*      */   short[] returnParamIndicators;
/*      */   int returnParamRowBytes;
/*      */   int returnParamRowChars;
/* 2197 */   static int PREAMBLE_PER_POSITION = 5;
/*      */ 
/* 2237 */   SQLException updateDataException = null;
/* 2238 */   int lastProcessedCell = 0;
/*      */   static final int PROCESS_DEFINE_DYNAMIC_COLUMNS = 16;
/*      */   static final int PROCESS_DEFINE_DEFAULT_COLUMNS = 32;
/*      */   static final int PROCESS_ADT_OUT_BINDS = 64;
/* 2242 */   int lastProcessedAccessorIndex = 0;
/* 2243 */   int accessorsProcessed = 0;
/* 2244 */   int previousMode = 0;
/*      */ 
/* 2762 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T2CPreparedStatement(T2CConnection paramT2CConnection, String paramString, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*      */     throws SQLException
/*      */   {
/*  109 */     super(paramT2CConnection, paramString, paramInt1, paramInt2, paramInt3, paramInt4);
/*      */ 
/*  112 */     this.userResultSetType = paramInt3;
/*  113 */     this.userResultSetConcur = paramInt4;
/*      */ 
/*  116 */     this.t2cConnection = paramT2CConnection;
/*      */ 
/*  118 */     if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/*  120 */       this.savedRowPrefetch = this.rowPrefetch;
/*  121 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   int getPrefetchInternal(boolean paramBoolean)
/*      */   {
/*  142 */     if (!this.t2cConnection.useOCIDefaultDefines) {
/*  143 */       return super.getPrefetchInternal(paramBoolean);
/*      */     }
/*  145 */     int i = paramBoolean ? this.defaultRowPrefetch : this.savedRowPrefetch;
/*      */ 
/*  147 */     return i;
/*      */   }
/*      */ 
/*      */   void setPrefetchInternal(int paramInt, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  158 */     int i = this.rowPrefetch;
/*  159 */     super.setPrefetchInternal(paramInt, paramBoolean1, paramBoolean2);
/*      */ 
/*  162 */     if ((this.t2cConnection.useOCIDefaultDefines) && (i != this.rowPrefetch))
/*      */     {
/*  164 */       this.savedRowPrefetch = this.rowPrefetch;
/*  165 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareForNewResults(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
/*      */     throws SQLException
/*      */   {
/*  180 */     super.prepareForNewResults(paramBoolean1, paramBoolean2, paramBoolean3);
/*      */ 
/*  185 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.rowPrefetchChanged))
/*      */     {
/*  187 */       this.savedRowPrefetch = this.rowPrefetch;
/*  188 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareAccessors()
/*      */     throws SQLException
/*      */   {
/*  199 */     super.prepareAccessors();
/*  200 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.hasStream))
/*  201 */       this.savedRowPrefetch = 1;
/*      */   }
/*      */ 
/*      */   String bytes2String(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  214 */     byte[] arrayOfByte = new byte[paramInt2];
/*      */ 
/*  216 */     System.arraycopy(paramArrayOfByte, paramInt1, arrayOfByte, 0, paramInt2);
/*      */ 
/*  218 */     return this.connection.conversion.CharBytesToString(arrayOfByte, paramInt2);
/*      */   }
/*      */ 
/*      */   void processDescribeData()
/*      */     throws SQLException
/*      */   {
/*  234 */     this.described = true;
/*  235 */     this.describedWithNames = true;
/*      */ 
/*  246 */     if (this.numberOfDefinePositions < 1) return;
/*  247 */     if ((this.accessors == null) || (this.numberOfDefinePositions > this.accessors.length)) {
/*  248 */       this.accessors = new Accessor[this.numberOfDefinePositions];
/*      */     }
/*      */ 
/*  264 */     int i = this.t2cConnection.queryMetaData1Offset;
/*  265 */     int j = this.t2cConnection.queryMetaData2Offset;
/*  266 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/*  267 */     byte[] arrayOfByte = this.t2cConnection.queryMetaData2;
/*      */ 
/*  269 */     for (int k = 0; k < this.numberOfDefinePositions; 
/*  270 */       i += 14)
/*      */     {
/*  272 */       int m = arrayOfShort[(i + 0)];
/*  273 */       int n = arrayOfShort[(i + 1)];
/*  274 */       int i1 = arrayOfShort[(i + 11)];
/*  275 */       boolean bool1 = arrayOfShort[(i + 2)] != 0;
/*  276 */       int i2 = arrayOfShort[(i + 3)];
/*  277 */       int i3 = arrayOfShort[(i + 4)];
/*  278 */       int i4 = 0;
/*  279 */       int i5 = 0;
/*  280 */       int i6 = 0;
/*  281 */       short s = arrayOfShort[(i + 5)];
/*  282 */       int i7 = arrayOfShort[(i + 6)];
/*  283 */       String str1 = bytes2String(arrayOfByte, j, i7);
/*  284 */       int i8 = arrayOfShort[(i + 12)];
/*  285 */       boolean bool2 = arrayOfShort[(i + 13)] != 0;
/*      */ 
/*  287 */       String str2 = null;
/*  288 */       OracleTypeADT localOracleTypeADT = null;
/*      */ 
/*  290 */       j += i7;
/*      */ 
/*  292 */       if (i8 > 0)
/*      */       {
/*  294 */         str2 = bytes2String(arrayOfByte, j, i8);
/*  295 */         j += i8;
/*  296 */         localOracleTypeADT = new OracleTypeADT(str2, this.connection);
/*  297 */         localOracleTypeADT.tdoCState = ((arrayOfShort[(i + 7)] & 0xFFFF) << 48 | (arrayOfShort[(i + 8)] & 0xFFFF) << 32 | (arrayOfShort[(i + 9)] & 0xFFFF) << 16 | arrayOfShort[(i + 10)] & 0xFFFF);
/*      */       }
/*      */ 
/*  304 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/*  311 */       if ((localAccessor == null) || (localAccessor.defineType == 0) || ((localAccessor.describeType != 0) && (localAccessor.describeType != m)))
/*      */       {
/*  315 */         localAccessor = allocateAccessorForDefines(k, m, n, bool1, i4, i2, i3, i5, i6, s, i1, localOracleTypeADT, str2);
/*      */ 
/*  318 */         if (this.accessors[k] != null)
/*      */         {
/*  320 */           localAccessor.rowLength = this.accessors[k].rowLength;
/*  321 */           localAccessor.rowOffset = this.accessors[k].rowOffset;
/*  322 */           localAccessor.rowNull = this.accessors[k].rowNull;
/*  323 */           localAccessor.rowMetadata = this.accessors[k].rowMetadata;
/*      */         }
/*      */       }
/*      */       else {
/*  327 */         localAccessor.initForDescribe(m, n, bool1, i4, i2, i3, i5, i6, s, str2);
/*      */       }
/*      */ 
/*  333 */       localAccessor.describeOtype = localOracleTypeADT;
/*  334 */       localAccessor.columnName = str1;
/*  335 */       localAccessor.columnInvisible = bool2;
/*      */ 
/*  337 */       this.accessors[k] = localAccessor;
/*      */ 
/*  270 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessorForDefines(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort, int paramInt9, OracleTypeADT paramOracleTypeADT, String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*  351 */     switch (paramInt2)
/*      */     {
/*      */     case 1:
/*  355 */       localObject = new VarcharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  359 */       if (paramInt9 > 0)
/*  360 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 96:
/*  365 */       localObject = new CharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  369 */       if (paramInt9 > 0)
/*  370 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 2:
/*  375 */       localObject = new NumberAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  379 */       break;
/*      */     case 23:
/*  382 */       localObject = new RawAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  386 */       break;
/*      */     case 100:
/*  389 */       localObject = new BinaryFloatAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  393 */       break;
/*      */     case 101:
/*  396 */       localObject = new BinaryDoubleAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  400 */       break;
/*      */     case 8:
/*  403 */       localObject = new T2CLongAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  410 */       this.rowPrefetch = 1;
/*  411 */       this.savedRowPrefetch = 1;
/*      */ 
/*  413 */       break;
/*      */     case 24:
/*  416 */       localObject = new T2CLongRawAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  423 */       this.rowPrefetch = 1;
/*  424 */       this.savedRowPrefetch = 1;
/*      */ 
/*  426 */       break;
/*      */     case 104:
/*  429 */       localObject = new RowidAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, (short)1);
/*      */ 
/*  433 */       break;
/*      */     case 102:
/*      */     case 116:
/*  438 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  440 */         localObject = new T2CResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */       else
/*      */       {
/*  445 */         localObject = new ResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */ 
/*  450 */       break;
/*      */     case 12:
/*  453 */       localObject = new DateAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  457 */       break;
/*      */     case 180:
/*  460 */       localObject = new TimestampAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  464 */       break;
/*      */     case 181:
/*  467 */       localObject = new TimestamptzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  471 */       break;
/*      */     case 231:
/*  474 */       localObject = new TimestampltzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  478 */       break;
/*      */     case 182:
/*  481 */       localObject = new IntervalymAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  485 */       break;
/*      */     case 183:
/*  488 */       localObject = new IntervaldsAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  492 */       break;
/*      */     case 112:
/*  495 */       localObject = new ClobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  499 */       break;
/*      */     case 113:
/*  502 */       localObject = new BlobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  506 */       break;
/*      */     case 114:
/*  509 */       localObject = new BfileAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  513 */       break;
/*      */     case 109:
/*  516 */       localObject = new NamedTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  521 */       break;
/*      */     case 111:
/*  524 */       localObject = new RefTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  529 */       break;
/*      */     default:
/*  533 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + paramInt2);
/*      */ 
/*  535 */       localSQLException.fillInStackTrace();
/*  536 */       throw localSQLException;
/*      */     }
/*      */ 
/*  539 */     return localObject;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  579 */     this.t2cOutput[0] = 0L;
/*  580 */     this.t2cOutput[2] = 0L;
/*  581 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/*      */ 
/*  585 */     this.lobPrefetchMetaData = null;
/*      */ 
/*  587 */     boolean bool1 = !this.described;
/*  588 */     boolean bool2 = false;
/*      */ 
/*  590 */     int j = this.t2cConnection.useOCIDefaultDefines ? this.savedRowPrefetch : this.rowPrefetch;
/*  591 */     assert (j > 0) : ("rowsToFetch < 1 (rowsToFetch=" + j + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/*  592 */     this.validRows = 0;
/*      */     int i;
/*      */     do
/*      */     {
/*  595 */       i = 0;
/*      */ 
/*  598 */       if (this.connection.endToEndAnyChanged)
/*      */       {
/*  600 */         pushEndToEndValues();
/*      */ 
/*  602 */         this.connection.endToEndAnyChanged = false;
/*      */       }
/*      */ 
/*  606 */       byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/*      */ 
/*  608 */       int k = 0;
/*      */       try
/*      */       {
/*  611 */         resetStateBeforeFetch();
/*  612 */         k = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, bool1, bool2, arrayOfByte, arrayOfByte.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), j, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, this.preparedByteBinds, this.preparedCharBinds, this.accessors, this.parameterDatum, this.t2cOutput, this.t2cConnection.plsqlCompilerWarnings);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/*  656 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 266);
/*  657 */         localSQLException.fillInStackTrace();
/*  658 */         throw localSQLException;
/*      */       }
/*      */ 
/*  664 */       if (this.bindIndicators != null) {
/*  665 */         setLengthForOutAccessors();
/*      */       }
/*      */ 
/*  670 */       this.validRows = ((int)this.t2cOutput[1]);
/*      */ 
/*  673 */       if ((k == -1) || (k == -4))
/*      */       {
/*  675 */         this.t2cConnection.checkError(k);
/*      */       }
/*  677 */       else if (k == T2C_EXTEND_BUFFER)
/*      */       {
/*  679 */         k = this.t2cConnection.queryMetaData1Size * 2;
/*      */       }
/*      */ 
/*  684 */       if (this.t2cOutput[3] != 0L)
/*      */       {
/*  686 */         foundPlsqlCompilerWarning();
/*      */       }
/*  688 */       else if (this.t2cOutput[2] != 0L)
/*      */       {
/*  690 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/*  695 */       this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/*  698 */       this.needToParse = false;
/*  699 */       bool2 = true;
/*      */ 
/*  701 */       if (this.sqlKind.isSELECT())
/*      */       {
/*  703 */         this.numberOfDefinePositions = k;
/*      */ 
/*  705 */         if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */         {
/*  707 */           i = 1;
/*  708 */           bool2 = true;
/*      */ 
/*  711 */           this.t2cConnection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  718 */         this.numberOfDefinePositions = 0;
/*  719 */         this.validRows = k;
/*      */       }
/*  721 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  723 */         checkForImplicitResultSets();
/*      */       }
/*      */     }
/*  726 */     while (i != 0);
/*      */ 
/*  729 */     this.isComplete = false;
/*      */ 
/*  731 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   void checkForImplicitResultSets()
/*      */     throws SQLException
/*      */   {
/*  739 */     int i = 0;
/*      */ 
/*  742 */     i = T2CStatement.t2cGetImplicitResultSetCount(this, this.c_state);
/*  743 */     if (i > 0)
/*      */     {
/*  745 */       int j = i;
/*  746 */       this.implicitResultSetStatements = new ArrayDeque(j);
/*  747 */       while (j != 0)
/*      */       {
/*  751 */         OracleStatement localOracleStatement = this.connection.createImplicitResultSetStatement(this);
/*  752 */         ((T2CStatement)localOracleStatement).doDescribe(true);
/*  753 */         ((T2CStatement)localOracleStatement).prepareAccessors();
/*  754 */         j--;
/*      */       }
/*  756 */       this.implicitResultSetIterator = this.implicitResultSetStatements.iterator();
/*      */     }
/*  758 */     else if (i != 0) {
/*  759 */       this.t2cConnection.checkError(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   void pushEndToEndValues()
/*      */     throws SQLException
/*      */   {
/*  766 */     T2CConnection localT2CConnection = this.t2cConnection;
/*  767 */     byte[] arrayOfByte1 = null;
/*  768 */     byte[] arrayOfByte2 = null;
/*  769 */     byte[] arrayOfByte3 = null;
/*  770 */     byte[] arrayOfByte4 = null;
/*  771 */     byte[] arrayOfByte5 = null;
/*      */ 
/*  773 */     if (localT2CConnection.endToEndValues != null)
/*      */     {
/*      */       String str;
/*  775 */       if (localT2CConnection.endToEndHasChanged[0] != 0)
/*      */       {
/*  777 */         str = localT2CConnection.endToEndValues[0];
/*      */ 
/*  779 */         if (str != null) {
/*  780 */           arrayOfByte1 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  784 */           arrayOfByte1 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  787 */         localT2CConnection.endToEndHasChanged[0] = false;
/*      */       }
/*      */ 
/*  790 */       if (localT2CConnection.endToEndHasChanged[1] != 0)
/*      */       {
/*  792 */         str = localT2CConnection.endToEndValues[1];
/*      */ 
/*  794 */         if (str != null) {
/*  795 */           arrayOfByte2 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  799 */           arrayOfByte2 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  802 */         localT2CConnection.endToEndHasChanged[1] = false;
/*      */       }
/*      */ 
/*  805 */       if (localT2CConnection.endToEndHasChanged[2] != 0)
/*      */       {
/*  807 */         str = localT2CConnection.endToEndValues[2];
/*      */ 
/*  809 */         if (str != null) {
/*  810 */           arrayOfByte3 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  814 */           arrayOfByte3 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  817 */         localT2CConnection.endToEndHasChanged[2] = false;
/*      */       }
/*      */ 
/*  820 */       if (localT2CConnection.endToEndHasChanged[3] != 0)
/*      */       {
/*  822 */         str = localT2CConnection.endToEndValues[3];
/*      */ 
/*  824 */         if (str != null) {
/*  825 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  829 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  832 */         localT2CConnection.endToEndHasChanged[3] = false;
/*      */       }
/*      */ 
/*  835 */       if (localT2CConnection.endToEndHasChanged[4] != 0)
/*      */       {
/*  837 */         str = localT2CConnection.endToEndValues[4];
/*      */ 
/*  839 */         if (str != null) {
/*  840 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  844 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  847 */         localT2CConnection.endToEndHasChanged[4] = false;
/*      */       }
/*      */ 
/*  853 */       T2CStatement.t2cEndToEndUpdate(this.c_state, arrayOfByte1, arrayOfByte1 == null ? -1 : arrayOfByte1.length, arrayOfByte2, arrayOfByte2 == null ? -1 : arrayOfByte2.length, arrayOfByte3, arrayOfByte3 == null ? -1 : arrayOfByte3.length, arrayOfByte4, arrayOfByte4 == null ? -1 : arrayOfByte4.length, arrayOfByte5, arrayOfByte5 == null ? -1 : arrayOfByte5.length, localT2CConnection.endToEndECIDSequenceNumber);
/*      */     }
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  909 */     if (this.connection.endToEndAnyChanged)
/*      */     {
/*  911 */       pushEndToEndValues();
/*      */ 
/*  913 */       this.connection.endToEndAnyChanged = false;
/*      */     }
/*      */ 
/*  917 */     if (!paramBoolean)
/*      */     {
/*  925 */       if (this.numberOfDefinePositions > 0)
/*      */       {
/*  927 */         doDefineExecuteFetch();
/*      */       }
/*      */       else
/*      */       {
/*  931 */         executeForDescribe();
/*      */       }
/*      */     }
/*  934 */     else if (this.numberOfDefinePositions > 0) {
/*  935 */       doDefineFetch();
/*      */     }
/*      */ 
/*  938 */     if (this.returnParamMeta != null) {
/*  939 */       fetchDmlReturnParams();
/*      */     }
/*      */ 
/*  944 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void setupForDefine()
/*      */     throws SQLException
/*      */   {
/*  954 */     if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */     {
/*  956 */       int i = this.numberOfDefinePositions / 100 + 1;
/*      */ 
/*  958 */       this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * i, this.t2cConnection.queryMetaData2Size * i * 8);
/*      */     }
/*      */ 
/*  963 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/*  964 */     int j = this.t2cConnection.queryMetaData1Offset;
/*      */ 
/*  967 */     for (int k = 0; k < this.numberOfDefinePositions; 
/*  968 */       j += 14)
/*      */     {
/*  970 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/*  972 */       if (localAccessor == null)
/*      */       {
/*  974 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  975 */         localSQLException.fillInStackTrace();
/*  976 */         throw localSQLException;
/*      */       }
/*      */ 
/*  979 */       arrayOfShort[(j + 0)] = ((short)localAccessor.defineType);
/*      */ 
/*  982 */       if ((!this.described) && (localAccessor.charLength > 0) && (localAccessor.formOfUse == 1))
/*      */       {
/*  989 */         int m = localAccessor.charLength;
/*  990 */         int n = m + 1;
/*  991 */         arrayOfShort[(j + 11)] = 0;
/*  992 */         arrayOfShort[(j + 1)] = ((short)n);
/*      */       }
/*      */       else {
/*  995 */         arrayOfShort[(j + 11)] = ((short)localAccessor.charLength);
/*      */ 
/*  997 */         arrayOfShort[(j + 1)] = ((short)localAccessor.byteLength);
/*      */       }
/*      */ 
/* 1000 */       arrayOfShort[(j + 5)] = localAccessor.formOfUse;
/*      */ 
/* 1003 */       if (localAccessor.internalOtype != null)
/*      */       {
/* 1005 */         long l = ((OracleTypeADT)localAccessor.internalOtype).getTdoCState();
/*      */ 
/* 1008 */         arrayOfShort[(j + 7)] = ((short)(int)((l & 0x0) >> 48));
/*      */ 
/* 1010 */         arrayOfShort[(j + 8)] = ((short)(int)((l & 0x0) >> 32));
/*      */ 
/* 1012 */         arrayOfShort[(j + 9)] = ((short)(int)((l & 0xFFFF0000) >> 16));
/*      */ 
/* 1014 */         arrayOfShort[(j + 10)] = ((short)(int)(l & 0xFFFF));
/*      */       }
/*      */ 
/* 1018 */       switch (localAccessor.internalType)
/*      */       {
/*      */       case 112:
/*      */       case 113:
/* 1024 */         if (localAccessor.lobPrefetchSizeForThisColumn == -1) {
/* 1025 */           localAccessor.lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
/*      */         }
/*      */ 
/* 1028 */         arrayOfShort[(j + 7)] = ((short)localAccessor.lobPrefetchSizeForThisColumn);
/*      */       }
/*  968 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void configureBindData()
/*      */     throws SQLException
/*      */   {
/* 1042 */     if (this.outBindAccessors == null) {
/* 1043 */       return;
/*      */     }
/*      */ 
/* 1046 */     AggregateByteArray localAggregateByteArray1 = (AggregateByteArray)this.bindData;
/* 1047 */     T2CCharByteArray localT2CCharByteArray1 = (T2CCharByteArray)localAggregateByteArray1.extension;
/*      */ 
/* 1049 */     AggregateByteArray localAggregateByteArray2 = (AggregateByteArray)localT2CCharByteArray1.extension;
/*      */ 
/* 1051 */     T2CCharByteArray localT2CCharByteArray2 = (T2CCharByteArray)localAggregateByteArray2.extension;
/*      */ 
/* 1054 */     if (this.bindBytes != null)
/* 1055 */       localAggregateByteArray1.setBytes(this.bindBytes);
/*      */     else {
/* 1057 */       localAggregateByteArray1.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
/*      */     }
/* 1059 */     if (this.bindChars != null)
/* 1060 */       localT2CCharByteArray1.setChars(this.bindChars);
/*      */     else {
/* 1062 */       localT2CCharByteArray1.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
/*      */     }
/* 1064 */     if (this.ibtBindBytes != null)
/* 1065 */       localAggregateByteArray2.setBytes(this.ibtBindBytes);
/*      */     else {
/* 1067 */       localAggregateByteArray2.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
/*      */     }
/* 1069 */     if (this.ibtBindChars != null)
/* 1070 */       localT2CCharByteArray2.setChars(this.ibtBindChars);
/*      */     else {
/* 1072 */       localT2CCharByteArray2.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
/*      */     }
/* 1074 */     localT2CCharByteArray1.setDBConversion(this.connection.conversion);
/* 1075 */     localT2CCharByteArray2.setDBConversion(this.connection.conversion);
/*      */ 
/* 1077 */     int i = this.bindBytes == null ? 0 : this.bindBytes.length;
/* 1078 */     int j = this.bindChars == null ? 0 : this.bindChars.length;
/* 1079 */     int k = this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length;
/* 1080 */     int m = this.ibtBindChars == null ? 0 : this.ibtBindChars.length;
/*      */ 
/* 1092 */     Accessor localAccessor = null;
/* 1093 */     int n = 0;
/*      */ 
/* 1096 */     for (int i1 = 0; 
/* 1097 */       i1 < this.numberOfBindPositions; 
/* 1098 */       i1++)
/*      */     {
/* 1101 */       localAccessor = this.outBindAccessors[i1];
/* 1102 */       if (localAccessor != null)
/*      */       {
/* 1104 */         int i2 = 0;
/* 1105 */         int i3 = localAccessor.byteLength;
/* 1106 */         if (localAccessor.defineType == 998)
/*      */         {
/* 1108 */           PlsqlIndexTableAccessor localPlsqlIndexTableAccessor = (PlsqlIndexTableAccessor)localAccessor;
/* 1109 */           i2 += i + j;
/* 1110 */           i2 += localPlsqlIndexTableAccessor.ibtBindInfo.ibtValueIndex;
/* 1111 */           switch (localPlsqlIndexTableAccessor.ibtBindInfo.element_internal_type)
/*      */           {
/*      */           case 9:
/* 1115 */             i2 += k;
/* 1116 */             break;
/*      */           case 6:
/*      */           }
/*      */ 
/* 1122 */           localAccessor.setOffset(0, i2);
/*      */         }
/*      */         else {
/* 1125 */           i2 = localAccessor.columnDataOffset;
/*      */ 
/* 1127 */           if (localAccessor.charLength > 0)
/*      */           {
/* 1129 */             i2 += i;
/* 1130 */             i3 = localAccessor.charLength;
/*      */           }
/* 1132 */           if (localAccessor.defineType == 15) n = 2;
/* 1133 */           else if (localAccessor.externalType == -8)
/*      */           {
/* 1135 */             n = this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK ? 1 : 2;
/*      */           }
/* 1141 */           else if ((localAccessor.defineType == 6) || (localAccessor.defineType == 9))
/*      */           {
/* 1143 */             n = 1;
/*      */           }
/* 1145 */           else n = 0;
/*      */ 
/* 1147 */           for (int i4 = 0; i4 < this.binders.length; i4++)
/*      */           {
/* 1149 */             i2 += i3 * i4 + n;
/* 1150 */             int i5 = this.bindIndicators[localAccessor.lengthIndex] - n & 0x7FFF;
/*      */ 
/* 1152 */             localAccessor.setOffset(i4, i2);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void initializePlsqlIndexByTableAccessor(Accessor paramAccessor, int paramInt)
/*      */   {
/* 1163 */     ((T2CPlsqlIndexTableAccessor)paramAccessor).ibtMetaIndex = (paramInt - 8);
/*      */   }
/*      */ 
/*      */   Object[] getLobPrefetchMetaData()
/*      */   {
/* 1178 */     Object[] arrayOfObject = null;
/* 1179 */     Object localObject = null;
/* 1180 */     int[] arrayOfInt = null;
/* 1181 */     int i = 0;
/* 1182 */     int j = 0;
/*      */     int k;
/* 1184 */     if (this.accessors != null) {
/* 1185 */       for (k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1187 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1194 */           j = k;
/* 1195 */           break;
/*      */         case 112:
/*      */         case 113:
/* 1201 */           if (arrayOfInt == null)
/*      */           {
/* 1203 */             arrayOfInt = new int[this.accessors.length];
/*      */           }
/*      */ 
/* 1206 */           if (this.accessors[k].lobPrefetchSizeForThisColumn != -1)
/*      */           {
/* 1208 */             i++;
/*      */ 
/* 1210 */             arrayOfInt[k] = this.accessors[k].lobPrefetchSizeForThisColumn;
/*      */           }
/*      */           else
/*      */           {
/* 1214 */             arrayOfInt[k] = -1;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1222 */     if (i > 0)
/*      */     {
/* 1224 */       if (arrayOfObject == null)
/*      */       {
/* 1226 */         arrayOfObject = new Object[] { null, new long[this.rowPrefetch * i], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * i] };
/*      */       }
/*      */ 
/* 1248 */       for (k = 0; k < j; k++)
/*      */       {
/* 1250 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1254 */           this.accessors[k].lobPrefetchSizeForThisColumn = -1;
/* 1255 */           arrayOfInt[k] = -1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1260 */       arrayOfObject[0] = arrayOfInt;
/*      */     }
/*      */ 
/* 1264 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   void processLobPrefetchMetaData(Object[] paramArrayOfObject)
/*      */   {
/* 1272 */     int i = 0;
/* 1273 */     int j = this.validRows == -2 ? 1 : this.validRows;
/*      */ 
/* 1275 */     byte[] arrayOfByte1 = (byte[])paramArrayOfObject[2];
/* 1276 */     int[] arrayOfInt1 = (int[])paramArrayOfObject[3];
/* 1277 */     long[] arrayOfLong = (long[])paramArrayOfObject[1];
/* 1278 */     Object[] arrayOfObject = (Object[])paramArrayOfObject[4];
/* 1279 */     int[] arrayOfInt2 = (int[])paramArrayOfObject[0];
/*      */ 
/* 1281 */     if (this.accessors != null)
/* 1282 */       for (int k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1284 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1289 */           if (this.accessors[k].lobPrefetchSizeForThisColumn >= 0)
/*      */           {
/* 1291 */             LobCommonAccessor localLobCommonAccessor = (LobCommonAccessor)this.accessors[k];
/*      */ 
/* 1293 */             if ((localLobCommonAccessor.prefetchedDataLength == null) || (localLobCommonAccessor.prefetchedDataLength.length < this.rowPrefetch))
/*      */             {
/* 1297 */               if (localLobCommonAccessor.internalType == 112) {
/* 1298 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse = new int[this.rowPrefetch];
/*      */               }
/* 1300 */               localLobCommonAccessor.prefetchedChunkSize = new int[this.rowPrefetch];
/* 1301 */               localLobCommonAccessor.prefetchedDataLength = new int[this.rowPrefetch];
/* 1302 */               localLobCommonAccessor.prefetchedLength = new long[this.rowPrefetch];
/* 1303 */               localLobCommonAccessor.prefetchedDataOffset = new long[this.rowPrefetch];
/*      */             }
/*      */ 
/* 1306 */             int m = j * i;
/* 1307 */             int n = this.needToRetainRows ? this.storedRowCount : 0;
/* 1308 */             for (int i1 = 0; i1 < j; i1++)
/*      */             {
/* 1310 */               localLobCommonAccessor.prefetchedChunkSize[(n + i1)] = arrayOfInt1[k];
/* 1311 */               localLobCommonAccessor.prefetchedLength[(n + i1)] = arrayOfLong[(m + i1)];
/*      */ 
/* 1313 */               if (localLobCommonAccessor.internalType == 112)
/*      */               {
/* 1315 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse[(n + i1)] = arrayOfByte1[k];
/*      */               }
/*      */ 
/* 1318 */               localLobCommonAccessor.prefetchedDataLength[i1] = 0;
/* 1319 */               if ((arrayOfInt2[k] > 0) && (arrayOfLong[(m + i1)] > 0L))
/*      */               {
/* 1322 */                 byte[] arrayOfByte2 = (byte[])arrayOfObject[(m + i1)];
/* 1323 */                 int i2 = arrayOfByte2 == null ? 0 : arrayOfByte2.length;
/* 1324 */                 if (i2 > 0)
/*      */                 {
/* 1326 */                   localLobCommonAccessor.setPrefetchedDataOffset(n + i1);
/* 1327 */                   localLobCommonAccessor.rowData.put(arrayOfByte2, 0, i2);
/*      */                 }
/* 1329 */                 localLobCommonAccessor.prefetchedDataLength[(n + i1)] = i2;
/*      */               }
/*      */             }
/* 1332 */             i++;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */   }
/*      */ 
/*      */   int getRowsToFetch()
/*      */   {
/* 1344 */     int i = -1;
/* 1345 */     if (this.hasStream)
/*      */     {
/* 1347 */       i = 1;
/* 1348 */       if (this.t2cConnection.useOCIDefaultDefines) {
/* 1349 */         this.savedRowPrefetch = 1;
/*      */       }
/*      */       else {
/* 1352 */         this.rowPrefetch = 1;
/*      */       }
/*      */     }
/* 1355 */     else if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/* 1359 */       if ((this.maxRows > 0) && (this.maxRows == this.storedRowCount))
/*      */       {
/* 1362 */         i = 0;
/*      */       }
/*      */       else {
/* 1365 */         i = this.rowPrefetch;
/*      */       }
/*      */ 
/*      */     }
/* 1369 */     else if ((this.maxRows > 0) && (this.maxRows < this.rowPrefetch + this.storedRowCount)) {
/* 1370 */       if ((this.storedRowCount < 1) && (this.maxRows < this.rowPrefetch)) {
/* 1371 */         i = this.maxRows;
/*      */       }
/*      */       else {
/* 1374 */         i = Math.min(this.rowPrefetch, this.maxRows - (this.rowPrefetch + this.storedRowCount));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1379 */       i = this.rowPrefetch;
/*      */     }
/*      */ 
/* 1382 */     return i;
/*      */   }
/*      */ 
/*      */   void doDefineFetch()
/*      */     throws SQLException
/*      */   {
/* 1389 */     int i = getRowsToFetch();
/*      */ 
/* 1392 */     this.validRows = 0;
/*      */ 
/* 1394 */     if (!this.needToPrepareDefineBuffer) {
/* 1395 */       throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
/*      */     }
/*      */ 
/* 1398 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1399 */     if (i > 0) {
/* 1400 */       setupForDefine();
/*      */ 
/* 1402 */       this.t2cOutput[2] = 0L;
/* 1403 */       this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1404 */       this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1405 */       if (this.connection.useNio) {
/* 1406 */         resetNioAttributesBeforeFetch();
/* 1407 */         allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */       }
/*      */ 
/* 1413 */       if (this.lobPrefetchMetaData == null) {
/* 1414 */         this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */       }
/* 1416 */       resetStateBeforeFetch();
/* 1417 */       this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, i, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1430 */       if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1431 */         this.t2cConnection.checkError(this.validRows);
/*      */       }
/*      */ 
/* 1435 */       if (this.t2cOutput[2] != 0L) {
/* 1436 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 1440 */       if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */       {
/* 1442 */         extractNioDefineBuffers(0);
/*      */       }
/* 1444 */       if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1445 */         copyStreamDataIntoDBA(0);
/*      */       }
/* 1447 */       if (this.lobPrefetchMetaData != null) {
/* 1448 */         processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */       }
/*      */     }
/* 1451 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */   }
/*      */ 
/*      */   void copyStreamDataIntoDBA(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1457 */     assert ((this.isFetchStreams) && (this.validRows == -2)) : ("isFetchStreams: " + this.isFetchStreams + "isScrollable(): " + this.realRsetType.isScrollable() + ", isUpdatable(): " + this.realRsetType.isUpdatable() + ", validRows=" + this.validRows);
/* 1458 */     checkValidRowsStatus();
/*      */ 
/* 1463 */     if (this.accessors != null)
/* 1464 */       for (Accessor localAccessor : this.accessors)
/* 1465 */         if (localAccessor != null)
/* 1466 */           switch (localAccessor.internalType) {
/*      */           case 8:
/* 1468 */             ((T2CLongAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/* 1469 */             break;
/*      */           case 24:
/* 1472 */             ((T2CLongRawAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/*      */           }
/*      */   }
/*      */ 
/*      */   void allocateNioBuffersIfRequired(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1483 */     if (this.nioBuffers == null) {
/* 1484 */       this.nioBuffers = new ByteBuffer[4];
/*      */     }
/* 1486 */     if (paramInt2 > 0)
/*      */     {
/* 1488 */       if ((this.nioBuffers[0] == null) || (this.nioBuffers[0].capacity() < paramInt2))
/*      */       {
/* 1491 */         this.nioBuffers[0] = ByteBuffer.allocateDirect(paramInt2);
/* 1492 */       } else if (this.nioBuffers[0] != null)
/*      */       {
/* 1494 */         this.nioBuffers[0].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1501 */     paramInt1 *= 2;
/* 1502 */     if (paramInt1 > 0)
/*      */     {
/* 1504 */       if ((this.nioBuffers[1] == null) || (this.nioBuffers[1].capacity() < paramInt1))
/*      */       {
/* 1507 */         this.nioBuffers[1] = ByteBuffer.allocateDirect(paramInt1);
/* 1508 */       } else if (this.nioBuffers[1] != null)
/*      */       {
/* 1510 */         this.nioBuffers[1].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1517 */     paramInt3 *= 2;
/* 1518 */     if (paramInt3 > 0)
/*      */     {
/* 1520 */       if ((this.nioBuffers[2] == null) || (this.nioBuffers[2].capacity() < paramInt3))
/*      */       {
/* 1523 */         this.nioBuffers[2] = ByteBuffer.allocateDirect(paramInt3);
/* 1524 */       } else if (this.nioBuffers[2] != null)
/*      */       {
/* 1526 */         this.nioBuffers[2].rewind();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doDefineExecuteFetch()
/*      */     throws SQLException
/*      */   {
/* 1535 */     short[] arrayOfShort = null;
/*      */ 
/* 1537 */     if ((this.needToPrepareDefineBuffer) || (this.needToParse))
/*      */     {
/* 1539 */       setupForDefine();
/*      */ 
/* 1541 */       arrayOfShort = this.t2cConnection.queryMetaData1;
/*      */     }
/*      */ 
/* 1544 */     this.t2cOutput[0] = 0L;
/* 1545 */     this.t2cOutput[2] = 0L;
/*      */ 
/* 1547 */     byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/* 1548 */     this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1549 */     this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1550 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/* 1551 */     if (this.connection.useNio) {
/* 1552 */       resetNioAttributesBeforeFetch();
/* 1553 */       allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */     }
/*      */ 
/* 1559 */     if (this.lobPrefetchMetaData == null) {
/* 1560 */       this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */     }
/* 1562 */     int i = getRowsToFetch();
/* 1563 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1564 */     this.validRows = 0;
/*      */     try {
/* 1566 */       resetStateBeforeFetch();
/* 1567 */       this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, arrayOfByte, arrayOfByte.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), i, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, arrayOfShort, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.preparedByteBinds, this.preparedCharBinds, this.accessors, this.parameterDatum, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1600 */       if (this.bindIndicators != null) {
/* 1601 */         setLengthForOutAccessors();
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1607 */       this.validRows = 0;
/*      */ 
/* 1609 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1610 */       localSQLException.fillInStackTrace();
/* 1611 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1615 */     if (this.validRows == -1) {
/* 1616 */       this.t2cConnection.checkError(this.validRows);
/*      */     }
/* 1618 */     if (this.t2cOutput[2] != 0L) {
/* 1619 */       this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */     }
/*      */ 
/* 1624 */     this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/* 1626 */     if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */     {
/* 1628 */       extractNioDefineBuffers(0);
/*      */     }
/* 1630 */     if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1631 */       copyStreamDataIntoDBA(0);
/*      */     }
/*      */ 
/* 1634 */     if (this.lobPrefetchMetaData != null)
/*      */     {
/* 1636 */       processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */     }
/*      */ 
/* 1639 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */ 
/* 1641 */     this.needToParse = false;
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1662 */     this.needToRetainRows = paramBoolean;
/* 1663 */     int i = getRowsToFetch();
/* 1664 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1665 */     this.validRows = 0;
/* 1666 */     if ((i > 0) && 
/* 1667 */       (this.numberOfDefinePositions > 0)) {
/* 1668 */       if (this.needToPrepareDefineBuffer) {
/* 1669 */         doDefineFetch();
/* 1670 */         this.needToPrepareDefineBuffer = false;
/*      */       }
/*      */       else {
/* 1673 */         this.t2cOutput[2] = 0L;
/* 1674 */         this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1675 */         this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1676 */         if (this.connection.useNio) {
/* 1677 */           resetNioAttributesBeforeFetch();
/* 1678 */           allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */         }
/*      */ 
/* 1685 */         if (this.lobPrefetchMetaData == null) {
/* 1686 */           this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */         }
/* 1688 */         resetStateBeforeFetch();
/* 1689 */         this.validRows = T2CStatement.t2cFetch(this, this.c_state, this.needToPrepareDefineBuffer, i, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1699 */         if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1700 */           this.t2cConnection.checkError(this.validRows);
/*      */         }
/* 1702 */         if (this.t2cOutput[2] != 0L)
/*      */         {
/* 1704 */           this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */         }
/*      */ 
/* 1707 */         if (this.lobPrefetchMetaData != null)
/*      */         {
/* 1709 */           processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */         }
/* 1711 */         if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */         {
/* 1713 */           extractNioDefineBuffers(0);
/*      */         }
/* 1715 */         if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1716 */           copyStreamDataIntoDBA(paramInt);
/*      */         }
/*      */       }
/*      */     }
/* 1720 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/* 1721 */     this.needToRetainRows = false;
/*      */   }
/*      */ 
/*      */   void resetNioAttributesBeforeFetch()
/*      */   {
/* 1728 */     this.extractedCharOffset = 0;
/* 1729 */     this.extractedByteOffset = 0;
/*      */   }
/*      */ 
/*      */   void extractNioDefineBuffers(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1738 */     if ((this.accessors == null) || (this.defineIndicators == null) || (paramInt == this.numberOfDefinePositions))
/*      */     {
/* 1741 */       return;
/*      */     }
/* 1743 */     int i = 0;
/* 1744 */     int j = 0;
/* 1745 */     int k = 0;
/* 1746 */     int m = 0;
/* 1747 */     int n = 0;
/*      */ 
/* 1750 */     if (!this.hasStream)
/*      */     {
/* 1752 */       i = this.defineBytes != null ? this.defineBytes.length : 0;
/* 1753 */       j = this.defineChars != null ? this.defineChars.length : 0;
/* 1754 */       k = this.defineIndicators.length;
/*      */     }
/*      */     else
/*      */     {
/* 1758 */       if (this.numberOfDefinePositions > paramInt)
/*      */       {
/* 1760 */         n = this.accessors[paramInt].indicatorIndex;
/* 1761 */         m = this.accessors[paramInt].lengthIndex;
/*      */       }
/*      */ 
/* 1766 */       for (int i1 = paramInt; i1 < this.numberOfDefinePositions; i1++)
/*      */       {
/* 1768 */         switch (this.accessors[i1].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1772 */           break;
/*      */         default:
/* 1774 */           i += this.accessors[i1].byteLength;
/* 1775 */           j += this.accessors[i1].charLength;
/* 1776 */           k++;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1781 */     ByteBuffer localByteBuffer = this.nioBuffers[0];
/* 1782 */     if ((localByteBuffer != null) && (this.defineBytes != null))
/*      */     {
/* 1784 */       if (i > 0)
/*      */       {
/* 1786 */         localByteBuffer.position(this.extractedByteOffset);
/* 1787 */         localByteBuffer.get(this.defineBytes, this.extractedByteOffset, i);
/* 1788 */         this.extractedByteOffset += i;
/*      */       }
/*      */     }
/*      */     Object localObject;
/* 1803 */     if ((this.nioBuffers[1] != null) && (this.defineChars != null))
/*      */     {
/* 1805 */       localByteBuffer = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
/* 1806 */       localObject = localByteBuffer.asCharBuffer();
/*      */ 
/* 1808 */       if (j > 0)
/*      */       {
/* 1810 */         ((CharBuffer)localObject).position(this.extractedCharOffset);
/* 1811 */         ((CharBuffer)localObject).get(this.defineChars, this.extractedCharOffset, j);
/* 1812 */         this.extractedCharOffset += j;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1817 */     if (this.nioBuffers[2] != null) {
/* 1818 */       localByteBuffer = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
/* 1819 */       localObject = localByteBuffer.asShortBuffer();
/* 1820 */       if (this.hasStream)
/*      */       {
/* 1822 */         if (k > 0)
/*      */         {
/* 1824 */           ((ShortBuffer)localObject).position(n);
/* 1825 */           ((ShortBuffer)localObject).get(this.defineIndicators, n, k);
/* 1826 */           ((ShortBuffer)localObject).position(m);
/* 1827 */           ((ShortBuffer)localObject).get(this.defineIndicators, m, k);
/*      */         }
/*      */       }
/*      */       else
/* 1831 */         ((ShortBuffer)localObject).get(this.defineIndicators);
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1879 */     if (this.defineBytes != null)
/*      */     {
/* 1881 */       this.defineBytes = null;
/*      */     }
/*      */ 
/* 1884 */     if (this.defineChars != null)
/*      */     {
/* 1886 */       this.defineChars = null;
/*      */     }
/*      */ 
/* 1889 */     if (this.defineIndicators != null)
/*      */     {
/* 1891 */       this.defineIndicators = null;
/*      */     }
/*      */ 
/* 1895 */     int i = T2CStatement.t2cCloseStatement(this.c_state);
/*      */ 
/* 1897 */     this.nioBuffers = null;
/*      */ 
/* 1899 */     if (i != 0) {
/* 1900 */       this.t2cConnection.checkError(i);
/*      */     }
/* 1902 */     this.t2cOutput = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 1914 */     this.connection.registerHeartbeat();
/* 1915 */     this.connection.needLine();
/*      */ 
/* 1918 */     if (this.streamList != null)
/* 1919 */       while (this.nextStream != null) {
/*      */         try {
/* 1921 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 1925 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1926 */           localSQLException.fillInStackTrace();
/* 1927 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1930 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */   }
/*      */ 
/*      */   void closeUsedStreams(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1942 */     while ((this.nextStream != null) && (this.nextStream.columnIndex < 1 + this.offsetOfFirstUserColumn + paramInt))
/*      */     {
/*      */       try
/*      */       {
/* 1948 */         this.nextStream.close();
/*      */       }
/*      */       catch (IOException localIOException1)
/*      */       {
/* 1953 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 1954 */         localSQLException.fillInStackTrace();
/* 1955 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1959 */       this.nextStream = this.nextStream.nextStream;
/*      */     }
/*      */ 
/* 1962 */     if (this.nextStream != null)
/*      */       try
/*      */       {
/* 1965 */         this.nextStream.needBytes();
/*      */       }
/*      */       catch (IOException localIOException2)
/*      */       {
/* 1969 */         interalCloseOnIOException(localIOException2);
/*      */ 
/* 1971 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 1972 */         localSQLException.fillInStackTrace();
/* 1973 */         throw localSQLException;
/*      */       }
/*      */   }
/*      */ 
/*      */   void interalCloseOnIOException(IOException paramIOException)
/*      */     throws SQLException
/*      */   {
/* 1982 */     this.closed = true;
/*      */ 
/* 1984 */     if (this.currentResultSet != null) {
/* 1985 */       this.currentResultSet.closed = true;
/*      */     }
/* 1987 */     doClose();
/*      */   }
/*      */ 
/*      */   void fetchDmlReturnParams()
/*      */     throws SQLException
/*      */   {
/* 1994 */     this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
/*      */ 
/* 1996 */     if (this.rowsDmlReturned != 0)
/*      */     {
/* 1998 */       allocateDmlReturnStorage();
/*      */ 
/* 2000 */       resetStateBeforeFetch();
/* 2001 */       int i = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this, this.accessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
/*      */ 
/* 2010 */       if ((i == -1) || (i == -4)) {
/* 2011 */         this.t2cConnection.checkError(i);
/*      */       }
/*      */ 
/* 2014 */       if (this.t2cOutput[2] != 0L)
/*      */       {
/* 2016 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 2020 */       if ((this.connection.useNio) && ((i > 0) || (i == -2)))
/*      */       {
/* 2022 */         extractNioDefineBuffers(0);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2028 */     AggregateByteArray localAggregateByteArray = (AggregateByteArray)this.bindData;
/* 2029 */     if (this.returnParamBytes != null)
/* 2030 */       localAggregateByteArray.setBytes(this.returnParamBytes);
/* 2031 */     ((T2CCharByteArray)localAggregateByteArray.extension).setChars(this.returnParamChars);
/* 2032 */     ((T2CCharByteArray)localAggregateByteArray.extension).setDBConversion(this.connection.conversion);
/*      */ 
/* 2034 */     int j = this.returnParamBytes == null ? 0 : this.returnParamBytes.length;
/* 2035 */     int k = 0;
/* 2036 */     int m = this.numReturnParams * this.rowsDmlReturned;
/* 2037 */     int n = 0;
/* 2038 */     int i1 = j;
/* 2039 */     int i2 = 0;
/* 2040 */     for (int i3 = 0; i3 < this.numberOfBindPositions; i3++)
/*      */     {
/* 2042 */       Accessor localAccessor = this.accessors[i3];
/* 2043 */       if (localAccessor != null)
/*      */       {
/* 2045 */         localAccessor.setCapacity(this.rowsDmlReturned);
/* 2046 */         for (int i4 = 0; i4 < this.rowsDmlReturned; i4++)
/*      */         {
/* 2049 */           if ((localAccessor.internalType == 109) || (localAccessor.internalType == 111))
/*      */           {
/* 2052 */             i2++;
/*      */           }
/*      */           else
/*      */           {
/* 2056 */             int i5 = this.returnParamIndicators[(m++)];
/* 2057 */             int i6 = this.returnParamIndicators[(k++)] == -1 ? 1 : 0;
/* 2058 */             int i7 = 0;
/* 2059 */             if (localAccessor.internalType == 104)
/* 2060 */               i7 = 2;
/* 2061 */             else if ((localAccessor.defineType == 6) || (localAccessor.defineType == 9) || (localAccessor.defineType == 1))
/*      */             {
/* 2063 */               i7 = 1;
/*      */             }
/*      */ 
/* 2072 */             if (localAccessor.charLength > 0)
/*      */             {
/* 2082 */               localAccessor.setOffset(i4, i1 + i7);
/* 2083 */               i1 += localAccessor.charLength;
/*      */             }
/*      */             else
/*      */             {
/* 2094 */               localAccessor.setOffset(i4, n + i7);
/* 2095 */               n += localAccessor.byteLength;
/*      */             }
/*      */ 
/* 2098 */             if ((i6 != 0) || (i5 == 0))
/*      */             {
/* 2100 */               localAccessor.setLengthAndNull(i4, 0);
/*      */             }
/*      */             else {
/* 2103 */               if (localAccessor.internalType == 1) i5 /= 2;
/*      */ 
/* 2105 */               localAccessor.setLengthAndNull(i4, i5);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2114 */     this.returnParamsFetched = true;
/*      */   }
/*      */ 
/*      */   void processDmlReturningBind()
/*      */     throws SQLException
/*      */   {
/* 2129 */     super.processDmlReturningBind();
/* 2130 */     this.returnParamRowBytes = 0;
/* 2131 */     this.returnParamRowChars = 0;
/*      */ 
/* 2133 */     for (int i = 0; i < this.numberOfBindPositions; i++)
/*      */     {
/* 2135 */       Accessor localAccessor = this.accessors[i];
/*      */ 
/* 2137 */       if (localAccessor != null)
/*      */       {
/* 2139 */         if (localAccessor.charLength > 0)
/*      */         {
/* 2141 */           this.returnParamRowChars += localAccessor.charLength;
/*      */         }
/*      */         else
/*      */         {
/* 2145 */           this.returnParamRowBytes += localAccessor.byteLength;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2151 */     this.returnParamMeta[1] = this.returnParamRowBytes;
/* 2152 */     this.returnParamMeta[2] = this.returnParamRowChars;
/*      */   }
/*      */ 
/*      */   void allocateDmlReturnStorage()
/*      */   {
/* 2161 */     if (this.rowsDmlReturned == 0) return;
/*      */ 
/* 2163 */     int i = this.returnParamRowBytes * this.rowsDmlReturned;
/* 2164 */     int j = this.returnParamRowChars * this.rowsDmlReturned;
/* 2165 */     int k = 2 * this.numReturnParams * this.rowsDmlReturned;
/*      */ 
/* 2167 */     this.returnParamBytes = new byte[i];
/* 2168 */     this.returnParamChars = new char[j];
/* 2169 */     this.returnParamIndicators = new short[k];
/*      */ 
/* 2172 */     for (int m = 0; m < this.numberOfBindPositions; m++)
/*      */     {
/* 2174 */       Accessor localAccessor = this.accessors[m];
/* 2175 */       if (localAccessor != null)
/* 2176 */         localAccessor.setCapacity(this.rowsDmlReturned);
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanupReturnParameterBuffers()
/*      */   {
/* 2183 */     this.returnParamBytes = null;
/* 2184 */     this.returnParamChars = null;
/* 2185 */     this.returnParamIndicators = null;
/*      */   }
/*      */ 
/*      */   void initializeIndicatorSubRange()
/*      */   {
/* 2203 */     this.bindIndicatorSubRange = (this.numberOfBindPositions * PREAMBLE_PER_POSITION);
/*      */   }
/*      */ 
/*      */   int calculateIndicatorSubRangeSize()
/*      */   {
/* 2210 */     return this.numberOfBindPositions * PREAMBLE_PER_POSITION;
/*      */   }
/*      */ 
/*      */   short getInoutIndicator(int paramInt)
/*      */   {
/* 2217 */     return this.bindIndicators[(paramInt * PREAMBLE_PER_POSITION)];
/*      */   }
/*      */ 
/*      */   void resetStateBeforeFetch()
/*      */   {
/* 2223 */     this.lastProcessedCell = 0;
/* 2224 */     this.lastProcessedAccessorIndex = 0;
/* 2225 */     this.accessorsProcessed = 0;
/* 2226 */     this.previousMode = 0;
/* 2227 */     if (this.rowData != null)
/* 2228 */       if (this.needToRetainRows) {
/* 2229 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*      */       else
/* 2232 */         this.rowData.reset();
/*      */   }
/*      */ 
/*      */   public int updateData(int paramInt1, int paramInt2, int paramInt3, int[] paramArrayOfInt, byte[] paramArrayOfByte)
/*      */   {
/*      */     try
/*      */     {
/* 2263 */       if (this.previousMode != paramInt1) {
/* 2264 */         this.accessorsProcessed = 0;
/*      */       }
/* 2266 */       this.previousMode = paramInt1;
/*      */ 
/* 2268 */       int i = 0;
/* 2269 */       int j = 0;
/* 2270 */       int k = 0;
/* 2271 */       int m = 0;
/* 2272 */       int n = 0;
/*      */       int i1;
/*      */       Object localObject1;
/* 2274 */       switch (paramInt1)
/*      */       {
/*      */       case 16:
/*      */       case 32:
/* 2279 */         for (i1 = 0; 
/* 2280 */           i1 < paramInt2; 
/* 2281 */           i1++)
/*      */         {
/* 2283 */           j = paramArrayOfInt[(i1 * 4 + 0)];
/* 2284 */           k = paramArrayOfInt[(i1 * 4 + 1)];
/* 2285 */           m = paramArrayOfInt[(i1 * 4 + 2)];
/* 2286 */           n = paramArrayOfInt[(i1 * 4 + 3)] == -1 ? 1 : 0;
/* 2287 */           localObject1 = this.accessors[k];
/*      */ 
/* 2293 */           ((Accessor)localObject1).setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j);
/*      */ 
/* 2297 */           if (m > 0)
/*      */           {
/* 2300 */             switch (((Accessor)localObject1).defineType)
/*      */             {
/*      */             case 1:
/*      */             case 23:
/*      */             case 96:
/*      */             case 104:
/* 2308 */               i += 2;
/* 2309 */               m -= 2;
/* 2310 */               break;
/*      */             case 6:
/* 2313 */               i++;
/* 2314 */               m--;
/*      */             }
/*      */ 
/* 2321 */             this.rowData.put(paramArrayOfByte, i, m);
/*      */ 
/* 2323 */             i += m;
/*      */           }
/* 2325 */           ((Accessor)localObject1).setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/* 2326 */           this.accessorsProcessed += 1;
/*      */ 
/* 2281 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/* 2328 */         break;
/*      */       case 64:
/* 2334 */         i1 = 0;
/* 2335 */         localObject1 = null;
/* 2336 */         if (this.outBindAccessors != null) {
/* 2337 */           i1 = (this.bindBytes == null ? 0 : this.bindBytes.length) + (this.bindChars == null ? 0 : this.bindChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2341 */           localObject1 = this.outBindAccessors;
/*      */         }
/*      */         else {
/* 2344 */           i1 = (this.returnParamBytes == null ? 0 : this.returnParamBytes.length) + (this.returnParamChars == null ? 0 : this.returnParamChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2348 */           localObject1 = this.accessors;
/*      */         }
/* 2350 */         assert (localObject1 != null) : "No OUT binds or Return Parameters";
/* 2351 */         ByteArray localByteArray = this.bindData;
/*      */         do
/*      */         {
/* 2355 */           if (!(localByteArray instanceof AggregateByteArray))
/*      */             break;
/* 2357 */           localByteArray = ((AggregateByteArray)localByteArray).extension;
/*      */         }
/* 2359 */         while (localByteArray != null);
/*      */ 
/* 2361 */         i1 = (int)(i1 + localByteArray.getPosition());
/* 2362 */         int i2 = this.accessorsProcessed;
/* 2363 */         for (int i3 = 0; 
/* 2364 */           i3 < paramInt2; 
/* 2365 */           i3++)
/*      */         {
/* 2367 */           j = paramArrayOfInt[(i3 * 4 + 0)];
/* 2368 */           k = paramArrayOfInt[(i3 * 4 + 1)];
/* 2369 */           m = paramArrayOfInt[(i3 * 4 + 2)];
/* 2370 */           n = paramArrayOfInt[(i3 * 4 + 3)] == -1 ? 1 : 0;
/* 2371 */           Object localObject2 = localObject1[k];
/*      */ 
/* 2376 */           localObject2.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j, i1);
/* 2377 */           localByteArray.put(paramArrayOfByte, i, m);
/* 2378 */           localObject2.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/*      */ 
/* 2380 */           i += m;
/* 2381 */           i1 += m;
/*      */ 
/* 2365 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2387 */       this.updateDataException = localSQLException;
/* 2388 */       return -3;
/*      */     }
/* 2390 */     return 0;
/*      */   }
/*      */ 
/*      */   final boolean bit(long paramLong1, long paramLong2)
/*      */   {
/* 2395 */     return (paramLong1 & paramLong2) == paramLong1;
/*      */   }
/*      */ 
/*      */   public static String toHex(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/* 2400 */     if (paramArrayOfByte == null)
/* 2401 */       return "null";
/* 2402 */     if (paramInt > paramArrayOfByte.length)
/* 2403 */       return "byte array not long enough";
/* 2404 */     String str = "0:";
/* 2405 */     int i = paramInt;
/* 2406 */     for (int j = 0; j < i; j++)
/*      */     {
/* 2408 */       if ((j != 0) && (j % 10 == 0)) str = str + "\n" + j + ": ";
/* 2409 */       str = str + OracleLog.toHex(paramArrayOfByte[j]) + " ";
/*      */     }
/* 2411 */     return str;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2425 */     Object localObject = null;
/*      */     SQLException localSQLException;
/* 2427 */     switch (paramInt1)
/*      */     {
/*      */     case 102:
/*      */     case 116:
/* 2432 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2434 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2435 */         localSQLException.fillInStackTrace();
/* 2436 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2439 */       localObject = new T2CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2442 */       return localObject;
/*      */     case 8:
/* 2446 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2448 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2449 */         localSQLException.fillInStackTrace();
/* 2450 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2453 */       if (paramBoolean) {
/* 2454 */         return new VarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */       }
/*      */ 
/* 2457 */       return new T2CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     case 1:
/* 2463 */       if (paramBoolean)
/*      */       {
/* 2465 */         if (paramString != null)
/*      */         {
/* 2468 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2469 */           localSQLException.fillInStackTrace();
/* 2470 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2475 */         localObject = new T2CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2477 */         return localObject;
/*      */       }
/*      */ 
/*      */       break;
/*      */     case 24:
/* 2483 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2485 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2486 */         localSQLException.fillInStackTrace();
/* 2487 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2490 */       if (paramBoolean) {
/* 2491 */         return new OutRawAccessor(this, paramInt4, paramShort, paramInt2);
/*      */       }
/*      */ 
/* 2494 */       return new T2CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     }
/*      */ 
/* 2501 */     return super.allocateAccessor(paramInt1, paramInt2, paramInt3, paramInt4, paramShort, paramString, paramBoolean);
/*      */   }
/*      */ 
/*      */   void prepareBindPreambles(int paramInt1, int paramInt2)
/*      */   {
/* 2514 */     int i = calculateIndicatorSubRangeSize();
/* 2515 */     int j = this.bindIndicatorSubRange - i;
/* 2516 */     OracleTypeADT[] arrayOfOracleTypeADT = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
/*      */ 
/* 2520 */     for (int k = 0; k < this.numberOfBindPositions; k++)
/*      */     {
/* 2523 */       Binder localBinder = this.lastBinders[k];
/*      */       OracleTypeADT localOracleTypeADT;
/*      */       short s;
/* 2526 */       if (localBinder == this.theReturnParamBinder)
/*      */       {
/* 2528 */         localOracleTypeADT = (OracleTypeADT)this.accessors[k].internalOtype;
/* 2529 */         s = 0;
/*      */       }
/*      */       else
/*      */       {
/* 2533 */         localOracleTypeADT = arrayOfOracleTypeADT == null ? null : arrayOfOracleTypeADT[k];
/*      */ 
/* 2535 */         if (this.outBindAccessors == null) {
/* 2536 */           s = 0;
/*      */         }
/*      */         else {
/* 2539 */           Accessor localAccessor = this.outBindAccessors[k];
/*      */ 
/* 2541 */           if (localAccessor == null) {
/* 2542 */             s = 0;
/* 2543 */           } else if (localBinder == this.theOutBinder)
/*      */           {
/* 2545 */             s = 1;
/*      */ 
/* 2547 */             if (localOracleTypeADT == null)
/* 2548 */               localOracleTypeADT = (OracleTypeADT)localAccessor.internalOtype;
/*      */           }
/*      */           else {
/* 2551 */             s = 2;
/*      */           }
/*      */         }
/* 2553 */         s = localBinder.updateInoutIndicatorValue(s);
/*      */       }
/*      */ 
/* 2556 */       this.bindIndicators[(j++)] = s;
/*      */ 
/* 2558 */       if (localOracleTypeADT != null)
/*      */       {
/* 2560 */         long l = localOracleTypeADT.getTdoCState();
/*      */ 
/* 2562 */         this.bindIndicators[(j + 0)] = ((short)(int)(l >> 48 & 0xFFFF));
/*      */ 
/* 2564 */         this.bindIndicators[(j + 1)] = ((short)(int)(l >> 32 & 0xFFFF));
/*      */ 
/* 2566 */         this.bindIndicators[(j + 2)] = ((short)(int)(l >> 16 & 0xFFFF));
/*      */ 
/* 2568 */         this.bindIndicators[(j + 3)] = ((short)(int)(l & 0xFFFF));
/*      */       }
/*      */ 
/* 2571 */       j += 4;
/*      */     }
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/* 2579 */     super.releaseBuffers();
/*      */   }
/*      */ 
/*      */   void setLengthForOutAccessors()
/*      */     throws SQLException
/*      */   {
/* 2588 */     if (this.outBindAccessors == null) return;
/* 2589 */     Accessor localAccessor = null;
/*      */ 
/* 2591 */     for (int i = 0; 
/* 2592 */       i < this.numberOfBindPositions; 
/* 2593 */       i++)
/*      */     {
/* 2596 */       localAccessor = this.outBindAccessors[i];
/* 2597 */       if (localAccessor != null)
/*      */       {
/* 2599 */         if ((localAccessor.defineType != 998) && (localAccessor.defineType != 111) && (localAccessor.defineType != 109))
/*      */         {
/* 2606 */           for (int j = 0; j < this.binders.length; j++)
/*      */           {
/* 2608 */             int k = localAccessor.rowSpaceIndicator[(localAccessor.indicatorIndex + j)] == -1 ? 1 : 0;
/* 2609 */             int m = k != 0 ? 0 : localAccessor.rowSpaceIndicator[(localAccessor.lengthIndex + j)] & 0xFFFF;
/*      */ 
/* 2617 */             if ((this.sqlKind != OracleStatement.SqlKind.CALL_BLOCK) && (localAccessor.externalType == -8))
/*      */             {
/* 2622 */               localAccessor.setLengthAndNull(j, m);
/* 2623 */             } else if ((localAccessor.defineType == 9) || (localAccessor.defineType == 1))
/*      */             {
/* 2626 */               localAccessor.setLengthAndNull(j, m / 2);
/* 2627 */             } else if ((localAccessor.defineType != 109) && (localAccessor.defineType != 111))
/*      */             {
/* 2630 */               localAccessor.setLengthAndNull(j, m);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2655 */     if (this.closed)
/*      */     {
/* 2657 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 2658 */       localSQLException.fillInStackTrace();
/* 2659 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2662 */     if (this.described == true)
/*      */     {
/* 2664 */       return;
/*      */     }
/*      */ 
/* 2667 */     if (!this.isOpen)
/*      */     {
/* 2671 */       this.connection.open(this);
/* 2672 */       this.isOpen = true;
/*      */     }
/*      */ 
/*      */     int i;
/*      */     do
/*      */     {
/* 2680 */       i = 0;
/*      */ 
/* 2689 */       boolean bool = (this.sqlKind.isSELECT()) && (this.needToParse) && ((!this.described) || (!this.serverCursor));
/* 2690 */       byte[] arrayOfByte = bool ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
/* 2691 */       this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, arrayOfByte, arrayOfByte.length, bool);
/*      */ 
/* 2702 */       if (!this.described) {
/* 2703 */         this.described = true;
/*      */       }
/*      */ 
/* 2710 */       if (this.numberOfDefinePositions == -1)
/*      */       {
/* 2712 */         this.t2cConnection.checkError(this.numberOfDefinePositions);
/*      */       }
/*      */ 
/* 2716 */       if (this.numberOfDefinePositions == T2C_EXTEND_BUFFER)
/*      */       {
/* 2718 */         i = 1;
/*      */ 
/* 2722 */         this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * 2, this.t2cConnection.queryMetaData2Size * 2);
/*      */       }
/*      */     }
/*      */ 
/* 2726 */     while (i != 0);
/*      */ 
/* 2728 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   protected void configureRowData()
/*      */   {
/* 2734 */     super.configureRowData();
/*      */ 
/* 2744 */     DynamicByteArray localDynamicByteArray = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
/*      */ 
/* 2746 */     T2CCharByteArray localT2CCharByteArray1 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localDynamicByteArray);
/*      */ 
/* 2748 */     AggregateByteArray localAggregateByteArray = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray1);
/*      */ 
/* 2751 */     T2CCharByteArray localT2CCharByteArray2 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localAggregateByteArray);
/*      */ 
/* 2755 */     this.bindData = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray2);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CPreparedStatement
 * JD-Core Version:    0.6.2
 */