/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ class T2CPlsqlIndexTableAccessor extends PlsqlIndexTableAccessor
/*     */ {
/*     */   int ibtMetaIndex;
/* 187 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T2CPlsqlIndexTableAccessor(OracleStatement paramOracleStatement, PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  46 */     super(paramOracleStatement, paramPlsqlIbtBindInfo, paramShort);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  55 */     unimpl("initForDataAccess");
/*     */   }
/*     */ 
/*     */   Object[] getPlsqlIndexTable(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  64 */     short[] arrayOfShort = this.statement.ibtBindIndicators;
/*  65 */     int i = ((arrayOfShort[(this.ibtMetaIndex + 4)] & 0xFFFF) << 16) + (arrayOfShort[(this.ibtMetaIndex + 5)] & 0xFFFF);
/*     */ 
/*  68 */     long l = getOffset(paramInt);
/*  69 */     int j = this.ibtBindInfo.elemMaxLen;
/*     */     Object localObject;
/*     */     int m;
/*  72 */     switch (this.ibtBindInfo.element_internal_type)
/*     */     {
/*     */     case 9:
/*  76 */       int[] arrayOfInt = new int[1];
/*  77 */       localObject = new String[i];
/*  78 */       for (m = 0; m < i; m++) {
/*  79 */         this.rowData.setPosition(l);
/*  80 */         char[] arrayOfChar = this.rowData.getChars(l, 1, this.statement.connection.conversion.getCharacterSet((short)1), arrayOfInt);
/*     */ 
/*  84 */         int n = arrayOfChar[0] / '\002';
/*  85 */         this.rowData.setPosition(l + 1L);
/*  86 */         if (n == 0) localObject[m] = null; else {
/*  87 */           localObject[m] = this.rowData.getString(n, this.statement.connection.conversion.getCharacterSet(1));
/*     */         }
/*  89 */         l += j;
/*     */       }
/*  91 */       break;
/*     */     case 6:
/*  94 */       localObject = new BigDecimal[i];
/*  95 */       for (int k = 0; k < i; k++) {
/*  96 */         this.rowData.setPosition(l);
/*  97 */         m = this.rowData.get() & 0xFF;
/*  98 */         if (m == 0) localObject[k] = null; else
/*  99 */           localObject[k] = NUMBER.toBigDecimal(this.rowData.getBytes(m));
/* 100 */         l += j;
/*     */       }
/* 102 */       break;
/*     */     default:
/* 106 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/* 107 */       localSQLException.fillInStackTrace();
/* 108 */       throw localSQLException;
/*     */     }
/*     */ 
/* 111 */     return localObject;
/*     */   }
/*     */ 
/*     */   Datum[] getOraclePlsqlIndexTable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 129 */     short[] arrayOfShort = this.statement.ibtBindIndicators;
/* 130 */     int i = ((arrayOfShort[(this.ibtMetaIndex + 4)] & 0xFFFF) << 16) + (arrayOfShort[(this.ibtMetaIndex + 5)] & 0xFFFF);
/*     */ 
/* 133 */     long l = getOffset(paramInt);
/* 134 */     int j = this.ibtBindInfo.elemMaxLen;
/*     */ 
/* 136 */     Object localObject = null;
/* 137 */     switch (this.ibtBindInfo.element_internal_type)
/*     */     {
/*     */     case 9:
/* 141 */       int[] arrayOfInt = new int[1];
/* 142 */       localObject = new CHAR[i];
/* 143 */       CharacterSet localCharacterSet = this.statement.connection.conversion.getDriverCharSetObj();
/* 144 */       for (int n = 0; n < i; n++) {
/* 145 */         this.rowData.setPosition(l);
/* 146 */         char[] arrayOfChar = this.rowData.getChars(l, 1, this.statement.connection.conversion.getCharacterSet((short)1), arrayOfInt);
/*     */ 
/* 150 */         int i1 = arrayOfChar[0] / '\002';
/* 151 */         this.rowData.setPosition(l + 1L);
/* 152 */         if (i1 == 0) { localObject[n] = null;
/*     */         } else
/*     */         {
/* 155 */           String str = this.rowData.getString(i1, this.statement.connection.conversion.getCharacterSet((short)1));
/*     */ 
/* 157 */           localObject[n] = new CHAR(str, localCharacterSet);
/*     */         }
/* 159 */         l += j;
/*     */       }
/* 161 */       break;
/*     */     case 6:
/* 164 */       localObject = new NUMBER[i];
/* 165 */       for (int k = 0; k < i; k++) {
/* 166 */         this.rowData.setPosition(l);
/* 167 */         int m = this.rowData.get() & 0xFF;
/* 168 */         if (m == 0) localObject[k] = null; else
/* 169 */           localObject[k] = new NUMBER(this.rowData.getBytes(m));
/* 170 */         l += j;
/*     */       }
/* 172 */       break;
/*     */     default:
/* 176 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/* 177 */       localSQLException.fillInStackTrace();
/* 178 */       throw localSQLException;
/*     */     }
/*     */ 
/* 181 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CPlsqlIndexTableAccessor
 * JD-Core Version:    0.6.2
 */