/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T2CLongRawAccessor extends LongRawAccessor
/*     */ {
/* 211 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T2CLongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3)
/*     */     throws SQLException
/*     */   {
/*  39 */     super(paramOracleStatement, paramInt1, paramInt2, paramShort, paramInt3);
/*     */   }
/*     */ 
/*     */   T2CLongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  47 */     super(paramOracleStatement, paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort);
/*     */   }
/*     */ 
/*     */   byte[] getBytesInternal(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  56 */     if (this.statement.isFetchStreams) {
/*  57 */       assert (!isNull(paramInt));
/*  58 */       int i = getLength(paramInt);
/*  59 */       long l = getOffset(paramInt);
/*  60 */       return this.rowData.get(l, i);
/*     */     }
/*     */ 
/*  63 */     return super.getBytesInternal(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  72 */     if (this.statement.isFetchStreams) {
/*  73 */       if (isNull(paramInt)) return null;
/*  74 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/*  78 */         return this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, 2); } finally {
/*     */         try {
/*  80 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/*  83 */     return super.getAsciiStream(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  93 */     if (this.statement.isFetchStreams) {
/*  94 */       if (isNull(paramInt)) return null;
/*  95 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/*  99 */         return this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, 3); } finally {
/*     */         try {
/* 101 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 104 */     return super.getUnicodeStream(paramInt);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 114 */     if (this.statement.isFetchStreams) {
/* 115 */       if (isNull(paramInt)) return null;
/* 116 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/* 120 */         return this.statement.connection.conversion.ConvertCharacterStream(localByteArrayInputStream, 8, this.formOfUse); } finally {
/*     */         try {
/* 122 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 125 */     return super.getCharacterStream(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 135 */     if (this.statement.isFetchStreams) {
/* 136 */       if (isNull(paramInt)) return null;
/* 137 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */ 
/* 140 */       return localByteArrayInputStream;
/*     */     }
/*     */ 
/* 149 */     return super.getBinaryStream(paramInt);
/*     */   }
/*     */ 
/*     */   void copyStreamDataIntoDBA(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 156 */     if (this.stream.closed)
/*     */     {
/* 158 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 159 */       ((SQLException)localObject1).fillInStackTrace();
/* 160 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/* 164 */     Object localObject1 = null;
/* 165 */     byte[] arrayOfByte1 = null;
/*     */     try {
/* 167 */       localObject1 = new ByteArrayOutputStream(1024);
/* 168 */       byte[] arrayOfByte2 = this.statement.connection.getByteBuffer(32768);
/*     */       try
/*     */       {
/* 172 */         int i;
/* 172 */         while ((i = this.stream.read(arrayOfByte2, 0, 32768)) != -1) ((ByteArrayOutputStream)localObject1).write(arrayOfByte2, 0, i);
/* 173 */         this.statement.connection.cacheBuffer(arrayOfByte2);
/*     */       }
/*     */       catch (IOException localIOException2)
/*     */       {
/* 177 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 178 */         localSQLException.fillInStackTrace();
/* 179 */         throw localSQLException;
/*     */       }
/*     */ 
/* 182 */       arrayOfByte1 = ((ByteArrayOutputStream)localObject1).toByteArray();
/*     */     } finally {
/*     */       try {
/* 185 */         if (localObject1 != null) ((ByteArrayOutputStream)localObject1).close();  } catch (IOException localIOException3) {  }
/*     */ 
/*     */     }
/* 187 */     if ((arrayOfByte1 == null) || (arrayOfByte1.length == 0)) {
/* 188 */       setLengthAndNull(paramInt, 0);
/*     */     }
/*     */     else {
/* 191 */       setOffset(paramInt);
/* 192 */       setLengthAndNull(paramInt, arrayOfByte1.length);
/* 193 */       this.rowData.put(arrayOfByte1);
/*     */     }
/*     */   }
/*     */ 
/*     */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*     */   {
/* 200 */     LongRawAccessor localLongRawAccessor = (LongRawAccessor)super.copyForDefine(paramOracleStatement);
/*     */     try {
/* 202 */       localLongRawAccessor.stream = paramOracleStatement.connection.driverExtension.createInputStream(paramOracleStatement, this.columnPosition, localLongRawAccessor);
/*     */     }
/*     */     catch (SQLException localSQLException) {
/*     */     }
/* 206 */     return localLongRawAccessor;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CLongRawAccessor
 * JD-Core Version:    0.6.2
 */