/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T2CLongAccessor extends LongAccessor
/*     */ {
/* 211 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T2CLongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(paramOracleStatement, paramInt1, paramInt2, paramShort, paramInt3);
/*     */   }
/*     */ 
/*     */   T2CLongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  48 */     super(paramOracleStatement, paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort);
/*     */   }
/*     */ 
/*     */   byte[] getBytesInternal(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  57 */     if (this.statement.isFetchStreams) {
/*  58 */       assert (!isNull(paramInt));
/*  59 */       int i = getLength(paramInt);
/*  60 */       long l = getOffset(paramInt);
/*  61 */       return this.rowData.get(l, i);
/*     */     }
/*     */ 
/*  64 */     return super.getBytesInternal(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  73 */     if (this.statement.isFetchStreams) {
/*  74 */       if (isNull(paramInt)) return null;
/*  75 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/*  79 */         return this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, 0); } finally {
/*     */         try {
/*  81 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/*  84 */     return super.getAsciiStream(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  94 */     if (this.statement.isFetchStreams) {
/*  95 */       if (isNull(paramInt)) return null;
/*  96 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/* 100 */         return this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, 1); } finally {
/*     */         try {
/* 102 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 105 */     return super.getUnicodeStream(paramInt);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 115 */     if (this.statement.isFetchStreams) {
/* 116 */       if (isNull(paramInt)) return null;
/* 117 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/* 121 */         return this.statement.connection.conversion.ConvertCharacterStream(localByteArrayInputStream, 9, this.formOfUse); } finally {
/*     */         try {
/* 123 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 126 */     return super.getCharacterStream(paramInt);
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 136 */     if (this.statement.isFetchStreams) {
/* 137 */       if (isNull(paramInt)) return null;
/* 138 */       ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */       try
/*     */       {
/* 142 */         return this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, 6); } finally {
/*     */         try {
/* 144 */           if (localByteArrayInputStream != null) localByteArrayInputStream.close();  } catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 147 */     return super.getBinaryStream(paramInt);
/*     */   }
/*     */ 
/*     */   void copyStreamDataIntoDBA(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 156 */     if (this.stream.closed)
/*     */     {
/* 158 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 159 */       ((SQLException)localObject1).fillInStackTrace();
/* 160 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/* 164 */     Object localObject1 = null;
/* 165 */     byte[] arrayOfByte1 = null;
/*     */     try {
/* 167 */       localObject1 = new ByteArrayOutputStream(1024);
/* 168 */       byte[] arrayOfByte2 = this.statement.connection.getByteBuffer(32768);
/*     */       try
/*     */       {
/* 172 */         int i;
/* 172 */         while ((i = this.stream.read(arrayOfByte2, 0, 32768)) != -1) ((ByteArrayOutputStream)localObject1).write(arrayOfByte2, 0, i);
/* 173 */         this.statement.connection.cacheBuffer(arrayOfByte2);
/*     */       }
/*     */       catch (IOException localIOException2)
/*     */       {
/* 177 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 178 */         localSQLException.fillInStackTrace();
/* 179 */         throw localSQLException;
/*     */       }
/*     */ 
/* 182 */       arrayOfByte1 = ((ByteArrayOutputStream)localObject1).toByteArray();
/*     */     } finally {
/*     */       try {
/* 185 */         if (localObject1 != null) ((ByteArrayOutputStream)localObject1).close();  } catch (IOException localIOException3) {  }
/*     */ 
/*     */     }
/* 187 */     if ((arrayOfByte1 == null) || (arrayOfByte1.length == 0)) {
/* 188 */       setLengthAndNull(paramInt, 0);
/*     */     }
/*     */     else {
/* 191 */       setOffset(paramInt);
/* 192 */       setLengthAndNull(paramInt, arrayOfByte1.length);
/* 193 */       this.rowData.put(arrayOfByte1);
/*     */     }
/*     */   }
/*     */ 
/*     */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*     */   {
/* 200 */     LongAccessor localLongAccessor = (LongAccessor)super.copyForDefine(paramOracleStatement);
/*     */     try {
/* 202 */       localLongAccessor.stream = paramOracleStatement.connection.driverExtension.createInputStream(paramOracleStatement, this.columnPosition, localLongAccessor);
/*     */     }
/*     */     catch (SQLException localSQLException) {
/*     */     }
/* 206 */     return localLongAccessor;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CLongAccessor
 * JD-Core Version:    0.6.2
 */