/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class T2CInputStream extends OracleInputStream
/*     */ {
/* 215 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   native int t2cGetBytes(long paramLong1, int paramInt1, byte[] paramArrayOfByte, int paramInt2, Accessor[] paramArrayOfAccessor, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2, long paramLong2);
/*     */ 
/*     */   T2CInputStream(OracleStatement paramOracleStatement, int paramInt, Accessor paramAccessor)
/*     */   {
/*  72 */     super(paramOracleStatement, paramInt, paramAccessor);
/*     */   }
/*     */ 
/*     */   private int getRowNumber()
/*     */   {
/*  79 */     int i = 0;
/*  80 */     if (this.statement.isFetchStreams) {
/*  81 */       if ((this.statement instanceof T2CStatement)) {
/*  82 */         if (((T2CStatement)this.statement).needToRetainRows) i = this.statement.storedRowCount;
/*     */       }
/*  84 */       else if ((this.statement instanceof T2CPreparedStatement)) {
/*  85 */         if (((T2CPreparedStatement)this.statement).needToRetainRows) i = this.statement.storedRowCount;
/*     */ 
/*     */       }
/*  88 */       else if (((T2CCallableStatement)this.statement).needToRetainRows) i = this.statement.storedRowCount;
/*     */     }
/*     */ 
/*  91 */     return i;
/*     */   }
/*     */ 
/*     */   public int getBytes(int paramInt) throws IOException
/*     */   {
/*  96 */     synchronized (this.statement.connection)
/*     */     {
/*  99 */       if (paramInt > this.currentBufferSize)
/*     */       {
/* 101 */         this.currentBufferSize = Math.max(paramInt, this.initialBufferSize);
/* 102 */         this.resizableBuffer = new byte[this.currentBufferSize];
/*     */       }
/* 104 */       long l = this.statement.connection.useNio ? 1 : 0;
/* 105 */       if (this.statement.connection.useNio)
/*     */       {
/* 107 */         if ((this.statement.nioBuffers[3] == null) || (this.statement.nioBuffers[3].capacity() < this.resizableBuffer.length))
/*     */         {
/* 110 */           this.statement.nioBuffers[3] = ByteBuffer.allocateDirect(this.resizableBuffer.length);
/*     */         }
/*     */         else {
/* 113 */           this.statement.nioBuffers[3].rewind();
/*     */         }
/*     */       }
/* 116 */       int i = 0;
/* 117 */       i = t2cGetBytes(this.statement.c_state, this.columnIndex, this.resizableBuffer, this.currentBufferSize, this.statement.accessors, this.statement.nioBuffers, this.statement.lobPrefetchMetaData, l);
/*     */ 
/* 124 */       int j = 0;
/*     */       try
/*     */       {
/* 134 */         int k = getRowNumber();
/*     */ 
/* 136 */         if (i == -1)
/*     */         {
/* 138 */           ((T2CConnection)this.statement.connection).checkError(i, this.statement.sqlWarning);
/*     */         }
/* 140 */         else if (i == -2)
/*     */         {
/* 142 */           j = 1;
/* 143 */           this.accessor.setNull(k, true);
/* 144 */           i = 0;
/* 145 */         } else if (i >= 0)
/*     */         {
/* 147 */           this.accessor.setNull(k, false);
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException1) {
/* 151 */         throw new IOException(localSQLException1.getMessage());
/*     */       }
/*     */ 
/* 154 */       if (i <= 0) {
/* 155 */         i = -1;
/* 156 */         j = 1;
/*     */       }
/*     */ 
/* 172 */       if (this.statement.connection.useNio)
/*     */       {
/* 174 */         ByteBuffer localByteBuffer = this.statement.nioBuffers[3];
/* 175 */         if ((localByteBuffer != null) && (i > 0))
/*     */         {
/* 177 */           localByteBuffer.get(this.resizableBuffer, 0, i);
/*     */         }
/*     */ 
/* 181 */         if (j != 0)
/*     */         {
/*     */           try
/*     */           {
/* 185 */             this.statement.extractNioDefineBuffers(this.columnIndex);
/*     */           }
/*     */           catch (SQLException localSQLException2)
/*     */           {
/* 189 */             throw new IOException(localSQLException2.getMessage());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 194 */       if ((j != 0) && (this.statement.lobPrefetchMetaData != null))
/*     */       {
/* 196 */         this.statement.processLobPrefetchMetaData(this.statement.lobPrefetchMetaData);
/*     */       }
/* 198 */       return i;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isNull()
/*     */     throws IOException
/*     */   {
/* 205 */     if (!this.statement.isFetchStreams) {
/* 206 */       needBytes();
/* 207 */       return super.isNull();
/*     */     }
/*     */ 
/* 211 */     return false;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CInputStream
 * JD-Core Version:    0.6.2
 */