/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import oracle.jdbc.oci.OracleOCIConnection;
/*     */ 
/*     */ class T2CDriverExtension extends OracleDriverExtension
/*     */ {
/*     */   static final int T2C_DEFAULT_BATCHSIZE = 1;
/* 114 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   Connection getConnection(String paramString, Properties paramProperties)
/*     */     throws SQLException
/*     */   {
/*  43 */     Object localObject = null;
/*  44 */     if (paramProperties.getProperty("is_connection_pooling") == "true")
/*     */     {
/*  47 */       localObject = new OracleOCIConnection(paramString, paramProperties, this);
/*     */     }
/*     */     else
/*     */     {
/*  51 */       localObject = new T2CConnection(paramString, paramProperties, this);
/*     */     }
/*  53 */     return localObject;
/*     */   }
/*     */ 
/*     */   OracleStatement allocateStatement(PhysicalConnection paramPhysicalConnection, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  65 */     return new T2CStatement((T2CConnection)paramPhysicalConnection, 1, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   OraclePreparedStatement allocatePreparedStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  79 */     return new T2CPreparedStatement((T2CConnection)paramPhysicalConnection, paramString, paramPhysicalConnection.defaultExecuteBatch, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   OracleCallableStatement allocateCallableStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  94 */     return new T2CCallableStatement((T2CConnection)paramPhysicalConnection, paramString, paramPhysicalConnection.defaultExecuteBatch, paramPhysicalConnection.defaultRowPrefetch, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   OracleInputStream createInputStream(OracleStatement paramOracleStatement, int paramInt, Accessor paramAccessor)
/*     */     throws SQLException
/*     */   {
/* 109 */     return new T2CInputStream(paramOracleStatement, paramInt, paramAccessor);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CDriverExtension
 * JD-Core Version:    0.6.2
 */