/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.Writer;
/*      */ import java.nio.ByteBuffer;
/*      */ import java.nio.ByteOrder;
/*      */ import java.nio.CharBuffer;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Properties;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.TimeZone;
/*      */ import oracle.jdbc.OracleOCIFailover;
/*      */ import oracle.jdbc.internal.OracleBfile;
/*      */ import oracle.jdbc.internal.OracleBlob;
/*      */ import oracle.jdbc.internal.OracleClob;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.InstanceProperty;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCLOB;
/*      */ import oracle.jdbc.pool.OracleOCIConnectionPool;
/*      */ import oracle.jdbc.pool.OraclePooledConnection;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.BfileDBAccess;
/*      */ import oracle.sql.BlobDBAccess;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ClobDBAccess;
/*      */ import oracle.sql.LobPlsqlUtil;
/*      */ import oracle.sql.NCLOB;
/*      */ import oracle.sql.SQLName;
/*      */ import oracle.sql.ZONEIDMAP;
/*      */ import oracle.sql.converter.CharacterSetMetaData;
/*      */ 
/*      */ public class T2CConnection extends PhysicalConnection
/*      */   implements BfileDBAccess, BlobDBAccess, ClobDBAccess
/*      */ {
/*   65 */   static final long JDBC_OCI_LIBRARY_VERSION = Long.parseLong("12.1.0.1.0".replaceAll("\\.", ""));
/*      */ 
/*   71 */   short[] queryMetaData1 = null;
/*   72 */   byte[] queryMetaData2 = null;
/*   73 */   int queryMetaData1Offset = 0;
/*   74 */   int queryMetaData2Offset = 0;
/*      */   private String password;
/*   76 */   int fatalErrorNumber = 0;
/*   77 */   String fatalErrorMessage = null;
/*      */   static final int QMD_dbtype = 0;
/*      */   static final int QMD_dbsize = 1;
/*      */   static final int QMD_nullok = 2;
/*      */   static final int QMD_precision = 3;
/*      */   static final int QMD_scale = 4;
/*      */   static final int QMD_formOfUse = 5;
/*      */   static final int QMD_columnNameLength = 6;
/*      */   static final int QMD_tdo0 = 7;
/*      */   static final int QMD_tdo1 = 8;
/*      */   static final int QMD_tdo2 = 9;
/*      */   static final int QMD_tdo3 = 10;
/*      */   static final int QMD_charLength = 11;
/*      */   static final int QMD_typeNameLength = 12;
/*      */   static final int QMD_columnInvisible = 13;
/*      */   static final int T2C_LOCATOR_MAX_LEN = 16;
/*      */   static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
/*      */   static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
/*      */   static final int METADATA1_INDICES_PER_COLUMN = 14;
/*      */   protected static final int SIZEOF_QUERYMETADATA2 = 8;
/*      */   static final String defaultDriverNameAttribute = "jdbcoci";
/*  112 */   int queryMetaData1Size = 100;
/*  113 */   int queryMetaData2Size = 800;
/*      */   long m_nativeState;
/*      */   short m_clientCharacterSet;
/*      */   byte byteAlign;
/*  121 */   static final byte[] EMPTY_BYTES = new byte[0];
/*      */   private static final int EOJ_SUCCESS = 0;
/*      */   private static final int EOJ_ERROR = -1;
/*      */   private static final int EOJ_WARNING = 1;
/*      */   private static final int EOJ_GET_STORAGE_ERROR = -4;
/*      */   private static final int EOJ_ORA3113_SERVER_NORMAL = -6;
/*      */   private static final String OCILIBRARY = "ocijdbc12";
/*  132 */   private int logon_mode = 0;
/*      */   static final int LOGON_MODE_DEFAULT = 0;
/*      */   static final int LOGON_MODE_SYSDBA = 2;
/*      */   static final int LOGON_MODE_SYSOPER = 4;
/*      */   static final int LOGON_MODE_SYSASM = 32768;
/*      */   static final int LOGON_MODE_SYSBKP = 131072;
/*      */   static final int LOGON_MODE_SYSDGD = 262144;
/*      */   static final int LOGON_MODE_SYSKMT = 524288;
/*      */   static final int LOGON_MODE_CONNECTION_POOL = 5;
/*      */   static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
/*      */   static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
/*      */   static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
/*      */   static final int T2C_PROXYTYPE_NONE = 0;
/*      */   static final int T2C_PROXYTYPE_USER_NAME = 1;
/*      */   static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
/*      */   static final int T2C_PROXYTYPE_CERTIFICATE = 3;
/*      */   static final int T2C_CONNECTION_FLAG_DEFAULT_LOB_PREFETCH = 0;
/*      */   static final int T2C_CONNECTION_FLAG_PRELIM_AUTH = 1;
/*      */   static final int T2C_CONNECTION_FLAG_CHARSET = 2;
/*      */   static final int T2C_CONNECTION_FLAG_NCHARSET = 3;
/*      */   static final int T2C_CONNECTION_FLAG_BYTE_ALIGN = 4;
/*      */   static final int T2C_CONNECTION_FLAG_SERVER_TZ_VERSION = 5;
/*      */   static final int T2C_CONNECTION_FLAG_TAF_ENABLED = 6;
/*      */   static final int T2C_CONNECTION_TAG_MATCHED = 7;
/*      */   static final int T2C_CONNECTION_FLAG_MAXLEN_COMPAT = 8;
/*      */   static final int T2C_MAX_SCHEMA_NAME_LENGTH = 258;
/*      */   private static boolean isLibraryLoaded;
/*  172 */   static final Map<String, String> cachedVersionTable = new Hashtable();
/*      */   static final int T2C_LOGON_OUT_BUFFER_LENGTH = 256;
/*      */   static final int EOO_LOGIN_OUT_TYPE_DBID = 1;
/*      */   static final int EOO_LOGIN_OUT_INST_START_TIME = 2;
/*      */   String databaseUniqueIdentifier;
/*  181 */   OracleOCIFailover appCallback = null;
/*  182 */   Object appCallbackObject = null;
/*      */   private Properties nativeInfo;
/*      */   ByteBuffer nioBufferForLob;
/*      */   boolean[] tagMatched;
/*      */   static final int OCI_SESSRLS_DROPSESS = 1;
/*      */   static final int OCI_SESSRLS_RETAG = 2;
/* 4491 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected T2CConnection(String paramString, Properties paramProperties, OracleDriverExtension paramOracleDriverExtension)
/*      */     throws SQLException
/*      */   {
/*  191 */     super(paramString, paramProperties, paramOracleDriverExtension);
/*      */ 
/*  194 */     initialize();
/*      */   }
/*      */ 
/*      */   final void initializePassword(String paramString)
/*      */     throws SQLException
/*      */   {
/*  202 */     this.password = paramString;
/*      */   }
/*      */ 
/*      */   protected void initialize()
/*      */   {
/*  209 */     allocQueryMetaDataBuffers();
/*      */   }
/*      */ 
/*      */   private void allocQueryMetaDataBuffers()
/*      */   {
/*  241 */     this.queryMetaData1Offset = 0;
/*  242 */     this.queryMetaData1 = new short[this.queryMetaData1Size * 14];
/*      */ 
/*  247 */     this.queryMetaData2Offset = 0;
/*  248 */     this.queryMetaData2 = new byte[this.queryMetaData2Size];
/*      */ 
/*  250 */     this.namedTypeAccessorByteLen = 0;
/*  251 */     this.refTypeAccessorByteLen = 0;
/*      */   }
/*      */ 
/*      */   void reallocateQueryMetaData(int paramInt1, int paramInt2)
/*      */   {
/*  258 */     this.queryMetaData1 = null;
/*  259 */     this.queryMetaData2 = null;
/*      */ 
/*  261 */     this.queryMetaData1Size = Math.max(paramInt1, this.queryMetaData1Size);
/*  262 */     this.queryMetaData2Size = Math.max(paramInt2, this.queryMetaData2Size);
/*      */ 
/*  264 */     allocQueryMetaDataBuffers();
/*      */   }
/*      */ 
/*      */   protected void logon()
/*      */     throws SQLException
/*      */   {
/*  288 */     this.tagMatched = new boolean[] { false };
/*  289 */     if (this.database == null)
/*      */     {
/*  291 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 64);
/*  292 */       ((SQLException)localObject1).fillInStackTrace();
/*  293 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/*  296 */     if (!isLibraryLoaded) {
/*  297 */       loadNativeLibrary(this.ocidll);
/*      */     }
/*      */ 
/*  307 */     Object localObject1 = new byte[256];
/*  308 */     if (this.ociConnectionPoolIsPooling)
/*      */     {
/*  310 */       processOCIConnectionPooling();
/*      */     }
/*      */     else
/*      */     {
/*  314 */       long l1 = this.ociSvcCtxHandle;
/*  315 */       long l2 = this.ociEnvHandle;
/*  316 */       long l3 = this.ociErrHandle;
/*      */ 
/*  319 */       if ((l1 != 0L) && (l2 != 0L))
/*      */       {
/*  322 */         if (this.ociDriverCharset != null) {
/*  323 */           this.m_clientCharacterSet = new Integer(this.ociDriverCharset).shortValue();
/*      */         }
/*      */         else
/*      */         {
/*  328 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/*  329 */           ((SQLException)localObject2).fillInStackTrace();
/*  330 */           throw ((Throwable)localObject2);
/*      */         }
/*      */ 
/*  336 */         this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/*  342 */         localObject2 = new long[] { this.defaultLobPrefetchSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.enableOCIFAN ? 1 : 0 };
/*      */ 
/*  355 */         this.sqlWarning = checkError(t2cUseConnection(this.m_nativeState, l2, l1, l3, (byte[])localObject1, (long[])localObject2), this.sqlWarning);
/*      */ 
/*  362 */         this.conversion = new DBConversion((short)(int)(localObject2[2] & 0xFFFF), this.m_clientCharacterSet, (short)(int)(localObject2[3] & 0xFFFF));
/*      */ 
/*  366 */         this.byteAlign = ((byte)(int)(localObject2[4] & 0xFF));
/*  367 */         this.timeZoneVersionNumber = ((int)localObject2[5]);
/*      */ 
/*  370 */         if (localObject2[6] != 0L) {
/*  371 */           this.useOCIDefaultDefines = true;
/*      */         }
/*  373 */         this.tagMatched[0] = (localObject2[7] != 0L ? 1 : false);
/*      */ 
/*  375 */         this.varTypeMaxLenCompat = ((int)localObject2[8]);
/*      */ 
/*  377 */         return;
/*      */       }
/*      */ 
/*  382 */       if (this.internalLogon == null)
/*  383 */         this.logon_mode = 0;
/*  384 */       else if (this.internalLogon.equalsIgnoreCase("SYSDBA"))
/*  385 */         this.logon_mode = 2;
/*  386 */       else if (this.internalLogon.equalsIgnoreCase("SYSOPER"))
/*  387 */         this.logon_mode = 4;
/*  388 */       else if (this.internalLogon.equalsIgnoreCase("SYSASM"))
/*  389 */         this.logon_mode = 32768;
/*  390 */       else if (this.internalLogon.equalsIgnoreCase("SYSBACKUP"))
/*  391 */         this.logon_mode = 131072;
/*  392 */       else if (this.internalLogon.equalsIgnoreCase("SYSDG"))
/*  393 */         this.logon_mode = 262144;
/*  394 */       else if (this.internalLogon.equalsIgnoreCase("SYSKM")) {
/*  395 */         this.logon_mode = 524288;
/*      */       }
/*  397 */       Object localObject2 = null;
/*  398 */       byte[] arrayOfByte1 = null;
/*  399 */       byte[] arrayOfByte2 = null;
/*  400 */       byte[] arrayOfByte3 = EMPTY_BYTES;
/*  401 */       byte[] arrayOfByte4 = EMPTY_BYTES;
/*  402 */       String str1 = this.setNewPassword;
/*  403 */       byte[] arrayOfByte5 = EMPTY_BYTES;
/*  404 */       byte[] arrayOfByte6 = EMPTY_BYTES;
/*  405 */       byte[] arrayOfByte7 = EMPTY_BYTES;
/*      */ 
/*  407 */       if (this.nlsLangBackdoor)
/*      */       {
/*  410 */         this.m_clientCharacterSet = getDriverCharSetIdFromNLS_LANG(this.ocidll);
/*      */       }
/*      */       else
/*      */       {
/*  415 */         this.m_clientCharacterSet = getClientCharSetId();
/*      */       }
/*      */ 
/*  418 */       if (str1 != null) {
/*  419 */         arrayOfByte5 = DBConversion.stringToDriverCharBytes(str1, this.m_clientCharacterSet);
/*      */       }
/*  421 */       if (this.editionName != null) {
/*  422 */         arrayOfByte6 = DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
/*      */       }
/*  424 */       if (this.driverNameAttribute == null)
/*  425 */         arrayOfByte7 = DBConversion.stringToDriverCharBytes("jdbcoci", this.m_clientCharacterSet);
/*      */       else {
/*  427 */         arrayOfByte7 = DBConversion.stringToDriverCharBytes(this.driverNameAttribute, this.m_clientCharacterSet);
/*      */       }
/*  429 */       localObject2 = this.userName == null ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */ 
/*  432 */       arrayOfByte1 = this.proxyClientName == null ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.proxyClientName, this.m_clientCharacterSet);
/*      */ 
/*  435 */       arrayOfByte2 = this.password == null ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
/*      */ 
/*  440 */       if (this.drcpEnabled) {
/*  441 */         arrayOfByte3 = DBConversion.stringToDriverCharBytes(this.drcpConnectionClass, this.m_clientCharacterSet);
/*      */       }
/*      */ 
/*  444 */       if (this.drcpTagName != null) {
/*  445 */         arrayOfByte4 = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
/*      */       }
/*  447 */       byte[] arrayOfByte8 = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
/*      */ 
/*  449 */       String str2 = null;
/*  450 */       byte[] arrayOfByte9 = (str2 = CharacterSetMetaData.getNLSLanguage(OracleLocale.getDefault())) != null ? str2.getBytes() : null;
/*      */ 
/*  457 */       byte[] arrayOfByte10 = (str2 = CharacterSetMetaData.getNLSTerritory(OracleLocale.getDefault())) != null ? str2.getBytes() : null;
/*      */ 
/*  465 */       if ((arrayOfByte9 == null) || (arrayOfByte10 == null))
/*      */       {
/*  467 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 176);
/*  468 */         ((SQLException)localObject3).fillInStackTrace();
/*  469 */         throw ((Throwable)localObject3);
/*      */       }
/*      */ 
/*  472 */       Object localObject3 = TimeZone.getDefault();
/*  473 */       String str3 = ((TimeZone)localObject3).getID();
/*      */ 
/*  475 */       if ((!ZONEIDMAP.isValidRegion(str3)) || (!this.timezoneAsRegion))
/*      */       {
/*  484 */         int i = ((TimeZone)localObject3).getOffset(System.currentTimeMillis());
/*  485 */         j = i / 3600000;
/*  486 */         int k = i / 60000 % 60;
/*      */ 
/*  488 */         str3 = new StringBuilder().append(j < 0 ? new StringBuilder().append("").append(j).toString() : new StringBuilder().append("+").append(j).toString()).append(k < 10 ? new StringBuilder().append(":0").append(k).toString() : new StringBuilder().append(":").append(k).toString()).toString();
/*      */       }
/*      */ 
/*  492 */       doSetSessionTimeZone(str3);
/*      */ 
/*  495 */       this.sessionTimeZone = str3;
/*      */ 
/*  498 */       this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/*  504 */       long[] arrayOfLong = { this.defaultLobPrefetchSize, this.prelimAuth ? 1 : 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.enableOCIFAN ? 1 : 0 };
/*      */ 
/*  517 */       if (this.m_nativeState == 0L)
/*      */       {
/*  519 */         this.sqlWarning = checkError(t2cCreateState((byte[])localObject2, localObject2.length, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte5, arrayOfByte5.length, arrayOfByte6, arrayOfByte6.length, arrayOfByte7, arrayOfByte7.length, arrayOfByte8, arrayOfByte8.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, this.m_clientCharacterSet, this.logon_mode, arrayOfByte9, arrayOfByte10, (byte[])localObject1, arrayOfLong), this.sqlWarning);
/*      */       }
/*      */       else
/*      */       {
/*  539 */         this.sqlWarning = checkError(t2cLogon(this.m_nativeState, (byte[])localObject2, localObject2.length, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte5, arrayOfByte5.length, arrayOfByte6, arrayOfByte6.length, arrayOfByte7, arrayOfByte7.length, arrayOfByte8, arrayOfByte8.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, this.logon_mode, arrayOfByte9, arrayOfByte10, (byte[])localObject1, arrayOfLong), this.sqlWarning);
/*      */       }
/*      */ 
/*  557 */       this.conversion = new DBConversion((short)(int)(arrayOfLong[2] & 0xFFFF), this.m_clientCharacterSet, (short)(int)(arrayOfLong[3] & 0xFFFF));
/*      */ 
/*  561 */       this.byteAlign = ((byte)(int)(arrayOfLong[4] & 0xFF));
/*  562 */       this.timeZoneVersionNumber = ((int)arrayOfLong[5]);
/*      */ 
/*  565 */       if (arrayOfLong[6] != 0L) {
/*  566 */         this.useOCIDefaultDefines = true;
/*      */       }
/*  568 */       this.tagMatched[0] = (arrayOfLong[7] != 0L ? 1 : false);
/*      */ 
/*  570 */       this.varTypeMaxLenCompat = ((int)arrayOfLong[8]);
/*      */ 
/*  572 */       int j = 0;
/*  573 */       String str4 = null;
/*      */       while (true)
/*      */       {
/*  579 */         int m = readShort((byte[])localObject1, j);
/*      */ 
/*  581 */         if (m == 0) break;
/*  582 */         j += 2;
/*      */ 
/*  584 */         int n = readShort((byte[])localObject1, j);
/*  585 */         j += 2;
/*      */ 
/*  587 */         switch (m) {
/*      */         case 1:
/*  589 */           this.databaseUniqueIdentifier = new String((byte[])localObject1, j, n);
/*      */ 
/*  592 */           j += n;
/*  593 */           break;
/*      */         case 2:
/*  595 */           str4 = new String((byte[])localObject1, j, n);
/*      */ 
/*  598 */           j += n;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  606 */       if (this.databaseUniqueIdentifier != null)
/*      */       {
/*  608 */         String str5 = (String)cachedVersionTable.get(new StringBuilder().append(this.databaseUniqueIdentifier).append(str4).toString());
/*  609 */         if (str5 == null) {
/*  610 */           cachedVersionTable.put(new StringBuilder().append(this.databaseUniqueIdentifier).append(str4).toString(), String.valueOf(getVersionNumber()));
/*      */ 
/*  612 */           if (this.drcpEnabled) detachServerConnection((String)null); 
/*      */         }
/*      */         else
/*      */         {
/*  615 */           this.versionNumber = Short.parseShort(str5);
/*  616 */           t2cSetCachedServerVersion(this.m_nativeState, this.versionNumber);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   int readShort(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/*  626 */     return (paramArrayOfByte[paramInt] & 0xFF) << 8 | paramArrayOfByte[(paramInt + 1)] & 0xFF;
/*      */   }
/*      */ 
/*      */   protected void logoff()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/*  645 */       if ((this.lifecycle == 8) || (this.lifecycle == 2))
/*      */       {
/*  647 */         checkError(t2cLogoff(this.m_nativeState));
/*      */       }
/*      */     }
/*      */     catch (NullPointerException localNullPointerException) {
/*      */     }
/*  652 */     this.m_nativeState = 0L;
/*      */   }
/*      */ 
/*      */   public void open(OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*  670 */     byte[] arrayOfByte = paramOracleStatement.sqlObject.getSql(paramOracleStatement.processEscapes, paramOracleStatement.convertNcharLiterals).getBytes();
/*      */ 
/*  673 */     checkError(t2cCreateStatement(this.m_nativeState, 0L, arrayOfByte, arrayOfByte.length, paramOracleStatement, false, paramOracleStatement.rowPrefetch));
/*      */   }
/*      */ 
/*      */   OracleStatement createImplicitResultSetStatement(OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*  690 */     T2CStatement localT2CStatement = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
/*  691 */     checkError(t2cGetImplicitResultSetStatement(this.m_nativeState, paramOracleStatement.c_state, localT2CStatement));
/*      */ 
/*  693 */     localT2CStatement.needToParse = false;
/*  694 */     localT2CStatement.isOpen = true;
/*  695 */     localT2CStatement.processEscapes = false;
/*      */ 
/*  697 */     localT2CStatement.sqlKind = OracleStatement.SqlKind.SELECT;
/*      */ 
/*  699 */     localT2CStatement.prepareForNewResults(true, false, true);
/*      */ 
/*  703 */     paramOracleStatement.addImplicitResultSetStmt(localT2CStatement);
/*  704 */     return localT2CStatement;
/*      */   }
/*      */ 
/*      */   void cancelOperationOnServer(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  718 */     checkError(t2cCancel(this.m_nativeState));
/*      */   }
/*      */ 
/*      */   native int t2cAbort(long paramLong);
/*      */ 
/*      */   void doAbort()
/*      */     throws SQLException
/*      */   {
/*  727 */     checkError(t2cAbort(this.m_nativeState));
/*      */   }
/*      */ 
/*      */   protected void doSetAutoCommit(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  743 */     if ((this.autoCommitSpecCompliant) && (!getAutoCommit()) && (paramBoolean)) {
/*  744 */       commit();
/*      */     }
/*      */ 
/*  747 */     checkError(t2cSetAutoCommit(this.m_nativeState, paramBoolean));
/*  748 */     this.autocommit = paramBoolean;
/*      */   }
/*      */ 
/*      */   protected void doCommit(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  764 */     checkError(t2cCommit(this.m_nativeState, paramInt));
/*      */   }
/*      */ 
/*      */   protected void doRollback()
/*      */     throws SQLException
/*      */   {
/*  780 */     checkError(t2cRollback(this.m_nativeState));
/*      */   }
/*      */ 
/*      */   synchronized int doPingDatabase()
/*      */     throws SQLException
/*      */   {
/*  787 */     if (t2cPingDatabase(this.m_nativeState) == 0) {
/*  788 */       return 0;
/*      */     }
/*  790 */     return -1;
/*      */   }
/*      */ 
/*      */   protected String doGetDatabaseProductVersion()
/*      */     throws SQLException
/*      */   {
/*  797 */     byte[] arrayOfByte = t2cGetProductionVersion(this.m_nativeState);
/*      */ 
/*  799 */     return this.conversion.CharBytesToString(arrayOfByte, arrayOfByte.length);
/*      */   }
/*      */ 
/*      */   protected short doGetVersionNumber()
/*      */     throws SQLException
/*      */   {
/*  806 */     short s = 0;
/*      */     try
/*      */     {
/*  810 */       String str1 = doGetDatabaseProductVersion();
/*      */ 
/*  812 */       StringTokenizer localStringTokenizer = new StringTokenizer(str1.trim(), " .", false);
/*  813 */       String str2 = null;
/*  814 */       int i = 0;
/*  815 */       int j = 0;
/*      */ 
/*  817 */       while (localStringTokenizer.hasMoreTokens())
/*      */       {
/*  819 */         str2 = localStringTokenizer.nextToken();
/*      */         try
/*      */         {
/*  823 */           j = Integer.decode(str2).shortValue();
/*  824 */           s = (short)(s * 10 + j);
/*  825 */           i++;
/*      */ 
/*  828 */           if (i == 4) {
/*  829 */             break;
/*      */           }
/*      */         }
/*      */         catch (NumberFormatException localNumberFormatException)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (NoSuchElementException localNoSuchElementException)
/*      */     {
/*      */     }
/*      */ 
/*  843 */     if (s == -1) {
/*  844 */       s = 0;
/*      */     }
/*      */ 
/*  847 */     return s;
/*      */   }
/*      */ 
/*      */   public ClobDBAccess createClobDBAccess()
/*      */   {
/*  854 */     return this;
/*      */   }
/*      */ 
/*      */   public BlobDBAccess createBlobDBAccess()
/*      */   {
/*  861 */     return this;
/*      */   }
/*      */ 
/*      */   public BfileDBAccess createBfileDBAccess()
/*      */   {
/*  868 */     return this;
/*      */   }
/*      */ 
/*      */   protected SQLWarning checkError(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  875 */     return checkError(paramInt, null);
/*      */   }
/*      */ 
/*      */   protected SQLWarning checkError(int paramInt, SQLWarning paramSQLWarning)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject1;
/*  885 */     switch (paramInt)
/*      */     {
/*      */     case 0:
/*  888 */       break;
/*      */     case -1:
/*      */     case 1:
/*  893 */       localObject1 = new T2CError();
/*      */ 
/*  899 */       int i = -1;
/*      */ 
/*  904 */       if ((this.lifecycle == 1) || (this.lifecycle == 16))
/*      */       {
/*  906 */         i = t2cDescribeError(this.m_nativeState, (T2CError)localObject1, ((T2CError)localObject1).m_errorMessage);
/*      */       }
/*      */       else {
/*  909 */         if (this.fatalErrorNumber != 0)
/*      */         {
/*  912 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 269);
/*  913 */           ((SQLException)localObject2).fillInStackTrace();
/*  914 */           throw ((Throwable)localObject2);
/*      */         }
/*      */ 
/*  919 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  920 */         ((SQLException)localObject2).fillInStackTrace();
/*  921 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/*  924 */       Object localObject2 = null;
/*  925 */       if (i != -1)
/*      */       {
/*  929 */         int j = 0;
/*      */ 
/*  931 */         while ((j < ((T2CError)localObject1).m_errorMessage.length) && (localObject1.m_errorMessage[j] != 0)) {
/*  932 */           j++;
/*      */         }
/*  934 */         if (this.conversion == null) throw new Error("conversion == null");
/*  935 */         if (localObject1 == null) throw new Error("l_error == null");
/*  936 */         localObject2 = this.conversion.CharBytesToString(((T2CError)localObject1).m_errorMessage, j, true);
/*      */       }
/*      */ 
/*  943 */       switch (((T2CError)localObject1).m_errorNumber)
/*      */       {
/*      */       case 28:
/*      */       case 600:
/*      */       case 1012:
/*      */       case 1041:
/*  949 */         internalClose();
/*  950 */         break;
/*      */       case 902:
/*  954 */         removeAllDescriptor();
/*  955 */         break;
/*      */       case 3113:
/*      */       case 3114:
/*  959 */         setUsable(false);
/*  960 */         close();
/*  961 */         break;
/*      */       case -6:
/*  963 */         ((T2CError)localObject1).m_errorNumber = 3113;
/*      */       }
/*      */       SQLException localSQLException;
/*  968 */       if (i == -1)
/*      */       {
/*  970 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Fetch error message failed!");
/*  971 */         localSQLException.fillInStackTrace();
/*  972 */         throw localSQLException;
/*      */       }
/*      */ 
/*  975 */       if (paramInt == -1)
/*      */       {
/*  978 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), (String)localObject2, ((T2CError)localObject1).m_errorNumber);
/*  979 */         localSQLException.fillInStackTrace();
/*  980 */         throw localSQLException;
/*      */       }
/*      */ 
/*  985 */       paramSQLWarning = DatabaseError.addSqlWarning(paramSQLWarning, (String)localObject2, ((T2CError)localObject1).m_errorNumber);
/*      */ 
/*  988 */       break;
/*      */     case -4:
/*  992 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 254);
/*  993 */       ((SQLException)localObject1).fillInStackTrace();
/*  994 */       throw ((Throwable)localObject1);
/*      */     case -3:
/*      */     case -2:
/*      */     }
/*      */ 
/* 1001 */     return paramSQLWarning;
/*      */   }
/*      */ 
/*      */   OracleStatement RefCursorBytesToStatement(byte[] paramArrayOfByte, OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/* 1009 */     T2CStatement localT2CStatement = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
/*      */ 
/* 1011 */     localT2CStatement.needToParse = false;
/* 1012 */     localT2CStatement.serverCursor = true;
/* 1013 */     localT2CStatement.isOpen = true;
/* 1014 */     localT2CStatement.processEscapes = false;
/*      */ 
/* 1016 */     localT2CStatement.prepareForNewResults(true, false, true);
/*      */ 
/* 1019 */     if (this.useOCIDefaultDefines)
/*      */     {
/* 1021 */       localT2CStatement.savedRowPrefetch = this.defaultRowPrefetch;
/* 1022 */       localT2CStatement.rowPrefetch = 1;
/*      */     }
/* 1024 */     localT2CStatement.sqlObject.initialize("select unknown as ref cursor from whatever");
/*      */ 
/* 1026 */     localT2CStatement.sqlKind = OracleStatement.SqlKind.SELECT;
/*      */ 
/* 1028 */     checkError(t2cCreateStatement(this.m_nativeState, paramOracleStatement.c_state, paramArrayOfByte, paramArrayOfByte.length, localT2CStatement, true, this.defaultRowPrefetch));
/*      */ 
/* 1032 */     paramOracleStatement.addChild(localT2CStatement);
/* 1033 */     return localT2CStatement;
/*      */   }
/*      */ 
/*      */   public void getForm(OracleTypeADT paramOracleTypeADT, OracleTypeCLOB paramOracleTypeCLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1042 */     int i = 0;
/*      */ 
/* 1044 */     if (paramOracleTypeCLOB != null)
/*      */     {
/* 1046 */       String[] arrayOfString1 = new String[1];
/* 1047 */       String[] arrayOfString2 = new String[1];
/*      */ 
/* 1049 */       SQLName.parse(paramOracleTypeADT.getFullName(), arrayOfString1, arrayOfString2, true);
/*      */ 
/* 1051 */       String str = new StringBuilder().append("\"").append(arrayOfString1[0]).append("\".\"").append(arrayOfString2[0]).append("\"").toString();
/*      */ 
/* 1054 */       byte[] arrayOfByte = this.conversion.StringToCharBytes(str);
/*      */ 
/* 1056 */       int j = t2cGetFormOfUse(this.m_nativeState, paramOracleTypeCLOB, arrayOfByte, arrayOfByte.length, paramInt);
/*      */ 
/* 1060 */       if (j < 0) {
/* 1061 */         checkError(j);
/*      */       }
/*      */ 
/* 1064 */       paramOracleTypeCLOB.setForm(j);
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getTdoCState(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1079 */     String str = new StringBuilder().append("\"").append(paramString1).append("\".\"").append(paramString2).append("\"").toString();
/* 1080 */     byte[] arrayOfByte = this.conversion.StringToCharBytes(str);
/* 1081 */     int[] arrayOfInt = new int[1];
/* 1082 */     long l = t2cGetTDO(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfInt);
/* 1083 */     if (l == 0L)
/*      */     {
/* 1085 */       checkError(arrayOfInt[0]);
/*      */     }
/* 1087 */     return l;
/*      */   }
/*      */ 
/*      */   public long getTdoCState(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1095 */     byte[] arrayOfByte = this.conversion.StringToCharBytes(paramString);
/* 1096 */     int[] arrayOfInt = new int[1];
/* 1097 */     long l = t2cGetTDO(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfInt);
/* 1098 */     if (l == 0L)
/*      */     {
/* 1100 */       checkError(arrayOfInt[0]);
/*      */     }
/* 1102 */     return l;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Properties getDBAccessProperties()
/*      */     throws SQLException
/*      */   {
/* 1118 */     return getOCIHandles();
/*      */   }
/*      */ 
/*      */   public synchronized Properties getOCIHandles()
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/* 1130 */     if (this.lifecycle != 1)
/*      */     {
/* 1132 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1133 */       ((SQLException)localObject).fillInStackTrace();
/* 1134 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1137 */     if (this.nativeInfo == null)
/*      */     {
/* 1139 */       localObject = new long[3];
/*      */ 
/* 1142 */       checkError(t2cGetHandles(this.m_nativeState, (long[])localObject));
/*      */ 
/* 1145 */       this.nativeInfo = new Properties();
/*      */ 
/* 1147 */       this.nativeInfo.put("OCIEnvHandle", String.valueOf(localObject[0]));
/* 1148 */       this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(localObject[1]));
/* 1149 */       this.nativeInfo.put("OCIErrHandle", String.valueOf(localObject[2]));
/* 1150 */       this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
/*      */     }
/*      */ 
/* 1153 */     return this.nativeInfo;
/*      */   }
/*      */ 
/*      */   public Properties getServerSessionInfo()
/*      */     throws SQLException
/*      */   {
/* 1160 */     if (this.lifecycle != 1)
/*      */     {
/* 1162 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1163 */       localSQLException.fillInStackTrace();
/* 1164 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1167 */     if (this.sessionProperties == null) {
/* 1168 */       this.sessionProperties = new Properties();
/*      */     }
/*      */ 
/* 1172 */     if (getVersionNumber() < 10200)
/* 1173 */       queryFCFProperties(this.sessionProperties);
/*      */     else {
/* 1175 */       checkError(t2cGetServerSessionInfo(this.m_nativeState, this.sessionProperties));
/*      */     }
/* 1177 */     return this.sessionProperties;
/*      */   }
/*      */ 
/*      */   public byte getInstanceProperty(OracleConnection.InstanceProperty paramInstanceProperty)
/*      */     throws SQLException
/*      */   {
/* 1183 */     byte b = 0;
/* 1184 */     if (paramInstanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED)
/*      */     {
/* 1186 */       b = t2cGetAsmVolProperty(this.m_nativeState);
/*      */     }
/* 1188 */     else if (paramInstanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE)
/*      */     {
/* 1190 */       b = t2cGetInstanceType(this.m_nativeState);
/*      */     }
/* 1192 */     return b;
/*      */   }
/*      */ 
/*      */   public Properties getConnectionPoolInfo()
/*      */     throws SQLException
/*      */   {
/* 1207 */     if (this.lifecycle != 1)
/*      */     {
/* 1209 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1210 */       ((SQLException)localObject).fillInStackTrace();
/* 1211 */       throw ((Throwable)localObject);
/*      */     }
/* 1213 */     Object localObject = new Properties();
/*      */ 
/* 1215 */     checkError(t2cGetConnPoolInfo(this.m_nativeState, (Properties)localObject));
/*      */ 
/* 1217 */     return localObject;
/*      */   }
/*      */ 
/*      */   public void setConnectionPoolInfo(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6)
/*      */     throws SQLException
/*      */   {
/* 1232 */     checkError(t2cSetConnPoolInfo(this.m_nativeState, paramInt1, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6));
/*      */   }
/*      */ 
/*      */   public void ociPasswordChange(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 1247 */     if (this.lifecycle != 1)
/*      */     {
/* 1249 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1250 */       ((SQLException)localObject).fillInStackTrace();
/* 1251 */       throw ((Throwable)localObject);
/*      */     }
/* 1253 */     Object localObject = paramString1 == null ? new byte[0] : DBConversion.stringToDriverCharBytes(paramString1, this.m_clientCharacterSet);
/*      */ 
/* 1257 */     byte[] arrayOfByte1 = paramString2 == null ? new byte[0] : DBConversion.stringToDriverCharBytes(paramString2, this.m_clientCharacterSet);
/*      */ 
/* 1260 */     byte[] arrayOfByte2 = paramString3 == null ? new byte[0] : DBConversion.stringToDriverCharBytes(paramString3, this.m_clientCharacterSet);
/*      */ 
/* 1263 */     this.sqlWarning = checkError(t2cPasswordChange(this.m_nativeState, (byte[])localObject, localObject.length, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length), this.sqlWarning);
/*      */   }
/*      */ 
/*      */   private void processOCIConnectionPooling()
/*      */     throws SQLException
/*      */   {
/* 1274 */     if (this.lifecycle != 1)
/*      */     {
/* 1276 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1277 */       ((SQLException)localObject1).fillInStackTrace();
/* 1278 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 1282 */     Object localObject1 = null;
/*      */ 
/* 1284 */     if (this.ociConnectionPoolLogonMode == "connection_pool")
/*      */     {
/* 1286 */       if (this.nlsLangBackdoor)
/*      */       {
/* 1289 */         this.m_clientCharacterSet = getDriverCharSetIdFromNLS_LANG(this.ocidll);
/*      */       }
/*      */       else
/*      */       {
/* 1294 */         this.m_clientCharacterSet = getClientCharSetId();
/*      */       }
/*      */     }
/*      */     else {
/* 1298 */       localObject1 = (T2CConnection)this.ociConnectionPoolObject;
/* 1299 */       this.m_clientCharacterSet = ((T2CConnection)localObject1).m_clientCharacterSet;
/*      */     }
/*      */ 
/* 1302 */     byte[] arrayOfByte1 = null;
/*      */ 
/* 1304 */     byte[] arrayOfByte2 = this.password == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
/*      */ 
/* 1307 */     byte[] arrayOfByte3 = this.editionName == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
/*      */ 
/* 1310 */     byte[] arrayOfByte4 = DBConversion.stringToDriverCharBytes(this.driverNameAttribute == null ? "jdbcoci" : this.driverNameAttribute, this.m_clientCharacterSet);
/*      */ 
/* 1314 */     byte[] arrayOfByte5 = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
/*      */ 
/* 1316 */     byte[] arrayOfByte6 = CharacterSetMetaData.getNLSLanguage(OracleLocale.getDefault()).getBytes();
/*      */ 
/* 1323 */     byte[] arrayOfByte7 = CharacterSetMetaData.getNLSTerritory(OracleLocale.getDefault()).getBytes();
/*      */ 
/* 1332 */     if ((arrayOfByte6 == null) || (arrayOfByte7 == null))
/*      */     {
/* 1334 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 176);
/* 1335 */       ((SQLException)localObject2).fillInStackTrace();
/* 1336 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1342 */     Object localObject2 = { this.defaultLobPrefetchSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
/*      */     Object localObject3;
/* 1355 */     if (this.ociConnectionPoolLogonMode == "connection_pool")
/*      */     {
/* 1357 */       arrayOfByte1 = this.userName == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */ 
/* 1363 */       this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/* 1366 */       this.logon_mode = 5;
/*      */ 
/* 1368 */       if (this.lifecycle == 1)
/*      */       {
/* 1370 */         localObject3 = new int[6];
/*      */ 
/* 1372 */         OracleOCIConnectionPool.readPoolConfig(this.ociConnectionPoolMinLimit, this.ociConnectionPoolMaxLimit, this.ociConnectionPoolIncrement, this.ociConnectionPoolTimeout, this.ociConnectionPoolNoWait, this.ociConnectionPoolTransactionDistributed, (int[])localObject3);
/*      */ 
/* 1380 */         this.sqlWarning = checkError(t2cCreateConnPool(arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte5, arrayOfByte5.length, this.m_clientCharacterSet, this.logon_mode, localObject3[0], localObject3[1], localObject3[2], localObject3[3], localObject3[4], localObject3[5]), this.sqlWarning);
/*      */ 
/* 1391 */         this.versionNumber = 10000;
/*      */       }
/*      */       else
/*      */       {
/* 1397 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 0, "Internal Error: ");
/* 1398 */         ((SQLException)localObject3).fillInStackTrace();
/* 1399 */         throw ((Throwable)localObject3);
/*      */       }
/*      */ 
/*      */     }
/* 1404 */     else if (this.ociConnectionPoolLogonMode == "connpool_connection")
/*      */     {
/* 1406 */       this.logon_mode = 6;
/*      */ 
/* 1408 */       arrayOfByte1 = this.userName == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */ 
/* 1414 */       this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/* 1417 */       this.sqlWarning = checkError(t2cConnPoolLogon(((T2CConnection)localObject1).m_nativeState, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, arrayOfByte5, arrayOfByte5.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, arrayOfByte6, arrayOfByte7, (long[])localObject2), this.sqlWarning);
/*      */     }
/* 1449 */     else if (this.ociConnectionPoolLogonMode == "connpool_alias_connection")
/*      */     {
/* 1451 */       this.logon_mode = 8;
/*      */ 
/* 1454 */       localObject3 = null;
/*      */ 
/* 1456 */       localObject3 = (byte[])this.ociConnectionPoolConnID;
/*      */ 
/* 1459 */       arrayOfByte1 = this.userName == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */ 
/* 1465 */       this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/* 1468 */       this.sqlWarning = checkError(t2cConnPoolLogon(((T2CConnection)localObject1).m_nativeState, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, arrayOfByte5, arrayOfByte5.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, (byte[])localObject3, localObject3 == null ? 0 : localObject3.length, arrayOfByte6, arrayOfByte7, (long[])localObject2), this.sqlWarning);
/*      */     }
/* 1500 */     else if (this.ociConnectionPoolLogonMode == "connpool_proxy_connection")
/*      */     {
/* 1502 */       this.logon_mode = 7;
/*      */ 
/* 1505 */       localObject3 = this.ociConnectionPoolProxyType;
/*      */ 
/* 1508 */       int i = this.ociConnectionPoolProxyNumRoles.intValue();
/*      */ 
/* 1510 */       String[] arrayOfString = null;
/*      */ 
/* 1512 */       if (i > 0)
/*      */       {
/* 1514 */         arrayOfString = (String[])this.ociConnectionPoolProxyRoles;
/*      */       }
/*      */ 
/* 1518 */       byte[] arrayOfByte8 = null;
/* 1519 */       byte[] arrayOfByte9 = null;
/* 1520 */       byte[] arrayOfByte10 = null;
/* 1521 */       byte[] arrayOfByte11 = null;
/*      */ 
/* 1524 */       int j = 0;
/*      */       String str;
/* 1527 */       if (localObject3 == "proxytype_user_name")
/*      */       {
/* 1529 */         j = 1;
/*      */ 
/* 1531 */         str = this.ociConnectionPoolProxyUserName;
/*      */ 
/* 1533 */         if (str != null) {
/* 1534 */           arrayOfByte8 = str.getBytes();
/*      */         }
/* 1536 */         str = this.ociConnectionPoolProxyPassword;
/*      */ 
/* 1538 */         if (str != null)
/* 1539 */           arrayOfByte9 = str.getBytes();
/*      */       }
/* 1541 */       else if (localObject3 == "proxytype_distinguished_name")
/*      */       {
/* 1544 */         j = 2;
/*      */ 
/* 1546 */         str = this.ociConnectionPoolProxyDistinguishedName;
/*      */ 
/* 1548 */         if (str != null)
/* 1549 */           arrayOfByte10 = str.getBytes();
/*      */       }
/* 1551 */       else if (localObject3 == "proxytype_certificate")
/*      */       {
/* 1553 */         j = 3;
/*      */ 
/* 1555 */         arrayOfByte11 = (byte[])this.ociConnectionPoolProxyCertificate;
/*      */       }
/*      */       else
/*      */       {
/* 1561 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 107);
/* 1562 */         localSQLException.fillInStackTrace();
/* 1563 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1568 */       arrayOfByte1 = this.userName == null ? new byte[0] : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */ 
/* 1574 */       this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
/*      */ 
/* 1577 */       this.sqlWarning = checkError(t2cConnPoolLogon(((T2CConnection)localObject1).m_nativeState, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, arrayOfByte5, arrayOfByte5.length, this.logon_mode, j, i, arrayOfString, arrayOfByte8, arrayOfByte8 == null ? 0 : arrayOfByte8.length, arrayOfByte9, arrayOfByte9 == null ? 0 : arrayOfByte9.length, arrayOfByte10, arrayOfByte10 == null ? 0 : arrayOfByte10.length, arrayOfByte11, arrayOfByte11 == null ? 0 : arrayOfByte11.length, null, 0, arrayOfByte6, arrayOfByte7, (long[])localObject2), this.sqlWarning);
/*      */     }
/*      */     else
/*      */     {
/* 1603 */       localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "connection-pool-logon");
/* 1604 */       ((SQLException)localObject3).fillInStackTrace();
/* 1605 */       throw ((Throwable)localObject3);
/*      */     }
/*      */ 
/* 1609 */     this.conversion = new DBConversion((short)(int)(localObject2[2] & 0xFFFF), this.m_clientCharacterSet, (short)(int)(localObject2[3] & 0xFFFF));
/*      */ 
/* 1613 */     this.byteAlign = ((byte)(int)(localObject2[4] & 0xFF));
/* 1614 */     this.timeZoneVersionNumber = ((int)localObject2[5]);
/*      */ 
/* 1617 */     if (localObject2[6] != 0L) {
/* 1618 */       this.useOCIDefaultDefines = true;
/*      */     }
/* 1620 */     this.tagMatched[0] = (localObject2[7] != 0L ? 1 : false);
/*      */ 
/* 1622 */     this.varTypeMaxLenCompat = ((int)localObject2[8]);
/*      */   }
/*      */ 
/*      */   public boolean isDescriptorSharable(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 1639 */     T2CConnection localT2CConnection = this;
/* 1640 */     PhysicalConnection localPhysicalConnection = (PhysicalConnection)paramOracleConnection.getPhysicalConnection();
/*      */ 
/* 1642 */     return localT2CConnection == localPhysicalConnection;
/*      */   }
/*      */ 
/*      */   native int t2cBlobRead(long paramLong1, byte[] paramArrayOfByte1, int paramInt1, long paramLong2, int paramInt2, byte[] paramArrayOfByte2, int paramInt3, boolean paramBoolean, ByteBuffer paramByteBuffer);
/*      */ 
/*      */   native int t2cClobRead(long paramLong1, byte[] paramArrayOfByte, int paramInt1, long paramLong2, int paramInt2, char[] paramArrayOfChar, int paramInt3, boolean paramBoolean1, boolean paramBoolean2, ByteBuffer paramByteBuffer);
/*      */ 
/*      */   native int t2cBlobWrite(long paramLong1, byte[] paramArrayOfByte1, int paramInt1, long paramLong2, int paramInt2, byte[] paramArrayOfByte2, int paramInt3, byte[][] paramArrayOfByte);
/*      */ 
/*      */   native int t2cClobWrite(long paramLong1, byte[] paramArrayOfByte, int paramInt1, long paramLong2, int paramInt2, char[] paramArrayOfChar, int paramInt3, byte[][] paramArrayOfByte1, boolean paramBoolean);
/*      */ 
/*      */   native long t2cLobGetLength(long paramLong, byte[] paramArrayOfByte, int paramInt);
/*      */ 
/*      */   native int t2cBfileOpen(long paramLong, byte[] paramArrayOfByte, int paramInt, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   native int t2cBfileIsOpen(long paramLong, byte[] paramArrayOfByte, int paramInt, boolean[] paramArrayOfBoolean);
/*      */ 
/*      */   native int t2cBfileExists(long paramLong, byte[] paramArrayOfByte, int paramInt, boolean[] paramArrayOfBoolean);
/*      */ 
/*      */   native String t2cBfileGetName(long paramLong, byte[] paramArrayOfByte, int paramInt);
/*      */ 
/*      */   native String t2cBfileGetDirAlias(long paramLong, byte[] paramArrayOfByte, int paramInt);
/*      */ 
/*      */   native int t2cBfileClose(long paramLong, byte[] paramArrayOfByte, int paramInt, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   native int t2cLobGetChunkSize(long paramLong, byte[] paramArrayOfByte, int paramInt);
/*      */ 
/*      */   native int t2cLobTrim(long paramLong1, int paramInt1, long paramLong2, byte[] paramArrayOfByte, int paramInt2, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   native int t2cLobCreateTemporary(long paramLong, int paramInt1, boolean paramBoolean, int paramInt2, short paramShort, byte[][] paramArrayOfByte);
/*      */ 
/*      */   native int t2cLobFreeTemporary(long paramLong, int paramInt1, byte[] paramArrayOfByte, int paramInt2, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   native int t2cLobIsTemporary(long paramLong, int paramInt1, byte[] paramArrayOfByte, int paramInt2, boolean[] paramArrayOfBoolean);
/*      */ 
/*      */   native int t2cLobOpen(long paramLong, int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   native int t2cLobIsOpen(long paramLong, int paramInt1, byte[] paramArrayOfByte, int paramInt2, boolean[] paramArrayOfBoolean);
/*      */ 
/*      */   native int t2cLobClose(long paramLong, int paramInt1, byte[] paramArrayOfByte, int paramInt2, byte[][] paramArrayOfByte1);
/*      */ 
/*      */   private long lobLength(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1719 */     long l = 0L;
/* 1720 */     l = t2cLobGetLength(this.m_nativeState, paramArrayOfByte, paramArrayOfByte.length);
/*      */ 
/* 1722 */     checkError((int)l);
/*      */ 
/* 1724 */     return l;
/*      */   }
/*      */ 
/*      */   private int blobRead(byte[] paramArrayOfByte1, long paramLong, int paramInt, byte[] paramArrayOfByte2, boolean paramBoolean, ByteBuffer paramByteBuffer)
/*      */     throws SQLException
/*      */   {
/* 1739 */     int i = 0;
/*      */ 
/* 1741 */     i = t2cBlobRead(this.m_nativeState, paramArrayOfByte1, paramArrayOfByte1.length, paramLong, paramInt, paramArrayOfByte2, paramArrayOfByte2.length, paramBoolean, paramByteBuffer);
/*      */ 
/* 1744 */     checkError(i);
/*      */ 
/* 1746 */     return i;
/*      */   }
/*      */ 
/*      */   private int blobWrite(byte[] paramArrayOfByte1, long paramLong, byte[] paramArrayOfByte2, byte[][] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1761 */     int i = 0;
/*      */ 
/* 1763 */     i = t2cBlobWrite(this.m_nativeState, paramArrayOfByte1, paramArrayOfByte1.length, paramLong, paramInt2, paramArrayOfByte2, paramInt1, paramArrayOfByte);
/*      */ 
/* 1766 */     checkError(i);
/*      */ 
/* 1768 */     return i;
/*      */   }
/*      */ 
/*      */   private int clobWrite(byte[] paramArrayOfByte, long paramLong, char[] paramArrayOfChar, byte[][] paramArrayOfByte1, boolean paramBoolean, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1784 */     int i = 0;
/*      */ 
/* 1786 */     i = t2cClobWrite(this.m_nativeState, paramArrayOfByte, paramArrayOfByte.length, paramLong, paramInt2, paramArrayOfChar, paramInt1, paramArrayOfByte1, paramBoolean);
/*      */ 
/* 1789 */     checkError(i);
/*      */ 
/* 1791 */     return i;
/*      */   }
/*      */ 
/*      */   private int lobGetChunkSize(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1799 */     int i = 0;
/* 1800 */     i = t2cLobGetChunkSize(this.m_nativeState, paramArrayOfByte, paramArrayOfByte.length);
/*      */ 
/* 1802 */     checkError(i);
/*      */ 
/* 1804 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized long length(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 1817 */     byte[] arrayOfByte = null;
/*      */ 
/* 1819 */     checkTrue(this.lifecycle == 1, 8);
/* 1820 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 1823 */     return lobLength(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public synchronized long position(BFILE paramBFILE, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1841 */     if (paramLong < 1L)
/*      */     {
/* 1844 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 1845 */       localSQLException.fillInStackTrace();
/* 1846 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1850 */     long l = LobPlsqlUtil.hasPattern(paramBFILE, paramArrayOfByte, paramLong);
/*      */ 
/* 1852 */     l = l == 0L ? -1L : l;
/*      */ 
/* 1854 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized long position(BFILE paramBFILE1, BFILE paramBFILE2, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1872 */     if (paramLong < 1L)
/*      */     {
/* 1875 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 1876 */       localSQLException.fillInStackTrace();
/* 1877 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1881 */     long l = LobPlsqlUtil.isSubLob(paramBFILE1, paramBFILE2, paramLong);
/*      */ 
/* 1883 */     l = l == 0L ? -1L : l;
/*      */ 
/* 1885 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getBytes(BFILE paramBFILE, long paramLong, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1901 */     byte[] arrayOfByte = null;
/*      */ 
/* 1903 */     checkTrue(this.lifecycle == 1, 8);
/* 1904 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 1907 */     if ((paramInt <= 0) || (paramArrayOfByte == null)) {
/* 1908 */       return 0;
/*      */     }
/* 1910 */     if (paramInt > paramArrayOfByte.length) {
/* 1911 */       paramInt = paramArrayOfByte.length;
/*      */     }
/* 1913 */     if (this.useNio)
/*      */     {
/* 1915 */       i = paramArrayOfByte.length;
/* 1916 */       if ((this.nioBufferForLob == null) || (this.nioBufferForLob.capacity() < i))
/* 1917 */         this.nioBufferForLob = ByteBuffer.allocateDirect(i);
/*      */       else {
/* 1919 */         this.nioBufferForLob.rewind();
/*      */       }
/*      */     }
/* 1922 */     int i = blobRead(arrayOfByte, paramLong, paramInt, paramArrayOfByte, this.useNio, this.nioBufferForLob);
/* 1923 */     if (this.useNio)
/*      */     {
/* 1925 */       this.nioBufferForLob.get(paramArrayOfByte);
/*      */     }
/*      */ 
/* 1928 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized String getName(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 1942 */     byte[] arrayOfByte = null;
/* 1943 */     String str = null;
/*      */ 
/* 1945 */     checkTrue(this.lifecycle == 1, 8);
/* 1946 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 1949 */     str = t2cBfileGetName(this.m_nativeState, arrayOfByte, arrayOfByte.length);
/*      */ 
/* 1951 */     checkError(str.length());
/*      */ 
/* 1953 */     return str;
/*      */   }
/*      */ 
/*      */   public synchronized String getDirAlias(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 1967 */     byte[] arrayOfByte = null;
/* 1968 */     String str = null;
/*      */ 
/* 1970 */     checkTrue(this.lifecycle == 1, 8);
/* 1971 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 1974 */     str = t2cBfileGetDirAlias(this.m_nativeState, arrayOfByte, arrayOfByte.length);
/*      */ 
/* 1976 */     checkError(str.length());
/*      */ 
/* 1978 */     return str;
/*      */   }
/*      */ 
/*      */   public synchronized void openFile(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 1991 */     byte[] arrayOfByte = null;
/*      */ 
/* 1993 */     checkTrue(this.lifecycle == 1, 8);
/* 1994 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 1997 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 1999 */     checkError(t2cBfileOpen(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2002 */     paramBFILE.setLocator(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized boolean isFileOpen(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2019 */     byte[] arrayOfByte = null;
/*      */ 
/* 2021 */     checkTrue(this.lifecycle == 1, 8);
/* 2022 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 2025 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 2027 */     checkError(t2cBfileIsOpen(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 2029 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public synchronized boolean fileExists(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2045 */     byte[] arrayOfByte = null;
/*      */ 
/* 2047 */     checkTrue(this.lifecycle == 1, 8);
/* 2048 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 2051 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 2053 */     checkError(t2cBfileExists(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 2055 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public synchronized void closeFile(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2068 */     byte[] arrayOfByte = null;
/*      */ 
/* 2070 */     checkTrue(this.lifecycle == 1, 8);
/* 2071 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.getLocator()) != null), 54);
/*      */ 
/* 2074 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2076 */     checkError(t2cBfileClose(this.m_nativeState, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2079 */     paramBFILE.setLocator(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized void open(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2094 */     byte[] arrayOfByte = null;
/*      */ 
/* 2096 */     checkTrue(this.lifecycle == 1, 8);
/* 2097 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.shareBytes()) != null), 54);
/*      */ 
/* 2100 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2102 */     checkError(t2cLobOpen(this.m_nativeState, 114, arrayOfByte, arrayOfByte.length, paramInt, arrayOfByte1));
/*      */ 
/* 2105 */     paramBFILE.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized void close(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2118 */     byte[] arrayOfByte = null;
/*      */ 
/* 2120 */     checkTrue(this.lifecycle == 1, 8);
/* 2121 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.shareBytes()) != null), 54);
/*      */ 
/* 2124 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2126 */     checkError(t2cLobClose(this.m_nativeState, 114, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2129 */     paramBFILE.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2143 */     byte[] arrayOfByte = null;
/*      */ 
/* 2145 */     checkTrue(this.lifecycle == 1, 8);
/* 2146 */     checkTrue((paramBFILE != null) && ((arrayOfByte = paramBFILE.shareBytes()) != null), 54);
/*      */ 
/* 2149 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 2151 */     checkError(t2cLobIsOpen(this.m_nativeState, 114, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 2154 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BFILE paramBFILE, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2173 */     return newInputStream(paramBFILE, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBfile paramOracleBfile, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2193 */     if (paramLong == 0L)
/*      */     {
/* 2195 */       return new OracleBlobInputStream(paramOracleBfile, paramInt);
/*      */     }
/*      */ 
/* 2199 */     return new OracleBlobInputStream(paramOracleBfile, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2218 */     return newConversionInputStream(paramBFILE, paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(OracleBfile paramOracleBfile, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2237 */     checkTrue((paramOracleBfile != null) && (paramOracleBfile.shareBytes() != null), 54);
/*      */ 
/* 2240 */     OracleConversionInputStream localOracleConversionInputStream = new OracleConversionInputStream(this.conversion, paramOracleBfile.getBinaryStream(), paramInt);
/*      */ 
/* 2242 */     return localOracleConversionInputStream;
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(BFILE paramBFILE, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2261 */     return newConversionReader(paramBFILE, paramInt);
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(OracleBfile paramOracleBfile, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2280 */     checkTrue((paramOracleBfile != null) && (paramOracleBfile.shareBytes() != null), 54);
/*      */ 
/* 2283 */     OracleConversionReader localOracleConversionReader = new OracleConversionReader(this.conversion, paramOracleBfile.getBinaryStream(), paramInt);
/*      */ 
/* 2285 */     return localOracleConversionReader;
/*      */   }
/*      */ 
/*      */   public synchronized long length(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2299 */     byte[] arrayOfByte = null;
/*      */ 
/* 2301 */     checkTrue(this.lifecycle == 1, 8);
/* 2302 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.getLocator()) != null), 54);
/*      */ 
/* 2305 */     return lobLength(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public synchronized long position(BLOB paramBLOB, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2324 */     checkTrue(this.lifecycle == 1, 8);
/* 2325 */     checkTrue((paramBLOB != null) && (paramBLOB.shareBytes() != null), 54);
/*      */ 
/* 2328 */     if (paramLong < 1L)
/*      */     {
/* 2331 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2332 */       localSQLException.fillInStackTrace();
/* 2333 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2337 */     long l = LobPlsqlUtil.hasPattern(paramBLOB, paramArrayOfByte, paramLong);
/*      */ 
/* 2339 */     l = l == 0L ? -1L : l;
/* 2340 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized long position(BLOB paramBLOB1, BLOB paramBLOB2, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2357 */     checkTrue(this.lifecycle == 1, 8);
/* 2358 */     checkTrue((paramBLOB1 != null) && (paramBLOB1.shareBytes() != null), 54);
/*      */ 
/* 2360 */     checkTrue((paramBLOB2 != null) && (paramBLOB2.shareBytes() != null), 54);
/*      */ 
/* 2363 */     if (paramLong < 1L)
/*      */     {
/* 2366 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 2367 */       localSQLException.fillInStackTrace();
/* 2368 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2372 */     long l = LobPlsqlUtil.isSubLob(paramBLOB1, paramBLOB2, paramLong);
/*      */ 
/* 2374 */     l = l == 0L ? -1L : l;
/* 2375 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getBytes(BLOB paramBLOB, long paramLong, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2392 */     byte[] arrayOfByte1 = null;
/* 2393 */     int i = 0;
/*      */ 
/* 2395 */     checkTrue(this.lifecycle == 1, 8);
/* 2396 */     checkTrue((paramBLOB != null) && ((arrayOfByte1 = paramBLOB.getLocator()) != null), 54);
/*      */ 
/* 2399 */     if ((paramInt <= 0) || (paramArrayOfByte == null)) {
/* 2400 */       return 0;
/*      */     }
/* 2402 */     if (paramInt > paramArrayOfByte.length) {
/* 2403 */       paramInt = paramArrayOfByte.length;
/*      */     }
/* 2405 */     long l = -1L;
/*      */     byte[] arrayOfByte2;
/*      */     int j;
/* 2407 */     if (paramBLOB.isActivePrefetch())
/*      */     {
/* 2409 */       arrayOfByte2 = paramBLOB.getPrefetchedData();
/* 2410 */       l = paramBLOB.length();
/* 2411 */       if ((arrayOfByte2 != null) && (arrayOfByte2.length > 0) && (paramLong > 0L) && (paramLong <= arrayOfByte2.length))
/*      */       {
/* 2417 */         j = Math.min(arrayOfByte2.length - (int)paramLong + 1, paramInt);
/*      */ 
/* 2419 */         System.arraycopy(arrayOfByte2, (int)paramLong - 1, paramArrayOfByte, 0, j);
/*      */ 
/* 2421 */         i += j;
/*      */       }
/*      */     }
/*      */ 
/* 2425 */     if ((i < paramInt) && ((l == -1L) || (paramLong - 1L + i < l)))
/*      */     {
/* 2429 */       arrayOfByte2 = paramArrayOfByte;
/* 2430 */       j = i;
/* 2431 */       int k = ((l > 0L) && (l < paramInt) ? (int)l : paramInt) - i;
/*      */ 
/* 2433 */       if (i > 0)
/*      */       {
/* 2435 */         arrayOfByte2 = new byte[k];
/*      */       }
/*      */ 
/* 2438 */       if (this.useNio)
/*      */       {
/* 2440 */         int m = paramArrayOfByte.length;
/* 2441 */         if ((this.nioBufferForLob == null) || (this.nioBufferForLob.capacity() < m))
/*      */         {
/* 2443 */           this.nioBufferForLob = ByteBuffer.allocateDirect(m);
/*      */         }
/* 2445 */         else this.nioBufferForLob.rewind();
/*      */       }
/*      */ 
/* 2448 */       i += blobRead(arrayOfByte1, paramLong + i, k, arrayOfByte2, this.useNio, this.nioBufferForLob);
/*      */ 
/* 2454 */       if (this.useNio)
/*      */       {
/* 2456 */         this.nioBufferForLob.get(arrayOfByte2);
/*      */       }
/*      */ 
/* 2461 */       if (j > 0)
/*      */       {
/* 2463 */         System.arraycopy(arrayOfByte2, 0, paramArrayOfByte, j, arrayOfByte2.length);
/*      */       }
/*      */     }
/*      */ 
/* 2467 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int putBytes(BLOB paramBLOB, long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2489 */     checkTrue((paramLong != 0L) || (paramInt2 > 0), 68);
/*      */ 
/* 2491 */     checkTrue(paramLong >= 0L, 68);
/* 2492 */     if ((paramArrayOfByte == null) || (paramInt2 <= 0)) {
/* 2493 */       return 0;
/*      */     }
/* 2495 */     int i = 0;
/*      */ 
/* 2497 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0) || (paramInt2 <= 0)) {
/* 2498 */       i = 0;
/*      */     }
/*      */     else {
/* 2501 */       byte[] arrayOfByte = null;
/*      */ 
/* 2503 */       checkTrue(this.lifecycle == 1, 8);
/* 2504 */       checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.getLocator()) != null), 54);
/*      */ 
/* 2507 */       byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2509 */       paramBLOB.setActivePrefetch(false);
/* 2510 */       paramBLOB.clearCachedData();
/* 2511 */       i = blobWrite(arrayOfByte, paramLong, paramArrayOfByte, arrayOfByte1, paramInt1, paramInt2);
/*      */ 
/* 2514 */       paramBLOB.setLocator(arrayOfByte1[0]);
/*      */     }
/*      */ 
/* 2517 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getChunkSize(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2529 */     byte[] arrayOfByte = null;
/*      */ 
/* 2531 */     checkTrue(this.lifecycle == 1, 8);
/* 2532 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.getLocator()) != null), 54);
/*      */ 
/* 2535 */     return lobGetChunkSize(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public synchronized void trim(BLOB paramBLOB, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2549 */     byte[] arrayOfByte = null;
/*      */ 
/* 2551 */     checkTrue(this.lifecycle == 1, 8);
/* 2552 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2555 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2557 */     paramBLOB.setActivePrefetch(false);
/* 2558 */     paramBLOB.clearCachedData();
/* 2559 */     checkError(t2cLobTrim(this.m_nativeState, 113, paramLong, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2562 */     paramBLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized BLOB createTemporaryBlob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2581 */     BLOB localBLOB = null;
/*      */ 
/* 2583 */     checkTrue(this.lifecycle == 1, 8);
/*      */ 
/* 2585 */     localBLOB = new BLOB((PhysicalConnection)paramConnection);
/*      */ 
/* 2587 */     byte[][] arrayOfByte = new byte[1][];
/*      */ 
/* 2589 */     checkError(t2cLobCreateTemporary(this.m_nativeState, 113, paramBoolean, paramInt, (short)0, arrayOfByte));
/*      */ 
/* 2592 */     localBLOB.setShareBytes(arrayOfByte[0]);
/*      */ 
/* 2594 */     return localBLOB;
/*      */   }
/*      */ 
/*      */   public synchronized void freeTemporary(BLOB paramBLOB, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 2610 */       byte[] arrayOfByte = null;
/*      */ 
/* 2612 */       checkTrue(this.lifecycle == 1, 8);
/* 2613 */       checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2616 */       byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2618 */       checkError(t2cLobFreeTemporary(this.m_nativeState, 113, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2621 */       paramBLOB.setShareBytes(arrayOfByte1[0]);
/*      */     }
/*      */     catch (SQLException localSQLException) {
/* 2624 */       if ((paramBoolean & localSQLException.getErrorCode() == 64201))
/* 2625 */         LobPlsqlUtil.freeTemporaryLob(this, paramBLOB, 2004);
/*      */       else
/* 2627 */         throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isTemporary(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2643 */     byte[] arrayOfByte = null;
/*      */ 
/* 2645 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2648 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 2650 */     checkError(t2cLobIsTemporary(this.m_nativeState, 113, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 2653 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public synchronized void open(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2666 */     byte[] arrayOfByte = null;
/*      */ 
/* 2668 */     checkTrue(this.lifecycle == 1, 8);
/* 2669 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2672 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2674 */     checkError(t2cLobOpen(this.m_nativeState, 113, arrayOfByte, arrayOfByte.length, paramInt, arrayOfByte1));
/*      */ 
/* 2677 */     paramBLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized void close(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2690 */     byte[] arrayOfByte = null;
/*      */ 
/* 2692 */     checkTrue(this.lifecycle == 1, 8);
/* 2693 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2696 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 2698 */     checkError(t2cLobClose(this.m_nativeState, 113, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 2701 */     paramBLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2715 */     byte[] arrayOfByte = null;
/*      */ 
/* 2717 */     checkTrue(this.lifecycle == 1, 8);
/* 2718 */     checkTrue((paramBLOB != null) && ((arrayOfByte = paramBLOB.shareBytes()) != null), 54);
/*      */ 
/* 2721 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 2723 */     checkError(t2cLobIsOpen(this.m_nativeState, 113, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 2726 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BLOB paramBLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2745 */     return newInputStream(paramBLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2764 */     if (paramLong == 0L)
/*      */     {
/* 2766 */       return new OracleBlobInputStream(paramOracleBlob, paramInt);
/*      */     }
/*      */ 
/* 2770 */     return new OracleBlobInputStream(paramOracleBlob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(BLOB paramBLOB, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 2790 */     return newInputStream(paramBLOB, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 2809 */     return new OracleBlobInputStream(paramOracleBlob, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(BLOB paramBLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2828 */     return newOutputStream(paramBLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2847 */     if (paramLong == 0L)
/*      */     {
/* 2849 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 2852 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2853 */         localSQLException.fillInStackTrace();
/* 2854 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2859 */       return new OracleBlobOutputStream(paramOracleBlob, paramInt);
/*      */     }
/*      */ 
/* 2864 */     return new OracleBlobOutputStream(paramOracleBlob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2883 */     return newConversionInputStream(paramBLOB, paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream newConversionInputStream(OracleBlob paramOracleBlob, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2903 */     checkTrue((paramOracleBlob != null) && (paramOracleBlob.shareBytes() != null), 54);
/*      */ 
/* 2906 */     OracleConversionInputStream localOracleConversionInputStream = new OracleConversionInputStream(this.conversion, paramOracleBlob.getBinaryStream(), paramInt);
/*      */ 
/* 2908 */     return localOracleConversionInputStream;
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(BLOB paramBLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2926 */     return newConversionReader(paramBLOB, paramInt);
/*      */   }
/*      */ 
/*      */   public Reader newConversionReader(OracleBlob paramOracleBlob, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2945 */     checkTrue((paramOracleBlob != null) && (paramOracleBlob.shareBytes() != null), 54);
/*      */ 
/* 2948 */     OracleConversionReader localOracleConversionReader = new OracleConversionReader(this.conversion, paramOracleBlob.getBinaryStream(), paramInt);
/*      */ 
/* 2950 */     return localOracleConversionReader;
/*      */   }
/*      */ 
/*      */   public synchronized long length(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 2968 */     byte[] arrayOfByte = null;
/*      */ 
/* 2970 */     checkTrue(this.lifecycle == 1, 8);
/* 2971 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.getLocator()) != null), 54);
/*      */ 
/* 2974 */     return lobLength(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public synchronized long position(CLOB paramCLOB, String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2992 */     if (paramString == null)
/*      */     {
/* 2994 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2995 */       ((SQLException)localObject).fillInStackTrace();
/* 2996 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 2999 */     checkTrue(this.lifecycle == 1, 8);
/* 3000 */     checkTrue((paramCLOB != null) && (paramCLOB.shareBytes() != null), 54);
/*      */ 
/* 3003 */     if (paramLong < 1L)
/*      */     {
/* 3006 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3007 */       ((SQLException)localObject).fillInStackTrace();
/* 3008 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 3012 */     Object localObject = new char[paramString.length()];
/*      */ 
/* 3014 */     paramString.getChars(0, localObject.length, (char[])localObject, 0);
/*      */ 
/* 3016 */     long l = LobPlsqlUtil.hasPattern(paramCLOB, (char[])localObject, paramLong);
/*      */ 
/* 3018 */     l = l == 0L ? -1L : l;
/* 3019 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized long position(CLOB paramCLOB1, CLOB paramCLOB2, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3036 */     checkTrue(this.lifecycle == 1, 8);
/* 3037 */     checkTrue((paramCLOB1 != null) && (paramCLOB1.shareBytes() != null), 54);
/*      */ 
/* 3039 */     checkTrue((paramCLOB2 != null) && (paramCLOB2.shareBytes() != null), 54);
/*      */ 
/* 3042 */     if (paramLong < 1L)
/*      */     {
/* 3045 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 3046 */       localSQLException.fillInStackTrace();
/* 3047 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3051 */     long l = LobPlsqlUtil.isSubLob(paramCLOB1, paramCLOB2, paramLong);
/*      */ 
/* 3053 */     l = l == 0L ? -1L : l;
/* 3054 */     return l;
/*      */   }
/*      */ 
/*      */   public synchronized int getChars(CLOB paramCLOB, long paramLong, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 3071 */     byte[] arrayOfByte = null;
/*      */ 
/* 3073 */     checkTrue(this.lifecycle == 1, 8);
/* 3074 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.getLocator()) != null), 54);
/*      */ 
/* 3077 */     if ((paramInt <= 0) || (paramArrayOfChar == null)) {
/* 3078 */       return 0;
/*      */     }
/* 3080 */     if (paramInt > paramArrayOfChar.length) {
/* 3081 */       paramInt = paramArrayOfChar.length;
/*      */     }
/* 3083 */     int i = 0;
/*      */ 
/* 3086 */     long l1 = -1L;
/*      */     char[] arrayOfChar;
/*      */     int m;
/* 3089 */     if (paramCLOB.isActivePrefetch())
/*      */     {
/* 3091 */       l1 = paramCLOB.length();
/* 3092 */       arrayOfChar = paramCLOB.getPrefetchedData();
/* 3093 */       long l2 = paramCLOB.getPrefetchedDataSize();
/*      */ 
/* 3096 */       if ((arrayOfChar != null) && (paramLong <= l2))
/*      */       {
/* 3099 */         m = Math.min((int)l2 - (int)paramLong + 1, paramInt);
/*      */ 
/* 3102 */         System.arraycopy(arrayOfChar, (int)paramLong - 1, paramArrayOfChar, 0, m);
/*      */ 
/* 3104 */         i += m;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3109 */     if ((i < paramInt) && ((l1 == -1L) || (paramLong - 1L + i < l1)))
/*      */     {
/* 3114 */       arrayOfChar = paramArrayOfChar;
/* 3115 */       int j = i;
/* 3116 */       int k = ((l1 > 0L) && (l1 < paramInt) ? (int)l1 : paramInt) - i;
/*      */ 
/* 3118 */       if (i > 0)
/*      */       {
/* 3120 */         arrayOfChar = new char[k];
/*      */       }
/*      */ 
/* 3123 */       if (this.useNio)
/*      */       {
/* 3127 */         m = paramArrayOfChar.length * 2;
/* 3128 */         if ((this.nioBufferForLob == null) || (this.nioBufferForLob.capacity() < m))
/* 3129 */           this.nioBufferForLob = ByteBuffer.allocateDirect(m);
/*      */         else {
/* 3131 */           this.nioBufferForLob.rewind();
/*      */         }
/*      */       }
/* 3134 */       i += t2cClobRead(this.m_nativeState, arrayOfByte, arrayOfByte.length, paramLong + i, k, arrayOfChar, arrayOfChar.length, paramCLOB.isNCLOB(), this.useNio, this.nioBufferForLob);
/*      */ 
/* 3146 */       if (this.useNio)
/*      */       {
/* 3148 */         ByteBuffer localByteBuffer = this.nioBufferForLob.order(ByteOrder.LITTLE_ENDIAN);
/* 3149 */         CharBuffer localCharBuffer = localByteBuffer.asCharBuffer();
/* 3150 */         localCharBuffer.get(arrayOfChar);
/*      */       }
/*      */ 
/* 3155 */       if (j > 0)
/*      */       {
/* 3157 */         System.arraycopy(arrayOfChar, 0, paramArrayOfChar, j, arrayOfChar.length);
/*      */       }
/*      */ 
/* 3160 */       checkError(i);
/*      */     }
/*      */ 
/* 3163 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int putChars(CLOB paramCLOB, long paramLong, char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3184 */     byte[] arrayOfByte = null;
/*      */ 
/* 3186 */     checkTrue(this.lifecycle == 1, 8);
/* 3187 */     checkTrue(paramLong >= 0L, 68);
/*      */ 
/* 3189 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.getLocator()) != null), 54);
/*      */ 
/* 3192 */     if (paramArrayOfChar == null) {
/* 3193 */       return 0;
/*      */     }
/* 3195 */     byte[][] arrayOfByte1 = new byte[1][];
/* 3196 */     paramCLOB.setActivePrefetch(false);
/* 3197 */     paramCLOB.clearCachedData();
/* 3198 */     int i = clobWrite(arrayOfByte, paramLong, paramArrayOfChar, arrayOfByte1, paramCLOB.isNCLOB(), paramInt1, paramInt2);
/*      */ 
/* 3201 */     paramCLOB.setLocator(arrayOfByte1[0]);
/*      */ 
/* 3203 */     return i;
/*      */   }
/*      */ 
/*      */   public synchronized int getChunkSize(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3215 */     byte[] arrayOfByte = null;
/*      */ 
/* 3217 */     checkTrue(this.lifecycle == 1, 8);
/* 3218 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.getLocator()) != null), 54);
/*      */ 
/* 3221 */     return lobGetChunkSize(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public synchronized void trim(CLOB paramCLOB, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3235 */     byte[] arrayOfByte = null;
/*      */ 
/* 3237 */     checkTrue(this.lifecycle == 1, 8);
/* 3238 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3241 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 3243 */     paramCLOB.setActivePrefetch(false);
/* 3244 */     paramCLOB.clearCachedData();
/* 3245 */     checkError(t2cLobTrim(this.m_nativeState, 112, paramLong, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 3248 */     paramCLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized CLOB createTemporaryClob(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 3268 */     Object localObject = null;
/*      */ 
/* 3270 */     checkTrue(this.lifecycle == 1, 8);
/*      */ 
/* 3272 */     if (paramShort == 1) {
/* 3273 */       localObject = new CLOB((PhysicalConnection)paramConnection);
/*      */     }
/*      */     else {
/* 3276 */       localObject = new NCLOB((PhysicalConnection)paramConnection);
/*      */     }
/*      */ 
/* 3279 */     byte[][] arrayOfByte = new byte[1][];
/*      */ 
/* 3281 */     checkError(t2cLobCreateTemporary(this.m_nativeState, 112, paramBoolean, paramInt, paramShort, arrayOfByte));
/*      */ 
/* 3284 */     ((CLOB)localObject).setShareBytes(arrayOfByte[0]);
/*      */ 
/* 3286 */     return localObject;
/*      */   }
/*      */ 
/*      */   public synchronized void freeTemporary(CLOB paramCLOB, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 3301 */       byte[] arrayOfByte = null;
/*      */ 
/* 3303 */       checkTrue(this.lifecycle == 1, 8);
/* 3304 */       checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3307 */       byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 3309 */       checkError(t2cLobFreeTemporary(this.m_nativeState, 112, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 3312 */       paramCLOB.setShareBytes(arrayOfByte1[0]);
/*      */     }
/*      */     catch (SQLException localSQLException) {
/* 3315 */       if ((paramBoolean & localSQLException.getErrorCode() == 64201))
/* 3316 */         LobPlsqlUtil.freeTemporaryLob(this, paramCLOB, 2005);
/*      */       else
/* 3318 */         throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized boolean isTemporary(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3335 */     byte[] arrayOfByte = null;
/*      */ 
/* 3337 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3340 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 3342 */     checkError(t2cLobIsTemporary(this.m_nativeState, 112, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 3345 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public synchronized void open(CLOB paramCLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3358 */     byte[] arrayOfByte = null;
/*      */ 
/* 3360 */     checkTrue(this.lifecycle == 1, 8);
/* 3361 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3364 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 3366 */     checkError(t2cLobOpen(this.m_nativeState, 112, arrayOfByte, arrayOfByte.length, paramInt, arrayOfByte1));
/*      */ 
/* 3369 */     paramCLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized void close(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3382 */     byte[] arrayOfByte = null;
/*      */ 
/* 3384 */     checkTrue(this.lifecycle == 1, 8);
/* 3385 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3388 */     byte[][] arrayOfByte1 = new byte[1][];
/*      */ 
/* 3390 */     checkError(t2cLobClose(this.m_nativeState, 112, arrayOfByte, arrayOfByte.length, arrayOfByte1));
/*      */ 
/* 3393 */     paramCLOB.setShareBytes(arrayOfByte1[0]);
/*      */   }
/*      */ 
/*      */   public synchronized boolean isOpen(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3407 */     byte[] arrayOfByte = null;
/*      */ 
/* 3409 */     checkTrue(this.lifecycle == 1, 8);
/* 3410 */     checkTrue((paramCLOB != null) && ((arrayOfByte = paramCLOB.shareBytes()) != null), 54);
/*      */ 
/* 3413 */     boolean[] arrayOfBoolean = new boolean[1];
/*      */ 
/* 3415 */     checkError(t2cLobIsOpen(this.m_nativeState, 112, arrayOfByte, arrayOfByte.length, arrayOfBoolean));
/*      */ 
/* 3418 */     return arrayOfBoolean[0];
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(CLOB paramCLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3437 */     return newInputStream(paramCLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public InputStream newInputStream(OracleClob paramOracleClob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3457 */     if (paramLong == 0L)
/*      */     {
/* 3459 */       return new OracleClobInputStream(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 3463 */     return new OracleClobInputStream(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(CLOB paramCLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3484 */     return newOutputStream(paramCLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public OutputStream newOutputStream(OracleClob paramOracleClob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3504 */     if (paramLong == 0L)
/*      */     {
/* 3506 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 3509 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3510 */         localSQLException.fillInStackTrace();
/* 3511 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3516 */       return new OracleClobOutputStream(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 3521 */     return new OracleClobOutputStream(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(CLOB paramCLOB, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3540 */     return newReader(paramCLOB, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(OracleClob paramOracleClob, int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3558 */     if (paramLong == 0L)
/*      */     {
/* 3560 */       return new OracleClobReader(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 3564 */     return new OracleClobReader(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public Reader newReader(CLOB paramCLOB, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 3584 */     return newReader(paramCLOB, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public Reader newReader(OracleClob paramOracleClob, int paramInt, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 3603 */     return new OracleClobReader(paramOracleClob, paramInt, paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   public Writer newWriter(CLOB paramCLOB, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3623 */     return newWriter(paramCLOB, paramInt, paramLong, paramBoolean);
/*      */   }
/*      */ 
/*      */   public Writer newWriter(OracleClob paramOracleClob, int paramInt, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3642 */     if (paramLong == 0L)
/*      */     {
/* 3644 */       if ((paramBoolean & this.lobStreamPosStandardCompliant))
/*      */       {
/* 3647 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3648 */         localSQLException.fillInStackTrace();
/* 3649 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3654 */       return new OracleClobWriter(paramOracleClob, paramInt);
/*      */     }
/*      */ 
/* 3659 */     return new OracleClobWriter(paramOracleClob, paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public synchronized void registerTAFCallback(OracleOCIFailover paramOracleOCIFailover, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 3686 */     this.appCallback = paramOracleOCIFailover;
/* 3687 */     this.appCallbackObject = paramObject;
/*      */ 
/* 3689 */     checkError(t2cRegisterTAFCallback(this.m_nativeState));
/*      */   }
/*      */ 
/*      */   synchronized int callTAFCallbackMethod(int paramInt1, int paramInt2)
/*      */   {
/* 3699 */     int i = 0;
/*      */ 
/* 3702 */     if (this.appCallback != null) {
/* 3703 */       i = this.appCallback.callbackFn(this, this.appCallbackObject, paramInt1, paramInt2);
/*      */     }
/* 3705 */     return i;
/*      */   }
/*      */ 
/*      */   public int getHeapAllocSize()
/*      */     throws SQLException
/*      */   {
/* 3719 */     if (this.lifecycle != 1)
/*      */     {
/* 3721 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 3722 */       localSQLException1.fillInStackTrace();
/* 3723 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3728 */     int i = t2cGetHeapAllocSize(this.m_nativeState);
/*      */ 
/* 3730 */     if (i < 0)
/*      */     {
/* 3732 */       if (i == -999)
/*      */       {
/* 3734 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 3735 */         localSQLException2.fillInStackTrace();
/* 3736 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 3742 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/* 3743 */       localSQLException2.fillInStackTrace();
/* 3744 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 3748 */     return i;
/*      */   }
/*      */ 
/*      */   public int getOCIEnvHeapAllocSize()
/*      */     throws SQLException
/*      */   {
/* 3761 */     if (this.lifecycle != 1)
/*      */     {
/* 3763 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 3764 */       localSQLException1.fillInStackTrace();
/* 3765 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 3770 */     int i = t2cGetOciEnvHeapAllocSize(this.m_nativeState);
/*      */ 
/* 3772 */     if (i < 0)
/*      */     {
/* 3774 */       if (i == -999)
/*      */       {
/* 3776 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 3777 */         localSQLException2.fillInStackTrace();
/* 3778 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 3781 */       checkError(i);
/*      */ 
/* 3785 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/* 3786 */       localSQLException2.fillInStackTrace();
/* 3787 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 3791 */     return i;
/*      */   }
/*      */ 
/*      */   public static final short getClientCharSetId()
/*      */   {
/* 3800 */     return 871;
/*      */   }
/*      */ 
/*      */   public static short getDriverCharSetIdFromNLS_LANG(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3816 */     if (!isLibraryLoaded) {
/* 3817 */       loadNativeLibrary(paramString);
/*      */     }
/*      */ 
/* 3820 */     short s = t2cGetDriverCharSetFromNlsLang();
/*      */ 
/* 3823 */     if (s < 0)
/*      */     {
/* 3825 */       SQLException localSQLException = DatabaseError.createSqlException(null, 8);
/* 3826 */       localSQLException.fillInStackTrace();
/* 3827 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3831 */     return s;
/*      */   }
/*      */ 
/*      */   void doProxySession(int paramInt, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/* 3844 */     Object localObject1 = (byte[][])null;
/*      */ 
/* 3850 */     int i = 0;
/*      */ 
/* 3852 */     this.savedUser = this.userName;
/* 3853 */     this.userName = null;
/*      */     byte[] arrayOfByte4;
/*      */     byte[] arrayOfByte3;
/*      */     byte[] arrayOfByte2;
/* 3855 */     byte[] arrayOfByte1 = arrayOfByte2 = arrayOfByte3 = arrayOfByte4 = new byte[0];
/*      */ 
/* 3857 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/* 3860 */       this.userName = paramProperties.getProperty("PROXY_USER_NAME");
/* 3861 */       String str1 = paramProperties.getProperty("PROXY_USER_PASSWORD");
/* 3862 */       if (this.userName != null) {
/* 3863 */         arrayOfByte1 = DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
/*      */       }
/* 3865 */       if (str1 != null)
/* 3866 */         arrayOfByte2 = DBConversion.stringToDriverCharBytes(str1, this.m_clientCharacterSet); break;
/*      */     case 2:
/* 3869 */       String str2 = paramProperties.getProperty("PROXY_DISTINGUISHED_NAME");
/* 3870 */       if (str2 != null)
/* 3871 */         arrayOfByte3 = DBConversion.stringToDriverCharBytes(str2, this.m_clientCharacterSet); break;
/*      */     case 3:
/* 3875 */       Object localObject2 = paramProperties.get("PROXY_CERTIFICATE");
/* 3876 */       arrayOfByte4 = (byte[])localObject2;
/*      */     }
/*      */ 
/* 3879 */     String[] arrayOfString = (String[])paramProperties.get("PROXY_ROLES");
/*      */ 
/* 3881 */     if (arrayOfString != null)
/*      */     {
/* 3883 */       i = arrayOfString.length;
/* 3884 */       localObject1 = new byte[i][];
/* 3885 */       for (int j = 0; j < i; j++)
/*      */       {
/* 3887 */         if (arrayOfString[j] == null)
/*      */         {
/* 3889 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/* 3890 */           localSQLException.fillInStackTrace();
/* 3891 */           throw localSQLException;
/*      */         }
/*      */ 
/* 3894 */         localObject1[j] = DBConversion.stringToDriverCharBytes(arrayOfString[j], this.m_clientCharacterSet);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3899 */     this.sqlWarning = checkError(t2cDoProxySession(this.m_nativeState, paramInt, arrayOfByte1, arrayOfByte1.length, arrayOfByte2, arrayOfByte2.length, arrayOfByte3, arrayOfByte3.length, arrayOfByte4, arrayOfByte4.length, i, (byte[][])localObject1), this.sqlWarning);
/*      */ 
/* 3913 */     this.isProxy = true;
/*      */   }
/*      */ 
/*      */   void closeProxySession()
/*      */     throws SQLException
/*      */   {
/* 3920 */     checkError(t2cCloseProxySession(this.m_nativeState));
/* 3921 */     this.userName = this.savedUser;
/*      */   }
/*      */ 
/*      */   protected void doDescribeTable(AutoKeyInfo paramAutoKeyInfo)
/*      */     throws SQLException
/*      */   {
/* 3929 */     String str = paramAutoKeyInfo.getTableName();
/*      */ 
/* 3931 */     byte[] arrayOfByte = DBConversion.stringToDriverCharBytes(str, this.m_clientCharacterSet);
/*      */     int i;
/*      */     int j;
/*      */     do
/*      */     {
/* 3939 */       i = 0;
/* 3940 */       j = t2cDescribeTable(this.m_nativeState, arrayOfByte, arrayOfByte.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size);
/*      */ 
/* 3950 */       if (j == -1)
/*      */       {
/* 3952 */         checkError(j);
/*      */       }
/*      */ 
/* 3956 */       if (j == T2CStatement.T2C_EXTEND_BUFFER)
/*      */       {
/* 3958 */         i = 1;
/*      */ 
/* 3960 */         reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
/*      */       }
/*      */     }
/* 3963 */     while (i != 0);
/*      */ 
/* 3965 */     processDescribeTableData(j, paramAutoKeyInfo);
/*      */   }
/*      */ 
/*      */   private void processDescribeTableData(int paramInt, AutoKeyInfo paramAutoKeyInfo)
/*      */     throws SQLException
/*      */   {
/* 3974 */     short[] arrayOfShort = this.queryMetaData1;
/* 3975 */     byte[] arrayOfByte = this.queryMetaData2;
/* 3976 */     int i = this.queryMetaData1Offset;
/* 3977 */     int j = this.queryMetaData2Offset;
/*      */ 
/* 3992 */     paramAutoKeyInfo.allocateSpaceForDescribedData(paramInt);
/*      */ 
/* 3994 */     for (int i6 = 0; i6 < paramInt; i6++)
/*      */     {
/* 3996 */       int m = arrayOfShort[(i + 0)];
/* 3997 */       int k = arrayOfShort[(i + 6)];
/* 3998 */       String str1 = bytes2String(arrayOfByte, j, k, this.conversion);
/*      */ 
/* 4001 */       int n = arrayOfShort[(i + 1)];
/* 4002 */       int i1 = arrayOfShort[(i + 11)];
/* 4003 */       boolean bool = arrayOfShort[(i + 2)] != 0;
/* 4004 */       short s = arrayOfShort[(i + 5)];
/* 4005 */       int i2 = arrayOfShort[(i + 3)];
/* 4006 */       int i3 = arrayOfShort[(i + 4)];
/* 4007 */       int i4 = arrayOfShort[(i + 12)];
/* 4008 */       int i5 = arrayOfShort[(i + 13)] != 0 ? 1 : 0;
/*      */ 
/* 4010 */       j += k;
/* 4011 */       i += 14;
/*      */ 
/* 4013 */       String str2 = null;
/* 4014 */       if (i4 > 0)
/*      */       {
/* 4016 */         str2 = bytes2String(arrayOfByte, j, i4, this.conversion);
/*      */ 
/* 4018 */         j += i4;
/*      */       }
/*      */ 
/* 4022 */       paramAutoKeyInfo.fillDescribedData(i6, str1, m, i1 > 0 ? i1 : n, bool, s, i2, i3, str2);
/*      */     }
/*      */   }
/*      */ 
/*      */   void doSetApplicationContext(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4036 */     checkError(t2cSetApplicationContext(this.m_nativeState, paramString1, paramString2, paramString3));
/*      */   }
/*      */ 
/*      */   void doClearAllApplicationContext(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4045 */     checkError(t2cClearAllApplicationContext(this.m_nativeState, paramString));
/*      */   }
/*      */ 
/*      */   void doStartup(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4053 */     checkError(t2cStartupDatabase(this.m_nativeState, paramInt));
/*      */   }
/*      */ 
/*      */   void doShutdown(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4061 */     checkError(t2cShutdownDatabase(this.m_nativeState, paramInt));
/*      */   }
/*      */ 
/*      */   private static final void loadNativeLibrary(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4073 */     if ((paramString == null) || (paramString.equals("ocijdbc12")))
/*      */     {
/* 4075 */       synchronized (T2CConnection.class)
/*      */       {
/* 4077 */         if (!isLibraryLoaded)
/*      */         {
/* 4079 */           AccessController.doPrivileged(new PrivilegedAction()
/*      */           {
/*      */             public Object run()
/*      */             {
/* 4083 */               System.loadLibrary("ocijdbc12");
/* 4084 */               int i = T2CConnection.getLibraryVersionNumber();
/* 4085 */               if (i != T2CConnection.JDBC_OCI_LIBRARY_VERSION) {
/* 4086 */                 throw new Error("Incompatible version of libocijdbc[Jdbc:" + T2CConnection.JDBC_OCI_LIBRARY_VERSION + ", Jdbc-OCI:" + i);
/*      */               }
/*      */ 
/* 4089 */               return null;
/*      */             }
/*      */           });
/* 4092 */           isLibraryLoaded = true;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 4099 */       synchronized (T2CConnection.class)
/*      */       {
/*      */         try
/*      */         {
/* 4103 */           System.loadLibrary(paramString);
/* 4104 */           isLibraryLoaded = true;
/*      */         }
/*      */         catch (SecurityException localSecurityException)
/*      */         {
/* 4108 */           if (!isLibraryLoaded)
/*      */           {
/* 4110 */             System.loadLibrary(paramString);
/* 4111 */             isLibraryLoaded = true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private final void checkTrue(boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4124 */     if (!paramBoolean)
/*      */     {
/* 4126 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), paramInt);
/* 4127 */       localSQLException.fillInStackTrace();
/* 4128 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean useLittleEndianSetCHARBinder()
/*      */     throws SQLException
/*      */   {
/* 4136 */     return t2cPlatformIsLittleEndian(this.m_nativeState);
/*      */   }
/*      */ 
/*      */   public void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/* 4144 */     super.getPropertyForPooledConnection(paramOraclePooledConnection, this.password);
/*      */   }
/*      */ 
/*      */   static final char[] getCharArray(String paramString)
/*      */   {
/* 4151 */     char[] arrayOfChar = null;
/*      */ 
/* 4153 */     if (paramString == null)
/*      */     {
/* 4155 */       arrayOfChar = new char[0];
/*      */     }
/*      */     else
/*      */     {
/* 4159 */       arrayOfChar = new char[paramString.length()];
/*      */ 
/* 4161 */       paramString.getChars(0, paramString.length(), arrayOfChar, 0);
/*      */     }
/*      */ 
/* 4164 */     return arrayOfChar;
/*      */   }
/*      */ 
/*      */   static String bytes2String(byte[] paramArrayOfByte, int paramInt1, int paramInt2, DBConversion paramDBConversion)
/*      */     throws SQLException
/*      */   {
/* 4174 */     byte[] arrayOfByte = new byte[paramInt2];
/* 4175 */     System.arraycopy(paramArrayOfByte, paramInt1, arrayOfByte, 0, paramInt2);
/*      */ 
/* 4177 */     return paramDBConversion.CharBytesToString(arrayOfByte, paramInt2);
/*      */   }
/*      */ 
/*      */   void disableNio()
/*      */   {
/* 4185 */     this.useNio = false;
/*      */   }
/*      */ 
/*      */   private static synchronized void doSetSessionTimeZone(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4193 */     t2cSetSessionTimeZone(paramString);
/*      */   }
/*      */ 
/*      */   public void incrementTempLobReferenceCount(byte[] paramArrayOfByte) throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public int decrementTempLobReferenceCount(byte[] paramArrayOfByte) throws SQLException {
/* 4201 */     return 0;
/*      */   }
/*      */ 
/*      */   void releaseConnectionToPool()
/*      */     throws SQLException
/*      */   {
/* 4209 */     if ((!this.drcpEnabled) || (this.drcpState != PhysicalConnection.DrcpState.STATEFUL)) {
/* 4210 */       return;
/*      */     }
/* 4212 */     this.drcpState = PhysicalConnection.DrcpState.STATELESS;
/*      */ 
/* 4214 */     int i = 0;
/* 4215 */     byte[] arrayOfByte = EMPTY_BYTES;
/* 4216 */     if (this.drcpTagName != null)
/*      */     {
/* 4218 */       this.tagMatched[0] = false;
/* 4219 */       arrayOfByte = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
/*      */ 
/* 4221 */       i = 2;
/*      */     }
/*      */     else {
/* 4224 */       this.tagMatched[0] = true;
/*      */     }
/*      */ 
/* 4228 */     checkError(t2cCloseDrcpConnection(this.m_nativeState, arrayOfByte, arrayOfByte.length, i), this.sqlWarning);
/*      */   }
/*      */ 
/*      */   boolean reusePooledConnection()
/*      */     throws SQLException
/*      */   {
/* 4237 */     if (this.drcpState != PhysicalConnection.DrcpState.STATEFUL) {
/* 4238 */       this.drcpState = PhysicalConnection.DrcpState.STATEFUL;
/* 4239 */       byte[] arrayOfByte = EMPTY_BYTES;
/*      */ 
/* 4241 */       if (this.drcpTagName != null) {
/* 4242 */         arrayOfByte = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
/*      */       }
/*      */ 
/* 4245 */       checkError(t2cOpenDrcpConnection(this.m_nativeState, arrayOfByte, arrayOfByte.length, this.tagMatched), this.sqlWarning);
/*      */     }
/*      */ 
/* 4251 */     return this.tagMatched[0];
/*      */   }
/*      */ 
/*      */   public boolean needToPurgeStatementCache()
/*      */     throws SQLException
/*      */   {
/* 4266 */     if (this.lifecycle != 1)
/*      */     {
/* 4268 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 4269 */       localSQLException.fillInStackTrace();
/* 4270 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4273 */     if (!this.drcpEnabled) return true;
/* 4274 */     return true;
/*      */   }
/*      */ 
/*      */   public String getCurrentSchema()
/*      */     throws SQLException
/*      */   {
/* 4288 */     if (this.lifecycle != 1)
/*      */     {
/* 4290 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 4291 */       ((SQLException)localObject).fillInStackTrace();
/* 4292 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 4295 */     Object localObject = new byte[258];
/*      */     int i;
/* 4298 */     checkError(i = t2cGetSchemaName(this.m_nativeState, (byte[])localObject));
/*      */ 
/* 4300 */     if (i > 0) {
/* 4301 */       return this.conversion.CharBytesToString((byte[])localObject, i);
/*      */     }
/* 4303 */     return this.userName;
/*      */   }
/*      */ 
/*      */   static native int getLibraryVersionNumber();
/*      */ 
/*      */   static native short t2cGetServerSessionInfo(long paramLong, Properties paramProperties);
/*      */ 
/*      */   static native short t2cGetDriverCharSetFromNlsLang();
/*      */ 
/*      */   native int t2cDescribeError(long paramLong, T2CError paramT2CError, byte[] paramArrayOfByte);
/*      */ 
/*      */   native int t2cCreateState(byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3, byte[] paramArrayOfByte4, int paramInt4, byte[] paramArrayOfByte5, int paramInt5, byte[] paramArrayOfByte6, int paramInt6, byte[] paramArrayOfByte7, int paramInt7, byte[] paramArrayOfByte8, int paramInt8, byte[] paramArrayOfByte9, int paramInt9, short paramShort, int paramInt10, byte[] paramArrayOfByte10, byte[] paramArrayOfByte11, byte[] paramArrayOfByte12, long[] paramArrayOfLong);
/*      */ 
/*      */   native int t2cLogon(long paramLong, byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3, byte[] paramArrayOfByte4, int paramInt4, byte[] paramArrayOfByte5, int paramInt5, byte[] paramArrayOfByte6, int paramInt6, byte[] paramArrayOfByte7, int paramInt7, byte[] paramArrayOfByte8, int paramInt8, byte[] paramArrayOfByte9, int paramInt9, int paramInt10, byte[] paramArrayOfByte10, byte[] paramArrayOfByte11, byte[] paramArrayOfByte12, long[] paramArrayOfLong);
/*      */ 
/*      */   private native int t2cLogoff(long paramLong);
/*      */ 
/*      */   private native int t2cCancel(long paramLong);
/*      */ 
/*      */   private native byte t2cGetAsmVolProperty(long paramLong);
/*      */ 
/*      */   private native byte t2cGetInstanceType(long paramLong);
/*      */ 
/*      */   private native int t2cCreateStatement(long paramLong1, long paramLong2, byte[] paramArrayOfByte, int paramInt1, OracleStatement paramOracleStatement, boolean paramBoolean, int paramInt2);
/*      */ 
/*      */   private native int t2cSetAutoCommit(long paramLong, boolean paramBoolean);
/*      */ 
/*      */   private native int t2cCommit(long paramLong, int paramInt);
/*      */ 
/*      */   private native int t2cRollback(long paramLong);
/*      */ 
/*      */   private native int t2cPingDatabase(long paramLong);
/*      */ 
/*      */   private native byte[] t2cGetProductionVersion(long paramLong);
/*      */ 
/*      */   private native int t2cGetVersionNumber(long paramLong);
/*      */ 
/*      */   private native int t2cGetDefaultStreamChunkSize(long paramLong);
/*      */ 
/*      */   native int t2cGetFormOfUse(long paramLong, OracleTypeCLOB paramOracleTypeCLOB, byte[] paramArrayOfByte, int paramInt1, int paramInt2);
/*      */ 
/*      */   native long t2cGetTDO(long paramLong, byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt);
/*      */ 
/*      */   native int t2cCreateConnPool(byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3, short paramShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, int paramInt10);
/*      */ 
/*      */   native int t2cConnPoolLogon(long paramLong, byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3, byte[] paramArrayOfByte4, int paramInt4, byte[] paramArrayOfByte5, int paramInt5, int paramInt6, int paramInt7, int paramInt8, String[] paramArrayOfString, byte[] paramArrayOfByte6, int paramInt9, byte[] paramArrayOfByte7, int paramInt10, byte[] paramArrayOfByte8, int paramInt11, byte[] paramArrayOfByte9, int paramInt12, byte[] paramArrayOfByte10, int paramInt13, byte[] paramArrayOfByte11, byte[] paramArrayOfByte12, long[] paramArrayOfLong);
/*      */ 
/*      */   native int t2cGetConnPoolInfo(long paramLong, Properties paramProperties);
/*      */ 
/*      */   native int t2cSetConnPoolInfo(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6);
/*      */ 
/*      */   native int t2cPasswordChange(long paramLong, byte[] paramArrayOfByte1, int paramInt1, byte[] paramArrayOfByte2, int paramInt2, byte[] paramArrayOfByte3, int paramInt3);
/*      */ 
/*      */   protected native byte[] t2cGetConnectionId(long paramLong);
/*      */ 
/*      */   native int t2cGetHandles(long paramLong, long[] paramArrayOfLong);
/*      */ 
/*      */   native int t2cUseConnection(long paramLong1, long paramLong2, long paramLong3, long paramLong4, byte[] paramArrayOfByte, long[] paramArrayOfLong);
/*      */ 
/*      */   native boolean t2cPlatformIsLittleEndian(long paramLong);
/*      */ 
/*      */   native int t2cRegisterTAFCallback(long paramLong);
/*      */ 
/*      */   native int t2cGetHeapAllocSize(long paramLong);
/*      */ 
/*      */   native int t2cGetOciEnvHeapAllocSize(long paramLong);
/*      */ 
/*      */   native int t2cDoProxySession(long paramLong, int paramInt1, byte[] paramArrayOfByte1, int paramInt2, byte[] paramArrayOfByte2, int paramInt3, byte[] paramArrayOfByte3, int paramInt4, byte[] paramArrayOfByte4, int paramInt5, int paramInt6, byte[][] paramArrayOfByte);
/*      */ 
/*      */   native int t2cCloseProxySession(long paramLong);
/*      */ 
/*      */   static native int t2cDescribeTable(long paramLong, byte[] paramArrayOfByte1, int paramInt1, short[] paramArrayOfShort, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4, int paramInt5);
/*      */ 
/*      */   native int t2cSetApplicationContext(long paramLong, String paramString1, String paramString2, String paramString3);
/*      */ 
/*      */   native int t2cClearAllApplicationContext(long paramLong, String paramString);
/*      */ 
/*      */   native int t2cStartupDatabase(long paramLong, int paramInt);
/*      */ 
/*      */   native int t2cShutdownDatabase(long paramLong, int paramInt);
/*      */ 
/*      */   static native void t2cSetSessionTimeZone(String paramString);
/*      */ 
/*      */   native int t2cCloseDrcpConnection(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2);
/*      */ 
/*      */   native int t2cOpenDrcpConnection(long paramLong, byte[] paramArrayOfByte, int paramInt, boolean[] paramArrayOfBoolean);
/*      */ 
/*      */   native int t2cSetCachedServerVersion(long paramLong, short paramShort);
/*      */ 
/*      */   native int t2cGetImplicitResultSetStatement(long paramLong1, long paramLong2, OracleStatement paramOracleStatement);
/*      */ 
/*      */   native int t2cGetSchemaName(long paramLong, byte[] paramArrayOfByte);
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CConnection
 * JD-Core Version:    0.6.2
 */