/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class T2CCharByteArray extends AggregateByteArray
/*     */ {
/*     */   char[] charArray;
/*     */   DBConversion conversion;
/* 155 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   T2CCharByteArray(char[] paramArrayOfChar, ByteArray paramByteArray)
/*     */   {
/*  47 */     super(PhysicalConnection.EMPTY_BYTE_ARRAY, paramByteArray);
/*  48 */     this.charArray = paramArrayOfChar;
/*     */   }
/*     */ 
/*     */   long length()
/*     */   {
/*  54 */     return this.charArray.length + this.extension.length();
/*     */   }
/*     */ 
/*     */   void setChars(char[] paramArrayOfChar)
/*     */   {
/*  60 */     this.charArray = paramArrayOfChar;
/*     */   }
/*     */ 
/*     */   void setDBConversion(DBConversion paramDBConversion)
/*     */   {
/*  65 */     this.conversion = paramDBConversion;
/*     */   }
/*     */ 
/*     */   char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/*  90 */     if (paramLong < this.charArray.length)
/*     */     {
/*  92 */       char[] arrayOfChar = new char[paramInt];
/*     */ 
/*  94 */       System.arraycopy(this.charArray, (int)paramLong, arrayOfChar, 0, paramInt);
/*     */ 
/*  99 */       paramArrayOfInt[0] = paramInt;
/* 100 */       return arrayOfChar;
/*     */     }
/*     */ 
/* 103 */     return this.extension.getChars(paramLong - this.charArray.length, paramInt, paramCharacterSet, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   void get(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 123 */     if (paramLong < this.charArray.length) {
/*     */       try
/*     */       {
/* 126 */         int i = this.conversion.javaCharsToCHARBytes(this.charArray, (int)paramLong, paramArrayOfByte, paramInt1, paramInt2);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 135 */       this.extension.get(paramLong - this.charArray.length, paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */   }
/*     */ 
/*     */   byte get(long paramLong)
/*     */   {
/* 150 */     if (paramLong < this.charArray.length) return (byte)(this.charArray[((int)paramLong)] & 0xFF);
/* 151 */     return this.extension.get(paramLong - this.charArray.length);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CCharByteArray
 * JD-Core Version:    0.6.2
 */