/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.nio.ByteBuffer;
/*      */ import java.nio.ByteOrder;
/*      */ import java.nio.CharBuffer;
/*      */ import java.nio.ShortBuffer;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayDeque;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ class T2CCallableStatement extends OracleCallableStatement
/*      */ {
/*   46 */   T2CConnection t2cConnection = null;
/*   47 */   int userResultSetType = -1;
/*   48 */   int userResultSetConcur = -1;
/*      */ 
/*   54 */   static int T2C_EXTEND_BUFFER = -3;
/*      */ 
/*   70 */   long[] t2cOutput = new long[10];
/*      */   static final int T2C_OUTPUT_USE_NIO = 5;
/*      */   static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
/*      */   static final int T2C_OUTPUT_USE_OCI_DEFAULT_DEFINE_OFFSET = 7;
/*      */   static final boolean T2CDEBUG = false;
/*      */   int extractedCharOffset;
/*      */   int extractedByteOffset;
/*  135 */   int savedRowPrefetch = 0;
/*      */   static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
/*      */   static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
/*      */   static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
/*      */   static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
/*      */   static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
/*      */   byte[] lobPrefetchTempBytes;
/* 1659 */   boolean needToRetainRows = false;
/*      */   byte[] returnParamBytes;
/*      */   char[] returnParamChars;
/*      */   short[] returnParamIndicators;
/*      */   int returnParamRowBytes;
/*      */   int returnParamRowChars;
/* 2198 */   static int PREAMBLE_PER_POSITION = 5;
/*      */ 
/* 2238 */   SQLException updateDataException = null;
/* 2239 */   int lastProcessedCell = 0;
/*      */   static final int PROCESS_DEFINE_DYNAMIC_COLUMNS = 16;
/*      */   static final int PROCESS_DEFINE_DEFAULT_COLUMNS = 32;
/*      */   static final int PROCESS_ADT_OUT_BINDS = 64;
/* 2243 */   int lastProcessedAccessorIndex = 0;
/* 2244 */   int accessorsProcessed = 0;
/* 2245 */   int previousMode = 0;
/*      */ 
/* 2837 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   T2CCallableStatement(T2CConnection paramT2CConnection, String paramString, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*      */     throws SQLException
/*      */   {
/*  110 */     super(paramT2CConnection, paramString, paramInt1, paramInt2, paramInt3, paramInt4);
/*      */ 
/*  113 */     this.userResultSetType = paramInt3;
/*  114 */     this.userResultSetConcur = paramInt4;
/*      */ 
/*  117 */     this.t2cConnection = paramT2CConnection;
/*      */ 
/*  119 */     if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/*  121 */       this.savedRowPrefetch = this.rowPrefetch;
/*  122 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   int getPrefetchInternal(boolean paramBoolean)
/*      */   {
/*  143 */     if (!this.t2cConnection.useOCIDefaultDefines) {
/*  144 */       return super.getPrefetchInternal(paramBoolean);
/*      */     }
/*  146 */     int i = paramBoolean ? this.defaultRowPrefetch : this.savedRowPrefetch;
/*      */ 
/*  148 */     return i;
/*      */   }
/*      */ 
/*      */   void setPrefetchInternal(int paramInt, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  159 */     int i = this.rowPrefetch;
/*  160 */     super.setPrefetchInternal(paramInt, paramBoolean1, paramBoolean2);
/*      */ 
/*  163 */     if ((this.t2cConnection.useOCIDefaultDefines) && (i != this.rowPrefetch))
/*      */     {
/*  165 */       this.savedRowPrefetch = this.rowPrefetch;
/*  166 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareForNewResults(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
/*      */     throws SQLException
/*      */   {
/*  181 */     super.prepareForNewResults(paramBoolean1, paramBoolean2, paramBoolean3);
/*      */ 
/*  186 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.rowPrefetchChanged))
/*      */     {
/*  188 */       this.savedRowPrefetch = this.rowPrefetch;
/*  189 */       this.rowPrefetch = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void prepareAccessors()
/*      */     throws SQLException
/*      */   {
/*  200 */     super.prepareAccessors();
/*  201 */     if ((this.t2cConnection.useOCIDefaultDefines) && (this.hasStream))
/*  202 */       this.savedRowPrefetch = 1;
/*      */   }
/*      */ 
/*      */   String bytes2String(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  215 */     byte[] arrayOfByte = new byte[paramInt2];
/*      */ 
/*  217 */     System.arraycopy(paramArrayOfByte, paramInt1, arrayOfByte, 0, paramInt2);
/*      */ 
/*  219 */     return this.connection.conversion.CharBytesToString(arrayOfByte, paramInt2);
/*      */   }
/*      */ 
/*      */   void processDescribeData()
/*      */     throws SQLException
/*      */   {
/*  235 */     this.described = true;
/*  236 */     this.describedWithNames = true;
/*      */ 
/*  247 */     if (this.numberOfDefinePositions < 1) return;
/*  248 */     if ((this.accessors == null) || (this.numberOfDefinePositions > this.accessors.length)) {
/*  249 */       this.accessors = new Accessor[this.numberOfDefinePositions];
/*      */     }
/*      */ 
/*  265 */     int i = this.t2cConnection.queryMetaData1Offset;
/*  266 */     int j = this.t2cConnection.queryMetaData2Offset;
/*  267 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/*  268 */     byte[] arrayOfByte = this.t2cConnection.queryMetaData2;
/*      */ 
/*  270 */     for (int k = 0; k < this.numberOfDefinePositions; 
/*  271 */       i += 14)
/*      */     {
/*  273 */       int m = arrayOfShort[(i + 0)];
/*  274 */       int n = arrayOfShort[(i + 1)];
/*  275 */       int i1 = arrayOfShort[(i + 11)];
/*  276 */       boolean bool1 = arrayOfShort[(i + 2)] != 0;
/*  277 */       int i2 = arrayOfShort[(i + 3)];
/*  278 */       int i3 = arrayOfShort[(i + 4)];
/*  279 */       int i4 = 0;
/*  280 */       int i5 = 0;
/*  281 */       int i6 = 0;
/*  282 */       short s = arrayOfShort[(i + 5)];
/*  283 */       int i7 = arrayOfShort[(i + 6)];
/*  284 */       String str1 = bytes2String(arrayOfByte, j, i7);
/*  285 */       int i8 = arrayOfShort[(i + 12)];
/*  286 */       boolean bool2 = arrayOfShort[(i + 13)] != 0;
/*      */ 
/*  288 */       String str2 = null;
/*  289 */       OracleTypeADT localOracleTypeADT = null;
/*      */ 
/*  291 */       j += i7;
/*      */ 
/*  293 */       if (i8 > 0)
/*      */       {
/*  295 */         str2 = bytes2String(arrayOfByte, j, i8);
/*  296 */         j += i8;
/*  297 */         localOracleTypeADT = new OracleTypeADT(str2, this.connection);
/*  298 */         localOracleTypeADT.tdoCState = ((arrayOfShort[(i + 7)] & 0xFFFF) << 48 | (arrayOfShort[(i + 8)] & 0xFFFF) << 32 | (arrayOfShort[(i + 9)] & 0xFFFF) << 16 | arrayOfShort[(i + 10)] & 0xFFFF);
/*      */       }
/*      */ 
/*  305 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/*  312 */       if ((localAccessor == null) || (localAccessor.defineType == 0) || ((localAccessor.describeType != 0) && (localAccessor.describeType != m)))
/*      */       {
/*  316 */         localAccessor = allocateAccessorForDefines(k, m, n, bool1, i4, i2, i3, i5, i6, s, i1, localOracleTypeADT, str2);
/*      */ 
/*  319 */         if (this.accessors[k] != null)
/*      */         {
/*  321 */           localAccessor.rowLength = this.accessors[k].rowLength;
/*  322 */           localAccessor.rowOffset = this.accessors[k].rowOffset;
/*  323 */           localAccessor.rowNull = this.accessors[k].rowNull;
/*  324 */           localAccessor.rowMetadata = this.accessors[k].rowMetadata;
/*      */         }
/*      */       }
/*      */       else {
/*  328 */         localAccessor.initForDescribe(m, n, bool1, i4, i2, i3, i5, i6, s, str2);
/*      */       }
/*      */ 
/*  334 */       localAccessor.describeOtype = localOracleTypeADT;
/*  335 */       localAccessor.columnName = str1;
/*  336 */       localAccessor.columnInvisible = bool2;
/*      */ 
/*  338 */       this.accessors[k] = localAccessor;
/*      */ 
/*  271 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessorForDefines(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort, int paramInt9, OracleTypeADT paramOracleTypeADT, String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*  352 */     switch (paramInt2)
/*      */     {
/*      */     case 1:
/*  356 */       localObject = new VarcharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  360 */       if (paramInt9 > 0)
/*  361 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 96:
/*  366 */       localObject = new CharAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  370 */       if (paramInt9 > 0)
/*  371 */         ((Accessor)localObject).setDisplaySize(paramInt9); break;
/*      */     case 2:
/*  376 */       localObject = new NumberAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  380 */       break;
/*      */     case 23:
/*  383 */       localObject = new RawAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  387 */       break;
/*      */     case 100:
/*  390 */       localObject = new BinaryFloatAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  394 */       break;
/*      */     case 101:
/*  397 */       localObject = new BinaryDoubleAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  401 */       break;
/*      */     case 8:
/*  404 */       localObject = new T2CLongAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  411 */       this.rowPrefetch = 1;
/*  412 */       this.savedRowPrefetch = 1;
/*      */ 
/*  414 */       break;
/*      */     case 24:
/*  417 */       localObject = new T2CLongRawAccessor(this, paramInt1 + 1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  424 */       this.rowPrefetch = 1;
/*  425 */       this.savedRowPrefetch = 1;
/*      */ 
/*  427 */       break;
/*      */     case 104:
/*  430 */       localObject = new RowidAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, (short)1);
/*      */ 
/*  434 */       break;
/*      */     case 102:
/*      */     case 116:
/*  439 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  441 */         localObject = new T2CResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */       else
/*      */       {
/*  446 */         localObject = new ResultSetAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */       }
/*      */ 
/*  451 */       break;
/*      */     case 12:
/*  454 */       localObject = new DateAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  458 */       break;
/*      */     case 180:
/*  461 */       localObject = new TimestampAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  465 */       break;
/*      */     case 181:
/*  468 */       localObject = new TimestamptzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  472 */       break;
/*      */     case 231:
/*  475 */       localObject = new TimestampltzAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  479 */       break;
/*      */     case 182:
/*  482 */       localObject = new IntervalymAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  486 */       break;
/*      */     case 183:
/*  489 */       localObject = new IntervaldsAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  493 */       break;
/*      */     case 112:
/*  496 */       localObject = new ClobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  500 */       break;
/*      */     case 113:
/*  503 */       localObject = new BlobAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  507 */       break;
/*      */     case 114:
/*  510 */       localObject = new BfileAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort);
/*      */ 
/*  514 */       break;
/*      */     case 109:
/*  517 */       localObject = new NamedTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  522 */       break;
/*      */     case 111:
/*  525 */       localObject = new RefTypeAccessor(this, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, paramString, paramOracleTypeADT);
/*      */ 
/*  530 */       break;
/*      */     default:
/*  534 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + paramInt2);
/*      */ 
/*  536 */       localSQLException.fillInStackTrace();
/*  537 */       throw localSQLException;
/*      */     }
/*      */ 
/*  540 */     return localObject;
/*      */   }
/*      */ 
/*      */   void executeForDescribe()
/*      */     throws SQLException
/*      */   {
/*  580 */     this.t2cOutput[0] = 0L;
/*  581 */     this.t2cOutput[2] = 0L;
/*  582 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/*      */ 
/*  586 */     this.lobPrefetchMetaData = null;
/*      */ 
/*  588 */     boolean bool1 = !this.described;
/*  589 */     boolean bool2 = false;
/*      */ 
/*  591 */     int j = this.t2cConnection.useOCIDefaultDefines ? this.savedRowPrefetch : this.rowPrefetch;
/*  592 */     assert (j > 0) : ("rowsToFetch < 1 (rowsToFetch=" + j + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/*  593 */     this.validRows = 0;
/*      */     int i;
/*      */     do
/*      */     {
/*  596 */       i = 0;
/*      */ 
/*  599 */       if (this.connection.endToEndAnyChanged)
/*      */       {
/*  601 */         pushEndToEndValues();
/*      */ 
/*  603 */         this.connection.endToEndAnyChanged = false;
/*      */       }
/*      */ 
/*  607 */       byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/*      */ 
/*  609 */       int k = 0;
/*      */       try
/*      */       {
/*  612 */         resetStateBeforeFetch();
/*  613 */         k = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, bool1, bool2, arrayOfByte, arrayOfByte.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), j, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, this.preparedByteBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.t2cConnection.plsqlCompilerWarnings);
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/*  657 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 266);
/*  658 */         localSQLException.fillInStackTrace();
/*  659 */         throw localSQLException;
/*      */       }
/*      */ 
/*  665 */       if (this.bindIndicators != null) {
/*  666 */         setLengthForOutAccessors();
/*      */       }
/*      */ 
/*  671 */       this.validRows = ((int)this.t2cOutput[1]);
/*      */ 
/*  674 */       if ((k == -1) || (k == -4))
/*      */       {
/*  676 */         this.t2cConnection.checkError(k);
/*      */       }
/*  678 */       else if (k == T2C_EXTEND_BUFFER)
/*      */       {
/*  680 */         k = this.t2cConnection.queryMetaData1Size * 2;
/*      */       }
/*      */ 
/*  685 */       if (this.t2cOutput[3] != 0L)
/*      */       {
/*  687 */         foundPlsqlCompilerWarning();
/*      */       }
/*  689 */       else if (this.t2cOutput[2] != 0L)
/*      */       {
/*  691 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/*  696 */       this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/*  699 */       this.needToParse = false;
/*  700 */       bool2 = true;
/*      */ 
/*  702 */       if (this.sqlKind.isSELECT())
/*      */       {
/*  704 */         this.numberOfDefinePositions = k;
/*      */ 
/*  706 */         if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */         {
/*  708 */           i = 1;
/*  709 */           bool2 = true;
/*      */ 
/*  712 */           this.t2cConnection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  719 */         this.numberOfDefinePositions = 0;
/*  720 */         this.validRows = k;
/*      */       }
/*  722 */       if (this.sqlKind.isPlsqlOrCall())
/*      */       {
/*  724 */         checkForImplicitResultSets();
/*      */       }
/*      */     }
/*  727 */     while (i != 0);
/*      */ 
/*  730 */     this.isComplete = false;
/*      */ 
/*  732 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   void checkForImplicitResultSets()
/*      */     throws SQLException
/*      */   {
/*  740 */     int i = 0;
/*      */ 
/*  743 */     i = T2CStatement.t2cGetImplicitResultSetCount(this, this.c_state);
/*  744 */     if (i > 0)
/*      */     {
/*  746 */       int j = i;
/*  747 */       this.implicitResultSetStatements = new ArrayDeque(j);
/*  748 */       while (j != 0)
/*      */       {
/*  752 */         OracleStatement localOracleStatement = this.connection.createImplicitResultSetStatement(this);
/*  753 */         ((T2CStatement)localOracleStatement).doDescribe(true);
/*  754 */         ((T2CStatement)localOracleStatement).prepareAccessors();
/*  755 */         j--;
/*      */       }
/*  757 */       this.implicitResultSetIterator = this.implicitResultSetStatements.iterator();
/*      */     }
/*  759 */     else if (i != 0) {
/*  760 */       this.t2cConnection.checkError(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   void pushEndToEndValues()
/*      */     throws SQLException
/*      */   {
/*  767 */     T2CConnection localT2CConnection = this.t2cConnection;
/*  768 */     byte[] arrayOfByte1 = null;
/*  769 */     byte[] arrayOfByte2 = null;
/*  770 */     byte[] arrayOfByte3 = null;
/*  771 */     byte[] arrayOfByte4 = null;
/*  772 */     byte[] arrayOfByte5 = null;
/*      */ 
/*  774 */     if (localT2CConnection.endToEndValues != null)
/*      */     {
/*      */       String str;
/*  776 */       if (localT2CConnection.endToEndHasChanged[0] != 0)
/*      */       {
/*  778 */         str = localT2CConnection.endToEndValues[0];
/*      */ 
/*  780 */         if (str != null) {
/*  781 */           arrayOfByte1 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  785 */           arrayOfByte1 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  788 */         localT2CConnection.endToEndHasChanged[0] = false;
/*      */       }
/*      */ 
/*  791 */       if (localT2CConnection.endToEndHasChanged[1] != 0)
/*      */       {
/*  793 */         str = localT2CConnection.endToEndValues[1];
/*      */ 
/*  795 */         if (str != null) {
/*  796 */           arrayOfByte2 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  800 */           arrayOfByte2 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  803 */         localT2CConnection.endToEndHasChanged[1] = false;
/*      */       }
/*      */ 
/*  806 */       if (localT2CConnection.endToEndHasChanged[2] != 0)
/*      */       {
/*  808 */         str = localT2CConnection.endToEndValues[2];
/*      */ 
/*  810 */         if (str != null) {
/*  811 */           arrayOfByte3 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  815 */           arrayOfByte3 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  818 */         localT2CConnection.endToEndHasChanged[2] = false;
/*      */       }
/*      */ 
/*  821 */       if (localT2CConnection.endToEndHasChanged[3] != 0)
/*      */       {
/*  823 */         str = localT2CConnection.endToEndValues[3];
/*      */ 
/*  825 */         if (str != null) {
/*  826 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  830 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  833 */         localT2CConnection.endToEndHasChanged[3] = false;
/*      */       }
/*      */ 
/*  836 */       if (localT2CConnection.endToEndHasChanged[4] != 0)
/*      */       {
/*  838 */         str = localT2CConnection.endToEndValues[4];
/*      */ 
/*  840 */         if (str != null) {
/*  841 */           arrayOfByte4 = DBConversion.stringToDriverCharBytes(str, localT2CConnection.m_clientCharacterSet);
/*      */         }
/*      */         else
/*      */         {
/*  845 */           arrayOfByte4 = PhysicalConnection.EMPTY_BYTE_ARRAY;
/*      */         }
/*      */ 
/*  848 */         localT2CConnection.endToEndHasChanged[4] = false;
/*      */       }
/*      */ 
/*  854 */       T2CStatement.t2cEndToEndUpdate(this.c_state, arrayOfByte1, arrayOfByte1 == null ? -1 : arrayOfByte1.length, arrayOfByte2, arrayOfByte2 == null ? -1 : arrayOfByte2.length, arrayOfByte3, arrayOfByte3 == null ? -1 : arrayOfByte3.length, arrayOfByte4, arrayOfByte4 == null ? -1 : arrayOfByte4.length, arrayOfByte5, arrayOfByte5 == null ? -1 : arrayOfByte5.length, localT2CConnection.endToEndECIDSequenceNumber);
/*      */     }
/*      */   }
/*      */ 
/*      */   void executeForRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  910 */     if (this.connection.endToEndAnyChanged)
/*      */     {
/*  912 */       pushEndToEndValues();
/*      */ 
/*  914 */       this.connection.endToEndAnyChanged = false;
/*      */     }
/*      */ 
/*  918 */     if (!paramBoolean)
/*      */     {
/*  926 */       if (this.numberOfDefinePositions > 0)
/*      */       {
/*  928 */         doDefineExecuteFetch();
/*      */       }
/*      */       else
/*      */       {
/*  932 */         executeForDescribe();
/*      */       }
/*      */     }
/*  935 */     else if (this.numberOfDefinePositions > 0) {
/*  936 */       doDefineFetch();
/*      */     }
/*      */ 
/*  939 */     if (this.returnParamMeta != null) {
/*  940 */       fetchDmlReturnParams();
/*      */     }
/*      */ 
/*  945 */     this.needToPrepareDefineBuffer = false;
/*      */   }
/*      */ 
/*      */   void setupForDefine()
/*      */     throws SQLException
/*      */   {
/*  955 */     if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size)
/*      */     {
/*  957 */       int i = this.numberOfDefinePositions / 100 + 1;
/*      */ 
/*  959 */       this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * i, this.t2cConnection.queryMetaData2Size * i * 8);
/*      */     }
/*      */ 
/*  964 */     short[] arrayOfShort = this.t2cConnection.queryMetaData1;
/*  965 */     int j = this.t2cConnection.queryMetaData1Offset;
/*      */ 
/*  968 */     for (int k = 0; k < this.numberOfDefinePositions; 
/*  969 */       j += 14)
/*      */     {
/*  971 */       Accessor localAccessor = this.accessors[k];
/*      */ 
/*  973 */       if (localAccessor == null)
/*      */       {
/*  975 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  976 */         localSQLException.fillInStackTrace();
/*  977 */         throw localSQLException;
/*      */       }
/*      */ 
/*  980 */       arrayOfShort[(j + 0)] = ((short)localAccessor.defineType);
/*      */ 
/*  983 */       if ((!this.described) && (localAccessor.charLength > 0) && (localAccessor.formOfUse == 1))
/*      */       {
/*  990 */         int m = localAccessor.charLength;
/*  991 */         int n = m + 1;
/*  992 */         arrayOfShort[(j + 11)] = 0;
/*  993 */         arrayOfShort[(j + 1)] = ((short)n);
/*      */       }
/*      */       else {
/*  996 */         arrayOfShort[(j + 11)] = ((short)localAccessor.charLength);
/*      */ 
/*  998 */         arrayOfShort[(j + 1)] = ((short)localAccessor.byteLength);
/*      */       }
/*      */ 
/* 1001 */       arrayOfShort[(j + 5)] = localAccessor.formOfUse;
/*      */ 
/* 1004 */       if (localAccessor.internalOtype != null)
/*      */       {
/* 1006 */         long l = ((OracleTypeADT)localAccessor.internalOtype).getTdoCState();
/*      */ 
/* 1009 */         arrayOfShort[(j + 7)] = ((short)(int)((l & 0x0) >> 48));
/*      */ 
/* 1011 */         arrayOfShort[(j + 8)] = ((short)(int)((l & 0x0) >> 32));
/*      */ 
/* 1013 */         arrayOfShort[(j + 9)] = ((short)(int)((l & 0xFFFF0000) >> 16));
/*      */ 
/* 1015 */         arrayOfShort[(j + 10)] = ((short)(int)(l & 0xFFFF));
/*      */       }
/*      */ 
/* 1019 */       switch (localAccessor.internalType)
/*      */       {
/*      */       case 112:
/*      */       case 113:
/* 1025 */         if (localAccessor.lobPrefetchSizeForThisColumn == -1) {
/* 1026 */           localAccessor.lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
/*      */         }
/*      */ 
/* 1029 */         arrayOfShort[(j + 7)] = ((short)localAccessor.lobPrefetchSizeForThisColumn);
/*      */       }
/*  969 */       k++;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void configureBindData()
/*      */     throws SQLException
/*      */   {
/* 1043 */     if (this.outBindAccessors == null) {
/* 1044 */       return;
/*      */     }
/*      */ 
/* 1047 */     AggregateByteArray localAggregateByteArray1 = (AggregateByteArray)this.bindData;
/* 1048 */     T2CCharByteArray localT2CCharByteArray1 = (T2CCharByteArray)localAggregateByteArray1.extension;
/*      */ 
/* 1050 */     AggregateByteArray localAggregateByteArray2 = (AggregateByteArray)localT2CCharByteArray1.extension;
/*      */ 
/* 1052 */     T2CCharByteArray localT2CCharByteArray2 = (T2CCharByteArray)localAggregateByteArray2.extension;
/*      */ 
/* 1055 */     if (this.bindBytes != null)
/* 1056 */       localAggregateByteArray1.setBytes(this.bindBytes);
/*      */     else {
/* 1058 */       localAggregateByteArray1.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
/*      */     }
/* 1060 */     if (this.bindChars != null)
/* 1061 */       localT2CCharByteArray1.setChars(this.bindChars);
/*      */     else {
/* 1063 */       localT2CCharByteArray1.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
/*      */     }
/* 1065 */     if (this.ibtBindBytes != null)
/* 1066 */       localAggregateByteArray2.setBytes(this.ibtBindBytes);
/*      */     else {
/* 1068 */       localAggregateByteArray2.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
/*      */     }
/* 1070 */     if (this.ibtBindChars != null)
/* 1071 */       localT2CCharByteArray2.setChars(this.ibtBindChars);
/*      */     else {
/* 1073 */       localT2CCharByteArray2.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
/*      */     }
/* 1075 */     localT2CCharByteArray1.setDBConversion(this.connection.conversion);
/* 1076 */     localT2CCharByteArray2.setDBConversion(this.connection.conversion);
/*      */ 
/* 1078 */     int i = this.bindBytes == null ? 0 : this.bindBytes.length;
/* 1079 */     int j = this.bindChars == null ? 0 : this.bindChars.length;
/* 1080 */     int k = this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length;
/* 1081 */     int m = this.ibtBindChars == null ? 0 : this.ibtBindChars.length;
/*      */ 
/* 1093 */     Accessor localAccessor = null;
/* 1094 */     int n = 0;
/*      */ 
/* 1097 */     for (int i1 = 0; 
/* 1098 */       i1 < this.numberOfBindPositions; 
/* 1099 */       i1++)
/*      */     {
/* 1102 */       localAccessor = this.outBindAccessors[i1];
/* 1103 */       if (localAccessor != null)
/*      */       {
/* 1105 */         int i2 = 0;
/* 1106 */         int i3 = localAccessor.byteLength;
/* 1107 */         if (localAccessor.defineType == 998)
/*      */         {
/* 1109 */           PlsqlIndexTableAccessor localPlsqlIndexTableAccessor = (PlsqlIndexTableAccessor)localAccessor;
/* 1110 */           i2 += i + j;
/* 1111 */           i2 += localPlsqlIndexTableAccessor.ibtBindInfo.ibtValueIndex;
/* 1112 */           switch (localPlsqlIndexTableAccessor.ibtBindInfo.element_internal_type)
/*      */           {
/*      */           case 9:
/* 1116 */             i2 += k;
/* 1117 */             break;
/*      */           case 6:
/*      */           }
/*      */ 
/* 1123 */           localAccessor.setOffset(0, i2);
/*      */         }
/*      */         else {
/* 1126 */           i2 = localAccessor.columnDataOffset;
/*      */ 
/* 1128 */           if (localAccessor.charLength > 0)
/*      */           {
/* 1130 */             i2 += i;
/* 1131 */             i3 = localAccessor.charLength;
/*      */           }
/* 1133 */           if (localAccessor.defineType == 15) n = 2;
/* 1134 */           else if (localAccessor.externalType == -8)
/*      */           {
/* 1136 */             n = this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK ? 1 : 2;
/*      */           }
/* 1142 */           else if ((localAccessor.defineType == 6) || (localAccessor.defineType == 9))
/*      */           {
/* 1144 */             n = 1;
/*      */           }
/* 1146 */           else n = 0;
/*      */ 
/* 1148 */           for (int i4 = 0; i4 < this.binders.length; i4++)
/*      */           {
/* 1150 */             i2 += i3 * i4 + n;
/* 1151 */             int i5 = this.bindIndicators[localAccessor.lengthIndex] - n & 0x7FFF;
/*      */ 
/* 1153 */             localAccessor.setOffset(i4, i2);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void initializePlsqlIndexByTableAccessor(Accessor paramAccessor, int paramInt)
/*      */   {
/* 1164 */     ((T2CPlsqlIndexTableAccessor)paramAccessor).ibtMetaIndex = (paramInt - 8);
/*      */   }
/*      */ 
/*      */   Object[] getLobPrefetchMetaData()
/*      */   {
/* 1179 */     Object[] arrayOfObject = null;
/* 1180 */     Object localObject = null;
/* 1181 */     int[] arrayOfInt = null;
/* 1182 */     int i = 0;
/* 1183 */     int j = 0;
/*      */     int k;
/* 1185 */     if (this.accessors != null) {
/* 1186 */       for (k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1188 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1195 */           j = k;
/* 1196 */           break;
/*      */         case 112:
/*      */         case 113:
/* 1202 */           if (arrayOfInt == null)
/*      */           {
/* 1204 */             arrayOfInt = new int[this.accessors.length];
/*      */           }
/*      */ 
/* 1207 */           if (this.accessors[k].lobPrefetchSizeForThisColumn != -1)
/*      */           {
/* 1209 */             i++;
/*      */ 
/* 1211 */             arrayOfInt[k] = this.accessors[k].lobPrefetchSizeForThisColumn;
/*      */           }
/*      */           else
/*      */           {
/* 1215 */             arrayOfInt[k] = -1;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1223 */     if (i > 0)
/*      */     {
/* 1225 */       if (arrayOfObject == null)
/*      */       {
/* 1227 */         arrayOfObject = new Object[] { null, new long[this.rowPrefetch * i], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * i] };
/*      */       }
/*      */ 
/* 1249 */       for (k = 0; k < j; k++)
/*      */       {
/* 1251 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1255 */           this.accessors[k].lobPrefetchSizeForThisColumn = -1;
/* 1256 */           arrayOfInt[k] = -1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1261 */       arrayOfObject[0] = arrayOfInt;
/*      */     }
/*      */ 
/* 1265 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   void processLobPrefetchMetaData(Object[] paramArrayOfObject)
/*      */   {
/* 1273 */     int i = 0;
/* 1274 */     int j = this.validRows == -2 ? 1 : this.validRows;
/*      */ 
/* 1276 */     byte[] arrayOfByte1 = (byte[])paramArrayOfObject[2];
/* 1277 */     int[] arrayOfInt1 = (int[])paramArrayOfObject[3];
/* 1278 */     long[] arrayOfLong = (long[])paramArrayOfObject[1];
/* 1279 */     Object[] arrayOfObject = (Object[])paramArrayOfObject[4];
/* 1280 */     int[] arrayOfInt2 = (int[])paramArrayOfObject[0];
/*      */ 
/* 1282 */     if (this.accessors != null)
/* 1283 */       for (int k = 0; k < this.numberOfDefinePositions; k++)
/*      */       {
/* 1285 */         switch (this.accessors[k].internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/* 1290 */           if (this.accessors[k].lobPrefetchSizeForThisColumn >= 0)
/*      */           {
/* 1292 */             LobCommonAccessor localLobCommonAccessor = (LobCommonAccessor)this.accessors[k];
/*      */ 
/* 1294 */             if ((localLobCommonAccessor.prefetchedDataLength == null) || (localLobCommonAccessor.prefetchedDataLength.length < this.rowPrefetch))
/*      */             {
/* 1298 */               if (localLobCommonAccessor.internalType == 112) {
/* 1299 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse = new int[this.rowPrefetch];
/*      */               }
/* 1301 */               localLobCommonAccessor.prefetchedChunkSize = new int[this.rowPrefetch];
/* 1302 */               localLobCommonAccessor.prefetchedDataLength = new int[this.rowPrefetch];
/* 1303 */               localLobCommonAccessor.prefetchedLength = new long[this.rowPrefetch];
/* 1304 */               localLobCommonAccessor.prefetchedDataOffset = new long[this.rowPrefetch];
/*      */             }
/*      */ 
/* 1307 */             int m = j * i;
/* 1308 */             int n = this.needToRetainRows ? this.storedRowCount : 0;
/* 1309 */             for (int i1 = 0; i1 < j; i1++)
/*      */             {
/* 1311 */               localLobCommonAccessor.prefetchedChunkSize[(n + i1)] = arrayOfInt1[k];
/* 1312 */               localLobCommonAccessor.prefetchedLength[(n + i1)] = arrayOfLong[(m + i1)];
/*      */ 
/* 1314 */               if (localLobCommonAccessor.internalType == 112)
/*      */               {
/* 1316 */                 ((ClobAccessor)localLobCommonAccessor).prefetchedDataFormOfUse[(n + i1)] = arrayOfByte1[k];
/*      */               }
/*      */ 
/* 1319 */               localLobCommonAccessor.prefetchedDataLength[i1] = 0;
/* 1320 */               if ((arrayOfInt2[k] > 0) && (arrayOfLong[(m + i1)] > 0L))
/*      */               {
/* 1323 */                 byte[] arrayOfByte2 = (byte[])arrayOfObject[(m + i1)];
/* 1324 */                 int i2 = arrayOfByte2 == null ? 0 : arrayOfByte2.length;
/* 1325 */                 if (i2 > 0)
/*      */                 {
/* 1327 */                   localLobCommonAccessor.setPrefetchedDataOffset(n + i1);
/* 1328 */                   localLobCommonAccessor.rowData.put(arrayOfByte2, 0, i2);
/*      */                 }
/* 1330 */                 localLobCommonAccessor.prefetchedDataLength[(n + i1)] = i2;
/*      */               }
/*      */             }
/* 1333 */             i++;
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */   }
/*      */ 
/*      */   int getRowsToFetch()
/*      */   {
/* 1345 */     int i = -1;
/* 1346 */     if (this.hasStream)
/*      */     {
/* 1348 */       i = 1;
/* 1349 */       if (this.t2cConnection.useOCIDefaultDefines) {
/* 1350 */         this.savedRowPrefetch = 1;
/*      */       }
/*      */       else {
/* 1353 */         this.rowPrefetch = 1;
/*      */       }
/*      */     }
/* 1356 */     else if (this.t2cConnection.useOCIDefaultDefines)
/*      */     {
/* 1360 */       if ((this.maxRows > 0) && (this.maxRows == this.storedRowCount))
/*      */       {
/* 1363 */         i = 0;
/*      */       }
/*      */       else {
/* 1366 */         i = this.rowPrefetch;
/*      */       }
/*      */ 
/*      */     }
/* 1370 */     else if ((this.maxRows > 0) && (this.maxRows < this.rowPrefetch + this.storedRowCount)) {
/* 1371 */       if ((this.storedRowCount < 1) && (this.maxRows < this.rowPrefetch)) {
/* 1372 */         i = this.maxRows;
/*      */       }
/*      */       else {
/* 1375 */         i = Math.min(this.rowPrefetch, this.maxRows - (this.rowPrefetch + this.storedRowCount));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1380 */       i = this.rowPrefetch;
/*      */     }
/*      */ 
/* 1383 */     return i;
/*      */   }
/*      */ 
/*      */   void doDefineFetch()
/*      */     throws SQLException
/*      */   {
/* 1390 */     int i = getRowsToFetch();
/*      */ 
/* 1393 */     this.validRows = 0;
/*      */ 
/* 1395 */     if (!this.needToPrepareDefineBuffer) {
/* 1396 */       throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
/*      */     }
/*      */ 
/* 1399 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1400 */     if (i > 0) {
/* 1401 */       setupForDefine();
/*      */ 
/* 1403 */       this.t2cOutput[2] = 0L;
/* 1404 */       this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1405 */       this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1406 */       if (this.connection.useNio) {
/* 1407 */         resetNioAttributesBeforeFetch();
/* 1408 */         allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */       }
/*      */ 
/* 1414 */       if (this.lobPrefetchMetaData == null) {
/* 1415 */         this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */       }
/* 1417 */       resetStateBeforeFetch();
/* 1418 */       this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, i, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1431 */       if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1432 */         this.t2cConnection.checkError(this.validRows);
/*      */       }
/*      */ 
/* 1436 */       if (this.t2cOutput[2] != 0L) {
/* 1437 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 1441 */       if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */       {
/* 1443 */         extractNioDefineBuffers(0);
/*      */       }
/* 1445 */       if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1446 */         copyStreamDataIntoDBA(0);
/*      */       }
/* 1448 */       if (this.lobPrefetchMetaData != null) {
/* 1449 */         processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */       }
/*      */     }
/* 1452 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */   }
/*      */ 
/*      */   void copyStreamDataIntoDBA(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1458 */     assert ((this.isFetchStreams) && (this.validRows == -2)) : ("isFetchStreams: " + this.isFetchStreams + "isScrollable(): " + this.realRsetType.isScrollable() + ", isUpdatable(): " + this.realRsetType.isUpdatable() + ", validRows=" + this.validRows);
/* 1459 */     checkValidRowsStatus();
/*      */ 
/* 1464 */     if (this.accessors != null)
/* 1465 */       for (Accessor localAccessor : this.accessors)
/* 1466 */         if (localAccessor != null)
/* 1467 */           switch (localAccessor.internalType) {
/*      */           case 8:
/* 1469 */             ((T2CLongAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/* 1470 */             break;
/*      */           case 24:
/* 1473 */             ((T2CLongRawAccessor)localAccessor).copyStreamDataIntoDBA(paramInt);
/*      */           }
/*      */   }
/*      */ 
/*      */   void allocateNioBuffersIfRequired(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1484 */     if (this.nioBuffers == null) {
/* 1485 */       this.nioBuffers = new ByteBuffer[4];
/*      */     }
/* 1487 */     if (paramInt2 > 0)
/*      */     {
/* 1489 */       if ((this.nioBuffers[0] == null) || (this.nioBuffers[0].capacity() < paramInt2))
/*      */       {
/* 1492 */         this.nioBuffers[0] = ByteBuffer.allocateDirect(paramInt2);
/* 1493 */       } else if (this.nioBuffers[0] != null)
/*      */       {
/* 1495 */         this.nioBuffers[0].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1502 */     paramInt1 *= 2;
/* 1503 */     if (paramInt1 > 0)
/*      */     {
/* 1505 */       if ((this.nioBuffers[1] == null) || (this.nioBuffers[1].capacity() < paramInt1))
/*      */       {
/* 1508 */         this.nioBuffers[1] = ByteBuffer.allocateDirect(paramInt1);
/* 1509 */       } else if (this.nioBuffers[1] != null)
/*      */       {
/* 1511 */         this.nioBuffers[1].rewind();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1518 */     paramInt3 *= 2;
/* 1519 */     if (paramInt3 > 0)
/*      */     {
/* 1521 */       if ((this.nioBuffers[2] == null) || (this.nioBuffers[2].capacity() < paramInt3))
/*      */       {
/* 1524 */         this.nioBuffers[2] = ByteBuffer.allocateDirect(paramInt3);
/* 1525 */       } else if (this.nioBuffers[2] != null)
/*      */       {
/* 1527 */         this.nioBuffers[2].rewind();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doDefineExecuteFetch()
/*      */     throws SQLException
/*      */   {
/* 1536 */     short[] arrayOfShort = null;
/*      */ 
/* 1538 */     if ((this.needToPrepareDefineBuffer) || (this.needToParse))
/*      */     {
/* 1540 */       setupForDefine();
/*      */ 
/* 1542 */       arrayOfShort = this.t2cConnection.queryMetaData1;
/*      */     }
/*      */ 
/* 1545 */     this.t2cOutput[0] = 0L;
/* 1546 */     this.t2cOutput[2] = 0L;
/*      */ 
/* 1548 */     byte[] arrayOfByte = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
/* 1549 */     this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1550 */     this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1551 */     this.t2cOutput[7] = (this.t2cConnection.useOCIDefaultDefines ? 1 : 0);
/* 1552 */     if (this.connection.useNio) {
/* 1553 */       resetNioAttributesBeforeFetch();
/* 1554 */       allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */     }
/*      */ 
/* 1560 */     if (this.lobPrefetchMetaData == null) {
/* 1561 */       this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */     }
/* 1563 */     int i = getRowsToFetch();
/* 1564 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1565 */     this.validRows = 0;
/*      */     try {
/* 1567 */       resetStateBeforeFetch();
/* 1568 */       this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, arrayOfByte, arrayOfByte.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), i, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, arrayOfShort, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.preparedByteBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1601 */       if (this.bindIndicators != null) {
/* 1602 */         setLengthForOutAccessors();
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1608 */       this.validRows = 0;
/*      */ 
/* 1610 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1611 */       localSQLException.fillInStackTrace();
/* 1612 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1616 */     if (this.validRows == -1) {
/* 1617 */       this.t2cConnection.checkError(this.validRows);
/*      */     }
/* 1619 */     if (this.t2cOutput[2] != 0L) {
/* 1620 */       this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */     }
/*      */ 
/* 1625 */     this.connection.endToEndECIDSequenceNumber = ((short)(int)this.t2cOutput[4]);
/*      */ 
/* 1627 */     if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */     {
/* 1629 */       extractNioDefineBuffers(0);
/*      */     }
/* 1631 */     if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1632 */       copyStreamDataIntoDBA(0);
/*      */     }
/*      */ 
/* 1635 */     if (this.lobPrefetchMetaData != null)
/*      */     {
/* 1637 */       processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */     }
/*      */ 
/* 1640 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/*      */ 
/* 1642 */     this.needToParse = false;
/*      */   }
/*      */ 
/*      */   protected void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1663 */     this.needToRetainRows = paramBoolean;
/* 1664 */     int i = getRowsToFetch();
/* 1665 */     assert (i > 0) : ("rowsToFetch < 1 (rowsToFetch=" + i + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")");
/* 1666 */     this.validRows = 0;
/* 1667 */     if ((i > 0) && 
/* 1668 */       (this.numberOfDefinePositions > 0)) {
/* 1669 */       if (this.needToPrepareDefineBuffer) {
/* 1670 */         doDefineFetch();
/* 1671 */         this.needToPrepareDefineBuffer = false;
/*      */       }
/*      */       else {
/* 1674 */         this.t2cOutput[2] = 0L;
/* 1675 */         this.t2cOutput[5] = (this.connection.useNio ? 1 : 0);
/* 1676 */         this.t2cOutput[6] = this.defaultLobPrefetchSize;
/* 1677 */         if (this.connection.useNio) {
/* 1678 */           resetNioAttributesBeforeFetch();
/* 1679 */           allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
/*      */         }
/*      */ 
/* 1686 */         if (this.lobPrefetchMetaData == null) {
/* 1687 */           this.lobPrefetchMetaData = getLobPrefetchMetaData();
/*      */         }
/* 1689 */         resetStateBeforeFetch();
/* 1690 */         this.validRows = T2CStatement.t2cFetch(this, this.c_state, this.needToPrepareDefineBuffer, i, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
/*      */ 
/* 1700 */         if ((this.validRows == -1) || (this.validRows == -4)) {
/* 1701 */           this.t2cConnection.checkError(this.validRows);
/*      */         }
/* 1703 */         if (this.t2cOutput[2] != 0L)
/*      */         {
/* 1705 */           this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */         }
/*      */ 
/* 1708 */         if (this.lobPrefetchMetaData != null)
/*      */         {
/* 1710 */           processLobPrefetchMetaData(this.lobPrefetchMetaData);
/*      */         }
/* 1712 */         if ((this.connection.useNio) && ((this.validRows > 0) || (this.validRows == -2)))
/*      */         {
/* 1714 */           extractNioDefineBuffers(0);
/*      */         }
/* 1716 */         if ((this.isFetchStreams) && (this.validRows == -2)) {
/* 1717 */           copyStreamDataIntoDBA(paramInt);
/*      */         }
/*      */       }
/*      */     }
/* 1721 */     this.isComplete = ((i < 1) || ((this.validRows >= 0) && (this.validRows < i)));
/* 1722 */     this.needToRetainRows = false;
/*      */   }
/*      */ 
/*      */   void resetNioAttributesBeforeFetch()
/*      */   {
/* 1729 */     this.extractedCharOffset = 0;
/* 1730 */     this.extractedByteOffset = 0;
/*      */   }
/*      */ 
/*      */   void extractNioDefineBuffers(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1739 */     if ((this.accessors == null) || (this.defineIndicators == null) || (paramInt == this.numberOfDefinePositions))
/*      */     {
/* 1742 */       return;
/*      */     }
/* 1744 */     int i = 0;
/* 1745 */     int j = 0;
/* 1746 */     int k = 0;
/* 1747 */     int m = 0;
/* 1748 */     int n = 0;
/*      */ 
/* 1751 */     if (!this.hasStream)
/*      */     {
/* 1753 */       i = this.defineBytes != null ? this.defineBytes.length : 0;
/* 1754 */       j = this.defineChars != null ? this.defineChars.length : 0;
/* 1755 */       k = this.defineIndicators.length;
/*      */     }
/*      */     else
/*      */     {
/* 1759 */       if (this.numberOfDefinePositions > paramInt)
/*      */       {
/* 1761 */         n = this.accessors[paramInt].indicatorIndex;
/* 1762 */         m = this.accessors[paramInt].lengthIndex;
/*      */       }
/*      */ 
/* 1767 */       for (int i1 = paramInt; i1 < this.numberOfDefinePositions; i1++)
/*      */       {
/* 1769 */         switch (this.accessors[i1].internalType)
/*      */         {
/*      */         case 8:
/*      */         case 24:
/* 1773 */           break;
/*      */         default:
/* 1775 */           i += this.accessors[i1].byteLength;
/* 1776 */           j += this.accessors[i1].charLength;
/* 1777 */           k++;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1782 */     ByteBuffer localByteBuffer = this.nioBuffers[0];
/* 1783 */     if ((localByteBuffer != null) && (this.defineBytes != null))
/*      */     {
/* 1785 */       if (i > 0)
/*      */       {
/* 1787 */         localByteBuffer.position(this.extractedByteOffset);
/* 1788 */         localByteBuffer.get(this.defineBytes, this.extractedByteOffset, i);
/* 1789 */         this.extractedByteOffset += i;
/*      */       }
/*      */     }
/*      */     Object localObject;
/* 1804 */     if ((this.nioBuffers[1] != null) && (this.defineChars != null))
/*      */     {
/* 1806 */       localByteBuffer = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
/* 1807 */       localObject = localByteBuffer.asCharBuffer();
/*      */ 
/* 1809 */       if (j > 0)
/*      */       {
/* 1811 */         ((CharBuffer)localObject).position(this.extractedCharOffset);
/* 1812 */         ((CharBuffer)localObject).get(this.defineChars, this.extractedCharOffset, j);
/* 1813 */         this.extractedCharOffset += j;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1818 */     if (this.nioBuffers[2] != null) {
/* 1819 */       localByteBuffer = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
/* 1820 */       localObject = localByteBuffer.asShortBuffer();
/* 1821 */       if (this.hasStream)
/*      */       {
/* 1823 */         if (k > 0)
/*      */         {
/* 1825 */           ((ShortBuffer)localObject).position(n);
/* 1826 */           ((ShortBuffer)localObject).get(this.defineIndicators, n, k);
/* 1827 */           ((ShortBuffer)localObject).position(m);
/* 1828 */           ((ShortBuffer)localObject).get(this.defineIndicators, m, k);
/*      */         }
/*      */       }
/*      */       else
/* 1832 */         ((ShortBuffer)localObject).get(this.defineIndicators);
/*      */     }
/*      */   }
/*      */ 
/*      */   void doClose()
/*      */     throws SQLException
/*      */   {
/* 1880 */     if (this.defineBytes != null)
/*      */     {
/* 1882 */       this.defineBytes = null;
/*      */     }
/*      */ 
/* 1885 */     if (this.defineChars != null)
/*      */     {
/* 1887 */       this.defineChars = null;
/*      */     }
/*      */ 
/* 1890 */     if (this.defineIndicators != null)
/*      */     {
/* 1892 */       this.defineIndicators = null;
/*      */     }
/*      */ 
/* 1896 */     int i = T2CStatement.t2cCloseStatement(this.c_state);
/*      */ 
/* 1898 */     this.nioBuffers = null;
/*      */ 
/* 1900 */     if (i != 0) {
/* 1901 */       this.t2cConnection.checkError(i);
/*      */     }
/* 1903 */     this.t2cOutput = null;
/*      */   }
/*      */ 
/*      */   void closeQuery()
/*      */     throws SQLException
/*      */   {
/* 1915 */     this.connection.registerHeartbeat();
/* 1916 */     this.connection.needLine();
/*      */ 
/* 1919 */     if (this.streamList != null)
/* 1920 */       while (this.nextStream != null) {
/*      */         try {
/* 1922 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 1926 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1927 */           localSQLException.fillInStackTrace();
/* 1928 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1931 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */   }
/*      */ 
/*      */   void closeUsedStreams(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1943 */     while ((this.nextStream != null) && (this.nextStream.columnIndex < 1 + this.offsetOfFirstUserColumn + paramInt))
/*      */     {
/*      */       try
/*      */       {
/* 1949 */         this.nextStream.close();
/*      */       }
/*      */       catch (IOException localIOException1)
/*      */       {
/* 1954 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 1955 */         localSQLException.fillInStackTrace();
/* 1956 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1960 */       this.nextStream = this.nextStream.nextStream;
/*      */     }
/*      */ 
/* 1963 */     if (this.nextStream != null)
/*      */       try
/*      */       {
/* 1966 */         this.nextStream.needBytes();
/*      */       }
/*      */       catch (IOException localIOException2)
/*      */       {
/* 1970 */         interalCloseOnIOException(localIOException2);
/*      */ 
/* 1972 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/* 1973 */         localSQLException.fillInStackTrace();
/* 1974 */         throw localSQLException;
/*      */       }
/*      */   }
/*      */ 
/*      */   void interalCloseOnIOException(IOException paramIOException)
/*      */     throws SQLException
/*      */   {
/* 1983 */     this.closed = true;
/*      */ 
/* 1985 */     if (this.currentResultSet != null) {
/* 1986 */       this.currentResultSet.closed = true;
/*      */     }
/* 1988 */     doClose();
/*      */   }
/*      */ 
/*      */   void fetchDmlReturnParams()
/*      */     throws SQLException
/*      */   {
/* 1995 */     this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
/*      */ 
/* 1997 */     if (this.rowsDmlReturned != 0)
/*      */     {
/* 1999 */       allocateDmlReturnStorage();
/*      */ 
/* 2001 */       resetStateBeforeFetch();
/* 2002 */       int i = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this, this.accessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
/*      */ 
/* 2011 */       if ((i == -1) || (i == -4)) {
/* 2012 */         this.t2cConnection.checkError(i);
/*      */       }
/*      */ 
/* 2015 */       if (this.t2cOutput[2] != 0L)
/*      */       {
/* 2017 */         this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
/*      */       }
/*      */ 
/* 2021 */       if ((this.connection.useNio) && ((i > 0) || (i == -2)))
/*      */       {
/* 2023 */         extractNioDefineBuffers(0);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2029 */     AggregateByteArray localAggregateByteArray = (AggregateByteArray)this.bindData;
/* 2030 */     if (this.returnParamBytes != null)
/* 2031 */       localAggregateByteArray.setBytes(this.returnParamBytes);
/* 2032 */     ((T2CCharByteArray)localAggregateByteArray.extension).setChars(this.returnParamChars);
/* 2033 */     ((T2CCharByteArray)localAggregateByteArray.extension).setDBConversion(this.connection.conversion);
/*      */ 
/* 2035 */     int j = this.returnParamBytes == null ? 0 : this.returnParamBytes.length;
/* 2036 */     int k = 0;
/* 2037 */     int m = this.numReturnParams * this.rowsDmlReturned;
/* 2038 */     int n = 0;
/* 2039 */     int i1 = j;
/* 2040 */     int i2 = 0;
/* 2041 */     for (int i3 = 0; i3 < this.numberOfBindPositions; i3++)
/*      */     {
/* 2043 */       Accessor localAccessor = this.accessors[i3];
/* 2044 */       if (localAccessor != null)
/*      */       {
/* 2046 */         localAccessor.setCapacity(this.rowsDmlReturned);
/* 2047 */         for (int i4 = 0; i4 < this.rowsDmlReturned; i4++)
/*      */         {
/* 2050 */           if ((localAccessor.internalType == 109) || (localAccessor.internalType == 111))
/*      */           {
/* 2053 */             i2++;
/*      */           }
/*      */           else
/*      */           {
/* 2057 */             int i5 = this.returnParamIndicators[(m++)];
/* 2058 */             int i6 = this.returnParamIndicators[(k++)] == -1 ? 1 : 0;
/* 2059 */             int i7 = 0;
/* 2060 */             if (localAccessor.internalType == 104)
/* 2061 */               i7 = 2;
/* 2062 */             else if ((localAccessor.defineType == 6) || (localAccessor.defineType == 9) || (localAccessor.defineType == 1))
/*      */             {
/* 2064 */               i7 = 1;
/*      */             }
/*      */ 
/* 2073 */             if (localAccessor.charLength > 0)
/*      */             {
/* 2083 */               localAccessor.setOffset(i4, i1 + i7);
/* 2084 */               i1 += localAccessor.charLength;
/*      */             }
/*      */             else
/*      */             {
/* 2095 */               localAccessor.setOffset(i4, n + i7);
/* 2096 */               n += localAccessor.byteLength;
/*      */             }
/*      */ 
/* 2099 */             if ((i6 != 0) || (i5 == 0))
/*      */             {
/* 2101 */               localAccessor.setLengthAndNull(i4, 0);
/*      */             }
/*      */             else {
/* 2104 */               if (localAccessor.internalType == 1) i5 /= 2;
/*      */ 
/* 2106 */               localAccessor.setLengthAndNull(i4, i5);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2115 */     this.returnParamsFetched = true;
/*      */   }
/*      */ 
/*      */   void processDmlReturningBind()
/*      */     throws SQLException
/*      */   {
/* 2130 */     super.processDmlReturningBind();
/* 2131 */     this.returnParamRowBytes = 0;
/* 2132 */     this.returnParamRowChars = 0;
/*      */ 
/* 2134 */     for (int i = 0; i < this.numberOfBindPositions; i++)
/*      */     {
/* 2136 */       Accessor localAccessor = this.accessors[i];
/*      */ 
/* 2138 */       if (localAccessor != null)
/*      */       {
/* 2140 */         if (localAccessor.charLength > 0)
/*      */         {
/* 2142 */           this.returnParamRowChars += localAccessor.charLength;
/*      */         }
/*      */         else
/*      */         {
/* 2146 */           this.returnParamRowBytes += localAccessor.byteLength;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2152 */     this.returnParamMeta[1] = this.returnParamRowBytes;
/* 2153 */     this.returnParamMeta[2] = this.returnParamRowChars;
/*      */   }
/*      */ 
/*      */   void allocateDmlReturnStorage()
/*      */   {
/* 2162 */     if (this.rowsDmlReturned == 0) return;
/*      */ 
/* 2164 */     int i = this.returnParamRowBytes * this.rowsDmlReturned;
/* 2165 */     int j = this.returnParamRowChars * this.rowsDmlReturned;
/* 2166 */     int k = 2 * this.numReturnParams * this.rowsDmlReturned;
/*      */ 
/* 2168 */     this.returnParamBytes = new byte[i];
/* 2169 */     this.returnParamChars = new char[j];
/* 2170 */     this.returnParamIndicators = new short[k];
/*      */ 
/* 2173 */     for (int m = 0; m < this.numberOfBindPositions; m++)
/*      */     {
/* 2175 */       Accessor localAccessor = this.accessors[m];
/* 2176 */       if (localAccessor != null)
/* 2177 */         localAccessor.setCapacity(this.rowsDmlReturned);
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanupReturnParameterBuffers()
/*      */   {
/* 2184 */     this.returnParamBytes = null;
/* 2185 */     this.returnParamChars = null;
/* 2186 */     this.returnParamIndicators = null;
/*      */   }
/*      */ 
/*      */   void initializeIndicatorSubRange()
/*      */   {
/* 2204 */     this.bindIndicatorSubRange = (this.numberOfBindPositions * PREAMBLE_PER_POSITION);
/*      */   }
/*      */ 
/*      */   int calculateIndicatorSubRangeSize()
/*      */   {
/* 2211 */     return this.numberOfBindPositions * PREAMBLE_PER_POSITION;
/*      */   }
/*      */ 
/*      */   short getInoutIndicator(int paramInt)
/*      */   {
/* 2218 */     return this.bindIndicators[(paramInt * PREAMBLE_PER_POSITION)];
/*      */   }
/*      */ 
/*      */   void resetStateBeforeFetch()
/*      */   {
/* 2224 */     this.lastProcessedCell = 0;
/* 2225 */     this.lastProcessedAccessorIndex = 0;
/* 2226 */     this.accessorsProcessed = 0;
/* 2227 */     this.previousMode = 0;
/* 2228 */     if (this.rowData != null)
/* 2229 */       if (this.needToRetainRows) {
/* 2230 */         this.rowData.setPosition(this.rowData.length());
/*      */       }
/*      */       else
/* 2233 */         this.rowData.reset();
/*      */   }
/*      */ 
/*      */   public int updateData(int paramInt1, int paramInt2, int paramInt3, int[] paramArrayOfInt, byte[] paramArrayOfByte)
/*      */   {
/*      */     try
/*      */     {
/* 2264 */       if (this.previousMode != paramInt1) {
/* 2265 */         this.accessorsProcessed = 0;
/*      */       }
/* 2267 */       this.previousMode = paramInt1;
/*      */ 
/* 2269 */       int i = 0;
/* 2270 */       int j = 0;
/* 2271 */       int k = 0;
/* 2272 */       int m = 0;
/* 2273 */       int n = 0;
/*      */       int i1;
/*      */       Object localObject1;
/* 2275 */       switch (paramInt1)
/*      */       {
/*      */       case 16:
/*      */       case 32:
/* 2280 */         for (i1 = 0; 
/* 2281 */           i1 < paramInt2; 
/* 2282 */           i1++)
/*      */         {
/* 2284 */           j = paramArrayOfInt[(i1 * 4 + 0)];
/* 2285 */           k = paramArrayOfInt[(i1 * 4 + 1)];
/* 2286 */           m = paramArrayOfInt[(i1 * 4 + 2)];
/* 2287 */           n = paramArrayOfInt[(i1 * 4 + 3)] == -1 ? 1 : 0;
/* 2288 */           localObject1 = this.accessors[k];
/*      */ 
/* 2294 */           ((Accessor)localObject1).setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j);
/*      */ 
/* 2298 */           if (m > 0)
/*      */           {
/* 2301 */             switch (((Accessor)localObject1).defineType)
/*      */             {
/*      */             case 1:
/*      */             case 23:
/*      */             case 96:
/*      */             case 104:
/* 2309 */               i += 2;
/* 2310 */               m -= 2;
/* 2311 */               break;
/*      */             case 6:
/* 2314 */               i++;
/* 2315 */               m--;
/*      */             }
/*      */ 
/* 2322 */             this.rowData.put(paramArrayOfByte, i, m);
/*      */ 
/* 2324 */             i += m;
/*      */           }
/* 2326 */           ((Accessor)localObject1).setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/* 2327 */           this.accessorsProcessed += 1;
/*      */ 
/* 2282 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/* 2329 */         break;
/*      */       case 64:
/* 2335 */         i1 = 0;
/* 2336 */         localObject1 = null;
/* 2337 */         if (this.outBindAccessors != null) {
/* 2338 */           i1 = (this.bindBytes == null ? 0 : this.bindBytes.length) + (this.bindChars == null ? 0 : this.bindChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2342 */           localObject1 = this.outBindAccessors;
/*      */         }
/*      */         else {
/* 2345 */           i1 = (this.returnParamBytes == null ? 0 : this.returnParamBytes.length) + (this.returnParamChars == null ? 0 : this.returnParamChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
/*      */ 
/* 2349 */           localObject1 = this.accessors;
/*      */         }
/* 2351 */         assert (localObject1 != null) : "No OUT binds or Return Parameters";
/* 2352 */         ByteArray localByteArray = this.bindData;
/*      */         do
/*      */         {
/* 2356 */           if (!(localByteArray instanceof AggregateByteArray))
/*      */             break;
/* 2358 */           localByteArray = ((AggregateByteArray)localByteArray).extension;
/*      */         }
/* 2360 */         while (localByteArray != null);
/*      */ 
/* 2362 */         i1 = (int)(i1 + localByteArray.getPosition());
/* 2363 */         int i2 = this.accessorsProcessed;
/* 2364 */         for (int i3 = 0; 
/* 2365 */           i3 < paramInt2; 
/* 2366 */           i3++)
/*      */         {
/* 2368 */           j = paramArrayOfInt[(i3 * 4 + 0)];
/* 2369 */           k = paramArrayOfInt[(i3 * 4 + 1)];
/* 2370 */           m = paramArrayOfInt[(i3 * 4 + 2)];
/* 2371 */           n = paramArrayOfInt[(i3 * 4 + 3)] == -1 ? 1 : 0;
/* 2372 */           Object localObject2 = localObject1[k];
/*      */ 
/* 2377 */           localObject2.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + j, i1);
/* 2378 */           localByteArray.put(paramArrayOfByte, i, m);
/* 2379 */           localObject2.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + j, m);
/*      */ 
/* 2381 */           i += m;
/* 2382 */           i1 += m;
/*      */ 
/* 2366 */           this.lastProcessedCell += 1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2388 */       this.updateDataException = localSQLException;
/* 2389 */       return -3;
/*      */     }
/* 2391 */     return 0;
/*      */   }
/*      */ 
/*      */   final boolean bit(long paramLong1, long paramLong2)
/*      */   {
/* 2396 */     return (paramLong1 & paramLong2) == paramLong1;
/*      */   }
/*      */ 
/*      */   public static String toHex(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/* 2401 */     if (paramArrayOfByte == null)
/* 2402 */       return "null";
/* 2403 */     if (paramInt > paramArrayOfByte.length)
/* 2404 */       return "byte array not long enough";
/* 2405 */     String str = "0:";
/* 2406 */     int i = paramInt;
/* 2407 */     for (int j = 0; j < i; j++)
/*      */     {
/* 2409 */       if ((j != 0) && (j % 10 == 0)) str = str + "\n" + j + ": ";
/* 2410 */       str = str + OracleLog.toHex(paramArrayOfByte[j]) + " ";
/*      */     }
/* 2412 */     return str;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2426 */     Object localObject = null;
/*      */     SQLException localSQLException;
/* 2428 */     switch (paramInt1)
/*      */     {
/*      */     case 102:
/*      */     case 116:
/* 2433 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2435 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2436 */         localSQLException.fillInStackTrace();
/* 2437 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2440 */       localObject = new T2CResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2443 */       return localObject;
/*      */     case 8:
/* 2447 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2449 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2450 */         localSQLException.fillInStackTrace();
/* 2451 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2454 */       if (paramBoolean) {
/* 2455 */         return new VarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */       }
/*      */ 
/* 2458 */       return new T2CLongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     case 1:
/* 2464 */       if (paramBoolean)
/*      */       {
/* 2466 */         if (paramString != null)
/*      */         {
/* 2469 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2470 */           localSQLException.fillInStackTrace();
/* 2471 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2476 */         localObject = new T2CVarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2478 */         return localObject;
/*      */       }
/*      */ 
/*      */       break;
/*      */     case 24:
/* 2484 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2486 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2487 */         localSQLException.fillInStackTrace();
/* 2488 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2491 */       if (paramBoolean) {
/* 2492 */         return new OutRawAccessor(this, paramInt4, paramShort, paramInt2);
/*      */       }
/*      */ 
/* 2495 */       return new T2CLongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */     }
/*      */ 
/* 2502 */     return super.allocateAccessor(paramInt1, paramInt2, paramInt3, paramInt4, paramShort, paramString, paramBoolean);
/*      */   }
/*      */ 
/*      */   void prepareBindPreambles(int paramInt1, int paramInt2)
/*      */   {
/* 2515 */     int i = calculateIndicatorSubRangeSize();
/* 2516 */     int j = this.bindIndicatorSubRange - i;
/* 2517 */     OracleTypeADT[] arrayOfOracleTypeADT = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
/*      */ 
/* 2521 */     for (int k = 0; k < this.numberOfBindPositions; k++)
/*      */     {
/* 2524 */       Binder localBinder = this.lastBinders[k];
/*      */       OracleTypeADT localOracleTypeADT;
/*      */       short s;
/* 2527 */       if (localBinder == this.theReturnParamBinder)
/*      */       {
/* 2529 */         localOracleTypeADT = (OracleTypeADT)this.accessors[k].internalOtype;
/* 2530 */         s = 0;
/*      */       }
/*      */       else
/*      */       {
/* 2534 */         localOracleTypeADT = arrayOfOracleTypeADT == null ? null : arrayOfOracleTypeADT[k];
/*      */ 
/* 2536 */         if (this.outBindAccessors == null) {
/* 2537 */           s = 0;
/*      */         }
/*      */         else {
/* 2540 */           Accessor localAccessor = this.outBindAccessors[k];
/*      */ 
/* 2542 */           if (localAccessor == null) {
/* 2543 */             s = 0;
/* 2544 */           } else if (localBinder == this.theOutBinder)
/*      */           {
/* 2546 */             s = 1;
/*      */ 
/* 2548 */             if (localOracleTypeADT == null)
/* 2549 */               localOracleTypeADT = (OracleTypeADT)localAccessor.internalOtype;
/*      */           }
/*      */           else {
/* 2552 */             s = 2;
/*      */           }
/*      */         }
/* 2554 */         s = localBinder.updateInoutIndicatorValue(s);
/*      */       }
/*      */ 
/* 2557 */       this.bindIndicators[(j++)] = s;
/*      */ 
/* 2559 */       if (localOracleTypeADT != null)
/*      */       {
/* 2561 */         long l = localOracleTypeADT.getTdoCState();
/*      */ 
/* 2563 */         this.bindIndicators[(j + 0)] = ((short)(int)(l >> 48 & 0xFFFF));
/*      */ 
/* 2565 */         this.bindIndicators[(j + 1)] = ((short)(int)(l >> 32 & 0xFFFF));
/*      */ 
/* 2567 */         this.bindIndicators[(j + 2)] = ((short)(int)(l >> 16 & 0xFFFF));
/*      */ 
/* 2569 */         this.bindIndicators[(j + 3)] = ((short)(int)(l & 0xFFFF));
/*      */       }
/*      */ 
/* 2572 */       j += 4;
/*      */     }
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/* 2580 */     super.releaseBuffers();
/*      */   }
/*      */ 
/*      */   void setLengthForOutAccessors()
/*      */     throws SQLException
/*      */   {
/* 2589 */     if (this.outBindAccessors == null) return;
/* 2590 */     Accessor localAccessor = null;
/*      */ 
/* 2592 */     for (int i = 0; 
/* 2593 */       i < this.numberOfBindPositions; 
/* 2594 */       i++)
/*      */     {
/* 2597 */       localAccessor = this.outBindAccessors[i];
/* 2598 */       if (localAccessor != null)
/*      */       {
/* 2600 */         if ((localAccessor.defineType != 998) && (localAccessor.defineType != 111) && (localAccessor.defineType != 109))
/*      */         {
/* 2607 */           for (int j = 0; j < this.binders.length; j++)
/*      */           {
/* 2609 */             int k = localAccessor.rowSpaceIndicator[(localAccessor.indicatorIndex + j)] == -1 ? 1 : 0;
/* 2610 */             int m = k != 0 ? 0 : localAccessor.rowSpaceIndicator[(localAccessor.lengthIndex + j)] & 0xFFFF;
/*      */ 
/* 2618 */             if ((this.sqlKind != OracleStatement.SqlKind.CALL_BLOCK) && (localAccessor.externalType == -8))
/*      */             {
/* 2623 */               localAccessor.setLengthAndNull(j, m);
/* 2624 */             } else if ((localAccessor.defineType == 9) || (localAccessor.defineType == 1))
/*      */             {
/* 2627 */               localAccessor.setLengthAndNull(j, m / 2);
/* 2628 */             } else if ((localAccessor.defineType != 109) && (localAccessor.defineType != 111))
/*      */             {
/* 2631 */               localAccessor.setLengthAndNull(j, m);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void doDescribe(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2656 */     if (this.closed)
/*      */     {
/* 2658 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 2659 */       localSQLException.fillInStackTrace();
/* 2660 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2663 */     if (this.described == true)
/*      */     {
/* 2665 */       return;
/*      */     }
/*      */ 
/* 2668 */     if (!this.isOpen)
/*      */     {
/* 2672 */       this.connection.open(this);
/* 2673 */       this.isOpen = true;
/*      */     }
/*      */ 
/*      */     int i;
/*      */     do
/*      */     {
/* 2681 */       i = 0;
/*      */ 
/* 2690 */       boolean bool = (this.sqlKind.isSELECT()) && (this.needToParse) && ((!this.described) || (!this.serverCursor));
/* 2691 */       byte[] arrayOfByte = bool ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
/* 2692 */       this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, arrayOfByte, arrayOfByte.length, bool);
/*      */ 
/* 2703 */       if (!this.described) {
/* 2704 */         this.described = true;
/*      */       }
/*      */ 
/* 2711 */       if (this.numberOfDefinePositions == -1)
/*      */       {
/* 2713 */         this.t2cConnection.checkError(this.numberOfDefinePositions);
/*      */       }
/*      */ 
/* 2717 */       if (this.numberOfDefinePositions == T2C_EXTEND_BUFFER)
/*      */       {
/* 2719 */         i = 1;
/*      */ 
/* 2723 */         this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * 2, this.t2cConnection.queryMetaData2Size * 2);
/*      */       }
/*      */     }
/*      */ 
/* 2727 */     while (i != 0);
/*      */ 
/* 2729 */     processDescribeData();
/*      */   }
/*      */ 
/*      */   protected void configureRowData()
/*      */   {
/* 2735 */     super.configureRowData();
/*      */ 
/* 2745 */     DynamicByteArray localDynamicByteArray = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
/*      */ 
/* 2747 */     T2CCharByteArray localT2CCharByteArray1 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localDynamicByteArray);
/*      */ 
/* 2749 */     AggregateByteArray localAggregateByteArray = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray1);
/*      */ 
/* 2752 */     T2CCharByteArray localT2CCharByteArray2 = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, localAggregateByteArray);
/*      */ 
/* 2756 */     this.bindData = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, localT2CCharByteArray2);
/*      */   }
/*      */ 
/*      */   void registerOutParameterInternal(int paramInt1, int paramInt2, int paramInt3, int paramInt4, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2766 */     int i = paramInt1 - 1;
/*      */ 
/* 2768 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*      */     {
/* 2770 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2771 */       localSQLException1.fillInStackTrace();
/* 2772 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2775 */     int j = getInternalType(paramInt2);
/*      */ 
/* 2777 */     if (j == 995)
/*      */     {
/* 2779 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 2780 */       localSQLException2.fillInStackTrace();
/* 2781 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 2784 */     resetBatch();
/*      */ 
/* 2786 */     this.currentRowNeedToPrepareBinds = true;
/*      */ 
/* 2788 */     if (this.currentRowBindAccessors == null) {
/* 2789 */       this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
/*      */     }
/*      */ 
/* 2792 */     switch (paramInt2)
/*      */     {
/*      */     case -4:
/*      */     case -3:
/*      */     case -1:
/*      */     case 1:
/*      */     case 12:
/*      */     case 70:
/* 2800 */       break;
/*      */     case -16:
/*      */     case -15:
/*      */     case -9:
/* 2804 */       this.currentRowFormOfUse[i] = 2;
/* 2805 */       break;
/*      */     case 2011:
/* 2807 */       paramInt4 = 0;
/* 2808 */       this.currentRowFormOfUse[i] = 2;
/* 2809 */       break;
/*      */     case 2009:
/* 2811 */       paramInt4 = 0;
/* 2812 */       paramString = "SYS.XMLTYPE";
/* 2813 */       break;
/*      */     default:
/* 2816 */       paramInt4 = 0;
/*      */     }
/*      */ 
/* 2820 */     this.currentRowBindAccessors[i] = allocateAccessor(j, paramInt2, paramInt1, paramInt4, this.currentRowFormOfUse[i], paramString, true);
/*      */ 
/* 2823 */     this.currentRowBindAccessors[i].setCapacity(1);
/*      */   }
/*      */ 
/*      */   Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2832 */     return new T2CPlsqlIndexTableAccessor(this, paramPlsqlIbtBindInfo, paramShort);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.T2CCallableStatement
 * JD-Core Version:    0.6.2
 */