/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleArray;
/*     */ import oracle.jdbc.OracleBfile;
/*     */ import oracle.jdbc.OracleBlob;
/*     */ import oracle.jdbc.OracleClob;
/*     */ import oracle.jdbc.OracleNClob;
/*     */ import oracle.jdbc.OracleOpaque;
/*     */ import oracle.jdbc.OracleRef;
/*     */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*     */ import oracle.jdbc.OracleStruct;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.oracore.OracleType;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ import oracle.jdbc.oracore.OracleTypeCHAR;
/*     */ import oracle.jdbc.oracore.OracleTypeFLOAT;
/*     */ import oracle.jdbc.oracore.OracleTypeNUMBER;
/*     */ import oracle.jdbc.oracore.OracleTypeRAW;
/*     */ import oracle.jdbc.oracore.OracleTypeREF;
/*     */ import oracle.sql.StructDescriptor;
/*     */ 
/*     */ class StructMetaData
/*     */   implements oracle.jdbc.internal.StructMetaData
/*     */ {
/*     */   StructDescriptor descriptor;
/*     */   OracleTypeADT otype;
/*     */   OracleType[] types;
/* 705 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public StructMetaData(StructDescriptor paramStructDescriptor)
/*     */     throws SQLException
/*     */   {
/*  38 */     if (paramStructDescriptor == null)
/*     */     {
/*  40 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "illegal operation: descriptor is null");
/*  41 */       localSQLException.fillInStackTrace();
/*  42 */       throw localSQLException;
/*     */     }
/*     */ 
/*  45 */     this.descriptor = paramStructDescriptor;
/*  46 */     this.otype = paramStructDescriptor.getOracleTypeADT();
/*  47 */     this.types = this.otype.getAttrTypes();
/*     */   }
/*     */ 
/*     */   public int getColumnCount()
/*     */     throws SQLException
/*     */   {
/*  60 */     return this.types.length;
/*     */   }
/*     */ 
/*     */   public boolean isAutoIncrement(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  68 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isSearchable(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  78 */     return false;
/*     */   }
/*     */ 
/*     */   public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  90 */     return OracleResultSetMetaData.SecurityAttribute.NONE;
/*     */   }
/*     */ 
/*     */   public boolean isCurrency(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  98 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 100 */     return ((this.types[i] instanceof OracleTypeNUMBER)) || ((this.types[i] instanceof OracleTypeFLOAT));
/*     */   }
/*     */ 
/*     */   public boolean isCaseSensitive(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 110 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 112 */     return this.types[i] instanceof OracleTypeCHAR;
/*     */   }
/*     */ 
/*     */   public int isNullable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 120 */     return 1;
/*     */   }
/*     */ 
/*     */   public boolean isSigned(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 128 */     return true;
/*     */   }
/*     */ 
/*     */   public int getColumnDisplaySize(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 140 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 142 */     if ((this.types[i] instanceof OracleTypeCHAR))
/* 143 */       return ((OracleTypeCHAR)this.types[i]).getLength();
/* 144 */     if ((this.types[i] instanceof OracleTypeRAW)) {
/* 145 */       return ((OracleTypeRAW)this.types[i]).getLength();
/*     */     }
/* 147 */     return 0;
/*     */   }
/*     */ 
/*     */   public String getColumnLabel(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 155 */     return getColumnName(paramInt);
/*     */   }
/*     */ 
/*     */   public String getColumnName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 170 */     return this.otype.getAttributeName(paramInt);
/*     */   }
/*     */ 
/*     */   public String getSchemaName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 185 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 187 */     if ((this.types[i] instanceof OracleTypeADT)) {
/* 188 */       return ((OracleTypeADT)this.types[i]).getSchemaName();
/*     */     }
/* 190 */     return "";
/*     */   }
/*     */ 
/*     */   public int getPrecision(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 198 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 201 */     return this.types[i].getPrecision();
/*     */   }
/*     */ 
/*     */   public int getScale(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 209 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 212 */     return this.types[i].getScale();
/*     */   }
/*     */ 
/*     */   public boolean isVariableScale(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 219 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 221 */     return this.types[i].getScale() == -127;
/*     */   }
/*     */ 
/*     */   public String getTableName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 229 */     return null;
/*     */   }
/*     */ 
/*     */   public String getCatalogName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 237 */     return null;
/*     */   }
/*     */ 
/*     */   public int getColumnType(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 245 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 247 */     return this.types[i].getTypeCode();
/*     */   }
/*     */ 
/*     */   public String getColumnTypeName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 263 */     int i = getColumnType(paramInt);
/* 264 */     int j = getValidColumnIndex(paramInt);
/*     */ 
/* 266 */     switch (i)
/*     */     {
/*     */     case 12:
/* 270 */       return "VARCHAR";
/*     */     case 1:
/* 273 */       return "CHAR";
/*     */     case -2:
/* 276 */       return "RAW";
/*     */     case 6:
/* 279 */       return "FLOAT";
/*     */     case 2:
/* 282 */       return "NUMBER";
/*     */     case 8:
/* 285 */       return "DOUBLE";
/*     */     case 3:
/* 288 */       return "DECIMAL";
/*     */     case 100:
/* 291 */       return "BINARY_FLOAT";
/*     */     case 101:
/* 294 */       return "BINARY_DOUBLE";
/*     */     case 91:
/* 297 */       return "DATE";
/*     */     case -104:
/* 300 */       return "INTERVALDS";
/*     */     case -103:
/* 303 */       return "INTERVALYM";
/*     */     case 93:
/* 306 */       return "TIMESTAMP";
/*     */     case -101:
/* 309 */       return "TIMESTAMP WITH TIME ZONE";
/*     */     case -102:
/* 312 */       return "TIMESTAMP WITH LOCAL TIME ZONE";
/*     */     case 2004:
/* 315 */       return "BLOB";
/*     */     case 2005:
/* 318 */       return "CLOB";
/*     */     case -13:
/* 321 */       return "BFILE";
/*     */     case 2002:
/*     */     case 2003:
/*     */     case 2007:
/*     */     case 2008:
/* 330 */       return ((OracleTypeADT)this.types[j]).getFullName();
/*     */     case 2006:
/* 333 */       return "REF " + ((OracleTypeREF)this.types[j]).getFullName();
/*     */     case -15:
/* 335 */       return "NCHAR";
/*     */     case -9:
/* 338 */       return "NVARCHAR";
/*     */     case 2011:
/* 341 */       return "NCLOB";
/*     */     case 1111:
/*     */     }
/*     */ 
/* 346 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 355 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isWritable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 363 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDefinitelyWritable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 371 */     return false;
/*     */   }
/*     */ 
/*     */   public String getColumnClassName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 379 */     int i = getColumnType(paramInt);
/*     */ 
/* 381 */     switch (i)
/*     */     {
/*     */     case -15:
/*     */     case -9:
/*     */     case 12:
/* 387 */       return "java.lang.String";
/*     */     case -2:
/* 390 */       return "byte[]";
/*     */     case 2:
/*     */     case 3:
/*     */     case 6:
/*     */     case 8:
/* 399 */       return "java.math.BigDecimal";
/*     */     case 91:
/* 402 */       return "java.sql.Timestamp";
/*     */     case -103:
/* 405 */       return "oracle.sql.INTERVALYM";
/*     */     case -104:
/* 408 */       return "oracle.sql.INTERVALDS";
/*     */     case 93:
/* 411 */       return "oracle.sql.TIMESTAMP";
/*     */     case -101:
/* 414 */       return "oracle.sql.TIMESTAMPTZ";
/*     */     case -102:
/* 417 */       return "oracle.sql.TIMESTAMPLTZ";
/*     */     case 2004:
/* 420 */       return OracleBlob.class.getName();
/*     */     case 2005:
/* 423 */       return OracleClob.class.getName();
/*     */     case 2011:
/* 426 */       return OracleNClob.class.getName();
/*     */     case -13:
/* 429 */       return OracleBfile.class.getName();
/*     */     case 2002:
/*     */     case 2008:
/* 434 */       return OracleStruct.class.getName();
/*     */     case 2007:
/* 437 */       return OracleOpaque.class.getName();
/*     */     case 2003:
/* 440 */       return OracleArray.class.getName();
/*     */     case 2006:
/* 443 */       return OracleRef.class.getName();
/*     */     case 1111:
/*     */     }
/*     */ 
/* 448 */     return null;
/*     */   }
/*     */ 
/*     */   public String getOracleColumnClassName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 462 */     int i = getColumnType(paramInt);
/*     */ 
/* 464 */     switch (i)
/*     */     {
/*     */     case -15:
/*     */     case -9:
/*     */     case 1:
/*     */     case 12:
/* 472 */       return "CHAR";
/*     */     case -2:
/* 475 */       return "RAW";
/*     */     case 2:
/*     */     case 3:
/*     */     case 6:
/*     */     case 8:
/* 484 */       return "NUMBER";
/*     */     case 91:
/* 487 */       return "DATE";
/*     */     case -103:
/* 490 */       return "INTERVALYM";
/*     */     case -104:
/* 493 */       return "INTERVALDS";
/*     */     case 93:
/* 496 */       return "TIMESTAMP";
/*     */     case -101:
/* 499 */       return "TIMESTAMPTZ";
/*     */     case -102:
/* 502 */       return "TIMESTAMPLTZ";
/*     */     case 2004:
/* 505 */       return "BLOB";
/*     */     case 2005:
/* 508 */       return "CLOB";
/*     */     case 2011:
/* 511 */       return "NCLOB";
/*     */     case -13:
/* 514 */       return "BFILE";
/*     */     case 2002:
/* 517 */       return "STRUCT";
/*     */     case 2008:
/* 520 */       return "JAVA_STRUCT";
/*     */     case 2007:
/* 523 */       return "OPAQUE";
/*     */     case 2003:
/* 526 */       return "ARRAY";
/*     */     case 2006:
/* 529 */       return "REF";
/*     */     case 1111:
/*     */     }
/*     */ 
/* 534 */     return null;
/*     */   }
/*     */ 
/*     */   public int getLocalColumnCount()
/*     */     throws SQLException
/*     */   {
/* 549 */     return this.descriptor.getLocalAttributeCount();
/*     */   }
/*     */ 
/*     */   public boolean isColumnInvisible(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 562 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isInherited(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 578 */     return paramInt <= getColumnCount() - getLocalColumnCount();
/*     */   }
/*     */ 
/*     */   public String getAttributeJavaName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 595 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 597 */     return this.descriptor.getAttributeJavaName(i);
/*     */   }
/*     */ 
/*     */   private int getValidColumnIndex(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 614 */     int i = paramInt - 1;
/*     */ 
/* 616 */     if ((i < 0) || (i >= this.types.length))
/*     */     {
/* 618 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
/* 619 */       localSQLException.fillInStackTrace();
/* 620 */       throw localSQLException;
/*     */     }
/*     */ 
/* 623 */     return i;
/*     */   }
/*     */ 
/*     */   public boolean isNCHAR(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 631 */     int i = getValidColumnIndex(paramInt);
/*     */ 
/* 633 */     return this.types[i].isNCHAR();
/*     */   }
/*     */ 
/*     */   public boolean isWrapperFor(Class<?> paramClass)
/*     */     throws SQLException
/*     */   {
/* 654 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*     */ 
/* 656 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 657 */     localSQLException.fillInStackTrace();
/* 658 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public <T> T unwrap(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 680 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*     */ 
/* 682 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 683 */     localSQLException.fillInStackTrace();
/* 684 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 700 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.StructMetaData
 * JD-Core Version:    0.6.2
 */