/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class SimpleByteArray extends ByteArray
/*     */ {
/*     */   protected byte[] bytes;
/* 227 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected SimpleByteArray(byte[] paramArrayOfByte)
/*     */   {
/*  25 */     setBytes(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   void setBytes(byte[] paramArrayOfByte)
/*     */   {
/*  30 */     this.bytes = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   long length()
/*     */   {
/*  39 */     return this.bytes.length;
/*     */   }
/*     */ 
/*     */   void put(long paramLong, byte paramByte)
/*     */   {
/*  53 */     assert ((paramLong >= 0L) && (paramLong < this.bytes.length)) : ("index = " + paramLong + " length = " + this.bytes.length);
/*  54 */     this.bytes[((int)paramLong)] = paramByte;
/*     */   }
/*     */ 
/*     */   byte get(long paramLong)
/*     */   {
/*  69 */     assert ((paramLong >= 0L) && (paramLong < this.bytes.length)) : ("index = " + paramLong + " length = " + this.bytes.length);
/*  70 */     return this.bytes[((int)paramLong)];
/*     */   }
/*     */ 
/*     */   void put(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*  89 */     assert ((paramLong >= 0L) && (paramLong + paramInt2 < this.bytes.length)) : ("offset = " + paramLong + " length = " + paramInt2 + " bytes.length = " + this.bytes.length);
/*     */ 
/*  91 */     assert ((paramInt1 >= 0) && (paramInt1 + paramInt2 < paramArrayOfByte.length)) : ("srcOffset = " + paramInt1 + " length = " + paramInt2 + " src.length = " + paramArrayOfByte.length);
/*  92 */     System.arraycopy(paramArrayOfByte, paramInt1, this.bytes, (int)paramLong, paramInt2);
/*     */   }
/*     */ 
/*     */   void get(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 114 */     assert ((paramLong >= 0L) && (paramLong + paramInt2 <= this.bytes.length) && (paramInt1 >= 0) && (paramInt1 + paramInt2 <= paramArrayOfByte.length)) : (" offset: " + paramLong + " bytes.length: " + this.bytes.length + " destOffset: " + paramInt1 + " length: " + paramInt2);
/* 115 */     System.arraycopy(this.bytes, (int)paramLong, paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   char[] getChars(long paramLong, int paramInt1, DBConversion paramDBConversion, int paramInt2, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 142 */     assert ((paramLong >= 0L) && (paramInt1 >= 0) && (this.bytes.length >= paramLong + paramInt1)) : ("bytes.length: " + this.bytes.length + " offset: " + paramLong + " lengthInBytes: " + paramInt1);
/* 143 */     assert (paramDBConversion != null) : "conversion is null";
/*     */ 
/* 145 */     assert ((paramArrayOfInt != null) && (paramArrayOfInt.length >= 1)) : ("out_lengthInChars: " + paramArrayOfInt);
/* 146 */     boolean bool = paramInt2 == 2;
/* 147 */     char[] arrayOfChar = new char[paramInt1 * paramDBConversion.cMaxCharSize];
/* 148 */     int[] arrayOfInt = new int[1];
/* 149 */     arrayOfInt[0] = paramInt1;
/* 150 */     int i = paramDBConversion.CHARBytesToJavaChars(this.bytes, (int)paramLong, arrayOfChar, 0, arrayOfInt, arrayOfChar.length, bool);
/*     */ 
/* 157 */     paramArrayOfInt[0] = i;
/* 158 */     return arrayOfChar;
/*     */   }
/*     */ 
/*     */   char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 183 */     assert ((paramLong >= 0L) && (paramInt >= 0)) : ("offset: " + paramLong + " lengthInBytes: " + paramInt);
/*     */ 
/* 185 */     assert (this.bytes.length >= paramLong + paramInt) : ("bytes.length: " + this.bytes.length + " offset: " + paramLong + " lengthInBytes: " + paramInt);
/*     */ 
/* 187 */     assert ((paramArrayOfInt != null) && (paramArrayOfInt.length > 0)) : ("out_lengthInChars: " + paramArrayOfInt);
/* 188 */     String str = paramCharacterSet.toString(this.bytes, (int)paramLong, paramInt);
/* 189 */     char[] arrayOfChar = str.toCharArray();
/* 190 */     paramArrayOfInt[0] = arrayOfChar.length;
/* 191 */     return arrayOfChar;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong1, int paramInt, CRC64 paramCRC64, long paramLong2)
/*     */   {
/* 206 */     return CRC64.updateChecksum(paramLong2, this.bytes, (int)paramLong1, paramInt);
/*     */   }
/*     */ 
/*     */   byte[] getBlockBasic(long paramLong, int[] paramArrayOfInt)
/*     */   {
/* 215 */     paramArrayOfInt[0] = ((int)paramLong);
/* 216 */     return paramLong < this.bytes.length ? this.bytes : null;
/*     */   }
/*     */ 
/*     */   void free()
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.SimpleByteArray
 * JD-Core Version:    0.6.2
 */