/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class SensitiveScrollableResultSet extends InsensitiveScrollableResultSet
/*     */ {
/*     */   protected int beginLastFetchedIndex;
/*     */   protected int endLastFetchedIndex;
/* 237 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   SensitiveScrollableResultSet(PhysicalConnection paramPhysicalConnection, OracleStatement paramOracleStatement)
/*     */     throws SQLException
/*     */   {
/*  35 */     super(paramPhysicalConnection, paramOracleStatement);
/*     */ 
/*  38 */     if (this.fetchedRowCount > 0) {
/*  39 */       this.beginLastFetchedIndex = 1;
/*  40 */       this.endLastFetchedIndex = this.fetchedRowCount;
/*     */     }
/*     */     else {
/*  43 */       this.beginLastFetchedIndex = 0;
/*  44 */       this.endLastFetchedIndex = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getType()
/*     */   {
/*  59 */     return 1005;
/*     */   }
/*     */ 
/*     */   public boolean next()
/*     */     throws SQLException
/*     */   {
/*  68 */     synchronized (this.connection)
/*     */     {
/*  75 */       if (super.next()) {
/*  76 */         handleRefetch();
/*  77 */         return true;
/*     */       }
/*     */ 
/*  80 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean first()
/*     */     throws SQLException
/*     */   {
/*  87 */     synchronized (this.connection)
/*     */     {
/*  94 */       if (super.first()) {
/*  95 */         handleRefetch();
/*  96 */         return true;
/*     */       }
/*     */ 
/*  99 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean last()
/*     */     throws SQLException
/*     */   {
/* 106 */     synchronized (this.connection)
/*     */     {
/* 113 */       if (super.last()) {
/* 114 */         handleRefetch();
/* 115 */         return true;
/*     */       }
/*     */ 
/* 118 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean absolute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 125 */     synchronized (this.connection)
/*     */     {
/* 132 */       if (super.absolute(paramInt)) {
/* 133 */         handleRefetch();
/* 134 */         return true;
/*     */       }
/*     */ 
/* 137 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean relative(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 144 */     synchronized (this.connection)
/*     */     {
/* 151 */       if (super.relative(paramInt)) {
/* 152 */         handleRefetch();
/* 153 */         return true;
/*     */       }
/*     */ 
/* 156 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean previous()
/*     */     throws SQLException
/*     */   {
/* 163 */     synchronized (this.connection)
/*     */     {
/* 170 */       if (super.previous()) {
/* 171 */         handleRefetch();
/* 172 */         return true;
/*     */       }
/*     */ 
/* 175 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   int refreshRows(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 183 */     int i = super.refreshRows(paramInt1, paramInt2);
/* 184 */     if (i != 0) {
/* 185 */       this.beginLastFetchedIndex = paramInt1;
/* 186 */       this.endLastFetchedIndex = (paramInt1 + i - 1);
/*     */     }
/* 188 */     return i;
/*     */   }
/*     */ 
/*     */   void removeCurrentRowFromCache()
/*     */     throws SQLException
/*     */   {
/* 200 */     synchronized (this.connection)
/*     */     {
/* 202 */       int i = this.currentRow + 1;
/* 203 */       super.removeCurrentRowFromCache();
/* 204 */       if (!isEmptyResultSet()) {
/* 205 */         if (i < this.beginLastFetchedIndex) this.beginLastFetchedIndex -= 1;
/* 206 */         if (i <= this.endLastFetchedIndex) this.endLastFetchedIndex -= 1;
/* 207 */         if (!isAfterLast()) handleRefetch();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean handleRefetch()
/*     */     throws SQLException
/*     */   {
/* 218 */     synchronized (this.connection)
/*     */     {
/* 222 */       int i = this.currentRow + 1;
/* 223 */       if ((this.beginLastFetchedIndex <= i) && (i <= this.endLastFetchedIndex))
/*     */       {
/* 225 */         return false;
/*     */       }
/*     */ 
/* 229 */       refreshRow();
/* 230 */       return true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.SensitiveScrollableResultSet
 * JD-Core Version:    0.6.2
 */