/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.InputStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Date;
/*      */ import java.sql.SQLData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.oracore.OracleNamedType;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCOLLECTION;
/*      */ import oracle.jdbc.oracore.OracleTypeOPAQUE;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.ArrayDescriptor;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BINARY_DOUBLE;
/*      */ import oracle.sql.BINARY_FLOAT;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CharacterSet;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.JAVA_STRUCT;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.OpaqueDescriptor;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.SQLName;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ import oracle.sql.TypeDescriptor;
/*      */ import oracle.sql.converter.CharacterSetMetaData;
/*      */ import oracle.xdb.XMLType;
/*      */ 
/*      */ public class SQLUtil
/*      */ {
/* 1812 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */   private static final int CLASS_NOT_FOUND = -1;
/*      */   private static final int CLASS_STRING = 0;
/*      */   private static final int CLASS_BOOLEAN = 1;
/*      */   private static final int CLASS_INTEGER = 2;
/*      */   private static final int CLASS_LONG = 3;
/*      */   private static final int CLASS_FLOAT = 4;
/*      */   private static final int CLASS_DOUBLE = 5;
/*      */   private static final int CLASS_BIGDECIMAL = 6;
/*      */   private static final int CLASS_DATE = 7;
/*      */   private static final int CLASS_TIME = 8;
/*      */   private static final int CLASS_TIMESTAMP = 9;
/*      */   private static final int CLASS_SHORT = 10;
/*      */   private static final int CLASS_BYTE = 11;
/*      */   private static final int TOTAL_CLASSES = 12;
/* 1837 */   private static Hashtable classTable = new Hashtable(12);
/*      */ 
/*      */   public static Object SQLToJava(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt, String paramString, Class paramClass, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*   87 */     Datum localDatum = makeDatum(paramOracleConnection, paramArrayOfByte, paramInt, paramString, 0);
/*   88 */     Object localObject = SQLToJava(paramOracleConnection, localDatum, paramClass, paramMap);
/*      */ 
/*   90 */     return localObject;
/*      */   }
/*      */ 
/*      */   public static CustomDatum SQLToJava(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt, String paramString, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/*  128 */     Datum localDatum = makeDatum(paramOracleConnection, paramArrayOfByte, paramInt, paramString, 0);
/*  129 */     CustomDatum localCustomDatum = paramCustomDatumFactory.create(localDatum, paramInt);
/*      */ 
/*  131 */     return localCustomDatum;
/*      */   }
/*      */ 
/*      */   public static ORAData SQLToJava(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt, String paramString, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/*  169 */     Datum localDatum = makeDatum(paramOracleConnection, paramArrayOfByte, paramInt, paramString, 0);
/*  170 */     ORAData localORAData = paramORADataFactory.create(localDatum, paramInt);
/*      */ 
/*  172 */     return localORAData;
/*      */   }
/*      */ 
/*      */   public static OracleData SQLToJava(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt, String paramString, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/*  210 */     Datum localDatum = makeDatum(paramOracleConnection, paramArrayOfByte, paramInt, paramString, 0);
/*  211 */     OracleData localOracleData = paramOracleDataFactory.create(localDatum.toJdbc(), paramInt);
/*      */ 
/*  213 */     return localOracleData;
/*      */   }
/*      */ 
/*      */   public static Object SQLToJava(OracleConnection paramOracleConnection, Datum paramDatum, Class paramClass, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  253 */     Object localObject = null;
/*      */ 
/*  255 */     if ((paramDatum instanceof STRUCT))
/*      */     {
/*  261 */       if (paramClass == null)
/*      */       {
/*  263 */         localObject = paramMap != null ? ((STRUCT)paramDatum).toJdbc(paramMap) : paramDatum.toJdbc();
/*      */       }
/*      */       else
/*      */       {
/*  267 */         localObject = paramMap != null ? ((STRUCT)paramDatum).toClass(paramClass, paramMap) : ((STRUCT)paramDatum).toClass(paramClass);
/*      */       }
/*      */ 
/*      */     }
/*  271 */     else if (paramClass == null)
/*      */     {
/*  277 */       localObject = paramDatum.toJdbc();
/*      */     }
/*      */     else
/*      */     {
/*  285 */       int i = classNumber(paramClass);
/*      */ 
/*  287 */       switch (i)
/*      */       {
/*      */       case 0:
/*  291 */         localObject = paramDatum.stringValue();
/*      */ 
/*  293 */         break;
/*      */       case 1:
/*  296 */         localObject = Boolean.valueOf(paramDatum.longValue() != 0L);
/*      */ 
/*  298 */         break;
/*      */       case 10:
/*  301 */         localObject = Short.valueOf((short)(int)paramDatum.longValue());
/*      */ 
/*  303 */         break;
/*      */       case 11:
/*  306 */         localObject = Byte.valueOf((byte)(int)paramDatum.longValue());
/*      */ 
/*  308 */         break;
/*      */       case 2:
/*  311 */         localObject = Integer.valueOf((int)paramDatum.longValue());
/*      */ 
/*  313 */         break;
/*      */       case 3:
/*  316 */         localObject = Long.valueOf(paramDatum.longValue());
/*      */ 
/*  318 */         break;
/*      */       case 4:
/*  321 */         localObject = Float.valueOf(paramDatum.bigDecimalValue().floatValue());
/*      */ 
/*  323 */         break;
/*      */       case 5:
/*  326 */         localObject = Double.valueOf(paramDatum.bigDecimalValue().doubleValue());
/*      */ 
/*  328 */         break;
/*      */       case 6:
/*  331 */         localObject = paramDatum.bigDecimalValue();
/*      */ 
/*  333 */         break;
/*      */       case 7:
/*  336 */         localObject = paramDatum.dateValue();
/*      */ 
/*  338 */         break;
/*      */       case 8:
/*  341 */         localObject = paramDatum.timeValue();
/*      */ 
/*  343 */         break;
/*      */       case 9:
/*  346 */         localObject = paramDatum.timestampValue();
/*      */ 
/*  348 */         break;
/*      */       case -1:
/*      */       default:
/*  353 */         localObject = paramDatum.toJdbc();
/*      */ 
/*  355 */         if (!paramClass.isInstance(localObject))
/*      */         {
/*  359 */           SQLException localSQLException = DatabaseError.createSqlException(null, 59, "invalid data conversion");
/*  360 */           localSQLException.fillInStackTrace();
/*  361 */           throw localSQLException;
/*      */         }
/*      */ 
/*      */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  369 */     return localObject;
/*      */   }
/*      */ 
/*      */   public static byte[] JavaToSQL(OracleConnection paramOracleConnection, Object paramObject, int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  407 */     if (paramObject == null)
/*      */     {
/*  410 */       return null;
/*      */     }
/*      */ 
/*  418 */     Object localObject = null;
/*      */ 
/*  420 */     if ((paramObject instanceof Datum))
/*      */     {
/*  422 */       localObject = (Datum)paramObject;
/*      */     }
/*  424 */     else if ((paramObject instanceof ORAData))
/*      */     {
/*  426 */       localObject = ((ORAData)paramObject).toDatum(paramOracleConnection);
/*      */     }
/*  428 */     else if ((paramObject instanceof CustomDatum))
/*      */     {
/*  430 */       localObject = paramOracleConnection.toDatum((CustomDatum)paramObject);
/*      */     }
/*  432 */     else if ((paramObject instanceof SQLData))
/*      */     {
/*  434 */       localObject = STRUCT.toSTRUCT(paramObject, paramOracleConnection);
/*      */     }
/*      */ 
/*  441 */     if (localObject != null)
/*      */     {
/*  451 */       if (!checkDatumType((Datum)localObject, paramInt, paramString))
/*      */       {
/*  453 */         localObject = null;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  466 */       localObject = makeDatum(paramOracleConnection, paramObject, paramInt, paramString);
/*      */     }
/*      */ 
/*  469 */     byte[] arrayOfByte = null;
/*      */ 
/*  474 */     if (localObject != null)
/*      */     {
/*  476 */       if ((localObject instanceof STRUCT))
/*  477 */         arrayOfByte = ((STRUCT)localObject).toBytes();
/*  478 */       else if ((localObject instanceof ARRAY))
/*  479 */         arrayOfByte = ((ARRAY)localObject).toBytes();
/*  480 */       else if ((localObject instanceof OPAQUE))
/*  481 */         arrayOfByte = ((OPAQUE)localObject).toBytes();
/*      */       else {
/*  483 */         arrayOfByte = ((Datum)localObject).shareBytes();
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  489 */       SQLException localSQLException = DatabaseError.createSqlException(null, 1, "attempt to convert a Datum to incompatible SQL type");
/*  490 */       localSQLException.fillInStackTrace();
/*  491 */       throw localSQLException;
/*      */     }
/*      */ 
/*  495 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static Datum makeDatum(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt1, String paramString, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  556 */     Object localObject1 = null;
/*      */ 
/*  571 */     int i = paramOracleConnection.getDbCsId();
/*  572 */     int j = paramOracleConnection.getJdbcCsId();
/*  573 */     int k = CharacterSetMetaData.getRatio(j, i);
/*      */     Object localObject2;
/*  575 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/*  584 */       if ((paramInt2 != 0) && (paramInt2 < paramArrayOfByte.length) && (k == 1))
/*      */       {
/*  586 */         localObject1 = new CHAR(paramArrayOfByte, 0, paramInt2, CharacterSet.make(paramOracleConnection.getJdbcCsId()));
/*      */       }
/*      */       else
/*      */       {
/*  591 */         localObject1 = new CHAR(paramArrayOfByte, CharacterSet.make(paramOracleConnection.getJdbcCsId()));
/*      */       }
/*      */ 
/*  594 */       break;
/*      */     case 1:
/*      */     case 8:
/*  601 */       localObject1 = new CHAR(paramArrayOfByte, CharacterSet.make(paramOracleConnection.getJdbcCsId()));
/*      */ 
/*  604 */       break;
/*      */     case 2:
/*      */     case 6:
/*  609 */       localObject1 = new NUMBER(paramArrayOfByte);
/*      */ 
/*  611 */       break;
/*      */     case 100:
/*  614 */       localObject1 = new BINARY_FLOAT(paramArrayOfByte);
/*      */ 
/*  616 */       break;
/*      */     case 101:
/*  619 */       localObject1 = new BINARY_DOUBLE(paramArrayOfByte);
/*      */ 
/*  621 */       break;
/*      */     case 23:
/*      */     case 24:
/*  626 */       localObject1 = new RAW(paramArrayOfByte);
/*      */ 
/*  628 */       break;
/*      */     case 104:
/*  631 */       localObject1 = new ROWID(paramArrayOfByte);
/*      */ 
/*  633 */       break;
/*      */     case 102:
/*  641 */       localObject2 = DatabaseError.createSqlException(null, 1, "need resolution: do we want to handle ResultSet?");
/*  642 */       ((SQLException)localObject2).fillInStackTrace();
/*  643 */       throw ((Throwable)localObject2);
/*      */     case 12:
/*  647 */       localObject1 = new DATE(paramArrayOfByte);
/*      */ 
/*  649 */       break;
/*      */     case 182:
/*  652 */       localObject1 = new INTERVALYM(paramArrayOfByte);
/*      */ 
/*  654 */       break;
/*      */     case 183:
/*  657 */       localObject1 = new INTERVALDS(paramArrayOfByte);
/*      */ 
/*  659 */       break;
/*      */     case 180:
/*  662 */       localObject1 = new TIMESTAMP(paramArrayOfByte);
/*      */ 
/*  664 */       break;
/*      */     case 181:
/*  667 */       localObject1 = new TIMESTAMPTZ(paramArrayOfByte);
/*      */ 
/*  669 */       break;
/*      */     case 231:
/*  672 */       localObject1 = new TIMESTAMPLTZ(paramArrayOfByte);
/*      */ 
/*  674 */       break;
/*      */     case 113:
/*  677 */       localObject1 = paramOracleConnection.createBlob(paramArrayOfByte);
/*      */ 
/*  679 */       break;
/*      */     case 112:
/*  682 */       localObject1 = paramOracleConnection.createClob(paramArrayOfByte);
/*      */ 
/*  684 */       break;
/*      */     case 114:
/*  687 */       localObject1 = paramOracleConnection.createBfile(paramArrayOfByte);
/*      */ 
/*  689 */       break;
/*      */     case 257:
/*  692 */       localObject1 = XMLFactory.createXML(paramOracleConnection, new ByteArrayInputStream(paramArrayOfByte));
/*      */ 
/*  694 */       break;
/*      */     case 109:
/*  698 */       localObject2 = TypeDescriptor.getTypeDescriptor(paramString, paramOracleConnection, paramArrayOfByte, 0L);
/*      */ 
/*  701 */       switch (((TypeDescriptor)localObject2).getTypeCode())
/*      */       {
/*      */       case 2002:
/*  704 */         localObject1 = new STRUCT((StructDescriptor)localObject2, paramArrayOfByte, paramOracleConnection);
/*      */ 
/*  706 */         break;
/*      */       case 2008:
/*  709 */         localObject1 = new JAVA_STRUCT((StructDescriptor)localObject2, paramArrayOfByte, paramOracleConnection);
/*      */ 
/*  711 */         break;
/*      */       case 2003:
/*  714 */         localObject1 = new ARRAY((ArrayDescriptor)localObject2, paramArrayOfByte, paramOracleConnection);
/*      */ 
/*  716 */         break;
/*      */       case 2009:
/*  720 */         localObject1 = XMLFactory.createXML(new OPAQUE((OpaqueDescriptor)localObject2, paramArrayOfByte, paramOracleConnection));
/*      */ 
/*  722 */         break;
/*      */       case 2007:
/*  725 */         localObject1 = new OPAQUE((OpaqueDescriptor)localObject2, paramArrayOfByte, paramOracleConnection);
/*      */       case 2004:
/*      */       case 2005:
/*      */       case 2006:
/*      */       }
/*      */ 
/*  731 */       break;
/*      */     case 111:
/*  735 */       localObject2 = getTypeDescriptor(paramString, paramOracleConnection);
/*      */ 
/*  737 */       if ((localObject2 instanceof StructDescriptor))
/*      */       {
/*  739 */         localObject1 = new REF((StructDescriptor)localObject2, paramOracleConnection, paramArrayOfByte);
/*      */       }
/*      */       else
/*      */       {
/*  745 */         SQLException localSQLException = DatabaseError.createSqlException(null, 1, "program error: REF points to a non-STRUCT");
/*  746 */         localSQLException.fillInStackTrace();
/*  747 */         throw localSQLException;
/*      */       }
/*      */ 
/*  752 */       break;
/*      */     default:
/*  757 */       localObject2 = DatabaseError.createSqlException(null, 1, "program error: invalid SQL type code");
/*  758 */       ((SQLException)localObject2).fillInStackTrace();
/*  759 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/*  764 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public static Datum makeNDatum(OracleConnection paramOracleConnection, byte[] paramArrayOfByte, int paramInt1, String paramString, short paramShort, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  780 */     Object localObject = null;
/*      */ 
/*  782 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/*  790 */       int i = paramInt2 * CharacterSetMetaData.getRatio(paramOracleConnection.getNCharSet(), 1);
/*      */ 
/*  794 */       if ((paramInt2 != 0) && (i < paramArrayOfByte.length)) {
/*  795 */         localObject = new CHAR(paramArrayOfByte, 0, paramInt2, CharacterSet.make(paramOracleConnection.getNCharSet()));
/*      */       }
/*      */       else {
/*  798 */         localObject = new CHAR(paramArrayOfByte, CharacterSet.make(paramOracleConnection.getNCharSet()));
/*      */       }
/*      */ 
/*  801 */       break;
/*      */     case 1:
/*      */     case 8:
/*  808 */       localObject = new CHAR(paramArrayOfByte, CharacterSet.make(paramOracleConnection.getNCharSet()));
/*      */ 
/*  811 */       break;
/*      */     case 112:
/*  814 */       localObject = paramOracleConnection.createClob(paramArrayOfByte, paramShort);
/*      */ 
/*  816 */       break;
/*      */     default:
/*  821 */       SQLException localSQLException = DatabaseError.createSqlException(null, 1, "program error: invalid SQL type code");
/*  822 */       localSQLException.fillInStackTrace();
/*  823 */       throw localSQLException;
/*      */     }
/*      */ 
/*  828 */     return localObject;
/*      */   }
/*      */ 
/*      */   public static Datum makeDatum(OracleConnection paramOracleConnection, Object paramObject, int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  862 */     return makeDatum(paramOracleConnection, paramObject, paramInt, paramString, false);
/*      */   }
/*      */ 
/*      */   public static Datum makeDatum(OracleConnection paramOracleConnection, Object paramObject, int paramInt, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  876 */     Object localObject1 = null;
/*      */     Object localObject2;
/*  878 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/*      */     case 8:
/*      */     case 96:
/*  888 */       localObject1 = new CHAR(paramObject, CharacterSet.make(paramBoolean ? paramOracleConnection.getNCharSet() : paramOracleConnection.getJdbcCsId()));
/*      */ 
/*  891 */       break;
/*      */     case 2:
/*      */     case 6:
/*  896 */       localObject1 = new NUMBER(paramObject);
/*      */ 
/*  898 */       break;
/*      */     case 100:
/*  901 */       if ((paramObject instanceof String))
/*  902 */         localObject1 = new BINARY_FLOAT((String)paramObject);
/*  903 */       else if ((paramObject instanceof Boolean))
/*  904 */         localObject1 = new BINARY_FLOAT((Boolean)paramObject);
/*      */       else {
/*  906 */         localObject1 = new BINARY_FLOAT((Float)paramObject);
/*      */       }
/*  908 */       break;
/*      */     case 101:
/*  911 */       if ((paramObject instanceof String))
/*  912 */         localObject1 = new BINARY_DOUBLE((String)paramObject);
/*  913 */       else if ((paramObject instanceof Boolean))
/*  914 */         localObject1 = new BINARY_DOUBLE((Boolean)paramObject);
/*      */       else {
/*  916 */         localObject1 = new BINARY_DOUBLE((Double)paramObject);
/*      */       }
/*  918 */       break;
/*      */     case 23:
/*      */     case 24:
/*  923 */       localObject1 = new RAW(paramObject);
/*      */ 
/*  925 */       break;
/*      */     case 104:
/*  928 */       if ((paramObject instanceof String))
/*  929 */         localObject1 = new ROWID((String)paramObject);
/*  930 */       else if ((paramObject instanceof byte[]))
/*  931 */         localObject1 = new ROWID((byte[])paramObject); break;
/*      */     case 102:
/*  941 */       localObject2 = DatabaseError.createSqlException(null, 1, "need resolution: do we want to handle ResultSet");
/*  942 */       ((SQLException)localObject2).fillInStackTrace();
/*  943 */       throw ((Throwable)localObject2);
/*      */     case 12:
/*  947 */       localObject1 = new DATE(paramObject);
/*      */ 
/*  949 */       break;
/*      */     case 180:
/*  952 */       if ((paramObject instanceof TIMESTAMP))
/*      */       {
/*  954 */         localObject1 = (Datum)paramObject;
/*      */       }
/*  956 */       else if ((paramObject instanceof Timestamp))
/*  957 */         localObject1 = new TIMESTAMP((Timestamp)paramObject);
/*  958 */       else if ((paramObject instanceof Date))
/*  959 */         localObject1 = new TIMESTAMP((Date)paramObject);
/*  960 */       else if ((paramObject instanceof Time))
/*  961 */         localObject1 = new TIMESTAMP((Time)paramObject);
/*  962 */       else if ((paramObject instanceof DATE))
/*  963 */         localObject1 = new TIMESTAMP((DATE)paramObject);
/*  964 */       else if ((paramObject instanceof String))
/*  965 */         localObject1 = new TIMESTAMP((String)paramObject);
/*  966 */       else if ((paramObject instanceof byte[]))
/*  967 */         localObject1 = new TIMESTAMP((byte[])paramObject); break;
/*      */     case 181:
/*  972 */       if ((paramObject instanceof TIMESTAMPTZ))
/*      */       {
/*  974 */         localObject1 = (Datum)paramObject;
/*      */       }
/*  976 */       else if ((paramObject instanceof Timestamp))
/*  977 */         localObject1 = new TIMESTAMPTZ(paramOracleConnection, (Timestamp)paramObject);
/*  978 */       else if ((paramObject instanceof Date))
/*  979 */         localObject1 = new TIMESTAMPTZ(paramOracleConnection, (Date)paramObject);
/*  980 */       else if ((paramObject instanceof Time))
/*  981 */         localObject1 = new TIMESTAMPTZ(paramOracleConnection, (Time)paramObject);
/*  982 */       else if ((paramObject instanceof DATE))
/*  983 */         localObject1 = new TIMESTAMPTZ(paramOracleConnection, (DATE)paramObject);
/*  984 */       else if ((paramObject instanceof String))
/*  985 */         localObject1 = new TIMESTAMPTZ(paramOracleConnection, (String)paramObject);
/*  986 */       else if ((paramObject instanceof byte[]))
/*  987 */         localObject1 = new TIMESTAMPTZ((byte[])paramObject); break;
/*      */     case 231:
/*  992 */       if ((paramObject instanceof TIMESTAMPLTZ))
/*      */       {
/*  994 */         localObject1 = (Datum)paramObject;
/*      */       }
/*  996 */       else if ((paramObject instanceof Timestamp))
/*  997 */         localObject1 = new TIMESTAMPLTZ(paramOracleConnection, (Timestamp)paramObject);
/*  998 */       else if ((paramObject instanceof Date))
/*  999 */         localObject1 = new TIMESTAMPLTZ(paramOracleConnection, (Date)paramObject);
/* 1000 */       else if ((paramObject instanceof Time))
/* 1001 */         localObject1 = new TIMESTAMPLTZ(paramOracleConnection, (Time)paramObject);
/* 1002 */       else if ((paramObject instanceof DATE))
/* 1003 */         localObject1 = new TIMESTAMPLTZ(paramOracleConnection, (DATE)paramObject);
/* 1004 */       else if ((paramObject instanceof String))
/* 1005 */         localObject1 = new TIMESTAMPLTZ(paramOracleConnection, (String)paramObject);
/* 1006 */       else if ((paramObject instanceof byte[]))
/* 1007 */         localObject1 = new TIMESTAMPLTZ((byte[])paramObject); break;
/*      */     case 113:
/* 1012 */       if ((paramObject instanceof BLOB))
/*      */       {
/* 1014 */         localObject1 = (Datum)paramObject;
/*      */       }
/* 1016 */       if ((paramObject instanceof byte[]))
/*      */       {
/* 1018 */         localObject1 = new RAW((byte[])paramObject); } break;
/*      */     case 112:
/* 1024 */       if ((paramObject instanceof CLOB))
/*      */       {
/* 1026 */         localObject1 = (Datum)paramObject;
/*      */       }
/*      */ 
/* 1029 */       if ((paramObject instanceof String))
/*      */       {
/* 1031 */         localObject2 = CharacterSet.make(paramBoolean ? paramOracleConnection.getNCharSet() : paramOracleConnection.getJdbcCsId());
/* 1032 */         localObject1 = new CHAR((String)paramObject, (CharacterSet)localObject2);
/* 1033 */       }break;
/*      */     case 114:
/* 1038 */       if ((paramObject instanceof BFILE))
/*      */       {
/* 1040 */         localObject1 = (Datum)paramObject; } break;
/*      */     case 109:
/* 1046 */       if (((paramObject instanceof STRUCT)) || ((paramObject instanceof ARRAY)) || ((paramObject instanceof OPAQUE)))
/*      */       {
/* 1049 */         localObject1 = (Datum)paramObject; } break;
/*      */     case 257:
/* 1055 */       if ((paramObject instanceof String))
/*      */       {
/* 1057 */         localObject1 = XMLFactory.createXML(paramOracleConnection, (String)paramObject); } break;
/*      */     case 111:
/* 1062 */       if ((paramObject instanceof REF))
/*      */       {
/* 1064 */         localObject1 = (Datum)paramObject; } break;
/*      */     }
/*      */ 
/* 1073 */     if (localObject1 == null)
/*      */     {
/* 1077 */       localObject2 = DatabaseError.createSqlException(null, 1, "Unable to construct a Datum from the specified input");
/* 1078 */       ((SQLException)localObject2).fillInStackTrace();
/* 1079 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1083 */     return localObject1;
/*      */   }
/*      */ 
/*      */   private static int classNumber(Class paramClass)
/*      */   {
/* 1098 */     int i = -1;
/* 1099 */     Integer localInteger = (Integer)classTable.get(paramClass);
/*      */ 
/* 1101 */     if (localInteger != null)
/*      */     {
/* 1103 */       i = localInteger.intValue();
/*      */     }
/*      */ 
/* 1106 */     return i;
/*      */   }
/*      */ 
/*      */   public static Object getTypeDescriptor(String paramString, OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 1140 */     Object localObject = null;
/*      */ 
/* 1145 */     SQLName localSQLName = new SQLName(paramString, paramOracleConnection);
/* 1146 */     String str = localSQLName.getName();
/*      */ 
/* 1151 */     localObject = paramOracleConnection.getDescriptor(str);
/*      */ 
/* 1153 */     if (localObject != null)
/*      */     {
/* 1156 */       return localObject;
/*      */     }
/*      */ 
/* 1162 */     OracleTypeADT localOracleTypeADT = new OracleTypeADT(str, paramOracleConnection);
/* 1163 */     localOracleTypeADT.init(paramOracleConnection);
/*      */ 
/* 1165 */     OracleNamedType localOracleNamedType = localOracleTypeADT.cleanup();
/*      */ 
/* 1170 */     switch (localOracleNamedType.getTypeCode())
/*      */     {
/*      */     case 2003:
/* 1175 */       localObject = new ArrayDescriptor(localSQLName, (OracleTypeCOLLECTION)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1179 */       break;
/*      */     case 2002:
/*      */     case 2008:
/* 1185 */       localObject = new StructDescriptor(localSQLName, (OracleTypeADT)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1189 */       break;
/*      */     case 2007:
/* 1193 */       localObject = new OpaqueDescriptor(localSQLName, (OracleTypeOPAQUE)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1197 */       break;
/*      */     case 2004:
/*      */     case 2005:
/*      */     case 2006:
/*      */     default:
/* 1202 */       SQLException localSQLException = DatabaseError.createSqlException(null, 1, "Unrecognized type code");
/* 1203 */       localSQLException.fillInStackTrace();
/* 1204 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1211 */     paramOracleConnection.putDescriptor(str, localObject);
/*      */ 
/* 1213 */     return localObject;
/*      */   }
/*      */ 
/*      */   public static boolean checkDatumType(Datum paramDatum, int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1243 */     boolean bool = false;
/*      */ 
/* 1245 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/*      */     case 8:
/*      */     case 96:
/* 1253 */       bool = paramDatum instanceof CHAR;
/*      */ 
/* 1255 */       break;
/*      */     case 2:
/*      */     case 6:
/* 1260 */       bool = paramDatum instanceof NUMBER;
/*      */ 
/* 1262 */       break;
/*      */     case 100:
/* 1265 */       bool = paramDatum instanceof BINARY_FLOAT;
/*      */ 
/* 1267 */       break;
/*      */     case 101:
/* 1270 */       bool = paramDatum instanceof BINARY_DOUBLE;
/*      */ 
/* 1272 */       break;
/*      */     case 23:
/*      */     case 24:
/* 1277 */       bool = paramDatum instanceof RAW;
/*      */ 
/* 1279 */       break;
/*      */     case 104:
/* 1282 */       bool = paramDatum instanceof ROWID;
/*      */ 
/* 1284 */       break;
/*      */     case 12:
/* 1287 */       bool = paramDatum instanceof DATE;
/*      */ 
/* 1289 */       break;
/*      */     case 180:
/* 1292 */       bool = paramDatum instanceof TIMESTAMP;
/*      */ 
/* 1294 */       break;
/*      */     case 181:
/* 1297 */       bool = paramDatum instanceof TIMESTAMPTZ;
/*      */ 
/* 1299 */       break;
/*      */     case 231:
/* 1302 */       bool = paramDatum instanceof TIMESTAMPLTZ;
/*      */ 
/* 1304 */       break;
/*      */     case 113:
/* 1307 */       bool = paramDatum instanceof BLOB;
/*      */ 
/* 1309 */       break;
/*      */     case 112:
/* 1312 */       bool = paramDatum instanceof CLOB;
/*      */ 
/* 1314 */       break;
/*      */     case 114:
/* 1317 */       bool = paramDatum instanceof BFILE;
/*      */ 
/* 1319 */       break;
/*      */     case 111:
/* 1322 */       bool = ((paramDatum instanceof REF)) && (((REF)paramDatum).getBaseTypeName().equals(paramString));
/*      */ 
/* 1325 */       break;
/*      */     case 109:
/* 1328 */       if ((paramDatum instanceof STRUCT))
/*      */       {
/* 1330 */         bool = ((STRUCT)paramDatum).isInHierarchyOf(paramString);
/*      */       }
/* 1332 */       else if ((paramDatum instanceof ARRAY))
/*      */       {
/* 1334 */         bool = ((ARRAY)paramDatum).getSQLTypeName().equals(paramString);
/*      */       }
/* 1336 */       else if ((paramDatum instanceof OPAQUE))
/*      */       {
/* 1338 */         bool = ((OPAQUE)paramDatum).getSQLTypeName().equals(paramString); } break;
/*      */     case 102:
/*      */     default:
/* 1346 */       bool = false;
/*      */     }
/*      */ 
/* 1349 */     return bool;
/*      */   }
/*      */ 
/*      */   public static boolean implementsInterface(Class paramClass1, Class paramClass2)
/*      */   {
/* 1369 */     if (paramClass1 == null)
/*      */     {
/* 1371 */       return false;
/*      */     }
/*      */ 
/* 1374 */     if (paramClass1 == paramClass2)
/*      */     {
/* 1376 */       return true;
/*      */     }
/*      */ 
/* 1379 */     Class[] arrayOfClass = paramClass1.getInterfaces();
/*      */ 
/* 1381 */     for (int i = 0; i < arrayOfClass.length; i++)
/*      */     {
/* 1383 */       if (implementsInterface(arrayOfClass[i], paramClass2))
/*      */       {
/* 1385 */         return true;
/*      */       }
/*      */     }
/*      */ 
/* 1389 */     return implementsInterface(paramClass1.getSuperclass(), paramClass2);
/*      */   }
/*      */ 
/*      */   public static Datum makeOracleDatum(OracleConnection paramOracleConnection, Object paramObject, int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1420 */     return makeOracleDatum(paramOracleConnection, paramObject, paramInt, paramString, false);
/*      */   }
/*      */ 
/*      */   public static Datum makeOracleDatum(OracleConnection paramOracleConnection, Object paramObject, int paramInt, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1435 */     Datum localDatum = makeDatum(paramOracleConnection, paramObject, getInternalType(paramInt), paramString, paramBoolean);
/*      */ 
/* 1438 */     return localDatum;
/*      */   }
/*      */ 
/*      */   public static int getInternalType(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1446 */     int i = 0;
/*      */ 
/* 1448 */     switch (paramInt)
/*      */     {
/*      */     case -7:
/*      */     case -6:
/*      */     case -5:
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/* 1470 */       i = 6;
/*      */ 
/* 1472 */       break;
/*      */     case 100:
/* 1475 */       i = 100;
/*      */ 
/* 1477 */       break;
/*      */     case 101:
/* 1480 */       i = 101;
/*      */ 
/* 1482 */       break;
/*      */     case 999:
/* 1485 */       i = 999;
/*      */ 
/* 1487 */       break;
/*      */     case 1:
/* 1490 */       i = 96;
/*      */ 
/* 1492 */       break;
/*      */     case -15:
/* 1495 */       i = 96;
/* 1496 */       break;
/*      */     case 12:
/* 1499 */       i = 1;
/*      */ 
/* 1501 */       break;
/*      */     case -9:
/* 1504 */       i = 1;
/* 1505 */       break;
/*      */     case -1:
/* 1508 */       i = 8;
/*      */ 
/* 1510 */       break;
/*      */     case 91:
/*      */     case 92:
/* 1515 */       i = 12;
/*      */ 
/* 1517 */       break;
/*      */     case -100:
/*      */     case 93:
/* 1522 */       i = 180;
/*      */ 
/* 1524 */       break;
/*      */     case -101:
/* 1527 */       i = 181;
/*      */ 
/* 1529 */       break;
/*      */     case -102:
/* 1532 */       i = 231;
/*      */ 
/* 1534 */       break;
/*      */     case -104:
/* 1537 */       i = 183;
/*      */ 
/* 1539 */       break;
/*      */     case -103:
/* 1542 */       i = 182;
/*      */ 
/* 1544 */       break;
/*      */     case -3:
/*      */     case -2:
/* 1549 */       i = 23;
/*      */ 
/* 1551 */       break;
/*      */     case -4:
/* 1554 */       i = 24;
/*      */ 
/* 1556 */       break;
/*      */     case -8:
/* 1559 */       i = 104;
/*      */ 
/* 1561 */       break;
/*      */     case 2004:
/* 1564 */       i = 113;
/*      */ 
/* 1566 */       break;
/*      */     case 2005:
/* 1569 */       i = 112;
/*      */ 
/* 1571 */       break;
/*      */     case 2011:
/* 1574 */       i = 112;
/*      */ 
/* 1576 */       break;
/*      */     case -13:
/* 1579 */       i = 114;
/*      */ 
/* 1581 */       break;
/*      */     case -10:
/* 1584 */       i = 102;
/*      */ 
/* 1586 */       break;
/*      */     case 2009:
/* 1589 */       i = 257;
/* 1590 */       break;
/*      */     case 2002:
/*      */     case 2003:
/*      */     case 2007:
/*      */     case 2008:
/* 1599 */       i = 109;
/*      */ 
/* 1601 */       break;
/*      */     case 2006:
/* 1604 */       i = 111;
/*      */ 
/* 1606 */       break;
/*      */     default:
/* 1611 */       SQLException localSQLException = DatabaseError.createSqlException(null, 4, "get_internal_type");
/* 1612 */       localSQLException.fillInStackTrace();
/* 1613 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1617 */     return i;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1632 */     return null;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/* 1841 */       classTable.put(Class.forName("java.lang.String"), Integer.valueOf(0));
/*      */ 
/* 1843 */       classTable.put(Class.forName("java.lang.Boolean"), Integer.valueOf(1));
/*      */ 
/* 1845 */       classTable.put(Class.forName("java.lang.Integer"), Integer.valueOf(2));
/*      */ 
/* 1847 */       classTable.put(Class.forName("java.lang.Long"), Integer.valueOf(3));
/*      */ 
/* 1849 */       classTable.put(Class.forName("java.lang.Float"), Integer.valueOf(4));
/*      */ 
/* 1851 */       classTable.put(Class.forName("java.lang.Double"), Integer.valueOf(5));
/*      */ 
/* 1853 */       classTable.put(Class.forName("java.math.BigDecimal"), Integer.valueOf(6));
/*      */ 
/* 1855 */       classTable.put(Class.forName("java.sql.Date"), Integer.valueOf(7));
/*      */ 
/* 1857 */       classTable.put(Class.forName("java.sql.Time"), Integer.valueOf(8));
/*      */ 
/* 1859 */       classTable.put(Class.forName("java.sql.Timestamp"), Integer.valueOf(9));
/*      */ 
/* 1861 */       classTable.put(Class.forName("java.lang.Short"), Integer.valueOf(10));
/*      */ 
/* 1863 */       classTable.put(Class.forName("java.lang.Byte"), Integer.valueOf(11));
/*      */     }
/*      */     catch (ClassNotFoundException localClassNotFoundException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class XMLFactory
/*      */   {
/*      */     static Datum createXML(OPAQUE paramOPAQUE)
/*      */       throws SQLException
/*      */     {
/*  504 */       return XMLType.createXML(paramOPAQUE);
/*      */     }
/*      */ 
/*      */     static Datum createXML(OracleConnection paramOracleConnection, String paramString) throws SQLException
/*      */     {
/*  509 */       return XMLType.createXML(paramOracleConnection, paramString);
/*      */     }
/*      */ 
/*      */     static Datum createXML(OracleConnection paramOracleConnection, InputStream paramInputStream) throws SQLException
/*      */     {
/*  514 */       return XMLType.createXML(paramOracleConnection, paramInputStream);
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.SQLUtil
 * JD-Core Version:    0.6.2
 */