/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLClientInfoException;
/*     */ import java.sql.SQLDataException;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLFeatureNotSupportedException;
/*     */ import java.sql.SQLIntegrityConstraintViolationException;
/*     */ import java.sql.SQLInvalidAuthorizationSpecException;
/*     */ import java.sql.SQLNonTransientConnectionException;
/*     */ import java.sql.SQLNonTransientException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import java.sql.SQLSyntaxErrorException;
/*     */ import java.sql.SQLTimeoutException;
/*     */ import java.sql.SQLTransactionRollbackException;
/*     */ import java.sql.SQLTransientConnectionException;
/*     */ import java.sql.SQLTransientException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ 
/*     */ class SQLStateMapping
/*     */ {
/*     */   public static final int SQLEXCEPTION = 0;
/*     */   public static final int SQLNONTRANSIENTEXCEPTION = 1;
/*     */   public static final int SQLTRANSIENTEXCEPTION = 2;
/*     */   public static final int SQLDATAEXCEPTION = 3;
/*     */   public static final int SQLFEATURENOTSUPPORTEDEXCEPTION = 4;
/*     */   public static final int SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION = 5;
/*     */   public static final int SQLINVALIDAUTHORIZATIONSPECEXCEPTION = 6;
/*     */   public static final int SQLNONTRANSIENTCONNECTIONEXCEPTION = 7;
/*     */   public static final int SQLSYNTAXERROREXCEPTION = 8;
/*     */   public static final int SQLTIMEOUTEXCEPTION = 9;
/*     */   public static final int SQLTRANSACTIONROLLBACKEXCEPTION = 10;
/*     */   public static final int SQLTRANSIENTCONNECTIONEXCEPTION = 11;
/*     */   public static final int SQLCLIENTINFOEXCEPTION = 12;
/*     */   public static final int SQLRECOVERABLEEXCEPTION = 13;
/*     */   int low;
/*     */   int high;
/*     */   public String sqlState;
/*     */   public int exception;
/*     */   static final String mappingResource = "errorMap.xml";
/*     */   static SQLStateMapping[] all;
/*     */   private static final int NUMEBER_OF_MAPPINGS_IN_ERRORMAP_XML = 128;
/* 465 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public SQLStateMapping(int paramInt1, int paramInt2, String paramString, int paramInt3)
/*     */   {
/*  52 */     this.low = paramInt1;
/*  53 */     this.sqlState = paramString;
/*  54 */     this.exception = paramInt3;
/*  55 */     this.high = paramInt2;
/*     */   }
/*     */ 
/*     */   public boolean isIncluded(int paramInt)
/*     */   {
/*  61 */     return (this.low <= paramInt) && (paramInt <= this.high);
/*     */   }
/*     */ 
/*     */   public SQLException newSQLException(String paramString, int paramInt)
/*     */   {
/*  67 */     switch (this.exception) {
/*     */     case 0:
/*  69 */       return new SQLException(paramString, this.sqlState, paramInt);
/*     */     case 1:
/*  71 */       return new SQLNonTransientException(paramString, this.sqlState, paramInt);
/*     */     case 2:
/*  73 */       return new SQLTransientException(paramString, this.sqlState, paramInt);
/*     */     case 3:
/*  75 */       return new SQLDataException(paramString, this.sqlState, paramInt);
/*     */     case 4:
/*  77 */       return new SQLFeatureNotSupportedException(paramString, this.sqlState, paramInt);
/*     */     case 5:
/*  79 */       return new SQLIntegrityConstraintViolationException(paramString, this.sqlState, paramInt);
/*     */     case 6:
/*  81 */       return new SQLInvalidAuthorizationSpecException(paramString, this.sqlState, paramInt);
/*     */     case 7:
/*  83 */       return new SQLNonTransientConnectionException(paramString, this.sqlState, paramInt);
/*     */     case 8:
/*  85 */       return new SQLSyntaxErrorException(paramString, this.sqlState, paramInt);
/*     */     case 9:
/*  87 */       return new SQLTimeoutException(paramString, this.sqlState, paramInt);
/*     */     case 10:
/*  89 */       return new SQLTransactionRollbackException(paramString, this.sqlState, paramInt);
/*     */     case 11:
/*  91 */       return new SQLTransientConnectionException(paramString, this.sqlState, paramInt);
/*     */     case 12:
/*  93 */       return new SQLClientInfoException(paramString, this.sqlState, paramInt, null);
/*     */     case 13:
/*  95 */       return new SQLRecoverableException(paramString, this.sqlState, paramInt);
/*  96 */     }return new SQLException(paramString, this.sqlState, paramInt);
/*     */   }
/*     */ 
/*     */   boolean lessThan(SQLStateMapping paramSQLStateMapping)
/*     */   {
/* 102 */     if (this.low < paramSQLStateMapping.low) {
/* 103 */       return this.high < paramSQLStateMapping.high;
/*     */     }
/*     */ 
/* 106 */     return this.high <= paramSQLStateMapping.high;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 111 */     return super.toString() + "(" + this.low + ", " + this.high + ", " + this.sqlState + ", " + this.exception + ")";
/*     */   }
/*     */ 
/*     */   public static void main(String[] paramArrayOfString)
/*     */     throws IOException
/*     */   {
/* 118 */     SQLStateMapping[] arrayOfSQLStateMapping = doGetMappings();
/* 119 */     System.out.println("a\t" + arrayOfSQLStateMapping);
/* 120 */     for (int i = 0; i < arrayOfSQLStateMapping.length; i++)
/* 121 */       System.out.println("low:\t" + arrayOfSQLStateMapping[i].low + "\thigh:\t" + arrayOfSQLStateMapping[i].high + "\tsqlState:\t" + arrayOfSQLStateMapping[i].sqlState + "\tsqlException:\t" + arrayOfSQLStateMapping[i].exception);
/*     */   }
/*     */ 
/*     */   static SQLStateMapping[] getMappings()
/*     */   {
/* 131 */     if (all == null) {
/*     */       try {
/* 133 */         all = doGetMappings();
/*     */       }
/*     */       catch (Throwable localThrowable)
/*     */       {
/* 137 */         all = new SQLStateMapping[0];
/*     */       }
/*     */     }
/* 140 */     return all;
/*     */   }
/*     */ 
/*     */   static SQLStateMapping[] doGetMappings()
/*     */     throws IOException
/*     */   {
/* 148 */     InputStream localInputStream = SQLStateMapping.class.getResourceAsStream("errorMap.xml");
/* 149 */     ArrayList localArrayList = new ArrayList(128);
/* 150 */     load(localInputStream, localArrayList);
/* 151 */     return (SQLStateMapping[])localArrayList.toArray(new SQLStateMapping[0]);
/*     */   }
/*     */ 
/*     */   static void load(InputStream paramInputStream, List paramList)
/*     */     throws IOException
/*     */   {
/* 173 */     BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(paramInputStream));
/* 174 */     Tokenizer localTokenizer = new Tokenizer(localBufferedReader);
/* 175 */     int i = -1;
/* 176 */     int j = -1;
/* 177 */     Object localObject1 = null;
/* 178 */     int k = -1;
/* 179 */     Object localObject2 = null;
/* 180 */     int m = 0;
/*     */     String str;
/* 182 */     while ((str = localTokenizer.next()) != null)
/* 183 */       switch (m) {
/*     */       case 0:
/* 185 */         if (str.equals("<")) m = 1; break;
/*     */       case 1:
/* 188 */         if (str.equals("!")) m = 2;
/* 189 */         else if (str.equals("oraErrorSqlStateSqlExceptionMapping")) m = 6; else {
/* 190 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
/*     */         }
/*     */         break;
/*     */       case 2:
/* 194 */         if (str.equals("-")) m = 3; else {
/* 195 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"-\".");
/*     */         }
/*     */         break;
/*     */       case 3:
/* 199 */         if (str.equals("-")) m = 4; break;
/*     */       case 4:
/* 202 */         if (str.equals("-")) m = 5; else
/* 203 */           m = 3;
/* 204 */         break;
/*     */       case 5:
/* 206 */         if (str.equals(">")) m = 0; else {
/* 207 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \">\".");
/*     */         }
/*     */         break;
/*     */       case 6:
/* 211 */         if (str.equals(">")) m = 7; else {
/* 212 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \">\".");
/*     */         }
/*     */         break;
/*     */       case 7:
/* 216 */         if (str.equals("<")) m = 8; else {
/* 217 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"<\".");
/*     */         }
/*     */         break;
/*     */       case 8:
/* 221 */         if (str.equals("!")) m = 9;
/* 222 */         else if (str.equals("error")) m = 14;
/* 223 */         else if (str.equals("/")) m = 16; else {
/* 224 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected one of \"!--\", \"error\", \"/\".");
/*     */         }
/*     */         break;
/*     */       case 9:
/* 228 */         if (str.equals("-")) m = 10; else {
/* 229 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"-\".");
/*     */         }
/*     */         break;
/*     */       case 10:
/* 233 */         if (str.equals("-")) m = 11; else {
/* 234 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"-\".");
/*     */         }
/*     */         break;
/*     */       case 11:
/* 238 */         if (str.equals("-")) m = 12; break;
/*     */       case 12:
/* 241 */         if (str.equals("-")) m = 13; else
/* 242 */           m = 11;
/* 243 */         break;
/*     */       case 13:
/* 245 */         if (str.equals(">")) m = 7; else {
/* 246 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \">\".");
/*     */         }
/*     */         break;
/*     */       case 14:
/* 250 */         if (str.equals("/")) m = 15;
/* 251 */         else if (str.equals("oraErrorFrom")) m = 19;
/* 252 */         else if (str.equals("oraErrorTo")) m = 21;
/* 253 */         else if (str.equals("sqlState")) m = 23;
/* 254 */         else if (str.equals("sqlException")) m = 25;
/* 255 */         else if (str.equals("comment")) m = 27; else {
/* 256 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected one of " + "\"oraErrorFrom\", \"oraErrorTo\", \"sqlState\", " + "\"sqlException\", \"comment\", \"/\".");
/*     */         }
/*     */ 
/*     */         break;
/*     */       case 15:
/* 262 */         if (str.equals(">")) {
/*     */           try {
/* 264 */             createOne(paramList, i, j, (String)localObject1, k, (String)localObject2);
/*     */           }
/*     */           catch (IOException localIOException) {
/* 267 */             throw new IOException("Invalid error element at line " + localTokenizer.lineno + " of errorMap.xml. " + localIOException.getMessage());
/*     */           }
/*     */ 
/* 270 */           i = -1;
/* 271 */           j = -1;
/* 272 */           localObject1 = null;
/* 273 */           k = -1;
/* 274 */           localObject2 = null;
/* 275 */           m = 7;
/*     */         } else {
/* 277 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \">\".");
/*     */         }
/*     */         break;
/*     */       case 16:
/* 281 */         if (str.equals("oraErrorSqlStateSqlExceptionMapping")) m = 17; else {
/* 282 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
/*     */         }
/*     */         break;
/*     */       case 17:
/* 286 */         if (str.equals(">")) m = 18; else {
/* 287 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \">\".");
/*     */         }
/*     */         break;
/*     */       case 18:
/* 291 */         break;
/*     */       case 19:
/* 293 */         if (str.equals("=")) m = 20; else
/* 294 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"=\".");
/*     */         break;
/*     */       case 20:
/*     */         try
/*     */         {
/* 299 */           i = Integer.parseInt(str);
/*     */         }
/*     */         catch (NumberFormatException localNumberFormatException1) {
/* 302 */           throw new IOException("Unexpected value \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected an integer.");
/*     */         }
/*     */ 
/* 305 */         m = 14;
/* 306 */         break;
/*     */       case 21:
/* 308 */         if (str.equals("=")) m = 22; else
/* 309 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"=\".");
/*     */         break;
/*     */       case 22:
/*     */         try
/*     */         {
/* 314 */           j = Integer.parseInt(str);
/*     */         }
/*     */         catch (NumberFormatException localNumberFormatException2) {
/* 317 */           throw new IOException("Unexpected value \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected an integer.");
/*     */         }
/*     */ 
/* 320 */         m = 14;
/* 321 */         break;
/*     */       case 23:
/* 323 */         if (str.equals("=")) m = 24; else {
/* 324 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"=\".");
/*     */         }
/*     */         break;
/*     */       case 24:
/* 328 */         localObject1 = str;
/* 329 */         m = 14;
/* 330 */         break;
/*     */       case 25:
/* 332 */         if (str.equals("=")) m = 26; else
/* 333 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"=\".");
/*     */         break;
/*     */       case 26:
/*     */         try
/*     */         {
/* 338 */           k = valueOf(str);
/*     */         }
/*     */         catch (Exception localException) {
/* 341 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected SQLException" + " subclass name.");
/*     */         }
/*     */ 
/* 345 */         m = 14;
/* 346 */         break;
/*     */       case 27:
/* 348 */         if (str.equals("=")) m = 28; else {
/* 349 */           throw new IOException("Unexpected token \"" + str + "\" at line " + localTokenizer.lineno + " of errorMap.xml. Expected \"=\".");
/*     */         }
/*     */         break;
/*     */       case 28:
/* 353 */         localObject2 = str;
/* 354 */         m = 14;
/* 355 */         break;
/*     */       default:
/* 357 */         throw new IOException("Unknown parser state " + m + " at line " + localTokenizer.lineno + " of errorMap.xml.");
/*     */       }
/*     */   }
/*     */ 
/*     */   private static void createOne(List paramList, int paramInt1, int paramInt2, String paramString1, int paramInt3, String paramString2)
/*     */     throws IOException
/*     */   {
/* 426 */     if (paramInt1 == -1) throw new IOException("oraErrorFrom is a required attribute");
/* 427 */     if (paramInt2 == -1) paramInt2 = paramInt1;
/* 428 */     if ((paramString1 == null) || (paramString1.length() == 0)) throw new IOException("sqlState is a required attribute");
/* 429 */     if (paramInt3 == -1) throw new IOException("sqlException is a required attribute");
/* 430 */     if ((paramString2 == null) || (paramString2.length() < 8)) throw new IOException("a lengthy comment in required");
/* 431 */     SQLStateMapping localSQLStateMapping = new SQLStateMapping(paramInt1, paramInt2, paramString1, paramInt3);
/* 432 */     add(paramList, localSQLStateMapping);
/*     */   }
/*     */ 
/*     */   static void add(List paramList, SQLStateMapping paramSQLStateMapping) {
/* 436 */     int i = paramList.size();
/* 437 */     while ((i > 0) && 
/* 438 */       (!((SQLStateMapping)paramList.get(i - 1)).lessThan(paramSQLStateMapping))) {
/* 437 */       i--;
/*     */     }
/*     */ 
/* 442 */     paramList.add(i, paramSQLStateMapping);
/*     */   }
/*     */ 
/*     */   static int valueOf(String paramString) throws Exception
/*     */   {
/* 447 */     if (paramString.equalsIgnoreCase("SQLEXCEPTION")) return 0;
/* 448 */     if (paramString.equalsIgnoreCase("SQLNONTRANSIENTEXCEPTION")) return 1;
/* 449 */     if (paramString.equalsIgnoreCase("SQLTRANSIENTEXCEPTION")) return 2;
/* 450 */     if (paramString.equalsIgnoreCase("SQLDATAEXCEPTION")) return 3;
/* 451 */     if (paramString.equalsIgnoreCase("SQLFEATURENOTSUPPORTEDEXCEPTION")) return 4;
/* 452 */     if (paramString.equalsIgnoreCase("SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION")) return 5;
/* 453 */     if (paramString.equalsIgnoreCase("SQLINVALIDAUTHORIZATIONSPECEXCEPTION")) return 6;
/* 454 */     if (paramString.equalsIgnoreCase("SQLNONTRANSIENTCONNECTIONEXCEPTION")) return 7;
/* 455 */     if (paramString.equalsIgnoreCase("SQLSYNTAXERROREXCEPTION")) return 8;
/* 456 */     if (paramString.equalsIgnoreCase("SQLTIMEOUTEXCEPTION")) return 9;
/* 457 */     if (paramString.equalsIgnoreCase("SQLTRANSACTIONROLLBACKEXCEPTION")) return 10;
/* 458 */     if (paramString.equalsIgnoreCase("SQLTRANSIENTCONNECTIONEXCEPTION")) return 11;
/* 459 */     if (paramString.equalsIgnoreCase("SQLCLIENTINFOEXCEPTION")) return 12;
/* 460 */     if (paramString.equalsIgnoreCase("SQLRECOVERABLEEXCEPTION")) return 13;
/* 461 */     throw new Exception("unexpected exception name: " + paramString);
/*     */   }
/*     */ 
/*     */   private static final class Tokenizer
/*     */   {
/* 375 */     int lineno = 1;
/*     */     Reader r;
/*     */     int c;
/*     */ 
/*     */     Tokenizer(Reader paramReader)
/*     */       throws IOException
/*     */     {
/* 380 */       this.r = paramReader;
/* 381 */       this.c = paramReader.read();
/*     */     }
/*     */ 
/*     */     String next() throws IOException {
/* 385 */       StringBuffer localStringBuffer = new StringBuffer(16);
/* 386 */       int i = 1;
/*     */ 
/* 388 */       while (this.c != -1) {
/* 389 */         if (this.c == 10) this.lineno += 1;
/* 390 */         if ((this.c <= 32) && (i != 0)) {
/* 391 */           this.c = this.r.read();
/*     */         }
/* 394 */         else if ((this.c <= 32) && (i == 0)) {
/* 395 */           this.c = this.r.read();
/*     */         }
/* 398 */         else if (this.c == 34) {
/* 399 */           while ((this.c = this.r.read()) != 34) localStringBuffer.append((char)this.c);
/* 400 */           this.c = this.r.read();
/*     */         }
/* 403 */         else if (((48 <= this.c) && (this.c <= 57)) || ((65 <= this.c) && (this.c <= 90)) || ((97 <= this.c) && (this.c <= 122)) || (this.c == 95))
/*     */         {
/*     */           do
/*     */           {
/* 408 */             localStringBuffer.append((char)this.c);
/*     */           }
/*     */ 
/* 412 */           while (((48 <= (this.c = this.r.read())) && (this.c <= 57)) || ((65 <= this.c) && (this.c <= 90)) || ((97 <= this.c) && (this.c <= 122)) || (this.c == 95));
/*     */         }
/*     */         else {
/* 415 */           localStringBuffer.append((char)this.c);
/* 416 */           this.c = this.r.read();
/*     */         }
/*     */       }
/* 419 */       if (localStringBuffer.length() > 0) return localStringBuffer.toString();
/* 420 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.SQLStateMapping
 * JD-Core Version:    0.6.2
 */