/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.ROWID;
/*     */ 
/*     */ class RowidAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = 4000;
/*     */   static final int EXTENDED_ROWID_MAX_LENGTH = 18;
/* 145 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   RowidAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  26 */     super(Representation.ROWID, paramOracleStatement, 4000, paramBoolean);
/*     */ 
/*  28 */     init(paramOracleStatement, 104, 9, paramShort, paramBoolean);
/*  29 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   RowidAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  37 */     super(Representation.ROWID, paramOracleStatement, 4000, false);
/*     */ 
/*  39 */     init(paramOracleStatement, 104, 9, paramShort, false);
/*  40 */     initForDescribe(104, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  42 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  50 */     if (paramInt1 != 0) {
/*  51 */       this.externalType = paramInt1;
/*     */     }
/*  53 */     this.byteLength = (this.representationMaxLength + 2);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  70 */     if (isNull(paramInt)) return null;
/*  71 */     return this.rowData.getString(getOffset(paramInt), getLength(paramInt), this.statement.connection.conversion.getCharacterSet((short)1));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  90 */     return getROWID(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 106 */     return getROWID(paramInt);
/*     */   }
/*     */ 
/*     */   ROWID getROWID(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 122 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 124 */     return arrayOfByte == null ? null : new ROWID(arrayOfByte);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 140 */     return getROWID(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.RowidAccessor
 * JD-Core Version:    0.6.2
 */