/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class ResultSetAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = 16;
/*     */   OracleStatement currentStmt;
/* 105 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   ResultSetAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  25 */     super(Representation.RESULT_SET, paramOracleStatement, 16, paramBoolean);
/*     */ 
/*  27 */     init(paramOracleStatement, 102, 116, paramShort, paramBoolean);
/*  28 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   ResultSetAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  36 */     super(Representation.RESULT_SET, paramOracleStatement, 16, false);
/*     */ 
/*  38 */     init(paramOracleStatement, 102, 116, paramShort, false);
/*  39 */     initForDescribe(102, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  41 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   ResultSet getCursor(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  61 */     if ((this.currentStmt != null) && (this.currentStmt.refCursorRowNumber == paramInt) && (this.currentStmt.currentResultSet != null))
/*     */     {
/*  65 */       return this.currentStmt.currentResultSet;
/*     */     }
/*     */ 
/*  68 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/*  70 */     OracleStatement localOracleStatement = this.statement.connection.RefCursorBytesToStatement(arrayOfByte, this.statement);
/*     */ 
/*  73 */     localOracleStatement.refCursorRowNumber = paramInt;
/*     */ 
/*  75 */     localOracleStatement.doDescribe(false);
/*  76 */     if (localOracleStatement.numberOfDefinePositions > 0) localOracleStatement.prepareAccessors();
/*  77 */     localOracleStatement.setPrefetchInternal(this.statement.getFetchSize(), false, false);
/*  78 */     localOracleStatement.closeOnCompletion();
/*     */ 
/*  80 */     OracleResultSet localOracleResultSet = OracleResultSet.createResultSet(localOracleStatement);
/*     */ 
/*  82 */     localOracleStatement.currentResultSet = localOracleResultSet;
/*  83 */     this.currentStmt = localOracleStatement;
/*     */ 
/*  85 */     return localOracleResultSet;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 100 */     return getCursor(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ResultSetAccessor
 * JD-Core Version:    0.6.2
 */