/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.NClob;
/*     */ import java.sql.Ref;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Struct;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Arrays;
/*     */ import java.util.Calendar;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import oracle.jdbc.OracleArray;
/*     */ import oracle.jdbc.OracleBfile;
/*     */ import oracle.jdbc.OracleBlob;
/*     */ import oracle.jdbc.OracleClob;
/*     */ import oracle.jdbc.OracleData;
/*     */ import oracle.jdbc.OracleOpaque;
/*     */ import oracle.jdbc.OracleRef;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.BFILE;
/*     */ import oracle.sql.BINARY_DOUBLE;
/*     */ import oracle.sql.BINARY_FLOAT;
/*     */ import oracle.sql.BLOB;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.INTERVALDS;
/*     */ import oracle.sql.INTERVALYM;
/*     */ import oracle.sql.NUMBER;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.ORAData;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.REF;
/*     */ import oracle.sql.ROWID;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPLTZ;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ public class Representation
/*     */ {
/* 138 */   public static final Representation VARCHAR = new Representation("VARCHAR", new Class[] { String.class, Reader.class, CHAR.class, InputStream.class, BigDecimal.class, Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class, Timestamp.class, java.util.Date.class, Calendar.class, java.sql.Date.class, Time.class, Boolean.class });
/*     */ 
/* 157 */   public static final Representation FIXED_CHAR = VARCHAR;
/* 158 */   public static final Representation CHAR = VARCHAR;
/* 159 */   public static final Representation VCS = VARCHAR;
/* 160 */   public static final Representation LONG = new Representation("LONG", new Class[] { String.class, Reader.class, InputStream.class });
/*     */ 
/* 165 */   public static final Representation NUMBER = new Representation("NUMBER", new Class[] { BigDecimal.class, NUMBER.class, Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class, Boolean.class });
/*     */ 
/* 176 */   public static final Representation VARNUM = NUMBER;
/* 177 */   public static final Representation BINARY_FLOAT = new Representation("BINARY_FLOAT", new Class[] { Float.class, Double.class, BigDecimal.class, BINARY_FLOAT.class, NUMBER.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class });
/*     */ 
/* 189 */   public static final Representation BINARY_DOUBLE = new Representation("BINARY_DOUBLE", new Class[] { Double.class, BigDecimal.class, BINARY_DOUBLE.class, NUMBER.class, Float.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class });
/*     */ 
/* 201 */   public static final Representation RAW = new Representation("RAW", new Class[] { [B.class, RAW.class });
/*     */ 
/* 205 */   public static final Representation VBI = null;
/* 206 */   public static final Representation LONG_RAW = RAW;
/* 207 */   public static final Representation ROWID = new Representation("ROWID", new Class[] { RowId.class, ROWID.class, String.class });
/*     */ 
/* 212 */   public static final Representation RESULT_SET = new Representation("RESULT_SET", new Class[] { ResultSet.class });
/*     */ 
/* 215 */   public static final Representation RSET = RESULT_SET;
/* 216 */   public static final Representation DATE = new Representation("DATE", new Class[] { Timestamp.class, java.util.Date.class, Calendar.class, DATE.class, TIMESTAMP.class, String.class, java.sql.Date.class, Time.class });
/*     */ 
/* 226 */   public static final Representation BLOB = new Representation("BLOB", new Class[] { Blob.class, BLOB.class, OracleBlob.class, InputStream.class, [B.class });
/*     */ 
/* 233 */   public static final Representation CLOB = new Representation("CLOB", new Class[] { Clob.class, CLOB.class, OracleClob.class, Reader.class, String.class, InputStream.class });
/*     */ 
/* 241 */   public static final Representation BFILE = new Representation("BFILE", new Class[] { BFILE.class, OracleBfile.class, InputStream.class, [B.class });
/*     */ 
/* 247 */   public static final Representation NAMED_TYPE = new Representation("NAMED_TYPE", new Class[] { SQLXML.class, OracleData.class, ORAData.class, OPAQUE.class, OracleOpaque.class, Struct.class, STRUCT.class, Array.class, ARRAY.class, OracleArray.class });
/*     */ 
/* 259 */   public static final Representation REF_TYPE = new Representation("REF_TYPE", new Class[] { Ref.class, REF.class, OracleRef.class });
/*     */ 
/* 264 */   public static final Representation TIMESTAMP = new Representation("TIMESTAMP", new Class[] { Timestamp.class, TIMESTAMP.class, Calendar.class, java.util.Date.class, DATE.class, String.class, java.sql.Date.class, Time.class, [B.class });
/*     */ 
/* 275 */   public static final Representation TIMESTAMPTZ = new Representation("TIMESTAMPTZ", new Class[] { TIMESTAMPTZ.class, Timestamp.class, TIMESTAMP.class, Calendar.class, java.util.Date.class, DATE.class, String.class, java.sql.Date.class, Time.class, [B.class });
/*     */ 
/* 287 */   public static final Representation OLD_TIMESTAMPTZ = new Representation("OLD_TIMESTAMPTZ", new Class[] { TIMESTAMPTZ.class, Timestamp.class, TIMESTAMP.class, Calendar.class, java.util.Date.class, String.class, java.sql.Date.class, Time.class });
/*     */ 
/* 297 */   public static final Representation TIMESTAMPLTZ = new Representation("TIMESTAMPLTZ", new Class[] { TIMESTAMPLTZ.class, Timestamp.class, TIMESTAMP.class, Calendar.class, java.util.Date.class, DATE.class, String.class, java.sql.Date.class, Time.class, [B.class });
/*     */ 
/* 309 */   public static final Representation INTERVALYM = new Representation("INTERVALYM", new Class[] { INTERVALYM.class });
/*     */ 
/* 312 */   public static final Representation INTERVALDS = new Representation("INTERVALDS", new Class[] { INTERVALDS.class });
/*     */ 
/* 315 */   public static final Representation UROWID = null;
/* 316 */   public static final Representation PLSQL_INDEX_TABLE = null;
/*     */ 
/* 319 */   public static final Representation T2S_OVERLONG_RAW = null;
/* 320 */   public static final Representation SET_CHAR_BYTES = null;
/* 321 */   public static final Representation NULL_TYPE = null;
/* 322 */   public static final Representation DML_RETURN_PARAM = null;
/*     */ 
/* 324 */   public static final Representation NVARCHAR = new Representation("NVARCHAR", new Class[] { String.class, Reader.class, CHAR.class, InputStream.class, BigDecimal.class, Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class, Timestamp.class, java.util.Date.class, Calendar.class, java.sql.Date.class, Time.class, Boolean.class });
/*     */ 
/* 343 */   public static final Representation FIXED_NCHAR = NVARCHAR;
/* 344 */   public static final Representation NCHAR = NVARCHAR;
/* 345 */   public static final Representation NVCS = NVARCHAR;
/* 346 */   public static final Representation NCLOB = new Representation("NCLOB", new Class[] { NClob.class, Clob.class, CLOB.class, Reader.class, String.class, InputStream.class });
/*     */   protected final List<Class> tableB3Classes;
/* 374 */   protected final Map<Class, Redirector> redirectorCache = new ConcurrentHashMap(1024);
/*     */   protected final String identifier;
/* 474 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected Representation(String paramString, Class[] paramArrayOfClass)
/*     */   {
/* 385 */     this.identifier = paramString;
/* 386 */     assert (paramArrayOfClass.length > 0) : paramArrayOfClass.length;
/* 387 */     this.tableB3Classes = Collections.unmodifiableList(Arrays.asList(paramArrayOfClass));
/* 388 */     assert (this.tableB3Classes.size() > 0) : this.tableB3Classes.size();
/* 389 */     this.redirectorCache.putAll(Redirector.createRedirectorMap(this.tableB3Classes));
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 393 */     return "oracle.jdbc.driver.Representation[" + this.identifier + "]";
/*     */   }
/*     */ 
/*     */   <T> T getObject(Accessor paramAccessor, int paramInt, Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 412 */     if (paramClass == null) {
/* 413 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 282);
/* 414 */       ((SQLException)localObject).fillInStackTrace();
/* 415 */       throw ((Throwable)localObject);
/*     */     }
/* 417 */     Object localObject = getRedirector(paramClass);
/* 418 */     if (localObject == null) {
/* 419 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, paramClass);
/* 420 */       localSQLException.fillInStackTrace();
/* 421 */       throw localSQLException;
/*     */     }
/* 423 */     return ((Redirector)localObject).redirect(paramAccessor, paramInt);
/*     */   }
/*     */ 
/*     */   final <T> Redirector<T> getRedirector(Class<T> paramClass)
/*     */   {
/* 439 */     Redirector localRedirector = (Redirector)this.redirectorCache.get(paramClass);
/* 440 */     if (localRedirector == null) {
/* 441 */       localRedirector = createRedirector(paramClass);
/* 442 */       this.redirectorCache.put(paramClass, localRedirector);
/*     */     }
/* 444 */     return localRedirector;
/*     */   }
/*     */ 
/*     */   private final <T> Redirector<T> createRedirector(Class<T> paramClass)
/*     */   {
/* 458 */     if ((SQLData.class.isAssignableFrom(paramClass)) || (OracleData.class.isAssignableFrom(paramClass)) || (ORAData.class.isAssignableFrom(paramClass)))
/*     */     {
/* 461 */       return Redirector.createObjectRedirector(paramClass);
/*     */     }
/*     */ 
/* 464 */     return Redirector.createValueOfRedirector(paramClass, this.tableB3Classes);
/*     */   }
/*     */ 
/*     */   static OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 470 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.Representation
 * JD-Core Version:    0.6.2
 */