/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.oracore.OracleType;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.REF;
/*     */ import oracle.sql.StructDescriptor;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ 
/*     */ class RefTypeAccessor extends TypeAccessor
/*     */ {
/*     */   static final int MAXLENGTH = -1;
/* 142 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   RefTypeAccessor(OracleStatement paramOracleStatement, String paramString, short paramShort, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  27 */     super(Representation.REF_TYPE, paramOracleStatement, -1, paramBoolean);
/*     */ 
/*  29 */     init(paramOracleStatement, 111, 111, paramShort, paramBoolean);
/*  30 */     initForDataAccess(paramInt, 0, paramString);
/*     */   }
/*     */ 
/*     */   RefTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString)
/*     */     throws SQLException
/*     */   {
/*  39 */     super(Representation.REF_TYPE, paramOracleStatement, -1, false);
/*     */ 
/*  41 */     init(paramOracleStatement, 111, 111, paramShort, false);
/*  42 */     initForDescribe(111, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/*  44 */     initForDataAccess(0, paramInt1, paramString);
/*     */   }
/*     */ 
/*     */   RefTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString, OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/*  53 */     super(Representation.REF_TYPE, paramOracleStatement, -1, false);
/*     */ 
/*  55 */     init(paramOracleStatement, 111, 111, paramShort, false);
/*     */ 
/*  57 */     this.describeOtype = paramOracleType;
/*     */ 
/*  59 */     initForDescribe(111, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/*  62 */     this.internalOtype = paramOracleType;
/*     */ 
/*  64 */     initForDataAccess(0, paramInt1, paramString);
/*     */   }
/*     */ 
/*     */   OracleType otypeFromName(String paramString)
/*     */     throws SQLException
/*     */   {
/*  71 */     if (!this.outBind) {
/*  72 */       return TypeDescriptor.getTypeDescriptor(paramString, this.statement.connection).getPickler();
/*     */     }
/*     */ 
/*  75 */     return StructDescriptor.createDescriptor(paramString, this.statement.connection).getOracleTypeADT();
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  84 */     super.initForDataAccess(paramInt1, paramInt2, paramString);
/*     */ 
/*  86 */     this.byteLength = this.statement.connection.refTypeAccessorByteLen;
/*     */   }
/*     */ 
/*     */   REF getREF(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 103 */     if (isNull(paramInt)) return null;
/*     */ 
/* 105 */     byte[] arrayOfByte = pickledBytes(paramInt);
/* 106 */     OracleTypeADT localOracleTypeADT = (OracleTypeADT)this.internalOtype;
/* 107 */     return new REF(localOracleTypeADT.getFullName(), this.statement.connection, arrayOfByte);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 116 */     return getObject(paramInt, this.statement.connection.getTypeMap());
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 124 */     return getREF(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 131 */     REF localREF = getREF(paramInt);
/* 132 */     if (localREF == null) {
/* 133 */       return null;
/*     */     }
/*     */ 
/* 136 */     return localREF.toJdbc(paramMap);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.RefTypeAccessor
 * JD-Core Version:    0.6.2
 */