/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.CharArrayReader;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.util.RepConversion;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.RAW;
/*     */ 
/*     */ class RawCommonAccessor extends Accessor
/*     */ {
/* 242 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   RawCommonAccessor(OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*     */   {
/*  27 */     super(Representation.RAW, paramOracleStatement, paramInt, paramBoolean);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, short paramShort, int paramInt4)
/*     */     throws SQLException
/*     */   {
/*  35 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  36 */     initForDataAccess(paramInt4, paramInt3, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  45 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  46 */     initForDescribe(paramInt1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, null);
/*     */ 
/*  49 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  51 */     if ((i > 0) && ((paramInt3 == 0) || (i < paramInt3))) {
/*  52 */       paramInt3 = i;
/*     */     }
/*  54 */     initForDataAccess(0, paramInt3, null);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  76 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/*  78 */     if (arrayOfByte == null) {
/*  79 */       return null;
/*     */     }
/*  81 */     int i = arrayOfByte.length;
/*     */ 
/*  83 */     if (i == 0) {
/*  84 */       return null;
/*     */     }
/*  86 */     return RepConversion.bArray2String(arrayOfByte);
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 100 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 102 */     if (arrayOfByte == null) {
/* 103 */       return null;
/*     */     }
/* 105 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/*     */ 
/* 107 */     return localPhysicalConnection.conversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 2);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 122 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 124 */     if (arrayOfByte == null) {
/* 125 */       return null;
/*     */     }
/* 127 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/*     */ 
/* 129 */     return localPhysicalConnection.conversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 3);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 144 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 146 */     if (arrayOfByte == null) {
/* 147 */       return null;
/*     */     }
/* 149 */     int i = arrayOfByte.length;
/*     */ 
/* 151 */     char[] arrayOfChar = new char[i << 1];
/*     */ 
/* 153 */     int j = DBConversion.RAWBytesToHexChars(arrayOfByte, i, arrayOfChar);
/*     */ 
/* 156 */     return new CharArrayReader(arrayOfChar, 0, j);
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 170 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 172 */     if (arrayOfByte == null) {
/* 173 */       return null;
/*     */     }
/* 175 */     return new ByteArrayInputStream(arrayOfByte);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 189 */     return getBytes(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 204 */     return getBytes(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 218 */     return getRAW(paramInt);
/*     */   }
/*     */ 
/*     */   RAW getRAW(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 232 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 234 */     if (arrayOfByte == null) {
/* 235 */       return null;
/*     */     }
/* 237 */     return new RAW(arrayOfByte);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.RawCommonAccessor
 * JD-Core Version:    0.6.2
 */