/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ class PlsqlIndexTableAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = -1;
/*     */   PlsqlIbtBindInfo ibtBindInfo;
/* 158 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   PlsqlIndexTableAccessor(OracleStatement paramOracleStatement, PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  30 */     super(Representation.PLSQL_INDEX_TABLE, paramOracleStatement, -1, true);
/*     */ 
/*  32 */     init(paramOracleStatement, 998, 998, paramShort, true);
/*  33 */     this.ibtBindInfo = paramPlsqlIbtBindInfo;
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  41 */     unimpl("initForDataAccess");
/*     */   }
/*     */ 
/*     */   PlsqlIbtBindInfo plsqlIndexTableBindInfo()
/*     */     throws SQLException
/*     */   {
/*  48 */     return this.ibtBindInfo;
/*     */   }
/*     */ 
/*     */   Object[] getPlsqlIndexTable(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  66 */     this.rowData.setPosition(getOffset(paramInt));
/*  67 */     int i = this.rowData.getInt();
/*     */     Object localObject;
/*     */     int j;
/*     */     int k;
/*  69 */     switch (this.ibtBindInfo.element_internal_type)
/*     */     {
/*     */     case 9:
/*  72 */       localObject = new String[i];
/*  73 */       for (j = 0; j < i; j++) {
/*  74 */         k = this.rowData.getShort();
/*  75 */         if (k == 0) localObject[j] = null; else {
/*  76 */           localObject[j] = this.rowData.getString(k, this.statement.connection.conversion.getCharacterSet(1));
/*     */         }
/*     */       }
/*  79 */       break;
/*     */     case 6:
/*  82 */       localObject = new BigDecimal[i];
/*  83 */       for (j = 0; j < i; j++) {
/*  84 */         k = this.rowData.getShort();
/*  85 */         if (k == 0) localObject[j] = null; else
/*  86 */           localObject[j] = NUMBER.toBigDecimal(this.rowData.getBytes(k));
/*     */       }
/*  88 */       break;
/*     */     default:
/*  92 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/*  93 */       localSQLException.fillInStackTrace();
/*  94 */       throw localSQLException;
/*     */     }
/*     */ 
/*  98 */     assert (this.rowData.getPosition() == getOffset(paramInt) + getLength(paramInt)) : ("rowData.position(): " + this.rowData.getPosition() + " getOffset(" + paramInt + "): " + getOffset(paramInt) + " getLength(" + paramInt + "): " + getLength(paramInt));
/*     */ 
/* 100 */     return localObject;
/*     */   }
/*     */ 
/*     */   Datum[] getOraclePlsqlIndexTable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 118 */     this.rowData.setPosition(getOffset(paramInt));
/* 119 */     Object localObject = null;
/* 120 */     int i = this.rowData.getInt();
/*     */     int j;
/*     */     int k;
/* 121 */     switch (this.ibtBindInfo.element_internal_type)
/*     */     {
/*     */     case 9:
/* 124 */       localObject = new CHAR[i];
/* 125 */       CharacterSet localCharacterSet = this.statement.connection.conversion.getDriverCharSetObj();
/* 126 */       for (j = 0; j < i; j++) {
/* 127 */         k = this.rowData.getShort();
/* 128 */         if (k == 0) localObject[j] = null; else
/* 129 */           localObject[j] = new CHAR(this.rowData.getBytes(k), localCharacterSet);
/*     */       }
/* 131 */       break;
/*     */     case 6:
/* 134 */       localObject = new NUMBER[i];
/* 135 */       for (j = 0; j < i; j++) {
/* 136 */         k = this.rowData.getShort();
/* 137 */         if (k == 0) localObject[j] = null; else
/* 138 */           localObject[j] = new NUMBER(this.rowData.getBytes(k));
/*     */       }
/* 140 */       break;
/*     */     default:
/* 144 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/* 145 */       localSQLException.fillInStackTrace();
/* 146 */       throw localSQLException;
/*     */     }
/*     */ 
/* 150 */     assert (this.rowData.getPosition() == getOffset(paramInt) + getLength(paramInt)) : ("rowData.position(): " + this.rowData.getPosition() + " getOffset(" + paramInt + "): " + getOffset(paramInt) + " getLength(" + paramInt + "): " + getLength(paramInt));
/*     */ 
/* 152 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.PlsqlIndexTableAccessor
 * JD-Core Version:    0.6.2
 */