/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.SQLException;
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ import oracle.sql.Datum;
/*       */ 
/*       */ class PlsqlIbtBinder extends Binder
/*       */ {
/* 23223 */   Binder thePlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
/*       */ 
/* 23347 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   PlsqlIbtBinder()
/*       */   {
/* 23229 */     init(this);
/*       */   }
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 23236 */     paramBinder.type = 998;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 23248 */     PlsqlIbtBindInfo localPlsqlIbtBindInfo = paramOraclePreparedStatement.parameterPlsqlIbt[paramInt3][paramInt1];
/*       */ 
/* 23250 */     if (paramBoolean) {
/* 23251 */       paramOraclePreparedStatement.parameterPlsqlIbt[paramInt3][paramInt1] = null;
/*       */     }
/* 23253 */     int i = localPlsqlIbtBindInfo.ibtValueIndex;
/*       */     int j;
/* 23255 */     switch (localPlsqlIbtBindInfo.element_internal_type)
/*       */     {
/*       */     case 9:
/* 23259 */       for (j = 0; j < localPlsqlIbtBindInfo.curLen; j++)
/*       */       {
/* 23261 */         int k = 0;
/* 23262 */         String str = (String)localPlsqlIbtBindInfo.arrayData[j];
/*       */ 
/* 23264 */         if (str != null)
/*       */         {
/* 23266 */           k = str.length();
/*       */ 
/* 23268 */           if (k > localPlsqlIbtBindInfo.elemMaxLen - 1) {
/* 23269 */             k = localPlsqlIbtBindInfo.elemMaxLen - 1;
/*       */           }
/* 23271 */           str.getChars(0, k, paramOraclePreparedStatement.ibtBindChars, i + 1);
/*       */ 
/* 23273 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtIndicatorIndex + j)] = 0;
/* 23274 */           k <<= 1;
/* 23275 */           paramOraclePreparedStatement.ibtBindChars[i] = ((char)k);
/*       */ 
/* 23278 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtLengthIndex + j)] = (k == 0 ? 3 : (short)(k + 2));
/*       */         }
/*       */         else
/*       */         {
/* 23284 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtIndicatorIndex + j)] = -1;
/*       */         }
/* 23286 */         i += localPlsqlIbtBindInfo.elemMaxLen;
/*       */       }
/*       */ 
/* 23289 */       break;
/*       */     case 6:
/* 23293 */       for (j = 0; j < localPlsqlIbtBindInfo.curLen; j++) {
/* 23294 */         byte[] arrayOfByte = null;
/* 23295 */         if (localPlsqlIbtBindInfo.arrayData[j] != null) {
/* 23296 */           arrayOfByte = ((Datum)localPlsqlIbtBindInfo.arrayData[j]).getBytes();
/*       */         }
/*       */ 
/* 23299 */         if (arrayOfByte == null) {
/* 23300 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtIndicatorIndex + j)] = -1;
/*       */         }
/*       */         else {
/* 23303 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtIndicatorIndex + j)] = 0;
/* 23304 */           paramOraclePreparedStatement.ibtBindIndicators[(localPlsqlIbtBindInfo.ibtLengthIndex + j)] = ((short)(arrayOfByte.length + 1));
/*       */ 
/* 23306 */           paramOraclePreparedStatement.ibtBindBytes[i] = ((byte)arrayOfByte.length);
/*       */ 
/* 23308 */           System.arraycopy(arrayOfByte, 0, paramOraclePreparedStatement.ibtBindBytes, i + 1, arrayOfByte.length);
/*       */         }
/*       */ 
/* 23312 */         i += localPlsqlIbtBindInfo.elemMaxLen;
/*       */ 
/* 23314 */         if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 23315 */           if (arrayOfByte == null) {
/* 23316 */             paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */           }
/*       */           else
/*       */           {
/* 23320 */             paramLong = CRC64.updateChecksum(paramLong, arrayOfByte, 0, arrayOfByte.length);
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/* 23327 */       break;
/*       */     default:
/* 23331 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/* 23332 */       localSQLException.fillInStackTrace();
/* 23333 */       throw localSQLException;
/*       */     }
/*       */ 
/* 23336 */     return paramLong;
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 23343 */     return this.thePlsqlIbtCopyingBinder;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.PlsqlIbtBinder
 * JD-Core Version:    0.6.2
 */