/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.lang.reflect.Field;
/*       */ import java.lang.reflect.Modifier;
/*       */ import java.math.BigDecimal;
/*       */ import java.math.BigInteger;
/*       */ import java.net.InetAddress;
/*       */ import java.net.SocketException;
/*       */ import java.net.UnknownHostException;
/*       */ import java.security.AccessController;
/*       */ import java.security.NoSuchAlgorithmException;
/*       */ import java.security.Permission;
/*       */ import java.security.PrivilegedAction;
/*       */ import java.security.spec.InvalidKeySpecException;
/*       */ import java.sql.Array;
/*       */ import java.sql.Blob;
/*       */ import java.sql.CallableStatement;
/*       */ import java.sql.ClientInfoStatus;
/*       */ import java.sql.Clob;
/*       */ import java.sql.Connection;
/*       */ import java.sql.DatabaseMetaData;
/*       */ import java.sql.Date;
/*       */ import java.sql.DriverManager;
/*       */ import java.sql.NClob;
/*       */ import java.sql.PreparedStatement;
/*       */ import java.sql.ResultSet;
/*       */ import java.sql.ResultSetMetaData;
/*       */ import java.sql.SQLClientInfoException;
/*       */ import java.sql.SQLException;
/*       */ import java.sql.SQLWarning;
/*       */ import java.sql.SQLXML;
/*       */ import java.sql.Savepoint;
/*       */ import java.sql.Statement;
/*       */ import java.sql.Struct;
/*       */ import java.sql.Time;
/*       */ import java.sql.Timestamp;
/*       */ import java.util.ArrayList;
/*       */ import java.util.Arrays;
/*       */ import java.util.Calendar;
/*       */ import java.util.EnumSet;
/*       */ import java.util.Enumeration;
/*       */ import java.util.GregorianCalendar;
/*       */ import java.util.HashMap;
/*       */ import java.util.Hashtable;
/*       */ import java.util.Iterator;
/*       */ import java.util.List;
/*       */ import java.util.Map;
/*       */ import java.util.Properties;
/*       */ import java.util.Set;
/*       */ import java.util.TimeZone;
/*       */ import java.util.Vector;
/*       */ import java.util.concurrent.Executor;
/*       */ import java.util.regex.Matcher;
/*       */ import java.util.regex.Pattern;
/*       */ import javax.transaction.xa.XAResource;
/*       */ import oracle.jdbc.LogicalTransactionIdEventListener;
/*       */ import oracle.jdbc.OracleConnection.CommitOption;
/*       */ import oracle.jdbc.OracleConnection.DatabaseShutdownMode;
/*       */ import oracle.jdbc.OracleConnection.DatabaseStartupMode;
/*       */ import oracle.jdbc.OracleOCIFailover;
/*       */ import oracle.jdbc.OracleSQLPermission;
/*       */ import oracle.jdbc.aq.AQDequeueOptions;
/*       */ import oracle.jdbc.aq.AQEnqueueOptions;
/*       */ import oracle.jdbc.aq.AQMessage;
/*       */ import oracle.jdbc.aq.AQMessageProperties;
/*       */ import oracle.jdbc.aq.AQNotificationRegistration;
/*       */ import oracle.jdbc.dcn.DatabaseChangeRegistration;
/*       */ import oracle.jdbc.internal.JMSDequeueOptions;
/*       */ import oracle.jdbc.internal.JMSEnqueueOptions;
/*       */ import oracle.jdbc.internal.JMSFactory;
/*       */ import oracle.jdbc.internal.JMSMessage;
/*       */ import oracle.jdbc.internal.JMSMessageProperties;
/*       */ import oracle.jdbc.internal.JMSNotificationRegistration;
/*       */ import oracle.jdbc.internal.JMSNotificationRegistration.Directive;
/*       */ import oracle.jdbc.internal.KeywordValueLong;
/*       */ import oracle.jdbc.internal.OracleConnection.BufferCacheStatistics;
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ import oracle.jdbc.internal.OracleConnection.EndReplayCallback;
/*       */ import oracle.jdbc.internal.OracleConnection.InstanceProperty;
/*       */ import oracle.jdbc.internal.OracleConnection.ReplayOperation;
/*       */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*       */ import oracle.jdbc.internal.OracleConnection.XSOperationCode;
/*       */ import oracle.jdbc.internal.OracleConnection.XSSessionModeFlag;
/*       */ import oracle.jdbc.internal.OracleConnection.XSSessionOperationCode;
/*       */ import oracle.jdbc.internal.OracleConnection.XSSessionSetOperationCode;
/*       */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*       */ import oracle.jdbc.internal.PDBChangeEventListener;
/*       */ import oracle.jdbc.internal.XSEventListener;
/*       */ import oracle.jdbc.internal.XSKeyval;
/*       */ import oracle.jdbc.internal.XSNamespace;
/*       */ import oracle.jdbc.internal.XSPrincipal;
/*       */ import oracle.jdbc.internal.XSSecureId;
/*       */ import oracle.jdbc.internal.XSSessionParameters;
/*       */ import oracle.jdbc.oracore.OracleTypeADT;
/*       */ import oracle.jdbc.oracore.OracleTypeCLOB;
/*       */ import oracle.jdbc.oracore.Util;
/*       */ import oracle.jdbc.pool.OracleConnectionCacheCallback;
/*       */ import oracle.jdbc.pool.OraclePooledConnection;
/*       */ import oracle.net.nt.CustomSSLSocketFactory;
/*       */ import oracle.security.pki.OracleSecretStore;
/*       */ import oracle.security.pki.OracleWallet;
/*       */ import oracle.sql.ARRAY;
/*       */ import oracle.sql.ArrayDescriptor;
/*       */ import oracle.sql.BFILE;
/*       */ import oracle.sql.BINARY_DOUBLE;
/*       */ import oracle.sql.BINARY_FLOAT;
/*       */ import oracle.sql.BLOB;
/*       */ import oracle.sql.BfileDBAccess;
/*       */ import oracle.sql.BlobDBAccess;
/*       */ import oracle.sql.CLOB;
/*       */ import oracle.sql.CharacterSet;
/*       */ import oracle.sql.ClobDBAccess;
/*       */ import oracle.sql.CustomDatum;
/*       */ import oracle.sql.DATE;
/*       */ import oracle.sql.Datum;
/*       */ import oracle.sql.INTERVALDS;
/*       */ import oracle.sql.INTERVALYM;
/*       */ import oracle.sql.NCLOB;
/*       */ import oracle.sql.NUMBER;
/*       */ import oracle.sql.SQLName;
/*       */ import oracle.sql.STRUCT;
/*       */ import oracle.sql.StructDescriptor;
/*       */ import oracle.sql.TIMESTAMP;
/*       */ import oracle.sql.TIMESTAMPLTZ;
/*       */ import oracle.sql.TIMESTAMPTZ;
/*       */ import oracle.sql.TIMEZONETAB;
/*       */ import oracle.sql.TypeDescriptor;
/*       */ import oracle.xdb.XMLType;
/*       */ 
/*       */ abstract class PhysicalConnection extends OracleConnection
/*       */ {
/*       */   public static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
/*       */   public static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
/*       */   public static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
/*       */   public static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
/*       */   public static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
/*   115 */   static final CRC64 CHECKSUM = new CRC64();
/*       */   public static final char slash_character = '/';
/*       */   public static final char at_sign_character = '@';
/*       */   public static final char left_square_bracket_character = '[';
/*       */   public static final char right_square_bracket_character = ']';
/*   120 */   static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
/*   121 */   static final char[] EMPTY_CHAR_ARRAY = new char[0];
/*       */   static final int STREAM_CHUNK_SIZE = 32768;
/*   137 */   long outScn = 0L;
/*       */ 
/*   139 */   char[][] charOutput = new char[1][];
/*   140 */   byte[][] byteOutput = new byte[1][];
/*   141 */   short[][] shortOutput = new short[1][];
/*       */ 
/*   147 */   Properties sessionProperties = null;
/*       */ 
/*   154 */   private static final String[] END_TO_END_CLIENTINFO_KEYS = { "OCSID.ACTION", "OCSID.CLIENTID", "OCSID.ECID", "OCSID.MODULE", "OCSID.DBOP" };
/*       */   private static final String END_TO_END_CLIENTINFO_KEY_SEQ_NO = "OCSID.SEQUENCE_NUMBER";
/*       */   boolean retainV9BindBehavior;
/*       */   String userName;
/*       */   String database;
/*       */   boolean defaultautocommit;
/*       */   String protocol;
/*       */   int streamChunkSize;
/*       */   boolean setFloatAndDoubleUseBinary;
/*       */   String ocidll;
/*       */   String thinVsessionTerminal;
/*       */   String thinVsessionMachine;
/*       */   String thinVsessionOsuser;
/*       */   String thinVsessionProgram;
/*       */   String thinVsessionProcess;
/*       */   String thinVsessionIname;
/*       */   String thinVsessionEname;
/*       */   String thinNetProfile;
/*       */   String thinNetAuthenticationServices;
/*       */   String thinNetAuthenticationKrb5Mutual;
/*       */   String thinNetAuthenticationKrb5CcName;
/*       */   String thinNetEncryptionLevel;
/*       */   String thinNetEncryptionTypes;
/*       */   String thinNetChecksumLevel;
/*       */   String thinNetChecksumTypes;
/*       */   String thinNetCryptoSeed;
/*       */   boolean thinTcpNoDelay;
/*       */   String thinReadTimeout;
/*       */   String thinNetConnectTimeout;
/*       */   boolean thinNetDisableOutOfBandBreak;
/*       */   boolean thinNetUseZeroCopyIO;
/*       */   boolean use1900AsYearForTime;
/*       */   boolean timestamptzInGmt;
/*       */   boolean timezoneAsRegion;
/*       */   String thinSslServerDnMatch;
/*       */   String thinSslVersion;
/*       */   String thinSslCipherSuites;
/*       */   String thinJavaxNetSslKeystore;
/*       */   String thinJavaxNetSslKeystoretype;
/*       */   String thinJavaxNetSslKeystorepassword;
/*       */   String thinJavaxNetSslTruststore;
/*       */   String thinJavaxNetSslTruststoretype;
/*       */   String thinJavaxNetSslTruststorepassword;
/*       */   String thinSslKeymanagerfactoryAlgorithm;
/*       */   String thinSslTrustmanagerfactoryAlgorithm;
/*       */   String thinNetOldsyntax;
/*       */   String thinNamingContextInitial;
/*       */   String thinNamingProviderUrl;
/*       */   String thinNamingSecurityAuthentication;
/*       */   String thinNamingSecurityPrincipal;
/*       */   String thinNamingSecurityCredentials;
/*       */   String thinJndiLdapConnectTimeout;
/*       */   String thinJndiLdapReadTimeout;
/*       */   String walletLocation;
/*       */   String walletPassword;
/*       */   String proxyClientName;
/*       */   boolean useNio;
/*       */   String ociDriverCharset;
/*       */   String editionName;
/*       */   String logonCap;
/*       */   boolean useOCIDefaultDefines;
/*       */   String internalLogon;
/*       */   boolean createDescriptorUseCurrentSchemaForSchemaName;
/*       */   long ociSvcCtxHandle;
/*       */   long ociEnvHandle;
/*       */   long ociErrHandle;
/*       */   boolean prelimAuth;
/*       */   boolean jmsNotificationConnection;
/*       */   boolean nlsLangBackdoor;
/*       */   String setNewPassword;
/*       */   boolean spawnNewThreadToCancel;
/*       */   int defaultExecuteBatch;
/*       */   int defaultRowPrefetch;
/*       */   int defaultLobPrefetchSize;
/*       */   boolean enableDataInLocator;
/*       */   boolean enableReadDataInLocator;
/*       */   boolean overrideEnableReadDataInLocator;
/*       */   boolean reportRemarks;
/*       */   boolean includeSynonyms;
/*       */   boolean restrictGettables;
/*       */   boolean accumulateBatchResult;
/*       */   boolean useFetchSizeWithLongColumn;
/*       */   boolean processEscapes;
/*       */   boolean fixedString;
/*       */   boolean defaultnchar;
/*       */   boolean permitTimestampDateMismatch;
/*       */   String resourceManagerId;
/*       */   boolean disableDefinecolumntype;
/*       */   boolean convertNcharLiterals;
/*       */   boolean autoCommitSpecCompliant;
/*       */   boolean j2ee13Compliant;
/*       */   boolean mapDateToTimestamp;
/*       */   boolean useThreadLocalBufferCache;
/*       */   String driverNameAttribute;
/*       */   int maxCachedBufferSize;
/*       */   int implicitStatementCacheSize;
/*       */   boolean lobStreamPosStandardCompliant;
/*       */   boolean isStrictAsciiConversion;
/*       */   String drcpConnectionClass;
/*       */   String drcpTagName;
/*       */   String blockSourceImpl;
/*       */   boolean thinForceDnsLoadBalancing;
/*       */   boolean enableTempLobRefCnt;
/*       */   boolean keepAlive;
/*       */   String sqlTranslationProfile;
/*       */   String sqlErrorTranslationFile;
/*       */   boolean ignoreReplayContextFromAuthentication;
/*       */   boolean javaNetNio;
/*       */   boolean nsDirectBuffer;
/*       */   boolean plsqlVarcharParameter4KOnly;
/*       */   String targetInstanceName;
/*       */   boolean enableOCIFAN;
/*       */   public OracleConnection.ChecksumMode checksumMode;
/*       */   boolean isPDBChanged;
/*       */   boolean autocommit;
/*       */   String url;
/*       */   String savedUser;
/*       */   int commitOption;
/*   288 */   int ociConnectionPoolMinLimit = 0;
/*   289 */   int ociConnectionPoolMaxLimit = 0;
/*   290 */   int ociConnectionPoolIncrement = 0;
/*   291 */   int ociConnectionPoolTimeout = 0;
/*   292 */   boolean ociConnectionPoolNoWait = false;
/*   293 */   boolean ociConnectionPoolTransactionDistributed = false;
/*   294 */   String ociConnectionPoolLogonMode = null;
/*   295 */   boolean ociConnectionPoolIsPooling = false;
/*   296 */   Object ociConnectionPoolObject = null;
/*   297 */   Object ociConnectionPoolConnID = null;
/*   298 */   String ociConnectionPoolProxyType = null;
/*   299 */   Integer ociConnectionPoolProxyNumRoles = Integer.valueOf(0);
/*   300 */   Object ociConnectionPoolProxyRoles = null;
/*   301 */   String ociConnectionPoolProxyUserName = null;
/*   302 */   String ociConnectionPoolProxyPassword = null;
/*   303 */   String ociConnectionPoolProxyDistinguishedName = null;
/*   304 */   Object ociConnectionPoolProxyCertificate = null;
/*       */ 
/*   306 */   static NTFManager ntfManager = new NTFManager();
/*       */ 
/*   317 */   public int protocolId = -3;
/*       */   OracleTimeout timeout;
/*       */   DBConversion conversion;
/*       */   boolean xaWantsError;
/*       */   boolean usingXA;
/*   342 */   int txnMode = 0;
/*       */   byte[] fdo;
/*       */   Boolean bigEndian;
/*       */   OracleStatement statements;
/*       */   int lifecycle;
/*       */   static final int OPEN = 1;
/*       */   static final int CLOSING = 2;
/*       */   static final int CLOSED = 4;
/*       */   static final int ABORTED = 8;
/*       */   static final int BLOCKED = 16;
/*   391 */   boolean clientIdSet = false;
/*   392 */   String clientId = null;
/*       */   int txnLevel;
/*       */   Map map;
/*       */   Map javaObjectMap;
/*   408 */   final Hashtable[] descriptorCacheStack = new Hashtable[2];
/*       */ 
/*   410 */   int dci = 0;
/*       */   OracleStatement statementHoldingLine;
/*   422 */   oracle.jdbc.OracleDatabaseMetaData databaseMetaData = null;
/*       */   LogicalConnection logicalConnectionAttached;
/*   432 */   boolean isProxy = false;
/*       */ 
/*   437 */   OracleSql sqlObj = null;
/*       */ 
/*   440 */   SQLWarning sqlWarning = null;
/*       */ 
/*   443 */   boolean readOnly = false;
/*       */ 
/*   448 */   LRUStatementCache statementCache = null;
/*       */ 
/*   451 */   boolean clearStatementMetaData = false;
/*       */ 
/*   457 */   OracleCloseCallback closeCallback = null;
/*   458 */   Object privateData = null;
/*       */ 
/*   461 */   Statement savepointStatement = null;
/*       */ 
/*   464 */   boolean isUsable = true;
/*       */ 
/*   466 */   TimeZone defaultTimeZone = null;
/*       */   static final int END_TO_END_DBOP_INDEX = 4;
/*       */   static final int END_TO_END_STATE_INDEX_MAX_POST_1200 = 5;
/*   500 */   final int[] endToEndMaxLength = new int[5];
/*       */ 
/*   502 */   boolean endToEndAnyChanged = false;
/*   503 */   final boolean[] endToEndHasChanged = new boolean[5];
/*   504 */   short endToEndECIDSequenceNumber = -32768;
/*       */   static final int DMS_NONE = 0;
/*       */   static final int DMS_10G = 1;
/*       */   static final int DMS_11 = 2;
/*   514 */   String[] endToEndValues = new String[5];
/*   515 */   final int whichDMS = 0;
/*       */ 
/*   519 */   oracle.jdbc.OracleConnection wrapper = null;
/*       */   int minVcsBindSize;
/*       */   int maxRawBytesSql;
/*       */   int maxRawBytesPlsql;
/*       */   int maxVcsCharsSql;
/*       */   int maxVcsNCharsSql;
/*       */   int maxVcsBytesPlsql;
/*       */   int maxVcsBytesPlsqlOut;
/*       */   int maxIbtVarcharElementLength;
/*       */   int maxVarcharLength;
/*       */   int maxNVarcharLength;
/*       */   int maxRawLength;
/*   591 */   String instanceName = null;
/*   592 */   String dbName = null;
/*       */   OracleDriverExtension driverExtension;
/*       */   static final String uninitializedMarker = "";
/*   595 */   String databaseProductVersion = "";
/*   596 */   short versionNumber = -1;
/*       */   int namedTypeAccessorByteLen;
/*       */   int refTypeAccessorByteLen;
/*       */   CharacterSet setCHARCharSetObj;
/*       */   CharacterSet setCHARNCharSetObj;
/*       */   protected final Object cancelInProgressLockForThin;
/*   607 */   boolean plsqlCompilerWarnings = false;
/*       */   private boolean savedAutoCommitFlag;
/*       */   private int savedTxnMode;
/*       */   private BlockSource blockSource;
/*   628 */   int thinACLastLtxidHash = 0;
/*       */   LogicalTransactionId thinACCurrentLTXID;
/*   642 */   ReplayContext[] thinACReplayContextReceived = new ReplayContext[10];
/*   643 */   int thinACReplayContextReceivedCurrent = 0;
/*       */ 
/*   645 */   ReplayContext thinACLastReplayContextReceived = null;
/*       */ 
/*   648 */   DrcpState drcpState = DrcpState.STATELESS;
/*   649 */   boolean currentlyInTransaction = false;
/*   650 */   boolean drcpEnabled = false;
/*       */ 
/*  2854 */   private static final Pattern driverNameAttributePattern = Pattern.compile("[\\x20-\\x7e]{0,8}");
/*       */   static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";
/*  4761 */   private static final OracleSQLPermission CALL_ORACLE_ABORT_PERMISSION = new OracleSQLPermission("callAbort");
/*       */   static final String DATABASE_NAME = "DATABASE_NAME";
/*       */   static final String SERVER_HOST = "SERVER_HOST";
/*       */   static final String INSTANCE_NAME = "INSTANCE_NAME";
/*       */   static final String SERVICE_NAME = "SERVICE_NAME";
/*       */   Hashtable clientData;
/*       */   private BufferCacheStore connectionBufferCacheStore;
/*       */   private static ThreadLocal<BufferCacheStore> threadLocalBufferCacheStore;
/*       */   private int pingResult;
/*  9259 */   String sessionTimeZone = null;
/*  9260 */   String databaseTimeZone = null;
/*  9261 */   Calendar dbTzCalendar = null;
/*       */   static final String SETCLIENTINFO_PERMISSION_NAME = "clientInfo.";
/* 11503 */   static final List<String> RESERVED_NAMESPACES = Arrays.asList(new String[] { "SYS" });
/*       */ 
/* 11509 */   static final Pattern SUPPORTED_NAME_PATTERN = Pattern.compile("\\w+\\.\\w+");
/*       */ 
/* 11515 */   protected final Properties clientInfo = new Properties();
/*       */ 
/* 11595 */   private short lastEndToEndSequenceNumber = -1;
/*       */   static final String RAW_STR = "RAW";
/*       */   static final String SYS_RAW_STR = "SYS.RAW";
/*       */   static final String SYS_ANYDATA_STR = "SYS.ANYDATA";
/*       */   static final String SYS_XMLTYPE_STR = "SYS.XMLTYPE";
/* 13555 */   int timeZoneVersionNumber = -1;
/* 13556 */   TIMEZONETAB timeZoneTab = null;
/*       */ 
/* 13877 */   int varTypeMaxLenCompat = 0;
/*       */ 
/* 13916 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   protected BlockSource setBlockSource()
/*       */   {
/*   652 */     return BlockSource.createBlockSource(this.useThreadLocalBufferCache, BlockSource.Implementation.THREADED);
/*       */   }
/*       */ 
/*       */   protected PhysicalConnection()
/*       */   {
/*   665 */     this.cancelInProgressLockForThin = new Object();
/*       */   }
/*       */ 
/*       */   PhysicalConnection(String paramString, Properties paramProperties, OracleDriverExtension paramOracleDriverExtension)
/*       */     throws SQLException
/*       */   {
/*   685 */     this.cancelInProgressLockForThin = new Object();
/*       */ 
/*   687 */     readConnectionProperties(paramString, paramProperties);
/*       */ 
/*   693 */     this.driverExtension = paramOracleDriverExtension;
/*       */ 
/*   695 */     this.blockSource = setBlockSource();
/*       */ 
/*   697 */     initialize(null, null, null);
/*   698 */     additionalInitialization();
/*   699 */     this.logicalConnectionAttached = null;
/*       */     try
/*       */     {
/*   703 */       needLine();
/*       */ 
/*   705 */       if ((this.drcpConnectionClass != null) && (this.url.matches("(?i)(.*\\(SERVER=POOLED\\).*)|(.*:POOLED)")))
/*       */       {
/*   707 */         this.drcpConnectionClass = this.drcpConnectionClass.trim();
/*   708 */         this.drcpEnabled = (this.drcpConnectionClass.length() > 0);
/*       */       }
/*       */ 
/*   711 */       logon();
/*   712 */       if (this.drcpEnabled) {
/*   713 */         this.drcpState = DrcpState.STATEFUL;
/*       */       }
/*       */ 
/*   716 */       setAutoCommit(this.autocommit);
/*       */ 
/*   718 */       int i = getVersionNumber();
/*   719 */       if (i >= 12100)
/*       */       {
/*   721 */         this.endToEndMaxLength[4] = 64;
/*       */       }
/*       */ 
/*   724 */       if (i >= 11202)
/*       */       {
/*   727 */         this.endToEndMaxLength[0] = 64;
/*   728 */         this.endToEndMaxLength[1] = 64;
/*   729 */         this.endToEndMaxLength[2] = 64;
/*   730 */         this.endToEndMaxLength[3] = 64;
/*       */       }
/*   732 */       else if (i >= 11000)
/*       */       {
/*   735 */         this.endToEndMaxLength[0] = 32;
/*   736 */         this.endToEndMaxLength[1] = 64;
/*   737 */         this.endToEndMaxLength[2] = 64;
/*   738 */         this.endToEndMaxLength[3] = 48;
/*       */       }
/*   740 */       else if (i >= 10000)
/*       */       {
/*   743 */         this.endToEndMaxLength[0] = 32;
/*   744 */         this.endToEndMaxLength[1] = 64;
/*   745 */         this.endToEndMaxLength[2] = 64;
/*   746 */         this.endToEndMaxLength[3] = 48;
/*       */       }
/*       */       else
/*       */       {
/*   751 */         this.endToEndMaxLength[0] = 32;
/*   752 */         this.endToEndMaxLength[1] = 64;
/*   753 */         this.endToEndMaxLength[2] = 64;
/*   754 */         this.endToEndMaxLength[3] = 48;
/*       */       }
/*       */ 
/*   757 */       if (((i >= 12000 ? 1 : 0) & (this.varTypeMaxLenCompat == 2 ? 1 : 0)) != 0)
/*       */       {
/*   760 */         this.minVcsBindSize = 32766;
/*   761 */         this.maxRawBytesSql = 32766;
/*   762 */         this.maxRawBytesPlsql = 32766;
/*   763 */         this.maxVcsCharsSql = 32766;
/*   764 */         this.maxVcsNCharsSql = 32766;
/*   765 */         this.maxVcsBytesPlsql = 32766;
/*   766 */         this.maxVcsBytesPlsqlOut = 32767;
/*   767 */         this.maxIbtVarcharElementLength = 32766;
/*   768 */         this.maxVarcharLength = 32767;
/*   769 */         this.maxNVarcharLength = 32766;
/*   770 */         this.maxRawLength = 32767;
/*       */       }
/*   772 */       else if (i >= 11202)
/*       */       {
/*   774 */         this.minVcsBindSize = 4001;
/*   775 */         this.maxRawBytesSql = 4000;
/*   776 */         this.maxRawBytesPlsql = 32766;
/*   777 */         this.maxVcsCharsSql = 32766;
/*   778 */         this.maxVcsNCharsSql = 32766;
/*   779 */         this.maxVcsBytesPlsql = 32766;
/*   780 */         this.maxVcsBytesPlsqlOut = 32767;
/*   781 */         this.maxIbtVarcharElementLength = 32766;
/*   782 */         this.maxVarcharLength = 4000;
/*   783 */         this.maxNVarcharLength = 4000;
/*   784 */         this.maxRawLength = 2000;
/*       */       }
/*   786 */       else if (i >= 11000)
/*       */       {
/*   788 */         this.minVcsBindSize = 4001;
/*   789 */         this.maxRawBytesSql = 4000;
/*   790 */         this.maxRawBytesPlsql = 32766;
/*   791 */         this.maxVcsCharsSql = 32766;
/*   792 */         this.maxVcsNCharsSql = 32766;
/*   793 */         this.maxVcsBytesPlsql = 32766;
/*   794 */         this.maxVcsBytesPlsqlOut = 32767;
/*   795 */         this.maxIbtVarcharElementLength = 32766;
/*   796 */         this.maxVarcharLength = 4000;
/*   797 */         this.maxNVarcharLength = 4000;
/*   798 */         this.maxRawLength = 2000;
/*       */       }
/*   800 */       else if (i >= 10000)
/*       */       {
/*   802 */         this.minVcsBindSize = 4001;
/*   803 */         this.maxRawBytesSql = 4000;
/*   804 */         this.maxRawBytesPlsql = 32512;
/*   805 */         this.maxVcsCharsSql = 32766;
/*   806 */         this.maxVcsNCharsSql = 32766;
/*   807 */         this.maxVcsBytesPlsql = 32512;
/*   808 */         this.maxVcsBytesPlsqlOut = 32512;
/*   809 */         this.maxIbtVarcharElementLength = 32766;
/*   810 */         this.maxVarcharLength = 4000;
/*   811 */         this.maxNVarcharLength = 4000;
/*   812 */         this.maxRawLength = 2000;
/*       */       }
/*       */ 
/*   818 */       initializeSetCHARCharSetObjs();
/*       */ 
/*   821 */       if (this.implicitStatementCacheSize > 0) {
/*   822 */         setStatementCacheSize(this.implicitStatementCacheSize);
/*   823 */         setImplicitCachingEnabled(true);
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (SQLException localSQLException1)
/*       */     {
/*   835 */       this.lifecycle = 2;
/*       */       try
/*       */       {
/*   838 */         logoff();
/*       */       } catch (SQLException localSQLException2) {
/*       */       }
/*   841 */       this.lifecycle = 4;
/*       */ 
/*   843 */       throw localSQLException1;
/*       */     }
/*       */ 
/*   847 */     this.txnMode = 0;
/*       */   }
/*       */ 
/*       */   int getMaxSizeForVarchar(OracleStatement.SqlKind paramSqlKind, int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*   857 */     int i = 0;
/*   858 */     if (paramSqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
/*   859 */       if (paramInt > 0) {
/*   860 */         i = Math.max(this.maxVcsBytesPlsql, paramInt);
/*       */       }
/*   862 */       else if (paramBoolean) {
/*   863 */         i = 4000;
/*       */       }
/*       */       else {
/*   866 */         i = this.maxVcsBytesPlsqlOut;
/*       */       }
/*       */     }
/*       */     else {
/*   870 */       i = this.maxVarcharLength;
/*       */     }
/*   872 */     return i;
/*       */   }
/*       */ 
/*       */   void additionalInitialization()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   private static final String propertyVariableName(String paramString)
/*       */   {
/*   887 */     char[] arrayOfChar = new char[paramString.length()];
/*   888 */     paramString.getChars(0, paramString.length(), arrayOfChar, 0);
/*   889 */     String str = "";
/*   890 */     for (int i = 0; i < arrayOfChar.length; i++)
/*       */     {
/*   892 */       if (Character.isUpperCase(arrayOfChar[i]))
/*   893 */         str = str + "_";
/*   894 */       str = str + Character.toUpperCase(arrayOfChar[i]);
/*       */     }
/*   896 */     return str;
/*       */   }
/*       */ 
/*       */   private void initializeUserDefaults(Properties paramProperties)
/*       */   {
/*   909 */     for (String str : OracleDriver.DEFAULT_CONNECTION_PROPERTIES.stringPropertyNames())
/*   910 */       if (!paramProperties.containsKey(str))
/*   911 */         paramProperties.setProperty(str, OracleDriver.DEFAULT_CONNECTION_PROPERTIES.getProperty(str));
/*       */   }
/*       */ 
/*       */   private void readConnectionProperties(String paramString, Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*   938 */     initializeUserDefaults(paramProperties);
/*       */ 
/*   943 */     String str1 = null;
/*       */ 
/*   946 */     str1 = null;
/*   947 */     if (paramProperties != null)
/*       */     {
/*   949 */       str1 = paramProperties.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
/*       */     }
/*   951 */     if (str1 == null)
/*   952 */       str1 = getSystemProperty("oracle.jdbc.RetainV9LongBindBehavior", null);
/*   953 */     if (str1 == null) {
/*   954 */       str1 = "false";
/*       */     }
/*       */ 
/*   957 */     this.retainV9BindBehavior = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*   960 */     str1 = null;
/*   961 */     if (paramProperties != null)
/*       */     {
/*   963 */       str1 = paramProperties.getProperty("user");
/*   964 */       if (str1 == null)
/*   965 */         str1 = paramProperties.getProperty("oracle.jdbc.user");
/*       */     }
/*   967 */     if (str1 == null)
/*   968 */       str1 = getSystemProperty("oracle.jdbc.user", null);
/*   969 */     if (str1 == null) {
/*   970 */       str1 = null;
/*       */     }
/*       */ 
/*   973 */     this.userName = str1;
/*       */ 
/*   976 */     str1 = null;
/*   977 */     if (paramProperties != null)
/*       */     {
/*   979 */       str1 = paramProperties.getProperty("database");
/*   980 */       if (str1 == null)
/*   981 */         str1 = paramProperties.getProperty("oracle.jdbc.database");
/*       */     }
/*   983 */     if (str1 == null)
/*   984 */       str1 = getSystemProperty("oracle.jdbc.database", null);
/*   985 */     if (str1 == null) {
/*   986 */       str1 = null;
/*       */     }
/*       */ 
/*   989 */     this.database = str1;
/*       */ 
/*   992 */     str1 = null;
/*   993 */     if (paramProperties != null)
/*       */     {
/*   995 */       str1 = paramProperties.getProperty("autoCommit");
/*   996 */       if (str1 == null)
/*   997 */         str1 = paramProperties.getProperty("oracle.jdbc.autoCommit");
/*       */     }
/*   999 */     if (str1 == null)
/*  1000 */       str1 = getSystemProperty("oracle.jdbc.autoCommit", null);
/*  1001 */     if (str1 == null) {
/*  1002 */       str1 = "true";
/*       */     }
/*       */ 
/*  1005 */     this.defaultautocommit = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1008 */     str1 = null;
/*  1009 */     if (paramProperties != null)
/*       */     {
/*  1011 */       str1 = paramProperties.getProperty("protocol");
/*  1012 */       if (str1 == null)
/*  1013 */         str1 = paramProperties.getProperty("oracle.jdbc.protocol");
/*       */     }
/*  1015 */     if (str1 == null)
/*  1016 */       str1 = getSystemProperty("oracle.jdbc.protocol", null);
/*  1017 */     if (str1 == null) {
/*  1018 */       str1 = null;
/*       */     }
/*       */ 
/*  1021 */     this.protocol = str1;
/*       */ 
/*  1024 */     str1 = null;
/*  1025 */     if (paramProperties != null)
/*       */     {
/*  1027 */       str1 = paramProperties.getProperty("oracle.jdbc.StreamChunkSize");
/*       */     }
/*  1029 */     if (str1 == null)
/*  1030 */       str1 = getSystemProperty("oracle.jdbc.StreamChunkSize", null);
/*  1031 */     if (str1 == null)
/*  1032 */       str1 = "32767";
/*       */     try
/*       */     {
/*  1035 */       this.streamChunkSize = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException1)
/*       */     {
/*  1040 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'streamChunkSize'");
/*  1041 */       ((SQLException)localObject2).fillInStackTrace();
/*  1042 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  1048 */     str1 = null;
/*  1049 */     if (paramProperties != null)
/*       */     {
/*  1051 */       str1 = paramProperties.getProperty("SetFloatAndDoubleUseBinary");
/*  1052 */       if (str1 == null)
/*  1053 */         str1 = paramProperties.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
/*       */     }
/*  1055 */     if (str1 == null)
/*  1056 */       str1 = getSystemProperty("oracle.jdbc.SetFloatAndDoubleUseBinary", null);
/*  1057 */     if (str1 == null) {
/*  1058 */       str1 = "false";
/*       */     }
/*       */ 
/*  1061 */     this.setFloatAndDoubleUseBinary = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1064 */     str1 = null;
/*  1065 */     if (paramProperties != null)
/*       */     {
/*  1067 */       str1 = paramProperties.getProperty("oracle.jdbc.ocinativelibrary");
/*       */     }
/*  1069 */     if (str1 == null)
/*  1070 */       str1 = getSystemProperty("oracle.jdbc.ocinativelibrary", null);
/*  1071 */     if (str1 == null) {
/*  1072 */       str1 = null;
/*       */     }
/*       */ 
/*  1075 */     this.ocidll = str1;
/*       */ 
/*  1078 */     str1 = null;
/*  1079 */     if (paramProperties != null)
/*       */     {
/*  1081 */       str1 = paramProperties.getProperty("v$session.terminal");
/*  1082 */       if (str1 == null)
/*  1083 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.terminal");
/*       */     }
/*  1085 */     if (str1 == null)
/*  1086 */       str1 = getSystemProperty("oracle.jdbc.v$session.terminal", null);
/*  1087 */     if (str1 == null) {
/*  1088 */       str1 = "unknown";
/*       */     }
/*       */ 
/*  1091 */     this.thinVsessionTerminal = str1;
/*       */ 
/*  1094 */     str1 = null;
/*  1095 */     if (paramProperties != null)
/*       */     {
/*  1097 */       str1 = paramProperties.getProperty("v$session.machine");
/*  1098 */       if (str1 == null)
/*  1099 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.machine");
/*       */     }
/*  1101 */     if (str1 == null)
/*  1102 */       str1 = getSystemProperty("oracle.jdbc.v$session.machine", null);
/*  1103 */     if (str1 == null) {
/*  1104 */       str1 = null;
/*       */     }
/*       */ 
/*  1107 */     this.thinVsessionMachine = str1;
/*       */ 
/*  1110 */     str1 = null;
/*  1111 */     if (paramProperties != null)
/*       */     {
/*  1113 */       str1 = paramProperties.getProperty("v$session.osuser");
/*  1114 */       if (str1 == null)
/*  1115 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.osuser");
/*       */     }
/*  1117 */     if (str1 == null)
/*  1118 */       str1 = getSystemProperty("oracle.jdbc.v$session.osuser", null);
/*  1119 */     if (str1 == null) {
/*  1120 */       str1 = null;
/*       */     }
/*       */ 
/*  1123 */     this.thinVsessionOsuser = str1;
/*       */ 
/*  1126 */     str1 = null;
/*  1127 */     if (paramProperties != null)
/*       */     {
/*  1129 */       str1 = paramProperties.getProperty("v$session.program");
/*  1130 */       if (str1 == null)
/*  1131 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.program");
/*       */     }
/*  1133 */     if (str1 == null)
/*  1134 */       str1 = getSystemProperty("oracle.jdbc.v$session.program", null);
/*  1135 */     if (str1 == null) {
/*  1136 */       str1 = "JDBC Thin Client";
/*       */     }
/*       */ 
/*  1139 */     this.thinVsessionProgram = str1;
/*       */ 
/*  1142 */     str1 = null;
/*  1143 */     if (paramProperties != null)
/*       */     {
/*  1145 */       str1 = paramProperties.getProperty("v$session.process");
/*  1146 */       if (str1 == null)
/*  1147 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.process");
/*       */     }
/*  1149 */     if (str1 == null)
/*  1150 */       str1 = getSystemProperty("oracle.jdbc.v$session.process", null);
/*  1151 */     if (str1 == null) {
/*  1152 */       str1 = "1234";
/*       */     }
/*       */ 
/*  1155 */     this.thinVsessionProcess = str1;
/*       */ 
/*  1158 */     str1 = null;
/*  1159 */     if (paramProperties != null)
/*       */     {
/*  1161 */       str1 = paramProperties.getProperty("v$session.iname");
/*  1162 */       if (str1 == null)
/*  1163 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.iname");
/*       */     }
/*  1165 */     if (str1 == null)
/*  1166 */       str1 = getSystemProperty("oracle.jdbc.v$session.iname", null);
/*  1167 */     if (str1 == null) {
/*  1168 */       str1 = "jdbc_ttc_impl";
/*       */     }
/*       */ 
/*  1171 */     this.thinVsessionIname = str1;
/*       */ 
/*  1174 */     str1 = null;
/*  1175 */     if (paramProperties != null)
/*       */     {
/*  1177 */       str1 = paramProperties.getProperty("v$session.ename");
/*  1178 */       if (str1 == null)
/*  1179 */         str1 = paramProperties.getProperty("oracle.jdbc.v$session.ename");
/*       */     }
/*  1181 */     if (str1 == null)
/*  1182 */       str1 = getSystemProperty("oracle.jdbc.v$session.ename", null);
/*  1183 */     if (str1 == null) {
/*  1184 */       str1 = null;
/*       */     }
/*       */ 
/*  1187 */     this.thinVsessionEname = str1;
/*       */ 
/*  1190 */     str1 = null;
/*  1191 */     if (paramProperties != null)
/*       */     {
/*  1193 */       str1 = paramProperties.getProperty("oracle.net.profile");
/*       */     }
/*  1195 */     if (str1 == null)
/*  1196 */       str1 = getSystemProperty("oracle.net.profile", null);
/*  1197 */     if (str1 == null) {
/*  1198 */       str1 = null;
/*       */     }
/*       */ 
/*  1201 */     this.thinNetProfile = str1;
/*       */ 
/*  1204 */     str1 = null;
/*  1205 */     if (paramProperties != null)
/*       */     {
/*  1207 */       str1 = paramProperties.getProperty("oracle.net.authentication_services");
/*       */     }
/*  1209 */     if (str1 == null)
/*  1210 */       str1 = getSystemProperty("oracle.net.authentication_services", null);
/*  1211 */     if (str1 == null) {
/*  1212 */       str1 = null;
/*       */     }
/*       */ 
/*  1215 */     this.thinNetAuthenticationServices = str1;
/*       */ 
/*  1218 */     str1 = null;
/*  1219 */     if (paramProperties != null)
/*       */     {
/*  1221 */       str1 = paramProperties.getProperty("oracle.net.kerberos5_mutual_authentication");
/*       */     }
/*  1223 */     if (str1 == null)
/*  1224 */       str1 = getSystemProperty("oracle.net.kerberos5_mutual_authentication", null);
/*  1225 */     if (str1 == null) {
/*  1226 */       str1 = null;
/*       */     }
/*       */ 
/*  1229 */     this.thinNetAuthenticationKrb5Mutual = str1;
/*       */ 
/*  1232 */     str1 = null;
/*  1233 */     if (paramProperties != null)
/*       */     {
/*  1235 */       str1 = paramProperties.getProperty("oracle.net.kerberos5_cc_name");
/*       */     }
/*  1237 */     if (str1 == null)
/*  1238 */       str1 = getSystemProperty("oracle.net.kerberos5_cc_name", null);
/*  1239 */     if (str1 == null) {
/*  1240 */       str1 = null;
/*       */     }
/*       */ 
/*  1243 */     this.thinNetAuthenticationKrb5CcName = str1;
/*       */ 
/*  1246 */     str1 = null;
/*  1247 */     if (paramProperties != null)
/*       */     {
/*  1249 */       str1 = paramProperties.getProperty("oracle.net.encryption_client");
/*       */     }
/*  1251 */     if (str1 == null)
/*  1252 */       str1 = getSystemProperty("oracle.net.encryption_client", null);
/*  1253 */     if (str1 == null) {
/*  1254 */       str1 = null;
/*       */     }
/*       */ 
/*  1257 */     this.thinNetEncryptionLevel = str1;
/*       */ 
/*  1260 */     str1 = null;
/*  1261 */     if (paramProperties != null)
/*       */     {
/*  1263 */       str1 = paramProperties.getProperty("oracle.net.encryption_types_client");
/*       */     }
/*  1265 */     if (str1 == null)
/*  1266 */       str1 = getSystemProperty("oracle.net.encryption_types_client", null);
/*  1267 */     if (str1 == null) {
/*  1268 */       str1 = null;
/*       */     }
/*       */ 
/*  1271 */     this.thinNetEncryptionTypes = str1;
/*       */ 
/*  1274 */     str1 = null;
/*  1275 */     if (paramProperties != null)
/*       */     {
/*  1277 */       str1 = paramProperties.getProperty("oracle.net.crypto_checksum_client");
/*       */     }
/*  1279 */     if (str1 == null)
/*  1280 */       str1 = getSystemProperty("oracle.net.crypto_checksum_client", null);
/*  1281 */     if (str1 == null) {
/*  1282 */       str1 = null;
/*       */     }
/*       */ 
/*  1285 */     this.thinNetChecksumLevel = str1;
/*       */ 
/*  1288 */     str1 = null;
/*  1289 */     if (paramProperties != null)
/*       */     {
/*  1291 */       str1 = paramProperties.getProperty("oracle.net.crypto_checksum_types_client");
/*       */     }
/*  1293 */     if (str1 == null)
/*  1294 */       str1 = getSystemProperty("oracle.net.crypto_checksum_types_client", null);
/*  1295 */     if (str1 == null) {
/*  1296 */       str1 = null;
/*       */     }
/*       */ 
/*  1299 */     this.thinNetChecksumTypes = str1;
/*       */ 
/*  1302 */     str1 = null;
/*  1303 */     if (paramProperties != null)
/*       */     {
/*  1305 */       str1 = paramProperties.getProperty("oracle.net.crypto_seed");
/*       */     }
/*  1307 */     if (str1 == null)
/*  1308 */       str1 = getSystemProperty("oracle.net.crypto_seed", null);
/*  1309 */     if (str1 == null) {
/*  1310 */       str1 = null;
/*       */     }
/*       */ 
/*  1313 */     this.thinNetCryptoSeed = str1;
/*       */ 
/*  1316 */     str1 = null;
/*  1317 */     if (paramProperties != null)
/*       */     {
/*  1319 */       str1 = paramProperties.getProperty("oracle.jdbc.TcpNoDelay");
/*       */     }
/*  1321 */     if (str1 == null)
/*  1322 */       str1 = getSystemProperty("oracle.jdbc.TcpNoDelay", null);
/*  1323 */     if (str1 == null) {
/*  1324 */       str1 = "false";
/*       */     }
/*       */ 
/*  1327 */     this.thinTcpNoDelay = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1330 */     str1 = null;
/*  1331 */     if (paramProperties != null)
/*       */     {
/*  1333 */       str1 = paramProperties.getProperty("oracle.jdbc.ReadTimeout");
/*       */     }
/*  1335 */     if (str1 == null)
/*  1336 */       str1 = getSystemProperty("oracle.jdbc.ReadTimeout", null);
/*  1337 */     if (str1 == null) {
/*  1338 */       str1 = null;
/*       */     }
/*       */ 
/*  1341 */     this.thinReadTimeout = str1;
/*       */ 
/*  1344 */     str1 = null;
/*  1345 */     if (paramProperties != null)
/*       */     {
/*  1347 */       str1 = paramProperties.getProperty("oracle.net.CONNECT_TIMEOUT");
/*       */     }
/*  1349 */     if (str1 == null)
/*  1350 */       str1 = getSystemProperty("oracle.net.CONNECT_TIMEOUT", null);
/*  1351 */     if (str1 == null) {
/*  1352 */       str1 = null;
/*       */     }
/*       */ 
/*  1355 */     this.thinNetConnectTimeout = str1;
/*       */ 
/*  1358 */     str1 = null;
/*  1359 */     if (paramProperties != null)
/*       */     {
/*  1361 */       str1 = paramProperties.getProperty("oracle.net.disableOob");
/*       */     }
/*  1363 */     if (str1 == null)
/*  1364 */       str1 = getSystemProperty("oracle.net.disableOob", null);
/*  1365 */     if (str1 == null) {
/*  1366 */       str1 = "false";
/*       */     }
/*       */ 
/*  1369 */     this.thinNetDisableOutOfBandBreak = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1372 */     str1 = null;
/*  1373 */     if (paramProperties != null)
/*       */     {
/*  1375 */       str1 = paramProperties.getProperty("oracle.net.useZeroCopyIO");
/*       */     }
/*  1377 */     if (str1 == null)
/*  1378 */       str1 = getSystemProperty("oracle.net.useZeroCopyIO", null);
/*  1379 */     if (str1 == null) {
/*  1380 */       str1 = "true";
/*       */     }
/*       */ 
/*  1383 */     this.thinNetUseZeroCopyIO = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1386 */     str1 = null;
/*  1387 */     if (paramProperties != null)
/*       */     {
/*  1389 */       str1 = paramProperties.getProperty("oracle.jdbc.use1900AsYearForTime");
/*       */     }
/*  1391 */     if (str1 == null)
/*  1392 */       str1 = getSystemProperty("oracle.jdbc.use1900AsYearForTime", null);
/*  1393 */     if (str1 == null) {
/*  1394 */       str1 = "false";
/*       */     }
/*       */ 
/*  1397 */     this.use1900AsYearForTime = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1400 */     str1 = null;
/*  1401 */     if (paramProperties != null)
/*       */     {
/*  1403 */       str1 = paramProperties.getProperty("oracle.jdbc.timestampTzInGmt");
/*       */     }
/*  1405 */     if (str1 == null)
/*  1406 */       str1 = getSystemProperty("oracle.jdbc.timestampTzInGmt", null);
/*  1407 */     if (str1 == null) {
/*  1408 */       str1 = "true";
/*       */     }
/*       */ 
/*  1411 */     this.timestamptzInGmt = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1414 */     str1 = null;
/*  1415 */     if (paramProperties != null)
/*       */     {
/*  1417 */       str1 = paramProperties.getProperty("oracle.jdbc.timezoneAsRegion");
/*       */     }
/*  1419 */     if (str1 == null)
/*  1420 */       str1 = getSystemProperty("oracle.jdbc.timezoneAsRegion", null);
/*  1421 */     if (str1 == null) {
/*  1422 */       str1 = "true";
/*       */     }
/*       */ 
/*  1425 */     this.timezoneAsRegion = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1428 */     str1 = null;
/*  1429 */     if (paramProperties != null)
/*       */     {
/*  1431 */       str1 = paramProperties.getProperty("oracle.net.ssl_server_dn_match");
/*       */     }
/*  1433 */     if (str1 == null)
/*  1434 */       str1 = getSystemProperty("oracle.net.ssl_server_dn_match", null);
/*  1435 */     if (str1 == null) {
/*  1436 */       str1 = null;
/*       */     }
/*       */ 
/*  1439 */     this.thinSslServerDnMatch = str1;
/*       */ 
/*  1442 */     str1 = null;
/*  1443 */     if (paramProperties != null)
/*       */     {
/*  1445 */       str1 = paramProperties.getProperty("oracle.net.ssl_version");
/*       */     }
/*  1447 */     if (str1 == null)
/*  1448 */       str1 = getSystemProperty("oracle.net.ssl_version", null);
/*  1449 */     if (str1 == null) {
/*  1450 */       str1 = null;
/*       */     }
/*       */ 
/*  1453 */     this.thinSslVersion = str1;
/*       */ 
/*  1456 */     str1 = null;
/*  1457 */     if (paramProperties != null)
/*       */     {
/*  1459 */       str1 = paramProperties.getProperty("oracle.net.ssl_cipher_suites");
/*       */     }
/*  1461 */     if (str1 == null)
/*  1462 */       str1 = getSystemProperty("oracle.net.ssl_cipher_suites", null);
/*  1463 */     if (str1 == null) {
/*  1464 */       str1 = null;
/*       */     }
/*       */ 
/*  1467 */     this.thinSslCipherSuites = str1;
/*       */ 
/*  1470 */     str1 = null;
/*  1471 */     if (paramProperties != null)
/*       */     {
/*  1473 */       str1 = paramProperties.getProperty("javax.net.ssl.keyStore");
/*       */     }
/*  1475 */     if (str1 == null)
/*  1476 */       str1 = getSystemProperty("javax.net.ssl.keyStore", null);
/*  1477 */     if (str1 == null) {
/*  1478 */       str1 = null;
/*       */     }
/*       */ 
/*  1481 */     this.thinJavaxNetSslKeystore = str1;
/*       */ 
/*  1484 */     str1 = null;
/*  1485 */     if (paramProperties != null)
/*       */     {
/*  1487 */       str1 = paramProperties.getProperty("javax.net.ssl.keyStoreType");
/*       */     }
/*  1489 */     if (str1 == null)
/*  1490 */       str1 = getSystemProperty("javax.net.ssl.keyStoreType", null);
/*  1491 */     if (str1 == null) {
/*  1492 */       str1 = null;
/*       */     }
/*       */ 
/*  1495 */     this.thinJavaxNetSslKeystoretype = str1;
/*       */ 
/*  1498 */     str1 = null;
/*  1499 */     if (paramProperties != null)
/*       */     {
/*  1501 */       str1 = paramProperties.getProperty("javax.net.ssl.keyStorePassword");
/*       */     }
/*  1503 */     if (str1 == null)
/*  1504 */       str1 = getSystemProperty("javax.net.ssl.keyStorePassword", null);
/*  1505 */     if (str1 == null) {
/*  1506 */       str1 = null;
/*       */     }
/*       */ 
/*  1509 */     this.thinJavaxNetSslKeystorepassword = str1;
/*       */ 
/*  1512 */     str1 = null;
/*  1513 */     if (paramProperties != null)
/*       */     {
/*  1515 */       str1 = paramProperties.getProperty("javax.net.ssl.trustStore");
/*       */     }
/*  1517 */     if (str1 == null)
/*  1518 */       str1 = getSystemProperty("javax.net.ssl.trustStore", null);
/*  1519 */     if (str1 == null) {
/*  1520 */       str1 = null;
/*       */     }
/*       */ 
/*  1523 */     this.thinJavaxNetSslTruststore = str1;
/*       */ 
/*  1526 */     str1 = null;
/*  1527 */     if (paramProperties != null)
/*       */     {
/*  1529 */       str1 = paramProperties.getProperty("javax.net.ssl.trustStoreType");
/*       */     }
/*  1531 */     if (str1 == null)
/*  1532 */       str1 = getSystemProperty("javax.net.ssl.trustStoreType", null);
/*  1533 */     if (str1 == null) {
/*  1534 */       str1 = null;
/*       */     }
/*       */ 
/*  1537 */     this.thinJavaxNetSslTruststoretype = str1;
/*       */ 
/*  1540 */     str1 = null;
/*  1541 */     if (paramProperties != null)
/*       */     {
/*  1543 */       str1 = paramProperties.getProperty("javax.net.ssl.trustStorePassword");
/*       */     }
/*  1545 */     if (str1 == null)
/*  1546 */       str1 = getSystemProperty("javax.net.ssl.trustStorePassword", null);
/*  1547 */     if (str1 == null) {
/*  1548 */       str1 = null;
/*       */     }
/*       */ 
/*  1551 */     this.thinJavaxNetSslTruststorepassword = str1;
/*       */ 
/*  1554 */     str1 = null;
/*  1555 */     if (paramProperties != null)
/*       */     {
/*  1557 */       str1 = paramProperties.getProperty("ssl.keyManagerFactory.algorithm");
/*  1558 */       if (str1 == null)
/*  1559 */         str1 = paramProperties.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
/*       */     }
/*  1561 */     if (str1 == null)
/*  1562 */       str1 = getSystemProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm", null);
/*  1563 */     if (str1 == null) {
/*  1564 */       str1 = null;
/*       */     }
/*       */ 
/*  1567 */     this.thinSslKeymanagerfactoryAlgorithm = str1;
/*       */ 
/*  1570 */     str1 = null;
/*  1571 */     if (paramProperties != null)
/*       */     {
/*  1573 */       str1 = paramProperties.getProperty("ssl.trustManagerFactory.algorithm");
/*  1574 */       if (str1 == null)
/*  1575 */         str1 = paramProperties.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
/*       */     }
/*  1577 */     if (str1 == null)
/*  1578 */       str1 = getSystemProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm", null);
/*  1579 */     if (str1 == null) {
/*  1580 */       str1 = null;
/*       */     }
/*       */ 
/*  1583 */     this.thinSslTrustmanagerfactoryAlgorithm = str1;
/*       */ 
/*  1586 */     str1 = null;
/*  1587 */     if (paramProperties != null)
/*       */     {
/*  1589 */       str1 = paramProperties.getProperty("oracle.net.oldSyntax");
/*       */     }
/*  1591 */     if (str1 == null)
/*  1592 */       str1 = getSystemProperty("oracle.net.oldSyntax", null);
/*  1593 */     if (str1 == null) {
/*  1594 */       str1 = null;
/*       */     }
/*       */ 
/*  1597 */     this.thinNetOldsyntax = str1;
/*       */ 
/*  1600 */     str1 = null;
/*  1601 */     if (paramProperties != null)
/*       */     {
/*  1603 */       str1 = paramProperties.getProperty("java.naming.factory.initial");
/*       */     }
/*  1605 */     if (str1 == null) {
/*  1606 */       str1 = null;
/*       */     }
/*       */ 
/*  1609 */     this.thinNamingContextInitial = str1;
/*       */ 
/*  1612 */     str1 = null;
/*  1613 */     if (paramProperties != null)
/*       */     {
/*  1615 */       str1 = paramProperties.getProperty("java.naming.provider.url");
/*       */     }
/*  1617 */     if (str1 == null) {
/*  1618 */       str1 = null;
/*       */     }
/*       */ 
/*  1621 */     this.thinNamingProviderUrl = str1;
/*       */ 
/*  1624 */     str1 = null;
/*  1625 */     if (paramProperties != null)
/*       */     {
/*  1627 */       str1 = paramProperties.getProperty("java.naming.security.authentication");
/*       */     }
/*  1629 */     if (str1 == null) {
/*  1630 */       str1 = null;
/*       */     }
/*       */ 
/*  1633 */     this.thinNamingSecurityAuthentication = str1;
/*       */ 
/*  1636 */     str1 = null;
/*  1637 */     if (paramProperties != null)
/*       */     {
/*  1639 */       str1 = paramProperties.getProperty("java.naming.security.principal");
/*       */     }
/*  1641 */     if (str1 == null) {
/*  1642 */       str1 = null;
/*       */     }
/*       */ 
/*  1645 */     this.thinNamingSecurityPrincipal = str1;
/*       */ 
/*  1648 */     str1 = null;
/*  1649 */     if (paramProperties != null)
/*       */     {
/*  1651 */       str1 = paramProperties.getProperty("java.naming.security.credentials");
/*       */     }
/*  1653 */     if (str1 == null) {
/*  1654 */       str1 = null;
/*       */     }
/*       */ 
/*  1657 */     this.thinNamingSecurityCredentials = str1;
/*       */ 
/*  1660 */     str1 = null;
/*  1661 */     if (paramProperties != null)
/*       */     {
/*  1663 */       str1 = paramProperties.getProperty("com.sun.jndi.ldap.connect.timeout");
/*  1664 */       if (str1 == null)
/*  1665 */         str1 = paramProperties.getProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout");
/*       */     }
/*  1667 */     if (str1 == null)
/*  1668 */       str1 = getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout", null);
/*  1669 */     if (str1 == null) {
/*  1670 */       str1 = null;
/*       */     }
/*       */ 
/*  1673 */     this.thinJndiLdapConnectTimeout = str1;
/*       */ 
/*  1676 */     str1 = null;
/*  1677 */     if (paramProperties != null)
/*       */     {
/*  1679 */       str1 = paramProperties.getProperty("com.sun.jndi.ldap.read.timeout");
/*  1680 */       if (str1 == null)
/*  1681 */         str1 = paramProperties.getProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout");
/*       */     }
/*  1683 */     if (str1 == null)
/*  1684 */       str1 = getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout", null);
/*  1685 */     if (str1 == null) {
/*  1686 */       str1 = null;
/*       */     }
/*       */ 
/*  1689 */     this.thinJndiLdapReadTimeout = str1;
/*       */ 
/*  1692 */     str1 = null;
/*  1693 */     if (paramProperties != null)
/*       */     {
/*  1695 */       str1 = paramProperties.getProperty("oracle.net.wallet_location");
/*       */     }
/*  1697 */     if (str1 == null)
/*  1698 */       str1 = getSystemProperty("oracle.net.wallet_location", null);
/*  1699 */     if (str1 == null) {
/*  1700 */       str1 = null;
/*       */     }
/*       */ 
/*  1703 */     this.walletLocation = str1;
/*       */ 
/*  1706 */     str1 = null;
/*  1707 */     if (paramProperties != null)
/*       */     {
/*  1709 */       str1 = paramProperties.getProperty("oracle.net.wallet_password");
/*       */     }
/*  1711 */     if (str1 == null)
/*  1712 */       str1 = getSystemProperty("oracle.net.wallet_password", null);
/*  1713 */     if (str1 == null) {
/*  1714 */       str1 = null;
/*       */     }
/*       */ 
/*  1717 */     this.walletPassword = str1;
/*       */ 
/*  1720 */     str1 = null;
/*  1721 */     if (paramProperties != null)
/*       */     {
/*  1723 */       str1 = paramProperties.getProperty("oracle.jdbc.proxyClientName");
/*       */     }
/*  1725 */     if (str1 == null)
/*  1726 */       str1 = getSystemProperty("oracle.jdbc.proxyClientName", null);
/*  1727 */     if (str1 == null) {
/*  1728 */       str1 = null;
/*       */     }
/*       */ 
/*  1731 */     this.proxyClientName = str1;
/*       */ 
/*  1734 */     str1 = null;
/*  1735 */     if (paramProperties != null)
/*       */     {
/*  1737 */       str1 = paramProperties.getProperty("oracle.jdbc.useNio");
/*       */     }
/*  1739 */     if (str1 == null)
/*  1740 */       str1 = getSystemProperty("oracle.jdbc.useNio", null);
/*  1741 */     if (str1 == null) {
/*  1742 */       str1 = "false";
/*       */     }
/*       */ 
/*  1745 */     this.useNio = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1748 */     str1 = null;
/*  1749 */     if (paramProperties != null)
/*       */     {
/*  1751 */       str1 = paramProperties.getProperty("JDBCDriverCharSetId");
/*  1752 */       if (str1 == null)
/*  1753 */         str1 = paramProperties.getProperty("oracle.jdbc.JDBCDriverCharSetId");
/*       */     }
/*  1755 */     if (str1 == null)
/*  1756 */       str1 = getSystemProperty("oracle.jdbc.JDBCDriverCharSetId", null);
/*  1757 */     if (str1 == null) {
/*  1758 */       str1 = null;
/*       */     }
/*       */ 
/*  1761 */     this.ociDriverCharset = str1;
/*       */ 
/*  1764 */     str1 = null;
/*  1765 */     if (paramProperties != null)
/*       */     {
/*  1767 */       str1 = paramProperties.getProperty("oracle.jdbc.editionName");
/*       */     }
/*  1769 */     if (str1 == null)
/*  1770 */       str1 = getSystemProperty("oracle.jdbc.editionName", null);
/*  1771 */     if (str1 == null) {
/*  1772 */       str1 = null;
/*       */     }
/*       */ 
/*  1775 */     this.editionName = str1;
/*       */ 
/*  1778 */     str1 = null;
/*  1779 */     if (paramProperties != null)
/*       */     {
/*  1781 */       str1 = paramProperties.getProperty("oracle.jdbc.thinLogonCapability");
/*       */     }
/*  1783 */     if (str1 == null)
/*  1784 */       str1 = getSystemProperty("oracle.jdbc.thinLogonCapability", null);
/*  1785 */     if (str1 == null) {
/*  1786 */       str1 = "o5";
/*       */     }
/*       */ 
/*  1789 */     this.logonCap = str1;
/*       */ 
/*  1792 */     str1 = null;
/*  1793 */     if (paramProperties != null)
/*       */     {
/*  1795 */       str1 = paramProperties.getProperty("oracle.jdbc.useOCIDefaultDefines");
/*       */     }
/*  1797 */     if (str1 == null)
/*  1798 */       str1 = getSystemProperty("oracle.jdbc.useOCIDefaultDefines", null);
/*  1799 */     if (str1 == null) {
/*  1800 */       str1 = "false";
/*       */     }
/*       */ 
/*  1803 */     this.useOCIDefaultDefines = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1806 */     str1 = null;
/*  1807 */     if (paramProperties != null)
/*       */     {
/*  1809 */       str1 = paramProperties.getProperty("internal_logon");
/*  1810 */       if (str1 == null)
/*  1811 */         str1 = paramProperties.getProperty("oracle.jdbc.internal_logon");
/*       */     }
/*  1813 */     if (str1 == null)
/*  1814 */       str1 = getSystemProperty("oracle.jdbc.internal_logon", null);
/*  1815 */     if (str1 == null) {
/*  1816 */       str1 = null;
/*       */     }
/*       */ 
/*  1819 */     this.internalLogon = str1;
/*       */ 
/*  1822 */     str1 = null;
/*  1823 */     if (paramProperties != null)
/*       */     {
/*  1825 */       str1 = paramProperties.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
/*       */     }
/*  1827 */     if (str1 == null)
/*  1828 */       str1 = getSystemProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName", null);
/*  1829 */     if (str1 == null) {
/*  1830 */       str1 = "false";
/*       */     }
/*       */ 
/*  1833 */     this.createDescriptorUseCurrentSchemaForSchemaName = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1836 */     str1 = null;
/*  1837 */     if (paramProperties != null)
/*       */     {
/*  1839 */       str1 = paramProperties.getProperty("OCISvcCtxHandle");
/*  1840 */       if (str1 == null)
/*  1841 */         str1 = paramProperties.getProperty("oracle.jdbc.OCISvcCtxHandle");
/*       */     }
/*  1843 */     if (str1 == null)
/*  1844 */       str1 = getSystemProperty("oracle.jdbc.OCISvcCtxHandle", null);
/*  1845 */     if (str1 == null)
/*  1846 */       str1 = "0";
/*       */     try
/*       */     {
/*  1849 */       this.ociSvcCtxHandle = Long.parseLong(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException2)
/*       */     {
/*  1854 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'ociSvcCtxHandle'");
/*  1855 */       ((SQLException)localObject2).fillInStackTrace();
/*  1856 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  1862 */     str1 = null;
/*  1863 */     if (paramProperties != null)
/*       */     {
/*  1865 */       str1 = paramProperties.getProperty("OCIEnvHandle");
/*  1866 */       if (str1 == null)
/*  1867 */         str1 = paramProperties.getProperty("oracle.jdbc.OCIEnvHandle");
/*       */     }
/*  1869 */     if (str1 == null)
/*  1870 */       str1 = getSystemProperty("oracle.jdbc.OCIEnvHandle", null);
/*  1871 */     if (str1 == null)
/*  1872 */       str1 = "0";
/*       */     try
/*       */     {
/*  1875 */       this.ociEnvHandle = Long.parseLong(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException3)
/*       */     {
/*  1880 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'ociEnvHandle'");
/*  1881 */       ((SQLException)localObject2).fillInStackTrace();
/*  1882 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  1888 */     str1 = null;
/*  1889 */     if (paramProperties != null)
/*       */     {
/*  1891 */       str1 = paramProperties.getProperty("OCIErrHandle");
/*  1892 */       if (str1 == null)
/*  1893 */         str1 = paramProperties.getProperty("oracle.jdbc.OCIErrHandle");
/*       */     }
/*  1895 */     if (str1 == null)
/*  1896 */       str1 = getSystemProperty("oracle.jdbc.OCIErrHandle", null);
/*  1897 */     if (str1 == null)
/*  1898 */       str1 = "0";
/*       */     try
/*       */     {
/*  1901 */       this.ociErrHandle = Long.parseLong(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException4)
/*       */     {
/*  1906 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'ociErrHandle'");
/*  1907 */       ((SQLException)localObject2).fillInStackTrace();
/*  1908 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  1914 */     str1 = null;
/*  1915 */     if (paramProperties != null)
/*       */     {
/*  1917 */       str1 = paramProperties.getProperty("prelim_auth");
/*  1918 */       if (str1 == null)
/*  1919 */         str1 = paramProperties.getProperty("oracle.jdbc.prelim_auth");
/*       */     }
/*  1921 */     if (str1 == null)
/*  1922 */       str1 = getSystemProperty("oracle.jdbc.prelim_auth", null);
/*  1923 */     if (str1 == null) {
/*  1924 */       str1 = "false";
/*       */     }
/*       */ 
/*  1927 */     this.prelimAuth = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1930 */     str1 = null;
/*  1931 */     if (paramProperties != null)
/*       */     {
/*  1933 */       str1 = paramProperties.getProperty("oracle.jdbc.jmsNotification");
/*       */     }
/*  1935 */     if (str1 == null)
/*  1936 */       str1 = getSystemProperty("oracle.jdbc.jmsNotification", null);
/*  1937 */     if (str1 == null) {
/*  1938 */       str1 = "false";
/*       */     }
/*       */ 
/*  1941 */     this.jmsNotificationConnection = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1944 */     str1 = null;
/*  1945 */     if (paramProperties != null)
/*       */     {
/*  1947 */       str1 = paramProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
/*       */     }
/*  1949 */     if (str1 == null)
/*  1950 */       str1 = getSystemProperty("oracle.jdbc.ociNlsLangBackwardCompatible", null);
/*  1951 */     if (str1 == null) {
/*  1952 */       str1 = "false";
/*       */     }
/*       */ 
/*  1955 */     this.nlsLangBackdoor = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1958 */     str1 = null;
/*  1959 */     if (paramProperties != null)
/*       */     {
/*  1961 */       str1 = paramProperties.getProperty("OCINewPassword");
/*  1962 */       if (str1 == null)
/*  1963 */         str1 = paramProperties.getProperty("oracle.jdbc.OCINewPassword");
/*       */     }
/*  1965 */     if (str1 == null)
/*  1966 */       str1 = getSystemProperty("oracle.jdbc.OCINewPassword", null);
/*  1967 */     if (str1 == null) {
/*  1968 */       str1 = null;
/*       */     }
/*       */ 
/*  1971 */     this.setNewPassword = str1;
/*       */ 
/*  1974 */     str1 = null;
/*  1975 */     if (paramProperties != null)
/*       */     {
/*  1977 */       str1 = paramProperties.getProperty("oracle.jdbc.spawnNewThreadToCancel");
/*       */     }
/*  1979 */     if (str1 == null)
/*  1980 */       str1 = getSystemProperty("oracle.jdbc.spawnNewThreadToCancel", null);
/*  1981 */     if (str1 == null) {
/*  1982 */       str1 = "false";
/*       */     }
/*       */ 
/*  1985 */     this.spawnNewThreadToCancel = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  1988 */     str1 = null;
/*  1989 */     if (paramProperties != null)
/*       */     {
/*  1991 */       str1 = paramProperties.getProperty("defaultExecuteBatch");
/*  1992 */       if (str1 == null)
/*  1993 */         str1 = paramProperties.getProperty("oracle.jdbc.defaultExecuteBatch");
/*       */     }
/*  1995 */     if (str1 == null)
/*  1996 */       str1 = getSystemProperty("oracle.jdbc.defaultExecuteBatch", null);
/*  1997 */     if (str1 == null)
/*  1998 */       str1 = "1";
/*       */     try
/*       */     {
/*  2001 */       this.defaultExecuteBatch = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException5)
/*       */     {
/*  2006 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'defaultExecuteBatch'");
/*  2007 */       ((SQLException)localObject2).fillInStackTrace();
/*  2008 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  2014 */     str1 = null;
/*  2015 */     if (paramProperties != null)
/*       */     {
/*  2017 */       str1 = paramProperties.getProperty("defaultRowPrefetch");
/*  2018 */       if (str1 == null)
/*  2019 */         str1 = paramProperties.getProperty("oracle.jdbc.defaultRowPrefetch");
/*       */     }
/*  2021 */     if (str1 == null)
/*  2022 */       str1 = getSystemProperty("oracle.jdbc.defaultRowPrefetch", null);
/*  2023 */     if (str1 == null)
/*  2024 */       str1 = "10";
/*       */     try
/*       */     {
/*  2027 */       this.defaultRowPrefetch = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException6)
/*       */     {
/*  2032 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'defaultRowPrefetch'");
/*  2033 */       ((SQLException)localObject2).fillInStackTrace();
/*  2034 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  2040 */     str1 = null;
/*  2041 */     if (paramProperties != null)
/*       */     {
/*  2043 */       str1 = paramProperties.getProperty("oracle.jdbc.defaultLobPrefetchSize");
/*       */     }
/*  2045 */     if (str1 == null)
/*  2046 */       str1 = getSystemProperty("oracle.jdbc.defaultLobPrefetchSize", null);
/*  2047 */     if (str1 == null)
/*  2048 */       str1 = "4000";
/*       */     try
/*       */     {
/*  2051 */       this.defaultLobPrefetchSize = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException7)
/*       */     {
/*  2056 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'defaultLobPrefetchSize'");
/*  2057 */       ((SQLException)localObject2).fillInStackTrace();
/*  2058 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  2064 */     str1 = null;
/*  2065 */     if (paramProperties != null)
/*       */     {
/*  2067 */       str1 = paramProperties.getProperty("oracle.jdbc.enableDataInLocator");
/*       */     }
/*  2069 */     if (str1 == null)
/*  2070 */       str1 = getSystemProperty("oracle.jdbc.enableDataInLocator", null);
/*  2071 */     if (str1 == null) {
/*  2072 */       str1 = "true";
/*       */     }
/*       */ 
/*  2075 */     this.enableDataInLocator = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2078 */     str1 = null;
/*  2079 */     if (paramProperties != null)
/*       */     {
/*  2081 */       str1 = paramProperties.getProperty("oracle.jdbc.enableReadDataInLocator");
/*       */     }
/*  2083 */     if (str1 == null)
/*  2084 */       str1 = getSystemProperty("oracle.jdbc.enableReadDataInLocator", null);
/*  2085 */     if (str1 == null) {
/*  2086 */       str1 = "true";
/*       */     }
/*       */ 
/*  2089 */     this.enableReadDataInLocator = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2092 */     str1 = null;
/*  2093 */     if (paramProperties != null)
/*       */     {
/*  2095 */       str1 = paramProperties.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
/*       */     }
/*  2097 */     if (str1 == null)
/*  2098 */       str1 = getSystemProperty("oracle.jdbc.overrideEnableReadDataInLocator", null);
/*  2099 */     if (str1 == null) {
/*  2100 */       str1 = "false";
/*       */     }
/*       */ 
/*  2103 */     this.overrideEnableReadDataInLocator = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2106 */     str1 = null;
/*  2107 */     if (paramProperties != null)
/*       */     {
/*  2109 */       str1 = paramProperties.getProperty("remarksReporting");
/*  2110 */       if (str1 == null)
/*  2111 */         str1 = paramProperties.getProperty("oracle.jdbc.remarksReporting");
/*       */     }
/*  2113 */     if (str1 == null)
/*  2114 */       str1 = getSystemProperty("oracle.jdbc.remarksReporting", null);
/*  2115 */     if (str1 == null) {
/*  2116 */       str1 = "false";
/*       */     }
/*       */ 
/*  2119 */     this.reportRemarks = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2122 */     str1 = null;
/*  2123 */     if (paramProperties != null)
/*       */     {
/*  2125 */       str1 = paramProperties.getProperty("includeSynonyms");
/*  2126 */       if (str1 == null)
/*  2127 */         str1 = paramProperties.getProperty("oracle.jdbc.includeSynonyms");
/*       */     }
/*  2129 */     if (str1 == null)
/*  2130 */       str1 = getSystemProperty("oracle.jdbc.includeSynonyms", null);
/*  2131 */     if (str1 == null) {
/*  2132 */       str1 = "false";
/*       */     }
/*       */ 
/*  2135 */     this.includeSynonyms = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2138 */     str1 = null;
/*  2139 */     if (paramProperties != null)
/*       */     {
/*  2141 */       str1 = paramProperties.getProperty("restrictGetTables");
/*  2142 */       if (str1 == null)
/*  2143 */         str1 = paramProperties.getProperty("oracle.jdbc.restrictGetTables");
/*       */     }
/*  2145 */     if (str1 == null)
/*  2146 */       str1 = getSystemProperty("oracle.jdbc.restrictGetTables", null);
/*  2147 */     if (str1 == null) {
/*  2148 */       str1 = "false";
/*       */     }
/*       */ 
/*  2151 */     this.restrictGettables = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2154 */     str1 = null;
/*  2155 */     if (paramProperties != null)
/*       */     {
/*  2157 */       str1 = paramProperties.getProperty("AccumulateBatchResult");
/*  2158 */       if (str1 == null)
/*  2159 */         str1 = paramProperties.getProperty("oracle.jdbc.AccumulateBatchResult");
/*       */     }
/*  2161 */     if (str1 == null)
/*  2162 */       str1 = getSystemProperty("oracle.jdbc.AccumulateBatchResult", null);
/*  2163 */     if (str1 == null) {
/*  2164 */       str1 = "true";
/*       */     }
/*       */ 
/*  2167 */     this.accumulateBatchResult = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2170 */     str1 = null;
/*  2171 */     if (paramProperties != null)
/*       */     {
/*  2173 */       str1 = paramProperties.getProperty("useFetchSizeWithLongColumn");
/*  2174 */       if (str1 == null)
/*  2175 */         str1 = paramProperties.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
/*       */     }
/*  2177 */     if (str1 == null)
/*  2178 */       str1 = getSystemProperty("oracle.jdbc.useFetchSizeWithLongColumn", null);
/*  2179 */     if (str1 == null) {
/*  2180 */       str1 = "false";
/*       */     }
/*       */ 
/*  2183 */     this.useFetchSizeWithLongColumn = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2186 */     str1 = null;
/*  2187 */     if (paramProperties != null)
/*       */     {
/*  2189 */       str1 = paramProperties.getProperty("processEscapes");
/*  2190 */       if (str1 == null)
/*  2191 */         str1 = paramProperties.getProperty("oracle.jdbc.processEscapes");
/*       */     }
/*  2193 */     if (str1 == null)
/*  2194 */       str1 = getSystemProperty("oracle.jdbc.processEscapes", null);
/*  2195 */     if (str1 == null) {
/*  2196 */       str1 = "true";
/*       */     }
/*       */ 
/*  2199 */     this.processEscapes = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2202 */     str1 = null;
/*  2203 */     if (paramProperties != null)
/*       */     {
/*  2205 */       str1 = paramProperties.getProperty("fixedString");
/*  2206 */       if (str1 == null)
/*  2207 */         str1 = paramProperties.getProperty("oracle.jdbc.fixedString");
/*       */     }
/*  2209 */     if (str1 == null)
/*  2210 */       str1 = getSystemProperty("oracle.jdbc.fixedString", null);
/*  2211 */     if (str1 == null) {
/*  2212 */       str1 = "false";
/*       */     }
/*       */ 
/*  2215 */     this.fixedString = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2218 */     str1 = null;
/*  2219 */     if (paramProperties != null)
/*       */     {
/*  2221 */       str1 = paramProperties.getProperty("defaultNChar");
/*  2222 */       if (str1 == null)
/*  2223 */         str1 = paramProperties.getProperty("oracle.jdbc.defaultNChar");
/*       */     }
/*  2225 */     if (str1 == null)
/*  2226 */       str1 = getSystemProperty("oracle.jdbc.defaultNChar", null);
/*  2227 */     if (str1 == null) {
/*  2228 */       str1 = "false";
/*       */     }
/*       */ 
/*  2231 */     this.defaultnchar = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2234 */     str1 = null;
/*  2235 */     if (paramProperties != null)
/*       */     {
/*  2237 */       str1 = paramProperties.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
/*       */     }
/*  2239 */     if (str1 == null)
/*  2240 */       str1 = getSystemProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch", null);
/*  2241 */     if (str1 == null) {
/*  2242 */       str1 = "false";
/*       */     }
/*       */ 
/*  2245 */     this.permitTimestampDateMismatch = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2248 */     str1 = null;
/*  2249 */     if (paramProperties != null)
/*       */     {
/*  2251 */       str1 = paramProperties.getProperty("RessourceManagerId");
/*  2252 */       if (str1 == null)
/*  2253 */         str1 = paramProperties.getProperty("oracle.jdbc.RessourceManagerId");
/*       */     }
/*  2255 */     if (str1 == null)
/*  2256 */       str1 = getSystemProperty("oracle.jdbc.RessourceManagerId", null);
/*  2257 */     if (str1 == null) {
/*  2258 */       str1 = "0000";
/*       */     }
/*       */ 
/*  2261 */     this.resourceManagerId = str1;
/*       */ 
/*  2264 */     str1 = null;
/*  2265 */     if (paramProperties != null)
/*       */     {
/*  2267 */       str1 = paramProperties.getProperty("disableDefineColumnType");
/*  2268 */       if (str1 == null)
/*  2269 */         str1 = paramProperties.getProperty("oracle.jdbc.disableDefineColumnType");
/*       */     }
/*  2271 */     if (str1 == null)
/*  2272 */       str1 = getSystemProperty("oracle.jdbc.disableDefineColumnType", null);
/*  2273 */     if (str1 == null) {
/*  2274 */       str1 = "false";
/*       */     }
/*       */ 
/*  2277 */     this.disableDefinecolumntype = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2280 */     str1 = null;
/*  2281 */     if (paramProperties != null)
/*       */     {
/*  2283 */       str1 = paramProperties.getProperty("oracle.jdbc.convertNcharLiterals");
/*       */     }
/*  2285 */     if (str1 == null)
/*  2286 */       str1 = getSystemProperty("oracle.jdbc.convertNcharLiterals", null);
/*  2287 */     if (str1 == null) {
/*  2288 */       str1 = "true";
/*       */     }
/*       */ 
/*  2291 */     this.convertNcharLiterals = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2294 */     str1 = null;
/*  2295 */     if (paramProperties != null)
/*       */     {
/*  2297 */       str1 = paramProperties.getProperty("oracle.jdbc.autoCommitSpecCompliant");
/*       */     }
/*  2299 */     if (str1 == null)
/*  2300 */       str1 = getSystemProperty("oracle.jdbc.autoCommitSpecCompliant", null);
/*  2301 */     if (str1 == null) {
/*  2302 */       str1 = "true";
/*       */     }
/*       */ 
/*  2305 */     this.autoCommitSpecCompliant = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2308 */     str1 = null;
/*  2309 */     if (paramProperties != null)
/*       */     {
/*  2311 */       str1 = paramProperties.getProperty("oracle.jdbc.J2EE13Compliant");
/*       */     }
/*  2313 */     if (str1 == null)
/*  2314 */       str1 = getSystemProperty("oracle.jdbc.J2EE13Compliant", null);
/*  2315 */     if (str1 == null) {
/*  2316 */       str1 = "false";
/*       */     }
/*       */ 
/*  2319 */     this.j2ee13Compliant = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2322 */     str1 = null;
/*  2323 */     if (paramProperties != null)
/*       */     {
/*  2325 */       str1 = paramProperties.getProperty("oracle.jdbc.mapDateToTimestamp");
/*       */     }
/*  2327 */     if (str1 == null)
/*  2328 */       str1 = getSystemProperty("oracle.jdbc.mapDateToTimestamp", null);
/*  2329 */     if (str1 == null) {
/*  2330 */       str1 = "true";
/*       */     }
/*       */ 
/*  2333 */     this.mapDateToTimestamp = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2336 */     str1 = null;
/*  2337 */     if (paramProperties != null)
/*       */     {
/*  2339 */       str1 = paramProperties.getProperty("oracle.jdbc.useThreadLocalBufferCache");
/*       */     }
/*  2341 */     if (str1 == null)
/*  2342 */       str1 = getSystemProperty("oracle.jdbc.useThreadLocalBufferCache", null);
/*  2343 */     if (str1 == null) {
/*  2344 */       str1 = "false";
/*       */     }
/*       */ 
/*  2347 */     this.useThreadLocalBufferCache = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2350 */     str1 = null;
/*  2351 */     if (paramProperties != null)
/*       */     {
/*  2353 */       str1 = paramProperties.getProperty("oracle.jdbc.driverNameAttribute");
/*       */     }
/*  2355 */     if (str1 == null)
/*  2356 */       str1 = getSystemProperty("oracle.jdbc.driverNameAttribute", null);
/*  2357 */     if (str1 == null) {
/*  2358 */       str1 = null;
/*       */     }
/*       */ 
/*  2361 */     this.driverNameAttribute = str1;
/*       */ 
/*  2364 */     str1 = null;
/*  2365 */     if (paramProperties != null)
/*       */     {
/*  2367 */       str1 = paramProperties.getProperty("oracle.jdbc.maxCachedBufferSize");
/*       */     }
/*  2369 */     if (str1 == null)
/*  2370 */       str1 = getSystemProperty("oracle.jdbc.maxCachedBufferSize", null);
/*  2371 */     if (str1 == null)
/*  2372 */       str1 = "30";
/*       */     try
/*       */     {
/*  2375 */       this.maxCachedBufferSize = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException8)
/*       */     {
/*  2380 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'maxCachedBufferSize'");
/*  2381 */       ((SQLException)localObject2).fillInStackTrace();
/*  2382 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  2388 */     str1 = null;
/*  2389 */     if (paramProperties != null)
/*       */     {
/*  2391 */       str1 = paramProperties.getProperty("oracle.jdbc.implicitStatementCacheSize");
/*       */     }
/*  2393 */     if (str1 == null)
/*  2394 */       str1 = getSystemProperty("oracle.jdbc.implicitStatementCacheSize", null);
/*  2395 */     if (str1 == null)
/*  2396 */       str1 = "0";
/*       */     try
/*       */     {
/*  2399 */       this.implicitStatementCacheSize = Integer.parseInt(str1);
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException9)
/*       */     {
/*  2404 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 190, "Property is 'implicitStatementCacheSize'");
/*  2405 */       ((SQLException)localObject2).fillInStackTrace();
/*  2406 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  2412 */     str1 = null;
/*  2413 */     if (paramProperties != null)
/*       */     {
/*  2415 */       str1 = paramProperties.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
/*       */     }
/*  2417 */     if (str1 == null)
/*  2418 */       str1 = getSystemProperty("oracle.jdbc.LobStreamPosStandardCompliant", null);
/*  2419 */     if (str1 == null) {
/*  2420 */       str1 = "false";
/*       */     }
/*       */ 
/*  2423 */     this.lobStreamPosStandardCompliant = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2426 */     str1 = null;
/*  2427 */     if (paramProperties != null)
/*       */     {
/*  2429 */       str1 = paramProperties.getProperty("oracle.jdbc.strictASCIIConversion");
/*       */     }
/*  2431 */     if (str1 == null)
/*  2432 */       str1 = getSystemProperty("oracle.jdbc.strictASCIIConversion", null);
/*  2433 */     if (str1 == null) {
/*  2434 */       str1 = "false";
/*       */     }
/*       */ 
/*  2437 */     this.isStrictAsciiConversion = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2440 */     str1 = null;
/*  2441 */     if (paramProperties != null)
/*       */     {
/*  2443 */       str1 = paramProperties.getProperty("oracle.jdbc.DRCPConnectionClass");
/*       */     }
/*  2445 */     if (str1 == null)
/*  2446 */       str1 = getSystemProperty("oracle.jdbc.DRCPConnectionClass", null);
/*  2447 */     if (str1 == null) {
/*  2448 */       str1 = null;
/*       */     }
/*       */ 
/*  2451 */     this.drcpConnectionClass = str1;
/*       */ 
/*  2454 */     str1 = null;
/*  2455 */     if (paramProperties != null)
/*       */     {
/*  2457 */       str1 = paramProperties.getProperty("oracle.jdbc.DRCPTagName");
/*       */     }
/*  2459 */     if (str1 == null) {
/*  2460 */       str1 = null;
/*       */     }
/*       */ 
/*  2463 */     this.drcpTagName = str1;
/*       */ 
/*  2466 */     str1 = null;
/*  2467 */     if (str1 == null)
/*  2468 */       str1 = getSystemProperty("oracle.jdbc.blockSourceImplementation", null);
/*  2469 */     if (str1 == null) {
/*  2470 */       str1 = "THREADED";
/*       */     }
/*       */ 
/*  2476 */     this.blockSourceImpl = str1;
/*       */ 
/*  2479 */     str1 = null;
/*  2480 */     if (paramProperties != null)
/*       */     {
/*  2482 */       str1 = paramProperties.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
/*       */     }
/*  2484 */     if (str1 == null)
/*  2485 */       str1 = getSystemProperty("oracle.jdbc.thinForceDNSLoadBalancing", null);
/*  2486 */     if (str1 == null) {
/*  2487 */       str1 = "false";
/*       */     }
/*       */ 
/*  2490 */     this.thinForceDnsLoadBalancing = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2493 */     str1 = null;
/*  2494 */     if (paramProperties != null)
/*       */     {
/*  2496 */       str1 = paramProperties.getProperty("oracle.jdbc.enableTempLobRefCnt");
/*       */     }
/*  2498 */     if (str1 == null)
/*  2499 */       str1 = getSystemProperty("oracle.jdbc.enableTempLobRefCnt", null);
/*  2500 */     if (str1 == null) {
/*  2501 */       str1 = "true";
/*       */     }
/*       */ 
/*  2504 */     this.enableTempLobRefCnt = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2507 */     str1 = null;
/*  2508 */     if (paramProperties != null)
/*       */     {
/*  2510 */       str1 = paramProperties.getProperty("oracle.net.keepAlive");
/*       */     }
/*  2512 */     if (str1 == null)
/*  2513 */       str1 = getSystemProperty("oracle.net.keepAlive", null);
/*  2514 */     if (str1 == null) {
/*  2515 */       str1 = "false";
/*       */     }
/*       */ 
/*  2518 */     this.keepAlive = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2521 */     str1 = null;
/*  2522 */     if (paramProperties != null)
/*       */     {
/*  2524 */       str1 = paramProperties.getProperty("oracle.jdbc.sqlTranslationProfile");
/*       */     }
/*  2526 */     if (str1 == null)
/*  2527 */       str1 = getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
/*  2528 */     if (str1 == null) {
/*  2529 */       str1 = null;
/*       */     }
/*       */ 
/*  2532 */     this.sqlTranslationProfile = str1;
/*       */ 
/*  2535 */     str1 = null;
/*  2536 */     if (paramProperties != null)
/*       */     {
/*  2538 */       str1 = paramProperties.getProperty("oracle.jdbc.sqlErrorTranslationFile");
/*       */     }
/*  2540 */     if (str1 == null)
/*  2541 */       str1 = getSystemProperty("oracle.jdbc.sqlErrorTranslationFile", null);
/*  2542 */     if (str1 == null) {
/*  2543 */       str1 = null;
/*       */     }
/*       */ 
/*  2546 */     this.sqlErrorTranslationFile = str1;
/*       */ 
/*  2549 */     str1 = null;
/*  2550 */     if (paramProperties != null)
/*       */     {
/*  2552 */       str1 = paramProperties.getProperty("oracle.jdbc.ignoreReplayContextFromAuthentication");
/*       */     }
/*  2554 */     if (str1 == null) {
/*  2555 */       str1 = "false";
/*       */     }
/*       */ 
/*  2558 */     this.ignoreReplayContextFromAuthentication = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2561 */     str1 = null;
/*  2562 */     if (paramProperties != null)
/*       */     {
/*  2564 */       str1 = paramProperties.getProperty("oracle.jdbc.javaNetNio");
/*       */     }
/*  2566 */     if (str1 == null)
/*  2567 */       str1 = getSystemProperty("oracle.jdbc.javaNetNio", null);
/*  2568 */     if (str1 == null) {
/*  2569 */       str1 = "false";
/*       */     }
/*       */ 
/*  2572 */     this.javaNetNio = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2575 */     str1 = null;
/*  2576 */     if (paramProperties != null)
/*       */     {
/*  2578 */       str1 = paramProperties.getProperty("oracle.jdbc.nsDirectBuffer");
/*       */     }
/*  2580 */     if (str1 == null)
/*  2581 */       str1 = getSystemProperty("oracle.jdbc.nsDirectBuffer", null);
/*  2582 */     if (str1 == null) {
/*  2583 */       str1 = "false";
/*       */     }
/*       */ 
/*  2586 */     this.nsDirectBuffer = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2589 */     str1 = null;
/*  2590 */     if (paramProperties != null)
/*       */     {
/*  2592 */       str1 = paramProperties.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
/*       */     }
/*  2594 */     if (str1 == null)
/*  2595 */       str1 = getSystemProperty("oracle.jdbc.plsqlVarcharParameter4KOnly", null);
/*  2596 */     if (str1 == null) {
/*  2597 */       str1 = "false";
/*       */     }
/*       */ 
/*  2600 */     this.plsqlVarcharParameter4KOnly = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2603 */     str1 = null;
/*  2604 */     if (paramProperties != null)
/*       */     {
/*  2606 */       str1 = paramProperties.getProperty("oracle.jdbc.targetInstanceName");
/*       */     }
/*  2608 */     if (str1 == null)
/*  2609 */       str1 = getSystemProperty("oracle.jdbc.targetInstanceName", null);
/*  2610 */     if (str1 == null) {
/*  2611 */       str1 = null;
/*       */     }
/*       */ 
/*  2614 */     this.targetInstanceName = str1;
/*       */ 
/*  2617 */     str1 = null;
/*  2618 */     if (paramProperties != null)
/*       */     {
/*  2620 */       str1 = paramProperties.getProperty("oracle.jdbc.enableOCIFastApplicationNotification");
/*       */     }
/*  2622 */     if (str1 == null)
/*  2623 */       str1 = getSystemProperty("oracle.jdbc.enableOCIFastApplicationNotification", null);
/*  2624 */     if (str1 == null) {
/*  2625 */       str1 = "false";
/*       */     }
/*       */ 
/*  2628 */     this.enableOCIFAN = ((str1 != null) && (str1.equalsIgnoreCase("true")));
/*       */ 
/*  2632 */     str1 = null;
/*  2633 */     if (paramProperties != null)
/*  2634 */       str1 = paramProperties.getProperty("oracle.jdbc.commitOption");
/*  2635 */     if (str1 == null)
/*  2636 */       str1 = getSystemProperty("oracle.jdbc.commitOption", null);
/*       */     Object localObject1;
/*       */     Object localObject3;
/*  2637 */     if (str1 != null)
/*       */     {
/*  2639 */       this.commitOption = 0;
/*  2640 */       localObject1 = str1.split(",");
/*  2641 */       if ((localObject1 != null) && (localObject1.length > 0))
/*       */       {
/*  2643 */         for (localObject3 : localObject1) {
/*  2644 */           if (((String)localObject3).trim() != "") {
/*  2645 */             this.commitOption |= OracleConnection.CommitOption.valueOf(((String)localObject3).trim()).getCode();
/*       */           }
/*       */         }
/*       */       }
/*       */     }
/*  2650 */     str1 = null;
/*  2651 */     if (paramProperties != null)
/*       */     {
/*  2653 */       str1 = paramProperties.getProperty("oracle.jdbc.calculateChecksum");
/*       */     }
/*  2655 */     if (str1 == null)
/*  2656 */       str1 = getSystemProperty("oracle.jdbc.calculateChecksum", null);
/*  2657 */     if (str1 == null) {
/*  2658 */       this.checksumMode = OracleConnection.ChecksumMode.NO_CHECKSUM;
/*       */     }
/*       */     else {
/*  2661 */       this.checksumMode = OracleConnection.ChecksumMode.valueOf(str1);
/*       */     }
/*       */ 
/*  2667 */     this.includeSynonyms = parseConnectionProperty_boolean(paramProperties, "synonyms", (byte)3, this.includeSynonyms);
/*       */ 
/*  2670 */     this.reportRemarks = parseConnectionProperty_boolean(paramProperties, "remarks", (byte)3, this.reportRemarks);
/*       */ 
/*  2673 */     this.defaultRowPrefetch = parseConnectionProperty_int(paramProperties, "prefetch", (byte)3, this.defaultRowPrefetch);
/*       */ 
/*  2676 */     this.defaultRowPrefetch = parseConnectionProperty_int(paramProperties, "rowPrefetch", (byte)3, this.defaultRowPrefetch);
/*       */ 
/*  2679 */     this.defaultExecuteBatch = parseConnectionProperty_int(paramProperties, "batch", (byte)3, this.defaultExecuteBatch);
/*       */ 
/*  2682 */     this.defaultExecuteBatch = parseConnectionProperty_int(paramProperties, "executeBatch", (byte)3, this.defaultExecuteBatch);
/*       */ 
/*  2685 */     this.proxyClientName = parseConnectionProperty_String(paramProperties, "PROXY_CLIENT_NAME", (byte)1, this.proxyClientName);
/*       */ 
/*  2691 */     if (this.defaultRowPrefetch <= 0) {
/*  2692 */       this.defaultRowPrefetch = Integer.parseInt("10");
/*       */     }
/*  2694 */     if (this.defaultExecuteBatch <= 0) {
/*  2695 */       this.defaultExecuteBatch = Integer.parseInt("1");
/*       */     }
/*  2697 */     if (this.defaultLobPrefetchSize < -1)
/*       */     {
/*  2699 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 267);
/*  2700 */       ((SQLException)localObject1).fillInStackTrace();
/*  2701 */       throw ((Throwable)localObject1);
/*       */     }
/*       */ 
/*  2705 */     if (this.thinVsessionOsuser == null)
/*       */     {
/*  2707 */       this.thinVsessionOsuser = getSystemProperty("user.name", null);
/*  2708 */       if (this.thinVsessionOsuser == null) {
/*  2709 */         this.thinVsessionOsuser = "jdbcuser";
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  2716 */     if (this.thinNetConnectTimeout == CONNECTION_PROPERTY_THIN_NET_CONNECT_TIMEOUT_DEFAULT)
/*       */     {
/*  2718 */       int i = DriverManager.getLoginTimeout();
/*  2719 */       if (i != 0) {
/*  2720 */         this.thinNetConnectTimeout = ("" + i * 1000);
/*       */       }
/*       */     }
/*       */ 
/*  2724 */     this.autocommit = this.defaultautocommit;
/*       */ 
/*  2728 */     this.url = paramString;
/*  2729 */     Hashtable localHashtable = parseUrl(this.url, this.walletLocation, this.walletPassword);
/*       */ 
/*  2731 */     if (this.userName == CONNECTION_PROPERTY_USER_NAME_DEFAULT)
/*  2732 */       this.userName = ((String)localHashtable.get("user"));
/*  2733 */     Object localObject2 = new String[1];
/*  2734 */     String[] arrayOfString = new String[1];
/*  2735 */     this.userName = parseLoginOption(this.userName, paramProperties, (String[])localObject2, arrayOfString);
/*  2736 */     if (localObject2[0] != null)
/*  2737 */       this.internalLogon = localObject2[0];
/*  2738 */     if (arrayOfString[0] != null) {
/*  2739 */       this.proxyClientName = arrayOfString[0];
/*       */     }
/*  2741 */     String str2 = paramProperties.getProperty("password", CONNECTION_PROPERTY_PASSWORD_DEFAULT);
/*       */ 
/*  2743 */     if (str2 == CONNECTION_PROPERTY_PASSWORD_DEFAULT)
/*  2744 */       str2 = (String)localHashtable.get("password");
/*  2745 */     initializePassword(str2);
/*       */ 
/*  2747 */     if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
/*  2748 */       this.database = paramProperties.getProperty("server", CONNECTION_PROPERTY_DATABASE_DEFAULT);
/*       */     }
/*  2750 */     if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
/*  2751 */       this.database = ((String)localHashtable.get("database"));
/*       */     }
/*  2753 */     this.protocol = ((String)localHashtable.get("protocol"));
/*       */ 
/*  2756 */     if (this.protocol == null)
/*       */     {
/*  2759 */       localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 40, "Protocol is not specified in URL");
/*  2760 */       ((SQLException)localObject3).fillInStackTrace();
/*  2761 */       throw ((Throwable)localObject3);
/*       */     }
/*       */ 
/*  2766 */     if ((this.protocol.equals("oci8")) || (this.protocol.equals("oci"))) {
/*  2767 */       this.database = translateConnStr(this.database);
/*       */ 
/*  2769 */       if ((null != this.targetInstanceName) && (!"".equals(this.targetInstanceName))) {
/*  2770 */         this.database = createNamedInstanceUrl(this.database, this.targetInstanceName);
/*       */       }
/*       */     }
/*  2773 */     if (paramProperties.getProperty("is_connection_pooling") == "true")
/*       */     {
/*  2776 */       if (this.database == null) {
/*  2777 */         this.database = "";
/*       */       }
/*       */     }
/*  2780 */     if ((this.userName != null) && (!this.userName.startsWith("\"")))
/*       */     {
/*  2783 */       localObject3 = this.userName.toCharArray();
/*  2784 */       for (int m = 0; m < localObject3.length; m++)
/*  2785 */         localObject3[m] = Character.toUpperCase(localObject3[m]);
/*  2786 */       this.userName = String.copyValueOf((char[])localObject3);
/*       */     }
/*       */ 
/*  2790 */     this.xaWantsError = false;
/*  2791 */     this.usingXA = false;
/*       */ 
/*  2793 */     readOCIConnectionPoolProperties(paramProperties);
/*  2794 */     validateConnectionProperties();
/*       */   }
/*       */ 
/*       */   private void readOCIConnectionPoolProperties(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*  2803 */     this.ociConnectionPoolMinLimit = parseConnectionProperty_int(paramProperties, "connpool_min_limit", (byte)1, 0);
/*       */ 
/*  2806 */     this.ociConnectionPoolMaxLimit = parseConnectionProperty_int(paramProperties, "connpool_max_limit", (byte)1, 0);
/*       */ 
/*  2809 */     this.ociConnectionPoolIncrement = parseConnectionProperty_int(paramProperties, "connpool_increment", (byte)1, 0);
/*       */ 
/*  2812 */     this.ociConnectionPoolTimeout = parseConnectionProperty_int(paramProperties, "connpool_timeout", (byte)1, 0);
/*       */ 
/*  2815 */     this.ociConnectionPoolNoWait = parseConnectionProperty_boolean(paramProperties, "connpool_nowait", (byte)1, false);
/*       */ 
/*  2818 */     this.ociConnectionPoolTransactionDistributed = parseConnectionProperty_boolean(paramProperties, "transactions_distributed", (byte)1, false);
/*       */ 
/*  2821 */     this.ociConnectionPoolLogonMode = parseConnectionProperty_String(paramProperties, "connection_pool", (byte)1, null);
/*       */ 
/*  2824 */     this.ociConnectionPoolIsPooling = parseConnectionProperty_boolean(paramProperties, "is_connection_pooling", (byte)1, false);
/*       */ 
/*  2827 */     this.ociConnectionPoolObject = parseConnectionProperty_Object(paramProperties, "connpool_object", null);
/*       */ 
/*  2829 */     this.ociConnectionPoolConnID = parseConnectionProperty_Object(paramProperties, "connection_id", null);
/*       */ 
/*  2831 */     this.ociConnectionPoolProxyType = parseConnectionProperty_String(paramProperties, "proxytype", (byte)1, null);
/*       */ 
/*  2834 */     this.ociConnectionPoolProxyNumRoles = ((Integer)parseConnectionProperty_Object(paramProperties, "proxy_num_roles", Integer.valueOf(0)));
/*       */ 
/*  2836 */     this.ociConnectionPoolProxyRoles = parseConnectionProperty_Object(paramProperties, "proxy_roles", null);
/*       */ 
/*  2838 */     this.ociConnectionPoolProxyUserName = parseConnectionProperty_String(paramProperties, "proxy_user_name", (byte)1, null);
/*       */ 
/*  2841 */     this.ociConnectionPoolProxyPassword = parseConnectionProperty_String(paramProperties, "proxy_password", (byte)1, null);
/*       */ 
/*  2844 */     this.ociConnectionPoolProxyDistinguishedName = parseConnectionProperty_String(paramProperties, "proxy_distinguished_name", (byte)1, null);
/*       */ 
/*  2847 */     this.ociConnectionPoolProxyCertificate = parseConnectionProperty_Object(paramProperties, "proxy_certificate", null);
/*       */   }
/*       */ 
/*       */   void validateConnectionProperties()
/*       */     throws SQLException
/*       */   {
/*  2864 */     if ((this.driverNameAttribute != null) && (!driverNameAttributePattern.matcher(this.driverNameAttribute).matches()))
/*       */     {
/*  2867 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 257);
/*  2868 */       localSQLException.fillInStackTrace();
/*  2869 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   private static final Object parseConnectionProperty_Object(Properties paramProperties, String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  2886 */     Object localObject1 = paramObject;
/*  2887 */     if (paramProperties != null)
/*       */     {
/*  2889 */       Object localObject2 = paramProperties.get(paramString);
/*  2890 */       if (localObject2 != null)
/*  2891 */         localObject1 = localObject2;
/*       */     }
/*  2893 */     return localObject1;
/*       */   }
/*       */ 
/*       */   private static final String parseConnectionProperty_String(Properties paramProperties, String paramString1, byte paramByte, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  2922 */     String str = null;
/*  2923 */     if (((paramByte == 1) || (paramByte == 3)) && (paramProperties != null))
/*       */     {
/*  2926 */       str = paramProperties.getProperty(paramString1);
/*  2927 */       if ((str == null) && (!paramString1.startsWith("oracle.")) && (!paramString1.startsWith("java.")) && (!paramString1.startsWith("javax.")))
/*  2928 */         str = paramProperties.getProperty("oracle.jdbc." + paramString1);
/*       */     }
/*  2930 */     if ((str == null) && ((paramByte == 2) || (paramByte == 3)))
/*       */     {
/*  2933 */       if ((paramString1.startsWith("oracle.")) || (paramString1.startsWith("java.")) || (paramString1.startsWith("javax.")))
/*  2934 */         str = getSystemProperty(paramString1, null);
/*       */       else
/*  2936 */         str = getSystemProperty("oracle.jdbc." + paramString1, null);
/*       */     }
/*  2938 */     if (str == null)
/*  2939 */       str = paramString2;
/*  2940 */     return str;
/*       */   }
/*       */ 
/*       */   private static final int parseConnectionProperty_int(Properties paramProperties, String paramString, byte paramByte, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2951 */     int i = paramInt;
/*  2952 */     String str = parseConnectionProperty_String(paramProperties, paramString, paramByte, null);
/*       */ 
/*  2957 */     if (str != null)
/*       */     {
/*       */       try
/*       */       {
/*  2961 */         i = Integer.parseInt(str);
/*       */       }
/*       */       catch (NumberFormatException localNumberFormatException)
/*       */       {
/*  2967 */         SQLException localSQLException = DatabaseError.createSqlException(null, 190, "Property is '" + paramString + "' and value is '" + str + "'");
/*  2968 */         localSQLException.fillInStackTrace();
/*  2969 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  2974 */     return i;
/*       */   }
/*       */ 
/*       */   private static final long parseConnectionProperty_long(Properties paramProperties, String paramString, byte paramByte, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  2985 */     long l = paramLong;
/*  2986 */     String str = parseConnectionProperty_String(paramProperties, paramString, paramByte, null);
/*       */ 
/*  2991 */     if (str != null)
/*       */     {
/*       */       try
/*       */       {
/*  2995 */         l = Long.parseLong(str);
/*       */       }
/*       */       catch (NumberFormatException localNumberFormatException)
/*       */       {
/*  3001 */         SQLException localSQLException = DatabaseError.createSqlException(null, 190, "Property is '" + paramString + "' and value is '" + str + "'");
/*  3002 */         localSQLException.fillInStackTrace();
/*  3003 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3008 */     return l;
/*       */   }
/*       */ 
/*       */   private static final boolean parseConnectionProperty_boolean(Properties paramProperties, String paramString, byte paramByte, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  3019 */     boolean bool = paramBoolean;
/*  3020 */     String str = parseConnectionProperty_String(paramProperties, paramString, paramByte, null);
/*       */ 
/*  3025 */     if (str != null)
/*       */     {
/*  3027 */       if (str.equalsIgnoreCase("false"))
/*  3028 */         bool = false;
/*  3029 */       else if (str.equalsIgnoreCase("true"))
/*  3030 */         bool = true;
/*       */     }
/*  3032 */     return bool;
/*       */   }
/*       */ 
/*       */   private static String parseLoginOption(String paramString, Properties paramProperties, String[] paramArrayOfString1, String[] paramArrayOfString2)
/*       */   {
/*  3052 */     int j = 0;
/*  3053 */     String str1 = null;
/*  3054 */     String str2 = null;
/*       */ 
/*  3057 */     if (paramString == null) {
/*  3058 */       return null;
/*       */     }
/*  3060 */     int k = paramString.length();
/*       */ 
/*  3062 */     if (k == 0) {
/*  3063 */       return null;
/*       */     }
/*       */ 
/*  3066 */     int i = paramString.indexOf(91);
/*  3067 */     if (i > 0) {
/*  3068 */       j = paramString.indexOf(93);
/*  3069 */       str2 = paramString.substring(i + 1, j);
/*  3070 */       str2 = str2.trim();
/*       */ 
/*  3072 */       if (str2.length() > 0) {
/*  3073 */         paramArrayOfString2[0] = str2;
/*       */       }
/*       */ 
/*  3076 */       paramString = paramString.substring(0, i) + paramString.substring(j + 1, k);
/*       */     }
/*       */ 
/*  3081 */     String str3 = paramString.toLowerCase();
/*       */ 
/*  3084 */     i = str3.lastIndexOf(" as ");
/*       */ 
/*  3086 */     if ((i == -1) || (i < str3.lastIndexOf("\""))) {
/*  3087 */       return paramString;
/*       */     }
/*       */ 
/*  3092 */     str1 = paramString.substring(0, i);
/*       */ 
/*  3094 */     i += 4;
/*       */ 
/*  3097 */     while ((i < k) && (str3.charAt(i) == ' ')) {
/*  3098 */       i++;
/*       */     }
/*  3100 */     if (i == k) {
/*  3101 */       return paramString;
/*       */     }
/*  3103 */     String str4 = str3.substring(i).trim();
/*       */ 
/*  3105 */     if (str4.length() > 0) {
/*  3106 */       paramArrayOfString1[0] = str4;
/*       */     }
/*  3108 */     return str1;
/*       */   }
/*       */ 
/*       */   static final Hashtable parseUrl(String paramString1, String paramString2, String paramString3)
/*       */     throws SQLException
/*       */   {
/*  3129 */     Hashtable localHashtable = new Hashtable(5);
/*  3130 */     int i = paramString1.indexOf(58, paramString1.indexOf(58) + 1) + 1;
/*  3131 */     int j = paramString1.length();
/*       */ 
/*  3134 */     if (i == j) {
/*  3135 */       return localHashtable;
/*       */     }
/*  3137 */     int k = paramString1.indexOf(58, i);
/*       */ 
/*  3140 */     if (k == -1)
/*       */     {
/*  3146 */       return localHashtable;
/*       */     }
/*       */ 
/*  3150 */     localHashtable.put("protocol", paramString1.substring(i, k));
/*       */ 
/*  3152 */     int m = k + 1;
/*  3153 */     int n = paramString1.indexOf(47, m);
/*       */ 
/*  3155 */     int i1 = paramString1.indexOf(64, m);
/*       */     Object localObject;
/*  3160 */     if ((i1 > m) && (m > i) && (n == -1))
/*       */     {
/*  3163 */       localObject = DatabaseError.createSqlException(null, 67);
/*  3164 */       ((SQLException)localObject).fillInStackTrace();
/*  3165 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3169 */     if (i1 == -1) {
/*  3170 */       i1 = j;
/*       */     }
/*  3172 */     if (n == -1) {
/*  3173 */       n = i1;
/*       */     }
/*  3175 */     if ((n < i1) && (n != m) && (i1 != m))
/*       */     {
/*  3177 */       localHashtable.put("user", paramString1.substring(m, n));
/*  3178 */       localHashtable.put("password", paramString1.substring(n + 1, i1));
/*       */     }
/*       */ 
/*  3184 */     if ((n <= i1) && ((n == m) || (i1 == m)))
/*       */     {
/*  3191 */       if (i1 < j)
/*       */       {
/*  3193 */         localObject = paramString1.substring(i1 + 1);
/*  3194 */         String[] arrayOfString = getSecretStoreCredentials((String)localObject, paramString2, paramString3);
/*  3195 */         if ((arrayOfString[0] != null) || (arrayOfString[1] != null))
/*       */         {
/*  3197 */           localHashtable.put("user", arrayOfString[0]);
/*  3198 */           localHashtable.put("password", arrayOfString[1]);
/*       */         }
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3204 */     if (i1 < j) {
/*  3205 */       localHashtable.put("database", paramString1.substring(i1 + 1));
/*       */     }
/*  3207 */     return localHashtable;
/*       */   }
/*       */ 
/*       */   private static final synchronized String[] getSecretStoreCredentials(String paramString1, String paramString2, String paramString3)
/*       */     throws SQLException
/*       */   {
/*  3369 */     String[] arrayOfString = new String[2];
/*  3370 */     arrayOfString[0] = null;
/*  3371 */     arrayOfString[1] = null;
/*       */ 
/*  3373 */     if (paramString2 != null)
/*       */     {
/*       */       try
/*       */       {
/*  3377 */         if (paramString2.startsWith("(")) {
/*  3378 */           paramString2 = "file:" + CustomSSLSocketFactory.processWalletLocation(paramString2);
/*       */         }
/*  3380 */         OracleWallet localOracleWallet = new OracleWallet();
/*  3381 */         if (localOracleWallet.exists(paramString2))
/*       */         {
/*  3385 */           localObject = null;
/*  3386 */           if (paramString3 != null) {
/*  3387 */             localObject = paramString3.toCharArray();
/*       */           }
/*       */ 
/*  3391 */           localOracleWallet.open(paramString2, (char[])localObject);
/*  3392 */           OracleSecretStore localOracleSecretStore = localOracleWallet.getSecretStore();
/*       */ 
/*  3396 */           if (localOracleSecretStore.containsAlias("oracle.security.client.default_username")) {
/*  3397 */             arrayOfString[0] = new String(localOracleSecretStore.getSecret("oracle.security.client.default_username"));
/*       */           }
/*  3399 */           if (localOracleSecretStore.containsAlias("oracle.security.client.default_password")) {
/*  3400 */             arrayOfString[1] = new String(localOracleSecretStore.getSecret("oracle.security.client.default_password"));
/*       */           }
/*       */ 
/*  3403 */           Enumeration localEnumeration = localOracleWallet.getSecretStore().internalAliases();
/*       */ 
/*  3405 */           String str1 = null;
/*  3406 */           while (localEnumeration.hasMoreElements())
/*       */           {
/*  3408 */             str1 = (String)localEnumeration.nextElement();
/*  3409 */             if ((str1.startsWith("oracle.security.client.connect_string")) && 
/*  3411 */               (paramString1.equalsIgnoreCase(new String(localOracleSecretStore.getSecret(str1)))))
/*       */             {
/*  3414 */               String str2 = str1.substring("oracle.security.client.connect_string".length());
/*  3415 */               arrayOfString[0] = new String(localOracleSecretStore.getSecret("oracle.security.client.username" + str2));
/*       */ 
/*  3417 */               arrayOfString[1] = new String(localOracleSecretStore.getSecret("oracle.security.client.password" + str2));
/*       */             }
/*       */ 
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*       */       }
/*       */       catch (NoClassDefFoundError localNoClassDefFoundError)
/*       */       {
/*  3428 */         localObject = DatabaseError.createSqlException(null, 167, localNoClassDefFoundError);
/*  3429 */         ((SQLException)localObject).fillInStackTrace();
/*  3430 */         throw ((Throwable)localObject);
/*       */       }
/*       */       catch (Exception localException)
/*       */       {
/*  3435 */         if ((localException instanceof RuntimeException)) throw ((RuntimeException)localException);
/*       */ 
/*  3445 */         Object localObject = DatabaseError.createSqlException(null, 168, localException);
/*  3446 */         ((SQLException)localObject).fillInStackTrace();
/*  3447 */         throw ((Throwable)localObject);
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3452 */     return arrayOfString;
/*       */   }
/*       */ 
/*       */   private String translateConnStr(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3471 */     int i = 0;
/*  3472 */     int j = 0;
/*       */ 
/*  3474 */     if ((paramString == null) || (paramString.equals(""))) {
/*  3475 */       return paramString;
/*       */     }
/*       */ 
/*  3478 */     if (paramString.indexOf(41) != -1) {
/*  3479 */       return paramString;
/*       */     }
/*  3481 */     int k = 0;
/*  3482 */     if (paramString.indexOf(91) != -1)
/*       */     {
/*  3485 */       i = paramString.indexOf(93);
/*  3486 */       if (i == -1)
/*       */       {
/*  3488 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67, paramString);
/*  3489 */         ((SQLException)localObject).fillInStackTrace();
/*  3490 */         throw ((Throwable)localObject);
/*       */       }
/*  3492 */       k = 1;
/*       */     }
/*       */ 
/*  3495 */     i = paramString.indexOf(58, i);
/*  3496 */     if (i == -1)
/*  3497 */       return paramString;
/*  3498 */     j = paramString.indexOf(58, i + 1);
/*  3499 */     if (j == -1) {
/*  3500 */       return paramString;
/*       */     }
/*       */ 
/*  3503 */     if (paramString.indexOf(58, j + 1) != -1)
/*       */     {
/*  3506 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67, paramString);
/*  3507 */       ((SQLException)localObject).fillInStackTrace();
/*  3508 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3512 */     Object localObject = null;
/*  3513 */     if (k != 0)
/*  3514 */       localObject = paramString.substring(1, i - 1);
/*       */     else {
/*  3516 */       localObject = paramString.substring(0, i);
/*       */     }
/*  3518 */     String str2 = paramString.substring(i + 1, j);
/*  3519 */     String str3 = paramString.substring(j + 1, paramString.length());
/*       */ 
/*  3521 */     String str1 = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + (String)localObject + ")(PORT=" + str2 + "))(CONNECT_DATA=(SID=" + str3 + ")))";
/*       */ 
/*  3527 */     return str1;
/*       */   }
/*       */ 
/*       */   private String createNamedInstanceUrl(String paramString1, String paramString2)
/*       */   {
/*  3543 */     StringBuffer localStringBuffer = new StringBuffer(paramString1);
/*       */ 
/*  3550 */     int i = localStringBuffer.indexOf("CONNECT_DATA");
/*       */ 
/*  3555 */     if (i != -1) {
/*  3556 */       int j = localStringBuffer.indexOf("=", i + "CONNECT_DATA".length());
/*       */ 
/*  3561 */       if (j != -1) {
/*  3562 */         localStringBuffer.insert(j + 1, "(INSTANCE_NAME=" + paramString2 + ")");
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3571 */     String str = localStringBuffer.toString();
/*       */ 
/*  3574 */     return str;
/*       */   }
/*       */ 
/*       */   protected static String getSystemPropertyPollInterval()
/*       */   {
/*  3581 */     return getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
/*       */   }
/*       */ 
/*       */   static String getSqlTranslationProfile()
/*       */   {
/*  3588 */     return getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
/*       */   }
/*       */ 
/*       */   static String getSystemPropertyFastConnectionFailover(String paramString)
/*       */   {
/*  3596 */     return getSystemProperty("oracle.jdbc.FastConnectionFailover", paramString);
/*       */   }
/*       */ 
/*       */   static String getSystemPropertyJserverVersion()
/*       */   {
/*  3604 */     return getSystemProperty("oracle.jserver.version", null);
/*       */   }
/*       */ 
/*       */   private static String getSystemProperty(String paramString1, String paramString2)
/*       */   {
/*  3611 */     if (paramString1 != null)
/*       */     {
/*  3613 */       final String str1 = paramString1;
/*  3614 */       final String str2 = paramString2;
/*  3615 */       String[] arrayOfString = { paramString2 };
/*  3616 */       AccessController.doPrivileged(new PrivilegedAction()
/*       */       {
/*       */         public Object run()
/*       */         {
/*  3620 */           this.val$rets[0] = System.getProperty(str1, str2);
/*  3621 */           return null;
/*       */         }
/*       */       });
/*  3624 */       return arrayOfString[0];
/*       */     }
/*       */ 
/*  3627 */     return paramString2;
/*       */   }
/*       */ 
/*       */   abstract void initializePassword(String paramString)
/*       */     throws SQLException;
/*       */ 
/*       */   public Properties getProperties()
/*       */   {
/*  3643 */     Properties localProperties = new Properties();
/*       */     try
/*       */     {
/*  3646 */       Class localClass1 = null;
/*  3647 */       Class localClass2 = null;
/*       */       try
/*       */       {
/*  3650 */         localClass1 = Class.forName("oracle.jdbc.OracleConnection");
/*  3651 */         localClass2 = Class.forName("oracle.jdbc.driver.PhysicalConnection");
/*       */       }
/*       */       catch (ClassNotFoundException localClassNotFoundException)
/*       */       {
/*       */       }
/*       */ 
/*  3660 */       Field[] arrayOfField = localClass2.getDeclaredFields();
/*  3661 */       for (int i = 0; i < arrayOfField.length; i++)
/*       */       {
/*  3663 */         int j = arrayOfField[i].getModifiers();
/*  3664 */         if (!Modifier.isStatic(j))
/*       */         {
/*  3667 */           String str1 = arrayOfField[i].getName();
/*       */ 
/*  3670 */           String str2 = "CONNECTION_PROPERTY_" + propertyVariableName(str1);
/*       */ 
/*  3674 */           Field localField = null;
/*       */           try
/*       */           {
/*  3678 */             localField = localClass1.getField(str2);
/*       */           }
/*       */           catch (NoSuchFieldException localNoSuchFieldException)
/*       */           {
/*  3682 */             continue;
/*       */           }
/*       */ 
/*  3686 */           if (!str2.matches(".*PASSWORD.*"))
/*       */           {
/*  3689 */             String str3 = (String)localField.get(null);
/*  3690 */             String str4 = arrayOfField[i].getType().getName();
/*  3691 */             if (str4.equals("boolean"))
/*       */             {
/*  3693 */               boolean bool = arrayOfField[i].getBoolean(this);
/*  3694 */               if (bool)
/*  3695 */                 localProperties.setProperty(str3, "true");
/*       */               else
/*  3697 */                 localProperties.setProperty(str3, "false");
/*       */             }
/*  3699 */             else if (str4.equals("int"))
/*       */             {
/*  3701 */               int k = arrayOfField[i].getInt(this);
/*  3702 */               localProperties.setProperty(str3, Integer.toString(k));
/*       */             }
/*  3704 */             else if (str4.equals("long"))
/*       */             {
/*  3706 */               long l = arrayOfField[i].getLong(this);
/*  3707 */               localProperties.setProperty(str3, Long.toString(l));
/*       */             }
/*  3709 */             else if (str4.equals("java.lang.String"))
/*       */             {
/*  3711 */               String str5 = (String)arrayOfField[i].get(this);
/*  3712 */               if (str5 != null)
/*  3713 */                 localProperties.setProperty(str3, str5);
/*       */             }
/*       */           }
/*       */         }
/*       */       }
/*       */     }
/*       */     catch (IllegalAccessException localIllegalAccessException)
/*       */     {
/*       */     }
/*  3722 */     return localProperties;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public synchronized Connection _getPC()
/*       */   {
/*  3748 */     return null;
/*       */   }
/*       */ 
/*       */   public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection()
/*       */   {
/*  3769 */     return this;
/*       */   }
/*       */ 
/*       */   public synchronized boolean isLogicalConnection()
/*       */   {
/*  3787 */     return false;
/*       */   }
/*       */ 
/*       */   void initialize(Hashtable paramHashtable, Map paramMap1, Map paramMap2)
/*       */     throws SQLException
/*       */   {
/*  3800 */     this.clearStatementMetaData = false;
/*       */ 
/*  3806 */     if (paramHashtable != null)
/*  3807 */       this.descriptorCacheStack[this.dci] = paramHashtable;
/*       */     else {
/*  3809 */       this.descriptorCacheStack[this.dci] = new Hashtable(10);
/*       */     }
/*  3811 */     this.map = paramMap1;
/*       */ 
/*  3813 */     if (paramMap2 != null)
/*  3814 */       this.javaObjectMap = paramMap2;
/*       */     else {
/*  3816 */       this.javaObjectMap = new Hashtable(10);
/*       */     }
/*  3818 */     this.lifecycle = 1;
/*  3819 */     this.txnLevel = 2;
/*       */ 
/*  3822 */     this.clientIdSet = false;
/*       */   }
/*       */ 
/*       */   void initializeSetCHARCharSetObjs()
/*       */   {
/*  3830 */     this.setCHARNCharSetObj = this.conversion.getDriverNCharSetObj();
/*  3831 */     this.setCHARCharSetObj = this.conversion.getDriverCharSetObj();
/*       */   }
/*       */ 
/*       */   OracleTimeout getTimeout()
/*       */     throws SQLException
/*       */   {
/*  3845 */     if (this.timeout == null)
/*       */     {
/*  3847 */       this.timeout = OracleTimeout.newTimeout(this.url);
/*       */     }
/*       */ 
/*  3850 */     return this.timeout;
/*       */   }
/*       */ 
/*       */   public synchronized Statement createStatement()
/*       */     throws SQLException
/*       */   {
/*  3874 */     return createStatement(-1, -1);
/*       */   }
/*       */ 
/*       */   public synchronized Statement createStatement(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  3901 */     if (this.lifecycle != 1)
/*       */     {
/*  3903 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  3904 */       ((SQLException)localObject).fillInStackTrace();
/*  3905 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3908 */     Object localObject = null;
/*       */ 
/*  3914 */     localObject = this.driverExtension.allocateStatement(this, paramInt1, paramInt2);
/*       */ 
/*  3921 */     return new OracleStatementWrapper((oracle.jdbc.OracleStatement)localObject);
/*       */   }
/*       */ 
/*       */   public synchronized PreparedStatement prepareStatement(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3947 */     return prepareStatement(paramString, -1, -1);
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public synchronized PreparedStatement prepareStatementWithKey(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3973 */     if (this.lifecycle != 1)
/*       */     {
/*  3975 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  3976 */       ((SQLException)localObject).fillInStackTrace();
/*  3977 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3980 */     if (paramString == null) {
/*  3981 */       return null;
/*       */     }
/*  3983 */     if (!isStatementCacheInitialized())
/*       */     {
/*  3985 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 95);
/*  3986 */       ((SQLException)localObject).fillInStackTrace();
/*  3987 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3994 */     Object localObject = null;
/*       */ 
/*  3996 */     localObject = (OraclePreparedStatement)this.statementCache.searchExplicitCache(paramString);
/*       */ 
/*  4007 */     if (localObject != null) {
/*  4008 */       localObject = new OraclePreparedStatementWrapper((oracle.jdbc.OraclePreparedStatement)localObject);
/*       */     }
/*  4010 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4041 */     OraclePreparedStatement localOraclePreparedStatement = prepareStatementInternal(paramString, paramInt1, paramInt2);
/*       */ 
/*  4043 */     return new OraclePreparedStatementWrapper(localOraclePreparedStatement);
/*       */   }
/*       */ 
/*       */   OraclePreparedStatement prepareStatementInternal(String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4065 */     if ((paramString == null) || (paramString.length() == 0))
/*       */     {
/*  4067 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 104);
/*  4068 */       ((SQLException)localObject).fillInStackTrace();
/*  4069 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4072 */     if (this.lifecycle != 1)
/*       */     {
/*  4074 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4075 */       ((SQLException)localObject).fillInStackTrace();
/*  4076 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4079 */     Object localObject = null;
/*       */ 
/*  4082 */     if (this.statementCache != null) {
/*  4083 */       OracleResultSet.ResultSetType localResultSetType = OracleResultSet.ResultSetType.typeFor(paramInt1, paramInt2);
/*  4084 */       if (localResultSetType == OracleResultSet.ResultSetType.UNKNOWN) localResultSetType = OracleStatement.DEFAULT_RESULT_SET_TYPE;
/*  4085 */       localObject = (OraclePreparedStatement)this.statementCache.searchImplicitCache(paramString, 1, localResultSetType.ordinal(), this);
/*       */     }
/*       */ 
/*  4093 */     if (localObject == null) {
/*  4094 */       localObject = this.driverExtension.allocatePreparedStatement(this, paramString, paramInt1, paramInt2);
/*       */     }
/*       */ 
/*  4106 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized CallableStatement prepareCall(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4130 */     return prepareCall(paramString, -1, -1);
/*       */   }
/*       */ 
/*       */   public synchronized CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4164 */     if ((paramString == null) || (paramString.length() == 0))
/*       */     {
/*  4166 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 104);
/*  4167 */       ((SQLException)localObject).fillInStackTrace();
/*  4168 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4171 */     if (this.lifecycle != 1)
/*       */     {
/*  4173 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4174 */       ((SQLException)localObject).fillInStackTrace();
/*  4175 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4178 */     Object localObject = null;
/*       */ 
/*  4180 */     if (this.statementCache != null) {
/*  4181 */       OracleResultSet.ResultSetType localResultSetType = OracleResultSet.ResultSetType.typeFor(paramInt1, paramInt2);
/*  4182 */       if (localResultSetType == OracleResultSet.ResultSetType.UNKNOWN) localResultSetType = OracleStatement.DEFAULT_RESULT_SET_TYPE;
/*  4183 */       localObject = (OracleCallableStatement)this.statementCache.searchImplicitCache(paramString, 2, localResultSetType.ordinal(), this);
/*       */     }
/*       */ 
/*  4191 */     if (localObject == null) {
/*  4192 */       localObject = this.driverExtension.allocateCallableStatement(this, paramString, paramInt1, paramInt2);
/*       */     }
/*       */ 
/*  4203 */     return new OracleCallableStatementWrapper((oracle.jdbc.OracleCallableStatement)localObject);
/*       */   }
/*       */ 
/*       */   public synchronized CallableStatement prepareCallWithKey(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4228 */     if (this.lifecycle != 1)
/*       */     {
/*  4230 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4231 */       ((SQLException)localObject).fillInStackTrace();
/*  4232 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4235 */     if (paramString == null) {
/*  4236 */       return null;
/*       */     }
/*  4238 */     if (!isStatementCacheInitialized())
/*       */     {
/*  4240 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 95);
/*  4241 */       ((SQLException)localObject).fillInStackTrace();
/*  4242 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4249 */     Object localObject = null;
/*       */ 
/*  4251 */     localObject = (OracleCallableStatement)this.statementCache.searchExplicitCache(paramString);
/*       */ 
/*  4261 */     if (localObject != null) {
/*  4262 */       localObject = new OracleCallableStatementWrapper((oracle.jdbc.OracleCallableStatement)localObject);
/*       */     }
/*  4264 */     return localObject;
/*       */   }
/*       */ 
/*       */   public String nativeSQL(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4281 */     if (this.sqlObj == null)
/*       */     {
/*  4283 */       this.sqlObj = new OracleSql(this.conversion);
/*       */     }
/*       */ 
/*  4286 */     this.sqlObj.initialize(paramString);
/*       */ 
/*  4288 */     String str = this.sqlObj.getSql(this.processEscapes, this.convertNcharLiterals);
/*       */ 
/*  4290 */     return str;
/*       */   }
/*       */ 
/*       */   public synchronized void setAutoCommit(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  4305 */     if (paramBoolean) {
/*  4306 */       disallowGlobalTxnMode(116);
/*       */     }
/*  4308 */     if (this.lifecycle != 1)
/*       */     {
/*  4310 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4311 */       localSQLException.fillInStackTrace();
/*  4312 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4315 */     needLine();
/*  4316 */     doSetAutoCommit(paramBoolean);
/*       */   }
/*       */ 
/*       */   public boolean getAutoCommit()
/*       */     throws SQLException
/*       */   {
/*  4330 */     if (this.lifecycle != 1)
/*       */     {
/*  4332 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4333 */       localSQLException.fillInStackTrace();
/*  4334 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4337 */     return this.autocommit;
/*       */   }
/*       */ 
/*       */   public void cancel()
/*       */     throws SQLException
/*       */   {
/*  4361 */     OracleStatement localOracleStatement = this.statements;
/*       */ 
/*  4363 */     if ((this.lifecycle != 1) && (this.lifecycle != 16))
/*       */     {
/*  4365 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4366 */       localSQLException1.fillInStackTrace();
/*  4367 */       throw localSQLException1;
/*       */     }
/*       */ 
/*  4370 */     int i = 0;
/*       */ 
/*  4372 */     while (localOracleStatement != null)
/*       */     {
/*       */       try
/*       */       {
/*  4380 */         if (localOracleStatement.doCancel()) {
/*  4381 */           i = 1;
/*       */         }
/*       */       }
/*       */       catch (SQLException localSQLException2)
/*       */       {
/*       */       }
/*  4387 */       localOracleStatement = localOracleStatement.next;
/*       */     }
/*       */ 
/*  4391 */     if (i == 0)
/*  4392 */       cancelOperationOnServer(false);
/*       */   }
/*       */ 
/*       */   public void commit(EnumSet<OracleConnection.CommitOption> paramEnumSet)
/*       */     throws SQLException
/*       */   {
/*  4399 */     int i = 0;
/*       */     Object localObject;
/*  4400 */     if (paramEnumSet != null)
/*       */     {
/*  4402 */       if (((paramEnumSet.contains(OracleConnection.CommitOption.WRITEBATCH)) && (paramEnumSet.contains(OracleConnection.CommitOption.WRITEIMMED))) || ((paramEnumSet.contains(OracleConnection.CommitOption.WAIT)) && (paramEnumSet.contains(OracleConnection.CommitOption.NOWAIT))))
/*       */       {
/*  4408 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 191);
/*  4409 */         ((SQLException)localObject).fillInStackTrace();
/*  4410 */         throw ((Throwable)localObject);
/*       */       }
/*       */ 
/*  4414 */       for (localObject = paramEnumSet.iterator(); ((Iterator)localObject).hasNext(); ) { OracleConnection.CommitOption localCommitOption = (OracleConnection.CommitOption)((Iterator)localObject).next();
/*  4415 */         i |= localCommitOption.getCode(); }
/*       */     }
/*  4417 */     commit(i);
/*       */   }
/*       */ 
/*       */   synchronized void commit(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4433 */     disallowGlobalTxnMode(114);
/*       */ 
/*  4436 */     if ((this.autoCommitSpecCompliant) && (getAutoCommit()))
/*       */     {
/*  4438 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 273);
/*  4439 */       ((SQLException)localObject).fillInStackTrace();
/*  4440 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4443 */     if (this.lifecycle != 1)
/*       */     {
/*  4445 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4446 */       ((SQLException)localObject).fillInStackTrace();
/*  4447 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4450 */     Object localObject = this.statements;
/*       */ 
/*  4452 */     while (localObject != null)
/*       */     {
/*  4457 */       if (!((OracleStatement)localObject).closed) {
/*  4458 */         ((OracleStatement)localObject).sendBatch();
/*       */       }
/*  4460 */       localObject = ((OracleStatement)localObject).next;
/*       */     }
/*  4462 */     if ((((paramInt & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) && ((paramInt & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0)) || (((paramInt & OracleConnection.CommitOption.WAIT.getCode()) != 0) && ((paramInt & OracleConnection.CommitOption.NOWAIT.getCode()) != 0)))
/*       */     {
/*  4468 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 191);
/*  4469 */       localSQLException.fillInStackTrace();
/*  4470 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4477 */     registerHeartbeat();
/*       */ 
/*  4479 */     needLine();
/*  4480 */     doCommit(paramInt);
/*       */   }
/*       */ 
/*       */   public void commit()
/*       */     throws SQLException
/*       */   {
/*  4486 */     commit(this.commitOption);
/*       */   }
/*       */ 
/*       */   public synchronized void rollback()
/*       */     throws SQLException
/*       */   {
/*  4500 */     disallowGlobalTxnMode(115);
/*       */ 
/*  4503 */     if ((this.autoCommitSpecCompliant) && (getAutoCommit()))
/*       */     {
/*  4505 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 274);
/*  4506 */       ((SQLException)localObject).fillInStackTrace();
/*  4507 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4510 */     if (this.lifecycle != 1)
/*       */     {
/*  4512 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  4513 */       ((SQLException)localObject).fillInStackTrace();
/*  4514 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4518 */     Object localObject = this.statements;
/*       */ 
/*  4520 */     while (localObject != null)
/*       */     {
/*  4522 */       if (((OracleStatement)localObject).isOracleBatchStyle()) {
/*  4523 */         ((OracleStatement)localObject).clearBatch();
/*       */       }
/*  4525 */       localObject = ((OracleStatement)localObject).next;
/*       */     }
/*       */ 
/*  4532 */     registerHeartbeat();
/*       */ 
/*  4534 */     needLine();
/*  4535 */     doRollback();
/*       */   }
/*       */ 
/*       */   public synchronized void close()
/*       */     throws SQLException
/*       */   {
/*  4554 */     if ((this.lifecycle == 2) || (this.lifecycle == 4)) {
/*  4555 */       return;
/*       */     }
/*       */ 
/*  4560 */     needLineUnchecked();
/*       */     try
/*       */     {
/*  4564 */       if (this.closeCallback != null) {
/*  4565 */         this.closeCallback.beforeClose(this, this.privateData);
/*       */       }
/*  4567 */       closeStatementCache();
/*  4568 */       closeStatements(false);
/*       */ 
/*  4570 */       if (this.lifecycle == 1) this.lifecycle = 2;
/*       */ 
/*  4573 */       if (this.isProxy)
/*       */       {
/*  4575 */         close(1);
/*       */       }
/*       */ 
/*  4578 */       if (this.timeZoneTab != null) {
/*  4579 */         this.timeZoneTab.freeInstance();
/*       */       }
/*  4581 */       logoff();
/*  4582 */       cleanup();
/*       */ 
/*  4584 */       if (this.timeout != null) {
/*  4585 */         this.timeout.close();
/*       */       }
/*  4587 */       if (this.closeCallback != null)
/*  4588 */         this.closeCallback.afterClose(this.privateData);
/*       */     }
/*       */     finally
/*       */     {
/*  4592 */       this.lifecycle = 4;
/*  4593 */       this.isUsable = false;
/*       */     }
/*       */   }
/*       */ 
/*       */   public String getDataIntegrityAlgorithmName()
/*       */     throws SQLException
/*       */   {
/*  4604 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4605 */     localSQLException.fillInStackTrace();
/*  4606 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public String getEncryptionAlgorithmName()
/*       */     throws SQLException
/*       */   {
/*  4613 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4614 */     localSQLException.fillInStackTrace();
/*  4615 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public String getAuthenticationAdaptorName()
/*       */     throws SQLException
/*       */   {
/*  4622 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4623 */     localSQLException.fillInStackTrace();
/*  4624 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void closeInternal(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  4634 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4635 */     localSQLException.fillInStackTrace();
/*  4636 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void cleanupAndClose(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  4647 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4648 */     localSQLException.fillInStackTrace();
/*  4649 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void cleanupAndClose()
/*       */     throws SQLException
/*       */   {
/*  4660 */     if (this.lifecycle != 1) {
/*  4661 */       return;
/*       */     }
/*       */ 
/*  4666 */     this.lifecycle = 16;
/*       */ 
/*  4669 */     cancel();
/*       */   }
/*       */ 
/*       */   synchronized void closeLogicalConnection()
/*       */     throws SQLException
/*       */   {
/*  4676 */     if ((this.lifecycle == 1) || (this.lifecycle == 16) || (this.lifecycle == 2))
/*       */     {
/*  4680 */       this.savepointStatement = null;
/*  4681 */       closeStatements(true);
/*       */ 
/*  4683 */       if (this.clientIdSet) {
/*  4684 */         clearClientIdentifier(this.clientId);
/*       */       }
/*  4686 */       this.logicalConnectionAttached = null;
/*  4687 */       this.lifecycle = 1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public synchronized void close(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*  4712 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4713 */     localSQLException.fillInStackTrace();
/*  4714 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void close(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4735 */     if ((paramInt & 0x1000) != 0)
/*       */     {
/*  4737 */       close();
/*       */ 
/*  4739 */       return;
/*       */     }
/*       */ 
/*  4742 */     if (((paramInt & 0x1) != 0) && (this.isProxy))
/*       */     {
/*  4744 */       purgeStatementCache();
/*  4745 */       closeStatements(false);
/*  4746 */       this.descriptorCacheStack[(this.dci--)] = null;
/*       */ 
/*  4748 */       closeProxySession();
/*       */ 
/*  4750 */       this.isProxy = false;
/*       */ 
/*  4753 */       this.autocommit = this.savedAutoCommitFlag;
/*  4754 */       this.txnMode = this.savedTxnMode;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void abort()
/*       */     throws SQLException
/*       */   {
/*  4766 */     SecurityManager localSecurityManager = System.getSecurityManager();
/*  4767 */     if (localSecurityManager != null) {
/*  4768 */       localSecurityManager.checkPermission(CALL_ORACLE_ABORT_PERMISSION);
/*       */     }
/*       */ 
/*  4776 */     if ((this.lifecycle == 4) || (this.lifecycle == 8)) {
/*  4777 */       return;
/*       */     }
/*       */ 
/*  4780 */     this.lifecycle = 8;
/*       */ 
/*  4783 */     doAbort();
/*       */   }
/*       */ 
/*       */   abstract void doAbort()
/*       */     throws SQLException;
/*       */ 
/*       */   void closeProxySession()
/*       */     throws SQLException
/*       */   {
/*  4796 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4797 */     localSQLException.fillInStackTrace();
/*  4798 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Properties getServerSessionInfo()
/*       */     throws SQLException
/*       */   {
/*  4820 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4821 */     localSQLException.fillInStackTrace();
/*  4822 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void applyConnectionAttributes(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*  4840 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4841 */     localSQLException.fillInStackTrace();
/*  4842 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized Properties getConnectionAttributes()
/*       */     throws SQLException
/*       */   {
/*  4860 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4861 */     localSQLException.fillInStackTrace();
/*  4862 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized Properties getUnMatchedConnectionAttributes()
/*       */     throws SQLException
/*       */   {
/*  4880 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4881 */     localSQLException.fillInStackTrace();
/*  4882 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void setAbandonedTimeoutEnabled(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  4901 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4902 */     localSQLException.fillInStackTrace();
/*  4903 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback paramOracleConnectionCacheCallback, Object paramObject, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4921 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4922 */     localSQLException.fillInStackTrace();
/*  4923 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public OracleConnectionCacheCallback getConnectionCacheCallbackObj()
/*       */     throws SQLException
/*       */   {
/*  4941 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4942 */     localSQLException.fillInStackTrace();
/*  4943 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Object getConnectionCacheCallbackPrivObj()
/*       */     throws SQLException
/*       */   {
/*  4960 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4961 */     localSQLException.fillInStackTrace();
/*  4962 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public int getConnectionCacheCallbackFlag()
/*       */     throws SQLException
/*       */   {
/*  4979 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  4980 */     localSQLException.fillInStackTrace();
/*  4981 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void setConnectionReleasePriority(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4999 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  5000 */     localSQLException.fillInStackTrace();
/*  5001 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public int getConnectionReleasePriority()
/*       */     throws SQLException
/*       */   {
/*  5018 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  5019 */     localSQLException.fillInStackTrace();
/*  5020 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized boolean isClosed()
/*       */     throws SQLException
/*       */   {
/*  5038 */     return this.lifecycle != 1;
/*       */   }
/*       */ 
/*       */   public synchronized boolean isProxySession()
/*       */   {
/*  5050 */     return this.isProxy;
/*       */   }
/*       */ 
/*       */   public synchronized void openProxySession(int paramInt, Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*  5064 */     int i = 1;
/*       */ 
/*  5066 */     if (this.isProxy)
/*       */     {
/*  5068 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 149);
/*  5069 */       ((SQLException)localObject1).fillInStackTrace();
/*  5070 */       throw ((Throwable)localObject1);
/*       */     }
/*       */ 
/*  5073 */     Object localObject1 = paramProperties.getProperty("PROXY_USER_NAME");
/*  5074 */     String str1 = paramProperties.getProperty("PROXY_USER_PASSWORD");
/*  5075 */     String str2 = paramProperties.getProperty("PROXY_DISTINGUISHED_NAME");
/*       */ 
/*  5077 */     Object localObject2 = paramProperties.get("PROXY_CERTIFICATE");
/*       */     Object localObject3;
/*  5079 */     if (paramInt == 1)
/*       */     {
/*  5081 */       if ((localObject1 == null) && (str1 == null))
/*       */       {
/*  5083 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/*  5084 */         ((SQLException)localObject3).fillInStackTrace();
/*  5085 */         throw ((Throwable)localObject3);
/*       */       }
/*       */     }
/*  5088 */     else if (paramInt == 2)
/*       */     {
/*  5090 */       if (str2 == null)
/*       */       {
/*  5092 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/*  5093 */         ((SQLException)localObject3).fillInStackTrace();
/*  5094 */         throw ((Throwable)localObject3);
/*       */       }
/*       */     }
/*  5097 */     else if (paramInt == 3)
/*       */     {
/*  5099 */       if (localObject2 == null)
/*       */       {
/*  5101 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/*  5102 */         ((SQLException)localObject3).fillInStackTrace();
/*  5103 */         throw ((Throwable)localObject3);
/*       */       }
/*       */ 
/*       */       try
/*       */       {
/*  5108 */         localObject3 = (byte[])localObject2;
/*       */       }
/*       */       catch (ClassCastException localClassCastException)
/*       */       {
/*  5113 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/*  5114 */         localSQLException2.fillInStackTrace();
/*  5115 */         throw localSQLException2;
/*       */       }
/*       */ 
/*       */     }
/*       */     else
/*       */     {
/*  5121 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 150);
/*  5122 */       localSQLException1.fillInStackTrace();
/*  5123 */       throw localSQLException1;
/*       */     }
/*       */ 
/*  5126 */     purgeStatementCache();
/*  5127 */     closeStatements(false);
/*       */     try
/*       */     {
/*  5132 */       doProxySession(paramInt, paramProperties);
/*  5133 */       this.dci += 1;
/*       */ 
/*  5143 */       this.savedAutoCommitFlag = this.autocommit;
/*  5144 */       this.autocommit = this.defaultautocommit;
/*  5145 */       this.savedTxnMode = this.txnMode;
/*  5146 */       this.txnMode = 0;
/*  5147 */       i = 0;
/*       */ 
/*  5152 */       if (i == 1)
/*  5153 */         closeProxySession();
/*       */     }
/*       */     finally
/*       */     {
/*  5152 */       if (i == 1)
/*  5153 */         closeProxySession();
/*       */     }
/*       */   }
/*       */ 
/*       */   void doProxySession(int paramInt, Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/*  5164 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  5165 */     localSQLException.fillInStackTrace();
/*  5166 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void cleanup()
/*       */   {
/*  5176 */     this.fdo = null;
/*  5177 */     this.conversion = null;
/*  5178 */     this.statements = null;
/*  5179 */     this.descriptorCacheStack[this.dci] = null;
/*  5180 */     this.map = null;
/*  5181 */     this.javaObjectMap = null;
/*  5182 */     this.statementHoldingLine = null;
/*  5183 */     this.sqlObj = null;
/*  5184 */     this.isProxy = false;
/*  5185 */     this.blockSource = null;
/*  5186 */     this.connectionBufferCacheStore = null;
/*  5187 */     threadLocalBufferCacheStore = null;
/*       */   }
/*       */ 
/*       */   public synchronized DatabaseMetaData getMetaData()
/*       */     throws SQLException
/*       */   {
/*  5209 */     if (this.lifecycle != 1)
/*       */     {
/*  5211 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5212 */       localSQLException.fillInStackTrace();
/*  5213 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5216 */     if (this.databaseMetaData == null) {
/*  5217 */       this.databaseMetaData = new OracleDatabaseMetaData(this);
/*       */     }
/*  5219 */     return this.databaseMetaData;
/*       */   }
/*       */ 
/*       */   public void setReadOnly(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5241 */     if (this.lifecycle != 1)
/*       */     {
/*  5243 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5244 */       localSQLException.fillInStackTrace();
/*  5245 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5248 */     this.readOnly = paramBoolean;
/*       */   }
/*       */ 
/*       */   public boolean isReadOnly()
/*       */     throws SQLException
/*       */   {
/*  5268 */     if (this.lifecycle != 1)
/*       */     {
/*  5270 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5271 */       localSQLException.fillInStackTrace();
/*  5272 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5276 */     return this.readOnly;
/*       */   }
/*       */ 
/*       */   public void setCatalog(String paramString)
/*       */     throws SQLException
/*       */   {
/*  5293 */     if (this.lifecycle != 1)
/*       */     {
/*  5295 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5296 */       localSQLException.fillInStackTrace();
/*  5297 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public String getCatalog()
/*       */     throws SQLException
/*       */   {
/*  5316 */     if (this.lifecycle != 1)
/*       */     {
/*  5318 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5319 */       localSQLException.fillInStackTrace();
/*  5320 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5323 */     return null;
/*       */   }
/*       */ 
/*       */   public synchronized void setTransactionIsolation(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5338 */     if (this.lifecycle != 1)
/*       */     {
/*  5340 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5341 */       ((SQLException)localObject1).fillInStackTrace();
/*  5342 */       throw ((Throwable)localObject1);
/*       */     }
/*       */ 
/*  5345 */     if (this.txnLevel == paramInt) {
/*  5346 */       return;
/*       */     }
/*  5348 */     Object localObject1 = createStatement();
/*       */     try
/*       */     {
/*  5352 */       switch (paramInt)
/*       */       {
/*       */       case 2:
/*  5357 */         ((Statement)localObject1).execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
/*       */ 
/*  5359 */         this.txnLevel = 2;
/*       */ 
/*  5361 */         break;
/*       */       case 8:
/*  5366 */         ((Statement)localObject1).execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
/*       */ 
/*  5368 */         this.txnLevel = 8;
/*       */ 
/*  5370 */         break;
/*       */       default:
/*  5375 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 30);
/*  5376 */         localSQLException.fillInStackTrace();
/*  5377 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */     }
/*       */     finally
/*       */     {
/*  5385 */       ((Statement)localObject1).close();
/*       */     }
/*       */   }
/*       */ 
/*       */   public int getTransactionIsolation()
/*       */     throws SQLException
/*       */   {
/*  5400 */     if (this.lifecycle != 1)
/*       */     {
/*  5402 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5403 */       localSQLException.fillInStackTrace();
/*  5404 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5407 */     return this.txnLevel;
/*       */   }
/*       */ 
/*       */   public synchronized void setAutoClose(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5425 */     if (!paramBoolean)
/*       */     {
/*  5427 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 31);
/*  5428 */       localSQLException.fillInStackTrace();
/*  5429 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public boolean getAutoClose()
/*       */     throws SQLException
/*       */   {
/*  5446 */     return true;
/*       */   }
/*       */ 
/*       */   public SQLWarning getWarnings()
/*       */     throws SQLException
/*       */   {
/*  5462 */     if (this.lifecycle != 1)
/*       */     {
/*  5464 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5465 */       localSQLException.fillInStackTrace();
/*  5466 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5469 */     return this.sqlWarning;
/*       */   }
/*       */ 
/*       */   public void clearWarnings()
/*       */     throws SQLException
/*       */   {
/*  5482 */     if (this.lifecycle != 1)
/*       */     {
/*  5484 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  5485 */       localSQLException.fillInStackTrace();
/*  5486 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5489 */     this.sqlWarning = null;
/*       */   }
/*       */ 
/*       */   void setWarnings(SQLWarning paramSQLWarning)
/*       */   {
/*  5496 */     this.sqlWarning = paramSQLWarning;
/*       */   }
/*       */ 
/*       */   public void setDefaultRowPrefetch(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5545 */     if (paramInt <= 0)
/*       */     {
/*  5547 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 20);
/*  5548 */       localSQLException.fillInStackTrace();
/*  5549 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5552 */     this.defaultRowPrefetch = paramInt;
/*       */   }
/*       */ 
/*       */   public int getDefaultRowPrefetch()
/*       */   {
/*  5584 */     return this.defaultRowPrefetch;
/*       */   }
/*       */ 
/*       */   public boolean getTimestamptzInGmt()
/*       */   {
/*  5596 */     return this.timestamptzInGmt;
/*       */   }
/*       */ 
/*       */   public boolean getUse1900AsYearForTime()
/*       */   {
/*  5608 */     return this.use1900AsYearForTime;
/*       */   }
/*       */ 
/*       */   public synchronized void setDefaultExecuteBatch(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5655 */     if (paramInt <= 0)
/*       */     {
/*  5657 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 42);
/*  5658 */       localSQLException.fillInStackTrace();
/*  5659 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5662 */     this.defaultExecuteBatch = paramInt;
/*       */   }
/*       */ 
/*       */   public synchronized int getDefaultExecuteBatch()
/*       */   {
/*  5695 */     return this.defaultExecuteBatch;
/*       */   }
/*       */ 
/*       */   public synchronized void setRemarksReporting(boolean paramBoolean)
/*       */   {
/*  5723 */     this.reportRemarks = paramBoolean;
/*       */   }
/*       */ 
/*       */   public synchronized boolean getRemarksReporting()
/*       */   {
/*  5741 */     return this.reportRemarks;
/*       */   }
/*       */ 
/*       */   public void setIncludeSynonyms(boolean paramBoolean)
/*       */   {
/*  5767 */     this.includeSynonyms = paramBoolean;
/*       */   }
/*       */ 
/*       */   public synchronized String[] getEndToEndMetrics()
/*       */     throws SQLException
/*       */   {
/*       */     String[] arrayOfString;
/*  5786 */     if (this.endToEndValues == null)
/*       */     {
/*  5788 */       arrayOfString = null;
/*       */     }
/*       */     else
/*       */     {
/*  5792 */       arrayOfString = new String[4];
/*       */ 
/*  5794 */       System.arraycopy(this.endToEndValues, 0, arrayOfString, 0, 4);
/*       */     }
/*  5796 */     return arrayOfString;
/*       */   }
/*       */ 
/*       */   public short getEndToEndECIDSequenceNumber()
/*       */     throws SQLException
/*       */   {
/*  5819 */     return this.endToEndECIDSequenceNumber;
/*       */   }
/*       */ 
/*       */   public synchronized void setEndToEndMetrics(String[] paramArrayOfString, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  5839 */     String[] arrayOfString = new String[paramArrayOfString.length];
/*       */ 
/*  5841 */     System.arraycopy(paramArrayOfString, 0, arrayOfString, 0, paramArrayOfString.length);
/*  5842 */     setEndToEndMetricsInternal(arrayOfString, paramShort);
/*       */   }
/*       */ 
/*       */   void setEndToEndMetricsInternal(String[] paramArrayOfString, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  5857 */     if (paramArrayOfString != this.endToEndValues) {
/*  5858 */       if (paramArrayOfString.length != 4)
/*       */       {
/*  5860 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 156);
/*  5861 */         localSQLException1.fillInStackTrace();
/*  5862 */         throw localSQLException1;
/*       */       }
/*       */       String str;
/*  5866 */       for (int i = 0; i < 4; i++) {
/*  5867 */         str = paramArrayOfString[i];
/*  5868 */         if ((str != null) && (str.length() > this.endToEndMaxLength[i]))
/*       */         {
/*  5870 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, str);
/*  5871 */           localSQLException2.fillInStackTrace();
/*  5872 */           throw localSQLException2;
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/*  5877 */       if (this.endToEndValues != null) {
/*  5878 */         for (i = 0; i < 4; i++) {
/*  5879 */           str = paramArrayOfString[i];
/*       */ 
/*  5881 */           if (((str == null) && (this.endToEndValues[i] != null)) || ((str != null) && (!str.equals(this.endToEndValues[i]))))
/*       */           {
/*  5883 */             this.endToEndHasChanged[i] = true;
/*  5884 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*  5889 */         this.endToEndHasChanged[0] |= this.endToEndHasChanged[3];
/*       */       }
/*       */       else
/*       */       {
/*  5893 */         for (i = 0; i < 4; i++) {
/*  5894 */           this.endToEndHasChanged[i] = true;
/*       */         }
/*  5896 */         this.endToEndAnyChanged = true;
/*       */       }
/*  5898 */       System.arraycopy(paramArrayOfString, 0, this.endToEndValues, 0, 4);
/*       */ 
/*  5900 */       for (i = 0; i < 4; i++) {
/*  5901 */         if (paramArrayOfString[i] == null) this.clientInfo.remove(END_TO_END_CLIENTINFO_KEYS[i]); else {
/*  5902 */           this.clientInfo.put(END_TO_END_CLIENTINFO_KEYS[i], paramArrayOfString[i]);
/*       */         }
/*       */       }
/*       */     }
/*  5906 */     this.endToEndECIDSequenceNumber = paramShort;
/*  5907 */     this.clientInfo.put("OCSID.SEQUENCE_NUMBER", Short.toString(paramShort));
/*       */   }
/*       */ 
/*       */   void updateSystemContext()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   void resetSystemContext()
/*       */   {
/*       */   }
/*       */ 
/*       */   void updateSystemContext11()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public boolean getIncludeSynonyms()
/*       */   {
/*  5971 */     return this.includeSynonyms;
/*       */   }
/*       */ 
/*       */   public void setRestrictGetTables(boolean paramBoolean)
/*       */   {
/*  6017 */     this.restrictGettables = paramBoolean;
/*       */   }
/*       */ 
/*       */   public boolean getRestrictGetTables()
/*       */   {
/*  6038 */     return this.restrictGettables;
/*       */   }
/*       */ 
/*       */   public void setDefaultFixedString(boolean paramBoolean)
/*       */   {
/*  6072 */     this.fixedString = paramBoolean;
/*       */   }
/*       */ 
/*       */   void setDefaultNChar(boolean paramBoolean)
/*       */   {
/*  6086 */     this.defaultnchar = paramBoolean;
/*       */   }
/*       */ 
/*       */   public boolean getDefaultFixedString()
/*       */   {
/*  6119 */     return this.fixedString;
/*       */   }
/*       */ 
/*       */   int getNlsRatio()
/*       */   {
/*  6132 */     return 1;
/*       */   }
/*       */ 
/*       */   public int getC2SNlsRatio()
/*       */   {
/*  6144 */     return 1;
/*       */   }
/*       */ 
/*       */   synchronized void addStatement(OracleStatement paramOracleStatement)
/*       */   {
/*  6153 */     if (paramOracleStatement.next != null) {
/*  6154 */       throw new Error("add_statement called twice on " + paramOracleStatement);
/*       */     }
/*  6156 */     paramOracleStatement.next = this.statements;
/*       */ 
/*  6158 */     if (this.statements != null) {
/*  6159 */       this.statements.prev = paramOracleStatement;
/*       */     }
/*  6161 */     this.statements = paramOracleStatement;
/*       */   }
/*       */ 
/*       */   synchronized void removeStatement(OracleStatement paramOracleStatement)
/*       */   {
/*  6180 */     OracleStatement localOracleStatement1 = paramOracleStatement.prev;
/*  6181 */     OracleStatement localOracleStatement2 = paramOracleStatement.next;
/*       */ 
/*  6183 */     if (localOracleStatement1 == null)
/*       */     {
/*  6185 */       if (this.statements != paramOracleStatement) {
/*  6186 */         return;
/*       */       }
/*  6188 */       this.statements = localOracleStatement2;
/*       */     }
/*       */     else {
/*  6191 */       localOracleStatement1.next = localOracleStatement2;
/*       */     }
/*  6193 */     if (localOracleStatement2 != null) {
/*  6194 */       localOracleStatement2.prev = localOracleStatement1;
/*       */     }
/*  6196 */     paramOracleStatement.next = null;
/*  6197 */     paramOracleStatement.prev = null;
/*       */   }
/*       */ 
/*       */   synchronized void closeStatements(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  6219 */     Object localObject = this.statements;
/*       */     OracleStatement localOracleStatement;
/*  6221 */     while (localObject != null)
/*       */     {
/*  6223 */       localOracleStatement = ((OracleStatement)localObject).nextChild;
/*       */ 
/*  6225 */       if (((OracleStatement)localObject).serverCursor)
/*       */       {
/*  6227 */         ((OracleStatement)localObject).close();
/*  6228 */         removeStatement((OracleStatement)localObject);
/*       */       }
/*       */ 
/*  6231 */       localObject = localOracleStatement;
/*       */     }
/*       */ 
/*  6235 */     localObject = this.statements;
/*       */ 
/*  6237 */     while (localObject != null)
/*       */     {
/*  6239 */       localOracleStatement = ((OracleStatement)localObject).next;
/*       */ 
/*  6241 */       if (paramBoolean) {
/*  6242 */         ((OracleStatement)localObject).close();
/*       */       } else {
/*  6244 */         ((OracleStatement)localObject).hardClose();
/*  6245 */         ((OracleStatement)localObject).closeWrapper();
/*  6246 */       }removeStatement((OracleStatement)localObject);
/*       */ 
/*  6248 */       localObject = localOracleStatement;
/*       */     }
/*       */   }
/*       */ 
/*       */   final void purgeStatementCache()
/*       */     throws SQLException
/*       */   {
/*  6259 */     if (isStatementCacheInitialized())
/*       */     {
/*  6261 */       this.statementCache.purgeImplicitCache();
/*  6262 */       this.statementCache.purgeExplicitCache();
/*       */     }
/*       */   }
/*       */ 
/*       */   final void closeStatementCache()
/*       */     throws SQLException
/*       */   {
/*  6272 */     if (isStatementCacheInitialized())
/*       */     {
/*  6276 */       this.statementCache.close();
/*       */ 
/*  6278 */       this.statementCache = null;
/*  6279 */       this.clearStatementMetaData = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   void needLine()
/*       */     throws SQLException
/*       */   {
/*  6288 */     if (this.lifecycle != 1)
/*       */     {
/*  6290 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6291 */       localSQLException.fillInStackTrace();
/*  6292 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6295 */     needLineUnchecked();
/*       */   }
/*       */ 
/*       */   synchronized void needLineUnchecked()
/*       */     throws SQLException
/*       */   {
/*  6305 */     if (this.statementHoldingLine != null)
/*       */     {
/*  6307 */       this.statementHoldingLine.freeLine();
/*       */     }
/*       */   }
/*       */ 
/*       */   synchronized void holdLine(oracle.jdbc.internal.OracleStatement paramOracleStatement)
/*       */   {
/*  6315 */     holdLine((OracleStatement)paramOracleStatement);
/*       */   }
/*       */ 
/*       */   synchronized void holdLine(OracleStatement paramOracleStatement)
/*       */   {
/*  6324 */     this.statementHoldingLine = paramOracleStatement;
/*       */   }
/*       */ 
/*       */   synchronized void releaseLine()
/*       */   {
/*  6332 */     releaseLineForCancel();
/*       */   }
/*       */ 
/*       */   void releaseLineForCancel()
/*       */   {
/*  6341 */     this.statementHoldingLine = null;
/*       */   }
/*       */ 
/*       */   public synchronized void startup(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  6354 */     if (this.lifecycle != 1)
/*       */     {
/*  6356 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6357 */       localSQLException.fillInStackTrace();
/*  6358 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6362 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  6363 */     localSQLException.fillInStackTrace();
/*  6364 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void startup(OracleConnection.DatabaseStartupMode paramDatabaseStartupMode)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  6377 */     if (this.lifecycle != 1)
/*       */     {
/*  6379 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6380 */       localSQLException.fillInStackTrace();
/*  6381 */       throw localSQLException;
/*       */     }
/*  6383 */     if (paramDatabaseStartupMode == null)
/*       */     {
/*  6385 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6386 */       localSQLException.fillInStackTrace();
/*  6387 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6390 */     needLine();
/*  6391 */     doStartup(paramDatabaseStartupMode.getMode());
/*       */   }
/*       */ 
/*       */   void doStartup(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  6400 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  6401 */     localSQLException.fillInStackTrace();
/*  6402 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void shutdown(OracleConnection.DatabaseShutdownMode paramDatabaseShutdownMode)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  6416 */     if (this.lifecycle != 1)
/*       */     {
/*  6418 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6419 */       localSQLException.fillInStackTrace();
/*  6420 */       throw localSQLException;
/*       */     }
/*  6422 */     if (paramDatabaseShutdownMode == null)
/*       */     {
/*  6424 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6425 */       localSQLException.fillInStackTrace();
/*  6426 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6429 */     needLine();
/*  6430 */     doShutdown(paramDatabaseShutdownMode.getMode());
/*       */   }
/*       */ 
/*       */   void doShutdown(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  6439 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  6440 */     localSQLException.fillInStackTrace();
/*  6441 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void archive(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6457 */     if (this.lifecycle != 1)
/*       */     {
/*  6459 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6460 */       localSQLException.fillInStackTrace();
/*  6461 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6465 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  6466 */     localSQLException.fillInStackTrace();
/*  6467 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized void registerSQLType(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  6486 */     if ((paramString1 == null) || (paramString2 == null))
/*       */     {
/*  6488 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6489 */       localSQLException1.fillInStackTrace();
/*  6490 */       throw localSQLException1;
/*       */     }
/*       */ 
/*       */     try
/*       */     {
/*  6495 */       registerSQLType(paramString1, Class.forName(paramString2));
/*       */     }
/*       */     catch (ClassNotFoundException localClassNotFoundException)
/*       */     {
/*  6500 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Class not found: " + paramString2);
/*  6501 */       localSQLException2.fillInStackTrace();
/*  6502 */       throw localSQLException2;
/*       */     }
/*       */   }
/*       */ 
/*       */   public synchronized void registerSQLType(String paramString, Class paramClass)
/*       */     throws SQLException
/*       */   {
/*  6518 */     if ((paramString == null) || (paramClass == null))
/*       */     {
/*  6520 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6521 */       localSQLException.fillInStackTrace();
/*  6522 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6525 */     if (this.map == null) this.map = new Hashtable(10);
/*       */ 
/*  6527 */     this.map.put(paramString, paramClass);
/*  6528 */     this.map.put(paramClass.getName(), paramString);
/*       */   }
/*       */ 
/*       */   public synchronized String getSQLType(Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  6541 */     if ((paramObject != null) && (this.map != null))
/*       */     {
/*  6543 */       String str = paramObject.getClass().getName();
/*       */ 
/*  6545 */       return (String)this.map.get(str);
/*       */     }
/*       */ 
/*  6548 */     return null;
/*       */   }
/*       */ 
/*       */   public synchronized Object getJavaObject(String paramString)
/*       */     throws SQLException
/*       */   {
/*  6561 */     Object localObject = null;
/*       */     try
/*       */     {
/*  6565 */       if ((paramString != null) && (this.map != null))
/*       */       {
/*  6567 */         Class localClass = (Class)this.map.get(paramString);
/*       */ 
/*  6569 */         localObject = localClass.newInstance();
/*       */       }
/*       */     }
/*       */     catch (IllegalAccessException localIllegalAccessException)
/*       */     {
/*  6574 */       localIllegalAccessException.printStackTrace();
/*       */     }
/*       */     catch (InstantiationException localInstantiationException)
/*       */     {
/*  6578 */       localInstantiationException.printStackTrace();
/*       */     }
/*       */ 
/*  6581 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized void putDescriptor(String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  6594 */     if ((paramString != null) && (paramObject != null))
/*       */     {
/*  6596 */       if (this.descriptorCacheStack[this.dci] == null) {
/*  6597 */         this.descriptorCacheStack[this.dci] = new Hashtable(10);
/*       */       }
/*  6599 */       ((TypeDescriptor)paramObject).fixupConnection(this);
/*  6600 */       this.descriptorCacheStack[this.dci].put(paramString, paramObject);
/*       */     }
/*       */     else
/*       */     {
/*  6604 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6605 */       localSQLException.fillInStackTrace();
/*  6606 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public synchronized Object getDescriptor(String paramString)
/*       */   {
/*  6618 */     Object localObject = null;
/*       */ 
/*  6620 */     if (paramString != null) {
/*  6621 */       if (this.descriptorCacheStack[this.dci] != null)
/*  6622 */         localObject = this.descriptorCacheStack[this.dci].get(paramString);
/*  6623 */       if ((localObject == null) && (this.dci == 1) && (this.descriptorCacheStack[0] != null)) {
/*  6624 */         localObject = this.descriptorCacheStack[0].get(paramString);
/*       */       }
/*       */     }
/*  6627 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized void removeDescriptor(String paramString)
/*       */   {
/*  6640 */     if ((paramString != null) && (this.descriptorCacheStack[this.dci] != null))
/*  6641 */       this.descriptorCacheStack[this.dci].remove(paramString);
/*  6642 */     if ((paramString != null) && (this.dci == 1) && (this.descriptorCacheStack[0] != null))
/*  6643 */       this.descriptorCacheStack[0].remove(paramString);
/*       */   }
/*       */ 
/*       */   public synchronized void removeAllDescriptor()
/*       */   {
/*  6655 */     for (int i = 0; i <= this.dci; i++)
/*  6656 */       if (this.descriptorCacheStack[i] != null)
/*  6657 */         this.descriptorCacheStack[i].clear();
/*       */   }
/*       */ 
/*       */   public int numberOfDescriptorCacheEntries()
/*       */   {
/*  6674 */     int i = 0;
/*  6675 */     for (int j = 0; j <= this.dci; j++) {
/*  6676 */       if (this.descriptorCacheStack[j] != null)
/*  6677 */         i += this.descriptorCacheStack[j].size();
/*       */     }
/*  6679 */     return i;
/*       */   }
/*       */ 
/*       */   public Enumeration descriptorCacheKeys()
/*       */   {
/*  6692 */     if (this.dci == 0) {
/*  6693 */       if (this.descriptorCacheStack[this.dci] != null) {
/*  6694 */         return this.descriptorCacheStack[this.dci].keys();
/*       */       }
/*  6696 */       return null;
/*       */     }
/*  6698 */     if ((this.descriptorCacheStack[0] == null) && (this.descriptorCacheStack[1] != null))
/*  6699 */       return this.descriptorCacheStack[1].keys();
/*  6700 */     if ((this.descriptorCacheStack[1] == null) && (this.descriptorCacheStack[0] != null))
/*  6701 */       return this.descriptorCacheStack[0].keys();
/*  6702 */     if ((this.descriptorCacheStack[0] == null) && (this.descriptorCacheStack[1] == null)) {
/*  6703 */       return null;
/*       */     }
/*  6705 */     Vector localVector = new Vector(this.descriptorCacheStack[1].keySet());
/*  6706 */     localVector.addAll(this.descriptorCacheStack[0].keySet());
/*  6707 */     return localVector.elements();
/*       */   }
/*       */ 
/*       */   public synchronized void putDescriptor(byte[] paramArrayOfByte, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  6721 */     if ((paramArrayOfByte != null) && (paramObject != null))
/*       */     {
/*  6723 */       if (this.descriptorCacheStack[this.dci] == null) {
/*  6724 */         this.descriptorCacheStack[this.dci] = new Hashtable(10);
/*       */       }
/*  6726 */       this.descriptorCacheStack[this.dci].put(new ByteArrayKey(paramArrayOfByte), paramObject);
/*       */     }
/*       */     else
/*       */     {
/*  6730 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6731 */       localSQLException.fillInStackTrace();
/*  6732 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public synchronized Object getDescriptor(byte[] paramArrayOfByte)
/*       */   {
/*  6744 */     Object localObject = null;
/*       */ 
/*  6746 */     if (paramArrayOfByte != null) {
/*  6747 */       ByteArrayKey localByteArrayKey = new ByteArrayKey(paramArrayOfByte);
/*  6748 */       if (this.descriptorCacheStack[this.dci] != null)
/*  6749 */         localObject = this.descriptorCacheStack[this.dci].get(localByteArrayKey);
/*  6750 */       if ((localObject == null) && (this.dci == 1) && (this.descriptorCacheStack[0] != null)) {
/*  6751 */         localObject = this.descriptorCacheStack[0].get(localByteArrayKey);
/*       */       }
/*       */     }
/*  6754 */     return localObject;
/*       */   }
/*       */ 
/*       */   public short getJdbcCsId()
/*       */     throws SQLException
/*       */   {
/*  6775 */     if (this.conversion == null)
/*       */     {
/*  6778 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 65);
/*  6779 */       localSQLException.fillInStackTrace();
/*  6780 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6784 */     return this.conversion.getClientCharSet();
/*       */   }
/*       */ 
/*       */   public short getDbCsId()
/*       */     throws SQLException
/*       */   {
/*  6804 */     if (this.conversion == null)
/*       */     {
/*  6807 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 65);
/*  6808 */       localSQLException.fillInStackTrace();
/*  6809 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6813 */     return this.conversion.getServerCharSetId();
/*       */   }
/*       */ 
/*       */   short getNCsId()
/*       */     throws SQLException
/*       */   {
/*  6820 */     if (this.conversion == null)
/*       */     {
/*  6823 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 65);
/*  6824 */       localSQLException.fillInStackTrace();
/*  6825 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6829 */     return this.conversion.getNCharSetId();
/*       */   }
/*       */ 
/*       */   public short getStructAttrCsId()
/*       */     throws SQLException
/*       */   {
/*  6850 */     return getDbCsId();
/*       */   }
/*       */ 
/*       */   public short getStructAttrNCsId()
/*       */     throws SQLException
/*       */   {
/*  6862 */     return getNCsId();
/*       */   }
/*       */ 
/*       */   public synchronized Map getTypeMap()
/*       */     throws SQLException
/*       */   {
/*  6873 */     if (this.map == null) {
/*  6874 */       this.map = new Hashtable(10);
/*       */     }
/*  6876 */     return this.map;
/*       */   }
/*       */ 
/*       */   public synchronized void setTypeMap(Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  6889 */     if (this.lifecycle != 1)
/*       */     {
/*  6891 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  6892 */       localSQLException.fillInStackTrace();
/*  6893 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6896 */     this.map = paramMap;
/*       */   }
/*       */ 
/*       */   public synchronized void setUsingXAFlag(boolean paramBoolean)
/*       */   {
/*  6909 */     this.usingXA = paramBoolean;
/*       */   }
/*       */ 
/*       */   public synchronized boolean getUsingXAFlag()
/*       */   {
/*  6921 */     return this.usingXA;
/*       */   }
/*       */ 
/*       */   public synchronized void setXAErrorFlag(boolean paramBoolean)
/*       */   {
/*  6934 */     this.xaWantsError = paramBoolean;
/*       */   }
/*       */ 
/*       */   public synchronized boolean getXAErrorFlag()
/*       */   {
/*  6946 */     return this.xaWantsError;
/*       */   }
/*       */ 
/*       */   String getPropertyFromDatabase(String paramString)
/*       */     throws SQLException
/*       */   {
/*  6954 */     String str = null;
/*  6955 */     Statement localStatement = null;
/*  6956 */     ResultSet localResultSet = null;
/*  6957 */     beginNonRequestCalls();
/*       */     try
/*       */     {
/*  6960 */       localStatement = createStatement();
/*  6961 */       localStatement.setFetchSize(1);
/*  6962 */       localResultSet = localStatement.executeQuery(paramString);
/*  6963 */       if (localResultSet.next())
/*  6964 */         str = localResultSet.getString(1);
/*       */     }
/*       */     finally
/*       */     {
/*  6968 */       if (localResultSet != null)
/*  6969 */         localResultSet.close();
/*  6970 */       if (localStatement != null) {
/*  6971 */         localStatement.close();
/*       */       }
/*       */ 
/*  6976 */       endNonRequestCalls();
/*       */     }
/*  6978 */     return str;
/*       */   }
/*       */ 
/*       */   public synchronized String getUserName()
/*       */     throws SQLException
/*       */   {
/*  6991 */     if (this.userName == null) {
/*  6992 */       this.userName = getPropertyFromDatabase("SELECT USER FROM DUAL");
/*       */     }
/*  6994 */     return this.userName;
/*       */   }
/*       */ 
/*       */   public String getCurrentSchema()
/*       */     throws SQLException
/*       */   {
/*  7014 */     return getPropertyFromDatabase("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL");
/*       */   }
/*       */ 
/*       */   public String getDefaultSchemaNameForNamedTypes()
/*       */     throws SQLException
/*       */   {
/*  7037 */     String str = null;
/*       */ 
/*  7039 */     if (this.createDescriptorUseCurrentSchemaForSchemaName)
/*  7040 */       str = getCurrentSchema();
/*       */     else {
/*  7042 */       str = getUserName();
/*       */     }
/*  7044 */     return str;
/*       */   }
/*       */ 
/*       */   public synchronized void setStartTime(long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7067 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  7068 */     localSQLException.fillInStackTrace();
/*  7069 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized long getStartTime()
/*       */     throws SQLException
/*       */   {
/*  7085 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  7086 */     localSQLException.fillInStackTrace();
/*  7087 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void registerHeartbeat()
/*       */     throws SQLException
/*       */   {
/*  7100 */     if (this.logicalConnectionAttached != null)
/*  7101 */       this.logicalConnectionAttached.registerHeartbeat();
/*       */   }
/*       */ 
/*       */   public int getHeartbeatNoChangeCount()
/*       */     throws SQLException
/*       */   {
/*  7113 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 152);
/*  7114 */     localSQLException.fillInStackTrace();
/*  7115 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public synchronized byte[] getFDO(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  7127 */     if ((this.fdo == null) && (paramBoolean)) {
/*  7128 */       CallableStatement localCallableStatement = null;
/*  7129 */       beginNonRequestCalls();
/*       */       try {
/*  7131 */         localCallableStatement = prepareCall("begin :1 := dbms_pickler.get_format (:2); end;");
/*       */ 
/*  7134 */         localCallableStatement.registerOutParameter(1, 2);
/*  7135 */         localCallableStatement.registerOutParameter(2, -4);
/*  7136 */         localCallableStatement.execute();
/*       */ 
/*  7138 */         this.fdo = localCallableStatement.getBytes(2);
/*       */       }
/*       */       finally {
/*  7141 */         if (localCallableStatement != null) {
/*  7142 */           localCallableStatement.close();
/*       */         }
/*  7144 */         localCallableStatement = null;
/*       */ 
/*  7149 */         endNonRequestCalls();
/*       */       }
/*       */     }
/*       */ 
/*  7153 */     return this.fdo;
/*       */   }
/*       */ 
/*       */   public synchronized void setFDO(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7164 */     this.fdo = paramArrayOfByte;
/*       */   }
/*       */ 
/*       */   public synchronized boolean getBigEndian()
/*       */     throws SQLException
/*       */   {
/*  7175 */     if (this.bigEndian == null)
/*       */     {
/*  7177 */       int[] arrayOfInt = Util.toJavaUnsignedBytes(getFDO(true));
/*       */ 
/*  7181 */       int i = arrayOfInt[(6 + arrayOfInt[5] + arrayOfInt[6] + 5)];
/*       */ 
/*  7186 */       int j = (byte)(i & 0x10);
/*       */ 
/*  7188 */       if (j < 0) {
/*  7189 */         j += 256;
/*       */       }
/*  7191 */       if (j > 0)
/*  7192 */         this.bigEndian = Boolean.TRUE;
/*       */       else {
/*  7194 */         this.bigEndian = Boolean.FALSE;
/*       */       }
/*       */     }
/*  7197 */     return this.bigEndian.booleanValue();
/*       */   }
/*       */ 
/*       */   public void setHoldability(int paramInt)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  7231 */     if (this.lifecycle != 1)
/*       */     {
/*  7233 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  7234 */       localSQLException.fillInStackTrace();
/*  7235 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7238 */     if (!getMetaData().supportsResultSetHoldability(paramInt))
/*       */     {
/*  7240 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 162);
/*  7241 */       localSQLException.fillInStackTrace();
/*  7242 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public int getHoldability()
/*       */     throws SQLException
/*       */   {
/*  7275 */     if (this.lifecycle != 1)
/*       */     {
/*  7277 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  7278 */       localSQLException.fillInStackTrace();
/*  7279 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7282 */     return 1;
/*       */   }
/*       */ 
/*       */   public synchronized Savepoint setSavepoint()
/*       */     throws SQLException
/*       */   {
/*  7296 */     return oracleSetSavepoint();
/*       */   }
/*       */ 
/*       */   public synchronized Savepoint setSavepoint(String paramString)
/*       */     throws SQLException
/*       */   {
/*  7311 */     return oracleSetSavepoint(paramString);
/*       */   }
/*       */ 
/*       */   public synchronized void rollback(Savepoint paramSavepoint)
/*       */     throws SQLException
/*       */   {
/*  7327 */     disallowGlobalTxnMode(115);
/*       */ 
/*  7330 */     if (this.autocommit)
/*       */     {
/*  7332 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 121);
/*  7333 */       ((SQLException)localObject).fillInStackTrace();
/*  7334 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7339 */     if (this.savepointStatement == null)
/*       */     {
/*  7341 */       this.savepointStatement = createStatement();
/*       */     }
/*       */ 
/*  7344 */     Object localObject = null;
/*  7345 */     if (paramSavepoint != null)
/*       */     {
/*       */       try
/*       */       {
/*  7349 */         localObject = paramSavepoint.getSavepointName();
/*       */       }
/*       */       catch (SQLException localSQLException)
/*       */       {
/*  7353 */         localObject = "ORACLE_SVPT_" + paramSavepoint.getSavepointId();
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  7358 */     this.savepointStatement.executeUpdate("ROLLBACK TO " + (String)localObject);
/*       */   }
/*       */ 
/*       */   public synchronized void releaseSavepoint(Savepoint paramSavepoint)
/*       */     throws SQLException
/*       */   {
/*  7373 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  7374 */     localSQLException.fillInStackTrace();
/*  7375 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Statement createStatement(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  7426 */     if (!getMetaData().supportsResultSetHoldability(paramInt3))
/*       */     {
/*  7428 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 162);
/*  7429 */       localSQLException.fillInStackTrace();
/*  7430 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7433 */     return createStatement(paramInt1, paramInt2);
/*       */   }
/*       */ 
/*       */   public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  7489 */     if (!getMetaData().supportsResultSetHoldability(paramInt3))
/*       */     {
/*  7491 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 162);
/*  7492 */       localSQLException.fillInStackTrace();
/*  7493 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7496 */     return prepareStatement(paramString, paramInt1, paramInt2);
/*       */   }
/*       */ 
/*       */   public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  7550 */     if (!getMetaData().supportsResultSetHoldability(paramInt3))
/*       */     {
/*  7552 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 162);
/*  7553 */       localSQLException.fillInStackTrace();
/*  7554 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7557 */     return prepareCall(paramString, paramInt1, paramInt2);
/*       */   }
/*       */ 
/*       */   public PreparedStatement prepareStatement(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  7612 */     AutoKeyInfo localAutoKeyInfo = new AutoKeyInfo(paramString);
/*  7613 */     if ((paramInt == 2) || (!localAutoKeyInfo.isInsertSqlStmt()))
/*       */     {
/*  7615 */       return prepareStatement(paramString);
/*       */     }
/*  7617 */     if (paramInt != 1)
/*       */     {
/*  7619 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  7620 */       ((SQLException)localObject).fillInStackTrace();
/*  7621 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7624 */     Object localObject = localAutoKeyInfo.getNewSql();
/*  7625 */     oracle.jdbc.OraclePreparedStatement localOraclePreparedStatement = (oracle.jdbc.OraclePreparedStatement)prepareStatement((String)localObject);
/*  7626 */     OraclePreparedStatement localOraclePreparedStatement1 = (OraclePreparedStatement)((OraclePreparedStatementWrapper)localOraclePreparedStatement).preparedStatement;
/*       */ 
/*  7628 */     localOraclePreparedStatement1.isAutoGeneratedKey = true;
/*  7629 */     localOraclePreparedStatement1.autoKeyInfo = localAutoKeyInfo;
/*  7630 */     localOraclePreparedStatement1.registerReturnParamsForAutoKey();
/*  7631 */     return localOraclePreparedStatement;
/*       */   }
/*       */ 
/*       */   public PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt)
/*       */     throws SQLException
/*       */   {
/*  7685 */     AutoKeyInfo localAutoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfInt);
/*       */ 
/*  7687 */     if (!localAutoKeyInfo.isInsertSqlStmt()) return prepareStatement(paramString);
/*       */ 
/*  7689 */     if ((paramArrayOfInt == null) || (paramArrayOfInt.length == 0))
/*       */     {
/*  7691 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  7692 */       ((SQLException)localObject).fillInStackTrace();
/*  7693 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7698 */     doDescribeTable(localAutoKeyInfo);
/*       */ 
/*  7700 */     Object localObject = localAutoKeyInfo.getNewSql();
/*  7701 */     oracle.jdbc.OraclePreparedStatement localOraclePreparedStatement = (oracle.jdbc.OraclePreparedStatement)prepareStatement((String)localObject);
/*  7702 */     OraclePreparedStatement localOraclePreparedStatement1 = (OraclePreparedStatement)((OraclePreparedStatementWrapper)localOraclePreparedStatement).preparedStatement;
/*       */ 
/*  7704 */     localOraclePreparedStatement1.isAutoGeneratedKey = true;
/*  7705 */     localOraclePreparedStatement1.autoKeyInfo = localAutoKeyInfo;
/*  7706 */     localOraclePreparedStatement1.registerReturnParamsForAutoKey();
/*  7707 */     return localOraclePreparedStatement;
/*       */   }
/*       */ 
/*       */   public PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString)
/*       */     throws SQLException
/*       */   {
/*  7762 */     AutoKeyInfo localAutoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfString);
/*  7763 */     if (!localAutoKeyInfo.isInsertSqlStmt()) return prepareStatement(paramString);
/*       */ 
/*  7765 */     if ((paramArrayOfString == null) || (paramArrayOfString.length == 0))
/*       */     {
/*  7767 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  7768 */       ((SQLException)localObject).fillInStackTrace();
/*  7769 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7773 */     doDescribeTable(localAutoKeyInfo);
/*       */ 
/*  7775 */     Object localObject = localAutoKeyInfo.getNewSql();
/*  7776 */     oracle.jdbc.OraclePreparedStatement localOraclePreparedStatement = (oracle.jdbc.OraclePreparedStatement)prepareStatement((String)localObject);
/*  7777 */     OraclePreparedStatement localOraclePreparedStatement1 = (OraclePreparedStatement)((OraclePreparedStatementWrapper)localOraclePreparedStatement).preparedStatement;
/*       */ 
/*  7779 */     localOraclePreparedStatement1.isAutoGeneratedKey = true;
/*  7780 */     localOraclePreparedStatement1.autoKeyInfo = localAutoKeyInfo;
/*  7781 */     localOraclePreparedStatement1.registerReturnParamsForAutoKey();
/*  7782 */     return localOraclePreparedStatement;
/*       */   }
/*       */ 
/*       */   public synchronized oracle.jdbc.OracleSavepoint oracleSetSavepoint()
/*       */     throws SQLException
/*       */   {
/*  7813 */     disallowGlobalTxnMode(117);
/*       */ 
/*  7816 */     if (this.autocommit)
/*       */     {
/*  7818 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 120);
/*  7819 */       ((SQLException)localObject).fillInStackTrace();
/*  7820 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7825 */     if (this.savepointStatement == null)
/*       */     {
/*  7827 */       this.savepointStatement = createStatement();
/*       */     }
/*       */ 
/*  7830 */     Object localObject = new OracleSavepoint();
/*       */ 
/*  7832 */     String str = "SAVEPOINT ORACLE_SVPT_" + ((OracleSavepoint)localObject).getSavepointId();
/*       */ 
/*  7834 */     this.savepointStatement.executeUpdate(str);
/*       */ 
/*  7837 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized oracle.jdbc.OracleSavepoint oracleSetSavepoint(String paramString)
/*       */     throws SQLException
/*       */   {
/*  7869 */     disallowGlobalTxnMode(117);
/*       */ 
/*  7872 */     if (this.autocommit)
/*       */     {
/*  7874 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 120);
/*  7875 */       ((SQLException)localObject).fillInStackTrace();
/*  7876 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7881 */     if (this.savepointStatement == null)
/*       */     {
/*  7883 */       this.savepointStatement = createStatement();
/*       */     }
/*       */ 
/*  7886 */     Object localObject = new OracleSavepoint(paramString);
/*       */     String str;
/*  7888 */     if (((OracleSavepoint)localObject).getType() == 1)
/*  7889 */       str = "SAVEPOINT ORACLE_SVPT_" + ((OracleSavepoint)localObject).getSavepointId();
/*       */     else {
/*  7891 */       str = "SAVEPOINT " + ((OracleSavepoint)localObject).getSavepointName();
/*       */     }
/*  7893 */     this.savepointStatement.executeUpdate(str);
/*       */ 
/*  7896 */     return localObject;
/*       */   }
/*       */ 
/*       */   public synchronized void oracleRollback(oracle.jdbc.OracleSavepoint paramOracleSavepoint)
/*       */     throws SQLException
/*       */   {
/*  7929 */     disallowGlobalTxnMode(115);
/*       */ 
/*  7932 */     if (this.autocommit)
/*       */     {
/*  7934 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 121);
/*  7935 */       ((SQLException)localObject).fillInStackTrace();
/*  7936 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7941 */     if (this.savepointStatement == null)
/*       */     {
/*  7943 */       this.savepointStatement = createStatement();
/*       */     }
/*       */ 
/*  7946 */     Object localObject = null;
/*  7947 */     if (paramOracleSavepoint != null)
/*       */     {
/*       */       try
/*       */       {
/*  7951 */         localObject = paramOracleSavepoint.getSavepointName();
/*       */       }
/*       */       catch (SQLException localSQLException)
/*       */       {
/*  7955 */         localObject = "ORACLE_SVPT_" + paramOracleSavepoint.getSavepointId();
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  7960 */     this.savepointStatement.executeUpdate("ROLLBACK TO " + (String)localObject);
/*       */   }
/*       */ 
/*       */   public synchronized void oracleReleaseSavepoint(oracle.jdbc.OracleSavepoint paramOracleSavepoint)
/*       */     throws SQLException
/*       */   {
/*  7993 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  7994 */     localSQLException.fillInStackTrace();
/*  7995 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void disallowGlobalTxnMode(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  8016 */     if (this.txnMode == 1)
/*       */     {
/*  8018 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), paramInt);
/*  8019 */       localSQLException.fillInStackTrace();
/*  8020 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTxnMode(int paramInt)
/*       */   {
/*  8034 */     this.txnMode = paramInt;
/*       */   }
/*       */ 
/*       */   public int getTxnMode()
/*       */   {
/*  8041 */     return this.txnMode;
/*       */   }
/*       */ 
/*       */   public synchronized Object getClientData(Object paramObject)
/*       */   {
/*  8070 */     if (this.clientData == null)
/*       */     {
/*  8072 */       return null;
/*       */     }
/*       */ 
/*  8075 */     return this.clientData.get(paramObject);
/*       */   }
/*       */ 
/*       */   public synchronized Object setClientData(Object paramObject1, Object paramObject2)
/*       */   {
/*  8102 */     if (this.clientData == null)
/*       */     {
/*  8104 */       this.clientData = new Hashtable();
/*       */     }
/*       */ 
/*  8107 */     return this.clientData.put(paramObject1, paramObject2);
/*       */   }
/*       */ 
/*       */   public synchronized Object removeClientData(Object paramObject)
/*       */   {
/*  8128 */     if (this.clientData == null)
/*       */     {
/*  8130 */       return null;
/*       */     }
/*       */ 
/*  8133 */     return this.clientData.remove(paramObject);
/*       */   }
/*       */ 
/*       */   public BlobDBAccess createBlobDBAccess()
/*       */     throws SQLException
/*       */   {
/*  8141 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  8142 */     localSQLException.fillInStackTrace();
/*  8143 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public ClobDBAccess createClobDBAccess()
/*       */     throws SQLException
/*       */   {
/*  8152 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  8153 */     localSQLException.fillInStackTrace();
/*  8154 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public BfileDBAccess createBfileDBAccess()
/*       */     throws SQLException
/*       */   {
/*  8163 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  8164 */     localSQLException.fillInStackTrace();
/*  8165 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void printState()
/*       */   {
/*       */     try
/*       */     {
/*  8191 */       int i = getJdbcCsId();
/*       */ 
/*  8194 */       int j = getDbCsId();
/*       */ 
/*  8197 */       int k = getStructAttrCsId();
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*  8202 */       localSQLException.printStackTrace();
/*       */     }
/*       */   }
/*       */ 
/*       */   public String getProtocolType()
/*       */   {
/*  8214 */     return this.protocol;
/*       */   }
/*       */ 
/*       */   public String getURL()
/*       */   {
/*  8230 */     return this.url;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public synchronized void setStmtCacheSize(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  8249 */     setStatementCacheSize(paramInt);
/*  8250 */     setImplicitCachingEnabled(true);
/*  8251 */     setExplicitCachingEnabled(true);
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public synchronized void setStmtCacheSize(int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  8271 */     setStatementCacheSize(paramInt);
/*  8272 */     setImplicitCachingEnabled(true);
/*       */ 
/*  8275 */     setExplicitCachingEnabled(true);
/*       */ 
/*  8277 */     this.clearStatementMetaData = paramBoolean;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public synchronized int getStmtCacheSize()
/*       */   {
/*  8296 */     int i = 0;
/*       */     try
/*       */     {
/*  8300 */       i = getStatementCacheSize();
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*       */     }
/*       */ 
/*  8308 */     if (i == -1)
/*       */     {
/*  8313 */       i = 0;
/*       */     }
/*       */ 
/*  8316 */     return i;
/*       */   }
/*       */ 
/*       */   public synchronized void setStatementCacheSize(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  8342 */     if (this.statementCache == null)
/*       */     {
/*  8344 */       this.statementCache = new LRUStatementCache(paramInt);
/*       */     }
/*       */     else
/*       */     {
/*  8351 */       this.statementCache.resize(paramInt);
/*       */     }
/*       */   }
/*       */ 
/*       */   public synchronized int getStatementCacheSize()
/*       */     throws SQLException
/*       */   {
/*  8375 */     if (this.statementCache == null) {
/*  8376 */       return -1;
/*       */     }
/*  8378 */     return this.statementCache.getCacheSize();
/*       */   }
/*       */ 
/*       */   public synchronized void setImplicitCachingEnabled(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  8406 */     if (this.statementCache == null)
/*       */     {
/*  8411 */       this.statementCache = new LRUStatementCache(0);
/*       */     }
/*       */ 
/*  8418 */     this.statementCache.setImplicitCachingEnabled(paramBoolean);
/*       */   }
/*       */ 
/*       */   public synchronized boolean getImplicitCachingEnabled()
/*       */     throws SQLException
/*       */   {
/*  8442 */     if (this.statementCache == null) {
/*  8443 */       return false;
/*       */     }
/*  8445 */     return this.statementCache.getImplicitCachingEnabled();
/*       */   }
/*       */ 
/*       */   public synchronized void setExplicitCachingEnabled(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  8473 */     if (this.statementCache == null)
/*       */     {
/*  8478 */       this.statementCache = new LRUStatementCache(0);
/*       */     }
/*       */ 
/*  8485 */     this.statementCache.setExplicitCachingEnabled(paramBoolean);
/*       */   }
/*       */ 
/*       */   public synchronized boolean getExplicitCachingEnabled()
/*       */     throws SQLException
/*       */   {
/*  8509 */     if (this.statementCache == null) {
/*  8510 */       return false;
/*       */     }
/*  8512 */     return this.statementCache.getExplicitCachingEnabled();
/*       */   }
/*       */ 
/*       */   public synchronized void purgeImplicitCache()
/*       */     throws SQLException
/*       */   {
/*  8536 */     if (this.statementCache != null)
/*  8537 */       this.statementCache.purgeImplicitCache();
/*       */   }
/*       */ 
/*       */   public synchronized void purgeExplicitCache()
/*       */     throws SQLException
/*       */   {
/*  8561 */     if (this.statementCache != null)
/*  8562 */       this.statementCache.purgeExplicitCache();
/*       */   }
/*       */ 
/*       */   public synchronized PreparedStatement getStatementWithKey(String paramString)
/*       */     throws SQLException
/*       */   {
/*  8589 */     if (this.statementCache != null)
/*       */     {
/*  8591 */       OracleStatement localOracleStatement = this.statementCache.searchExplicitCache(paramString);
/*       */ 
/*  8594 */       if ((localOracleStatement == null) || (localOracleStatement.statementType == 1)) {
/*  8595 */         return (PreparedStatement)localOracleStatement;
/*       */       }
/*       */ 
/*  8599 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 125);
/*  8600 */       localSQLException.fillInStackTrace();
/*  8601 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8606 */     return null;
/*       */   }
/*       */ 
/*       */   public synchronized CallableStatement getCallWithKey(String paramString)
/*       */     throws SQLException
/*       */   {
/*  8633 */     if (this.statementCache != null)
/*       */     {
/*  8635 */       OracleStatement localOracleStatement = this.statementCache.searchExplicitCache(paramString);
/*       */ 
/*  8638 */       if ((localOracleStatement == null) || (localOracleStatement.statementType == 2)) {
/*  8639 */         return (CallableStatement)localOracleStatement;
/*       */       }
/*       */ 
/*  8643 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 125);
/*  8644 */       localSQLException.fillInStackTrace();
/*  8645 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8650 */     return null;
/*       */   }
/*       */ 
/*       */   synchronized void cacheImplicitStatement(OraclePreparedStatement paramOraclePreparedStatement, String paramString, int paramInt, OracleResultSet.ResultSetType paramResultSetType)
/*       */     throws SQLException
/*       */   {
/*  8666 */     if (this.statementCache == null)
/*       */     {
/*  8668 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 95);
/*  8669 */       localSQLException.fillInStackTrace();
/*  8670 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8674 */     this.statementCache.addToImplicitCache(paramOraclePreparedStatement, paramString, paramInt, paramResultSetType.ordinal());
/*       */   }
/*       */ 
/*       */   synchronized void cacheExplicitStatement(OraclePreparedStatement paramOraclePreparedStatement, String paramString)
/*       */     throws SQLException
/*       */   {
/*  8691 */     if (this.statementCache == null)
/*       */     {
/*  8693 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 95);
/*  8694 */       localSQLException.fillInStackTrace();
/*  8695 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8698 */     this.statementCache.addToExplicitCache(paramOraclePreparedStatement, paramString);
/*       */   }
/*       */ 
/*       */   public synchronized boolean isStatementCacheInitialized()
/*       */   {
/*  8713 */     if (this.statementCache == null)
/*  8714 */       return false;
/*  8715 */     if (this.statementCache.getCacheSize() == 0) {
/*  8716 */       return false;
/*       */     }
/*  8718 */     return true;
/*       */   }
/*       */ 
/*       */   BlockSource getBlockSource()
/*       */   {
/*  8728 */     return this.blockSource;
/*       */   }
/*       */ 
/*       */   private BufferCacheStore getBufferCacheStore()
/*       */   {
/*  8784 */     if (this.useThreadLocalBufferCache) {
/*  8785 */       if (threadLocalBufferCacheStore == null)
/*       */       {
/*  8798 */         BufferCacheStore.MAX_CACHED_BUFFER_SIZE = this.maxCachedBufferSize;
/*  8799 */         threadLocalBufferCacheStore = new ThreadLocal()
/*       */         {
/*       */           protected PhysicalConnection.BufferCacheStore initialValue()
/*       */           {
/*  8803 */             return new PhysicalConnection.BufferCacheStore();
/*       */           }
/*       */         };
/*       */       }
/*  8807 */       return (BufferCacheStore)threadLocalBufferCacheStore.get();
/*       */     }
/*       */ 
/*  8810 */     if (this.connectionBufferCacheStore == null)
/*       */     {
/*  8812 */       this.connectionBufferCacheStore = new BufferCacheStore(this.maxCachedBufferSize);
/*       */     }
/*  8814 */     return this.connectionBufferCacheStore;
/*       */   }
/*       */ 
/*       */   void cacheBuffer(byte[] paramArrayOfByte)
/*       */   {
/*  8825 */     if (paramArrayOfByte != null) {
/*  8826 */       BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8827 */       localBufferCacheStore.byteBufferCache.put(paramArrayOfByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   void cacheBuffer(char[] paramArrayOfChar)
/*       */   {
/*  8839 */     if (paramArrayOfChar != null) {
/*  8840 */       BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8841 */       localBufferCacheStore.charBufferCache.put(paramArrayOfChar);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void cacheBufferSync(char[] paramArrayOfChar)
/*       */   {
/*  8847 */     synchronized (this) {
/*  8848 */       cacheBuffer(paramArrayOfChar);
/*       */     }
/*       */   }
/*       */ 
/*       */   byte[] getByteBuffer(int paramInt)
/*       */   {
/*  8860 */     BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8861 */     return (byte[])localBufferCacheStore.byteBufferCache.get(Byte.TYPE, paramInt);
/*       */   }
/*       */ 
/*       */   char[] getCharBuffer(int paramInt)
/*       */   {
/*  8873 */     BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8874 */     return (char[])localBufferCacheStore.charBufferCache.get(Character.TYPE, paramInt);
/*       */   }
/*       */ 
/*       */   public char[] getCharBufferSync(int paramInt)
/*       */   {
/*  8879 */     synchronized (this) {
/*  8880 */       return getCharBuffer(paramInt);
/*       */     }
/*       */   }
/*       */ 
/*       */   public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics()
/*       */   {
/*  8891 */     BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8892 */     return localBufferCacheStore.byteBufferCache.getStatistics();
/*       */   }
/*       */ 
/*       */   public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics()
/*       */   {
/*  8903 */     BufferCacheStore localBufferCacheStore = getBufferCacheStore();
/*  8904 */     return localBufferCacheStore.charBufferCache.getStatistics();
/*       */   }
/*       */ 
/*       */   public synchronized void registerTAFCallback(OracleOCIFailover paramOracleOCIFailover, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  8932 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  8933 */     localSQLException.fillInStackTrace();
/*  8934 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public String getDatabaseProductVersion()
/*       */     throws SQLException
/*       */   {
/*  8952 */     if (this.databaseProductVersion == "")
/*       */     {
/*  8954 */       needLine();
/*       */ 
/*  8956 */       this.databaseProductVersion = doGetDatabaseProductVersion();
/*       */     }
/*       */ 
/*  8959 */     return this.databaseProductVersion;
/*       */   }
/*       */ 
/*       */   synchronized boolean getReportRemarks()
/*       */   {
/*  8971 */     return this.reportRemarks;
/*       */   }
/*       */ 
/*       */   public short getVersionNumber()
/*       */     throws SQLException
/*       */   {
/*  8983 */     if (this.versionNumber == -1)
/*       */     {
/*  8985 */       synchronized (this)
/*       */       {
/*  8987 */         if (this.versionNumber == -1)
/*       */         {
/*  8989 */           needLine();
/*       */ 
/*  8991 */           this.versionNumber = doGetVersionNumber();
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/*  8996 */     return this.versionNumber;
/*       */   }
/*       */ 
/*       */   synchronized void registerCloseCallback(OracleCloseCallback paramOracleCloseCallback, Object paramObject)
/*       */   {
/*  9009 */     this.closeCallback = paramOracleCloseCallback;
/*  9010 */     this.privateData = paramObject;
/*       */   }
/*       */ 
/*       */   public void setCreateStatementAsRefCursor(boolean paramBoolean)
/*       */   {
/*       */   }
/*       */ 
/*       */   public boolean getCreateStatementAsRefCursor()
/*       */   {
/*  9068 */     return false;
/*       */   }
/*       */ 
/*       */   public int pingDatabase()
/*       */     throws SQLException
/*       */   {
/*  9084 */     if (this.lifecycle != 1)
/*  9085 */       return -1;
/*  9086 */     return doPingDatabase();
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public int pingDatabase(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9104 */     if (this.lifecycle != 1)
/*  9105 */       return -1;
/*  9106 */     if (paramInt == 0) {
/*  9107 */       return pingDatabase();
/*       */     }
/*       */     try
/*       */     {
/*  9111 */       this.pingResult = -2;
/*  9112 */       Thread localThread = new Thread(new Runnable() {
/*       */         public void run() {
/*       */           try {
/*  9115 */             PhysicalConnection.this.pingResult = PhysicalConnection.this.doPingDatabase();
/*       */           }
/*       */           catch (Throwable localThrowable)
/*       */           {
/*       */           }
/*       */         }
/*       */       });
/*  9120 */       localThread.start();
/*  9121 */       localThread.join(paramInt * 1000);
/*  9122 */       return this.pingResult;
/*       */     } catch (InterruptedException localInterruptedException) {
/*       */     }
/*  9125 */     return -3;
/*       */   }
/*       */ 
/*       */   int doPingDatabase()
/*       */     throws SQLException
/*       */   {
/*  9134 */     Statement localStatement = null;
/*       */     try
/*       */     {
/*  9138 */       localStatement = createStatement();
/*       */ 
/*  9140 */       ((oracle.jdbc.OracleStatement)localStatement).defineColumnType(1, 12, 1);
/*  9141 */       localStatement.executeQuery("SELECT 'x' FROM DUAL");
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*  9145 */       return -1;
/*       */     }
/*       */     finally
/*       */     {
/*  9149 */       if (localStatement != null) {
/*  9150 */         localStatement.close();
/*       */       }
/*       */     }
/*  9153 */     return 0;
/*       */   }
/*       */ 
/*       */   public synchronized Map getJavaObjectTypeMap()
/*       */   {
/*  9169 */     return this.javaObjectMap;
/*       */   }
/*       */ 
/*       */   public synchronized void setJavaObjectTypeMap(Map paramMap)
/*       */   {
/*  9179 */     this.javaObjectMap = paramMap;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void clearClientIdentifier(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9199 */     if ((paramString != null) && (paramString.length() != 0))
/*       */     {
/*  9203 */       String[] arrayOfString = getEndToEndMetrics();
/*       */ 
/*  9205 */       if ((arrayOfString != null) && (paramString.equals(arrayOfString[1])))
/*       */       {
/*  9208 */         arrayOfString[1] = null;
/*       */ 
/*  9210 */         setEndToEndMetrics(arrayOfString, getEndToEndECIDSequenceNumber());
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void setClientIdentifier(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9237 */     String[] arrayOfString = getEndToEndMetrics();
/*       */ 
/*  9239 */     if (arrayOfString == null)
/*       */     {
/*  9241 */       arrayOfString = new String[4];
/*       */     }
/*       */ 
/*  9245 */     arrayOfString[1] = paramString;
/*       */ 
/*  9247 */     setEndToEndMetrics(arrayOfString, getEndToEndECIDSequenceNumber());
/*       */   }
/*       */ 
/*       */   public void setSessionTimeZone(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9290 */     Statement localStatement = null;
/*  9291 */     Object localObject1 = null;
/*       */     try
/*       */     {
/*  9294 */       localStatement = createStatement();
/*       */ 
/*  9297 */       localStatement.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + paramString + "'");
/*       */ 
/*  9302 */       if (this.dbTzCalendar == null)
/*  9303 */         setDbTzCalendar(getDatabaseTimeZone());
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*  9307 */       throw localSQLException;
/*       */     }
/*       */     finally {
/*  9310 */       if (localStatement != null) {
/*  9311 */         localStatement.close();
/*       */       }
/*       */     }
/*       */ 
/*  9315 */     this.sessionTimeZone = paramString;
/*       */   }
/*       */ 
/*       */   public String getDatabaseTimeZone()
/*       */     throws SQLException
/*       */   {
/*  9327 */     if (this.databaseTimeZone == null) {
/*  9328 */       this.databaseTimeZone = getPropertyFromDatabase("SELECT DBTIMEZONE FROM DUAL");
/*       */     }
/*       */ 
/*  9331 */     return this.databaseTimeZone;
/*       */   }
/*       */ 
/*       */   public String getSessionTimeZone()
/*       */   {
/*  9351 */     return this.sessionTimeZone;
/*       */   }
/*       */ 
/*       */   private static String to2DigitString(int paramInt)
/*       */   {
/*       */     String str;
/*  9360 */     if (paramInt < 10)
/*  9361 */       str = "0" + paramInt;
/*       */     else {
/*  9363 */       str = "" + paramInt;
/*       */     }
/*  9365 */     return str;
/*       */   }
/*       */ 
/*       */   String tzToOffset(String paramString)
/*       */   {
/*  9373 */     if (paramString == null) {
/*  9374 */       return paramString;
/*       */     }
/*       */ 
/*  9377 */     int i = paramString.charAt(0);
/*       */ 
/*  9379 */     if ((i != 45) && (i != 43))
/*       */     {
/*  9381 */       TimeZone localTimeZone = TimeZone.getTimeZone(paramString);
/*       */ 
/*  9383 */       int j = localTimeZone.getOffset(System.currentTimeMillis());
/*       */ 
/*  9385 */       if (j != 0) {
/*  9386 */         int k = j / 60000;
/*  9387 */         int m = k / 60;
/*  9388 */         k -= m * 60;
/*       */ 
/*  9390 */         if (j > 0) {
/*  9391 */           paramString = "+" + to2DigitString(m) + ":" + to2DigitString(k);
/*       */         }
/*       */         else
/*       */         {
/*  9395 */           paramString = "-" + to2DigitString(-m) + ":" + to2DigitString(-k);
/*       */         }
/*       */       }
/*       */       else
/*       */       {
/*  9400 */         paramString = "+00:00";
/*       */       }
/*       */     }
/*       */ 
/*  9404 */     return paramString;
/*       */   }
/*       */ 
/*       */   public String getSessionTimeZoneOffset()
/*       */     throws SQLException
/*       */   {
/*  9419 */     String str = getPropertyFromDatabase("SELECT SESSIONTIMEZONE FROM DUAL");
/*       */ 
/*  9422 */     if (str != null) {
/*  9423 */       str = tzToOffset(str.trim());
/*       */     }
/*       */ 
/*  9426 */     return str;
/*       */   }
/*       */ 
/*       */   private void setDbTzCalendar(String paramString)
/*       */   {
/*  9441 */     int i = paramString.charAt(0);
/*       */ 
/*  9443 */     if ((i == 45) || (i == 43)) {
/*  9444 */       paramString = "GMT" + paramString;
/*       */     }
/*       */ 
/*  9447 */     TimeZone localTimeZone = TimeZone.getTimeZone(paramString);
/*       */ 
/*  9449 */     this.dbTzCalendar = new GregorianCalendar(localTimeZone);
/*       */   }
/*       */ 
/*       */   Calendar getDbTzCalendar()
/*       */     throws SQLException
/*       */   {
/*  9469 */     if (this.dbTzCalendar == null)
/*       */     {
/*  9471 */       setDbTzCalendar(getDatabaseTimeZone());
/*       */     }
/*       */ 
/*  9474 */     Calendar localCalendar = null;
/*       */ 
/*  9476 */     if (this.dbTzCalendar != null) {
/*  9477 */       localCalendar = (Calendar)this.dbTzCalendar.clone();
/*       */     }
/*       */ 
/*  9480 */     return localCalendar;
/*       */   }
/*       */ 
/*       */   void setAccumulateBatchResult(boolean paramBoolean)
/*       */   {
/*  9497 */     this.accumulateBatchResult = paramBoolean;
/*       */   }
/*       */ 
/*       */   boolean isAccumulateBatchResult()
/*       */   {
/*  9515 */     return this.accumulateBatchResult;
/*       */   }
/*       */ 
/*       */   void setJ2EE13Compliant(boolean paramBoolean)
/*       */   {
/*  9532 */     this.j2ee13Compliant = paramBoolean;
/*       */   }
/*       */ 
/*       */   boolean getJ2EE13Compliant()
/*       */   {
/*  9549 */     return this.j2ee13Compliant;
/*       */   }
/*       */ 
/*       */   public Class classForNameAndSchema(String paramString1, String paramString2)
/*       */     throws ClassNotFoundException
/*       */   {
/*  9571 */     return Class.forName(paramString1);
/*       */   }
/*       */ 
/*       */   Class safelyGetClassForName(String paramString)
/*       */     throws ClassNotFoundException
/*       */   {
/*  9596 */     return Class.forName(paramString);
/*       */   }
/*       */ 
/*       */   public int getHeapAllocSize()
/*       */     throws SQLException
/*       */   {
/*  9615 */     if (this.lifecycle != 1)
/*       */     {
/*  9617 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  9618 */       localSQLException.fillInStackTrace();
/*  9619 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9623 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  9624 */     localSQLException.fillInStackTrace();
/*  9625 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public int getOCIEnvHeapAllocSize()
/*       */     throws SQLException
/*       */   {
/*  9644 */     if (this.lifecycle != 1)
/*       */     {
/*  9646 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/*  9647 */       localSQLException.fillInStackTrace();
/*  9648 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9652 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  9653 */     localSQLException.fillInStackTrace();
/*  9654 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection paramOracleConnection)
/*       */   {
/*  9669 */     Object localObject1 = paramOracleConnection;
/*  9670 */     Object localObject2 = localObject1;
/*       */     while (true)
/*       */     {
/*  9674 */       if (localObject2 == null) {
/*  9675 */         return (OracleConnection)localObject1;
/*       */       }
/*  9677 */       localObject1 = localObject2;
/*  9678 */       localObject2 = ((oracle.jdbc.OracleConnection)localObject1).unwrap();
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setWrapper(oracle.jdbc.OracleConnection paramOracleConnection)
/*       */   {
/*  9686 */     this.wrapper = paramOracleConnection;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.OracleConnection unwrap()
/*       */   {
/*  9698 */     return null;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.OracleConnection getWrapper()
/*       */   {
/*  9710 */     if (this.wrapper != null) {
/*  9711 */       return this.wrapper;
/*       */     }
/*  9713 */     return this;
/*       */   }
/*       */ 
/*       */   static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection paramConnection)
/*       */   {
/*  9731 */     OracleConnection localOracleConnection = null;
/*       */ 
/*  9735 */     if (paramConnection != null)
/*       */     {
/*  9737 */       localOracleConnection = unwrapCompletely((oracle.jdbc.OracleConnection)paramConnection);
/*       */     }
/*       */ 
/*  9742 */     return localOracleConnection;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.internal.OracleConnection physicalConnectionWithin()
/*       */   {
/*  9749 */     return this;
/*       */   }
/*       */ 
/*       */   public long getTdoCState(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  9757 */     return 0L;
/*       */   }
/*       */ 
/*       */   public long getTdoCState(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9765 */     return 0L;
/*       */   }
/*       */ 
/*       */   void getOracleTypeADT(OracleTypeADT paramOracleTypeADT)
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public Datum toDatum(CustomDatum paramCustomDatum) throws SQLException
/*       */   {
/*  9775 */     return paramCustomDatum.toDatum(this);
/*       */   }
/*       */ 
/*       */   public short getNCharSet()
/*       */   {
/*  9782 */     return this.conversion.getNCharSetId();
/*       */   }
/*       */ 
/*       */   public ResultSet newArrayDataResultSet(Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  9790 */     return new ArrayDataResultSet(this, paramArrayOfDatum, paramLong, paramInt, paramMap);
/*       */   }
/*       */ 
/*       */   public ResultSet newArrayDataResultSet(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  9798 */     return new ArrayDataResultSet(this, paramARRAY, paramLong, paramInt, paramMap);
/*       */   }
/*       */ 
/*       */   public ResultSet newArrayLocatorResultSet(ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  9808 */     return ArrayLocatorResultSet.create(this, paramArrayDescriptor, paramArrayOfByte, paramLong, paramInt, paramMap);
/*       */   }
/*       */ 
/*       */   public ResultSetMetaData newStructMetaData(StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  9816 */     return new StructMetaData(paramStructDescriptor);
/*       */   }
/*       */ 
/*       */   public int CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*       */     throws SQLException
/*       */   {
/*  9824 */     int[] arrayOfInt = new int[1];
/*       */ 
/*  9826 */     arrayOfInt[0] = paramInt;
/*       */ 
/*  9828 */     return this.conversion.CHARBytesToJavaChars(paramArrayOfByte, 0, paramArrayOfChar, 0, arrayOfInt, paramArrayOfChar.length);
/*       */   }
/*       */ 
/*       */   public int NCHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*       */     throws SQLException
/*       */   {
/*  9837 */     int[] arrayOfInt = new int[1];
/*       */ 
/*  9839 */     return this.conversion.NCHARBytesToJavaChars(paramArrayOfByte, 0, paramArrayOfChar, 0, arrayOfInt, paramArrayOfChar.length);
/*       */   }
/*       */ 
/*       */   public boolean IsNCharFixedWith()
/*       */   {
/*  9852 */     return this.conversion.IsNCharFixedWith();
/*       */   }
/*       */ 
/*       */   public short getDriverCharSet()
/*       */   {
/*  9864 */     return this.conversion.getClientCharSet();
/*       */   }
/*       */ 
/*       */   public int getMaxCharSize()
/*       */     throws SQLException
/*       */   {
/*  9877 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 58);
/*  9878 */     localSQLException.fillInStackTrace();
/*  9879 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public int getMaxCharbyteSize()
/*       */   {
/*  9892 */     return this.conversion.getMaxCharbyteSize();
/*       */   }
/*       */ 
/*       */   public int getMaxNCharbyteSize()
/*       */   {
/*  9904 */     return this.conversion.getMaxNCharbyteSize();
/*       */   }
/*       */ 
/*       */   public boolean isCharSetMultibyte(short paramShort)
/*       */   {
/*  9916 */     return DBConversion.isCharSetMultibyte(paramShort);
/*       */   }
/*       */ 
/*       */   public int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  9929 */     return this.conversion.javaCharsToCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public int javaCharsToNCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  9942 */     return this.conversion.javaCharsToNCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public abstract void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*       */     throws SQLException;
/*       */ 
/*       */   final void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection, String paramString)
/*       */     throws SQLException
/*       */   {
/*  9954 */     Hashtable localHashtable = new Hashtable();
/*       */ 
/*  9956 */     localHashtable.put("obj_type_map", this.javaObjectMap);
/*       */ 
/*  9958 */     Properties localProperties = new Properties();
/*       */ 
/*  9960 */     localProperties.put("user", this.userName);
/*  9961 */     localProperties.put("password", paramString);
/*       */ 
/*  9963 */     localProperties.put("connection_url", this.url);
/*  9964 */     localProperties.put("connect_auto_commit", "" + this.autocommit);
/*       */ 
/*  9967 */     localProperties.put("trans_isolation", "" + this.txnLevel);
/*       */ 
/*  9969 */     if (getStatementCacheSize() != -1)
/*       */     {
/*  9971 */       localProperties.put("stmt_cache_size", "" + getStatementCacheSize());
/*       */ 
/*  9973 */       localProperties.put("implicit_cache_enabled", "" + getImplicitCachingEnabled());
/*       */ 
/*  9975 */       localProperties.put("explict_cache_enabled", "" + getExplicitCachingEnabled());
/*       */     }
/*       */ 
/*  9979 */     localProperties.put("defaultExecuteBatch", "" + this.defaultExecuteBatch);
/*  9980 */     localProperties.put("defaultRowPrefetch", "" + this.defaultRowPrefetch);
/*  9981 */     localProperties.put("remarksReporting", "" + this.reportRemarks);
/*  9982 */     localProperties.put("AccumulateBatchResult", "" + this.accumulateBatchResult);
/*  9983 */     localProperties.put("oracle.jdbc.J2EE13Compliant", "" + this.j2ee13Compliant);
/*  9984 */     localProperties.put("processEscapes", "" + this.processEscapes);
/*       */ 
/*  9986 */     localProperties.put("restrictGetTables", "" + this.restrictGettables);
/*  9987 */     localProperties.put("includeSynonyms", "" + this.includeSynonyms);
/*  9988 */     localProperties.put("fixedString", "" + this.fixedString);
/*       */ 
/*  9990 */     localHashtable.put("connection_properties", localProperties);
/*       */ 
/*  9992 */     paramOraclePooledConnection.setProperties(localHashtable);
/*       */   }
/*       */ 
/*       */   public Properties getDBAccessProperties()
/*       */     throws SQLException
/*       */   {
/* 10019 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 10020 */     localSQLException.fillInStackTrace();
/* 10021 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Properties getOCIHandles()
/*       */     throws SQLException
/*       */   {
/* 10038 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 10039 */     localSQLException.fillInStackTrace();
/* 10040 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   abstract void logon()
/*       */     throws SQLException;
/*       */ 
/*       */   void logoff()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   abstract void open(OracleStatement paramOracleStatement)
/*       */     throws SQLException;
/*       */ 
/*       */   abstract void cancelOperationOnServer(boolean paramBoolean)
/*       */     throws SQLException;
/*       */ 
/*       */   abstract void doSetAutoCommit(boolean paramBoolean)
/*       */     throws SQLException;
/*       */ 
/*       */   abstract void doCommit(int paramInt)
/*       */     throws SQLException;
/*       */ 
/*       */   abstract void doRollback()
/*       */     throws SQLException;
/*       */ 
/*       */   abstract String doGetDatabaseProductVersion()
/*       */     throws SQLException;
/*       */ 
/*       */   abstract short doGetVersionNumber()
/*       */     throws SQLException;
/*       */ 
/*       */   int getDefaultStreamChunkSize()
/*       */   {
/* 10140 */     return 32768;
/*       */   }
/*       */ 
/*       */   abstract OracleStatement RefCursorBytesToStatement(byte[] paramArrayOfByte, OracleStatement paramOracleStatement)
/*       */     throws SQLException;
/*       */ 
/*       */   abstract OracleStatement createImplicitResultSetStatement(OracleStatement paramOracleStatement)
/*       */     throws SQLException;
/*       */ 
/*       */   public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 10157 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 10158 */     localSQLException.fillInStackTrace();
/* 10159 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Connection getLogicalConnection(OraclePooledConnection paramOraclePooledConnection, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10172 */     if (this.logicalConnectionAttached != null)
/*       */     {
/* 10174 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 143);
/* 10175 */       ((SQLException)localObject).fillInStackTrace();
/* 10176 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10179 */     Object localObject = new LogicalConnection(paramOraclePooledConnection, this, paramBoolean);
/*       */ 
/* 10184 */     this.logicalConnectionAttached = ((LogicalConnection)localObject);
/*       */ 
/* 10186 */     return localObject;
/*       */   }
/*       */ 
/*       */   public void getForm(OracleTypeADT paramOracleTypeADT, OracleTypeCLOB paramOracleTypeCLOB, int paramInt)
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public CLOB createClob(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 10199 */     Object localObject = new CLOB(this, paramArrayOfByte);
/* 10200 */     if (((CLOB)localObject).isNCLOB())
/*       */     {
/* 10202 */       localObject = new NCLOB((CLOB)localObject);
/*       */     }
/*       */ 
/* 10205 */     return localObject;
/*       */   }
/*       */ 
/*       */   public CLOB createClobWithUnpickledBytes(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 10214 */     Object localObject = new CLOB(this, paramArrayOfByte, true);
/* 10215 */     if (((CLOB)localObject).isNCLOB())
/*       */     {
/* 10217 */       localObject = new NCLOB((CLOB)localObject);
/*       */     }
/*       */ 
/* 10220 */     return localObject;
/*       */   }
/*       */ 
/*       */   public CLOB createClob(byte[] paramArrayOfByte, short paramShort)
/*       */     throws SQLException
/*       */   {
/* 10228 */     if (paramShort == 2) {
/* 10229 */       return new NCLOB(this, paramArrayOfByte);
/*       */     }
/* 10231 */     return new CLOB(this, paramArrayOfByte, paramShort);
/*       */   }
/*       */ 
/*       */   public BLOB createBlob(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 10238 */     return new BLOB(this, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public BLOB createBlobWithUnpickledBytes(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 10246 */     return new BLOB(this, paramArrayOfByte, true);
/*       */   }
/*       */ 
/*       */   public BFILE createBfile(byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 10253 */     return new BFILE(this, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public ARRAY createARRAY(String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/* 10277 */     ArrayDescriptor localArrayDescriptor = ArrayDescriptor.createDescriptor(paramString, this);
/* 10278 */     return new ARRAY(localArrayDescriptor, this, paramObject);
/*       */   }
/*       */ 
/*       */   public Array createOracleArray(String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/* 10303 */     return createARRAY(paramString, paramObject);
/*       */   }
/*       */ 
/*       */   public BINARY_DOUBLE createBINARY_DOUBLE(double paramDouble)
/*       */     throws SQLException
/*       */   {
/* 10325 */     return new BINARY_DOUBLE(paramDouble);
/*       */   }
/*       */ 
/*       */   public BINARY_FLOAT createBINARY_FLOAT(float paramFloat)
/*       */     throws SQLException
/*       */   {
/* 10345 */     return new BINARY_FLOAT(paramFloat);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Date paramDate)
/*       */     throws SQLException
/*       */   {
/* 10365 */     return new DATE(paramDate);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Time paramTime)
/*       */     throws SQLException
/*       */   {
/* 10385 */     return new DATE(paramTime);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/* 10405 */     return new DATE(paramTimestamp);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10428 */     return new DATE(paramDate);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10451 */     return new DATE(paramTime);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10474 */     return new DATE(paramTimestamp);
/*       */   }
/*       */ 
/*       */   public DATE createDATE(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10494 */     return new DATE(paramString);
/*       */   }
/*       */ 
/*       */   public INTERVALDS createINTERVALDS(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10514 */     return new INTERVALDS(paramString);
/*       */   }
/*       */ 
/*       */   public INTERVALYM createINTERVALYM(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10534 */     return new INTERVALYM(paramString);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10554 */     return new NUMBER(paramBoolean);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(byte paramByte)
/*       */     throws SQLException
/*       */   {
/* 10574 */     return new NUMBER(paramByte);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(short paramShort)
/*       */     throws SQLException
/*       */   {
/* 10594 */     return new NUMBER(paramShort);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 10614 */     return new NUMBER(paramInt);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(long paramLong)
/*       */     throws SQLException
/*       */   {
/* 10634 */     return new NUMBER(paramLong);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(float paramFloat)
/*       */     throws SQLException
/*       */   {
/* 10654 */     return new NUMBER(paramFloat);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(double paramDouble)
/*       */     throws SQLException
/*       */   {
/* 10674 */     return new NUMBER(paramDouble);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/* 10694 */     return new NUMBER(paramBigDecimal);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(BigInteger paramBigInteger)
/*       */     throws SQLException
/*       */   {
/* 10714 */     return new NUMBER(paramBigInteger);
/*       */   }
/*       */ 
/*       */   public NUMBER createNUMBER(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 10735 */     return new NUMBER(paramString, paramInt);
/*       */   }
/*       */ 
/*       */   public Array createArrayOf(String paramString, Object[] paramArrayOfObject)
/*       */     throws SQLException
/*       */   {
/* 10762 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 10763 */     localSQLException.fillInStackTrace();
/* 10764 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Struct createStruct(String paramString, Object[] paramArrayOfObject)
/*       */     throws SQLException
/*       */   {
/*       */     try
/*       */     {
/* 10788 */       StructDescriptor localStructDescriptor = StructDescriptor.createDescriptor(paramString, this);
/* 10789 */       return new STRUCT(localStructDescriptor, this, paramArrayOfObject);
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/* 10793 */       if (localSQLException.getErrorCode() == 17049)
/* 10794 */         removeAllDescriptor();
/* 10795 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public TIMESTAMP createTIMESTAMP(Date paramDate)
/*       */     throws SQLException
/*       */   {
/* 10817 */     return new TIMESTAMP(paramDate);
/*       */   }
/*       */ 
/*       */   public TIMESTAMP createTIMESTAMP(DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/* 10837 */     return new TIMESTAMP(paramDATE);
/*       */   }
/*       */ 
/*       */   public TIMESTAMP createTIMESTAMP(Time paramTime)
/*       */     throws SQLException
/*       */   {
/* 10857 */     return new TIMESTAMP(paramTime);
/*       */   }
/*       */ 
/*       */   public TIMESTAMP createTIMESTAMP(Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/* 10877 */     return new TIMESTAMP(paramTimestamp);
/*       */   }
/*       */ 
/*       */   public TIMESTAMP createTIMESTAMP(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10897 */     return new TIMESTAMP(paramString);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Date paramDate)
/*       */     throws SQLException
/*       */   {
/* 10917 */     return new TIMESTAMPTZ(this, paramDate);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10941 */     return new TIMESTAMPTZ(this, paramDate, paramCalendar);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Time paramTime)
/*       */     throws SQLException
/*       */   {
/* 10961 */     return new TIMESTAMPTZ(this, paramTime);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10985 */     return new TIMESTAMPTZ(this, paramTime, paramCalendar);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/* 11005 */     return new TIMESTAMPTZ(this, paramTimestamp);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11029 */     return new TIMESTAMPTZ(this, paramTimestamp, paramCalendar);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(String paramString)
/*       */     throws SQLException
/*       */   {
/* 11049 */     return new TIMESTAMPTZ(this, paramString);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(String paramString, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11073 */     return new TIMESTAMPTZ(this, paramString, paramCalendar);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ createTIMESTAMPTZ(DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/* 11089 */     return new TIMESTAMPTZ(this, paramDATE);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ createTIMESTAMPLTZ(Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11113 */     return new TIMESTAMPLTZ(this, paramCalendar, paramDate);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ createTIMESTAMPLTZ(Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11137 */     return new TIMESTAMPLTZ(this, paramCalendar, paramTime);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11161 */     return new TIMESTAMPLTZ(this, paramCalendar, paramTimestamp);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ createTIMESTAMPLTZ(String paramString, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11185 */     return new TIMESTAMPLTZ(this, paramCalendar, paramString);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE paramDATE, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 11209 */     return new TIMESTAMPLTZ(this, paramCalendar, paramDATE);
/*       */   }
/*       */ 
/*       */   public abstract BLOB createTemporaryBlob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*       */     throws SQLException;
/*       */ 
/*       */   public abstract CLOB createTemporaryClob(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*       */     throws SQLException;
/*       */ 
/*       */   public Blob createBlob()
/*       */     throws SQLException
/*       */   {
/* 11234 */     if (this.lifecycle != 1)
/*       */     {
/* 11236 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11237 */       localSQLException.fillInStackTrace();
/* 11238 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11241 */     return createTemporaryBlob(this, true, 10);
/*       */   }
/*       */ 
/*       */   public Clob createClob()
/*       */     throws SQLException
/*       */   {
/* 11260 */     if (this.lifecycle != 1)
/*       */     {
/* 11262 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11263 */       localSQLException.fillInStackTrace();
/* 11264 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11267 */     return createTemporaryClob(this, true, 10, (short)1);
/*       */   }
/*       */ 
/*       */   public NClob createNClob()
/*       */     throws SQLException
/*       */   {
/* 11287 */     if (this.lifecycle != 1)
/*       */     {
/* 11289 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11290 */       localSQLException.fillInStackTrace();
/* 11291 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11294 */     return (NClob)createTemporaryClob(this, true, 10, (short)2);
/*       */   }
/*       */ 
/*       */   public SQLXML createSQLXML()
/*       */     throws SQLException
/*       */   {
/* 11314 */     if (this.lifecycle != 1)
/*       */     {
/* 11316 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11317 */       localSQLException.fillInStackTrace();
/* 11318 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11321 */     return new XMLType(this, (String)null);
/*       */   }
/*       */ 
/*       */   public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*       */     throws SQLException
/*       */   {
/* 11337 */     PhysicalConnection localPhysicalConnection1 = this;
/* 11338 */     PhysicalConnection localPhysicalConnection2 = (PhysicalConnection)paramOracleConnection.getPhysicalConnection();
/*       */ 
/* 11340 */     return (localPhysicalConnection1 == localPhysicalConnection2) || (localPhysicalConnection1.url.equals(localPhysicalConnection2.url)) || ((localPhysicalConnection2.protocol != null) && (localPhysicalConnection2.protocol.equals("kprb")));
/*       */   }
/*       */ 
/*       */   boolean useLittleEndianSetCHARBinder()
/*       */     throws SQLException
/*       */   {
/* 11349 */     return false;
/*       */   }
/*       */ 
/*       */   public void setPlsqlWarnings(String paramString)
/*       */     throws SQLException
/*       */   {
/* 11375 */     if (paramString == null)
/*       */     {
/* 11377 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 11378 */       ((SQLException)localObject1).fillInStackTrace();
/* 11379 */       throw ((Throwable)localObject1);
/*       */     }
/*       */ 
/* 11382 */     if ((paramString != null) && ((paramString = paramString.trim()).length() > 0) && (!OracleSql.isValidPlsqlWarning(paramString)))
/*       */     {
/* 11386 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 11387 */       ((SQLException)localObject1).fillInStackTrace();
/* 11388 */       throw ((Throwable)localObject1);
/*       */     }
/*       */ 
/* 11391 */     Object localObject1 = "ALTER SESSION SET PLSQL_WARNINGS=" + paramString;
/*       */ 
/* 11393 */     String str = "ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'";
/*       */ 
/* 11396 */     Statement localStatement = null;
/*       */     try
/*       */     {
/* 11399 */       localStatement = createStatement(-1, -1);
/*       */ 
/* 11401 */       localStatement.execute((String)localObject1);
/*       */ 
/* 11403 */       if (paramString.equals("'DISABLE:ALL'"))
/*       */       {
/* 11405 */         this.plsqlCompilerWarnings = false;
/*       */       }
/*       */       else
/*       */       {
/* 11409 */         localStatement.execute(str);
/*       */ 
/* 11411 */         this.plsqlCompilerWarnings = true;
/*       */       }
/*       */     }
/*       */     finally {
/* 11415 */       if (localStatement != null)
/* 11416 */         localStatement.close();
/*       */     }
/*       */   }
/*       */ 
/*       */   void internalClose()
/*       */     throws SQLException
/*       */   {
/* 11429 */     this.lifecycle = 4;
/*       */ 
/* 11431 */     Object localObject = this.statements;
/*       */     OracleStatement localOracleStatement;
/* 11433 */     while (localObject != null)
/*       */     {
/* 11435 */       localOracleStatement = ((OracleStatement)localObject).nextChild;
/*       */ 
/* 11437 */       if (((OracleStatement)localObject).serverCursor)
/*       */       {
/* 11439 */         ((OracleStatement)localObject).internalClose();
/* 11440 */         removeStatement((OracleStatement)localObject);
/*       */       }
/*       */ 
/* 11443 */       localObject = localOracleStatement;
/*       */     }
/*       */ 
/* 11446 */     localObject = this.statements;
/*       */ 
/* 11448 */     while (localObject != null)
/*       */     {
/* 11450 */       localOracleStatement = ((OracleStatement)localObject).next;
/* 11451 */       ((OracleStatement)localObject).internalClose();
/* 11452 */       localObject = localOracleStatement;
/*       */     }
/*       */ 
/* 11455 */     this.statements = null;
/*       */   }
/*       */ 
/*       */   public XAResource getXAResource()
/*       */     throws SQLException
/*       */   {
/* 11476 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 164);
/* 11477 */     localSQLException.fillInStackTrace();
/* 11478 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   protected void doDescribeTable(AutoKeyInfo paramAutoKeyInfo)
/*       */     throws SQLException
/*       */   {
/* 11491 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11492 */     localSQLException.fillInStackTrace();
/* 11493 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setClientInfo(String paramString1, String paramString2)
/*       */     throws SQLClientInfoException
/*       */   {
/* 11537 */     SecurityManager localSecurityManager = System.getSecurityManager();
/* 11538 */     if (localSecurityManager != null) {
/* 11539 */       OracleSQLPermission localOracleSQLPermission = new OracleSQLPermission("clientInfo." + paramString1);
/*       */ 
/* 11541 */       localSecurityManager.checkPermission(localOracleSQLPermission);
/*       */     }
/* 11543 */     setClientInfoInternal(paramString1, paramString2);
/*       */   }
/*       */ 
/*       */   public void setClientInfo(Properties paramProperties)
/*       */     throws SQLClientInfoException
/*       */   {
/* 11565 */     SecurityManager localSecurityManager = System.getSecurityManager();
/* 11566 */     if (localSecurityManager != null) {
/* 11567 */       localObject1 = new OracleSQLPermission("clientInfo.*");
/*       */ 
/* 11569 */       localSecurityManager.checkPermission((Permission)localObject1);
/*       */     }
/* 11571 */     this.clientInfo.clear();
/* 11572 */     Object localObject1 = new HashMap();
/* 11573 */     for (Object localObject2 = paramProperties.stringPropertyNames().iterator(); ((Iterator)localObject2).hasNext(); ) { String str1 = (String)((Iterator)localObject2).next();
/* 11574 */       String str2 = paramProperties.getProperty(str1);
/*       */       try {
/* 11576 */         setClientInfoInternal(str1, str2);
/*       */       }
/*       */       catch (SQLClientInfoException localSQLClientInfoException) {
/* 11579 */         ((Map)localObject1).put(str1, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
/*       */       }
/*       */     }
/* 11582 */     if (!((Map)localObject1).isEmpty())
/*       */     {
/* 11584 */       localObject2 = DatabaseError.createSQLClientInfoException(253, (Map)localObject1, null);
/* 11585 */       ((SQLClientInfoException)localObject2).fillInStackTrace();
/* 11586 */       throw ((Throwable)localObject2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setClientInfoInternal(String paramString1, String paramString2)
/*       */     throws SQLClientInfoException
/*       */   {
/* 11611 */     if (!SUPPORTED_NAME_PATTERN.matcher(paramString1).matches())
/*       */     {
/* 11613 */       localObject = DatabaseError.createSQLClientInfoException(253, null, null);
/* 11614 */       ((SQLClientInfoException)localObject).fillInStackTrace();
/* 11615 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 11618 */     Object localObject = paramString1.split("\\.", 2);
/* 11619 */     if (RESERVED_NAMESPACES.contains(localObject[0]))
/*       */     {
/* 11621 */       localSQLClientInfoException1 = DatabaseError.createSQLClientInfoException(276, null, null);
/* 11622 */       localSQLClientInfoException1.fillInStackTrace();
/* 11623 */       throw localSQLClientInfoException1;
/*       */     }
/*       */ 
/* 11627 */     SQLClientInfoException localSQLClientInfoException1 = localObject[0];
/* 11628 */     String str = localObject[1];
/*       */     try
/*       */     {
/*       */       SQLException localSQLException2;
/* 11632 */       if (localSQLClientInfoException1.equals("OCSID"))
/*       */       {
/*       */         SQLException localSQLException1;
/* 11634 */         if (str.equals("ACTION")) {
/* 11635 */           if ((paramString2 != null) && (paramString2.length() > this.endToEndMaxLength[0]))
/*       */           {
/* 11637 */             localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, paramString2);
/* 11638 */             localSQLException1.fillInStackTrace();
/* 11639 */             throw localSQLException1;
/*       */           }
/* 11641 */           if (((paramString2 == null) && (this.endToEndValues[0] != null)) || ((paramString2 != null) && (!paramString2.equals(this.endToEndValues[0]))))
/*       */           {
/* 11643 */             this.endToEndValues[0] = paramString2;
/* 11644 */             this.endToEndHasChanged[0] = true;
/* 11645 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */         }
/* 11648 */         else if (str.equals("CLIENTID")) {
/* 11649 */           if ((paramString2 != null) && (paramString2.length() > this.endToEndMaxLength[1]))
/*       */           {
/* 11651 */             localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, paramString2);
/* 11652 */             localSQLException1.fillInStackTrace();
/* 11653 */             throw localSQLException1;
/*       */           }
/* 11655 */           if (((paramString2 == null) && (this.endToEndValues[1] != null)) || ((paramString2 != null) && (!paramString2.equals(this.endToEndValues[1]))))
/*       */           {
/* 11657 */             this.endToEndValues[1] = paramString2;
/* 11658 */             this.endToEndHasChanged[1] = true;
/* 11659 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */         }
/* 11662 */         else if (str.equals("ECID")) {
/* 11663 */           if ((paramString2 != null) && (paramString2.length() > this.endToEndMaxLength[2]))
/*       */           {
/* 11665 */             localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, paramString2);
/* 11666 */             localSQLException1.fillInStackTrace();
/* 11667 */             throw localSQLException1;
/*       */           }
/* 11669 */           if (((paramString2 == null) && (this.endToEndValues[2] != null)) || ((paramString2 != null) && (!paramString2.equals(this.endToEndValues[2]))))
/*       */           {
/* 11671 */             this.endToEndValues[2] = paramString2;
/* 11672 */             this.endToEndHasChanged[2] = true;
/* 11673 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */         }
/* 11676 */         else if (str.equals("MODULE")) {
/* 11677 */           if ((paramString2 != null) && (paramString2.length() > this.endToEndMaxLength[3]))
/*       */           {
/* 11679 */             localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, paramString2);
/* 11680 */             localSQLException1.fillInStackTrace();
/* 11681 */             throw localSQLException1;
/*       */           }
/* 11683 */           if (((paramString2 == null) && (this.endToEndValues[3] != null)) || ((paramString2 != null) && (!paramString2.equals(this.endToEndValues[3]))))
/*       */           {
/* 11685 */             this.endToEndValues[3] = paramString2;
/* 11686 */             this.endToEndHasChanged[3] = true;
/* 11687 */             this.endToEndHasChanged[0] = true;
/* 11688 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */         }
/* 11691 */         else if (str.equals("SEQUENCE_NUMBER")) {
/* 11692 */           short s = 0;
/* 11693 */           if (paramString2 != null) {
/*       */             try {
/* 11695 */               s = Short.valueOf(paramString2).shortValue();
/*       */             }
/*       */             catch (NumberFormatException localNumberFormatException)
/*       */             {
/* 11699 */               SQLException localSQLException4 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 160, paramString2);
/* 11700 */               localSQLException4.fillInStackTrace();
/* 11701 */               throw localSQLException4;
/*       */             }
/*       */           }
/*       */ 
/* 11705 */           this.endToEndECIDSequenceNumber = s;
/* 11706 */           this.endToEndAnyChanged = true;
/*       */         }
/* 11708 */         else if (str.equals("DBOP")) {
/* 11709 */           if ((paramString2 != null) && (paramString2.length() > this.endToEndMaxLength[4]))
/*       */           {
/* 11711 */             localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 159, paramString2);
/* 11712 */             localSQLException2.fillInStackTrace();
/* 11713 */             throw localSQLException2;
/*       */           }
/* 11715 */           if (((paramString2 == null) && (this.endToEndValues[4] != null)) || ((paramString2 != null) && (!paramString2.equals(this.endToEndValues[4]))))
/*       */           {
/* 11717 */             this.endToEndValues[4] = paramString2;
/* 11718 */             this.endToEndHasChanged[4] = true;
/* 11719 */             this.endToEndAnyChanged = true;
/*       */           }
/*       */         }
/*       */         else {
/* 11723 */           localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 253, "OCSID." + str);
/* 11724 */           localSQLException2.fillInStackTrace();
/* 11725 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */       else {
/* 11729 */         if (str.length() > 30)
/*       */         {
/* 11731 */           localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 171);
/*       */ 
/* 11733 */           localSQLException2.fillInStackTrace();
/* 11734 */           throw localSQLException2;
/*       */         }
/*       */ 
/* 11737 */         if ((paramString2 != null) && (paramString2.length() > 4000))
/*       */         {
/* 11739 */           localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 172);
/*       */ 
/* 11741 */           localSQLException2.fillInStackTrace();
/* 11742 */           throw localSQLException2;
/*       */         }
/*       */ 
/* 11745 */         doSetApplicationContext(localSQLClientInfoException1, str, paramString2 == null ? "" : paramString2);
/*       */       }
/* 11747 */       if (paramString2 == null) this.clientInfo.remove(paramString1); else
/* 11748 */         this.clientInfo.put(paramString1, paramString2);
/*       */     }
/*       */     catch (SQLException localSQLException3)
/*       */     {
/* 11752 */       SQLClientInfoException localSQLClientInfoException2 = DatabaseError.createSQLClientInfoException(1, null, localSQLException3);
/* 11753 */       localSQLClientInfoException2.fillInStackTrace();
/* 11754 */       throw localSQLClientInfoException2;
/*       */     }
/*       */   }
/*       */ 
/*       */   public String getClientInfo(String paramString)
/*       */     throws SQLException
/*       */   {
/*       */     Object localObject;
/* 11777 */     if (isClosed())
/*       */     {
/* 11779 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11780 */       ((SQLException)localObject).fillInStackTrace();
/* 11781 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 11784 */     if (paramString == null) {
/* 11785 */       return null;
/*       */     }
/* 11787 */     if (!SUPPORTED_NAME_PATTERN.matcher(paramString).matches())
/*       */     {
/* 11790 */       localObject = DatabaseError.createSQLClientInfoException(253, null, null);
/* 11791 */       ((SQLClientInfoException)localObject).fillInStackTrace();
/* 11792 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 11797 */     return this.clientInfo.getProperty(paramString);
/*       */   }
/*       */ 
/*       */   public Properties getClientInfo()
/*       */     throws SQLException
/*       */   {
/* 11819 */     if (isClosed())
/*       */     {
/* 11821 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 11822 */       localSQLException.fillInStackTrace();
/* 11823 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11826 */     return (Properties)this.clientInfo.clone();
/*       */   }
/*       */ 
/*       */   public void setApplicationContext(String paramString1, String paramString2, String paramString3)
/*       */     throws SQLException
/*       */   {
/* 11843 */     if (paramString2 == null) {
/* 11844 */       throw new NullPointerException();
/*       */     }
/* 11846 */     if ((paramString1 == null) || (paramString1.equals("")))
/*       */     {
/* 11848 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 170);
/*       */ 
/* 11850 */       localSQLException.fillInStackTrace();
/* 11851 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11854 */     setClientInfoInternal(paramString1 + "." + paramString2, paramString3);
/*       */   }
/*       */ 
/*       */   void doSetApplicationContext(String paramString1, String paramString2, String paramString3)
/*       */     throws SQLException
/*       */   {
/* 11868 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11869 */     localSQLException.fillInStackTrace();
/* 11870 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void clearAllApplicationContext(String paramString)
/*       */     throws SQLException
/*       */   {
/* 11886 */     if (paramString == null)
/* 11887 */       throw new NullPointerException();
/*       */     Object localObject;
/* 11888 */     if (paramString.equals(""))
/*       */     {
/* 11890 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 170);
/*       */ 
/* 11892 */       ((SQLException)localObject).fillInStackTrace();
/* 11893 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 11896 */     doClearAllApplicationContext(paramString);
/*       */ 
/* 11898 */     if (!paramString.equals("OCSID"))
/*       */     {
/* 11900 */       for (localObject = this.clientInfo.stringPropertyNames().iterator(); ((Iterator)localObject).hasNext(); ) { String str = (String)((Iterator)localObject).next();
/*       */ 
/* 11902 */         if (str.startsWith(paramString + "."))
/*       */         {
/* 11904 */           this.clientInfo.remove(str);
/*       */         }
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void doClearAllApplicationContext(String paramString)
/*       */     throws SQLException
/*       */   {
/* 11918 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11919 */     localSQLException.fillInStackTrace();
/* 11920 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public byte[] createLightweightSession(String paramString, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*       */     throws SQLException
/*       */   {
/* 11939 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11940 */     localSQLException.fillInStackTrace();
/* 11941 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void executeLightweightSessionRoundtrip(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*       */     throws SQLException
/*       */   {
/* 11955 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11956 */     localSQLException.fillInStackTrace();
/* 11957 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void executeLightweightSessionPiggyback(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2)
/*       */     throws SQLException
/*       */   {
/* 11974 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11975 */     localSQLException.fillInStackTrace();
/* 11976 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSNamespace[][] paramArrayOfXSNamespace1, XSSecureId paramXSSecureId)
/*       */     throws SQLException
/*       */   {
/* 11995 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11996 */     localSQLException.fillInStackTrace();
/* 11997 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSSecureId paramXSSecureId)
/*       */     throws SQLException
/*       */   {
/* 12014 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12015 */     localSQLException.fillInStackTrace();
/* 12016 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode paramXSSessionOperationCode, XSSecureId paramXSSecureId, byte[] paramArrayOfByte, XSPrincipal paramXSPrincipal, String paramString, XSNamespace[] paramArrayOfXSNamespace, OracleConnection.XSSessionModeFlag paramXSSessionModeFlag, XSKeyval paramXSKeyval)
/*       */     throws SQLException
/*       */   {
/* 12038 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12039 */     localSQLException.fillInStackTrace();
/* 12040 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSSessionDestroyOp(byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2)
/*       */     throws SQLException
/*       */   {
/* 12058 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12059 */     localSQLException.fillInStackTrace();
/* 12060 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSSessionDetachOp(int paramInt, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 12078 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12079 */     localSQLException.fillInStackTrace();
/* 12080 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode paramXSSessionSetOperationCode, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, XSSessionParameters paramXSSessionParameters)
/*       */     throws SQLException
/*       */   {
/* 12098 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12099 */     localSQLException.fillInStackTrace();
/* 12100 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void doXSSessionAttachOp(int paramInt1, byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2, XSPrincipal paramXSPrincipal, String[] paramArrayOfString1, String[] paramArrayOfString2, String[] paramArrayOfString3, XSNamespace[] paramArrayOfXSNamespace1, XSNamespace[] paramArrayOfXSNamespace2, XSNamespace[] paramArrayOfXSNamespace3, TIMESTAMPTZ paramTIMESTAMPTZ1, TIMESTAMPTZ paramTIMESTAMPTZ2, int paramInt2, long paramLong, XSKeyval paramXSKeyval, int[] paramArrayOfInt)
/*       */     throws SQLException
/*       */   {
/* 12130 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12131 */     localSQLException.fillInStackTrace();
/* 12132 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void enqueue(String paramString, AQEnqueueOptions paramAQEnqueueOptions, AQMessage paramAQMessage)
/*       */     throws SQLException
/*       */   {
/* 12147 */     AQMessageI localAQMessageI = (AQMessageI)paramAQMessage;
/*       */ 
/* 12149 */     byte[][] arrayOfByte = new byte[1][];
/*       */ 
/* 12153 */     doEnqueue(paramString, paramAQEnqueueOptions, localAQMessageI.getMessagePropertiesI(), localAQMessageI.getPayloadTOID(), localAQMessageI.getPayload(), arrayOfByte, localAQMessageI.isRAWPayload());
/*       */ 
/* 12164 */     if (arrayOfByte[0] != null)
/* 12165 */       localAQMessageI.setMessageId(arrayOfByte[0]);
/*       */   }
/*       */ 
/*       */   public AQMessage dequeue(String paramString, AQDequeueOptions paramAQDequeueOptions, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 12180 */     byte[][] arrayOfByte1 = new byte[1][];
/* 12181 */     AQMessagePropertiesI localAQMessagePropertiesI = new AQMessagePropertiesI();
/* 12182 */     byte[][] arrayOfByte2 = new byte[1][];
/* 12183 */     boolean bool = false;
/*       */ 
/* 12188 */     bool = doDequeue(paramString, paramAQDequeueOptions, localAQMessagePropertiesI, paramArrayOfByte, arrayOfByte2, arrayOfByte1, AQMessageI.compareToid(paramArrayOfByte, TypeDescriptor.RAWTOID));
/*       */ 
/* 12200 */     AQMessageI localAQMessageI = null;
/* 12201 */     if (bool)
/*       */     {
/* 12203 */       localAQMessageI = new AQMessageI(localAQMessagePropertiesI, this);
/* 12204 */       localAQMessageI.setPayload(arrayOfByte2[0], paramArrayOfByte);
/* 12205 */       localAQMessageI.setMessageId(arrayOfByte1[0]);
/*       */     }
/* 12207 */     return localAQMessageI;
/*       */   }
/*       */ 
/*       */   public AQMessage dequeue(String paramString1, AQDequeueOptions paramAQDequeueOptions, String paramString2)
/*       */     throws SQLException
/*       */   {
/* 12226 */     byte[] arrayOfByte = null;
/* 12227 */     TypeDescriptor localTypeDescriptor = null;
/* 12228 */     if (("RAW".equals(paramString2)) || ("SYS.RAW".equals(paramString2)))
/*       */     {
/* 12230 */       arrayOfByte = TypeDescriptor.RAWTOID;
/* 12231 */     } else if ("SYS.ANYDATA".equals(paramString2)) {
/* 12232 */       arrayOfByte = TypeDescriptor.ANYDATATOID;
/* 12233 */     } else if ("SYS.XMLTYPE".equals(paramString2)) {
/* 12234 */       arrayOfByte = TypeDescriptor.XMLTYPETOID;
/*       */     }
/*       */     else {
/* 12237 */       localTypeDescriptor = TypeDescriptor.getTypeDescriptor(paramString2, this);
/* 12238 */       arrayOfByte = ((OracleTypeADT)localTypeDescriptor.getPickler()).getTOID();
/*       */     }
/* 12240 */     AQMessageI localAQMessageI = (AQMessageI)dequeue(paramString1, paramAQDequeueOptions, arrayOfByte);
/* 12241 */     if (localAQMessageI != null)
/*       */     {
/* 12243 */       localAQMessageI.setTypeName(paramString2);
/* 12244 */       localAQMessageI.setTypeDescriptor(localTypeDescriptor);
/*       */     }
/* 12246 */     return localAQMessageI;
/*       */   }
/*       */ 
/*       */   synchronized void doEnqueue(String paramString, AQEnqueueOptions paramAQEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[][] paramArrayOfByte, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 12269 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12270 */     localSQLException.fillInStackTrace();
/* 12271 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   synchronized boolean doDequeue(String paramString, AQDequeueOptions paramAQDequeueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, byte[] paramArrayOfByte, byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 12298 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12299 */     localSQLException.fillInStackTrace();
/* 12300 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void jmsEnqueue(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, JMSMessage paramJMSMessage, AQMessageProperties paramAQMessageProperties)
/*       */     throws SQLException
/*       */   {
/* 12312 */     byte[][] arrayOfByte = new byte[1][];
/* 12313 */     AQMessagePropertiesI localAQMessagePropertiesI = (AQMessagePropertiesI)paramAQMessageProperties;
/* 12314 */     doJMSEnqueue(paramString, paramJMSEnqueueOptions, localAQMessagePropertiesI, paramJMSMessage.getJMSMessageProperties(), paramJMSMessage.getToid(), paramJMSMessage.getPayload(), arrayOfByte);
/*       */ 
/* 12322 */     if (arrayOfByte[0] != null)
/* 12323 */       paramJMSMessage.setMessageId(arrayOfByte[0]);
/*       */   }
/*       */ 
/*       */   synchronized void doJMSEnqueue(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessageProperties paramJMSMessageProperties, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[][] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public JMSMessage jmsDequeue(String paramString1, JMSDequeueOptions paramJMSDequeueOptions, String paramString2)
/*       */     throws SQLException
/*       */   {
/* 12344 */     JMSMessage localJMSMessage = jmsDequeue(paramString1, paramJMSDequeueOptions);
/* 12345 */     return localJMSMessage;
/*       */   }
/*       */ 
/*       */   public JMSMessage jmsDequeue(String paramString, JMSDequeueOptions paramJMSDequeueOptions)
/*       */     throws SQLException
/*       */   {
/* 12353 */     byte[] arrayOfByte = TypeDescriptor.RAWTOID;
/* 12354 */     byte[][] arrayOfByte1 = new byte[1][];
/* 12355 */     AQMessagePropertiesI localAQMessagePropertiesI = new AQMessagePropertiesI();
/* 12356 */     JMSMessagePropertiesI localJMSMessagePropertiesI = new JMSMessagePropertiesI();
/* 12357 */     byte[][] arrayOfByte2 = new byte[1][];
/* 12358 */     boolean bool = false;
/* 12359 */     bool = doJmsDequeue(paramString, paramJMSDequeueOptions, localAQMessagePropertiesI, localJMSMessagePropertiesI, arrayOfByte, arrayOfByte2, arrayOfByte1);
/*       */ 
/* 12368 */     JMSMessage localJMSMessage = null;
/* 12369 */     if (bool)
/*       */     {
/* 12371 */       localJMSMessage = JMSFactory.createJMSMessage(localJMSMessagePropertiesI);
/* 12372 */       localJMSMessage.setPayload(arrayOfByte2[0]);
/* 12373 */       localJMSMessage.setMessageId(arrayOfByte1[0]);
/* 12374 */       localJMSMessage.setJMSMessageProperties(localJMSMessagePropertiesI);
/* 12375 */       localJMSMessage.setAQMessageProperties(localAQMessagePropertiesI);
/*       */     }
/* 12377 */     return localJMSMessage;
/*       */   }
/*       */ 
/*       */   synchronized boolean doJmsDequeue(String paramString, JMSDequeueOptions paramJMSDequeueOptions, AQMessagePropertiesI paramAQMessagePropertiesI, JMSMessagePropertiesI paramJMSMessagePropertiesI, byte[] paramArrayOfByte, byte[][] paramArrayOfByte1, byte[][] paramArrayOfByte2)
/*       */     throws SQLException
/*       */   {
/* 12390 */     return true;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public boolean isV8Compatible()
/*       */     throws SQLException
/*       */   {
/* 12411 */     return this.mapDateToTimestamp;
/*       */   }
/*       */ 
/*       */   public boolean getMapDateToTimestamp()
/*       */   {
/* 12424 */     return this.mapDateToTimestamp;
/*       */   }
/*       */ 
/*       */   public byte getInstanceProperty(OracleConnection.InstanceProperty paramInstanceProperty)
/*       */     throws SQLException
/*       */   {
/* 12437 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12438 */     localSQLException.fillInStackTrace();
/* 12439 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] paramArrayOfString, Map<String, Properties> paramMap)
/*       */     throws SQLException
/*       */   {
/* 12455 */     if ((paramArrayOfString == null) || (paramMap == null))
/*       */     {
/* 12457 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "name and options cannot be null");
/*       */ 
/* 12459 */       ((SQLException)localObject).fillInStackTrace();
/* 12460 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12463 */     Object localObject = doRegisterJMSNotification(paramArrayOfString, paramMap);
/*       */ 
/* 12466 */     return localObject;
/*       */   }
/*       */ 
/*       */   Map<String, JMSNotificationRegistration> doRegisterJMSNotification(String[] paramArrayOfString, Map<String, Properties> paramMap)
/*       */     throws SQLException
/*       */   {
/* 12474 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12475 */     localSQLException.fillInStackTrace();
/* 12476 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void unregisterJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration)
/*       */     throws SQLException
/*       */   {
/* 12487 */     if (paramJMSNotificationRegistration == null)
/*       */     {
/* 12489 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "registration cannot be null");
/*       */ 
/* 12491 */       ((SQLException)localObject).fillInStackTrace();
/* 12492 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12495 */     Object localObject = (NTFJMSRegistration)paramJMSNotificationRegistration;
/* 12496 */     doUnregisterJMSNotification((NTFJMSRegistration)localObject);
/*       */   }
/*       */ 
/*       */   void doUnregisterJMSNotification(NTFJMSRegistration paramNTFJMSRegistration)
/*       */     throws SQLException
/*       */   {
/* 12504 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12505 */     localSQLException.fillInStackTrace();
/* 12506 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void ackJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration, byte[] paramArrayOfByte, JMSNotificationRegistration.Directive paramDirective)
/*       */     throws SQLException
/*       */   {
/* 12546 */     if ((paramDirective == null) || (paramJMSNotificationRegistration == null) || (paramArrayOfByte == null))
/*       */     {
/* 12548 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "directive,registration or lastMessageID cannot be null");
/*       */ 
/* 12550 */       localSQLException.fillInStackTrace();
/* 12551 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12554 */     short s = paramDirective.getCode();
/* 12555 */     doAckJMSNtfn((NTFJMSRegistration)paramJMSNotificationRegistration, paramArrayOfByte, s);
/*       */   }
/*       */ 
/*       */   void doAckJMSNtfn(NTFJMSRegistration paramNTFJMSRegistration, byte[] paramArrayOfByte, short paramShort)
/*       */     throws SQLException
/*       */   {
/* 12569 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12570 */     localSQLException.fillInStackTrace();
/* 12571 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public AQNotificationRegistration[] registerAQNotification(String[] paramArrayOfString, Properties[] paramArrayOfProperties, Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 12585 */     String str = readNTFlocalhost(paramProperties);
/* 12586 */     int i = readNTFtcpport(paramProperties);
/*       */ 
/* 12588 */     NTFAQRegistration[] arrayOfNTFAQRegistration = doRegisterAQNotification(paramArrayOfString, str, i, paramArrayOfProperties);
/*       */ 
/* 12594 */     return (AQNotificationRegistration[])arrayOfNTFAQRegistration;
/*       */   }
/*       */ 
/*       */   NTFAQRegistration[] doRegisterAQNotification(String[] paramArrayOfString, String paramString, int paramInt, Properties[] paramArrayOfProperties)
/*       */     throws SQLException
/*       */   {
/* 12605 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12606 */     localSQLException.fillInStackTrace();
/* 12607 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void unregisterAQNotification(AQNotificationRegistration paramAQNotificationRegistration)
/*       */     throws SQLException
/*       */   {
/* 12617 */     NTFAQRegistration localNTFAQRegistration = (NTFAQRegistration)paramAQNotificationRegistration;
/* 12618 */     doUnregisterAQNotification(localNTFAQRegistration);
/*       */   }
/*       */ 
/*       */   void doUnregisterAQNotification(NTFAQRegistration paramNTFAQRegistration)
/*       */     throws SQLException
/*       */   {
/* 12628 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12629 */     localSQLException.fillInStackTrace();
/* 12630 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   private String readNTFlocalhost(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 12638 */     String str = null;
/*       */     try
/*       */     {
/* 12641 */       str = paramProperties.getProperty("NTF_LOCAL_HOST", InetAddress.getLocalHost().getHostAddress());
/*       */     }
/*       */     catch (UnknownHostException localUnknownHostException)
/*       */     {
/* 12647 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 240);
/*       */ 
/* 12649 */       localSQLException.fillInStackTrace();
/* 12650 */       throw localSQLException;
/*       */     }
/*       */     catch (SecurityException localSecurityException)
/*       */     {
/* 12658 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 241);
/*       */ 
/* 12660 */       localSQLException.fillInStackTrace();
/* 12661 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12664 */     return str;
/*       */   }
/*       */ 
/*       */   private int readNTFtcpport(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 12674 */     int i = 0;
/*       */     try
/*       */     {
/* 12677 */       i = Integer.parseInt(paramProperties.getProperty("NTF_LOCAL_TCP_PORT", "0"));
/*       */ 
/* 12681 */       if (i < 0)
/*       */       {
/* 12683 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 242);
/*       */ 
/* 12685 */         localSQLException1.fillInStackTrace();
/* 12686 */         throw localSQLException1;
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException)
/*       */     {
/* 12692 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 242);
/*       */ 
/* 12694 */       localSQLException2.fillInStackTrace();
/* 12695 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 12698 */     return i;
/*       */   }
/*       */ 
/*       */   int readNTFtimeout(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 12705 */     int i = 0;
/*       */     try
/*       */     {
/* 12708 */       i = Integer.parseInt(paramProperties.getProperty("NTF_TIMEOUT", "0"));
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException)
/*       */     {
/* 12713 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 243);
/*       */ 
/* 12715 */       localSQLException.fillInStackTrace();
/* 12716 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12719 */     return i;
/*       */   }
/*       */ 
/*       */   public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 12728 */     String str = readNTFlocalhost(paramProperties);
/* 12729 */     int i = readNTFtcpport(paramProperties);
/* 12730 */     int j = readNTFtimeout(paramProperties);
/* 12731 */     int k = 0;
/*       */     try
/*       */     {
/* 12735 */       k = Integer.parseInt(paramProperties.getProperty("DCN_NOTIFY_CHANGELAG", "0"));
/*       */     }
/*       */     catch (NumberFormatException localNumberFormatException)
/*       */     {
/* 12739 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 244);
/*       */ 
/* 12741 */       localSQLException.fillInStackTrace();
/* 12742 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12748 */     NTFDCNRegistration localNTFDCNRegistration = doRegisterDatabaseChangeNotification(str, i, paramProperties, j, k);
/*       */ 
/* 12755 */     ntfManager.addRegistration(localNTFDCNRegistration);
/* 12756 */     return localNTFDCNRegistration;
/*       */   }
/*       */ 
/*       */   NTFDCNRegistration doRegisterDatabaseChangeNotification(String paramString, int paramInt1, Properties paramProperties, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/* 12865 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12866 */     localSQLException.fillInStackTrace();
/* 12867 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public DatabaseChangeRegistration getDatabaseChangeRegistration(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 12932 */     NTFDCNRegistration localNTFDCNRegistration = new NTFDCNRegistration(this.dbName, paramInt, this.userName, this.versionNumber);
/* 12933 */     return localNTFDCNRegistration;
/*       */   }
/*       */ 
/*       */   public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration paramDatabaseChangeRegistration)
/*       */     throws SQLException
/*       */   {
/* 12943 */     NTFDCNRegistration localNTFDCNRegistration = (NTFDCNRegistration)paramDatabaseChangeRegistration;
/* 12944 */     if (localNTFDCNRegistration.getDatabaseName().compareToIgnoreCase(this.dbName) != 0)
/*       */     {
/* 12948 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 245);
/*       */ 
/* 12950 */       localSQLException.fillInStackTrace();
/* 12951 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12955 */     doUnregisterDatabaseChangeNotification(localNTFDCNRegistration);
/*       */   }
/*       */ 
/*       */   void doUnregisterDatabaseChangeNotification(NTFDCNRegistration paramNTFDCNRegistration)
/*       */     throws SQLException
/*       */   {
/* 12965 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 12966 */     localSQLException.fillInStackTrace();
/* 12967 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void unregisterDatabaseChangeNotification(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 12977 */     String str = null;
/*       */     try
/*       */     {
/* 12980 */       str = InetAddress.getLocalHost().getHostAddress();
/*       */     }
/*       */     catch (Exception localException)
/*       */     {
/*       */     }
/*       */ 
/* 12986 */     unregisterDatabaseChangeNotification(paramInt, str, 47632);
/*       */   }
/*       */ 
/*       */   public void unregisterDatabaseChangeNotification(int paramInt1, String paramString, int paramInt2)
/*       */     throws SQLException
/*       */   {
/* 12995 */     String str = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + paramString + ")(PORT=" + paramInt2 + "))?PR=0";
/*       */ 
/* 12997 */     unregisterDatabaseChangeNotification(paramInt1, str);
/*       */   }
/*       */ 
/*       */   public void unregisterDatabaseChangeNotification(long paramLong, String paramString)
/*       */     throws SQLException
/*       */   {
/* 13006 */     doUnregisterDatabaseChangeNotification(paramLong, paramString);
/*       */   }
/*       */ 
/*       */   void doUnregisterDatabaseChangeNotification(long paramLong, String paramString)
/*       */     throws SQLException
/*       */   {
/* 13015 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13016 */     localSQLException.fillInStackTrace();
/* 13017 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void addXSEventListener(XSEventListener paramXSEventListener)
/*       */     throws SQLException
/*       */   {
/* 13032 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13033 */     localSQLException.fillInStackTrace();
/* 13034 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void addXSEventListener(XSEventListener paramXSEventListener, Executor paramExecutor)
/*       */     throws SQLException
/*       */   {
/* 13050 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13051 */     localSQLException.fillInStackTrace();
/* 13052 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void removeXSEventListener(XSEventListener paramXSEventListener)
/*       */     throws SQLException
/*       */   {
/* 13067 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13068 */     localSQLException.fillInStackTrace();
/* 13069 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void removeAllXSEventListener()
/*       */     throws SQLException
/*       */   {
/* 13081 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13082 */     localSQLException.fillInStackTrace();
/* 13083 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener)
/*       */     throws SQLException
/*       */   {
/* 13105 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13106 */     localSQLException.fillInStackTrace();
/* 13107 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener, Executor paramExecutor)
/*       */     throws SQLException
/*       */   {
/* 13132 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13133 */     localSQLException.fillInStackTrace();
/* 13134 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*       */     throws SQLException
/*       */   {
/* 13149 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13150 */     localSQLException.fillInStackTrace();
/* 13151 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener, Executor paramExecutor)
/*       */     throws SQLException
/*       */   {
/* 13167 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13168 */     localSQLException.fillInStackTrace();
/* 13169 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*       */     throws SQLException
/*       */   {
/* 13184 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13185 */     localSQLException.fillInStackTrace();
/* 13186 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.LogicalTransactionId getLogicalTransactionId()
/*       */     throws SQLException
/*       */   {
/* 13199 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13200 */     localSQLException.fillInStackTrace();
/* 13201 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema()
/*       */     throws SQLException
/*       */   {
/* 13217 */     TypeDescriptor[] arrayOfTypeDescriptor = null;
/* 13218 */     Statement localStatement = null;
/* 13219 */     beginNonRequestCalls();
/*       */     try
/*       */     {
/* 13222 */       localStatement = createStatement();
/* 13223 */       ResultSet localResultSet = localStatement.executeQuery("SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info())");
/*       */ 
/* 13225 */       arrayOfTypeDescriptor = getTypeDescriptorsFromResultSet(localResultSet);
/* 13226 */       localResultSet.close();
/*       */     }
/*       */     catch (SQLException localSQLException1)
/*       */     {
/* 13230 */       if (localSQLException1.getErrorCode() == 904)
/*       */       {
/* 13233 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 165);
/* 13234 */         localSQLException2.fillInStackTrace();
/* 13235 */         throw localSQLException2;
/*       */       }
/*       */ 
/* 13240 */       throw localSQLException1;
/*       */     }
/*       */     finally
/*       */     {
/* 13245 */       if (localStatement != null) localStatement.close();
/*       */ 
/* 13250 */       endNonRequestCalls();
/*       */     }
/* 13252 */     return arrayOfTypeDescriptor;
/*       */   }
/*       */ 
/*       */   public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] paramArrayOfString)
/*       */     throws SQLException
/*       */   {
/* 13267 */     String str = "SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info(?))";
/* 13268 */     TypeDescriptor[] arrayOfTypeDescriptor = null;
/* 13269 */     PreparedStatement localPreparedStatement = null;
/* 13270 */     beginNonRequestCalls();
/*       */     try {
/* 13272 */       localPreparedStatement = prepareStatement(str);
/* 13273 */       int i = paramArrayOfString.length;
/* 13274 */       localObject1 = new StringBuffer(i * 8);
/* 13275 */       for (int j = 0; j < i; j++)
/*       */       {
/* 13277 */         ((StringBuffer)localObject1).append(paramArrayOfString[j]);
/* 13278 */         if (j < i - 1) ((StringBuffer)localObject1).append(',');
/*       */       }
/* 13280 */       localPreparedStatement.setString(1, ((StringBuffer)localObject1).toString());
/* 13281 */       ResultSet localResultSet = localPreparedStatement.executeQuery();
/* 13282 */       arrayOfTypeDescriptor = getTypeDescriptorsFromResultSet(localResultSet);
/* 13283 */       localResultSet.close();
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*       */       Object localObject1;
/* 13286 */       if (localSQLException.getErrorCode() == 904)
/*       */       {
/* 13288 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 165);
/* 13289 */         ((SQLException)localObject1).fillInStackTrace();
/* 13290 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/* 13294 */       throw localSQLException;
/*       */     }
/*       */     finally
/*       */     {
/* 13298 */       if (localPreparedStatement != null) {
/* 13299 */         localPreparedStatement.close();
/*       */       }
/*       */ 
/* 13304 */       endNonRequestCalls();
/*       */     }
/* 13306 */     return arrayOfTypeDescriptor;
/*       */   }
/*       */ 
/*       */   public TypeDescriptor[] getTypeDescriptorsFromList(String[][] paramArrayOfString)
/*       */     throws SQLException
/*       */   {
/* 13322 */     TypeDescriptor[] arrayOfTypeDescriptor = null;
/* 13323 */     PreparedStatement localPreparedStatement = null;
/* 13324 */     int i = paramArrayOfString.length;
/* 13325 */     StringBuffer localStringBuffer1 = new StringBuffer(i * 8);
/* 13326 */     StringBuffer localStringBuffer2 = new StringBuffer(i * 8);
/* 13327 */     for (int j = 0; j < i; j++)
/*       */     {
/* 13329 */       localStringBuffer1.append(paramArrayOfString[j][0]);
/* 13330 */       localStringBuffer2.append(paramArrayOfString[j][1]);
/* 13331 */       if (j < i - 1)
/*       */       {
/* 13333 */         localStringBuffer1.append(',');
/* 13334 */         localStringBuffer2.append(',');
/*       */       }
/*       */     }
/* 13337 */     beginNonRequestCalls();
/*       */     try
/*       */     {
/* 13340 */       String str = "SELECT schema_name, typename, typoid, typecode, version, tds FROM TABLE(private_jdbc.Get_All_Type_Shape_Info(?,?))";
/*       */ 
/* 13342 */       localPreparedStatement = prepareStatement(str);
/* 13343 */       localPreparedStatement.setString(1, localStringBuffer1.toString());
/* 13344 */       localPreparedStatement.setString(2, localStringBuffer2.toString());
/*       */ 
/* 13346 */       localObject1 = localPreparedStatement.executeQuery();
/* 13347 */       arrayOfTypeDescriptor = getTypeDescriptorsFromResultSet((ResultSet)localObject1);
/* 13348 */       ((ResultSet)localObject1).close();
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*       */       Object localObject1;
/* 13352 */       if (localSQLException.getErrorCode() == 904)
/*       */       {
/* 13355 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 165);
/* 13356 */         ((SQLException)localObject1).fillInStackTrace();
/* 13357 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/* 13362 */       throw localSQLException;
/*       */     }
/*       */     finally
/*       */     {
/* 13367 */       if (localPreparedStatement != null) localPreparedStatement.close();
/*       */ 
/* 13372 */       endNonRequestCalls();
/*       */     }
/* 13374 */     return arrayOfTypeDescriptor;
/*       */   }
/*       */ 
/*       */   TypeDescriptor[] getTypeDescriptorsFromResultSet(ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/* 13395 */     ArrayList localArrayList = new ArrayList();
/*       */     Object localObject2;
/* 13396 */     while (paramResultSet.next())
/*       */     {
/* 13398 */       localObject1 = paramResultSet.getString(1);
/* 13399 */       String str1 = paramResultSet.getString(2);
/* 13400 */       localObject2 = paramResultSet.getBytes(3);
/* 13401 */       String str2 = paramResultSet.getString(4);
/* 13402 */       int j = paramResultSet.getInt(5);
/* 13403 */       byte[] arrayOfByte = paramResultSet.getBytes(6);
/* 13404 */       SQLName localSQLName = new SQLName((String)localObject1, str1, this);
/*       */       Object localObject3;
/* 13405 */       if (str2.equals("OBJECT"))
/*       */       {
/* 13407 */         localObject3 = StructDescriptor.createDescriptor(localSQLName, (byte[])localObject2, j, arrayOfByte, this);
/*       */ 
/* 13411 */         putDescriptor((byte[])localObject2, localObject3);
/* 13412 */         putDescriptor(((TypeDescriptor)localObject3).getName(), localObject3);
/* 13413 */         localArrayList.add(localObject3);
/*       */       }
/* 13415 */       else if (str2.equals("COLLECTION"))
/*       */       {
/* 13417 */         localObject3 = ArrayDescriptor.createDescriptor(localSQLName, (byte[])localObject2, j, arrayOfByte, this);
/*       */ 
/* 13421 */         putDescriptor((byte[])localObject2, localObject3);
/* 13422 */         putDescriptor(((TypeDescriptor)localObject3).getName(), localObject3);
/* 13423 */         localArrayList.add(localObject3);
/*       */       }
/*       */     }
/* 13426 */     Object localObject1 = new TypeDescriptor[localArrayList.size()];
/* 13427 */     for (int i = 0; i < localArrayList.size(); i++)
/*       */     {
/* 13429 */       localObject2 = (TypeDescriptor)localArrayList.get(i);
/* 13430 */       localObject1[i] = localObject2;
/*       */     }
/* 13432 */     return localObject1;
/*       */   }
/*       */ 
/*       */   public synchronized boolean isUsable()
/*       */   {
/* 13449 */     return this.isUsable;
/*       */   }
/*       */ 
/*       */   public void setUsable(boolean paramBoolean)
/*       */   {
/* 13469 */     this.isUsable = paramBoolean;
/*       */   }
/*       */ 
/*       */   void queryFCFProperties(Properties paramProperties)
/*       */     throws SQLException
/*       */   {
/* 13487 */     Statement localStatement = null;
/* 13488 */     ResultSet localResultSet = null;
/* 13489 */     String str1 = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
/*       */     try
/*       */     {
/* 13497 */       localStatement = createStatement();
/* 13498 */       localStatement.setFetchSize(1);
/* 13499 */       localResultSet = localStatement.executeQuery(str1);
/* 13500 */       while (localResultSet.next())
/*       */       {
/* 13502 */         String str2 = null;
/* 13503 */         str2 = localResultSet.getString(1);
/* 13504 */         if (str2 != null) {
/* 13505 */           paramProperties.put("INSTANCE_NAME", str2.trim());
/*       */         }
/* 13507 */         str2 = localResultSet.getString(2);
/* 13508 */         if (str2 != null) {
/* 13509 */           paramProperties.put("SERVER_HOST", str2.trim());
/*       */         }
/*       */ 
/* 13513 */         str2 = localResultSet.getString(3);
/* 13514 */         if (str2 != null) {
/* 13515 */           paramProperties.put("SERVICE_NAME", str2.trim());
/*       */         }
/* 13517 */         str2 = localResultSet.getString(4);
/* 13518 */         if (str2 != null)
/* 13519 */           paramProperties.put("DATABASE_NAME", str2.trim());
/*       */       }
/*       */     }
/*       */     finally {
/* 13523 */       if (localResultSet != null)
/* 13524 */         localResultSet.close();
/* 13525 */       if (localStatement != null)
/* 13526 */         localStatement.close();
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDefaultTimeZone(TimeZone paramTimeZone)
/*       */     throws SQLException
/*       */   {
/* 13539 */     this.defaultTimeZone = paramTimeZone;
/*       */   }
/*       */ 
/*       */   public TimeZone getDefaultTimeZone()
/*       */     throws SQLException
/*       */   {
/* 13551 */     return this.defaultTimeZone;
/*       */   }
/*       */ 
/*       */   public int getTimezoneVersionNumber()
/*       */     throws SQLException
/*       */   {
/* 13560 */     return this.timeZoneVersionNumber;
/*       */   }
/*       */ 
/*       */   public TIMEZONETAB getTIMEZONETAB()
/*       */     throws SQLException
/*       */   {
/* 13570 */     if (this.timeZoneTab == null) {
/* 13571 */       this.timeZoneTab = TIMEZONETAB.getInstance(getTimezoneVersionNumber());
/*       */     }
/* 13573 */     return this.timeZoneTab;
/*       */   }
/*       */ 
/*       */   public boolean isDataInLocatorEnabled()
/*       */     throws SQLException
/*       */   {
/* 13587 */     return (getVersionNumber() >= 10200 ? 1 : 0) & (getVersionNumber() < 11000 ? 1 : 0) & this.enableReadDataInLocator | this.overrideEnableReadDataInLocator;
/*       */   }
/*       */ 
/*       */   public boolean isLobStreamPosStandardCompliant()
/*       */     throws SQLException
/*       */   {
/* 13596 */     return this.lobStreamPosStandardCompliant;
/*       */   }
/*       */ 
/*       */   public long getCurrentSCN()
/*       */     throws SQLException
/*       */   {
/* 13603 */     return doGetCurrentSCN();
/*       */   }
/*       */ 
/*       */   long doGetCurrentSCN()
/*       */     throws SQLException
/*       */   {
/* 13609 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13610 */     localSQLException.fillInStackTrace();
/* 13611 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void doSetSnapshotSCN(long paramLong)
/*       */     throws SQLException
/*       */   {
/* 13618 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13619 */     localSQLException.fillInStackTrace();
/* 13620 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public EnumSet<OracleConnection.TransactionState> getTransactionState()
/*       */     throws SQLException
/*       */   {
/* 13626 */     return doGetTransactionState();
/*       */   }
/*       */ 
/*       */   EnumSet<OracleConnection.TransactionState> doGetTransactionState()
/*       */     throws SQLException
/*       */   {
/* 13632 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13633 */     localSQLException.fillInStackTrace();
/* 13634 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public boolean isConnectionSocketKeepAlive()
/*       */     throws SocketException, SQLException
/*       */   {
/* 13641 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13642 */     localSQLException.fillInStackTrace();
/* 13643 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> paramEnumSet)
/*       */     throws SQLException
/*       */   {
/* 13649 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13650 */     localSQLException.fillInStackTrace();
/* 13651 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void beginNonRequestCalls()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public void endNonRequestCalls()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public void setReplayContext(oracle.jdbc.internal.ReplayContext[] paramArrayOfReplayContext)
/*       */     throws SQLException
/*       */   {
/* 13667 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13668 */     localSQLException.fillInStackTrace();
/* 13669 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setReplayingMode(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 13676 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13677 */     localSQLException.fillInStackTrace();
/* 13678 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void registerEndReplayCallback(OracleConnection.EndReplayCallback paramEndReplayCallback)
/*       */     throws SQLException
/*       */   {
/* 13684 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13685 */     localSQLException.fillInStackTrace();
/* 13686 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public int getEOC()
/*       */     throws SQLException
/*       */   {
/* 13692 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13693 */     localSQLException.fillInStackTrace();
/* 13694 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.internal.ReplayContext[] getReplayContext()
/*       */     throws SQLException
/*       */   {
/* 13700 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13701 */     localSQLException.fillInStackTrace();
/* 13702 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.internal.ReplayContext getLastReplayContext()
/*       */     throws SQLException
/*       */   {
/* 13708 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13709 */     localSQLException.fillInStackTrace();
/* 13710 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public byte[] getDerivedKeyInternal(byte[] paramArrayOfByte, int paramInt)
/*       */     throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException
/*       */   {
/* 13717 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13718 */     localSQLException.fillInStackTrace();
/* 13719 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void releaseConnectionToPool()
/*       */     throws SQLException
/*       */   {
/* 13734 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13735 */     localSQLException.fillInStackTrace();
/* 13736 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   boolean reusePooledConnection()
/*       */     throws SQLException
/*       */   {
/* 13747 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13748 */     localSQLException.fillInStackTrace();
/* 13749 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   void resetAfterReusePooledConnection()
/*       */     throws SQLException
/*       */   {
/* 13758 */     if (needToPurgeStatementCache())
/*       */     {
/* 13760 */       purgeStatementCache();
/*       */     }
/*       */   }
/*       */ 
/*       */   public boolean attachServerConnection()
/*       */     throws SQLException
/*       */   {
/* 13771 */     if (this.lifecycle != 1)
/*       */     {
/* 13773 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 13774 */       localSQLException.fillInStackTrace();
/* 13775 */       throw localSQLException;
/*       */     }
/*       */ 
/* 13778 */     if (!this.drcpEnabled) return true;
/*       */ 
/* 13780 */     return reusePooledConnection();
/*       */   }
/*       */ 
/*       */   public boolean isDRCPEnabled()
/*       */     throws SQLException
/*       */   {
/* 13794 */     return this.drcpEnabled;
/*       */   }
/*       */ 
/*       */   public void detachServerConnection(String paramString)
/*       */     throws SQLException
/*       */   {
/* 13806 */     if (this.lifecycle != 1)
/*       */     {
/* 13808 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 13809 */       localSQLException.fillInStackTrace();
/* 13810 */       throw localSQLException;
/*       */     }
/*       */ 
/* 13813 */     if (!this.drcpEnabled) return;
/* 13814 */     this.drcpTagName = paramString;
/*       */ 
/* 13826 */     purgeStatementCache();
/* 13827 */     closeStatements(false);
/*       */ 
/* 13829 */     releaseConnectionToPool();
/*       */   }
/*       */ 
/*       */   public boolean needToPurgeStatementCache()
/*       */     throws SQLException
/*       */   {
/* 13845 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13846 */     localSQLException.fillInStackTrace();
/* 13847 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public short getExecutingRPCFunctionCode()
/*       */   {
/* 13855 */     return 0;
/*       */   }
/*       */ 
/*       */   public String getExecutingRPCSQL()
/*       */   {
/* 13861 */     return "";
/*       */   }
/*       */ 
/*       */   public int getNegotiatedSDU()
/*       */     throws SQLException
/*       */   {
/* 13867 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 13868 */     localSQLException.fillInStackTrace();
/* 13869 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setChecksumMode(OracleConnection.ChecksumMode paramChecksumMode) throws SQLException
/*       */   {
/* 13874 */     this.checksumMode = paramChecksumMode;
/*       */   }
/*       */ 
/*       */   public int getVarTypeMaxLenCompat()
/*       */     throws SQLException
/*       */   {
/* 13886 */     return this.varTypeMaxLenCompat;
/*       */   }
/*       */ 
/*       */   static final boolean bit(long paramLong1, long paramLong2)
/*       */   {
/* 13891 */     return (paramLong1 & paramLong2) == paramLong2;
/*       */   }
/*       */ 
/*       */   static final boolean bit(int paramInt1, int paramInt2) {
/* 13895 */     return (paramInt1 & paramInt2) == paramInt2;
/*       */   }
/*       */ 
/*       */   void onPDBChange()
/*       */     throws SQLException
/*       */   {
/* 13907 */     removeAllDescriptor();
/*       */ 
/* 13909 */     if (isStatementCacheInitialized()) {
/* 13910 */       this.statementCache.purgeExplicitCache();
/* 13911 */       this.statementCache.purgeImplicitCache();
/*       */     }
/*       */   }
/*       */ 
/*       */   private static final class BufferCacheStore
/*       */   {
/*  8763 */     static int MAX_CACHED_BUFFER_SIZE = 2147483647;
/*       */     final BufferCache<byte[]> byteBufferCache;
/*       */     final BufferCache<char[]> charBufferCache;
/*       */ 
/*       */     BufferCacheStore()
/*       */     {
/*  8768 */       this(MAX_CACHED_BUFFER_SIZE);
/*       */     }
/*       */ 
/*       */     BufferCacheStore(int paramInt) {
/*  8772 */       this.byteBufferCache = new BufferCache(paramInt);
/*  8773 */       this.charBufferCache = new BufferCache(paramInt);
/*       */     }
/*       */   }
/*       */ 
/*       */   static enum DrcpState
/*       */   {
/*   647 */     STATEFUL, STATELESS;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.PhysicalConnection
 * JD-Core Version:    0.6.2
 */