/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class OracleTimeoutThreadPerVM extends OracleTimeout
/*     */ {
/*  27 */   private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
/*     */   private OracleStatement statement;
/*     */   private long interruptAfter;
/*     */   private String name;
/* 201 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleTimeoutThreadPerVM(String paramString)
/*     */   {
/*  44 */     this.name = paramString;
/*  45 */     this.interruptAfter = 9223372036854775807L;
/*  46 */     watchdog.addTimeout(this);
/*     */   }
/*     */ 
/*     */   void close()
/*     */   {
/*  60 */     watchdog.removeTimeout(this);
/*     */   }
/*     */ 
/*     */   synchronized void setTimeout(long paramLong, OracleStatement paramOracleStatement)
/*     */     throws SQLException
/*     */   {
/*  79 */     if (this.interruptAfter != 9223372036854775807L)
/*     */     {
/*  83 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 131);
/*  84 */       localSQLException.fillInStackTrace();
/*  85 */       throw localSQLException;
/*     */     }
/*     */ 
/*  89 */     this.statement = paramOracleStatement;
/*  90 */     this.interruptAfter = (System.currentTimeMillis() + paramLong);
/*     */   }
/*     */ 
/*     */   synchronized void cancelTimeout()
/*     */     throws SQLException
/*     */   {
/* 114 */     this.statement = null;
/* 115 */     this.interruptAfter = 9223372036854775807L;
/*     */   }
/*     */ 
/*     */   void interruptIfAppropriate(long paramLong)
/*     */   {
/* 142 */     if (paramLong > this.interruptAfter)
/*     */     {
/* 144 */       synchronized (this)
/*     */       {
/* 146 */         if (paramLong > this.interruptAfter)
/*     */         {
/* 149 */           if (this.statement.connection.spawnNewThreadToCancel) {
/* 150 */             final OracleStatement localOracleStatement = this.statement;
/* 151 */             Thread localThread = new Thread(new Runnable() {
/*     */               public void run() {
/*     */                 try {
/* 154 */                   localOracleStatement.cancel();
/*     */                 }
/*     */                 catch (Throwable localThrowable)
/*     */                 {
/*     */                 }
/*     */               }
/*     */             });
/* 161 */             localThread.setName("interruptIfAppropriate_" + this);
/* 162 */             localThread.setDaemon(true);
/* 163 */             localThread.setPriority(10);
/* 164 */             localThread.start();
/*     */           }
/*     */           else {
/*     */             try {
/* 168 */               this.statement.cancel();
/*     */             }
/*     */             catch (Throwable localThrowable)
/*     */             {
/*     */             }
/*     */           }
/*     */ 
/* 175 */           this.statement = null;
/* 176 */           this.interruptAfter = 9223372036854775807L;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 195 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleTimeoutThreadPerVM
 * JD-Core Version:    0.6.2
 */