/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ class OracleTimeoutPollingThread extends Thread
/*     */ {
/*     */   protected static final String threadName = "OracleTimeoutPollingThread";
/*     */   public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
/*     */   public static final String pollIntervalDefault = "1000";
/*     */   private OracleTimeoutThreadPerVM[] knownTimeouts;
/*     */   private int count;
/*     */   private long sleepMillis;
/* 215 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleTimeoutPollingThread()
/*     */   {
/*  69 */     super("OracleTimeoutPollingThread");
/*     */ 
/*  71 */     setDaemon(true);
/*  72 */     setPriority(10);
/*     */ 
/*  74 */     this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
/*  75 */     this.count = 0;
/*  76 */     this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
/*     */ 
/*  79 */     start();
/*     */   }
/*     */ 
/*     */   public synchronized void addTimeout(OracleTimeoutThreadPerVM paramOracleTimeoutThreadPerVM)
/*     */   {
/*  90 */     int i = 0;
/*     */ 
/*  92 */     if (this.count >= this.knownTimeouts.length)
/*     */     {
/*  96 */       OracleTimeoutThreadPerVM[] arrayOfOracleTimeoutThreadPerVM = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
/*     */ 
/*  99 */       System.arraycopy(this.knownTimeouts, 0, arrayOfOracleTimeoutThreadPerVM, 0, this.knownTimeouts.length);
/*     */ 
/* 101 */       i = this.knownTimeouts.length;
/* 102 */       this.knownTimeouts = arrayOfOracleTimeoutThreadPerVM;
/*     */     }
/*     */ 
/* 105 */     for (; i < this.knownTimeouts.length; i++)
/*     */     {
/* 107 */       if (this.knownTimeouts[i] == null)
/*     */       {
/* 109 */         this.knownTimeouts[i] = paramOracleTimeoutThreadPerVM;
/* 110 */         this.count += 1;
/*     */ 
/* 113 */         break;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void removeTimeout(OracleTimeoutThreadPerVM paramOracleTimeoutThreadPerVM)
/*     */   {
/* 126 */     for (int i = 0; i < this.knownTimeouts.length; i++)
/*     */     {
/* 128 */       if (this.knownTimeouts[i] == paramOracleTimeoutThreadPerVM)
/*     */       {
/* 130 */         this.knownTimeouts[i] = null;
/* 131 */         this.count -= 1;
/*     */ 
/* 133 */         break;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     while (true)
/*     */     {
/*     */       try
/*     */       {
/* 148 */         Thread.sleep(this.sleepMillis);
/*     */       }
/*     */       catch (InterruptedException localInterruptedException)
/*     */       {
/*     */       }
/*     */ 
/* 156 */       pollOnce();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void pollOnce()
/*     */   {
/* 193 */     if (this.count > 0)
/*     */     {
/* 195 */       long l = System.currentTimeMillis();
/*     */ 
/* 197 */       for (int i = 0; i < this.knownTimeouts.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 201 */           if (this.knownTimeouts[i] != null)
/* 202 */             this.knownTimeouts[i].interruptIfAppropriate(l);
/*     */         }
/*     */         catch (NullPointerException localNullPointerException)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleTimeoutPollingThread
 * JD-Core Version:    0.6.2
 */