/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLWarning;
/*     */ import oracle.jdbc.dcn.DatabaseChangeRegistration;
/*     */ import oracle.jdbc.internal.OracleCallableStatement;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleStatement.BindChecksumListener;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class OracleStatementWrapper
/*     */   implements oracle.jdbc.internal.OracleStatement
/*     */ {
/*     */   private Object forEquals;
/*     */   protected oracle.jdbc.internal.OracleStatement statement;
/*  69 */   static final OracleCallableStatement closedStatement = new OracleClosedStatement();
/*     */ 
/* 708 */   OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/* 709 */   long checkSum = 0L;
/* 710 */   boolean checkSumComputationFailure = false;
/*     */   Object acProxy;
/* 760 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleStatementWrapper(oracle.jdbc.OracleStatement paramOracleStatement)
/*     */     throws SQLException
/*     */   {
/*  78 */     this.forEquals = paramOracleStatement;
/*     */ 
/*  80 */     this.statement = ((oracle.jdbc.internal.OracleStatement)paramOracleStatement);
/*  81 */     ((Wrappable)paramOracleStatement).setWrapper(this);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws SQLException
/*     */   {
/*  89 */     if (this.statement == closedStatement) {
/*  90 */       return;
/*     */     }
/*     */ 
/*  94 */     this.checkSum = (((OracleStatement)this.statement).checkSum = this.checkSum);
/*     */ 
/*  96 */     this.checkSumComputationFailure = ((OracleStatement)this.statement).checkSumComputationFailure;
/*     */ 
/*  98 */     this.sqlKind = ((OracleStatement)this.statement).sqlKind;
/*     */ 
/* 100 */     this.statement.close();
/*     */ 
/* 102 */     ((Wrappable)this.statement).setWrapper(null);
/* 103 */     this.statement = closedStatement;
/*     */   }
/*     */ 
/*     */   void beClosed()
/*     */     throws SQLException
/*     */   {
/* 109 */     this.statement = closedStatement;
/*     */   }
/*     */ 
/*     */   public void closeWithKey(String paramString)
/*     */     throws SQLException
/*     */   {
/* 116 */     this.statement.closeWithKey(paramString);
/* 117 */     this.statement = closedStatement;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/* 122 */     return (paramObject != null) && (getClass() == paramObject.getClass()) && (this.forEquals == ((OracleStatementWrapper)paramObject).forEquals);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 128 */     return this.forEquals.hashCode();
/*     */   }
/*     */ 
/*     */   public int getFetchDirection()
/*     */     throws SQLException
/*     */   {
/* 140 */     return this.statement.getFetchDirection();
/*     */   }
/*     */ 
/*     */   public int getFetchSize()
/*     */     throws SQLException
/*     */   {
/* 148 */     return this.statement.getFetchSize();
/*     */   }
/*     */ 
/*     */   public int getMaxFieldSize()
/*     */     throws SQLException
/*     */   {
/* 156 */     return this.statement.getMaxFieldSize();
/*     */   }
/*     */ 
/*     */   public int getMaxRows()
/*     */     throws SQLException
/*     */   {
/* 164 */     return this.statement.getMaxRows();
/*     */   }
/*     */ 
/*     */   public int getQueryTimeout()
/*     */     throws SQLException
/*     */   {
/* 172 */     return this.statement.getQueryTimeout();
/*     */   }
/*     */ 
/*     */   public int getResultSetConcurrency()
/*     */     throws SQLException
/*     */   {
/* 180 */     return this.statement.getResultSetConcurrency();
/*     */   }
/*     */ 
/*     */   public int getResultSetHoldability()
/*     */     throws SQLException
/*     */   {
/* 188 */     return this.statement.getResultSetHoldability();
/*     */   }
/*     */ 
/*     */   public int getResultSetType()
/*     */     throws SQLException
/*     */   {
/* 196 */     return this.statement.getResultSetType();
/*     */   }
/*     */ 
/*     */   public int getUpdateCount()
/*     */     throws SQLException
/*     */   {
/* 204 */     return this.statement.getUpdateCount();
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */     throws SQLException
/*     */   {
/* 212 */     this.statement.cancel();
/*     */   }
/*     */ 
/*     */   public void clearBatch()
/*     */     throws SQLException
/*     */   {
/* 220 */     this.statement.clearBatch();
/*     */   }
/*     */ 
/*     */   public void clearWarnings()
/*     */     throws SQLException
/*     */   {
/* 228 */     this.statement.clearWarnings();
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults()
/*     */     throws SQLException
/*     */   {
/* 236 */     return this.statement.getMoreResults();
/*     */   }
/*     */ 
/*     */   public int[] executeBatch()
/*     */     throws SQLException
/*     */   {
/* 244 */     return this.statement.executeBatch();
/*     */   }
/*     */ 
/*     */   public void setFetchDirection(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 252 */     this.statement.setFetchDirection(paramInt);
/*     */   }
/*     */ 
/*     */   public void setFetchSize(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 260 */     this.statement.setFetchSize(paramInt);
/*     */   }
/*     */ 
/*     */   public void setMaxFieldSize(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 268 */     this.statement.setMaxFieldSize(paramInt);
/*     */   }
/*     */ 
/*     */   public void setMaxRows(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 276 */     this.statement.setMaxRows(paramInt);
/*     */   }
/*     */ 
/*     */   public void setQueryTimeout(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 284 */     this.statement.setQueryTimeout(paramInt);
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 292 */     return this.statement.getMoreResults(paramInt);
/*     */   }
/*     */ 
/*     */   public void setEscapeProcessing(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 300 */     this.statement.setEscapeProcessing(paramBoolean);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString)
/*     */     throws SQLException
/*     */   {
/* 308 */     return this.statement.executeUpdate(paramString);
/*     */   }
/*     */ 
/*     */   public void addBatch(String paramString)
/*     */     throws SQLException
/*     */   {
/* 316 */     this.statement.addBatch(paramString);
/*     */   }
/*     */ 
/*     */   public void setCursorName(String paramString)
/*     */     throws SQLException
/*     */   {
/* 324 */     this.statement.setCursorName(paramString);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString)
/*     */     throws SQLException
/*     */   {
/* 332 */     return this.statement.execute(paramString);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 340 */     return this.statement.executeUpdate(paramString, paramInt);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 348 */     return this.statement.execute(paramString, paramInt);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 356 */     return this.statement.executeUpdate(paramString, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 364 */     return this.statement.execute(paramString, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   public Connection getConnection()
/*     */     throws SQLException
/*     */   {
/* 372 */     return this.statement.getConnection();
/*     */   }
/*     */ 
/*     */   public ResultSet getGeneratedKeys()
/*     */     throws SQLException
/*     */   {
/* 380 */     return this.statement.getGeneratedKeys();
/*     */   }
/*     */ 
/*     */   public ResultSet getResultSet()
/*     */     throws SQLException
/*     */   {
/* 388 */     return this.statement.getResultSet();
/*     */   }
/*     */ 
/*     */   public SQLWarning getWarnings()
/*     */     throws SQLException
/*     */   {
/* 396 */     return this.statement.getWarnings();
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 404 */     return this.statement.executeUpdate(paramString, paramArrayOfString);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 412 */     return this.statement.execute(paramString, paramArrayOfString);
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery(String paramString)
/*     */     throws SQLException
/*     */   {
/* 420 */     return this.statement.executeQuery(paramString);
/*     */   }
/*     */ 
/*     */   public void clearDefines()
/*     */     throws SQLException
/*     */   {
/* 434 */     this.statement.clearDefines();
/*     */   }
/*     */ 
/*     */   public void defineColumnType(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 442 */     this.statement.defineColumnType(paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public void defineColumnType(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 450 */     this.statement.defineColumnType(paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public void defineColumnType(int paramInt1, int paramInt2, int paramInt3, short paramShort)
/*     */     throws SQLException
/*     */   {
/* 458 */     this.statement.defineColumnType(paramInt1, paramInt2, paramInt3, paramShort);
/*     */   }
/*     */ 
/*     */   public void defineColumnTypeBytes(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 466 */     this.statement.defineColumnTypeBytes(paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public void defineColumnTypeChars(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 474 */     this.statement.defineColumnTypeChars(paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public void defineColumnType(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/* 482 */     this.statement.defineColumnType(paramInt1, paramInt2, paramString);
/*     */   }
/*     */ 
/*     */   public int getRowPrefetch()
/*     */   {
/* 489 */     return this.statement.getRowPrefetch();
/*     */   }
/*     */ 
/*     */   public void setRowPrefetch(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 497 */     this.statement.setRowPrefetch(paramInt);
/*     */   }
/*     */ 
/*     */   public int getLobPrefetchSize()
/*     */     throws SQLException
/*     */   {
/* 503 */     return this.statement.getLobPrefetchSize();
/*     */   }
/*     */ 
/*     */   public void setLobPrefetchSize(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 510 */     this.statement.setLobPrefetchSize(paramInt);
/*     */   }
/*     */ 
/*     */   public int creationState()
/*     */   {
/* 518 */     return this.statement.creationState();
/*     */   }
/*     */ 
/*     */   public boolean isNCHAR(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 526 */     return this.statement.isNCHAR(paramInt);
/*     */   }
/*     */ 
/*     */   public void setDatabaseChangeRegistration(DatabaseChangeRegistration paramDatabaseChangeRegistration)
/*     */     throws SQLException
/*     */   {
/* 535 */     this.statement.setDatabaseChangeRegistration(paramDatabaseChangeRegistration);
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */     throws SQLException
/*     */   {
/* 544 */     return this.statement.isClosed();
/*     */   }
/*     */ 
/*     */   public boolean isPoolable()
/*     */     throws SQLException
/*     */   {
/* 552 */     return this.statement.isPoolable();
/*     */   }
/*     */ 
/*     */   public void setPoolable(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 558 */     this.statement.setPoolable(paramBoolean);
/*     */   }
/*     */ 
/*     */   public boolean isWrapperFor(Class<?> paramClass)
/*     */     throws SQLException
/*     */   {
/* 578 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*     */ 
/* 580 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 581 */     localSQLException.fillInStackTrace();
/* 582 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public <T> T unwrap(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 605 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*     */ 
/* 607 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 608 */     localSQLException.fillInStackTrace();
/* 609 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void setFixedString(boolean paramBoolean)
/*     */   {
/* 625 */     this.statement.setFixedString(paramBoolean);
/*     */   }
/*     */ 
/*     */   public boolean getFixedString()
/*     */   {
/* 632 */     return this.statement.getFixedString();
/*     */   }
/*     */ 
/*     */   public int sendBatch()
/*     */     throws SQLException
/*     */   {
/* 639 */     return this.statement.sendBatch();
/*     */   }
/*     */ 
/*     */   public boolean getserverCursor()
/*     */   {
/* 646 */     return this.statement.getserverCursor();
/*     */   }
/*     */ 
/*     */   public int getcacheState()
/*     */   {
/* 653 */     return this.statement.getcacheState();
/*     */   }
/*     */ 
/*     */   public int getstatementType()
/*     */   {
/* 661 */     return this.statement.getstatementType();
/*     */   }
/*     */ 
/*     */   public String[] getRegisteredTableNames()
/*     */     throws SQLException
/*     */   {
/* 668 */     return this.statement.getRegisteredTableNames();
/*     */   }
/*     */ 
/*     */   public long getRegisteredQueryId()
/*     */     throws SQLException
/*     */   {
/* 675 */     return this.statement.getRegisteredQueryId();
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 690 */     return null;
/*     */   }
/*     */ 
/*     */   public void setSnapshotSCN(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 697 */     this.statement.setSnapshotSCN(paramLong);
/*     */   }
/*     */ 
/*     */   public OracleStatement.SqlKind getSqlKind()
/*     */     throws SQLException
/*     */   {
/* 704 */     return this.statement == closedStatement ? this.sqlKind : this.statement.getSqlKind();
/*     */   }
/*     */ 
/*     */   public long getChecksum()
/*     */     throws SQLException
/*     */   {
/* 720 */     if (this.statement != closedStatement) {
/* 721 */       return this.statement.getChecksum();
/*     */     }
/*     */ 
/* 724 */     if (this.checkSumComputationFailure)
/*     */     {
/* 726 */       SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 727 */       localSQLException.fillInStackTrace();
/* 728 */       throw localSQLException;
/*     */     }
/*     */ 
/* 731 */     return this.checkSum;
/*     */   }
/*     */ 
/*     */   public void registerBindChecksumListener(OracleStatement.BindChecksumListener paramBindChecksumListener)
/*     */     throws SQLException
/*     */   {
/* 743 */     this.statement.registerBindChecksumListener(paramBindChecksumListener);
/*     */   }
/*     */ 
/*     */   public void setACProxy(Object paramObject)
/*     */   {
/* 751 */     this.acProxy = paramObject;
/*     */   }
/*     */ 
/*     */   public Object getACProxy()
/*     */   {
/* 756 */     return this.acProxy;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleStatementWrapper
 * JD-Core Version:    0.6.2
 */