/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.nio.ByteBuffer;
/*      */ import java.sql.BatchUpdateException;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayDeque;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Calendar;
/*      */ import java.util.Iterator;
/*      */ import java.util.Locale;
/*      */ import java.util.TimeZone;
/*      */ import java.util.Vector;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.jdbc.dcn.DatabaseChangeRegistration;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleStatement.BindChecksumListener;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ROWID;
/*      */ 
/*      */ abstract class OracleStatement extends GeneratedStatement
/*      */   implements oracle.jdbc.internal.OracleStatement, Wrappable<OracleStatementWrapper>
/*      */ {
/*      */   byte[] defineBytes;
/*      */   char[] defineChars;
/*      */   short[] defineIndicators;
/*      */   int[] returnParamMeta;
/*      */   static final int PLAIN_STMT = 0;
/*      */   static final int PREP_STMT = 1;
/*      */   static final int CALL_STMT = 2;
/*      */   static final int METADATALENGTH = 1;
/*      */   static final int VALID_ROWS_UNINIT = -999;
/*      */   static final byte EXECUTE_NONE = -1;
/*      */   static final byte EXECUTE_QUERY = 1;
/*      */   static final byte EXECUTE_UPDATE = 2;
/*      */   static final byte EXECUTE_NORMAL = 3;
/*      */   static final int DMLR_METADATA_PREFIX_SIZE = 3;
/*      */   static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
/*      */   static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
/*      */   static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
/*      */   static final int DMLR_METADATA_TYPE_OFFSET = 0;
/*      */   static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
/*      */   static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
/*      */   static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
/*      */   static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
/*      */   static final String SYS_ODCIVARCHAR2LIST = "SYS.ODCIVARCHAR2LIST";
/*  268 */   static final OracleResultSet.ResultSetType DEFAULT_RESULT_SET_TYPE = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
/*      */   boolean closed;
/*      */   protected boolean isComplete;
/*      */   int cursorId;
/*      */   int refCursorRowNumber;
/*  303 */   ByteArray rowData = null;
/*  304 */   ByteArray bindData = null;
/*      */   int numberOfDefinePositions;
/*      */   int definesBatchSize;
/*  308 */   boolean described = false;
/*  309 */   boolean describedWithNames = false;
/*  310 */   boolean executeDoneForDefines = false;
/*      */   int rowsProcessed;
/*      */   protected int validRows;
/*      */   protected int storedRowCount;
/*  315 */   protected int currentCapacity = -1;
/*      */   boolean isStreaming;
/*      */   boolean isFetchStreams;
/*  323 */   OracleStatement children = null;
/*  324 */   OracleStatement parent = null;
/*      */ 
/*  327 */   OracleStatement nextChild = null;
/*      */   OracleStatement next;
/*      */   OracleStatement prev;
/*      */   long c_state;
/*      */   int numberOfBindPositions;
/*      */   byte[] bindBytes;
/*      */   char[] bindChars;
/*      */   short[] bindIndicators;
/*      */   int bindByteOffset;
/*      */   int bindCharOffset;
/*      */   int bindIndicatorOffset;
/*      */   int bindByteSubRange;
/*      */   int bindCharSubRange;
/*      */   int bindIndicatorSubRange;
/*      */   Accessor[] outBindAccessors;
/*      */   InputStream[][] parameterStream;
/*      */   Object[][] userStream;
/*      */   int firstRowInBatch;
/*  370 */   boolean hasIbtBind = false;
/*      */   byte[] ibtBindBytes;
/*      */   char[] ibtBindChars;
/*      */   short[] ibtBindIndicators;
/*      */   int ibtBindByteOffset;
/*      */   int ibtBindCharOffset;
/*      */   int ibtBindIndicatorOffset;
/*      */   int ibtBindIndicatorSize;
/*      */   OracleInputStream nextStream;
/*      */   OracleResultSet currentResultSet;
/*  395 */   ArrayDeque<OracleStatement> implicitResultSetStatements = null;
/*      */ 
/*  397 */   ArrayDeque<OracleResultSet> openImplicitResultSets = null;
/*      */ 
/*  399 */   Iterator<OracleStatement> implicitResultSetIterator = null;
/*      */   boolean processEscapes;
/*      */   boolean convertNcharLiterals;
/*      */   int queryTimeout;
/*      */   int maxFieldSize;
/*      */   int maxRows;
/*      */   int batch;
/*  415 */   int numberOfExecutedElementsInBatch = -1;
/*      */   int currentRank;
/*  417 */   boolean bsendBatchInProgress = false;
/*      */   int[] batchRowsUpdatedArray;
/*      */   int rowPrefetch;
/*  435 */   int rowPrefetchInLastFetch = -1;
/*      */   int defaultRowPrefetch;
/*      */   boolean rowPrefetchChanged;
/*      */   int defaultLobPrefetchSize;
/*      */   OracleSql sqlObject;
/*      */   boolean needToParse;
/*      */   boolean needToPrepareDefineBuffer;
/*      */   boolean columnsDefinedByUser;
/*      */   boolean gotLastBatch;
/*      */   boolean clearParameters;
/*  470 */   OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.SELECT;
/*  471 */   byte sqlKindByte = 1;
/*      */   boolean serverCursor;
/*  478 */   boolean fixedString = false;
/*      */ 
/*  481 */   boolean noMoreUpdateCounts = false;
/*      */ 
/*  483 */   protected CancelLock cancelLock = new CancelLock();
/*      */   OracleStatementWrapper wrapper;
/*  488 */   byte executionType = -1;
/*      */   OracleResultSet.ResultSetType userRsetType;
/*      */   OracleResultSet.ResultSetType realRsetType;
/*  494 */   boolean isRowidPrepended = false;
/*      */   SQLWarning sqlWarning;
/*  498 */   int cacheState = 3;
/*      */ 
/*  501 */   int creationState = 0;
/*      */ 
/*  503 */   boolean isOpen = false;
/*      */ 
/*  507 */   int statementType = 0;
/*      */ 
/*  511 */   boolean columnSetNull = false;
/*      */ 
/*  515 */   boolean isDmlReturning = false;
/*      */   boolean returnParamsFetched;
/*      */   int rowsDmlReturned;
/*      */   int numReturnParams;
/*      */   boolean isAutoGeneratedKey;
/*      */   AutoKeyInfo autoKeyInfo;
/*  528 */   TimeZone defaultTimeZone = null;
/*  529 */   String defaultTimeZoneName = null;
/*      */ 
/*  531 */   Calendar defaultCalendar = null;
/*  532 */   Calendar gmtCalendar = null;
/*      */ 
/*  535 */   long inScn = 0L;
/*      */ 
/*  538 */   OraclePreparedStatement refreshStatement = null;
/*      */ 
/*  564 */   ByteBuffer[] nioBuffers = null;
/*  565 */   Object[] lobPrefetchMetaData = null;
/*      */   boolean hasStream;
/*      */   byte[] tmpByteArray;
/*  581 */   int sizeTmpByteArray = 0;
/*      */   byte[] tmpBindsByteArray;
/*  589 */   boolean needToSendOalToFetch = false;
/*      */ 
/*  596 */   int[] definedColumnType = null;
/*  597 */   int[] definedColumnSize = null;
/*  598 */   int[] definedColumnFormOfUse = null;
/*      */ 
/*  604 */   T4CTTIoac[] oacdefSent = null;
/*      */ 
/*  611 */   int[] nbPostPonedColumns = null;
/*  612 */   int[][] indexOfPostPonedColumn = (int[][])null;
/*      */ 
/*  616 */   boolean aFetchWasDoneDuringDescribe = false;
/*      */ 
/*  623 */   boolean implicitDefineForLobPrefetchDone = false;
/*      */ 
/*  625 */   long checkSum = 0L;
/*  626 */   boolean checkSumComputationFailure = false;
/*      */ 
/* 4536 */   Vector m_batchItems = null;
/*      */ 
/* 6140 */   ArrayList tempClobsToFree = null;
/* 6141 */   ArrayList tempBlobsToFree = null;
/*      */ 
/* 6143 */   ArrayList oldTempClobsToFree = null;
/* 6144 */   ArrayList oldTempBlobsToFree = null;
/*      */ 
/* 6345 */   NTFDCNRegistration registration = null;
/* 6346 */   String[] dcnTableName = null;
/* 6347 */   long dcnQueryId = -1L;
/*      */ 
/* 6608 */   long localCheckSum = 0L;
/*      */   OracleStatement.BindChecksumListener bindChecksumListener;
/* 6701 */   boolean isCloseOnCompletion = false;
/*      */   protected Object acProxy;
/* 6740 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   abstract void doDescribe(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void executeForDescribe()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void executeForRows(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   protected abstract void fetch(int paramInt, boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void doClose()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void closeQuery()
/*      */     throws SQLException;
/*      */ 
/*      */   public int cursorIfRefCursor()
/*      */     throws SQLException
/*      */   {
/*  202 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
/*  203 */     localSQLException.fillInStackTrace();
/*  204 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void continueReadRow(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  215 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
/*  216 */     localSQLException.fillInStackTrace();
/*  217 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void closeCursorOnPlainStatement()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind paramSqlKind)
/*      */   {
/*  274 */     return paramSqlKind.getKind();
/*      */   }
/*      */ 
/*      */   static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte paramByte)
/*      */   {
/*  280 */     return OracleStatement.SqlKind.valueOf(paramByte);
/*      */   }
/*      */ 
/*      */   OracleStatement(PhysicalConnection paramPhysicalConnection, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  654 */     this(paramPhysicalConnection, paramInt1, paramInt2, -1, -1);
/*      */   }
/*      */ 
/*      */   OracleStatement(PhysicalConnection paramPhysicalConnection, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*      */     throws SQLException
/*      */   {
/*  664 */     super(paramPhysicalConnection);
/*      */ 
/*  667 */     this.connection.needLine();
/*  668 */     this.connection.registerHeartbeat();
/*      */ 
/*  671 */     this.sqlObject = new OracleSql(this.connection.conversion);
/*      */ 
/*  673 */     this.processEscapes = this.connection.processEscapes;
/*  674 */     this.convertNcharLiterals = this.connection.convertNcharLiterals;
/*  675 */     this.gotLastBatch = false;
/*  676 */     this.closed = false;
/*  677 */     this.clearParameters = true;
/*  678 */     this.serverCursor = false;
/*  679 */     this.fixedString = this.connection.getDefaultFixedString();
/*  680 */     this.rowPrefetchChanged = false;
/*  681 */     this.rowPrefetch = paramInt2;
/*  682 */     this.currentCapacity = this.rowPrefetch;
/*  683 */     this.defaultRowPrefetch = paramInt2;
/*  684 */     if (this.connection.getVersionNumber() >= 11000)
/*  685 */       this.defaultLobPrefetchSize = this.connection.defaultLobPrefetchSize;
/*      */     else
/*  687 */       this.defaultLobPrefetchSize = -1;
/*  688 */     this.batch = paramInt1;
/*      */ 
/*  692 */     this.needToParse = true;
/*  693 */     this.needToPrepareDefineBuffer = true;
/*  694 */     this.columnsDefinedByUser = false;
/*      */ 
/*  696 */     configureRowData();
/*      */ 
/*  700 */     this.userRsetType = OracleResultSet.ResultSetType.typeFor(paramInt3, paramInt4);
/*  701 */     if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
/*  702 */       this.userRsetType = DEFAULT_RESULT_SET_TYPE;
/*  703 */       this.realRsetType = DEFAULT_RESULT_SET_TYPE;
/*      */     }
/*      */     else {
/*  706 */       this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
/*      */     }
/*  708 */     this.isFetchStreams = ((this.connection.useFetchSizeWithLongColumn) || (this.userRsetType != DEFAULT_RESULT_SET_TYPE));
/*      */ 
/*  711 */     this.connection.addStatement(this);
/*      */   }
/*      */ 
/*      */   public void setWrapper(OracleStatementWrapper paramOracleStatementWrapper)
/*      */   {
/*  728 */     this.wrapper = paramOracleStatementWrapper;
/*      */   }
/*      */ 
/*      */   public void setSnapshotSCN(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  735 */     doSetSnapshotSCN(paramLong);
/*      */   }
/*      */ 
/*      */   void doSetSnapshotSCN(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  741 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  742 */     localSQLException.fillInStackTrace();
/*  743 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected void configureRowData()
/*      */   {
/*  760 */     this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
/*  761 */     this.bindData = this.rowData;
/*      */   }
/*      */ 
/*      */   void prepareAccessors()
/*      */     throws SQLException
/*      */   {
/*  773 */     if (this.accessors == null)
/*      */     {
/*  775 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  776 */       localSQLException.fillInStackTrace();
/*  777 */       throw localSQLException;
/*      */     }
/*      */     Object localObject;
/*  780 */     for (int i = 0; i < this.numberOfDefinePositions; i++) {
/*  781 */       Accessor localAccessor = this.accessors[i];
/*  782 */       if (localAccessor == null) {
/*  783 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  784 */         ((SQLException)localObject).fillInStackTrace();
/*  785 */         throw ((Throwable)localObject);
/*      */       }
/*  787 */       switch (localAccessor.internalType) {
/*      */       case 8:
/*      */       case 24:
/*  790 */         this.hasStream = true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  797 */     if ((this.streamList != null) && (!this.isFetchStreams))
/*  798 */       this.rowPrefetch = 1;
/*  799 */     i = this.rowPrefetch;
/*  800 */     this.definesBatchSize = i;
/*      */ 
/*  802 */     for (int j = 0; j < this.numberOfDefinePositions; j++) {
/*  803 */       localObject = this.accessors[j];
/*  804 */       ((Accessor)localObject).setCapacity(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean checkAccessorsUsable()
/*      */     throws SQLException
/*      */   {
/*  816 */     int i = this.accessors.length;
/*      */ 
/*  818 */     if (i < this.numberOfDefinePositions) {
/*  819 */       return false;
/*      */     }
/*  821 */     int j = 1;
/*  822 */     int k = 0;
/*  823 */     boolean bool = false;
/*      */ 
/*  825 */     for (int m = 0; m < this.numberOfDefinePositions; m++)
/*      */     {
/*  827 */       Accessor localAccessor = this.accessors[m];
/*      */ 
/*  829 */       if ((localAccessor == null) || (localAccessor.externalType == 0))
/*  830 */         j = 0;
/*      */       else {
/*  832 */         k = 1;
/*      */       }
/*      */     }
/*  835 */     if (j != 0)
/*      */     {
/*  838 */       bool = true; } else {
/*  839 */       if (k != 0)
/*      */       {
/*  843 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  844 */         localSQLException.fillInStackTrace();
/*  845 */         throw localSQLException;
/*      */       }
/*      */ 
/*  851 */       this.columnsDefinedByUser = false;
/*      */     }
/*  853 */     return bool;
/*      */   }
/*      */ 
/*      */   void executeMaybeDescribe()
/*      */     throws SQLException
/*      */   {
/*  862 */     int i = 1;
/*      */ 
/*  864 */     if (this.rowPrefetchChanged)
/*      */     {
/*  866 */       if ((this.streamList == null) && (this.rowPrefetch != this.definesBatchSize)) {
/*  867 */         this.needToPrepareDefineBuffer = true;
/*      */       }
/*  869 */       this.rowPrefetchChanged = false;
/*      */     }
/*      */ 
/*  872 */     if (!this.needToPrepareDefineBuffer)
/*      */     {
/*  876 */       if (this.accessors == null)
/*      */       {
/*  880 */         this.needToPrepareDefineBuffer = true;
/*  881 */       } else if (this.columnsDefinedByUser) {
/*  882 */         this.needToPrepareDefineBuffer = (!checkAccessorsUsable());
/*      */       }
/*      */     }
/*  885 */     boolean bool = false;
/*      */     try
/*      */     {
/*  890 */       this.cancelLock.enterExecuting();
/*      */ 
/*  892 */       if (this.needToPrepareDefineBuffer)
/*      */       {
/*  895 */         if (!this.columnsDefinedByUser)
/*      */         {
/*  897 */           executeForDescribe();
/*      */ 
/*  899 */           bool = true;
/*      */ 
/*  903 */           if (this.aFetchWasDoneDuringDescribe) {
/*  904 */             i = 0;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  910 */         if (this.needToPrepareDefineBuffer)
/*      */         {
/*  914 */           prepareAccessors();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  919 */       int j = this.accessors.length;
/*      */ 
/*  921 */       for (int k = this.numberOfDefinePositions; k < j; k++)
/*      */       {
/*  923 */         Accessor localAccessor = this.accessors[k];
/*      */ 
/*  925 */         if (localAccessor != null)
/*  926 */           localAccessor.rowSpaceIndicator = null;
/*      */       }
/*  928 */       if (i != 0) {
/*  929 */         executeForRows(bool);
/*      */       }
/*  931 */       this.currentCapacity = this.rowPrefetch;
/*  932 */       this.storedRowCount = (this.validRows == -2 ? 1 : this.validRows);
/*  933 */       this.indexOfFirstRow = 0;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  937 */       this.needToParse = true;
/*  938 */       throw localSQLException;
/*      */     }
/*      */     finally
/*      */     {
/*  942 */       this.cancelLock.exitExecuting();
/*      */     }
/*      */   }
/*      */ 
/*      */   void adjustGotLastBatch()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void locationToPutBytes(Accessor paramAccessor, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  966 */     paramAccessor.setOffset(paramInt1, this.rowData.length());
/*      */   }
/*      */ 
/*      */   void doExecuteWithTimeout()
/*      */     throws SQLException
/*      */   {
/*  981 */     if (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
/*  982 */       this.realRsetType = this.userRsetType;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  991 */       cleanOldTempLobs();
/*      */ 
/*  998 */       this.connection.registerHeartbeat();
/*      */ 
/* 1001 */       this.rowsProcessed = 0;
/*      */       SQLException localSQLException1;
/* 1003 */       if (this.sqlKind.isSELECT())
/*      */       {
/* 1005 */         if ((this.connection.j2ee13Compliant) && (this.executionType == 2))
/*      */         {
/* 1007 */           localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 129);
/* 1008 */           localSQLException1.fillInStackTrace();
/* 1009 */           throw localSQLException1;
/*      */         }
/*      */ 
/* 1012 */         this.connection.needLine();
/*      */ 
/* 1014 */         if (!this.isOpen)
/*      */         {
/* 1016 */           this.connection.open(this);
/*      */ 
/* 1018 */           this.isOpen = true;
/*      */         }
/*      */ 
/* 1021 */         if (this.queryTimeout != 0)
/*      */         {
/*      */           try
/*      */           {
/* 1025 */             this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
/* 1026 */             executeMaybeDescribe();
/*      */           }
/*      */           finally
/*      */           {
/* 1030 */             this.connection.getTimeout().cancelTimeout();
/*      */           }
/*      */         }
/*      */         else {
/* 1034 */           executeMaybeDescribe();
/*      */         }
/* 1036 */         checkValidRowsStatus();
/*      */ 
/* 1041 */         if (this.serverCursor)
/* 1042 */           adjustGotLastBatch();
/*      */       }
/*      */       else
/*      */       {
/* 1046 */         if ((this.connection.j2ee13Compliant) && (!this.sqlKind.isPlsqlOrCall()) && (this.executionType == 1))
/*      */         {
/* 1050 */           localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 128);
/* 1051 */           localSQLException1.fillInStackTrace();
/* 1052 */           throw localSQLException1;
/*      */         }
/*      */ 
/* 1055 */         this.currentRank += 1;
/*      */ 
/* 1057 */         if (this.currentRank >= this.batch)
/*      */         {
/*      */           try
/*      */           {
/* 1061 */             this.connection.needLine();
/*      */ 
/* 1063 */             this.cancelLock.enterExecuting();
/*      */ 
/* 1065 */             if (!this.isOpen)
/*      */             {
/* 1067 */               this.connection.open(this);
/*      */ 
/* 1069 */               this.isOpen = true;
/*      */             }
/*      */ 
/* 1072 */             if (this.queryTimeout != 0) {
/* 1073 */               this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
/*      */             }
/* 1075 */             executeForRows(false);
/*      */           }
/*      */           catch (SQLException localSQLException2)
/*      */           {
/* 1079 */             this.needToParse = true;
/* 1080 */             if (this.batch > 1)
/*      */             {
/* 1082 */               clearBatch();
/*      */               int[] arrayOfInt;
/*      */               int i;
/* 1088 */               if ((this.numberOfExecutedElementsInBatch != -1) && (this.numberOfExecutedElementsInBatch < this.batch))
/*      */               {
/* 1091 */                 arrayOfInt = new int[this.numberOfExecutedElementsInBatch];
/* 1092 */                 for (i = 0; i < arrayOfInt.length; i++)
/* 1093 */                   arrayOfInt[i] = -2;
/*      */               }
/*      */               else
/*      */               {
/* 1097 */                 arrayOfInt = new int[this.batch];
/* 1098 */                 for (i = 0; i < arrayOfInt.length; i++) {
/* 1099 */                   arrayOfInt[i] = -3;
/*      */                 }
/*      */               }
/* 1102 */               BatchUpdateException localBatchUpdateException = DatabaseError.createBatchUpdateException(localSQLException2, arrayOfInt.length, arrayOfInt);
/* 1103 */               localBatchUpdateException.fillInStackTrace();
/* 1104 */               throw localBatchUpdateException;
/*      */             }
/*      */ 
/* 1107 */             resetCurrentRowBinders();
/*      */ 
/* 1109 */             throw localSQLException2;
/*      */           }
/*      */           finally
/*      */           {
/* 1113 */             if (this.queryTimeout != 0) {
/* 1114 */               this.connection.getTimeout().cancelTimeout();
/*      */             }
/* 1116 */             this.currentRank = 0;
/* 1117 */             this.cancelLock.exitExecuting();
/*      */ 
/* 1119 */             checkValidRowsStatus();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException3)
/*      */     {
/* 1137 */       resetOnExceptionDuringExecute();
/* 1138 */       throw localSQLException3;
/*      */     }
/*      */ 
/* 1148 */     this.connection.registerHeartbeat();
/*      */   }
/*      */ 
/*      */   void resetOnExceptionDuringExecute()
/*      */   {
/* 1157 */     this.needToParse = true;
/*      */   }
/*      */ 
/*      */   void resetCurrentRowBinders()
/*      */   {
/*      */   }
/*      */ 
/*      */   void open()
/*      */     throws SQLException
/*      */   {
/* 1179 */     if (!this.isOpen)
/*      */     {
/* 1181 */       this.connection.needLine();
/* 1182 */       this.connection.open(this);
/*      */ 
/* 1184 */       this.isOpen = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet executeQuery(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1205 */     synchronized (this.connection)
/*      */     {
/* 1212 */       OracleResultSet localOracleResultSet = null;
/*      */ 
/* 1214 */       cleanUpBeforeExecute();
/* 1215 */       this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
/*      */       try
/*      */       {
/* 1219 */         this.executionType = 1;
/*      */ 
/* 1223 */         this.noMoreUpdateCounts = false;
/*      */ 
/* 1225 */         ensureOpen();
/* 1226 */         checkIfJdbcBatchExists();
/*      */ 
/* 1228 */         sendBatch();
/*      */ 
/* 1231 */         this.hasStream = false;
/*      */ 
/* 1234 */         this.sqlObject.initialize(paramString);
/*      */ 
/* 1236 */         this.sqlKind = this.sqlObject.getSqlKind();
/* 1237 */         this.needToParse = true;
/*      */ 
/* 1239 */         prepareForNewResults(true, true, true);
/*      */         SQLException localSQLException;
/* 1243 */         if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
/* 1244 */           doExecuteWithTimeout();
/*      */ 
/* 1248 */           if (this.implicitResultSetStatements == null) {
/* 1249 */             if (this.sqlKind.isPlsqlOrCall()) {
/* 1250 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 128);
/* 1251 */               localSQLException.fillInStackTrace();
/* 1252 */               throw localSQLException;
/*      */             }
/* 1254 */             computeOffsetOfFirstUserColumn();
/* 1255 */             this.currentResultSet = OracleResultSet.createResultSet(this);
/* 1256 */             localOracleResultSet = this.currentResultSet;
/*      */           }
/*      */         }
/*      */         else {
/* 1260 */           localOracleResultSet = doScrollStmtExecuteQuery();
/*      */ 
/* 1262 */           if (localOracleResultSet == null)
/*      */           {
/* 1265 */             if (this.implicitResultSetStatements == null) {
/* 1266 */               if (this.sqlKind.isPlsqlOrCall()) {
/* 1267 */                 localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 128);
/* 1268 */                 localSQLException.fillInStackTrace();
/* 1269 */                 throw localSQLException;
/*      */               }
/* 1271 */               computeOffsetOfFirstUserColumn();
/* 1272 */               this.currentResultSet = OracleResultSet.createResultSet(this);
/* 1273 */               localOracleResultSet = this.currentResultSet;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       finally {
/* 1279 */         this.executionType = -1;
/*      */       }
/*      */ 
/* 1282 */       return localOracleResultSet;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void closeWithKey(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1300 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 1301 */     localSQLException.fillInStackTrace();
/* 1302 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/* 1334 */     synchronized (this.connection)
/*      */     {
/* 1343 */       closeOrCache(null);
/*      */     }
/*      */   }
/*      */ 
/*      */   void closeWrapper()
/*      */     throws SQLException
/*      */   {
/* 1350 */     if (this.wrapper != null) this.wrapper.beClosed();
/*      */   }
/*      */ 
/*      */   protected void closeOrCache(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1357 */     if (this.closed) {
/* 1358 */       return;
/*      */     }
/*      */ 
/* 1361 */     if (this.connection.lifecycle == 2)
/* 1362 */       this.connection.needLineUnchecked();
/*      */     else {
/* 1364 */       this.connection.needLine();
/*      */     }
/*      */ 
/* 1373 */     if ((this.statementType != 0) && (this.cacheState != 0) && (this.cacheState != 3) && (this.connection.isStatementCacheInitialized()))
/*      */     {
/* 1384 */       if (paramString == null)
/*      */       {
/* 1386 */         if (this.connection.getImplicitCachingEnabled())
/*      */         {
/* 1388 */           this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
/*      */         }
/*      */         else
/*      */         {
/* 1397 */           this.cacheState = 0;
/*      */ 
/* 1399 */           hardClose();
/*      */         }
/*      */ 
/*      */       }
/* 1405 */       else if (this.connection.getExplicitCachingEnabled())
/*      */       {
/* 1407 */         this.connection.cacheExplicitStatement((OraclePreparedStatement)this, paramString);
/*      */       }
/*      */       else
/*      */       {
/* 1415 */         this.cacheState = 0;
/*      */ 
/* 1417 */         hardClose();
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1426 */       hardClose();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void hardClose()
/*      */     throws SQLException
/*      */   {
/* 1436 */     hardClose(true);
/*      */   }
/*      */ 
/*      */   private void hardClose(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1447 */     alwaysOnClose();
/*      */ 
/* 1449 */     this.describedWithNames = false;
/* 1450 */     this.described = false;
/*      */ 
/* 1453 */     this.connection.removeStatement(this);
/*      */ 
/* 1455 */     clearDefines();
/*      */ 
/* 1457 */     if ((this.isOpen) && (paramBoolean) && ((this.connection.lifecycle == 1) || (this.connection.lifecycle == 16) || (this.connection.lifecycle == 2)))
/*      */     {
/* 1466 */       this.connection.registerHeartbeat();
/*      */ 
/* 1469 */       doClose();
/* 1470 */       this.isOpen = false;
/* 1471 */       if (this.refreshStatement != null) this.refreshStatement.close();
/*      */     }
/*      */ 
/* 1474 */     this.sqlObject = null;
/*      */   }
/*      */ 
/*      */   protected void alwaysOnClose()
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject2;
/* 1492 */     if (this.implicitResultSetStatements != null)
/*      */     {
/* 1494 */       for (localObject1 = this.implicitResultSetStatements.iterator(); ((Iterator)localObject1).hasNext(); ) { localObject2 = (OracleStatement)((Iterator)localObject1).next();
/*      */ 
/* 1496 */         ((OracleStatement)localObject2).close();
/*      */       }
/*      */ 
/* 1499 */       if (this.openImplicitResultSets != null)
/*      */       {
/* 1501 */         for (localObject1 = this.openImplicitResultSets.iterator(); ((Iterator)localObject1).hasNext(); ) { localObject2 = (OracleResultSet)((Iterator)localObject1).next();
/*      */ 
/* 1503 */           ((OracleResultSet)localObject2).close();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1510 */     Object localObject1 = this.children;
/*      */ 
/* 1512 */     while (localObject1 != null)
/*      */     {
/* 1514 */       localObject2 = ((OracleStatement)localObject1).nextChild;
/*      */ 
/* 1516 */       ((OracleStatement)localObject1).close();
/*      */ 
/* 1518 */       localObject1 = localObject2;
/*      */     }
/*      */ 
/* 1521 */     if (this.parent != null)
/*      */     {
/* 1523 */       this.parent.removeChild(this);
/*      */     }
/*      */ 
/* 1526 */     this.closed = true;
/*      */ 
/* 1529 */     if ((this.connection != null) && ((this.connection.lifecycle == 1) || (this.connection.lifecycle == 2)))
/*      */     {
/* 1534 */       if (this.currentResultSet != null)
/*      */       {
/* 1536 */         this.currentResultSet.doneFetchingRows(false);
/* 1537 */         this.currentResultSet.close();
/* 1538 */         this.currentResultSet = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1544 */     this.sqlWarning = null;
/*      */ 
/* 1546 */     this.m_batchItems = null;
/*      */   }
/*      */ 
/*      */   void closeLeaveCursorOpen()
/*      */     throws SQLException
/*      */   {
/* 1562 */     synchronized (this.connection)
/*      */     {
/* 1568 */       if (this.closed)
/*      */       {
/* 1570 */         return;
/*      */       }
/*      */ 
/* 1573 */       hardClose(false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int executeUpdate(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1592 */     synchronized (this.connection)
/*      */     {
/* 1602 */       cleanUpBeforeExecute();
/* 1603 */       return executeUpdateInternal(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   int executeUpdateInternal(String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1614 */       if (this.executionType == -1) {
/* 1615 */         this.executionType = 2;
/*      */       }
/*      */ 
/* 1618 */       this.noMoreUpdateCounts = false;
/*      */ 
/* 1620 */       ensureOpen();
/* 1621 */       checkIfJdbcBatchExists();
/*      */ 
/* 1623 */       sendBatch();
/*      */ 
/* 1626 */       this.hasStream = false;
/*      */ 
/* 1629 */       this.sqlObject.initialize(paramString);
/*      */ 
/* 1631 */       this.sqlKind = this.sqlObject.getSqlKind();
/* 1632 */       this.needToParse = true;
/*      */ 
/* 1634 */       prepareForNewResults(true, true, true);
/*      */ 
/* 1638 */       if (this.userRsetType == DEFAULT_RESULT_SET_TYPE)
/*      */       {
/* 1640 */         doExecuteWithTimeout();
/*      */       }
/*      */       else
/*      */       {
/* 1644 */         doScrollStmtExecuteQuery();
/*      */       }
/*      */ 
/* 1647 */       return this.validRows;
/*      */     }
/*      */     finally
/*      */     {
/* 1651 */       this.executionType = -1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean execute(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1667 */     synchronized (this.connection)
/*      */     {
/* 1677 */       cleanUpBeforeExecute();
/* 1678 */       return executeInternal(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean executeInternal(String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1689 */       this.executionType = 3;
/*      */ 
/* 1691 */       this.checkSum = 0L;
/* 1692 */       this.checkSumComputationFailure = false;
/*      */ 
/* 1695 */       this.noMoreUpdateCounts = false;
/*      */ 
/* 1697 */       ensureOpen();
/* 1698 */       checkIfJdbcBatchExists();
/*      */ 
/* 1700 */       sendBatch();
/*      */ 
/* 1704 */       this.hasStream = false;
/*      */ 
/* 1707 */       this.sqlObject.initialize(paramString);
/*      */ 
/* 1709 */       this.sqlKind = this.sqlObject.getSqlKind();
/* 1710 */       this.needToParse = true;
/*      */ 
/* 1712 */       prepareForNewResults(true, true, true);
/*      */ 
/* 1716 */       if (this.userRsetType == DEFAULT_RESULT_SET_TYPE)
/*      */       {
/* 1718 */         doExecuteWithTimeout();
/*      */       }
/*      */       else
/*      */       {
/* 1722 */         doScrollStmtExecuteQuery();
/*      */       }
/*      */ 
/* 1725 */       return (this.sqlKind.isSELECT()) || (this.implicitResultSetStatements != null);
/*      */     }
/*      */     finally
/*      */     {
/* 1729 */       this.executionType = -1;
/*      */     }
/*      */   }
/*      */ 
/*      */   int getNumberOfColumns()
/*      */     throws SQLException
/*      */   {
/* 1742 */     if (this.serverCursor) {
/* 1743 */       return this.accessors == null ? 0 : this.accessors.length;
/*      */     }
/* 1745 */     if (this.sqlKind.isSELECT()) {
/* 1746 */       ensureOpen();
/* 1747 */       if (!this.described) {
/* 1748 */         synchronized (this.connection) {
/* 1749 */           doDescribe(false);
/* 1750 */           this.described = true;
/*      */         }
/*      */       }
/*      */ 
/* 1754 */       return this.numberOfDefinePositions - (1 + this.offsetOfFirstUserColumn);
/*      */     }
/*      */ 
/* 1757 */     return this.numReturnParams;
/*      */   }
/*      */ 
/*      */   Accessor[] getDescription()
/*      */     throws SQLException
/*      */   {
/* 1766 */     ensureOpen();
/* 1767 */     if (!this.described)
/*      */     {
/* 1769 */       synchronized (this.connection) {
/* 1770 */         doDescribe(false);
/*      */ 
/* 1772 */         this.described = true;
/*      */       }
/*      */     }
/*      */ 
/* 1776 */     return this.accessors;
/*      */   }
/*      */ 
/*      */   Accessor[] getDescriptionWithNames()
/*      */     throws SQLException
/*      */   {
/* 1783 */     ensureOpen();
/* 1784 */     if (!this.describedWithNames)
/*      */     {
/* 1786 */       synchronized (this.connection) {
/* 1787 */         doDescribe(true);
/*      */ 
/* 1789 */         this.described = true;
/* 1790 */         this.describedWithNames = true;
/*      */       }
/*      */     }
/*      */ 
/* 1794 */     return this.accessors;
/*      */   }
/*      */ 
/*      */   public OracleStatement.SqlKind getSqlKind()
/*      */     throws SQLException
/*      */   {
/* 1807 */     return this.sqlObject.getSqlKind();
/*      */   }
/*      */ 
/*      */   public void clearDefines()
/*      */     throws SQLException
/*      */   {
/* 1827 */     synchronized (this.connection)
/*      */     {
/* 1835 */       freeLine();
/*      */ 
/* 1837 */       this.streamList = null;
/*      */ 
/* 1844 */       this.columnsDefinedByUser = false;
/* 1845 */       this.needToPrepareDefineBuffer = true;
/*      */ 
/* 1848 */       this.numberOfDefinePositions = 0;
/* 1849 */       this.definesBatchSize = 0;
/*      */ 
/* 1851 */       this.described = false;
/* 1852 */       this.describedWithNames = false;
/*      */ 
/* 1854 */       cleanupDefines();
/*      */     }
/*      */   }
/*      */ 
/*      */   void reparseOnRedefineIfNeeded()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   void defineColumnTypeInternal(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1876 */     defineColumnTypeInternal(paramInt1, paramInt2, paramInt3, (short)1, paramBoolean, paramString);
/*      */   }
/*      */ 
/*      */   void defineColumnTypeInternal(int paramInt1, int paramInt2, int paramInt3, short paramShort, boolean paramBoolean, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1888 */     if (this.connection.disableDefinecolumntype)
/*      */       return;
/*      */     SQLException localSQLException;
/* 1893 */     if (paramInt1 < 1)
/*      */     {
/* 1895 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1896 */       localSQLException.fillInStackTrace();
/* 1897 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1900 */     if (paramInt2 == 0)
/*      */     {
/* 1902 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 1903 */       localSQLException.fillInStackTrace();
/* 1904 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1907 */     int i = paramInt1 - 1;
/* 1908 */     int j = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
/*      */     Object localObject1;
/* 1910 */     if (!paramBoolean)
/*      */     {
/* 1924 */       if (paramInt3 < 0)
/*      */       {
/* 1926 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 53);
/* 1927 */         ((SQLException)localObject1).fillInStackTrace();
/* 1928 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 1931 */       if ((paramInt2 == 2005) || (paramInt2 == 2004))
/*      */       {
/* 1933 */         if (((j == -1) && (paramInt3 > 0)) || ((j > 0) && (paramInt3 < j)))
/*      */         {
/* 1935 */           j = paramInt3;
/*      */         }
/*      */       }
/*      */       else {
/* 1939 */         j = -1;
/*      */       }
/*      */     }
/*      */ 
/* 1943 */     if ((this.currentResultSet != null) && (!this.currentResultSet.closed))
/*      */     {
/* 1945 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 28);
/* 1946 */       ((SQLException)localObject1).fillInStackTrace();
/* 1947 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 1950 */     if (!this.columnsDefinedByUser)
/*      */     {
/* 1954 */       clearDefines();
/*      */ 
/* 1956 */       this.columnsDefinedByUser = true;
/*      */     }
/*      */ 
/* 1959 */     if (this.numberOfDefinePositions < paramInt1)
/*      */     {
/* 1961 */       if ((this.accessors == null) || (this.accessors.length < paramInt1))
/*      */       {
/* 1963 */         localObject1 = new Accessor[paramInt1 << 1];
/*      */ 
/* 1965 */         if (this.accessors != null) {
/* 1966 */           System.arraycopy(this.accessors, 0, localObject1, 0, this.numberOfDefinePositions);
/*      */         }
/* 1968 */         this.accessors = ((Accessor[])localObject1);
/*      */       }
/*      */ 
/* 1971 */       this.numberOfDefinePositions = paramInt1;
/*      */     }
/*      */ 
/* 1974 */     switch (paramInt2) {
/*      */     case -16:
/*      */     case -15:
/*      */     case -9:
/*      */     case 2011:
/* 1979 */       paramShort = 2;
/* 1980 */       break;
/*      */     case 2009:
/* 1982 */       paramString = "SYS.XMLTYPE";
/* 1983 */       break;
/*      */     }
/*      */ 
/* 1988 */     int k = getInternalType(paramInt2);
/*      */ 
/* 1990 */     if (((k == 109) || (k == 111)) && ((paramString == null) || (paramString.equals(""))))
/*      */     {
/* 1993 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
/* 1994 */       ((SQLException)localObject2).fillInStackTrace();
/* 1995 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1998 */     Object localObject2 = this.accessors[i];
/* 1999 */     int m = 1;
/*      */ 
/* 2001 */     if (localObject2 != null)
/*      */     {
/* 2006 */       int n = ((Accessor)localObject2).useForDataAccessIfPossible(k, paramInt2, j, paramString);
/*      */ 
/* 2009 */       if (n == 0)
/*      */       {
/* 2011 */         paramShort = ((Accessor)localObject2).formOfUse;
/* 2012 */         localObject2 = null;
/*      */ 
/* 2014 */         reparseOnRedefineIfNeeded();
/*      */       }
/* 2016 */       else if (n == 1)
/*      */       {
/* 2018 */         localObject2 = null;
/*      */ 
/* 2020 */         reparseOnRedefineIfNeeded();
/*      */       }
/* 2022 */       else if (n == 2) {
/* 2023 */         m = 0;
/*      */       }
/*      */     }
/* 2026 */     if (m != 0) {
/* 2027 */       this.needToPrepareDefineBuffer = true;
/*      */     }
/* 2029 */     if (localObject2 == null)
/*      */     {
/* 2031 */       this.accessors[i] = allocateAccessor(k, paramInt2, paramInt1, j, paramShort, paramString, false);
/*      */ 
/* 2033 */       this.described = false;
/* 2034 */       this.describedWithNames = false;
/*      */     }
/*      */ 
/* 2037 */     this.executeDoneForDefines = false;
/*      */   }
/*      */ 
/*      */   Accessor allocateAccessor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/* 2076 */     switch (paramInt1)
/*      */     {
/*      */     case 96:
/* 2080 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2082 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2083 */         localSQLException.fillInStackTrace();
/* 2084 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2087 */       return new CharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 8:
/* 2090 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2092 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2093 */         localSQLException.fillInStackTrace();
/* 2094 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2097 */       if (!paramBoolean) {
/* 2098 */         return new LongAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */       }
/*      */ 
/*      */     case 1:
/* 2103 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2105 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2106 */         localSQLException.fillInStackTrace();
/* 2107 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2110 */       return new VarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 2:
/* 2113 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2115 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2116 */         localSQLException.fillInStackTrace();
/* 2117 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2120 */       return new NumberAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 6:
/* 2123 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2125 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2126 */         localSQLException.fillInStackTrace();
/* 2127 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2130 */       return new VarnumAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 24:
/* 2133 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2135 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2136 */         localSQLException.fillInStackTrace();
/* 2137 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2140 */       if (!paramBoolean) {
/* 2141 */         return new LongRawAccessor(this, paramInt3, paramInt4, paramShort, paramInt2);
/*      */       }
/*      */ 
/*      */     case 23:
/* 2147 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2149 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2150 */         localSQLException.fillInStackTrace();
/* 2151 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2154 */       if (paramBoolean) {
/* 2155 */         return new OutRawAccessor(this, paramInt4, paramShort, paramInt2);
/*      */       }
/* 2157 */       return new RawAccessor(this, paramInt4, paramShort, paramInt2, false);
/*      */     case 100:
/* 2160 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2162 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2163 */         localSQLException.fillInStackTrace();
/* 2164 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2167 */       return new BinaryFloatAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 101:
/* 2171 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2173 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2174 */         localSQLException.fillInStackTrace();
/* 2175 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2178 */       return new BinaryDoubleAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 104:
/* 2182 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2184 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2185 */         localSQLException.fillInStackTrace();
/* 2186 */         throw localSQLException;
/*      */       }
/* 2188 */       if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*      */       {
/* 2190 */         paramInt4 = 18;
/* 2191 */         localObject = new VarcharAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/* 2192 */         ((Accessor)localObject).definedColumnType = -8;
/* 2193 */         return localObject;
/*      */       }
/* 2195 */       return new RowidAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 102:
/* 2198 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2200 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2201 */         localSQLException.fillInStackTrace();
/* 2202 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2205 */       return new ResultSetAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 12:
/* 2208 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2210 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2211 */         localSQLException.fillInStackTrace();
/* 2212 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2215 */       return new DateAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 113:
/* 2218 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2220 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2221 */         localSQLException.fillInStackTrace();
/* 2222 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2225 */       localObject = new BlobAccessor(this, -1, paramShort, paramInt2, paramBoolean);
/* 2226 */       return localObject;
/*      */     case 112:
/* 2229 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2231 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2232 */         localSQLException.fillInStackTrace();
/* 2233 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2236 */       localObject = new ClobAccessor(this, -1, paramShort, paramInt2, paramBoolean);
/* 2237 */       return localObject;
/*      */     case 114:
/* 2240 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2242 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2243 */         localSQLException.fillInStackTrace();
/* 2244 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2247 */       localObject = new BfileAccessor(this, -1, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2251 */       return localObject;
/*      */     case 109:
/* 2254 */       if (paramString == null) {
/* 2255 */         if (paramBoolean)
/*      */         {
/* 2257 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2258 */           localSQLException.fillInStackTrace();
/* 2259 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2263 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
/* 2264 */         localSQLException.fillInStackTrace();
/* 2265 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2268 */       localObject = new NamedTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2271 */       ((Accessor)localObject).initMetadata();
/*      */ 
/* 2273 */       return localObject;
/*      */     case 111:
/* 2276 */       if (paramString == null) {
/* 2277 */         if (paramBoolean)
/*      */         {
/* 2279 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2280 */           localSQLException.fillInStackTrace();
/* 2281 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2285 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
/* 2286 */         localSQLException.fillInStackTrace();
/* 2287 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2290 */       localObject = new RefTypeAccessor(this, paramString, paramShort, paramInt2, paramBoolean);
/*      */ 
/* 2293 */       ((Accessor)localObject).initMetadata();
/*      */ 
/* 2295 */       return localObject;
/*      */     case 180:
/* 2300 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2302 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2303 */         localSQLException.fillInStackTrace();
/* 2304 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2307 */       return new TimestampAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 181:
/* 2311 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2313 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2314 */         localSQLException.fillInStackTrace();
/* 2315 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2318 */       return new TimestamptzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 231:
/* 2322 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2324 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2325 */         localSQLException.fillInStackTrace();
/* 2326 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2329 */       return new TimestampltzAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 182:
/* 2333 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2335 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2336 */         localSQLException.fillInStackTrace();
/* 2337 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2340 */       return new IntervalymAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 183:
/* 2344 */       if ((paramBoolean) && (paramString != null))
/*      */       {
/* 2346 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "sqlType=" + paramInt2);
/* 2347 */         localSQLException.fillInStackTrace();
/* 2348 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2351 */       return new IntervaldsAccessor(this, paramInt4, paramShort, paramInt2, paramBoolean);
/*      */     case 995:
/* 2370 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89);
/* 2371 */       localSQLException.fillInStackTrace();
/* 2372 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2377 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 2378 */     localSQLException.fillInStackTrace();
/* 2379 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void setDriverSpecificData(Accessor paramAccessor)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void defineColumnType(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2434 */     synchronized (this.connection)
/*      */     {
/* 2441 */       defineColumnTypeInternal(paramInt1, paramInt2, -1, true, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void defineColumnType(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 2462 */     defineColumnTypeInternal(paramInt1, paramInt2, paramInt3, false, null);
/*      */   }
/*      */ 
/*      */   public void defineColumnType(int paramInt1, int paramInt2, int paramInt3, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2486 */     defineColumnTypeInternal(paramInt1, paramInt2, paramInt3, paramShort, false, null);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void defineColumnTypeBytes(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 2557 */     synchronized (this.connection)
/*      */     {
/* 2565 */       defineColumnTypeInternal(paramInt1, paramInt2, paramInt3, false, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void defineColumnTypeChars(int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 2641 */     defineColumnTypeInternal(paramInt1, paramInt2, paramInt3, false, null);
/*      */   }
/*      */ 
/*      */   public void defineColumnType(int paramInt1, int paramInt2, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2681 */     synchronized (this.connection)
/*      */     {
/* 2692 */       defineColumnTypeInternal(paramInt1, paramInt2, -1, true, paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   void setCursorId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2708 */     this.cursorId = paramInt;
/*      */   }
/*      */ 
/*      */   void setPrefetchInternal(int paramInt, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 2723 */     if (paramBoolean1)
/*      */     {
/* 2725 */       if (paramInt <= 0)
/*      */       {
/* 2727 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 20);
/* 2728 */         localSQLException.fillInStackTrace();
/* 2729 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2734 */       if (paramInt < 0)
/*      */       {
/* 2736 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "setFetchSize");
/* 2737 */         localSQLException.fillInStackTrace();
/* 2738 */         throw localSQLException;
/*      */       }
/* 2740 */       if (paramInt == 0) {
/* 2741 */         paramInt = this.connection.getDefaultRowPrefetch();
/*      */       }
/*      */     }
/*      */ 
/* 2745 */     if (paramBoolean2)
/*      */     {
/* 2747 */       if (paramInt != this.defaultRowPrefetch)
/*      */       {
/* 2749 */         this.defaultRowPrefetch = paramInt;
/*      */ 
/* 2753 */         if ((this.currentResultSet == null) || (this.currentResultSet.closed)) {
/* 2754 */           this.rowPrefetchChanged = true;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/* 2761 */     else if ((paramInt != this.rowPrefetch) && (this.streamList == null))
/*      */     {
/* 2764 */       this.rowPrefetch = paramInt;
/* 2765 */       this.rowPrefetchChanged = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setRowPrefetch(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2792 */     synchronized (this.connection)
/*      */     {
/* 2801 */       setPrefetchInternal(paramInt, true, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLobPrefetchSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2814 */     synchronized (this.connection)
/*      */     {
/* 2821 */       if (paramInt < -1)
/*      */       {
/* 2823 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 267);
/* 2824 */         localSQLException.fillInStackTrace();
/* 2825 */         throw localSQLException;
/*      */       }
/* 2827 */       this.defaultLobPrefetchSize = paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getLobPrefetchSize()
/*      */     throws SQLException
/*      */   {
/* 2842 */     return this.defaultLobPrefetchSize;
/*      */   }
/*      */ 
/*      */   int getPrefetchInternal(boolean paramBoolean)
/*      */   {
/* 2859 */     int i = paramBoolean ? this.defaultRowPrefetch : this.rowPrefetch;
/*      */ 
/* 2861 */     return i;
/*      */   }
/*      */ 
/*      */   public int getRowPrefetch()
/*      */   {
/* 2876 */     synchronized (this.connection)
/*      */     {
/* 2884 */       return getPrefetchInternal(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFixedString(boolean paramBoolean)
/*      */   {
/* 2916 */     this.fixedString = paramBoolean;
/*      */   }
/*      */ 
/*      */   public boolean getFixedString()
/*      */   {
/* 2946 */     return this.fixedString;
/*      */   }
/*      */ 
/*      */   void check_row_prefetch_changed()
/*      */     throws SQLException
/*      */   {
/* 2961 */     if (this.rowPrefetchChanged)
/*      */     {
/* 2963 */       if (this.streamList == null)
/*      */       {
/* 2965 */         prepareAccessors();
/*      */ 
/* 2967 */         this.needToPrepareDefineBuffer = true;
/*      */       }
/*      */ 
/* 2970 */       this.rowPrefetchChanged = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   void setDefinesInitialized(boolean paramBoolean)
/*      */   {
/*      */   }
/*      */ 
/*      */   void printState(String paramString)
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   void checkValidRowsStatus()
/*      */     throws SQLException
/*      */   {
/* 3007 */     if (this.validRows == -2)
/*      */     {
/* 3011 */       this.validRows = 1;
/* 3012 */       this.connection.holdLine(this);
/*      */ 
/* 3015 */       OracleInputStream localOracleInputStream = this.streamList;
/*      */ 
/* 3017 */       while (localOracleInputStream != null)
/*      */       {
/* 3019 */         if (localOracleInputStream.hasBeenOpen) {
/* 3020 */           localOracleInputStream = localOracleInputStream.accessor.initForNewRow();
/*      */         }
/*      */ 
/* 3027 */         localOracleInputStream.closed = false;
/* 3028 */         localOracleInputStream.hasBeenOpen = true;
/*      */ 
/* 3032 */         localOracleInputStream = localOracleInputStream.nextStream;
/*      */       }
/*      */ 
/* 3037 */       this.nextStream = this.streamList;
/*      */     }
/* 3040 */     else if (this.sqlKind.isSELECT())
/*      */     {
/* 3042 */       if (this.validRows < this.rowPrefetch)
/* 3043 */         this.gotLastBatch = true;
/*      */     }
/* 3045 */     else if (!this.sqlKind.isPlsqlOrCall())
/*      */     {
/* 3047 */       this.rowsProcessed = this.validRows;
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanupDefines()
/*      */   {
/* 3055 */     if (this.accessors != null)
/* 3056 */       for (int i = 0; i < this.accessors.length; i++)
/* 3057 */         this.accessors[i] = null;
/* 3058 */     this.accessors = null;
/* 3059 */     if (this.rowData != null) this.rowData.free();
/*      */   }
/*      */ 
/*      */   public int getMaxFieldSize()
/*      */     throws SQLException
/*      */   {
/* 3065 */     synchronized (this.connection)
/*      */     {
/* 3072 */       ensureOpen();
/* 3073 */       return this.maxFieldSize;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setMaxFieldSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3080 */     synchronized (this.connection)
/*      */     {
/* 3087 */       ensureOpen();
/*      */ 
/* 3089 */       if (paramInt < 0)
/*      */       {
/* 3091 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3092 */         localSQLException.fillInStackTrace();
/* 3093 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3096 */       this.maxFieldSize = paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getMaxRows()
/*      */     throws SQLException
/*      */   {
/* 3109 */     ensureOpen();
/* 3110 */     return this.maxRows;
/*      */   }
/*      */ 
/*      */   public void setMaxRows(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3116 */     synchronized (this.connection)
/*      */     {
/* 3123 */       ensureOpen();
/*      */ 
/* 3125 */       if (paramInt < 0)
/*      */       {
/* 3127 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3128 */         localSQLException.fillInStackTrace();
/* 3129 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3132 */       this.maxRows = paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setEscapeProcessing(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3140 */     synchronized (this.connection)
/*      */     {
/* 3147 */       ensureOpen();
/* 3148 */       this.processEscapes = paramBoolean;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getQueryTimeout()
/*      */     throws SQLException
/*      */   {
/* 3162 */     synchronized (this.connection)
/*      */     {
/* 3169 */       ensureOpen();
/* 3170 */       return this.queryTimeout;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setQueryTimeout(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3185 */     synchronized (this.connection)
/*      */     {
/* 3192 */       ensureOpen();
/*      */ 
/* 3194 */       if (paramInt < 0)
/*      */       {
/* 3196 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 3197 */         localSQLException.fillInStackTrace();
/* 3198 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3201 */       this.queryTimeout = paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancel()
/*      */     throws SQLException
/*      */   {
/* 3219 */     ensureOpen();
/* 3220 */     doCancel();
/*      */   }
/*      */ 
/*      */   boolean doCancel()
/*      */     throws SQLException
/*      */   {
/* 3227 */     boolean bool = false;
/*      */ 
/* 3232 */     if (this.closed) {
/* 3233 */       return bool;
/*      */     }
/*      */ 
/* 3245 */     if (this.connection.statementHoldingLine != null)
/* 3246 */       freeLine();
/* 3247 */     else if (this.cancelLock.enterCanceling()) {
/*      */       try
/*      */       {
/* 3250 */         bool = true;
/* 3251 */         this.connection.cancelOperationOnServer(true);
/*      */       }
/*      */       finally {
/* 3254 */         this.cancelLock.exitCanceling();
/*      */       }
/*      */     }
/*      */     else {
/* 3258 */       return bool;
/*      */     }
/* 3260 */     OracleStatement localOracleStatement = this.children;
/* 3261 */     while (localOracleStatement != null) {
/* 3262 */       bool = (bool) || (localOracleStatement.doCancel());
/* 3263 */       localOracleStatement = localOracleStatement.nextChild;
/*      */     }
/*      */ 
/* 3266 */     this.connection.releaseLineForCancel();
/* 3267 */     return bool;
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/* 3289 */     ensureOpen();
/* 3290 */     return this.sqlWarning;
/*      */   }
/*      */ 
/*      */   public void clearWarnings()
/*      */     throws SQLException
/*      */   {
/* 3305 */     ensureOpen();
/* 3306 */     this.sqlWarning = null;
/*      */   }
/*      */ 
/*      */   void foundPlsqlCompilerWarning()
/*      */     throws SQLException
/*      */   {
/* 3314 */     SQLWarning localSQLWarning = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
/*      */ 
/* 3316 */     if (this.sqlWarning != null)
/*      */     {
/* 3318 */       this.sqlWarning.setNextWarning(localSQLWarning);
/*      */     }
/*      */     else
/*      */     {
/* 3322 */       this.sqlWarning = localSQLWarning;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCursorName(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3339 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 3340 */     localSQLException.fillInStackTrace();
/* 3341 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public ResultSet getResultSet()
/*      */     throws SQLException
/*      */   {
/* 3354 */     synchronized (this.connection)
/*      */     {
/* 3361 */       ensureOpen();
/* 3362 */       if (this.implicitResultSetStatements != null)
/*      */       {
/* 3364 */         if (this.currentResultSet != null) {
/* 3365 */           return this.currentResultSet;
/*      */         }
/*      */ 
/* 3368 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 283);
/* 3369 */         localSQLException.fillInStackTrace();
/* 3370 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3374 */       if (this.sqlKind.isSELECT()) {
/* 3375 */         if (this.currentResultSet == null) {
/* 3376 */           computeOffsetOfFirstUserColumn();
/* 3377 */           this.currentResultSet = OracleResultSet.createResultSet(this);
/*      */         }
/*      */ 
/* 3380 */         return this.currentResultSet;
/*      */       }
/*      */ 
/* 3383 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getUpdateCount()
/*      */     throws SQLException
/*      */   {
/* 3400 */     synchronized (this.connection)
/*      */     {
/* 3407 */       ensureOpen();
/* 3408 */       int i = -1;
/*      */ 
/* 3410 */       switch (1.$SwitchMap$oracle$jdbc$internal$OracleStatement$SqlKind[this.sqlKind.ordinal()])
/*      */       {
/*      */       case 1:
/*      */       case 2:
/*      */       case 3:
/* 3417 */         break;
/*      */       case 4:
/*      */       case 5:
/* 3421 */         if (!this.noMoreUpdateCounts) {
/* 3422 */           i = this.rowsProcessed;
/*      */         }
/* 3424 */         this.noMoreUpdateCounts = true;
/*      */ 
/* 3426 */         break;
/*      */       case 6:
/*      */       case 7:
/* 3432 */         this.noMoreUpdateCounts = true;
/*      */ 
/* 3434 */         break;
/*      */       case 8:
/*      */       case 9:
/*      */       case 10:
/*      */       case 11:
/* 3442 */         if (!this.noMoreUpdateCounts) {
/* 3443 */           i = this.rowsProcessed;
/*      */         }
/* 3445 */         this.noMoreUpdateCounts = true;
/*      */       }
/*      */ 
/* 3450 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getMoreResults()
/*      */     throws SQLException
/*      */   {
/* 3467 */     ensureOpen();
/*      */ 
/* 3469 */     return getMoreResults(1);
/*      */   }
/*      */ 
/*      */   public int sendBatch()
/*      */     throws SQLException
/*      */   {
/* 3486 */     return 0;
/*      */   }
/*      */ 
/*      */   protected void increaseCapacity(int paramInt)
/*      */   {
/* 3514 */     if (this.storedRowCount + paramInt > this.currentCapacity)
/*      */     {
/* 3517 */       if (this.currentCapacity < 1024) i = this.currentCapacity * 4;
/* 3518 */       if (this.currentCapacity < 16384) i = (int)(this.currentCapacity * 1.5D); else
/* 3519 */         i = (int)(this.currentCapacity * 1.2D);
/* 3520 */       int i = Math.max(this.storedRowCount + paramInt, i);
/* 3521 */       i = (i / this.rowPrefetch + 1) * this.rowPrefetch;
/*      */ 
/* 3523 */       for (Accessor localAccessor : this.accessors) if (localAccessor != null) localAccessor.setCapacity(i);
/* 3524 */       this.currentCapacity = i;
/*      */     }
/*      */ 
/* 3527 */     assert (this.currentCapacity >= this.storedRowCount + paramInt) : ("currentCapacity: " + this.currentCapacity + " storedRowCount: " + this.storedRowCount + ", numberOfRows: " + paramInt);
/*      */   }
/*      */ 
/*      */   protected void drainStreams()
/*      */     throws SQLException
/*      */   {
/* 3535 */     if (this.streamList != null)
/*      */     {
/* 3537 */       while (this.nextStream != null) {
/*      */         try {
/* 3539 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 3543 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3544 */           localSQLException.fillInStackTrace();
/* 3545 */           throw localSQLException;
/*      */         }
/*      */ 
/* 3548 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   int fetchMoreRows(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3573 */     assert (!this.isComplete) : ("isComplete: " + this.isComplete);
/*      */ 
/* 3580 */     if (this.realRsetType.isScrollable()) increaseCapacity(this.rowPrefetch);
/* 3581 */     check_row_prefetch_changed();
/*      */ 
/* 3583 */     drainStreams();
/*      */ 
/* 3585 */     this.connection.registerHeartbeat();
/* 3586 */     this.connection.needLine();
/*      */     try {
/* 3588 */       this.cancelLock.enterExecuting();
/*      */ 
/* 3590 */       fetch(this.realRsetType.isScrollable() ? paramInt : 0, this.realRsetType.isScrollable());
/*      */ 
/* 3592 */       if ((!$assertionsDisabled) && (this.validRows == -2) && (this.rowPrefetch != 1)) throw new AssertionError("validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch); 
/*      */     }
/*      */     finally
/*      */     {
/* 3595 */       this.cancelLock.exitExecuting();
/*      */     }
/*      */ 
/* 3598 */     checkValidRowsStatus();
/*      */ 
/* 3600 */     if (this.realRsetType.isScrollable())
/*      */     {
/* 3602 */       this.storedRowCount += this.validRows;
/*      */     }
/*      */     else {
/* 3605 */       this.indexOfFirstRow += this.storedRowCount;
/* 3606 */       this.storedRowCount = this.validRows;
/*      */     }
/* 3608 */     if ((this.maxRows > 0) && (this.indexOfFirstRow + this.storedRowCount >= this.maxRows)) this.isComplete = true;
/*      */ 
/* 3611 */     assert (paramInt - this.indexOfFirstRow >= 0) : ("firstRow: " + paramInt + " indexOfFirstRow: " + this.indexOfFirstRow);
/*      */ 
/* 3613 */     assert (paramInt - this.indexOfFirstRow < this.currentCapacity) : ("firstRow: " + paramInt + " indexOfFirstRow: " + this.indexOfFirstRow + " currentCapacity: " + this.currentCapacity);
/*      */ 
/* 3616 */     assert (this.validRows >= 0) : ("validRows: " + this.validRows);
/* 3617 */     assert ((this.validRows > 0) || (this.isComplete)) : ("validRows: " + this.validRows + ", isComplete: " + this.isComplete);
/* 3618 */     return this.validRows;
/*      */   }
/*      */ 
/*      */   boolean isComplete()
/*      */     throws SQLException
/*      */   {
/* 3629 */     return (this.isComplete) || ((this.implicitResultSetStatements == null) && (!this.serverCursor) && (!this.sqlObject.getSqlKind().isSELECT()));
/*      */   }
/*      */ 
/*      */   int storedRowCount()
/*      */   {
/* 3640 */     return this.storedRowCount;
/*      */   }
/*      */ 
/*      */   int refreshRows(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3654 */     if (this.refreshStatement == null) {
/* 3655 */       this.refreshStatement = this.connection.prepareStatementInternal(this.sqlObject.getRefetchSql(), 1003, 1007);
/*      */ 
/* 3659 */       this.refreshStatement.isRowidPrepended = true;
/* 3660 */       this.refreshStatement.isFetchStreams = true;
/* 3661 */       this.refreshStatement.copyDefines(this, paramInt2);
/* 3662 */       copyBinds(this.refreshStatement, 1);
/*      */     }
/*      */ 
/* 3665 */     int i = paramInt1 - 1 - this.indexOfFirstRow;
/*      */ 
/* 3668 */     ARRAY localARRAY = this.connection.createARRAY("SYS.ODCIVARCHAR2LIST", getRowKeys(i, paramInt2));
/*      */ 
/* 3670 */     this.refreshStatement.setArray(1, localARRAY);
/* 3671 */     this.refreshStatement.setFetchSize(paramInt2);
/* 3672 */     ResultSet localResultSet = null;
/*      */     try {
/* 3674 */       localResultSet = this.refreshStatement.executeQuery();
/* 3675 */       int j = 0;
/* 3676 */       for (int k = 0; localResultSet.next(); k++)
/*      */       {
/* 3678 */         assert (i + k < this.storedRowCount) : ("destRow: " + i + " storedRowCount: " + this.storedRowCount);
/*      */ 
/* 3681 */         if (this.accessors[0].getROWID(i + k).equals(this.refreshStatement.accessors[0].getROWID(k))) {
/* 3682 */           j++;
/* 3683 */           for (int m = 1; m < this.accessors.length; m++)
/*      */           {
/* 3687 */             if (this.accessors[m] != null) {
/* 3688 */               this.accessors[m].copyFrom(this.refreshStatement.accessors[m], k, i + k);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 3698 */       return j;
/*      */     }
/*      */     finally {
/* 3701 */       if (localResultSet != null) try {
/* 3702 */           localResultSet.close();
/*      */         } catch (Exception localException3) {
/*      */         } if (this.refreshStatement != null)
/*      */         try {
/* 3706 */           this.refreshStatement.drainStreams();
/* 3707 */           this.refreshStatement.close();
/*      */         } catch (Exception localException4) {
/*      */         } finally {
/* 3710 */           this.refreshStatement = null;
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected String[] getRowKeys(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3730 */     ArrayList localArrayList = new ArrayList(paramInt2);
/* 3731 */     int i = Math.min(paramInt2, this.storedRowCount - paramInt1);
/* 3732 */     for (int j = 0; j < i; j++) localArrayList.add(this.accessors[0].getString(paramInt1 + j));
/* 3733 */     return (String[])localArrayList.toArray(new String[0]);
/*      */   }
/*      */ 
/*      */   void removeRowFromCache(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3747 */     if (paramInt < this.indexOfFirstRow)
/*      */     {
/* 3750 */       this.indexOfFirstRow -= 1;
/*      */     }
/* 3752 */     else if (paramInt >= this.indexOfFirstRow)
/*      */     {
/* 3754 */       assert (paramInt < this.indexOfFirstRow + this.storedRowCount) : ("row: " + paramInt + " indexOfFirstRow: " + this.indexOfFirstRow + " storedRowCount: " + this.storedRowCount);
/* 3755 */       for (Accessor localAccessor : this.accessors) if (localAccessor != null) deleteRow(localAccessor, paramInt - this.indexOfFirstRow);
/* 3756 */       this.storedRowCount -= 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void deleteRow(Accessor paramAccessor, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3767 */     paramAccessor.deleteRow(paramInt);
/*      */   }
/*      */ 
/*      */   void prepareForNewResults(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
/*      */     throws SQLException
/*      */   {
/* 3780 */     if (!this.closed) {
/* 3781 */       clearWarnings();
/*      */     }
/*      */ 
/* 3784 */     if ((paramBoolean3) && (this.implicitResultSetStatements != null)) {
/* 3785 */       for (Iterator localIterator = this.implicitResultSetStatements.iterator(); localIterator.hasNext(); ) { localObject = (OracleStatement)localIterator.next();
/* 3786 */         ((OracleStatement)localObject).close();
/*      */       }
/*      */       Object localObject;
/* 3788 */       this.implicitResultSetStatements = null;
/* 3789 */       this.implicitResultSetIterator = null;
/*      */ 
/* 3791 */       if (this.openImplicitResultSets != null) {
/* 3792 */         for (localIterator = this.openImplicitResultSets.iterator(); localIterator.hasNext(); ) { localObject = (OracleResultSet)localIterator.next();
/* 3793 */           ((OracleResultSet)localObject).close();
/*      */         }
/* 3795 */         this.openImplicitResultSets = null;
/*      */       }
/*      */     }
/*      */ 
/* 3799 */     closeAllStreams(paramBoolean2);
/*      */ 
/* 3801 */     if (this.currentResultSet != null) {
/* 3802 */       this.currentResultSet.close();
/* 3803 */       this.currentResultSet = null;
/*      */     }
/*      */ 
/* 3806 */     this.rowData.reset();
/* 3807 */     this.storedRowCount = 0;
/* 3808 */     this.indexOfFirstRow = 0;
/* 3809 */     this.isComplete = false;
/* 3810 */     this.offsetOfFirstUserColumn = -1;
/* 3811 */     this.checkSum = 0L;
/* 3812 */     this.checkSumComputationFailure = false;
/* 3813 */     this.validRows = 0;
/* 3814 */     this.batchRowsUpdatedArray = null;
/* 3815 */     this.gotLastBatch = false;
/*      */ 
/* 3817 */     if ((this.needToParse) && (!this.columnsDefinedByUser)) {
/* 3818 */       if ((paramBoolean2) && (this.numberOfDefinePositions != 0)) {
/* 3819 */         this.numberOfDefinePositions = 0;
/*      */       }
/* 3821 */       this.needToPrepareDefineBuffer = true;
/*      */     }
/*      */ 
/* 3825 */     if ((paramBoolean1) && (this.rowPrefetch != this.defaultRowPrefetch) && (this.streamList == null))
/*      */     {
/* 3828 */       this.rowPrefetch = this.defaultRowPrefetch;
/* 3829 */       this.rowPrefetchChanged = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   void closeAllStreams(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3836 */     drainStreams();
/* 3837 */     if (paramBoolean) {
/* 3838 */       OracleInputStream localOracleInputStream1 = this.streamList;
/* 3839 */       OracleInputStream localOracleInputStream2 = null;
/* 3840 */       this.streamList = null;
/* 3841 */       while (localOracleInputStream1 != null) {
/* 3842 */         if (!localOracleInputStream1.hasBeenOpen) {
/* 3843 */           if (localOracleInputStream2 == null) this.streamList = localOracleInputStream1; else
/* 3844 */             localOracleInputStream2.nextStream = localOracleInputStream1;
/* 3845 */           localOracleInputStream2 = localOracleInputStream1;
/*      */         }
/* 3847 */         localOracleInputStream1 = localOracleInputStream1.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void reopenStreams()
/*      */     throws SQLException
/*      */   {
/* 3861 */     OracleInputStream localOracleInputStream = this.streamList;
/*      */ 
/* 3863 */     while (localOracleInputStream != null)
/*      */     {
/* 3865 */       if (localOracleInputStream.hasBeenOpen) {
/* 3866 */         localOracleInputStream = localOracleInputStream.accessor.initForNewRow();
/*      */       }
/* 3868 */       localOracleInputStream.closed = false;
/* 3869 */       localOracleInputStream.hasBeenOpen = true;
/* 3870 */       localOracleInputStream = localOracleInputStream.nextStream;
/*      */     }
/*      */ 
/* 3873 */     this.nextStream = this.streamList;
/*      */   }
/*      */ 
/*      */   void endOfResultSet(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3885 */     if (!paramBoolean)
/*      */     {
/* 3888 */       prepareForNewResults(false, false, false);
/*      */     }
/*      */ 
/* 3893 */     clearDefines();
/* 3894 */     this.rowPrefetchInLastFetch = -1;
/*      */   }
/*      */ 
/*      */   boolean wasNullValue(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 3911 */     if (this.closed) {
/* 3912 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "wasNull");
/* 3913 */       localSQLException.fillInStackTrace();
/* 3914 */       throw localSQLException;
/*      */     }
/* 3916 */     if (this.lastIndex < 0) {
/* 3917 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 24);
/* 3918 */       localSQLException.fillInStackTrace();
/* 3919 */       throw localSQLException;
/*      */     }
/* 3921 */     return isNull(paramInt, this.lastIndex);
/*      */   }
/*      */ 
/*      */   boolean isNull(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3927 */     if ((this.sqlKind.isSELECT()) || (this.isDmlReturning)) {
/* 3928 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].isNull(paramInt1 - this.indexOfFirstRow);
/*      */     }
/*      */ 
/* 3931 */     assert (paramInt1 == this.currentRank) : ("rowIndex: " + paramInt1 + " currentRank: " + this.currentRank);
/* 3932 */     return this.outBindAccessors[(paramInt2 - 1)].isNull(this.currentRank);
/*      */   }
/*      */ 
/*      */   int getColumnIndex(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3947 */     ensureOpen();
/* 3948 */     if (!this.describedWithNames)
/*      */     {
/* 3950 */       synchronized (this.connection) {
/* 3951 */         doDescribe(true);
/*      */ 
/* 3953 */         this.described = true;
/* 3954 */         this.describedWithNames = true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3959 */     for (int i = 1 + this.offsetOfFirstUserColumn; i < this.numberOfDefinePositions; i++) {
/* 3960 */       if (this.accessors[i].columnName.equalsIgnoreCase(paramString)) {
/* 3961 */         return i - this.offsetOfFirstUserColumn;
/*      */       }
/*      */     }
/* 3964 */     ??? = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/* 3965 */     ((SQLException)???).fillInStackTrace();
/* 3966 */     throw ((Throwable)???);
/*      */   }
/*      */ 
/*      */   int getJDBCType(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3974 */     int i = 0;
/* 3975 */     switch (paramInt)
/*      */     {
/*      */     case 6:
/* 3978 */       i = 2;
/* 3979 */       break;
/*      */     case 100:
/* 3981 */       i = 100;
/* 3982 */       break;
/*      */     case 101:
/* 3984 */       i = 101;
/* 3985 */       break;
/*      */     case 999:
/* 3987 */       i = 999;
/* 3988 */       break;
/*      */     case 96:
/* 3990 */       i = 1;
/* 3991 */       break;
/*      */     case 1:
/* 3993 */       i = 12;
/* 3994 */       break;
/*      */     case 8:
/* 3996 */       i = -1;
/* 3997 */       break;
/*      */     case 12:
/* 3999 */       i = 91;
/* 4000 */       break;
/*      */     case 180:
/* 4002 */       i = 93;
/* 4003 */       break;
/*      */     case 181:
/* 4005 */       i = -101;
/* 4006 */       break;
/*      */     case 231:
/* 4008 */       i = -102;
/* 4009 */       break;
/*      */     case 182:
/* 4011 */       i = -103;
/* 4012 */       break;
/*      */     case 183:
/* 4014 */       i = -104;
/* 4015 */       break;
/*      */     case 23:
/* 4017 */       i = -2;
/* 4018 */       break;
/*      */     case 24:
/* 4020 */       i = -4;
/* 4021 */       break;
/*      */     case 104:
/* 4023 */       i = -8;
/* 4024 */       break;
/*      */     case 113:
/* 4026 */       i = 2004;
/* 4027 */       break;
/*      */     case 112:
/* 4029 */       i = 2005;
/* 4030 */       break;
/*      */     case 114:
/* 4032 */       i = -13;
/* 4033 */       break;
/*      */     case 102:
/* 4035 */       i = -10;
/* 4036 */       break;
/*      */     case 109:
/* 4038 */       i = 2002;
/* 4039 */       break;
/*      */     case 111:
/* 4041 */       i = 2006;
/* 4042 */       break;
/*      */     case 998:
/* 4044 */       i = -14;
/* 4045 */       break;
/*      */     case 995:
/* 4047 */       i = 0;
/* 4048 */       break;
/*      */     default:
/* 4050 */       i = paramInt;
/*      */     }
/*      */ 
/* 4053 */     return i;
/*      */   }
/*      */ 
/*      */   int getInternalType(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4060 */     int i = 0;
/*      */ 
/* 4062 */     switch (paramInt)
/*      */     {
/*      */     case -7:
/*      */     case -6:
/*      */     case -5:
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/* 4074 */       i = 6;
/* 4075 */       break;
/*      */     case 100:
/* 4078 */       i = 100;
/* 4079 */       break;
/*      */     case 101:
/* 4082 */       i = 101;
/* 4083 */       break;
/*      */     case 999:
/* 4086 */       i = 999;
/* 4087 */       break;
/*      */     case 1:
/* 4090 */       i = 96;
/* 4091 */       break;
/*      */     case -15:
/*      */     case -9:
/*      */     case 12:
/* 4096 */       i = 1;
/* 4097 */       break;
/*      */     case -16:
/*      */     case -1:
/* 4101 */       i = 8;
/* 4102 */       break;
/*      */     case 91:
/*      */     case 92:
/* 4106 */       i = 12;
/* 4107 */       break;
/*      */     case -100:
/*      */     case 93:
/* 4111 */       i = 180;
/* 4112 */       break;
/*      */     case -101:
/* 4115 */       i = 181;
/* 4116 */       break;
/*      */     case -102:
/* 4119 */       i = 231;
/* 4120 */       break;
/*      */     case -103:
/* 4124 */       i = 182;
/* 4125 */       break;
/*      */     case -104:
/* 4128 */       i = 183;
/* 4129 */       break;
/*      */     case -3:
/*      */     case -2:
/* 4133 */       i = 23;
/* 4134 */       break;
/*      */     case -4:
/* 4137 */       i = 24;
/* 4138 */       break;
/*      */     case -8:
/* 4141 */       i = 104;
/* 4142 */       break;
/*      */     case 2004:
/* 4145 */       i = 113;
/* 4146 */       break;
/*      */     case 2005:
/*      */     case 2011:
/* 4150 */       i = 112;
/* 4151 */       break;
/*      */     case -13:
/* 4154 */       i = 114;
/* 4155 */       break;
/*      */     case -10:
/* 4158 */       i = 102;
/* 4159 */       break;
/*      */     case 2002:
/*      */     case 2003:
/*      */     case 2007:
/*      */     case 2008:
/*      */     case 2009:
/* 4166 */       i = 109;
/* 4167 */       break;
/*      */     case 2006:
/* 4170 */       i = 111;
/* 4171 */       break;
/*      */     case -14:
/* 4174 */       i = 998;
/* 4175 */       break;
/*      */     case 70:
/* 4178 */       i = 1;
/* 4179 */       break;
/*      */     case 0:
/* 4182 */       i = 995;
/* 4183 */       break;
/*      */     default:
/* 4187 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, Integer.toString(paramInt));
/* 4188 */       localSQLException.fillInStackTrace();
/* 4189 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4193 */     return i;
/*      */   }
/*      */ 
/*      */   ResultSetMetaData getResultSetMetaData()
/*      */     throws SQLException
/*      */   {
/* 4206 */     return new OracleResultSetMetaData(this.connection, this, this.offsetOfFirstUserColumn);
/*      */   }
/*      */ 
/*      */   void describe()
/*      */     throws SQLException
/*      */   {
/* 4219 */     synchronized (this.connection)
/*      */     {
/* 4221 */       ensureOpen();
/* 4222 */       if (!this.described)
/* 4223 */         doDescribe(false);
/*      */     }
/*      */   }
/*      */ 
/*      */   void freeLine()
/*      */     throws SQLException
/*      */   {
/* 4232 */     if (this.streamList != null)
/*      */     {
/* 4236 */       while (this.nextStream != null)
/*      */       {
/*      */         try
/*      */         {
/* 4240 */           this.nextStream.close();
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 4245 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4246 */           localSQLException.fillInStackTrace();
/* 4247 */           throw localSQLException;
/*      */         }
/*      */ 
/* 4251 */         this.nextStream = this.nextStream.nextStream;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void closeUsedStreams(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4264 */     while ((this.nextStream != null) && (this.nextStream.columnIndex < paramInt))
/*      */     {
/*      */       try
/*      */       {
/* 4270 */         this.nextStream.close();
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 4275 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4276 */         localSQLException.fillInStackTrace();
/* 4277 */         throw localSQLException;
/*      */       }
/*      */ 
/* 4281 */       this.nextStream = this.nextStream.nextStream;
/*      */     }
/*      */   }
/*      */ 
/*      */   final void ensureOpen()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 4293 */     if (this.connection.lifecycle != 1)
/*      */     {
/* 4295 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 4296 */       localSQLException.fillInStackTrace();
/* 4297 */       throw localSQLException;
/*      */     }
/* 4299 */     if (this.closed)
/*      */     {
/* 4301 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 4302 */       localSQLException.fillInStackTrace();
/* 4303 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateTmpByteArray()
/*      */   {
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4337 */     synchronized (this.connection)
/*      */     {
/* 4344 */       ensureOpen();
/* 4345 */       if (paramInt != 1000)
/*      */       {
/* 4350 */         if ((paramInt == 1001) || (paramInt == 1002))
/*      */         {
/* 4353 */           this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
/*      */         }
/*      */         else
/*      */         {
/* 4359 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
/* 4360 */           localSQLException.fillInStackTrace();
/* 4361 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getFetchDirection()
/*      */     throws SQLException
/*      */   {
/* 4389 */     ensureOpen();
/* 4390 */     return 1000;
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4409 */     synchronized (this.connection)
/*      */     {
/* 4416 */       ensureOpen();
/*      */ 
/* 4418 */       setPrefetchInternal(paramInt, false, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */     throws SQLException
/*      */   {
/* 4445 */     ensureOpen();
/*      */ 
/* 4447 */     return getPrefetchInternal(true);
/*      */   }
/*      */ 
/*      */   public int getResultSetConcurrency()
/*      */     throws SQLException
/*      */   {
/* 4464 */     ensureOpen();
/* 4465 */     return this.userRsetType.getConcur();
/*      */   }
/*      */ 
/*      */   public int getResultSetType()
/*      */     throws SQLException
/*      */   {
/* 4482 */     ensureOpen();
/* 4483 */     return this.userRsetType.getType();
/*      */   }
/*      */ 
/*      */   public Connection getConnection()
/*      */     throws SQLException
/*      */   {
/* 4503 */     ensureOpen();
/* 4504 */     return this.connection.getWrapper();
/*      */   }
/*      */ 
/*      */   boolean isOracleBatchStyle()
/*      */   {
/* 4512 */     return false;
/*      */   }
/*      */ 
/*      */   void initBatch()
/*      */   {
/*      */   }
/*      */ 
/*      */   int getBatchSize()
/*      */   {
/* 4548 */     if (this.m_batchItems == null)
/*      */     {
/* 4550 */       return 0;
/*      */     }
/*      */ 
/* 4554 */     return this.m_batchItems.size();
/*      */   }
/*      */ 
/*      */   void addBatchItem(String paramString)
/*      */   {
/* 4562 */     if (this.m_batchItems == null)
/*      */     {
/* 4564 */       this.m_batchItems = new Vector();
/*      */     }
/* 4566 */     this.m_batchItems.addElement(paramString);
/*      */   }
/*      */ 
/*      */   String getBatchItem(int paramInt)
/*      */   {
/* 4573 */     if (this.m_batchItems == null) {
/* 4574 */       return null;
/*      */     }
/* 4576 */     return (String)this.m_batchItems.elementAt(paramInt);
/*      */   }
/*      */ 
/*      */   void clearBatchItems()
/*      */   {
/* 4584 */     if (this.m_batchItems != null)
/*      */     {
/* 4586 */       this.m_batchItems.removeAllElements();
/*      */     }
/*      */   }
/*      */ 
/*      */   void checkIfJdbcBatchExists()
/*      */     throws SQLException
/*      */   {
/* 4603 */     if (getBatchSize() > 0)
/*      */     {
/* 4606 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
/* 4607 */       localSQLException.fillInStackTrace();
/* 4608 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addBatch(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4634 */     synchronized (this.connection)
/*      */     {
/* 4641 */       ensureOpen();
/* 4642 */       addBatchItem(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clearBatch()
/*      */     throws SQLException
/*      */   {
/* 4657 */     synchronized (this.connection)
/*      */     {
/* 4664 */       ensureOpen();
/* 4665 */       clearBatchItems();
/*      */     }
/*      */   }
/*      */ 
/*      */   public int[] executeBatch()
/*      */     throws SQLException
/*      */   {
/* 4696 */     synchronized (this.connection)
/*      */     {
/* 4703 */       ensureOpen();
/*      */ 
/* 4707 */       cleanUpBeforeExecute();
/* 4708 */       cleanOldTempLobs();
/* 4709 */       int i = 0;
/* 4710 */       int j = getBatchSize();
/* 4711 */       this.checkSum = 0L;
/* 4712 */       this.checkSumComputationFailure = false;
/*      */ 
/* 4716 */       if (j <= 0)
/*      */       {
/* 4720 */         return new int[0];
/*      */       }
/*      */ 
/* 4723 */       int[] arrayOfInt = new int[j];
/*      */ 
/* 4729 */       ensureOpen();
/*      */ 
/* 4732 */       prepareForNewResults(true, true, true);
/*      */ 
/* 4736 */       int k = this.numberOfDefinePositions;
/* 4737 */       String str = this.sqlObject.getOriginalSql();
/* 4738 */       OracleStatement.SqlKind localSqlKind = this.sqlKind;
/*      */ 
/* 4741 */       this.noMoreUpdateCounts = false;
/*      */ 
/* 4743 */       int m = 0;
/*      */       try
/*      */       {
/* 4752 */         this.connection.registerHeartbeat();
/*      */ 
/* 4754 */         this.connection.needLine();
/*      */ 
/* 4756 */         for (i = 0; i < j; i++)
/*      */         {
/* 4758 */           this.sqlObject.initialize(getBatchItem(i));
/*      */ 
/* 4760 */           this.sqlKind = this.sqlObject.getSqlKind();
/*      */ 
/* 4766 */           this.needToParse = true;
/* 4767 */           this.numberOfDefinePositions = 0;
/*      */ 
/* 4770 */           this.rowsProcessed = 0;
/* 4771 */           this.currentRank = 1;
/*      */ 
/* 4773 */           if (this.sqlKind.isSELECT())
/*      */           {
/* 4776 */             BatchUpdateException localBatchUpdateException1 = DatabaseError.createBatchUpdateException(80, "invalid SELECT batch command " + i, i, arrayOfInt);
/*      */ 
/* 4778 */             localBatchUpdateException1.fillInStackTrace();
/* 4779 */             throw localBatchUpdateException1;
/*      */           }
/*      */ 
/* 4784 */           if (!this.isOpen)
/*      */           {
/* 4786 */             this.connection.open(this);
/*      */ 
/* 4788 */             this.isOpen = true;
/*      */           }
/*      */ 
/* 4791 */           int n = -1;
/*      */           try
/*      */           {
/* 4795 */             if (this.queryTimeout != 0) {
/* 4796 */               this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
/*      */             }
/* 4798 */             this.cancelLock.enterExecuting();
/*      */ 
/* 4800 */             executeForRows(false);
/*      */ 
/* 4802 */             if (this.validRows > 0) {
/* 4803 */               m += this.validRows;
/*      */             }
/* 4805 */             n = this.validRows;
/*      */           }
/*      */           catch (SQLException localSQLException2)
/*      */           {
/* 4809 */             this.needToParse = true;
/* 4810 */             resetCurrentRowBinders();
/* 4811 */             throw localSQLException2;
/*      */           }
/*      */           finally
/*      */           {
/* 4815 */             if (this.queryTimeout != 0) {
/* 4816 */               this.connection.getTimeout().cancelTimeout();
/*      */             }
/* 4818 */             this.validRows = m;
/*      */ 
/* 4820 */             this.cancelLock.exitExecuting();
/*      */ 
/* 4822 */             checkValidRowsStatus();
/*      */           }
/*      */ 
/* 4827 */           arrayOfInt[i] = n;
/*      */ 
/* 4829 */           if (arrayOfInt[i] < 0)
/*      */           {
/* 4832 */             localBatchUpdateException2 = DatabaseError.createBatchUpdateException(81, "command return value " + arrayOfInt[i], i, arrayOfInt);
/*      */ 
/* 4834 */             localBatchUpdateException2.fillInStackTrace();
/* 4835 */             throw localBatchUpdateException2;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/* 4842 */         if ((localSQLException1 instanceof BatchUpdateException))
/*      */         {
/* 4844 */           throw localSQLException1;
/*      */         }
/*      */ 
/* 4849 */         BatchUpdateException localBatchUpdateException2 = DatabaseError.createBatchUpdateException(81, localSQLException1.getMessage(), i, arrayOfInt);
/* 4850 */         localBatchUpdateException2.fillInStackTrace();
/* 4851 */         throw localBatchUpdateException2;
/*      */       }
/*      */       finally
/*      */       {
/* 4857 */         clearBatchItems();
/*      */ 
/* 4859 */         this.numberOfDefinePositions = k;
/*      */ 
/* 4861 */         if (str != null)
/*      */         {
/* 4863 */           this.sqlObject.initialize(str);
/*      */ 
/* 4865 */           this.sqlKind = localSqlKind;
/*      */         }
/*      */ 
/* 4868 */         this.currentRank = 0;
/*      */       }
/*      */ 
/* 4875 */       this.connection.registerHeartbeat();
/*      */ 
/* 4881 */       return arrayOfInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   void copyDefines(OracleStatement paramOracleStatement, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4893 */     if (paramOracleStatement.columnsDefinedByUser) {
/* 4894 */       Accessor[] arrayOfAccessor = paramOracleStatement.accessors;
/* 4895 */       this.accessors = new Accessor[arrayOfAccessor.length];
/* 4896 */       for (int i = 0; i < arrayOfAccessor.length; i++) {
/* 4897 */         if (arrayOfAccessor[i] != null) {
/* 4898 */           this.accessors[i] = arrayOfAccessor[i].copyForDefine(this);
/* 4899 */           this.accessors[i].setCapacity(paramInt);
/*      */         }
/*      */       }
/* 4902 */       this.numberOfDefinePositions = paramOracleStatement.numberOfDefinePositions;
/* 4903 */       this.definedColumnType = paramOracleStatement.definedColumnType;
/* 4904 */       this.definedColumnSize = paramOracleStatement.definedColumnSize;
/* 4905 */       this.definedColumnFormOfUse = paramOracleStatement.definedColumnFormOfUse;
/* 4906 */       this.columnsDefinedByUser = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   int copyBinds(Statement paramStatement, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4922 */     return 0;
/*      */   }
/*      */ 
/*      */   public void notifyCloseRset()
/*      */     throws SQLException
/*      */   {
/* 4933 */     endOfResultSet(false);
/*      */   }
/*      */ 
/*      */   public String getOriginalSql()
/*      */     throws SQLException
/*      */   {
/* 4943 */     return this.sqlObject.getOriginalSql();
/*      */   }
/*      */ 
/*      */   boolean isRowidPrepended()
/*      */   {
/* 4951 */     return this.isRowidPrepended;
/*      */   }
/*      */ 
/*      */   void computeOffsetOfFirstUserColumn()
/*      */   {
/* 4967 */     this.offsetOfFirstUserColumn = -1;
/* 4968 */     if (this.sqlKind.isSELECT()) {
/* 4969 */       if (this.isRowidPrepended) this.offsetOfFirstUserColumn += 1;
/*      */ 
/*      */     }
/* 4972 */     else if (this.numReturnParams > 0)
/* 4973 */       this.offsetOfFirstUserColumn = (this.numberOfBindPositions - this.numReturnParams - 1);
/*      */   }
/*      */ 
/*      */   void doScrollExecuteCommon()
/*      */     throws SQLException
/*      */   {
/* 4984 */     if (!this.sqlKind.isSELECT()) {
/* 4985 */       doExecuteWithTimeout();
/*      */ 
/* 4987 */       return;
/*      */     }
/*      */ 
/* 4993 */     boolean bool = (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN ? this.userRsetType : this.realRsetType).isIdentifierRequired();
/*      */ 
/* 4996 */     if (!bool)
/*      */     {
/* 4999 */       doExecuteWithTimeout();
/*      */ 
/* 5001 */       computeOffsetOfFirstUserColumn();
/* 5002 */       this.currentResultSet = OracleResultSet.createResultSet(this);
/* 5003 */       this.realRsetType = this.userRsetType;
/*      */     }
/*      */     else
/*      */     {
/*      */       try {
/* 5008 */         this.sqlObject.setIncludeRowid(true);
/* 5009 */         this.isRowidPrepended = true;
/*      */ 
/* 5011 */         this.needToParse = true;
/*      */ 
/* 5015 */         prepareForNewResults(true, false, true);
/*      */ 
/* 5019 */         if (this.columnsDefinedByUser) {
/* 5020 */           Accessor[] arrayOfAccessor = this.accessors;
/*      */ 
/* 5022 */           if ((this.accessors == null) || (this.accessors.length <= this.numberOfDefinePositions)) {
/* 5023 */             this.accessors = new Accessor[this.numberOfDefinePositions + 1];
/*      */           }
/* 5025 */           if (arrayOfAccessor != null) {
/* 5026 */             for (i = this.numberOfDefinePositions; i > 0; i--) {
/* 5027 */               localAccessor = arrayOfAccessor[(i - 1)];
/*      */ 
/* 5029 */               this.accessors[i] = localAccessor;
/*      */ 
/* 5031 */               if (localAccessor.isColumnNumberAware)
/*      */               {
/* 5036 */                 localAccessor.updateColumnNumber(i);
/*      */               }
/*      */             }
/*      */           }
/* 5040 */           allocateRowidAccessor();
/* 5041 */           this.numberOfDefinePositions += 1;
/*      */         }
/*      */ 
/* 5044 */         doExecuteWithTimeout();
/*      */ 
/* 5046 */         computeOffsetOfFirstUserColumn();
/* 5047 */         this.currentResultSet = OracleResultSet.createResultSet(this);
/* 5048 */         this.realRsetType = this.userRsetType;
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */         int i;
/*      */         Accessor localAccessor;
/* 5055 */         this.realRsetType = this.userRsetType.downgrade();
/*      */ 
/* 5057 */         this.isRowidPrepended = this.realRsetType.isIdentifierRequired();
/* 5058 */         this.sqlObject.setIncludeRowid(this.isRowidPrepended);
/*      */ 
/* 5060 */         this.needToParse = true;
/*      */ 
/* 5064 */         prepareForNewResults(true, false, true);
/*      */ 
/* 5068 */         if (this.columnsDefinedByUser) {
/* 5069 */           this.needToPrepareDefineBuffer = true;
/* 5070 */           this.numberOfDefinePositions -= 1;
/*      */ 
/* 5072 */           System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
/*      */ 
/* 5074 */           this.accessors[this.numberOfDefinePositions] = null;
/*      */ 
/* 5076 */           for (i = 0; i < this.numberOfDefinePositions; i++) {
/* 5077 */             localAccessor = this.accessors[i];
/*      */ 
/* 5079 */             if (localAccessor.isColumnNumberAware)
/*      */             {
/* 5083 */               localAccessor.updateColumnNumber(i);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 5091 */         moveAllTempLobsToFree();
/* 5092 */         doExecuteWithTimeout();
/*      */ 
/* 5094 */         computeOffsetOfFirstUserColumn();
/* 5095 */         this.currentResultSet = OracleResultSet.createResultSet(this);
/* 5096 */         this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, localSQLException.getMessage());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void allocateRowidAccessor()
/*      */     throws SQLException
/*      */   {
/* 5115 */     this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
/*      */   }
/*      */ 
/*      */   OracleResultSet doScrollStmtExecuteQuery()
/*      */     throws SQLException
/*      */   {
/* 5124 */     doScrollExecuteCommon();
/*      */ 
/* 5126 */     return this.currentResultSet;
/*      */   }
/*      */ 
/*      */   void processDmlReturningBind()
/*      */     throws SQLException
/*      */   {
/* 5134 */     this.returnParamsFetched = false;
/*      */ 
/* 5136 */     int i = 0;
/* 5137 */     for (int j = 0; j < this.numberOfBindPositions; j++) {
/* 5138 */       if (this.accessors[j] != null) i++;
/*      */     }
/*      */ 
/* 5141 */     if (this.isAutoGeneratedKey) {
/* 5142 */       this.numReturnParams = i;
/*      */     }
/*      */     else
/*      */     {
/* 5146 */       if (this.numReturnParams <= 0) {
/* 5147 */         this.numReturnParams = this.sqlObject.getReturnParameterCount();
/*      */       }
/* 5149 */       if (this.numReturnParams != i)
/*      */       {
/* 5151 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 173);
/* 5152 */         localSQLException.fillInStackTrace();
/* 5153 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */ 
/* 5157 */     this.returnParamMeta[0] = this.numReturnParams;
/*      */   }
/*      */ 
/*      */   void allocateDmlReturnStorage()
/*      */   {
/*      */   }
/*      */ 
/*      */   void fetchDmlReturnParams()
/*      */     throws SQLException
/*      */   {
/* 5178 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 5179 */     localSQLException.fillInStackTrace();
/* 5180 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void registerReturnParameterInternal(int paramInt1, int paramInt2, int paramInt3, int paramInt4, short paramShort, String paramString)
/*      */     throws SQLException
/*      */   {
/* 5196 */     this.isDmlReturning = true;
/* 5197 */     if (this.accessors == null) {
/* 5198 */       this.accessors = new Accessor[this.numberOfBindPositions];
/*      */     }
/* 5200 */     if (this.returnParamMeta == null)
/*      */     {
/* 5202 */       this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
/*      */     }
/*      */ 
/* 5208 */     switch (paramInt3) {
/*      */     case -16:
/*      */     case -15:
/*      */     case -9:
/*      */     case 2011:
/* 5213 */       paramShort = 2;
/* 5214 */       break;
/*      */     case 2009:
/* 5216 */       paramString = "SYS.XMLTYPE";
/* 5217 */       break;
/*      */     case -8:
/*      */     }
/*      */ 
/* 5225 */     Accessor localAccessor = allocateAccessor(paramInt2, paramInt3, paramInt1 + 1, paramInt4, paramShort, paramString, true);
/*      */ 
/* 5233 */     localAccessor.isDMLReturnedParam = true;
/* 5234 */     localAccessor.setCapacity(this.currentCapacity);
/* 5235 */     this.accessors[paramInt1] = localAccessor;
/*      */ 
/* 5237 */     int i = localAccessor.charLength > 0 ? 1 : 0;
/*      */ 
/* 5240 */     this.returnParamMeta[(3 + paramInt1 * 4 + 0)] = localAccessor.defineType;
/*      */ 
/* 5245 */     this.returnParamMeta[(3 + paramInt1 * 4 + 1)] = (i != 0 ? 1 : 0);
/*      */ 
/* 5250 */     this.returnParamMeta[(3 + paramInt1 * 4 + 2)] = (i != 0 ? localAccessor.charLength : localAccessor.byteLength);
/*      */ 
/* 5255 */     this.returnParamMeta[(3 + paramInt1 * 4 + 3)] = paramShort;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int creationState()
/*      */   {
/* 5276 */     synchronized (this.connection)
/*      */     {
/* 5278 */       return this.creationState;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isColumnSetNull(int paramInt)
/*      */   {
/* 5297 */     return this.columnSetNull;
/*      */   }
/*      */ 
/*      */   public boolean isNCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5320 */     if (!this.described) {
/* 5321 */       describe();
/*      */     }
/* 5323 */     int i = paramInt - 1;
/* 5324 */     if ((i < 0) || (i >= this.numberOfDefinePositions))
/*      */     {
/* 5326 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 5327 */       localSQLException.fillInStackTrace();
/* 5328 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5331 */     boolean bool = this.accessors[i].formOfUse == 2;
/*      */ 
/* 5334 */     return bool;
/*      */   }
/*      */ 
/*      */   void addChild(OracleStatement paramOracleStatement)
/*      */   {
/* 5342 */     paramOracleStatement.nextChild = this.children;
/* 5343 */     this.children = paramOracleStatement;
/* 5344 */     paramOracleStatement.parent = this;
/*      */   }
/*      */ 
/*      */   void addImplicitResultSetStmt(OracleStatement paramOracleStatement)
/*      */   {
/* 5351 */     this.implicitResultSetStatements.add(paramOracleStatement);
/*      */   }
/*      */ 
/*      */   void removeChild(OracleStatement paramOracleStatement)
/*      */   {
/* 5357 */     if (paramOracleStatement == this.children) {
/* 5358 */       this.children = paramOracleStatement.nextChild;
/*      */     }
/*      */     else {
/* 5361 */       OracleStatement localOracleStatement = this.children;
/* 5362 */       while (localOracleStatement.nextChild != paramOracleStatement) {
/* 5363 */         localOracleStatement = localOracleStatement.nextChild;
/*      */       }
/* 5365 */       localOracleStatement.nextChild = paramOracleStatement.nextChild;
/*      */     }
/* 5367 */     paramOracleStatement.parent = null;
/* 5368 */     paramOracleStatement.nextChild = null;
/*      */   }
/*      */ 
/*      */   public boolean getMoreResults(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5409 */     ensureOpen();
/*      */     Object localObject;
/* 5410 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/* 5413 */       if ((this.currentResultSet != null) && (!this.currentResultSet.isClosed()))
/* 5414 */         this.currentResultSet.close(); break;
/*      */     case 2:
/* 5418 */       if ((this.currentResultSet != null) && (!this.currentResultSet.isClosed()))
/*      */       {
/* 5420 */         if (this.openImplicitResultSets == null)
/*      */         {
/* 5422 */           this.openImplicitResultSets = new ArrayDeque(this.implicitResultSetStatements.size());
/*      */         }
/*      */ 
/* 5425 */         this.openImplicitResultSets.add(this.currentResultSet);
/* 5426 */         this.currentResultSet = null; } break;
/*      */     case 3:
/*      */     default:
/* 5430 */       while ((this.openImplicitResultSets != null) && (this.openImplicitResultSets.size() != 0))
/*      */       {
/* 5432 */         localObject = (OracleResultSet)this.openImplicitResultSets.remove();
/* 5433 */         ((OracleResultSet)localObject).close();
/* 5434 */         continue;
/*      */ 
/* 5438 */         localObject = DatabaseError.createUnsupportedFeatureSqlException();
/* 5439 */         ((SQLException)localObject).fillInStackTrace();
/* 5440 */         throw ((Throwable)localObject);
/*      */       }
/*      */     }
/*      */ 
/* 5444 */     if ((this.implicitResultSetIterator != null) && (this.implicitResultSetIterator.hasNext()))
/*      */     {
/* 5446 */       localObject = (OracleStatement)this.implicitResultSetIterator.next();
/* 5447 */       if (localObject != null)
/*      */       {
/* 5449 */         computeOffsetOfFirstUserColumn();
/* 5450 */         this.currentResultSet = OracleResultSet.createResultSet((OracleStatement)localObject);
/* 5451 */         return true;
/*      */       }
/*      */     }
/* 5454 */     return false;
/*      */   }
/*      */ 
/*      */   public ResultSet getGeneratedKeys()
/*      */     throws SQLException
/*      */   {
/* 5472 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 5480 */       if (this.closed) {
/* 5481 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 5482 */         localSQLException.fillInStackTrace();
/* 5483 */         throw localSQLException;
/*      */       }
/* 5485 */       if (!this.isAutoGeneratedKey) {
/* 5486 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 5487 */         localSQLException.fillInStackTrace();
/* 5488 */         throw localSQLException;
/*      */       }
/*      */ 
/* 5491 */       if ((this.accessors == null) || (this.numReturnParams == 0))
/*      */       {
/* 5493 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 144);
/* 5494 */         localSQLException.fillInStackTrace();
/* 5495 */         throw localSQLException;
/*      */       }
/*      */ 
/* 5498 */       if (this.currentResultSet == null) {
/* 5499 */         this.isComplete = true;
/* 5500 */         this.currentResultSet = new OracleReturnResultSet(this.connection, this);
/* 5501 */         computeOffsetOfFirstUserColumn();
/*      */       }
/*      */ 
/* 5504 */       return this.currentResultSet;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int executeUpdate(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5543 */     cleanUpBeforeExecute();
/* 5544 */     this.autoKeyInfo = new AutoKeyInfo(paramString);
/* 5545 */     if ((paramInt == 2) || (!this.autoKeyInfo.isInsertSqlStmt()))
/*      */     {
/* 5548 */       this.autoKeyInfo = null;
/* 5549 */       return executeUpdate(paramString);
/*      */     }
/*      */ 
/* 5552 */     if (paramInt != 1)
/*      */     {
/* 5554 */       this.autoKeyInfo = null;
/*      */ 
/* 5556 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5557 */       localSQLException.fillInStackTrace();
/* 5558 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5562 */     synchronized (this.connection) {
/* 5563 */       this.isAutoGeneratedKey = true;
/* 5564 */       String str = this.autoKeyInfo.getNewSql();
/* 5565 */       this.numberOfBindPositions = 1;
/*      */ 
/* 5568 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5570 */       processDmlReturningBind();
/*      */ 
/* 5572 */       return executeUpdateInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int executeUpdate(String paramString, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 5606 */     cleanUpBeforeExecute();
/* 5607 */     if ((paramArrayOfInt == null) || (paramArrayOfInt.length == 0))
/*      */     {
/* 5609 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5610 */       localSQLException.fillInStackTrace();
/* 5611 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5614 */     this.autoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfInt);
/* 5615 */     if (!this.autoKeyInfo.isInsertSqlStmt())
/*      */     {
/* 5617 */       this.autoKeyInfo = null;
/* 5618 */       return executeUpdate(paramString);
/*      */     }
/*      */ 
/* 5621 */     synchronized (this.connection) {
/* 5622 */       this.isAutoGeneratedKey = true;
/*      */ 
/* 5625 */       this.connection.doDescribeTable(this.autoKeyInfo);
/*      */ 
/* 5627 */       String str = this.autoKeyInfo.getNewSql();
/* 5628 */       this.numberOfBindPositions = paramArrayOfInt.length;
/*      */ 
/* 5631 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5633 */       processDmlReturningBind();
/*      */ 
/* 5635 */       return executeUpdateInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int executeUpdate(String paramString, String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/* 5668 */     cleanUpBeforeExecute();
/* 5669 */     if ((paramArrayOfString == null) || (paramArrayOfString.length == 0))
/*      */     {
/* 5671 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5672 */       localSQLException.fillInStackTrace();
/* 5673 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5676 */     this.autoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfString);
/* 5677 */     if (!this.autoKeyInfo.isInsertSqlStmt())
/*      */     {
/* 5679 */       this.autoKeyInfo = null;
/* 5680 */       return executeUpdate(paramString);
/*      */     }
/*      */ 
/* 5683 */     synchronized (this.connection) {
/* 5684 */       this.isAutoGeneratedKey = true;
/*      */ 
/* 5687 */       this.connection.doDescribeTable(this.autoKeyInfo);
/*      */ 
/* 5689 */       String str = this.autoKeyInfo.getNewSql();
/* 5690 */       this.numberOfBindPositions = paramArrayOfString.length;
/*      */ 
/* 5693 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5695 */       processDmlReturningBind();
/*      */ 
/* 5697 */       return executeUpdateInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean execute(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5749 */     cleanUpBeforeExecute();
/* 5750 */     this.autoKeyInfo = new AutoKeyInfo(paramString);
/* 5751 */     if ((paramInt == 2) || (!this.autoKeyInfo.isInsertSqlStmt()))
/*      */     {
/* 5754 */       this.autoKeyInfo = null;
/* 5755 */       return execute(paramString);
/*      */     }
/*      */ 
/* 5758 */     if (paramInt != 1)
/*      */     {
/* 5760 */       this.autoKeyInfo = null;
/*      */ 
/* 5762 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5763 */       localSQLException.fillInStackTrace();
/* 5764 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5768 */     synchronized (this.connection) {
/* 5769 */       this.isAutoGeneratedKey = true;
/* 5770 */       String str = this.autoKeyInfo.getNewSql();
/* 5771 */       this.numberOfBindPositions = 1;
/*      */ 
/* 5774 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5776 */       processDmlReturningBind();
/*      */ 
/* 5778 */       return executeInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean execute(String paramString, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 5829 */     cleanUpBeforeExecute();
/* 5830 */     if ((paramArrayOfInt == null) || (paramArrayOfInt.length == 0))
/*      */     {
/* 5832 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5833 */       localSQLException.fillInStackTrace();
/* 5834 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5837 */     this.autoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfInt);
/* 5838 */     if (!this.autoKeyInfo.isInsertSqlStmt())
/*      */     {
/* 5840 */       this.autoKeyInfo = null;
/* 5841 */       return execute(paramString);
/*      */     }
/*      */ 
/* 5844 */     synchronized (this.connection) {
/* 5845 */       this.isAutoGeneratedKey = true;
/*      */ 
/* 5848 */       this.connection.doDescribeTable(this.autoKeyInfo);
/*      */ 
/* 5850 */       String str = this.autoKeyInfo.getNewSql();
/* 5851 */       this.numberOfBindPositions = paramArrayOfInt.length;
/*      */ 
/* 5854 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5856 */       processDmlReturningBind();
/*      */ 
/* 5858 */       return executeInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean execute(String paramString, String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/* 5910 */     cleanUpBeforeExecute();
/* 5911 */     if ((paramArrayOfString == null) || (paramArrayOfString.length == 0))
/*      */     {
/* 5913 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 5914 */       localSQLException.fillInStackTrace();
/* 5915 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5918 */     this.autoKeyInfo = new AutoKeyInfo(paramString, paramArrayOfString);
/* 5919 */     if (!this.autoKeyInfo.isInsertSqlStmt())
/*      */     {
/* 5921 */       this.autoKeyInfo = null;
/* 5922 */       return execute(paramString);
/*      */     }
/*      */ 
/* 5925 */     synchronized (this.connection) {
/* 5926 */       this.isAutoGeneratedKey = true;
/*      */ 
/* 5929 */       this.connection.doDescribeTable(this.autoKeyInfo);
/*      */ 
/* 5931 */       String str = this.autoKeyInfo.getNewSql();
/* 5932 */       this.numberOfBindPositions = paramArrayOfString.length;
/*      */ 
/* 5935 */       autoKeyRegisterReturnParams();
/*      */ 
/* 5937 */       processDmlReturningBind();
/*      */ 
/* 5939 */       return executeInternal(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getResultSetHoldability()
/*      */     throws SQLException
/*      */   {
/* 5964 */     ensureOpen();
/* 5965 */     return 1;
/*      */   }
/*      */ 
/*      */   public int getcacheState()
/*      */   {
/* 5972 */     return this.cacheState;
/*      */   }
/*      */ 
/*      */   public int getstatementType()
/*      */   {
/* 5979 */     return this.statementType;
/*      */   }
/*      */ 
/*      */   public boolean getserverCursor()
/*      */   {
/* 5986 */     return this.serverCursor;
/*      */   }
/*      */ 
/*      */   void initializeIndicatorSubRange()
/*      */   {
/* 5994 */     this.bindIndicatorSubRange = 0;
/*      */   }
/*      */ 
/*      */   private void autoKeyRegisterReturnParams()
/*      */     throws SQLException
/*      */   {
/* 6004 */     if (this.currentResultSet != null) this.currentResultSet.close();
/*      */ 
/* 6007 */     initializeIndicatorSubRange();
/*      */ 
/* 6009 */     int i = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
/*      */ 
/* 6015 */     int j = i + 2 * this.numberOfBindPositions;
/*      */ 
/* 6019 */     this.bindIndicators = new short[j];
/*      */ 
/* 6021 */     int k = this.bindIndicatorSubRange;
/*      */ 
/* 6023 */     this.bindIndicators[(k + 0)] = ((short)this.numberOfBindPositions);
/*      */ 
/* 6027 */     this.bindIndicators[(k + 1)] = 0;
/*      */ 
/* 6031 */     this.bindIndicators[(k + 2)] = 1;
/*      */ 
/* 6035 */     this.bindIndicators[(k + 3)] = 0;
/*      */ 
/* 6039 */     this.bindIndicators[(k + 4)] = 1;
/*      */ 
/* 6043 */     k += 5;
/*      */ 
/* 6046 */     short[] arrayOfShort = this.autoKeyInfo.tableFormOfUses;
/* 6047 */     int[] arrayOfInt = this.autoKeyInfo.columnIndexes;
/*      */ 
/* 6049 */     for (int m = 0; m < this.numberOfBindPositions; m++)
/*      */     {
/* 6051 */       this.bindIndicators[(k + 0)] = 994;
/*      */ 
/* 6055 */       short s = this.connection.defaultnchar ? 2 : 1;
/*      */ 
/* 6058 */       if ((arrayOfShort != null) && (arrayOfInt != null))
/*      */       {
/* 6060 */         if (arrayOfShort[(arrayOfInt[m] - 1)] == 2)
/*      */         {
/* 6063 */           s = 2;
/* 6064 */           this.bindIndicators[(k + 9)] = s;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 6070 */       k += 10;
/*      */ 
/* 6073 */       checkTypeForAutoKey(this.autoKeyInfo.returnTypes[m]);
/*      */ 
/* 6075 */       String str = null;
/* 6076 */       if (this.autoKeyInfo.returnTypes[m] == 111) {
/* 6077 */         str = this.autoKeyInfo.tableTypeNames[(arrayOfInt[m] - 1)];
/*      */       }
/*      */ 
/* 6080 */       registerReturnParameterInternal(m, this.autoKeyInfo.returnTypes[m], this.autoKeyInfo.returnTypes[m], -1, s, str);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final void cleanUpBeforeExecute()
/*      */     throws SQLException
/*      */   {
/* 6099 */     if ((this.currentResultSet != null) && (this.isCloseOnCompletion))
/*      */     {
/* 6101 */       this.currentResultSet.close();
/*      */ 
/* 6105 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 6106 */       localSQLException.fillInStackTrace();
/* 6107 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6111 */     this.isAutoGeneratedKey = false;
/* 6112 */     this.numberOfBindPositions = 0;
/* 6113 */     this.bindIndicators = null;
/* 6114 */     this.returnParamMeta = null;
/*      */ 
/* 6116 */     if (this.executeDoneForDefines)
/*      */     {
/* 6118 */       clearDefines();
/*      */     }
/*      */     else
/*      */     {
/* 6122 */       this.executeDoneForDefines = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   final void checkTypeForAutoKey(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6131 */     if (paramInt == 109)
/*      */     {
/* 6133 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 5);
/* 6134 */       localSQLException.fillInStackTrace();
/* 6135 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void moveAllTempLobsToFree()
/*      */   {
/* 6156 */     if (this.oldTempClobsToFree != null)
/*      */     {
/* 6158 */       if (this.tempClobsToFree == null)
/* 6159 */         this.tempClobsToFree = this.oldTempClobsToFree;
/*      */       else {
/* 6161 */         this.tempClobsToFree.add(this.oldTempClobsToFree);
/*      */       }
/* 6163 */       this.oldTempClobsToFree = null;
/*      */     }
/*      */ 
/* 6166 */     if (this.oldTempBlobsToFree != null)
/*      */     {
/* 6168 */       if (this.tempBlobsToFree == null)
/* 6169 */         this.tempBlobsToFree = this.oldTempBlobsToFree;
/*      */       else {
/* 6171 */         this.tempBlobsToFree.add(this.oldTempBlobsToFree);
/*      */       }
/* 6173 */       this.oldTempBlobsToFree = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void moveTempLobsToFree(CLOB paramCLOB)
/*      */   {
/*      */     int i;
/* 6183 */     if ((this.oldTempClobsToFree != null) && 
/* 6184 */       ((i = this.oldTempClobsToFree.indexOf(paramCLOB)) != -1))
/*      */     {
/* 6186 */       addToTempLobsToFree(paramCLOB);
/* 6187 */       this.oldTempClobsToFree.remove(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   void moveTempLobsToFree(BLOB paramBLOB)
/*      */   {
/*      */     int i;
/* 6197 */     if ((this.oldTempBlobsToFree != null) && 
/* 6198 */       ((i = this.oldTempBlobsToFree.indexOf(paramBLOB)) != -1))
/*      */     {
/* 6200 */       addToTempLobsToFree(paramBLOB);
/* 6201 */       this.oldTempBlobsToFree.remove(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   void addToTempLobsToFree(CLOB paramCLOB)
/*      */   {
/* 6210 */     if (this.tempClobsToFree == null)
/* 6211 */       this.tempClobsToFree = new ArrayList();
/* 6212 */     this.tempClobsToFree.add(paramCLOB);
/*      */   }
/*      */ 
/*      */   void addToTempLobsToFree(BLOB paramBLOB)
/*      */   {
/* 6219 */     if (this.tempBlobsToFree == null)
/* 6220 */       this.tempBlobsToFree = new ArrayList();
/* 6221 */     this.tempBlobsToFree.add(paramBLOB);
/*      */   }
/*      */ 
/*      */   void addToOldTempLobsToFree(CLOB paramCLOB)
/*      */   {
/* 6228 */     if (this.oldTempClobsToFree == null)
/* 6229 */       this.oldTempClobsToFree = new ArrayList();
/* 6230 */     this.oldTempClobsToFree.add(paramCLOB);
/*      */   }
/*      */ 
/*      */   void addToOldTempLobsToFree(BLOB paramBLOB)
/*      */   {
/* 6237 */     if (this.oldTempBlobsToFree == null)
/* 6238 */       this.oldTempBlobsToFree = new ArrayList();
/* 6239 */     this.oldTempBlobsToFree.add(paramBLOB);
/*      */   }
/*      */ 
/*      */   void cleanAllTempLobs()
/*      */   {
/* 6246 */     cleanTempClobs(this.tempClobsToFree);
/* 6247 */     this.tempClobsToFree = null;
/* 6248 */     cleanTempBlobs(this.tempBlobsToFree);
/* 6249 */     this.tempBlobsToFree = null;
/* 6250 */     cleanTempClobs(this.oldTempClobsToFree);
/* 6251 */     this.oldTempClobsToFree = null;
/* 6252 */     cleanTempBlobs(this.oldTempBlobsToFree);
/* 6253 */     this.oldTempBlobsToFree = null;
/*      */   }
/*      */ 
/*      */   void cleanOldTempLobs()
/*      */   {
/* 6260 */     cleanTempClobs(this.oldTempClobsToFree);
/* 6261 */     cleanTempBlobs(this.oldTempBlobsToFree);
/* 6262 */     this.oldTempClobsToFree = this.tempClobsToFree;
/* 6263 */     this.tempClobsToFree = null;
/* 6264 */     this.oldTempBlobsToFree = this.tempBlobsToFree;
/* 6265 */     this.tempBlobsToFree = null;
/*      */   }
/*      */ 
/*      */   void cleanTempClobs(ArrayList paramArrayList)
/*      */   {
/* 6272 */     if (paramArrayList != null)
/*      */     {
/* 6274 */       Iterator localIterator = paramArrayList.iterator();
/*      */ 
/* 6276 */       while (localIterator.hasNext())
/*      */       {
/*      */         try
/*      */         {
/* 6280 */           ((CLOB)localIterator.next()).freeTemporary();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void cleanTempBlobs(ArrayList paramArrayList)
/*      */   {
/* 6295 */     if (paramArrayList != null)
/*      */     {
/* 6297 */       Iterator localIterator = paramArrayList.iterator();
/*      */ 
/* 6299 */       while (localIterator.hasNext())
/*      */       {
/*      */         try
/*      */         {
/* 6303 */           ((BLOB)localIterator.next()).freeTemporary();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   TimeZone getDefaultTimeZone()
/*      */     throws SQLException
/*      */   {
/* 6323 */     return getDefaultTimeZone(false);
/*      */   }
/*      */ 
/*      */   TimeZone getDefaultTimeZone(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 6329 */     if (this.defaultTimeZone == null)
/*      */     {
/*      */       try {
/* 6332 */         this.defaultTimeZone = this.connection.getDefaultTimeZone();
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/* 6337 */       if (this.defaultTimeZone == null) {
/* 6338 */         this.defaultTimeZone = TimeZone.getDefault();
/*      */       }
/*      */     }
/* 6341 */     return this.defaultTimeZone;
/*      */   }
/*      */ 
/*      */   public void setDatabaseChangeRegistration(DatabaseChangeRegistration paramDatabaseChangeRegistration)
/*      */     throws SQLException
/*      */   {
/* 6352 */     this.registration = ((NTFDCNRegistration)paramDatabaseChangeRegistration);
/*      */   }
/*      */ 
/*      */   public String[] getRegisteredTableNames() throws SQLException
/*      */   {
/* 6357 */     return this.dcnTableName;
/*      */   }
/*      */ 
/*      */   public long getRegisteredQueryId() throws SQLException {
/* 6361 */     return this.dcnQueryId;
/*      */   }
/*      */ 
/*      */   Calendar getDefaultCalendar()
/*      */     throws SQLException
/*      */   {
/* 6369 */     if (this.defaultCalendar == null)
/*      */     {
/* 6371 */       this.defaultCalendar = Calendar.getInstance(getDefaultTimeZone(), Locale.US);
/*      */     }
/*      */ 
/* 6374 */     return this.defaultCalendar;
/*      */   }
/*      */ 
/*      */   void releaseBuffers()
/*      */   {
/* 6380 */     this.rowData.free();
/* 6381 */     if ((this.bindData != null) && (this.bindData != this.rowData))
/* 6382 */       this.bindData.free();
/*      */   }
/*      */ 
/*      */   public boolean isClosed() throws SQLException
/*      */   {
/* 6387 */     return this.closed;
/*      */   }
/*      */ 
/*      */   public boolean isPoolable()
/*      */     throws SQLException
/*      */   {
/* 6404 */     if (this.closed)
/*      */     {
/* 6406 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 6407 */       localSQLException.fillInStackTrace();
/* 6408 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6411 */     return this.cacheState != 3;
/*      */   }
/*      */ 
/*      */   public void setPoolable(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 6432 */     if (this.closed)
/*      */     {
/* 6434 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 6435 */       localSQLException.fillInStackTrace();
/* 6436 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6439 */     if (paramBoolean) {
/* 6440 */       this.cacheState = 1;
/*      */     }
/*      */     else
/* 6443 */       this.cacheState = 3;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 6464 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 6466 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 6467 */     localSQLException.fillInStackTrace();
/* 6468 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 6490 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 6492 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 6493 */     localSQLException.fillInStackTrace();
/* 6494 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   RowId getPrependedRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6508 */     assert (this.isRowidPrepended) : "no rowid";
/* 6509 */     return this.accessors[0].getROWID(paramInt - this.indexOfFirstRow);
/*      */   }
/*      */ 
/*      */   OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 6516 */     this.lastIndex = paramInt2;
/* 6517 */     if (this.streamList != null) closeUsedStreams(paramInt2);
/* 6518 */     return this.accessors[(paramInt2 - 1)].getAuthorizationIndicator(paramInt1 - this.indexOfFirstRow);
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 6533 */     return this.connection;
/*      */   }
/*      */ 
/*      */   Calendar getGMTCalendar()
/*      */   {
/* 6544 */     if (this.gmtCalendar == null)
/*      */     {
/* 6546 */       this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
/*      */     }
/*      */ 
/* 6550 */     return this.gmtCalendar;
/*      */   }
/*      */ 
/*      */   void extractNioDefineBuffers(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   void processLobPrefetchMetaData(Object[] paramArrayOfObject)
/*      */   {
/*      */   }
/*      */ 
/*      */   void internalClose()
/*      */     throws SQLException
/*      */   {
/* 6575 */     this.closed = true;
/* 6576 */     if (this.currentResultSet != null) {
/* 6577 */       this.currentResultSet.closed = true;
/*      */     }
/* 6579 */     cleanupDefines();
/* 6580 */     this.bindBytes = null;
/* 6581 */     this.bindChars = null;
/* 6582 */     this.bindIndicators = null;
/*      */ 
/* 6584 */     this.outBindAccessors = null;
/* 6585 */     this.parameterStream = ((InputStream[][])null);
/* 6586 */     this.userStream = ((Object[][])null);
/*      */ 
/* 6588 */     this.ibtBindBytes = null;
/* 6589 */     this.ibtBindChars = null;
/* 6590 */     this.ibtBindIndicators = null;
/*      */ 
/* 6592 */     this.lobPrefetchMetaData = null;
/* 6593 */     this.tmpByteArray = null;
/*      */ 
/* 6595 */     this.definedColumnType = null;
/* 6596 */     this.definedColumnSize = null;
/* 6597 */     this.definedColumnFormOfUse = null;
/*      */ 
/* 6601 */     if (this.wrapper != null)
/*      */     {
/* 6603 */       this.wrapper.close();
/*      */     }
/*      */   }
/*      */ 
/*      */   void calculateCheckSum()
/*      */     throws SQLException
/*      */   {
/* 6611 */     if (!this.connection.checksumMode.needToCalculateFetchChecksum()) {
/* 6612 */       return;
/*      */     }
/* 6614 */     this.localCheckSum = this.checkSum;
/* 6615 */     if ((this.accessors != null) && (!this.isDmlReturning)) {
/* 6616 */       accessorChecksum(this.accessors);
/*      */     }
/* 6618 */     if (this.outBindAccessors != null) {
/* 6619 */       accessorChecksum(this.outBindAccessors);
/*      */     }
/* 6621 */     if ((this.accessors != null) && (this.returnParamsFetched) && (this.isDmlReturning)) {
/* 6622 */       accessorChecksum(this.accessors);
/*      */     }
/* 6624 */     this.localCheckSum = CRC64.updateChecksum(this.localCheckSum, this.validRows);
/* 6625 */     this.checkSum = this.localCheckSum;
/* 6626 */     this.localCheckSum = 0L;
/*      */   }
/*      */ 
/*      */   void accessorChecksum(Accessor[] paramArrayOfAccessor) throws SQLException
/*      */   {
/* 6631 */     int i = 0;
/* 6632 */     int j = 0;
/*      */ 
/* 6635 */     for (Accessor localAccessor : paramArrayOfAccessor)
/*      */     {
/* 6637 */       if (localAccessor != null)
/*      */       {
/* 6639 */         switch (localAccessor.internalType)
/*      */         {
/*      */         case 112:
/*      */         case 113:
/*      */         case 114:
/* 6644 */           if (i == 0)
/* 6645 */             j = 1; break;
/*      */         case 8:
/*      */         case 24:
/* 6652 */           j = 0;
/*      */ 
/* 6654 */           break;
/*      */         default:
/* 6657 */           j = 0;
/*      */ 
/* 6661 */           i++;
/* 6662 */           for (int n = 0; n < this.validRows; n++)
/*      */           {
/* 6664 */             if (localAccessor.rowSpaceIndicator != null)
/* 6665 */               this.localCheckSum = localAccessor.updateChecksum(this.localCheckSum, n);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 6670 */     if (j != 0)
/* 6671 */       this.checkSumComputationFailure = true;
/*      */   }
/*      */ 
/*      */   public long getChecksum()
/*      */     throws SQLException
/*      */   {
/* 6684 */     if (this.checkSumComputationFailure)
/*      */     {
/* 6686 */       SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 6687 */       localSQLException.fillInStackTrace();
/* 6688 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6691 */     return this.checkSum;
/*      */   }
/*      */ 
/*      */   public void registerBindChecksumListener(OracleStatement.BindChecksumListener paramBindChecksumListener)
/*      */     throws SQLException
/*      */   {
/* 6698 */     this.bindChecksumListener = paramBindChecksumListener;
/*      */   }
/*      */ 
/*      */   public void closeOnCompletion()
/*      */     throws SQLException
/*      */   {
/* 6711 */     this.isCloseOnCompletion = true;
/*      */   }
/*      */ 
/*      */   public boolean isCloseOnCompletion()
/*      */     throws SQLException
/*      */   {
/* 6723 */     return this.isCloseOnCompletion;
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 6731 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 6736 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleStatement
 * JD-Core Version:    0.6.2
 */